/*
 * mcu.c
 *
 *  Created on: Nov 23, 2011
 *      Author: B31117
 */

#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */
#include "mcu.h"

 void SystemClockInit()
{

    /*lint -save  -e923 Disable MISRA rule (11.3) checking. */
    if (*(unsigned char*far)0x03FFU != 0xFFU)
    { /* Test if the device trim value is stored on the specified address */
        MCGTRM = *(unsigned char*far)0x03FFU; /* Initialize MCGTRM register from a non volatile memory */
        MCGSC = *(unsigned char*far)0x03FEU; /* Initialize MCGSC register from a non volatile memory */
    }
    /*lint -restore Enable MISRA rule (11.3) checking. */
    /* MCGC2: BDIV=0,RANGE=1,HGO=1,LP=0,EREFS=1,ERCLKEN=1,EREFSTEN=0 */
    MCGC2 = 0x36U; /* Set MCGC2 register */
    while(MCGSC_OSCINIT == 0U)
    { /* Wait until external reference is stable */
    }
    /* MCGC3: DIV32=1 */
    MCGC3 |= (unsigned char)0x10U;
    /* MCGC1: CLKS=2,RDIV=3,IREFS=0,IRCLKEN=0,IREFSTEN=0 */
    MCGC1 = 0x98U; /* Set MCGC1 register */
    while(MCGSC_IREFST != 0U)
    { /* Wait until external reference is selected */
    }
    /* MCGC3: LOLIE=0,PLLS=0,CME=0,DIV32=1,VDIV=8 */
    MCGC3 = 0x18U; /* Set MCGC3 register */
    /* MCGC4: DMX32=0,DRST_DRS=0 */
    MCGC4 = 0x00U; /* Set MCGC4 register */
    while((MCGSC & 0x0CU) != 0x08U)
    { /* Wait until external clock is selected as a bus clock reference */
    }
    /* MCGC2: BDIV=0,RANGE=1,HGO=1,LP=1,EREFS=1,ERCLKEN=1,EREFSTEN=0 */
    MCGC2 = 0x3EU; /* Set MCGC2 register */
    /* MCGC1: CLKS=2,RDIV=3,IREFS=0,IRCLKEN=0,IREFSTEN=0 */
    MCGC1 = 0x98U; /* Set MCGC1 register */
    /* MCGC3: LOLIE=0,PLLS=0,CME=0,DIV32=0,VDIV=8 */
    MCGC3 = 0x08U; /* Set MCGC3 register */
    /* MCGC3: LOLIE=0,PLLS=1,CME=0,DIV32=0,VDIV=8 */
    MCGC3 = 0x48U; /* Set MCGC3 register */
    while(MCGSC_PLLST == 0U)
    { /* Wait until PLL is selected */
    }
    /* MCGC2: LP=0 */
    MCGC2 &= (unsigned char)~(unsigned char)0x08U;
    while(MCGSC_LOCK == 0U)
    { /* Wait until PLL is locked */
    }
    /* MCGC1: CLKS=0,RDIV=3,IREFS=0,IRCLKEN=0,IREFSTEN=0 */
    MCGC1 = 0x18U; /* Set MCGC1 register */
    while((MCGSC & 0x0CU) != 0x0CU)
    { /* Wait until PLL clock is selected as a bus clock reference */
    }
    SOPT1 &= ~ SOPT1_COPT_MASK;
}
