/******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2012 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
****************************************************************************//*!
*
* @file    uart_init.c
*
* @author  b06050
*
* @version 1.0.2.0
*
* @date    Aug-3-2012
*
* @brief   FreeMASTER driver private initializations, used internally by the
*          driver
*
*******************************************************************************/
#include "uart_init.h"

void uart_init(void)
{
    linflex6 =(struct LINFLEX_tag *)&LINFLEX_6;

    // configure linflex1
    linflex6->LINCR1.B.SLEEP = 0x0;     // disable sleep mode
    linflex6->LINCR1.B.INIT  = 0x1;     // init mode
    linflex6->UARTCR.B.UART  = 0x1;     // UART mode

    linflex6->UARTCR.B.TDFL = 0x0;      // bufer size = 1
    linflex6->UARTCR.B.RDFL = 0x0;      // bufer size = 1
    linflex6->UARTCR.B.RXEN = 0x1;      // reciever enable
    linflex6->UARTCR.B.TXEN = 0x1;      // transmiter enable
    linflex6->UARTCR.B.OP   = 0x1;      // parity is even
    linflex6->UARTCR.B.PCE  = 0x0;      // parity control disable
    linflex6->UARTCR.B.WL   = 0x1;      // word length 8-bit data + parity bit

    linflex6->LINIBRR.B.DIV_M = 208;    // Baud rate = 19200, in case fipg_clock_lin = 64 MHz
    linflex6->LINFBRR.B.DIV_F = 5;      // Baud rate = 19200, in case fipg_clock_lin = 64 MHz

    linflex6->LINIER.B.DRIE  = 0x0;     // data reception complete interrupt
    linflex6->LINIER.B.DTIE  = 0x0;     // data transmition complete interrupt
    linflex6->LINIER.B.DBFIE = 0x0;     // data buffer full interrupt
    linflex6->LINIER.B.DBEIE = 0x0;     // data buffer empty interrupt

    linflex6->LINCR1.B.INIT = 0x0;      // normal mode
}