/*******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2012 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
****************************************************************************//*!
*
* @file     MPC5606B_DSPI_LLD.c
*
* @author   b06050
*
* @version  1.0.3.0
*
* @date     Aug-3-2012
*
* @brief    DSPI low level driver module for MPC5606B
*
********************************************************************************
*
* This file includes basic transmission functions of MPC5606B DSPI module.
*
*******************************************************************************/
#include "MPC5606B_DSPI_LLD.h"

/*******************************************************************************
* DSPI functions
******************************************************************************/

/***************************************************************************//*!
@brief          DSPI byte transmission

@param[in]      *ptr        - DSPI configuration structure pointer
                u8DataOut   - 8-bit data to be transmitted

@param[out]     *ptDataIn   - 16-bit input data store variable pointer

@return         bool_t      - function status

@details        The function transmits 8-bit DSPI data and reads 8-bit data from
                external device.
*******************************************************************************/
bool_t dspiSendByte(DSPI_SET_T *ptr, uint8_t u8DataOut, uint8_t *ptDataIn)
{
    static  uint32_t data_out;

    // data preparation - concatenate transfer command and data into 32-bit
    // transfer register
    data_out = (uint32_t)u8DataOut;
    data_out |= ptr->txCmd;

    ioctl(ptr->dspiBaseAdr, DSPI_WRITE_DATA, data_out);
    *ptDataIn = (uint8_t)(ioctl(ptr->dspiBaseAdr, DSPI_READ_DATA, NULL));

    return (1);
}


/***************************************************************************//*!
@brief          DSPI word transmission

@param[in]      *ptr        - DSPI configuration structure pointer
                u16DataOut  - 16-bit data to be transmitted

@param[out]     *ptDataIn   - 16-bit input data store variable pointer

@return         bool_t      - function status

@details        The function transmit 16-bits DSPI data and reads 16-bit data
                from external device.
*******************************************************************************/
bool_t dspiSendWord(DSPI_SET_T *ptr, uint16_t u16DataOut, uint16_t *ptDataIn)
{
    static  uint32_t data_out;

    // data preparation - concatenate transfer command and data into 32-bit
    // transfer register
    data_out = (uint32_t)u16DataOut;
    data_out |= ptr->txCmd;

    ioctl(ptr->dspiBaseAdr, DSPI_WRITE_DATA, data_out);
    *ptDataIn = (uint16_t)(ioctl(ptr->dspiBaseAdr, DSPI_READ_DATA, NULL));

    return (1);
}