/******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2012 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
***************************************************************************//*!
*
* @file       MPC5606B_DSPI_LLD.h
*
* @author     b06050
*
* @version    1.0.2.0
*
* @date       Aug-3-2012
*
* @brief      DSPI low level driver module for MPC5606B.
*
*******************************************************************************
*
* This file includes MACRO definitions of MPC5606B DSPI peripheral module.
*
******************************************************************************/
#ifndef __MPC5606B_DSPI_LLD_H
#define __MPC5606B_DSPI_LLD_H

#include "typedefs.h"
#include "MPC5606B_LLD_qs.h"

#ifdef __cplusplus
extern "C" {
#endif

#define DSPI0_BASE                                      0xFFF90000
#define DSPI0_CTAR0_BASE                                0xFFF9000C
#define DSPI0_CTAR1_BASE                                0xFFF90010
#define DSPI0_CTAR2_BASE                                0xFFF90014
#define DSPI0_CTAR3_BASE                                0xFFF90018
#define DSPI0_CTAR4_BASE                                0xFFF9001C
#define DSPI0_CTAR5_BASE                                0xFFF90020
#define DSPI1_BASE                                      0xFFF94000
#define DSPI1_CTAR0_BASE                                0xFFF9400C
#define DSPI1_CTAR1_BASE                                0xFFF94010
#define DSPI1_CTAR2_BASE                                0xFFF94014
#define DSPI1_CTAR3_BASE                                0xFFF94018
#define DSPI1_CTAR4_BASE                                0xFFF9401C
#define DSPI1_CTAR5_BASE                                0xFFF94020
#define DSPI2_BASE                                      0xFFF98000
#define DSPI2_CTAR0_BASE                                0xFFF9800C
#define DSPI2_CTAR1_BASE                                0xFFF98010
#define DSPI2_CTAR2_BASE                                0xFFF98014
#define DSPI2_CTAR3_BASE                                0xFFF98018
#define DSPI2_CTAR4_BASE                                0xFFF9801C
#define DSPI2_CTAR5_BASE                                0xFFF98020
#define DSPI3_BASE                                      0xFFF9C000
#define DSPI3_CTAR0_BASE                                0xFFF9C00C
#define DSPI3_CTAR1_BASE                                0xFFF9C010
#define DSPI3_CTAR2_BASE                                0xFFF9C014
#define DSPI3_CTAR3_BASE                                0xFFF9C018
#define DSPI3_CTAR4_BASE                                0xFFF9C01C
#define DSPI3_CTAR5_BASE                                0xFFF9C020
#define DSPI4_BASE                                      0xFFFA0000
#define DSPI4_CTAR0_BASE                                0xFFFA000C
#define DSPI4_CTAR1_BASE                                0xFFFA0010
#define DSPI4_CTAR2_BASE                                0xFFFA0014
#define DSPI4_CTAR3_BASE                                0xFFFA0018
#define DSPI4_CTAR4_BASE                                0xFFFA001C
#define DSPI4_CTAR5_BASE                                0xFFFA0020

/******************************************************************************
* DSPI ioctl commands definitions
******************************************************************************/
/***************************************************************************//*!
*
* @brief                DSPI peripheral module disable/enable control.
*
* @param                DSPI_ENABLE
* @param                DSPI_DISABLE
*
* @return               NULL
*
* @details              The #DSPI_DEVICE ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(DSPI0_BASE,DSPI_DEVICE, DSPI_ENABLE);
* \endcode
*
******************************************************************************/
#define DSPI_DEVICE

/***************************************************************************//*!
*
* @brief                Master/slave mode select.
*
* @param                DSPI_SLAVE
* @param                DSPI_MASTER
*
* @return               NULL
*
* @details              The #DSPI_SET_MODE ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(DSPI0_BASE,DSPI_SET_MODE, DSPI_SLAVE);
* \endcode
*
******************************************************************************/
#define DSPI_SET_MODE

/***************************************************************************//*!
*
* @brief                Continuous serial communication clock (SCK) enable/disable.
*
* @param                DSPI_DISABLE
* @param                DSPI_ENABLE
*
* @return               NULL
*
* @details              The #DSPI_CONTINUOUS_SCK ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(DSPI0_BASE,DSPI_CONTINUOUS_SCK, DSPI_DISABLE);
* \endcode
*
******************************************************************************/
#define DSPI_CONTINUOUS_SCK

/***************************************************************************//*!
*
* @brief                DSPI peripheral module configuration.
*
* @param                DSPI_SPI
*
* @return               NULL
*
* @details              The #DSPI_CONFIGURATION ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(DSPI0_BASE,DSPI_CONFIGURATION, DSPI_SPI);
* \endcode
*
******************************************************************************/
#define DSPI_CONFIGURATION

/***************************************************************************//*!
*
* @brief                DSPI freeze transfers in debug mode.
*
* @param                DSPI_DISABLE
* @param                DSPI_ENABLE
*
* @return               NULL
*
* @details              The #DSPI_FREEZE_IN_DEBUG ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(DSPI0_BASE,DSPI_FREEZE_IN_DEBUG, DSPI_DISABLE);
* \endcode
*
******************************************************************************/
#define DSPI_FREEZE_IN_DEBUG

/***************************************************************************//*!
*
* @brief                Modified timing format enable.
*
* @param                DSPI_DISABLE
* @param                DSPI_ENABLE
*
* @return               NULL
*
* @details              The #DSPI_MODIFIED_TIMING_FORMAT ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(DSPI0_BASE,DSPI_MODIFIED_TIMING_FORMAT, DSPI_DISABLE);
* \endcode
*
******************************************************************************/
#define DSPI_MODIFIED_TIMING_FORMAT

/***************************************************************************//*!
*
* @brief                Peripheral chip select strobe enable.
*
* @param                DSPI_DISABLE
* @param                DSPI_ENABLE
*
* @return               NULL
*
* @details              The #DSPI_CS5_STROBE ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(DSPI0_BASE,DSPI_CS5_STROBE, DSPI_DISABLE);
* \endcode
*
******************************************************************************/
#define DSPI_CS5_STROBE

/***************************************************************************//*!
*
* @brief                Receive FIFO overflow overwrite control.
*
* @param                DSPI_IGNORE_DATA
* @param                DSPI_OVERWRITE_DATA
*
* @return               NULL
*
* @details              The #DSPI_RX_FIFO_OVERFLOW_MODE ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(DSPI0_BASE,DSPI_RX_FIFO_OVERFLOW_MODE, DSPI_IGNORE_DATA);
* \endcode
*
******************************************************************************/
#define DSPI_RX_FIFO_OVERFLOW_MODE

/***************************************************************************//*!
*
* @brief                Peripheral chip select CS0 inactive state.
*
* @param                DSPI_LOW
* @param                DSPI_HIGH
*
* @return               NULL
*
* @details              The #DSPI_SET_INACTIVE_STATE_CS0 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(DSPI0_BASE,DSPI_SET_INACTIVE_STATE_CS0, DSPI_LOW);
* \endcode
*
******************************************************************************/
#define DSPI_SET_INACTIVE_STATE_CS0

/***************************************************************************//*!
*
* @brief                Peripheral chip select CS1 inactive state.
*
* @param                DSPI_LOW
* @param                DSPI_HIGH
*
* @return               NULL
*
* @details              The #DSPI_SET_INACTIVE_STATE_CS1 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(DSPI0_BASE,DSPI_SET_INACTIVE_STATE_CS1, DSPI_LOW);
* \endcode
*
******************************************************************************/
#define DSPI_SET_INACTIVE_STATE_CS1

/***************************************************************************//*!
*
* @brief                Peripheral chip select CS2 inactive state.
*
* @param                DSPI_LOW
* @param                DSPI_HIGH
*
* @return               NULL
*
* @details              The #DSPI_SET_INACTIVE_STATE_CS2 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(DSPI0_BASE,DSPI_SET_INACTIVE_STATE_CS2, DSPI_LOW);
* \endcode
*
******************************************************************************/
#define DSPI_SET_INACTIVE_STATE_CS2

/***************************************************************************//*!
*
* @brief                Peripheral chip select CS3 inactive state.
*
* @param                DSPI_LOW
* @param                DSPI_HIGH
*
* @return               NULL
*
* @details              The #DSPI_SET_INACTIVE_STATE_CS3 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(DSPI0_BASE,DSPI_SET_INACTIVE_STATE_CS3, DSPI_LOW);
* \endcode
*
******************************************************************************/
#define DSPI_SET_INACTIVE_STATE_CS3

/***************************************************************************//*!
*
* @brief                Peripheral chip select CS4 inactive state.
*
* @param                DSPI_LOW
* @param                DSPI_HIGH
*
* @return               NULL
*
* @details              The #DSPI_SET_INACTIVE_STATE_CS4 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(DSPI0_BASE,DSPI_SET_INACTIVE_STATE_CS4, DSPI_LOW);
* \endcode
*
******************************************************************************/
#define DSPI_SET_INACTIVE_STATE_CS4

/***************************************************************************//*!
*
* @brief                Peripheral chip select CS5 inactive state.
*
* @param                DSPI_LOW
* @param                DSPI_HIGH
*
* @return               NULL
*
* @details              The #DSPI_SET_INACTIVE_STATE_CS5 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(DSPI0_BASE,DSPI_SET_INACTIVE_STATE_CS5, DSPI_LOW);
* \endcode
*
******************************************************************************/
#define DSPI_SET_INACTIVE_STATE_CS5

/***************************************************************************//*!
*
* @brief                Peripheral chip select CS6 inactive state.
*
* @param                DSPI_LOW
* @param                DSPI_HIGH
*
* @return               NULL
*
* @details              The #DSPI_SET_INACTIVE_STATE_CS6 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(DSPI0_BASE,DSPI_SET_INACTIVE_STATE_CS6, DSPI_LOW);
* \endcode
*
******************************************************************************/
#define DSPI_SET_INACTIVE_STATE_CS6

/***************************************************************************//*!
*
* @brief                Peripheral chip select CS7 inactive state.
*
* @param                DSPI_LOW
* @param                DSPI_HIGH
*
* @return               NULL
*
* @details              The #DSPI_SET_INACTIVE_STATE_CS7 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(DSPI0_BASE,DSPI_SET_INACTIVE_STATE_CS7, DSPI_LOW);
* \endcode
*
******************************************************************************/
#define DSPI_SET_INACTIVE_STATE_CS7

/***************************************************************************//*!
*
* @brief                Disable/enable transmit FIFO
*
* @param                DSPI_DISABLE
* @param                DSPI_ENABLE
*
* @return               NULL
*
* @details              The #DSPI_TX_FIFO ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(DSPI0_BASE,DSPI_TX_FIFO, DSPI_DISABLE);
* \endcode
*
******************************************************************************/
#define DSPI_TX_FIFO

/***************************************************************************//*!
*
* @brief                Disable/enable receive FIFO
*
* @param                DSPI_DISABLE
* @param                DSPI_ENABLE
*
* @return               NULL
*
* @details              The #DSPI_RX_FIFO ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(DSPI0_BASE,DSPI_RX_FIFO, DSPI_DISABLE);
* \endcode
*
******************************************************************************/
#define DSPI_RX_FIFO

/***************************************************************************//*!
*
* @brief                Clear transmit FIFO
*
* @param                NULL
*
* @return               NULL
*
* @details              The #DSPI_CLEAR_TX_FIFO ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(DSPI0_BASE,DSPI_CLEAR_TX_FIFO, NULL);
* \endcode
*
******************************************************************************/
#define DSPI_CLEAR_TX_FIFO

/***************************************************************************//*!
*
* @brief                Clear receive FIFO
*
* @param                NULL
*
* @return               NULL
*
* @details              The #DSPI_CLEAR_RX_FIFO ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(DSPI0_BASE,DSPI_CLEAR_RX_FIFO, NULL);
* \endcode
*
******************************************************************************/
#define DSPI_CLEAR_RX_FIFO

/***************************************************************************//*!
*
* @brief                Configuration of serial input signal sample point with regard to the rising edge of SCK signal
*
* @param                DSPI_SAMPLE_AT_SCK
* @param                DSPI_DELAY_1
* @param                DSPI_DELAY_2
*
* @return               NULL
*
* @details              The #DSPI_SIN_SAMPLING ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(DSPI0_BASE,DSPI_SIN_SAMPLING, DSPI_SAMPLE_AT_SCK);
* \endcode
*
******************************************************************************/
#define DSPI_SIN_SAMPLING

/***************************************************************************//*!
*
* @brief                Software start/stop of DSPI transfers.
*
* @param                DSPI_START
* @param                DSPI_STOP
*
* @return               NULL
*
* @details              The #DSPI_TRANSFER ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(DSPI0_BASE,DSPI_TRANSFER, DSPI_START);
* \endcode
*
******************************************************************************/
#define DSPI_TRANSFER

/***************************************************************************//*!
*
* @brief                Set SPI transfer counter
*
* @param                (value unsigned 16bit)
*
* @return               NULL
*
* @details              The #DSPI_SET_TRANSFER_COUNT ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(DSPI0_BASE,DSPI_SET_TRANSFER_COUNT, (value unsigned 16bit));
* \endcode
*
******************************************************************************/
#define DSPI_SET_TRANSFER_COUNT

/***************************************************************************//*!
*
* @brief                Read SPI transfer counter
*
* @param                NULL
*
* @return               Returns uint16_t (16bit unsigned integer) representing actual number of SPI transfers stored in the SPI counter.
*
* @details              The #DSPI_GET_TRANSFER_COUNT ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(DSPI0_BASE,DSPI_GET_TRANSFER_COUNT, NULL);
* \endcode
*
******************************************************************************/
#define DSPI_GET_TRANSFER_COUNT

/***************************************************************************//*!
*
* @brief                Configuration of CTAR_0
*
* @param                DSPI_DBR_DISABLE
* @param                DSPI_DBR_ENABLE
* @param                DSPI_FMSZ_4
* @param                DSPI_FMSZ_5
* @param                DSPI_FMSZ_6
* @param                DSPI_FMSZ_7
* @param                DSPI_FMSZ_8
* @param                DSPI_FMSZ_9
* @param                DSPI_FMSZ_10
* @param                DSPI_FMSZ_11
* @param                DSPI_FMSZ_12
* @param                DSPI_FMSZ_13
* @param                DSPI_FMSZ_14
* @param                DSPI_FMSZ_15
* @param                DSPI_FMSZ_16
* @param                DSPI_SCK_POLARITY_LOW
* @param                DSPI_SCK_POLARITY_HIGH
* @param                DSPI_DATA_CAPTURE_ON_SCK_RISING_EDGE
* @param                DSPI_DATA_CAPTURE_ON_SCK_FALLING_EDGE
* @param                DSPI_MSB_FIRST
* @param                DSPI_LSB_FIRST
* @param                DSPI_PCSSCK_1
* @param                DSPI_PCSSCK_3
* @param                DSPI_PCSSCK_5
* @param                DSPI_PCSSCK_7
* @param                DSPI_PASC_1
* @param                DSPI_PASC_3
* @param                DSPI_PASC_5
* @param                DSPI_PASC_7
* @param                DSPI_PDT_1
* @param                DSPI_PDT_3
* @param                DSPI_PDT_5
* @param                DSPI_PDT_7
* @param                DSPI_PBR_2
* @param                DSPI_PBR_3
* @param                DSPI_PBR_5
* @param                DSPI_PBR_7
* @param                DSPI_CSSCK_2
* @param                DSPI_CSSCK_4
* @param                DSPI_CSSCK_8
* @param                DSPI_CSSCK_16
* @param                DSPI_CSSCK_32
* @param                DSPI_CSSCK_64
* @param                DSPI_CSSCK_128
* @param                DSPI_CSSCK_256
* @param                DSPI_CSSCK_512
* @param                DSPI_CSSCK_1024
* @param                DSPI_CSSCK_2048
* @param                DSPI_CSSCK_4096
* @param                DSPI_CSSCK_8192
* @param                DSPI_CSSCK_16384
* @param                DSPI_CSSCK_32768
* @param                DSPI_CSSCK_65536
* @param                DSPI_ASC_2
* @param                DSPI_ASC_4
* @param                DSPI_ASC_8
* @param                DSPI_ASC_16
* @param                DSPI_ASC_32
* @param                DSPI_ASC_64
* @param                DSPI_ASC_128
* @param                DSPI_ASC_256
* @param                DSPI_ASC_512
* @param                DSPI_ASC_1024
* @param                DSPI_ASC_2048
* @param                DSPI_ASC_4096
* @param                DSPI_ASC_8192
* @param                DSPI_ASC_16384
* @param                DSPI_ASC_32768
* @param                DSPI_ASC_65536
* @param                DSPI_DT_2
* @param                DSPI_DT_4
* @param                DSPI_DT_8
* @param                DSPI_DT_16
* @param                DSPI_DT_32
* @param                DSPI_DT_64
* @param                DSPI_DT_128
* @param                DSPI_DT_256
* @param                DSPI_DT_512
* @param                DSPI_DT_1024
* @param                DSPI_DT_2048
* @param                DSPI_DT_4096
* @param                DSPI_DT_8192
* @param                DSPI_DT_16384
* @param                DSPI_DT_32768
* @param                DSPI_DT_65536
* @param                DSPI_BR_2
* @param                DSPI_BR_4
* @param                DSPI_BR_6
* @param                DSPI_BR_8
* @param                DSPI_BR_16
* @param                DSPI_BR_32
* @param                DSPI_BR_64
* @param                DSPI_BR_128
* @param                DSPI_BR_256
* @param                DSPI_BR_512
* @param                DSPI_BR_1024
* @param                DSPI_BR_2048
* @param                DSPI_BR_4096
* @param                DSPI_BR_8192
* @param                DSPI_BR_16384
* @param                DSPI_BR_32768
*
* @return               NULL
*
* @details              The #DSPI_CONFG_CTAR_0 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(DSPI0_CTAR0_BASE,DSPI_CONFG_CTAR_0, DSPI_DBR_DISABLE);
* \endcode
*
******************************************************************************/
#define DSPI_CONFG_CTAR_0

/***************************************************************************//*!
*
* @brief                Read value of CTAR_0
*
* @param                NULL
*
* @return               Returns configuration of transfer attributes for CTAR_0
*
* @details              The #DSPI_READ_CTAR_0 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(DSPI0_CTAR0_BASE,DSPI_READ_CTAR_0, NULL);
* \endcode
*
******************************************************************************/
#define DSPI_READ_CTAR_0

/***************************************************************************//*!
*
* @brief                Configuration of CTAR_1
*
* @param                DSPI_DBR_DISABLE
* @param                DSPI_DBR_ENABLE
* @param                DSPI_FMSZ_4
* @param                DSPI_FMSZ_5
* @param                DSPI_FMSZ_6
* @param                DSPI_FMSZ_7
* @param                DSPI_FMSZ_8
* @param                DSPI_FMSZ_9
* @param                DSPI_FMSZ_10
* @param                DSPI_FMSZ_11
* @param                DSPI_FMSZ_12
* @param                DSPI_FMSZ_13
* @param                DSPI_FMSZ_14
* @param                DSPI_FMSZ_15
* @param                DSPI_FMSZ_16
* @param                DSPI_SCK_POLARITY_LOW
* @param                DSPI_SCK_POLARITY_HIGH
* @param                DSPI_DATA_CAPTURE_ON_SCK_RISING_EDGE
* @param                DSPI_DATA_CAPTURE_ON_SCK_FALLING_EDGE
* @param                DSPI_MSB_FIRST
* @param                DSPI_LSB_FIRST
* @param                DSPI_PCSSCK_1
* @param                DSPI_PCSSCK_3
* @param                DSPI_PCSSCK_5
* @param                DSPI_PCSSCK_7
* @param                DSPI_PASC_1
* @param                DSPI_PASC_3
* @param                DSPI_PASC_5
* @param                DSPI_PASC_7
* @param                DSPI_PDT_1
* @param                DSPI_PDT_3
* @param                DSPI_PDT_5
* @param                DSPI_PDT_7
* @param                DSPI_PBR_2
* @param                DSPI_PBR_3
* @param                DSPI_PBR_5
* @param                DSPI_PBR_7
* @param                DSPI_CSSCK_2
* @param                DSPI_CSSCK_4
* @param                DSPI_CSSCK_8
* @param                DSPI_CSSCK_16
* @param                DSPI_CSSCK_32
* @param                DSPI_CSSCK_64
* @param                DSPI_CSSCK_128
* @param                DSPI_CSSCK_256
* @param                DSPI_CSSCK_512
* @param                DSPI_CSSCK_1024
* @param                DSPI_CSSCK_2048
* @param                DSPI_CSSCK_4096
* @param                DSPI_CSSCK_8192
* @param                DSPI_CSSCK_16384
* @param                DSPI_CSSCK_32768
* @param                DSPI_CSSCK_65536
* @param                DSPI_ASC_2
* @param                DSPI_ASC_4
* @param                DSPI_ASC_8
* @param                DSPI_ASC_16
* @param                DSPI_ASC_32
* @param                DSPI_ASC_64
* @param                DSPI_ASC_128
* @param                DSPI_ASC_256
* @param                DSPI_ASC_512
* @param                DSPI_ASC_1024
* @param                DSPI_ASC_2048
* @param                DSPI_ASC_4096
* @param                DSPI_ASC_8192
* @param                DSPI_ASC_16384
* @param                DSPI_ASC_32768
* @param                DSPI_ASC_65536
* @param                DSPI_DT_2
* @param                DSPI_DT_4
* @param                DSPI_DT_8
* @param                DSPI_DT_16
* @param                DSPI_DT_32
* @param                DSPI_DT_64
* @param                DSPI_DT_128
* @param                DSPI_DT_256
* @param                DSPI_DT_512
* @param                DSPI_DT_1024
* @param                DSPI_DT_2048
* @param                DSPI_DT_4096
* @param                DSPI_DT_8192
* @param                DSPI_DT_16384
* @param                DSPI_DT_32768
* @param                DSPI_DT_65536
* @param                DSPI_BR_2
* @param                DSPI_BR_4
* @param                DSPI_BR_6
* @param                DSPI_BR_8
* @param                DSPI_BR_16
* @param                DSPI_BR_32
* @param                DSPI_BR_64
* @param                DSPI_BR_128
* @param                DSPI_BR_256
* @param                DSPI_BR_512
* @param                DSPI_BR_1024
* @param                DSPI_BR_2048
* @param                DSPI_BR_4096
* @param                DSPI_BR_8192
* @param                DSPI_BR_16384
* @param                DSPI_BR_32768
*
* @return               NULL
*
* @details              The #DSPI_CONFG_CTAR_1 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(DSPI0_CTAR1_BASE,DSPI_CONFG_CTAR_1, DSPI_DBR_DISABLE);
* \endcode
*
******************************************************************************/
#define DSPI_CONFG_CTAR_1

/***************************************************************************//*!
*
* @brief                Read value of CTAR_1
*
* @param                NULL
*
* @return               Returns configuration of transfer attributes for CTAR_1
*
* @details              The #DSPI_READ_CTAR_1 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(DSPI0_CTAR1_BASE,DSPI_READ_CTAR_1, NULL);
* \endcode
*
******************************************************************************/
#define DSPI_READ_CTAR_1

/***************************************************************************//*!
*
* @brief                Configuration of CTAR_2
*
* @param                DSPI_DBR_DISABLE
* @param                DSPI_DBR_ENABLE
* @param                DSPI_FMSZ_4
* @param                DSPI_FMSZ_5
* @param                DSPI_FMSZ_6
* @param                DSPI_FMSZ_7
* @param                DSPI_FMSZ_8
* @param                DSPI_FMSZ_9
* @param                DSPI_FMSZ_10
* @param                DSPI_FMSZ_11
* @param                DSPI_FMSZ_12
* @param                DSPI_FMSZ_13
* @param                DSPI_FMSZ_14
* @param                DSPI_FMSZ_15
* @param                DSPI_FMSZ_16
* @param                DSPI_SCK_POLARITY_LOW
* @param                DSPI_SCK_POLARITY_HIGH
* @param                DSPI_DATA_CAPTURE_ON_SCK_RISING_EDGE
* @param                DSPI_DATA_CAPTURE_ON_SCK_FALLING_EDGE
* @param                DSPI_MSB_FIRST
* @param                DSPI_LSB_FIRST
* @param                DSPI_PCSSCK_1
* @param                DSPI_PCSSCK_3
* @param                DSPI_PCSSCK_5
* @param                DSPI_PCSSCK_7
* @param                DSPI_PASC_1
* @param                DSPI_PASC_3
* @param                DSPI_PASC_5
* @param                DSPI_PASC_7
* @param                DSPI_PDT_1
* @param                DSPI_PDT_3
* @param                DSPI_PDT_5
* @param                DSPI_PDT_7
* @param                DSPI_PBR_2
* @param                DSPI_PBR_3
* @param                DSPI_PBR_5
* @param                DSPI_PBR_7
* @param                DSPI_CSSCK_2
* @param                DSPI_CSSCK_4
* @param                DSPI_CSSCK_8
* @param                DSPI_CSSCK_16
* @param                DSPI_CSSCK_32
* @param                DSPI_CSSCK_64
* @param                DSPI_CSSCK_128
* @param                DSPI_CSSCK_256
* @param                DSPI_CSSCK_512
* @param                DSPI_CSSCK_1024
* @param                DSPI_CSSCK_2048
* @param                DSPI_CSSCK_4096
* @param                DSPI_CSSCK_8192
* @param                DSPI_CSSCK_16384
* @param                DSPI_CSSCK_32768
* @param                DSPI_CSSCK_65536
* @param                DSPI_ASC_2
* @param                DSPI_ASC_4
* @param                DSPI_ASC_8
* @param                DSPI_ASC_16
* @param                DSPI_ASC_32
* @param                DSPI_ASC_64
* @param                DSPI_ASC_128
* @param                DSPI_ASC_256
* @param                DSPI_ASC_512
* @param                DSPI_ASC_1024
* @param                DSPI_ASC_2048
* @param                DSPI_ASC_4096
* @param                DSPI_ASC_8192
* @param                DSPI_ASC_16384
* @param                DSPI_ASC_32768
* @param                DSPI_ASC_65536
* @param                DSPI_DT_2
* @param                DSPI_DT_4
* @param                DSPI_DT_8
* @param                DSPI_DT_16
* @param                DSPI_DT_32
* @param                DSPI_DT_64
* @param                DSPI_DT_128
* @param                DSPI_DT_256
* @param                DSPI_DT_512
* @param                DSPI_DT_1024
* @param                DSPI_DT_2048
* @param                DSPI_DT_4096
* @param                DSPI_DT_8192
* @param                DSPI_DT_16384
* @param                DSPI_DT_32768
* @param                DSPI_DT_65536
* @param                DSPI_BR_2
* @param                DSPI_BR_4
* @param                DSPI_BR_6
* @param                DSPI_BR_8
* @param                DSPI_BR_16
* @param                DSPI_BR_32
* @param                DSPI_BR_64
* @param                DSPI_BR_128
* @param                DSPI_BR_256
* @param                DSPI_BR_512
* @param                DSPI_BR_1024
* @param                DSPI_BR_2048
* @param                DSPI_BR_4096
* @param                DSPI_BR_8192
* @param                DSPI_BR_16384
* @param                DSPI_BR_32768
*
* @return               NULL
*
* @details              The #DSPI_CONFG_CTAR_2 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(DSPI0_CTAR2_BASE,DSPI_CONFG_CTAR_2, DSPI_DBR_DISABLE);
* \endcode
*
******************************************************************************/
#define DSPI_CONFG_CTAR_2

/***************************************************************************//*!
*
* @brief                Read value of CTAR_2
*
* @param                NULL
*
* @return               Returns configuration of transfer attributes for CTAR_2
*
* @details              The #DSPI_READ_CTAR_2 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(DSPI0_CTAR2_BASE,DSPI_READ_CTAR_2, NULL);
* \endcode
*
******************************************************************************/
#define DSPI_READ_CTAR_2

/***************************************************************************//*!
*
* @brief                Configuration of CTAR_3
*
* @param                DSPI_DBR_DISABLE
* @param                DSPI_DBR_ENABLE
* @param                DSPI_FMSZ_4
* @param                DSPI_FMSZ_5
* @param                DSPI_FMSZ_6
* @param                DSPI_FMSZ_7
* @param                DSPI_FMSZ_8
* @param                DSPI_FMSZ_9
* @param                DSPI_FMSZ_10
* @param                DSPI_FMSZ_11
* @param                DSPI_FMSZ_12
* @param                DSPI_FMSZ_13
* @param                DSPI_FMSZ_14
* @param                DSPI_FMSZ_15
* @param                DSPI_FMSZ_16
* @param                DSPI_SCK_POLARITY_LOW
* @param                DSPI_SCK_POLARITY_HIGH
* @param                DSPI_DATA_CAPTURE_ON_SCK_RISING_EDGE
* @param                DSPI_DATA_CAPTURE_ON_SCK_FALLING_EDGE
* @param                DSPI_MSB_FIRST
* @param                DSPI_LSB_FIRST
* @param                DSPI_PCSSCK_1
* @param                DSPI_PCSSCK_3
* @param                DSPI_PCSSCK_5
* @param                DSPI_PCSSCK_7
* @param                DSPI_PASC_1
* @param                DSPI_PASC_3
* @param                DSPI_PASC_5
* @param                DSPI_PASC_7
* @param                DSPI_PDT_1
* @param                DSPI_PDT_3
* @param                DSPI_PDT_5
* @param                DSPI_PDT_7
* @param                DSPI_PBR_2
* @param                DSPI_PBR_3
* @param                DSPI_PBR_5
* @param                DSPI_PBR_7
* @param                DSPI_CSSCK_2
* @param                DSPI_CSSCK_4
* @param                DSPI_CSSCK_8
* @param                DSPI_CSSCK_16
* @param                DSPI_CSSCK_32
* @param                DSPI_CSSCK_64
* @param                DSPI_CSSCK_128
* @param                DSPI_CSSCK_256
* @param                DSPI_CSSCK_512
* @param                DSPI_CSSCK_1024
* @param                DSPI_CSSCK_2048
* @param                DSPI_CSSCK_4096
* @param                DSPI_CSSCK_8192
* @param                DSPI_CSSCK_16384
* @param                DSPI_CSSCK_32768
* @param                DSPI_CSSCK_65536
* @param                DSPI_ASC_2
* @param                DSPI_ASC_4
* @param                DSPI_ASC_8
* @param                DSPI_ASC_16
* @param                DSPI_ASC_32
* @param                DSPI_ASC_64
* @param                DSPI_ASC_128
* @param                DSPI_ASC_256
* @param                DSPI_ASC_512
* @param                DSPI_ASC_1024
* @param                DSPI_ASC_2048
* @param                DSPI_ASC_4096
* @param                DSPI_ASC_8192
* @param                DSPI_ASC_16384
* @param                DSPI_ASC_32768
* @param                DSPI_ASC_65536
* @param                DSPI_DT_2
* @param                DSPI_DT_4
* @param                DSPI_DT_8
* @param                DSPI_DT_16
* @param                DSPI_DT_32
* @param                DSPI_DT_64
* @param                DSPI_DT_128
* @param                DSPI_DT_256
* @param                DSPI_DT_512
* @param                DSPI_DT_1024
* @param                DSPI_DT_2048
* @param                DSPI_DT_4096
* @param                DSPI_DT_8192
* @param                DSPI_DT_16384
* @param                DSPI_DT_32768
* @param                DSPI_DT_65536
* @param                DSPI_BR_2
* @param                DSPI_BR_4
* @param                DSPI_BR_6
* @param                DSPI_BR_8
* @param                DSPI_BR_16
* @param                DSPI_BR_32
* @param                DSPI_BR_64
* @param                DSPI_BR_128
* @param                DSPI_BR_256
* @param                DSPI_BR_512
* @param                DSPI_BR_1024
* @param                DSPI_BR_2048
* @param                DSPI_BR_4096
* @param                DSPI_BR_8192
* @param                DSPI_BR_16384
* @param                DSPI_BR_32768
*
* @return               NULL
*
* @details              The #DSPI_CONFG_CTAR_3 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(DSPI0_CTAR3_BASE,DSPI_CONFG_CTAR_3, DSPI_DBR_DISABLE);
* \endcode
*
******************************************************************************/
#define DSPI_CONFG_CTAR_3

/***************************************************************************//*!
*
* @brief                Read value of CTAR_3
*
* @param                NULL
*
* @return               Returns configuration of transfer attributes for CTAR_3
*
* @details              The #DSPI_READ_CTAR_3 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(DSPI0_CTAR3_BASE,DSPI_READ_CTAR_3, NULL);
* \endcode
*
******************************************************************************/
#define DSPI_READ_CTAR_3

/***************************************************************************//*!
*
* @brief                Configuration of CTAR_4
*
* @param                DSPI_DBR_DISABLE
* @param                DSPI_DBR_ENABLE
* @param                DSPI_FMSZ_4
* @param                DSPI_FMSZ_5
* @param                DSPI_FMSZ_6
* @param                DSPI_FMSZ_7
* @param                DSPI_FMSZ_8
* @param                DSPI_FMSZ_9
* @param                DSPI_FMSZ_10
* @param                DSPI_FMSZ_11
* @param                DSPI_FMSZ_12
* @param                DSPI_FMSZ_13
* @param                DSPI_FMSZ_14
* @param                DSPI_FMSZ_15
* @param                DSPI_FMSZ_16
* @param                DSPI_SCK_POLARITY_LOW
* @param                DSPI_SCK_POLARITY_HIGH
* @param                DSPI_DATA_CAPTURE_ON_SCK_RISING_EDGE
* @param                DSPI_DATA_CAPTURE_ON_SCK_FALLING_EDGE
* @param                DSPI_MSB_FIRST
* @param                DSPI_LSB_FIRST
* @param                DSPI_PCSSCK_1
* @param                DSPI_PCSSCK_3
* @param                DSPI_PCSSCK_5
* @param                DSPI_PCSSCK_7
* @param                DSPI_PASC_1
* @param                DSPI_PASC_3
* @param                DSPI_PASC_5
* @param                DSPI_PASC_7
* @param                DSPI_PDT_1
* @param                DSPI_PDT_3
* @param                DSPI_PDT_5
* @param                DSPI_PDT_7
* @param                DSPI_PBR_2
* @param                DSPI_PBR_3
* @param                DSPI_PBR_5
* @param                DSPI_PBR_7
* @param                DSPI_CSSCK_2
* @param                DSPI_CSSCK_4
* @param                DSPI_CSSCK_8
* @param                DSPI_CSSCK_16
* @param                DSPI_CSSCK_32
* @param                DSPI_CSSCK_64
* @param                DSPI_CSSCK_128
* @param                DSPI_CSSCK_256
* @param                DSPI_CSSCK_512
* @param                DSPI_CSSCK_1024
* @param                DSPI_CSSCK_2048
* @param                DSPI_CSSCK_4096
* @param                DSPI_CSSCK_8192
* @param                DSPI_CSSCK_16384
* @param                DSPI_CSSCK_32768
* @param                DSPI_CSSCK_65536
* @param                DSPI_ASC_2
* @param                DSPI_ASC_4
* @param                DSPI_ASC_8
* @param                DSPI_ASC_16
* @param                DSPI_ASC_32
* @param                DSPI_ASC_64
* @param                DSPI_ASC_128
* @param                DSPI_ASC_256
* @param                DSPI_ASC_512
* @param                DSPI_ASC_1024
* @param                DSPI_ASC_2048
* @param                DSPI_ASC_4096
* @param                DSPI_ASC_8192
* @param                DSPI_ASC_16384
* @param                DSPI_ASC_32768
* @param                DSPI_ASC_65536
* @param                DSPI_DT_2
* @param                DSPI_DT_4
* @param                DSPI_DT_8
* @param                DSPI_DT_16
* @param                DSPI_DT_32
* @param                DSPI_DT_64
* @param                DSPI_DT_128
* @param                DSPI_DT_256
* @param                DSPI_DT_512
* @param                DSPI_DT_1024
* @param                DSPI_DT_2048
* @param                DSPI_DT_4096
* @param                DSPI_DT_8192
* @param                DSPI_DT_16384
* @param                DSPI_DT_32768
* @param                DSPI_DT_65536
* @param                DSPI_BR_2
* @param                DSPI_BR_4
* @param                DSPI_BR_6
* @param                DSPI_BR_8
* @param                DSPI_BR_16
* @param                DSPI_BR_32
* @param                DSPI_BR_64
* @param                DSPI_BR_128
* @param                DSPI_BR_256
* @param                DSPI_BR_512
* @param                DSPI_BR_1024
* @param                DSPI_BR_2048
* @param                DSPI_BR_4096
* @param                DSPI_BR_8192
* @param                DSPI_BR_16384
* @param                DSPI_BR_32768
*
* @return               NULL
*
* @details              The #DSPI_CONFG_CTAR_4 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(DSPI0_CTAR3_BASE,DSPI_CONFG_CTAR_4, DSPI_DBR_DISABLE);
* \endcode
*
******************************************************************************/
#define DSPI_CONFG_CTAR_4

/***************************************************************************//*!
*
* @brief                Read value of CTAR_4
*
* @param                NULL
*
* @return               Returns configuration of transfer attributes for CTAR_3
*
* @details              The #DSPI_READ_CTAR_4 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(DSPI0_CTAR3_BASE,DSPI_READ_CTAR_4, NULL);
* \endcode
*
******************************************************************************/
#define DSPI_READ_CTAR_4

/***************************************************************************//*!
*
* @brief                Configuration of CTAR_5
*
* @param                DSPI_DBR_DISABLE
* @param                DSPI_DBR_ENABLE
* @param                DSPI_FMSZ_4
* @param                DSPI_FMSZ_5
* @param                DSPI_FMSZ_6
* @param                DSPI_FMSZ_7
* @param                DSPI_FMSZ_8
* @param                DSPI_FMSZ_9
* @param                DSPI_FMSZ_10
* @param                DSPI_FMSZ_11
* @param                DSPI_FMSZ_12
* @param                DSPI_FMSZ_13
* @param                DSPI_FMSZ_14
* @param                DSPI_FMSZ_15
* @param                DSPI_FMSZ_16
* @param                DSPI_SCK_POLARITY_LOW
* @param                DSPI_SCK_POLARITY_HIGH
* @param                DSPI_DATA_CAPTURE_ON_SCK_RISING_EDGE
* @param                DSPI_DATA_CAPTURE_ON_SCK_FALLING_EDGE
* @param                DSPI_MSB_FIRST
* @param                DSPI_LSB_FIRST
* @param                DSPI_PCSSCK_1
* @param                DSPI_PCSSCK_3
* @param                DSPI_PCSSCK_5
* @param                DSPI_PCSSCK_7
* @param                DSPI_PASC_1
* @param                DSPI_PASC_3
* @param                DSPI_PASC_5
* @param                DSPI_PASC_7
* @param                DSPI_PDT_1
* @param                DSPI_PDT_3
* @param                DSPI_PDT_5
* @param                DSPI_PDT_7
* @param                DSPI_PBR_2
* @param                DSPI_PBR_3
* @param                DSPI_PBR_5
* @param                DSPI_PBR_7
* @param                DSPI_CSSCK_2
* @param                DSPI_CSSCK_4
* @param                DSPI_CSSCK_8
* @param                DSPI_CSSCK_16
* @param                DSPI_CSSCK_32
* @param                DSPI_CSSCK_64
* @param                DSPI_CSSCK_128
* @param                DSPI_CSSCK_256
* @param                DSPI_CSSCK_512
* @param                DSPI_CSSCK_1024
* @param                DSPI_CSSCK_2048
* @param                DSPI_CSSCK_4096
* @param                DSPI_CSSCK_8192
* @param                DSPI_CSSCK_16384
* @param                DSPI_CSSCK_32768
* @param                DSPI_CSSCK_65536
* @param                DSPI_ASC_2
* @param                DSPI_ASC_4
* @param                DSPI_ASC_8
* @param                DSPI_ASC_16
* @param                DSPI_ASC_32
* @param                DSPI_ASC_64
* @param                DSPI_ASC_128
* @param                DSPI_ASC_256
* @param                DSPI_ASC_512
* @param                DSPI_ASC_1024
* @param                DSPI_ASC_2048
* @param                DSPI_ASC_4096
* @param                DSPI_ASC_8192
* @param                DSPI_ASC_16384
* @param                DSPI_ASC_32768
* @param                DSPI_ASC_65536
* @param                DSPI_DT_2
* @param                DSPI_DT_4
* @param                DSPI_DT_8
* @param                DSPI_DT_16
* @param                DSPI_DT_32
* @param                DSPI_DT_64
* @param                DSPI_DT_128
* @param                DSPI_DT_256
* @param                DSPI_DT_512
* @param                DSPI_DT_1024
* @param                DSPI_DT_2048
* @param                DSPI_DT_4096
* @param                DSPI_DT_8192
* @param                DSPI_DT_16384
* @param                DSPI_DT_32768
* @param                DSPI_DT_65536
* @param                DSPI_BR_2
* @param                DSPI_BR_4
* @param                DSPI_BR_6
* @param                DSPI_BR_8
* @param                DSPI_BR_16
* @param                DSPI_BR_32
* @param                DSPI_BR_64
* @param                DSPI_BR_128
* @param                DSPI_BR_256
* @param                DSPI_BR_512
* @param                DSPI_BR_1024
* @param                DSPI_BR_2048
* @param                DSPI_BR_4096
* @param                DSPI_BR_8192
* @param                DSPI_BR_16384
* @param                DSPI_BR_32768
*
* @return               NULL
*
* @details              The #DSPI_CONFG_CTAR_5 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(DSPI0_CTAR3_BASE,DSPI_CONFG_CTAR_5, DSPI_DBR_DISABLE);
* \endcode
*
******************************************************************************/
#define DSPI_CONFG_CTAR_5

/***************************************************************************//*!
*
* @brief                Read value of CTAR_5
*
* @param                NULL
*
* @return               Returns configuration of transfer attributes for CTAR_3
*
* @details              The #DSPI_READ_CTAR_5 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(DSPI0_CTAR3_BASE,DSPI_READ_CTAR_5, NULL);
* \endcode
*
******************************************************************************/
#define DSPI_READ_CTAR_5

/***************************************************************************//*!
*
* @brief                Read DSPI status flags
*
* @param                DSPI_TCF
* @param                DSPI_TX_RX
* @param                DSPI_EOQF
* @param                DSPI_TFUF
* @param                DSPI_TFFF
* @param                DSPI_RFOF
* @param                DSPI_RFDF
* @param                DSPI_ALL_FLAGS
*
* @return               Returns status and flags of DSPI
*
* @details              The #DSPI_READ_STATUS_FLAGS ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(DSPI0_BASE,DSPI_READ_STATUS_FLAGS, DSPI_TCF);
* \endcode
*
******************************************************************************/
#define DSPI_READ_STATUS_FLAGS

/***************************************************************************//*!
*
* @brief                Clear DSPI status flags
*
* @param                DSPI_TCF
* @param                DSPI_TX_RX
* @param                DSPI_EOQF
* @param                DSPI_TFUF
* @param                DSPI_TFFF
* @param                DSPI_RFOF
* @param                DSPI_RFDF
* @param                DSPI_ALL_FLAGS
*
* @return               NULL
*
* @details              The #DSPI_CLEAR_STATUS_FLAGS ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(DSPI0_BASE,DSPI_CLEAR_STATUS_FLAGS, DSPI_TCF);
* \endcode
*
******************************************************************************/
#define DSPI_CLEAR_STATUS_FLAGS

/***************************************************************************//*!
*
* @brief                Enable DSPI interrupts and/or DMA
*
* @param                DSPI_TCF
* @param                DSPI_EOQF
* @param                DSPI_TFUF
* @param                DSPI_TFFF_INT
* @param                DSPI_TFFF_DMA
* @param                DSPI_RFOF
* @param                DSPI_RFDF_INT
* @param                DSPI_RFDF_DMA
* @param                DSPI_ALL_INT
*
* @return               NULL
*
* @details              The #DSPI_ENABLE_INT_DMA ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(DSPI0_BASE,DSPI_ENABLE_INT_DMA, DSPI_TCF);
* \endcode
*
******************************************************************************/
#define DSPI_ENABLE_INT_DMA

/***************************************************************************//*!
*
* @brief                Disable DSPI interrupts and/or DMA
*
* @param                DSPI_TCF
* @param                DSPI_EOQF
* @param                DSPI_TFUF
* @param                DSPI_TFFF
* @param                DSPI_RFOF
* @param                DSPI_RFDF
* @param                DSPI_ALL_INT
*
* @return               NULL
*
* @details              The #DSPI_DISABLE_INT_DMA ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(DSPI0_BASE,DSPI_DISABLE_INT_DMA, DSPI_TCF);
* \endcode
*
******************************************************************************/
#define DSPI_DISABLE_INT_DMA

/***************************************************************************//*!
*
* @brief                Read DSPI interrupts and DMA configuration
*
* @param                NULL
*
* @return               Returns configuration of interrupt and DMA request register.
*
* @details              The #DSPI_READ_INT_DMA_CONTROL_REG ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(DSPI0_BASE,DSPI_READ_INT_DMA_CONTROL_REG, NULL);
* \endcode
*
******************************************************************************/
#define DSPI_READ_INT_DMA_CONTROL_REG

/***************************************************************************//*!
*
* @brief                Write data to DSPI PUSH FIFO register for data transmint
*
* @param                DSPI_ENABLE_CONTINUOUS_CS
* @param                DSPI_DISABLE_CONTINUOUS_CS
* @param                DSPI_USE_CTAR_0
* @param                DSPI_USE_CTAR_1
* @param                DSPI_USE_CTAR_2
* @param                DSPI_USE_CTAR_3
* @param                DSPI_DATA_EOQ
* @param                DSPI_CLEAR_TRANSFER_COUNTER
* @param                DSPI_ASSERT_CS0
* @param                DSPI_ASSERT_CS1
* @param                DSPI_ASSERT_CS2
* @param                DSPI_ASSERT_CS3
* @param                DSPI_ASSERT_CS4
* @param                DSPI_ASSERT_CS5
* @param                DSPI_ASSERT_CS6
* @param                DSPI_ASSERT_CS7
* @param                value to be transmitted (16 bit data)
*
* @return               NULL
*
* @details              The #DSPI_WRITE_DATA ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(DSPI0_BASE,DSPI_WRITE_DATA, DSPI_ENABLE_CONTINUOUS_CS);
* \endcode
*
******************************************************************************/
#define DSPI_WRITE_DATA

/***************************************************************************//*!
*
* @brief                Read received data from DSPI POP FIFO register
*
* @param                NULL
*
* @return               Returns received data from RX FIFO
*
* @details              The #DSPI_READ_DATA ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(DSPI0_BASE,DSPI_READ_DATA, NULL);
* \endcode
*
******************************************************************************/
#define DSPI_READ_DATA


/******************************************************************************
* DSPI bitfield masks definition
******************************************************************************/

#define DSPI_MDIS_MASK                                  0x00004000
#define DSPI_MSTR_MASK                                  0x80000000
#define DSPI_CONTSCKE_MASK                              0x40000000
#define DSPI_DCONF_MASK                                 0x30000000
#define DSPI_FRZ_MASK                                   0x08000000
#define DSPI_MTFE_MASK                                  0x04000000
#define DSPI_PCSSE_MASK                                 0x02000000
#define DSPI_ROOE_MASK                                  0x01000000
#define DSPI_PCSIS0_MASK                                0x00010000
#define DSPI_PCSIS1_MASK                                0x00020000
#define DSPI_PCSIS2_MASK                                0x00040000
#define DSPI_PCSIS3_MASK                                0x00080000
#define DSPI_PCSIS4_MASK                                0x00100000
#define DSPI_PCSIS5_MASK                                0x00200000
#define DSPI_PCSIS6_MASK                                0x00400000
#define DSPI_PCSIS7_MASK                                0x00800000
#define DSPI_DIS_TXF_MASK                               0x00002000
#define DSPI_DIS_RXF_MASK                               0x00001000
#define DSPI_CLR_TXF_MASK                               0x00000800
#define DSPI_CLR_RXF_MASK                               0x00000400
#define DSPI_SMPL_PT_MASK                               0x00000300
#define DSPI_HALT_MASK                                  0x00000001
#define DSPI_SPI_TCNT_MASK                              0xFFFF0000

/******************************************************************************
* DSPI register offset definition
******************************************************************************/

#define DSPI_MCR_OFFSET                                 0x0
#define DSPI_TCR_OFFSET                                 0x8
#define DSPI_CTAR_0_OFFSET                              0xc
#define DSPI_CTAR_1_OFFSET                              0x10
#define DSPI_CTAR_2_OFFSET                              0x14
#define DSPI_CTAR_3_OFFSET                              0x18
#define DSPI_SR_OFFSET                                  0x2c
#define DSPI_RSER_OFFSET                                0x30
#define DSPI_PUSHR_OFFSET                               0x34
#define DSPI_POPR_OFFSET                                0x38

/******************************************************************************
* DSPI MACRO and ioctl parameters definition
******************************************************************************/

#define DSPI_ENABLE                                     1
#define DSPI_DISABLE                                    0
#define DSPI_SLAVE                                      0
#define DSPI_MASTER                                     1
#define DSPI_SPI                                        0
#define DSPI_IGNORE_DATA                                0
#define DSPI_OVERWRITE_DATA                             1
#define DSPI_LOW                                        0
#define DSPI_HIGH                                       1
#define DSPI_SAMPLE_AT_SCK                              0
#define DSPI_DELAY_1                                    1
#define DSPI_DELAY_2                                    2
#define DSPI_START                                      0
#define DSPI_STOP                                       1
#define DSPI_DBR_DISABLE                                0
#define DSPI_DBR_ENABLE                                 0x80000000
#define DSPI_FMSZ_4                                     0x18000000
#define DSPI_FMSZ_5                                     0x20000000
#define DSPI_FMSZ_6                                     0x28000000
#define DSPI_FMSZ_7                                     0x30000000
#define DSPI_FMSZ_8                                     0x38000000
#define DSPI_FMSZ_9                                     0x40000000
#define DSPI_FMSZ_10                                    0x48000000
#define DSPI_FMSZ_11                                    0x50000000
#define DSPI_FMSZ_12                                    0x58000000
#define DSPI_FMSZ_13                                    0x60000000
#define DSPI_FMSZ_14                                    0x68000000
#define DSPI_FMSZ_15                                    0x70000000
#define DSPI_FMSZ_16                                    0x78000000
#define DSPI_SCK_POLARITY_LOW                           0x0
#define DSPI_SCK_POLARITY_HIGH                          0x4000000
#define DSPI_DATA_CAPTURE_ON_SCK_RISING_EDGE            0x0
#define DSPI_DATA_CAPTURE_ON_SCK_FALLING_EDGE           0x2000000
#define DSPI_MSB_FIRST                                  0x0
#define DSPI_LSB_FIRST                                  0x1000000
#define DSPI_PCSSCK_1                                   0x0
#define DSPI_PCSSCK_3                                   0x400000
#define DSPI_PCSSCK_5                                   0x800000
#define DSPI_PCSSCK_7                                   0xC00000
#define DSPI_PASC_1                                     0x0
#define DSPI_PASC_3                                     0x100000
#define DSPI_PASC_5                                     0x200000
#define DSPI_PASC_7                                     0x300000
#define DSPI_PDT_1                                      0x0
#define DSPI_PDT_3                                      0x40000
#define DSPI_PDT_5                                      0x80000
#define DSPI_PDT_7                                      0xC0000
#define DSPI_PBR_2                                      0x0
#define DSPI_PBR_3                                      0x10000
#define DSPI_PBR_5                                      0x20000
#define DSPI_PBR_7                                      0x30000
#define DSPI_CSSCK_2                                    0x0
#define DSPI_CSSCK_4                                    0x1000
#define DSPI_CSSCK_8                                    0x2000
#define DSPI_CSSCK_16                                   0x3000
#define DSPI_CSSCK_32                                   0x4000
#define DSPI_CSSCK_64                                   0x5000
#define DSPI_CSSCK_128                                  0x6000
#define DSPI_CSSCK_256                                  0x7000
#define DSPI_CSSCK_512                                  0x8000
#define DSPI_CSSCK_1024                                 0x9000
#define DSPI_CSSCK_2048                                 0xA000
#define DSPI_CSSCK_4096                                 0xB000
#define DSPI_CSSCK_8192                                 0xC000
#define DSPI_CSSCK_16384                                0xD000
#define DSPI_CSSCK_32768                                0xE000
#define DSPI_CSSCK_65536                                0xF000
#define DSPI_ASC_2                                      0x0
#define DSPI_ASC_4                                      0x100
#define DSPI_ASC_8                                      0x200
#define DSPI_ASC_16                                     0x300
#define DSPI_ASC_32                                     0x400
#define DSPI_ASC_64                                     0x500
#define DSPI_ASC_128                                    0x600
#define DSPI_ASC_256                                    0x700
#define DSPI_ASC_512                                    0x800
#define DSPI_ASC_1024                                   0x900
#define DSPI_ASC_2048                                   0xA00
#define DSPI_ASC_4096                                   0xB00
#define DSPI_ASC_8192                                   0xC00
#define DSPI_ASC_16384                                  0xD00
#define DSPI_ASC_32768                                  0xE00
#define DSPI_ASC_65536                                  0xF00
#define DSPI_DT_2                                       0x0
#define DSPI_DT_4                                       0x10
#define DSPI_DT_8                                       0x20
#define DSPI_DT_16                                      0x30
#define DSPI_DT_32                                      0x40
#define DSPI_DT_64                                      0x50
#define DSPI_DT_128                                     0x60
#define DSPI_DT_256                                     0x70
#define DSPI_DT_512                                     0x80
#define DSPI_DT_1024                                    0x90
#define DSPI_DT_2048                                    0xA0
#define DSPI_DT_4096                                    0xB0
#define DSPI_DT_8192                                    0xC0
#define DSPI_DT_16384                                   0xD0
#define DSPI_DT_32768                                   0xE0
#define DSPI_DT_65536                                   0xF0
#define DSPI_BR_2                                       0x0
#define DSPI_BR_4                                       0x1
#define DSPI_BR_6                                       0x2
#define DSPI_BR_8                                       0x3
#define DSPI_BR_16                                      0x4
#define DSPI_BR_32                                      0x5
#define DSPI_BR_64                                      0x6
#define DSPI_BR_128                                     0x7
#define DSPI_BR_256                                     0x8
#define DSPI_BR_512                                     0x9
#define DSPI_BR_1024                                    0xA
#define DSPI_BR_2048                                    0xB
#define DSPI_BR_4096                                    0xC
#define DSPI_BR_8192                                    0xD
#define DSPI_BR_16384                                   0xE
#define DSPI_BR_32768                                   0xF
#define DSPI_TCF                                        0x80000000
#define DSPI_TX_RX                                      0x40000000
#define DSPI_EOQF                                       0x10000000
#define DSPI_TFUF                                       0x08000000
#define DSPI_TFFF                                       0x02000000
#define DSPI_RFOF                                       0x00080000
#define DSPI_RFDF                                       0x00020000
#define DSPI_ALL_FLAGS                                  0xFFFFFFFFF
#define DSPI_TFFF_INT                                   0x02000000
#define DSPI_TFFF_DMA                                   0x03000000
#define DSPI_RFDF_INT                                   0x00020000
#define DSPI_RFDF_DMA                                   0x00030000
#define DSPI_ALL_INT                                    0xFEFEFFFFF
#define DSPI_ENABLE_CONTINUOUS_CS                       0x80000000
#define DSPI_DISABLE_CONTINUOUS_CS                      0x0
#define DSPI_USE_CTAR_0                                 0x0
#define DSPI_USE_CTAR_1                                 0x10000000
#define DSPI_USE_CTAR_2                                 0x20000000
#define DSPI_USE_CTAR_3                                 0x30000000
#define DSPI_USE_CTAR_4                                 0x40000000
#define DSPI_USE_CTAR_5                                 0x50000000
#define DSPI_DATA_EOQ                                   0x08000000
#define DSPI_CLEAR_TRANSFER_COUNTER                     0x04000000
#define DSPI_ASSERT_CS0                                 0x00010000
#define DSPI_ASSERT_CS1                                 0x00020000
#define DSPI_ASSERT_CS2                                 0x00040000
#define DSPI_ASSERT_CS3                                 0x00080000
#define DSPI_ASSERT_CS4                                 0x00100000
#define DSPI_ASSERT_CS5                                 0x00200000
#define DSPI_ASSERT_CS6                                 0x00400000
#define DSPI_ASSERT_CS7                                 0x00800000

/******************************************************************************
* DSPI ioctl commands implementation
******************************************************************************/

#define ioctlDSPI_DEVICE(dspiAddr,param) \
        *((vuint32_t *)(dspiAddr + DSPI_MCR_OFFSET)) = (*((vuint32_t *)(dspiAddr + DSPI_MCR_OFFSET)) & (~DSPI_MDIS_MASK)) | (~param<<14)

#define ioctlDSPI_SET_MODE(dspiAddr,param) \
        *((vuint32_t *)(dspiAddr + DSPI_MCR_OFFSET)) = (*((vuint32_t *)(dspiAddr + DSPI_MCR_OFFSET)) & (~DSPI_MSTR_MASK)) | (param<<31)

#define ioctlDSPI_CONTINUOUS_SCK(dspiAddr,param) \
        *((vuint32_t *)(dspiAddr + DSPI_MCR_OFFSET)) = (*((vuint32_t *)(dspiAddr + DSPI_MCR_OFFSET)) & (~DSPI_CONTSCKE_MASK)) | (param<<30)

#define ioctlDSPI_CONFIGURATION(dspiAddr,param) \
        *((vuint32_t *)(dspiAddr + DSPI_MCR_OFFSET)) = (*((vuint32_t *)(dspiAddr + DSPI_MCR_OFFSET)) & (~DSPI_DCONF_MASK)) | (param<<28)

#define ioctlDSPI_FREEZE_IN_DEBUG(dspiAddr,param) \
        *((vuint32_t *)(dspiAddr + DSPI_MCR_OFFSET)) = (*((vuint32_t *)(dspiAddr + DSPI_MCR_OFFSET)) & (~DSPI_FRZ_MASK)) | (param<<27)

#define ioctlDSPI_MODIFIED_TIMING_FORMAT(dspiAddr,param) \
        *((vuint32_t *)(dspiAddr + DSPI_MCR_OFFSET)) = (*((vuint32_t *)(dspiAddr + DSPI_MCR_OFFSET)) & (~DSPI_MTFE_MASK)) | (param<<26)

#define ioctlDSPI_CS5_STROBE(dspiAddr,param) \
        *((vuint32_t *)(dspiAddr + DSPI_MCR_OFFSET)) = (*((vuint32_t *)(dspiAddr + DSPI_MCR_OFFSET)) & (~DSPI_PCSSE_MASK)) | (param<<25)

#define ioctlDSPI_RX_FIFO_OVERFLOW_MODE(dspiAddr,param) \
        *((vuint32_t *)(dspiAddr + DSPI_MCR_OFFSET)) = (*((vuint32_t *)(dspiAddr + DSPI_MCR_OFFSET)) & (~DSPI_ROOE_MASK)) | (param<<24)

#define ioctlDSPI_SET_INACTIVE_STATE_CS0(dspiAddr,param) \
        *((vuint32_t *)(dspiAddr + DSPI_MCR_OFFSET)) = (*((vuint32_t *)(dspiAddr + DSPI_MCR_OFFSET)) & (~DSPI_PCSIS0_MASK)) | (param<<16)

#define ioctlDSPI_SET_INACTIVE_STATE_CS1(dspiAddr,param) \
        *((vuint32_t *)(dspiAddr + DSPI_MCR_OFFSET)) = (*((vuint32_t *)(dspiAddr + DSPI_MCR_OFFSET)) & (~DSPI_PCSIS1_MASK)) | (param<<17)

#define ioctlDSPI_SET_INACTIVE_STATE_CS2(dspiAddr,param) \
        *((vuint32_t *)(dspiAddr + DSPI_MCR_OFFSET)) = (*((vuint32_t *)(dspiAddr + DSPI_MCR_OFFSET)) & (~DSPI_PCSIS2_MASK)) | (param<<18)

#define ioctlDSPI_SET_INACTIVE_STATE_CS3(dspiAddr,param) \
        *((vuint32_t *)(dspiAddr + DSPI_MCR_OFFSET)) = (*((vuint32_t *)(dspiAddr + DSPI_MCR_OFFSET)) & (~DSPI_PCSIS3_MASK)) | (param<<19)

#define ioctlDSPI_SET_INACTIVE_STATE_CS4(dspiAddr,param) \
        *((vuint32_t *)(dspiAddr + DSPI_MCR_OFFSET)) = (*((vuint32_t *)(dspiAddr + DSPI_MCR_OFFSET)) & (~DSPI_PCSIS4_MASK)) | (param<<20)

#define ioctlDSPI_SET_INACTIVE_STATE_CS5(dspiAddr,param) \
        *((vuint32_t *)(dspiAddr + DSPI_MCR_OFFSET)) = (*((vuint32_t *)(dspiAddr + DSPI_MCR_OFFSET)) & (~DSPI_PCSIS5_MASK)) | (param<<21)

#define ioctlDSPI_SET_INACTIVE_STATE_CS6(dspiAddr,param) \
        *((vuint32_t *)(dspiAddr + DSPI_MCR_OFFSET)) = (*((vuint32_t *)(dspiAddr + DSPI_MCR_OFFSET)) & (~DSPI_PCSIS6_MASK)) | (param<<22)

#define ioctlDSPI_SET_INACTIVE_STATE_CS7(dspiAddr,param) \
        *((vuint32_t *)(dspiAddr + DSPI_MCR_OFFSET)) = (*((vuint32_t *)(dspiAddr + DSPI_MCR_OFFSET)) & (~DSPI_PCSIS7_MASK)) | (param<<23)

#define ioctlDSPI_TX_FIFO(dspiAddr,param) \
        *((vuint32_t *)(dspiAddr + DSPI_MCR_OFFSET)) = (*((vuint32_t *)(dspiAddr + DSPI_MCR_OFFSET)) & (~DSPI_DIS_TXF_MASK)) | (~param<<13)

#define ioctlDSPI_RX_FIFO(dspiAddr,param) \
        *((vuint32_t *)(dspiAddr + DSPI_MCR_OFFSET)) = (*((vuint32_t *)(dspiAddr + DSPI_MCR_OFFSET)) & (~DSPI_DIS_RXF_MASK)) | (~param<<12)

#define ioctlDSPI_CLEAR_TX_FIFO(dspiAddr,param) \
        *((vuint32_t *)(dspiAddr + DSPI_MCR_OFFSET)) = (*((vuint32_t *)(dspiAddr + DSPI_MCR_OFFSET)) & (~DSPI_CLR_TXF_MASK)) | (param<<11)

#define ioctlDSPI_CLEAR_RX_FIFO(dspiAddr,param) \
        *((vuint32_t *)(dspiAddr + DSPI_MCR_OFFSET)) = (*((vuint32_t *)(dspiAddr + DSPI_MCR_OFFSET)) & (~DSPI_CLR_RXF_MASK)) | (param<<10)

#define ioctlDSPI_SIN_SAMPLING(dspiAddr,param) \
        *((vuint32_t *)(dspiAddr + DSPI_MCR_OFFSET)) = (*((vuint32_t *)(dspiAddr + DSPI_MCR_OFFSET)) & (~DSPI_SMPL_PT_MASK)) | (param<<8)

#define ioctlDSPI_TRANSFER(dspiAddr,param) \
        *((vuint32_t *)(dspiAddr + DSPI_MCR_OFFSET)) = (*((vuint32_t *)(dspiAddr + DSPI_MCR_OFFSET)) & (~DSPI_HALT_MASK)) | (param)

#define ioctlDSPI_SET_TRANSFER_COUNT(dspiAddr,param) \
        *((vuint32_t *)(dspiAddr + DSPI_TCR_OFFSET)) & (DSPI_SPI_TCNT_MASK) & (param)

#define ioctlDSPI_GET_TRANSFER_COUNT(dspiAddr,param) \
        (*((vuint32_t *)(dspiAddr + DSPI_TCR_OFFSET)) & (DSPI_SPI_TCNT_MASK)) >>16

#define ioctlDSPI_CONFG_CTAR_0(dspiAddr,param) \
        *((vuint32_t *)(dspiAddr + DSPI_CTAR_0_OFFSET)) = (param)

#define ioctlDSPI_READ_CTAR_0(dspiAddr,param) \
        *((vuint32_t *)(dspiAddr + DSPI_CTAR_0_OFFSET))

#define ioctlDSPI_CONFG_CTAR_1(dspiAddr,param) \
        *((vuint32_t *)(dspiAddr + DSPI_CTAR_1_OFFSET)) = (param)

#define ioctlDSPI_READ_CTAR_1(dspiAddr,param) \
        *((vuint32_t *)(dspiAddr + DSPI_CTAR_1_OFFSET))

#define ioctlDSPI_CONFG_CTAR_2(dspiAddr,param) \
        *((vuint32_t *)(dspiAddr + DSPI_CTAR_2_OFFSET)) = (param)

#define ioctlDSPI_READ_CTAR_2(dspiAddr,param) \
        *((vuint32_t *)(dspiAddr + DSPI_CTAR_2_OFFSET))

#define ioctlDSPI_CONFG_CTAR_3(dspiAddr,param) \
        *((vuint32_t *)(dspiAddr + DSPI_CTAR_3_OFFSET)) = (param)

#define ioctlDSPI_READ_CTAR_3(dspiAddr,param) \
        *((vuint32_t *)(dspiAddr + DSPI_CTAR_3_OFFSET))

#define ioctlDSPI_CONFG_CTAR_4(dspiAddr,param) \
        *((vuint32_t *)(dspiAddr + DSPI_CTAR_4_OFFSET)) = (param)

#define ioctlDSPI_READ_CTAR_4(dspiAddr,param) \
        *((vuint32_t *)(dspiAddr + DSPI_CTAR_4_OFFSET))

#define ioctlDSPI_CONFG_CTAR_5(dspiAddr,param) \
        *((vuint32_t *)(dspiAddr + DSPI_CTAR_5_OFFSET)) = (param)

#define ioctlDSPI_READ_CTAR_5(dspiAddr,param) \
        *((vuint32_t *)(dspiAddr + DSPI_CTAR_5_OFFSET))

#define ioctlDSPI_READ_STATUS_FLAGS(dspiAddr,param) \
        *((vuint32_t *)(dspiAddr + DSPI_SR_OFFSET)) & (param)

#define ioctlDSPI_CLEAR_STATUS_FLAGS(dspiAddr,param) \
        *((vuint32_t *)(dspiAddr + DSPI_SR_OFFSET)) = (param)

#define ioctlDSPI_ENABLE_INT_DMA(dspiAddr,param) \
        *((vuint32_t *)(dspiAddr + DSPI_RSER_OFFSET)) = (param)

#define ioctlDSPI_DISABLE_INT_DMA(dspiAddr,param) \
        *((vuint32_t *)(dspiAddr + DSPI_RSER_OFFSET)) = (~param)

#define ioctlDSPI_READ_INT_DMA_CONTROL_REG(dspiAddr,param) \
        *((vuint32_t *)(dspiAddr + DSPI_RSER_OFFSET))

#define ioctlDSPI_WRITE_DATA(dspiAddr,param) \
        {\
        vuint32_t u32RetVal;\
        ioctlDSPI_CLEAR_STATUS_FLAGS(dspiAddr,DSPI_TCF); \
        *((vuint32_t *)(dspiAddr + DSPI_PUSHR_OFFSET)) = (param); \
        while((ioctlDSPI_READ_STATUS_FLAGS(dspiAddr,DSPI_TCF))==0);\
        }

#define ioctlDSPI_READ_DATA(dspiAddr,param) \
        *((vuint32_t *)(dspiAddr + DSPI_POPR_OFFSET))

/*------------------------------------------------------------------------*//*!
@struct DSPI_SET_T "\MPC5606B_DSPI_LLD.h"

@brief  Structure containing configuration setup for the DSPI module
*//*-------------------------------------------------------------------------*/
typedef struct
{
    uint8_t         dspiCsSignal;   /*!< define number of the CS signal used for communication */
    uint8_t         csPcrNb;        /*!< define number of the PCR register used for CS signal on the CB */
    uint32_t        txCmd;          /*!< define transmit command */
    uint32_t        dspiBaseAdr;    /*!< define base address of used DSPI module */
}DSPI_SET_T;


#ifdef __cplusplus
}
#endif

#endif /* __MPC5606B_DSPI_LLD_H */