/******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2012 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
***************************************************************************//*!
*
* @file     MPC5606B_LLD_qs.h
*
* @author   b06050
*
* @version  1.0.2.0
*
* @date     Aug-3-2012
*
* @brief    Master header file for MPC5606B_QuickStart
*
******************************************************************************/
#ifndef __MPC5606B_LLD_QS_H
#define __MPC5606B_LLD_QS_H

/*******************************************************
* ioctl commands macro
* periph - Defined instance of a peripheral module
* cmd - command
* prm - parameter
*******************************************************/
#define ioctl(periph,cmd,prm) ioctl##cmd((periph),(prm))

/* set bits using the bfset instruction */
#define periphBitSet(mask, addr)   (*(addr) |= (mask))

/* clear bits using the bfclr instruction */
#define periphBitClear(mask, addr) (*(addr) &= ~(mask))

#endif /* __MPC5606B_LLD_QS_H */