/*******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2012 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
****************************************************************************//*!
*
* @file     MPC5606B_PIT_LLD.c
*
* @author   b06050
*
* @version  1.0.2.0
*
* @date     Aug-3-2012
*
* @brief    PIT low level driver module for MPC5606B
*
********************************************************************************
*
* This file includes initial setting functions of MPC5606B PIT module.
*
*******************************************************************************/
#include "MPC5606B_PIT_LLD.h"

/*******************************************************************************
* PIT functions
*******************************************************************************/

/***************************************************************************//*!
@brief          PIT delay function.

@param[in,out]  *SetPtr

@return         dt_set_fault

@details        This function provides basic blocking delay functionality.

@warning
*******************************************************************************/
void delayNanoSec(uint32_t delay_ns)
{
    // disable timer for setup new period
    ioctl(PIT_BASE,PIT_TIMER, PIT_DISABLE);

    // delay time
    ioctl(PIT_CHNL0_BASE,PIT_SET_TMR_RELOAD_VALUE, ((delay_ns * PIT_CLK)/1000));

    // enable timer
    ioctl(PIT_CHNL0_BASE,PIT_TIMER, PIT_ENABLE);

    // wait defined time
    while (!(ioctl(PIT_CHNL0_BASE,PIT_GET_FLAG, NULL)));

    // disable timer
    ioctl(PIT_CHNL0_BASE,PIT_TIMER, PIT_DISABLE);

    // clear interrupt flag
    ioctl(PIT_CHNL0_BASE,PIT_CLEAR_FLAG, PIT_CLEAR_FLAG);

}