/*******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2012 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
****************************************************************************//*!
*
* @file     ctu.c
*
* @author   b06050
*
* @version  1.0.2.0
*
* @date     Aug-3-2012
*
* @brief    CTU - Cross Triggering Unit for MPC5606B
*
********************************************************************************
*
* This file includes initial setting function of MPC5606B CTU peripheral module.
*
*******************************************************************************/
#include "MPC5606B.h"
#include "ctu.h"
#include "MPC5606B_appconfig.h"

/*******************************************************************************
* CTU functions
******************************************************************************/

/****************************************************************************//*!
@brief          Cross Triggering Unit initialization function

@param[in,out]  void
@param[in]      void

@return         void

@details        This function initializes the CTU.
*******************************************************************************/
void ctu_init(void)
{
    static uint8_t  i;

    // initialization of peripheral base address
    pCTU=(struct CTUL_tag *)&CTUL;

    /*--------------------------------------------------------------------------
     * CTU registers reset
    --------------------------------------------------------------------------*/
    for (i = 0; i<=64; i++)
    {
        pCTU->EVTCFGR[i].R = 0x0;
    }

    /*--------------------------------------------------------------------------
     * CTU Even Configuration Registers
    --------------------------------------------------------------------------*/
    #ifdef CTU_EVTCFGR0                    /* EVTCFGR0 register */
        pCTU->EVTCFGR[0].R     = CTU_EVTCFGR0;
    #endif

    #ifdef CTU_EVTCFGR1                    /* EVTCFGR1 register */
        pCTU->EVTCFGR[1].R     = CTU_EVTCFGR1;
    #endif

    #ifdef CTU_EVTCFGR2                    /* EVTCFGR2 register */
        pCTU->EVTCFGR[2].R     = CTU_EVTCFGR2;
    #endif

    #ifdef CTU_EVTCFGR3                    /* EVTCFGR3 register */
        pCTU->EVTCFGR[3].R     = CTU_EVTCFGR3;
    #endif

    #ifdef CTU_EVTCFGR4                    /* EVTCFGR4 register */
        pCTU->EVTCFGR[4].R     = CTU_EVTCFGR4;
    #endif

    #ifdef CTU_EVTCFGR5                    /* EVTCFGR5 register */
        pCTU->EVTCFGR[5].R     = CTU_EVTCFGR5;
    #endif

    #ifdef CTU_EVTCFGR6                    /* EVTCFGR6 register */
        pCTU->EVTCFGR[6].R     = CTU_EVTCFGR6;
    #endif

    #ifdef CTU_EVTCFGR7                    /* EVTCFGR7 register */
        pCTU->EVTCFGR[7].R     = CTU_EVTCFGR7;
    #endif

    #ifdef CTU_EVTCFGR8                    /* EVTCFGR8 register */
        pCTU->EVTCFGR[8].R     = CTU_EVTCFGR8;
    #endif

    #ifdef CTU_EVTCFGR9                    /* EVTCFGR9 register */
        pCTU->EVTCFGR[9].R     = CTU_EVTCFGR9;
    #endif

    #ifdef CTU_EVTCFGR10                   /* EVTCFGR10 register */
        pCTU->EVTCFGR[10].R     = CTU_EVTCFGR10;
    #endif

    #ifdef CTU_EVTCFGR11                   /* EVTCFGR11 register */
        pCTU->EVTCFGR[11].R     = CTU_EVTCFGR11;
    #endif

    #ifdef CTU_EVTCFGR12                   /* EVTCFGR12 register */
        pCTU->EVTCFGR[12].R     = CTU_EVTCFGR12;
    #endif

    #ifdef CTU_EVTCFGR13                   /* EVTCFGR13 register */
        pCTU->EVTCFGR[13].R     = CTU_EVTCFGR13;
    #endif

    #ifdef CTU_EVTCFGR14                   /* EVTCFGR14 register */
        pCTU->EVTCFGR[14].R     = CTU_EVTCFGR14;
    #endif

    #ifdef CTU_EVTCFGR15                   /* EVTCFGR15 register */
        pCTU->EVTCFGR[15].R     = CTU_EVTCFGR15;
    #endif

    #ifdef CTU_EVTCFGR16                   /* EVTCFGR16 register */
        pCTU->EVTCFGR[16].R     = CTU_EVTCFGR16;
    #endif

    #ifdef CTU_EVTCFGR17                   /* EVTCFGR17 register */
        pCTU->EVTCFGR[17].R     = CTU_EVTCFGR17;
    #endif

    #ifdef CTU_EVTCFGR18                   /* EVTCFGR18 register */
        pCTU->EVTCFGR[18].R     = CTU_EVTCFGR18;
    #endif

    #ifdef CTU_EVTCFGR19                   /* EVTCFGR19 register */
        pCTU->EVTCFGR[19].R     = CTU_EVTCFGR19;
    #endif

    #ifdef CTU_EVTCFGR20                   /* EVTCFGR20 register */
        pCTU->EVTCFGR[20].R     = CTU_EVTCFGR20;
    #endif

    #ifdef CTU_EVTCFGR21                   /* EVTCFGR21 register */
        pCTU->EVTCFGR[21].R     = CTU_EVTCFGR21;
    #endif

    #ifdef CTU_EVTCFGR22                   /* EVTCFGR22 register */
        pCTU->EVTCFGR[22].R     = CTU_EVTCFGR22;
    #endif

    #ifdef CTU_EVTCFGR23                   /* EVTCFGR23 register */
        pCTU->EVTCFGR[23].R     = CTU_EVTCFGR23;
    #endif

    #ifdef CTU_EVTCFGR24                   /* EVTCFGR24 register */
        pCTU->EVTCFGR[24].R     = CTU_EVTCFGR24;
    #endif

    #ifdef CTU_EVTCFGR25                   /* EVTCFGR25 register */
        pCTU->EVTCFGR[25].R     = CTU_EVTCFGR25;
    #endif

    #ifdef CTU_EVTCFGR26                   /* EVTCFGR26 register */
        pCTU->EVTCFGR[26].R     = CTU_EVTCFGR26;
    #endif

    #ifdef CTU_EVTCFGR27                   /* EVTCFGR27 register */
        pCTU->EVTCFGR[27].R     = CTU_EVTCFGR27;
    #endif

    #ifdef CTU_EVTCFGR28                   /* EVTCFGR28 register */
        pCTU->EVTCFGR[28].R     = CTU_EVTCFGR28;
    #endif

    #ifdef CTU_EVTCFGR29                   /* EVTCFGR29 register */
        pCTU->EVTCFGR[29].R     = CTU_EVTCFGR29;
    #endif

    #ifdef CTU_EVTCFGR30                   /* EVTCFGR30 register */
        pCTU->EVTCFGR[30].R     = CTU_EVTCFGR30;
    #endif

    #ifdef CTU_EVTCFGR31                   /* EVTCFGR31 register */
        pCTU->EVTCFGR[31].R     = CTU_EVTCFGR31;
    #endif

    #ifdef CTU_EVTCFGR32                   /* EVTCFGR32 register */
        pCTU->EVTCFGR[32].R     = CTU_EVTCFGR32;
    #endif

    #ifdef CTU_EVTCFGR33                   /* EVTCFGR33 register */
        pCTU->EVTCFGR[33].R     = CTU_EVTCFGR33;
    #endif

    #ifdef CTU_EVTCFGR34                   /* EVTCFGR34 register */
        pCTU->EVTCFGR[34].R     = CTU_EVTCFGR34;
    #endif

    #ifdef CTU_EVTCFGR35                   /* EVTCFGR35 register */
        pCTU->EVTCFGR[35].R     = CTU_EVTCFGR35;
    #endif

    #ifdef CTU_EVTCFGR36                   /* EVTCFGR36 register */
        pCTU->EVTCFGR[36].R     = CTU_EVTCFGR36;
    #endif

    #ifdef CTU_EVTCFGR37                   /* EVTCFGR37 register */
        pCTU->EVTCFGR[37].R     = CTU_EVTCFGR37;
    #endif

    #ifdef CTU_EVTCFGR38                   /* EVTCFGR38 register */
        pCTU->EVTCFGR[38].R     = CTU_EVTCFGR38;
    #endif

    #ifdef CTU_EVTCFGR39                   /* EVTCFGR39 register */
        pCTU->EVTCFGR[39].R     = CTU_EVTCFGR39;
    #endif

    #ifdef CTU_EVTCFGR40                   /* EVTCFGR40 register */
        pCTU->EVTCFGR[40].R     = CTU_EVTCFGR40;
    #endif

    #ifdef CTU_EVTCFGR41                   /* EVTCFGR41 register */
        pCTU->EVTCFGR[41].R     = CTU_EVTCFGR41;
    #endif

    #ifdef CTU_EVTCFGR42                   /* EVTCFGR42 register */
        pCTU->EVTCFGR[42].R     = CTU_EVTCFGR42;
    #endif

    #ifdef CTU_EVTCFGR43                   /* EVTCFGR43 register */
        pCTU->EVTCFGR[43].R     = CTU_EVTCFGR43;
    #endif

    #ifdef CTU_EVTCFGR44                   /* EVTCFGR44 register */
        pCTU->EVTCFGR[44].R     = CTU_EVTCFGR44;
    #endif

    #ifdef CTU_EVTCFGR45                   /* EVTCFGR45 register */
        pCTU->EVTCFGR[45].R     = CTU_EVTCFGR45;
    #endif

    #ifdef CTU_EVTCFGR46                   /* EVTCFGR46 register */
        pCTU->EVTCFGR[46].R     = CTU_EVTCFGR46;
    #endif

    #ifdef CTU_EVTCFGR47                   /* EVTCFGR47 register */
        pCTU->EVTCFGR[47].R     = CTU_EVTCFGR47;
    #endif

    #ifdef CTU_EVTCFGR48                   /* EVTCFGR48 register */
        pCTU->EVTCFGR[48].R     = CTU_EVTCFGR48;
    #endif

    #ifdef CTU_EVTCFGR49                   /* EVTCFGR49 register */
        pCTU->EVTCFGR[49].R     = CTU_EVTCFGR49;
    #endif

    #ifdef CTU_EVTCFGR50                   /* EVTCFGR50 register */
        pCTU->EVTCFGR[50].R     = CTU_EVTCFGR50;
    #endif

    #ifdef CTU_EVTCFGR51                   /* EVTCFGR51 register */
        pCTU->EVTCFGR[51].R     = CTU_EVTCFGR51;
    #endif

    #ifdef CTU_EVTCFGR52                   /* EVTCFGR52 register */
        pCTU->EVTCFGR[52].R     = CTU_EVTCFGR52;
    #endif

    #ifdef CTU_EVTCFGR53                   /* EVTCFGR53 register */
        pCTU->EVTCFGR[53].R     = CTU_EVTCFGR53;
    #endif

    #ifdef CTU_EVTCFGR54                   /* EVTCFGR54 register */
        pCTU->EVTCFGR[54].R     = CTU_EVTCFGR54;
    #endif

    #ifdef CTU_EVTCFGR55                   /* EVTCFGR55 register */
        pCTU->EVTCFGR[55].R     = CTU_EVTCFGR55;
    #endif

    #ifdef CTU_EVTCFGR56                   /* EVTCFGR56 register */
        pCTU->EVTCFGR[56].R     = CTU_EVTCFGR56;
    #endif

    #ifdef CTU_EVTCFGR57                   /* EVTCFGR57 register */
        pCTU->EVTCFGR[57].R     = CTU_EVTCFGR57;
    #endif

    #ifdef CTU_EVTCFGR58                   /* EVTCFGR58 register */
        pCTU->EVTCFGR[58].R     = CTU_EVTCFGR58;
    #endif

    #ifdef CTU_EVTCFGR59                   /* EVTCFGR59 register */
        pCTU->EVTCFGR[59].R     = CTU_EVTCFGR59;
    #endif

    #ifdef CTU_EVTCFGR60                   /* EVTCFGR60 register */
        pCTU->EVTCFGR[60].R     = CTU_EVTCFGR60;
    #endif

    #ifdef CTU_EVTCFGR61                   /* EVTCFGR61 register */
        pCTU->EVTCFGR[61].R     = CTU_EVTCFGR61;
    #endif

    #ifdef CTU_EVTCFGR62                   /* EVTCFGR62 register */
        pCTU->EVTCFGR[62].R     = CTU_EVTCFGR62;
    #endif

    #ifdef CTU_EVTCFGR63                   /* EVTCFGR63 register */
        pCTU->EVTCFGR[63].R     = CTU_EVTCFGR63;
    #endif
}