 /******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2012 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
****************************************************************************//*!
*
* @file     dspi.c
*
* @author   b06050
*
* @version  1.0.2.0
*
* @date     Aug-3-2012
*
* @brief    DSPI - DSPI module on MPC5606B
*
********************************************************************************
*
* This file includes initial setting functions of MPC5606B DSPI module.
*
*******************************************************************************/
#include "MPC5606B.h"
#include "dspi.h"
#include "MPC5606B_appconfig.h"

/*******************************************************************************
* DSPI functions
*******************************************************************************/

/***************************************************************************//*!
@brief          DSPI initialization function

@param[in,out]  void
@param[in]      void

@return         void

@details        This function initializes DSPI modules 0 to 4.
*******************************************************************************/
void dspi_init(void)
{
    pDSPI0=(struct DSPI_tag *)&DSPI_0;
    pDSPI1=(struct DSPI_tag *)&DSPI_1;
    pDSPI2=(struct DSPI_tag *)&DSPI_2;
    pDSPI3=(struct DSPI_tag *)&DSPI_3;
    pDSPI4=(struct DSPI_tag *)&DSPI_4;

    /*--------------------------------------------------------------------------
     * DSPI0 Reset
    --------------------------------------------------------------------------*/
    pDSPI0->MCR.R               = 0x1;
    pDSPI0->CTAR[0].R           = 0x38000000;
    pDSPI0->CTAR[1].R           = 0x38000000;
    pDSPI0->CTAR[2].R           = 0x38000000;
    pDSPI0->CTAR[3].R           = 0x38000000;
    pDSPI0->CTAR[4].R           = 0x38000000;
    pDSPI0->CTAR[5].R           = 0x38000000;
    pDSPI0->CTAR[6].R           = 0x38000000;
    pDSPI0->CTAR[7].R           = 0x38000000;
    pDSPI0->RSER.R              = 0x0;
    /*--------------------------------------------------------------------------
     * DSPI1 Reset
    --------------------------------------------------------------------------*/
    pDSPI1->MCR.R               = 0x1;
    pDSPI1->CTAR[0].R           = 0x38000000;
    pDSPI1->CTAR[1].R           = 0x38000000;
    pDSPI1->CTAR[2].R           = 0x38000000;
    pDSPI1->CTAR[3].R           = 0x38000000;
    pDSPI1->CTAR[4].R           = 0x38000000;
    pDSPI1->CTAR[5].R           = 0x38000000;
    pDSPI1->CTAR[6].R           = 0x38000000;
    pDSPI1->CTAR[7].R           = 0x38000000;
    pDSPI1->RSER.R              = 0x0;
    /*--------------------------------------------------------------------------
     * DSPI2 Reset
    --------------------------------------------------------------------------*/
    pDSPI2->MCR.R               = 0x1;
    pDSPI2->CTAR[0].R           = 0x38000000;
    pDSPI2->CTAR[1].R           = 0x38000000;
    pDSPI2->CTAR[2].R           = 0x38000000;
    pDSPI2->CTAR[3].R           = 0x38000000;
    pDSPI2->CTAR[4].R           = 0x38000000;
    pDSPI2->CTAR[5].R           = 0x38000000;
    pDSPI2->CTAR[6].R           = 0x38000000;
    pDSPI2->CTAR[7].R           = 0x38000000;
    pDSPI2->RSER.R              = 0x0;
    /*--------------------------------------------------------------------------
     * DSPI3 Reset
    --------------------------------------------------------------------------*/
    pDSPI3->MCR.R               = 0x1;
    pDSPI3->CTAR[0].R           = 0x38000000;
    pDSPI3->CTAR[1].R           = 0x38000000;
    pDSPI3->CTAR[2].R           = 0x38000000;
    pDSPI3->CTAR[3].R           = 0x38000000;
    pDSPI3->CTAR[4].R           = 0x38000000;
    pDSPI3->CTAR[5].R           = 0x38000000;
    pDSPI3->CTAR[6].R           = 0x38000000;
    pDSPI3->CTAR[7].R           = 0x38000000;
    pDSPI3->RSER.R              = 0x0;
    /*--------------------------------------------------------------------------
     * DSPI4 Reset
    --------------------------------------------------------------------------*/
    pDSPI4->MCR.R               = 0x1;
    pDSPI4->CTAR[0].R           = 0x38000000;
    pDSPI4->CTAR[1].R           = 0x38000000;
    pDSPI4->CTAR[2].R           = 0x38000000;
    pDSPI4->CTAR[3].R           = 0x38000000;
    pDSPI4->CTAR[4].R           = 0x38000000;
    pDSPI4->CTAR[5].R           = 0x38000000;
    pDSPI4->CTAR[6].R           = 0x38000000;
    pDSPI4->CTAR[7].R           = 0x38000000;
    pDSPI4->RSER.R              = 0x0;
    /*--------------------------------------------------------------------------
     * DSPI0 Control registers
    --------------------------------------------------------------------------*/
    #ifdef DSPI0_MCR                  /* MCR register */
        pDSPI0->MCR.R           = DSPI0_MCR;
    #endif

    #ifdef DSPI0_TCR                   /* TCR register */
        pDSPI0->TCR.R           = DSPI0_TCR;
    #endif

    #ifdef DSPI0_CTAR0                   /* CTAR[0] register */
        pDSPI0->CTAR[0].R       = DSPI0_CTAR0;
    #endif

    #ifdef DSPI0_CTAR1                   /* CTAR[1] register */
        pDSPI0->CTAR[1].R       = DSPI0_CTAR1;
    #endif

    #ifdef DSPI0_CTAR2                   /* CTAR[2] register */
        pDSPI0->CTAR[2].R       = DSPI0_CTAR2;
    #endif

    #ifdef DSPI0_CTAR3                   /* CTAR[3] register */
        pDSPI0->CTAR[3].R       = DSPI0_CTAR3;
    #endif

    #ifdef DSPI0_CTAR4                   /* CTAR[4] register */
        pDSPI0->CTAR[4].R       = DSPI0_CTAR4;
    #endif

    #ifdef DSPI0_CTAR5                   /* CTAR[5] register */
        pDSPI0->CTAR[5].R       = DSPI0_CTAR5;
    #endif

    #ifdef DSPI0_CTAR6                   /* CTAR[6] register */
        pDSPI0->CTAR[6].R       = DSPI0_CTAR6;
    #endif

    #ifdef DSPI0_CTAR7                   /* CTAR[7] register */
        pDSPI0->CTAR[7].R       = DSPI0_CTAR7;
    #endif

    #ifdef DSPI0_RSER                   /* RSER register */
        pDSPI0->RSER.R          = DSPI0_RSER;
    #endif

    /*--------------------------------------------------------------------------
     * DSPI1 Control registers
    --------------------------------------------------------------------------*/
    #ifdef DSPI1_MCR                  /* MCR register */
        pDSPI1->MCR.R           = DSPI1_MCR;
    #endif

    #ifdef DSPI1_TCR                   /* TCR register */
        pDSPI1->TCR.R           = DSPI1_TCR;
    #endif

    #ifdef DSPI1_CTAR0                   /* CTAR[0] register */
        pDSPI1->CTAR[0].R       = DSPI1_CTAR0;
    #endif

    #ifdef DSPI1_CTAR1                   /* CTAR[1] register */
        pDSPI1->CTAR[1].R       = DSPI1_CTAR1;
    #endif

    #ifdef DSPI1_CTAR2                   /* CTAR[2] register */
        pDSPI1->CTAR[2].R       = DSPI1_CTAR2;
    #endif

    #ifdef DSPI1_CTAR3                   /* CTAR[3] register */
        pDSPI1->CTAR[3].R       = DSPI1_CTAR3;
    #endif

    #ifdef DSPI1_CTAR4                   /* CTAR[4] register */
        pDSPI1->CTAR[4].R       = DSPI1_CTAR4;
    #endif

    #ifdef DSPI1_CTAR5                   /* CTAR[5] register */
        pDSPI1->CTAR[5].R       = DSPI1_CTAR5;
    #endif

    #ifdef DSPI1_CTAR6                   /* CTAR[6] register */
        pDSPI1->CTAR[6].R       = DSPI1_CTAR6;
    #endif

    #ifdef DSPI1_CTAR7                   /* CTAR[7] register */
        pDSPI1->CTAR[7].R       = DSPI1_CTAR7;
    #endif

    #ifdef DSPI1_RSER                   /* RSER register */
        pDSPI1->RSER.R          = DSPI1_RSER;
    #endif

    /*--------------------------------------------------------------------------
     * DSPI2 Control registers
    --------------------------------------------------------------------------*/
    #ifdef DSPI2_MCR                  /* MCR register */
        pDSPI2->MCR.R           = DSPI2_MCR;
    #endif

    #ifdef DSPI2_TCR                   /* TCR register */
        pDSPI2->TCR.R           = DSPI2_TCR;
    #endif

    #ifdef DSPI2_CTAR0                   /* CTAR[0] register */
        pDSPI2->CTAR[0].R       = DSPI2_CTAR0;
    #endif

    #ifdef DSPI2_CTAR1                   /* CTAR[1] register */
        pDSPI2->CTAR[1].R       = DSPI2_CTAR1;
    #endif

    #ifdef DSPI2_CTAR2                   /* CTAR[2] register */
        pDSPI2->CTAR[2].R       = DSPI2_CTAR2;
    #endif

    #ifdef DSPI2_CTAR3                   /* CTAR[3] register */
        pDSPI2->CTAR[3].R       = DSPI2_CTAR3;
    #endif

    #ifdef DSPI2_CTAR4                   /* CTAR[4] register */
        pDSPI2->CTAR[4].R       = DSPI2_CTAR4;
    #endif

    #ifdef DSPI2_CTAR5                   /* CTAR[5] register */
        pDSPI2->CTAR[5].R       = DSPI2_CTAR5;
    #endif

    #ifdef DSPI2_CTAR6                   /* CTAR[6] register */
        pDSPI2->CTAR[6].R       = DSPI2_CTAR6;
    #endif

    #ifdef DSPI2_CTAR7                   /* CTAR[7] register */
        pDSPI2->CTAR[7].R       = DSPI2_CTAR7;
    #endif

    #ifdef DSPI2_RSER                   /* RSER register */
        pDSPI2->RSER.R          = DSPI2_RSER;
    #endif

    /*--------------------------------------------------------------------------
     * DSPI3 Control registers
    --------------------------------------------------------------------------*/
    #ifdef DSPI3_TCR                   /* TCR register */
        pDSPI3->TCR.R           = DSPI3_TCR;
    #endif

    #ifdef DSPI3_CTAR0                   /* CTAR[0] register */
        pDSPI3->CTAR[0].R       = DSPI3_CTAR0;
    #endif

    #ifdef DSPI3_CTAR1                   /* CTAR[1] register */
        pDSPI3->CTAR[1].R       = DSPI3_CTAR1;
    #endif

    #ifdef DSPI3_CTAR2                   /* CTAR[2] register */
        pDSPI3->CTAR[2].R       = DSPI3_CTAR2;
    #endif

    #ifdef DSPI3_CTAR3                   /* CTAR[3] register */
        pDSPI3->CTAR[3].R       = DSPI3_CTAR3;
    #endif

    #ifdef DSPI3_CTAR4                   /* CTAR[4] register */
        pDSPI3->CTAR[4].R       = DSPI3_CTAR4;
    #endif

    #ifdef DSPI3_CTAR5                   /* CTAR[5] register */
        pDSPI3->CTAR[5].R       = DSPI3_CTAR5;
    #endif

    #ifdef DSPI3_CTAR6                   /* CTAR[6] register */
        pDSPI3->CTAR[6].R       = DSPI3_CTAR6;
    #endif

    #ifdef DSPI3_CTAR7                   /* CTAR[7] register */
        pDSPI3->CTAR[7].R       = DSPI3_CTAR7;
    #endif

    #ifdef DSPI3_RSER                   /* RSER register */
        pDSPI3->RSER.R          = DSPI3_RSER;
    #endif

    #ifdef DSPI3_MCR                  /* MCR register */
        pDSPI3->MCR.R           = DSPI3_MCR;
    #endif

    /*--------------------------------------------------------------------------
     * DSPI4 Control registers
    --------------------------------------------------------------------------*/
    #ifdef DSPI4_TCR                   /* TCR register */
        pDSPI4->TCR.R           = DSPI4_TCR;
    #endif

    #ifdef DSPI4_CTAR0                   /* CTAR[0] register */
        pDSPI4->CTAR[0].R       = DSPI4_CTAR0;
    #endif

    #ifdef DSPI4_CTAR1                   /* CTAR[1] register */
        pDSPI4->CTAR[1].R       = DSPI4_CTAR1;
    #endif

    #ifdef DSPI4_CTAR2                   /* CTAR[2] register */
        pDSPI4->CTAR[2].R       = DSPI4_CTAR2;
    #endif

    #ifdef DSPI4_CTAR3                   /* CTAR[3] register */
        pDSPI4->CTAR[3].R       = DSPI4_CTAR3;
    #endif

    #ifdef DSPI4_CTAR4                   /* CTAR[4] register */
        pDSPI4->CTAR[4].R       = DSPI4_CTAR4;
    #endif

    #ifdef DSPI4_CTAR5                   /* CTAR[5] register */
        pDSPI4->CTAR[5].R       = DSPI4_CTAR5;
    #endif

    #ifdef DSPI4_CTAR6                   /* CTAR[6] register */
        pDSPI4->CTAR[6].R       = DSPI4_CTAR6;
    #endif

    #ifdef DSPI4_CTAR7                   /* CTAR[7] register */
        pDSPI4->CTAR[7].R       = DSPI4_CTAR7;
    #endif

    #ifdef DSPI4_RSER                   /* RSER register */
        pDSPI4->RSER.R          = DSPI4_RSER;
    #endif

    #ifdef DSPI4_MCR                  /* MCR register */
        pDSPI4->MCR.R           = DSPI4_MCR;
    #endif
}