/*******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2012 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
****************************************************************************//*!
*
* @file     emios.c
*
* @author   b06050
*
* @version  1.0.2.0
*
* @date     Aug-3-2012
*
* @brief    eMIOS - eMIOS module on MPC5606B
*
********************************************************************************
*
* This file includes initial setting functions of MPC5606B eMIOS modules.
*
*******************************************************************************/
#include "MPC5606B.h"
#include "emios.h"
#include "MPC5606B_appconfig.h"
#include "BLDC_appconfig.h"

/***************************************************************************//*!
@brief          eMIOS_0 initialization function

@param[in,out]  void
@param[in]      void

@return         void

@details        This function initializes eMIOS_0 module.
*******************************************************************************/
void emios0_init(void)
{
    static uint8_t i;

    pEMIOS0=(struct EMIOS_tag *)&EMIOS_0;

    /*--------------------------------------------------------------------------
     * eMIOS0 Reset
    --------------------------------------------------------------------------*/
    pEMIOS0->MCR.R            = 0x0;
    pEMIOS0->OUDR.R           = 0x0;
    pEMIOS0->UCDIS.R          = 0x0;

    for (i=0;i<=32;i++)
    {
        pEMIOS0->CH[i].CCR.R  = 0x0;
    }

    /*--------------------------------------------------------------------------
     * eMIOS0 Control registers
    --------------------------------------------------------------------------*/
    #ifdef EMIOS0_MCR                   /* MCR register */
        pEMIOS0->MCR.R        = EMIOS0_MCR;
    #endif

    #ifdef EMIOS0_OUDR                  /* OUDR register */
        pEMIOS0->OUDR.R       = EMIOS0_OUDR;
    #endif

    #ifdef EMIOS0_UCDIS                 /* UCDIS register */
        pEMIOS0->UCDIS.R      = EMIOS0_UCDIS;
    #endif

    /*--------------------------------------------------------------------------
     * eMIOS0 unified channel 0 registers
    --------------------------------------------------------------------------*/
    #ifdef EMIOS0_UC0_CADR              /* CADR register */
        pEMIOS0->CH[0].CADR.R       = EMIOS0_UC0_CADR;
    #endif

    #ifdef EMIOS0_UC0_CBDR              /* CBDR register */
        pEMIOS0->CH[0].CBDR.R       = EMIOS0_UC0_CBDR;
    #endif

    #ifdef EMIOS0_UC0_CCR               /* CCR register */
        pEMIOS0->CH[0].CCR.R        = EMIOS0_UC0_CCR;
    #endif

    #ifdef EMIOS0_UC0_CSR               /* CSR register */
        pEMIOS0->CH[0].CSR.R        = EMIOS0_UC0_CSR;
    #endif

    #ifdef EMIOS0_UC0_ALTCADR            /* ALTCADR register */
        pEMIOS0->CH[0].ALTCADR.R    = EMIOS0_UC0_ALTCADR;
    #endif

    /*--------------------------------------------------------------------------
     * eMIOS0 unified channel 1 registers
    --------------------------------------------------------------------------*/
    #ifdef EMIOS0_UC1_CADR              /* CADR register */
        pEMIOS0->CH[1].CADR.R       = EMIOS0_UC1_CADR;
    #endif

    #ifdef EMIOS0_UC1_CBDR              /* CBDR register */
        pEMIOS0->CH[1].CBDR.R       = EMIOS0_UC1_CBDR;
    #endif

    #ifdef EMIOS0_UC1_CCR               /* CCR register */
        pEMIOS0->CH[1].CCR.R        = EMIOS0_UC1_CCR;
    #endif

    #ifdef EMIOS0_UC1_CSR               /* CSR register */
        pEMIOS0->CH[1].CSR.R        = EMIOS0_UC1_CSR;
    #endif

    #ifdef EMIOS0_UC1_ALTCADR            /* ALTCADR register */
        pEMIOS0->CH[1].ALTCADR.R    = EMIOS0_UC1_ALTCADR;
    #endif

    /*--------------------------------------------------------------------------
     * eMIOS0 unified channel 2 registers
    --------------------------------------------------------------------------*/
    #ifdef EMIOS0_UC2_CADR              /* CADR register */
        pEMIOS0->CH[2].CADR.R       = EMIOS0_UC2_CADR;
    #endif

    #ifdef EMIOS0_UC2_CBDR              /* CBDR register */
        pEMIOS0->CH[2].CBDR.R       = EMIOS0_UC2_CBDR;
    #endif

    #ifdef EMIOS0_UC2_CCR               /* CCR register */
        pEMIOS0->CH[2].CCR.R        = EMIOS0_UC2_CCR;
    #endif

    #ifdef EMIOS0_UC2_CSR               /* CSR register */
        pEMIOS0->CH[2].CSR.R        = EMIOS0_UC2_CSR;
    #endif

    #ifdef EMIOS0_UC2_ALTCADR            /* ALTCADR register */
        pEMIOS0->CH[2].ALTCADR.R    = EMIOS0_UC2_ALTCADR;
    #endif

    /*--------------------------------------------------------------------------
     * eMIOS0 unified channel 3 registers
    --------------------------------------------------------------------------*/
    #ifdef EMIOS0_UC3_CADR              /* CADR register */
        pEMIOS0->CH[3].CADR.R       = EMIOS0_UC3_CADR;
    #endif

    #ifdef EMIOS0_UC3_CBDR              /* CBDR register */
        pEMIOS0->CH[3].CBDR.R       = EMIOS0_UC3_CBDR;
    #endif

    #ifdef EMIOS0_UC3_CCR               /* CCR register */
        pEMIOS0->CH[3].CCR.R        = EMIOS0_UC3_CCR;
    #endif

    #ifdef EMIOS0_UC3_CSR               /* CSR register */
        pEMIOS0->CH[3].CSR.R        = EMIOS0_UC3_CSR;
    #endif

    #ifdef EMIOS0_UC3_ALTCADR            /* ALTCADR register */
        pEMIOS0->CH[3].ALTCADR.R    = EMIOS0_UC3_ALTCADR;
    #endif

    /*--------------------------------------------------------------------------
     * eMIOS0 unified channel 4 registers
    --------------------------------------------------------------------------*/
    #ifdef EMIOS0_UC4_CADR              /* CADR register */
        pEMIOS0->CH[4].CADR.R       = EMIOS0_UC4_CADR;
    #endif

    #ifdef EMIOS0_UC4_CBDR              /* CBDR register */
        pEMIOS0->CH[4].CBDR.R       = EMIOS0_UC4_CBDR;
    #endif

    #ifdef EMIOS0_UC4_CCR               /* CCR register */
        pEMIOS0->CH[4].CCR.R        = EMIOS0_UC4_CCR;
    #endif

    #ifdef EMIOS0_UC4_CSR               /* CSR register */
        pEMIOS0->CH[4].CSR.R        = EMIOS0_UC4_CSR;
    #endif

    #ifdef EMIOS0_UC4_ALTCADR            /* ALTCADR register */
        pEMIOS0->CH[4].ALTCADR.R    = EMIOS0_UC4_ALTCADR;
    #endif

    /*--------------------------------------------------------------------------
     * eMIOS0 unified channel 5 registers
    --------------------------------------------------------------------------*/
    #ifdef EMIOS0_UC5_CADR              /* CADR register */
        pEMIOS0->CH[5].CADR.R       = EMIOS0_UC5_CADR;
    #endif

    #ifdef EMIOS0_UC5_CBDR              /* CBDR register */
        pEMIOS0->CH[5].CBDR.R       = EMIOS0_UC5_CBDR;
    #endif

    #ifdef EMIOS0_UC5_CCR               /* CCR register */
        pEMIOS0->CH[5].CCR.R        = EMIOS0_UC5_CCR;
    #endif

    #ifdef EMIOS0_UC5_CSR               /* CSR register */
        pEMIOS0->CH[5].CSR.R        = EMIOS0_UC5_CSR;
    #endif

    #ifdef EMIOS0_UC5_ALTCADR            /* ALTCADR register */
        pEMIOS0->CH[5].ALTCADR.R    = EMIOS0_UC5_ALTCADR;
    #endif

    /*--------------------------------------------------------------------------
     * eMIOS0 unified channel 6 registers
    --------------------------------------------------------------------------*/
    #ifdef EMIOS0_UC6_CADR              /* CADR register */
        pEMIOS0->CH[6].CADR.R       = EMIOS0_UC6_CADR;
    #endif

    #ifdef EMIOS0_UC6_CBDR              /* CBDR register */
        pEMIOS0->CH[6].CBDR.R       = EMIOS0_UC6_CBDR;
    #endif

    #ifdef EMIOS0_UC6_CCR               /* CCR register */
        pEMIOS0->CH[6].CCR.R        = EMIOS0_UC6_CCR;
    #endif

    #ifdef EMIOS0_UC6_CSR               /* CSR register */
        pEMIOS0->CH[6].CSR.R        = EMIOS0_UC6_CSR;
    #endif

    #ifdef EMIOS0_UC6_ALTCADR            /* ALTCADR register */
        pEMIOS0->CH[6].ALTCADR.R    = EMIOS0_UC6_ALTCADR;
    #endif

    /*--------------------------------------------------------------------------
     * eMIOS0 unified channel 7 registers
    --------------------------------------------------------------------------*/
    #ifdef EMIOS0_UC7_CADR              /* CADR register */
        pEMIOS0->CH[7].CADR.R       = EMIOS0_UC7_CADR;
    #endif

    #ifdef EMIOS0_UC7_CBDR              /* CBDR register */
        pEMIOS0->CH[7].CBDR.R       = EMIOS0_UC7_CBDR;
    #endif

    #ifdef EMIOS0_UC7_CCR               /* CCR register */
        pEMIOS0->CH[7].CCR.R        = EMIOS0_UC7_CCR;
    #endif

    #ifdef EMIOS0_UC7_CSR               /* CSR register */
        pEMIOS0->CH[7].CSR.R        = EMIOS0_UC7_CSR;
    #endif

    #ifdef EMIOS0_UC7_ALTCADR            /* ALTCADR register */
        pEMIOS0->CH[7].ALTCADR.R    = EMIOS0_UC7_ALTCADR;
    #endif

    /*--------------------------------------------------------------------------
     * eMIOS0 unified channel 8 registers
    --------------------------------------------------------------------------*/
    #ifdef EMIOS0_UC8_CADR              /* CADR register */
        pEMIOS0->UC[8].CADR.R       = EMIOS0_UC8_CADR;
    #endif

    #ifdef EMIOS0_UC8_CBDR              /* CBDR register */
        pEMIOS0->UC[8].CBDR.R       = EMIOS0_UC8_CBDR;
    #endif

    #ifdef EMIOS0_UC8_CCR               /* CCR register */
        pEMIOS0->UC[8].CCR.R        = EMIOS0_UC8_CCR;
    #endif

    #ifdef EMIOS0_UC8_CSR               /* CSR register */
        pEMIOS0->UC[8].CSR.R        = EMIOS0_UC8_CSR;
    #endif

    #ifdef EMIOS0_UC8_ALTCADR            /* ALTCADR register */
        pEMIOS0->UC[8].ALTCADR.R    = EMIOS0_UC8_ALTCADR;
    #endif

    /*--------------------------------------------------------------------------
     * eMIOS0 unified channel 9 registers
    --------------------------------------------------------------------------*/
    #ifdef EMIOS0_UC9_CADR              /* CADR register */
        pEMIOS0->CH[9].CADR.R       = EMIOS0_UC9_CADR;
    #endif

    #ifdef EMIOS0_UC9_CBDR              /* CBDR register */
        pEMIOS0->CH[9].CBDR.R       = EMIOS0_UC9_CBDR;
    #endif

    #ifdef EMIOS0_UC9_CCR               /* CCR register */
        pEMIOS0->CH[9].CCR.R        = EMIOS0_UC9_CCR;
    #endif

    #ifdef EMIOS0_UC9_CSR               /* CSR register */
        pEMIOS0->CH[9].CSR.R        = EMIOS0_UC9_CSR;
    #endif

    #ifdef EMIOS0_UC9_ALTCADR            /* ALTCADR register */
        pEMIOS0->CH[9].ALTCADR.R    = EMIOS0_UC9_ALTCADR;
    #endif

    /*--------------------------------------------------------------------------
     * eMIOS0 unified channel 10 registers
    --------------------------------------------------------------------------*/
    #ifdef EMIOS0_UC10_CADR              /* CADR register */
        pEMIOS0->CH[10].CADR.R       = EMIOS0_UC10_CADR;
    #endif

    #ifdef EMIOS0_UC10_CBDR              /* CBDR register */
        pEMIOS0->CH[10].CBDR.R       = EMIOS0_UC10_CBDR;
    #endif

    #ifdef EMIOS0_UC10_CCR               /* CCR register */
        pEMIOS0->CH[10].CCR.R        = EMIOS0_UC10_CCR;
    #endif

    #ifdef EMIOS0_UC10_CSR               /* CSR register */
        pEMIOS0->CH[10].CSR.R        = EMIOS0_UC10_CSR;
    #endif

    #ifdef EMIOS0_UC10_ALTCADR            /* ALTCADR register */
        pEMIOS0->CH[10].ALTCADR.R    = EMIOS0_UC10_ALTCADR;
    #endif

    /*--------------------------------------------------------------------------
     * eMIOS0 unified channel 11 registers
    --------------------------------------------------------------------------*/
    #ifdef EMIOS0_UC11_CADR              /* CADR register */
        pEMIOS0->CH[11].CADR.R       = EMIOS0_UC11_CADR;
    #endif

    #ifdef EMIOS0_UC11_CBDR              /* CBDR register */
        pEMIOS0->CH[11].CBDR.R       = EMIOS0_UC11_CBDR;
    #endif

    #ifdef EMIOS0_UC11_CCR               /* CCR register */
        pEMIOS0->CH[11].CCR.R        = EMIOS0_UC11_CCR;
    #endif

    #ifdef EMIOS0_UC11_CSR               /* CSR register */
        pEMIOS0->CH[11].CSR.R        = EMIOS0_UC11_CSR;
    #endif

    #ifdef EMIOS0_UC11_ALTCADR            /* ALTCADR register */
        pEMIOS0->CH[11].ALTCADR.R    = EMIOS0_UC11_ALTCADR;
    #endif

    /*--------------------------------------------------------------------------
     * eMIOS0 unified channel 12 registers
    --------------------------------------------------------------------------*/
    #ifdef EMIOS0_UC12_CADR              /* CADR register */
        pEMIOS0->CH[12].CADR.R       = EMIOS0_UC12_CADR;
    #endif

    #ifdef EMIOS0_UC12_CBDR              /* CBDR register */
        pEMIOS0->CH[12].CBDR.R       = EMIOS0_UC12_CBDR;
    #endif

    #ifdef EMIOS0_UC12_CCR               /* CCR register */
        pEMIOS0->CH[12].CCR.R        = EMIOS0_UC12_CCR;
    #endif

    #ifdef EMIOS0_UC12_CSR               /* CSR register */
        pEMIOS0->CH[12].CSR.R        = EMIOS0_UC12_CSR;
    #endif

    #ifdef EMIOS0_UC12_ALTCADR            /* ALTCADR register */
        pEMIOS0->CH[12].ALTCADR.R    = EMIOS0_UC12_ALTCADR;
    #endif

    /*--------------------------------------------------------------------------
     * eMIOS0 unified channel 13 registers
    --------------------------------------------------------------------------*/
    #ifdef EMIOS0_UC13_CADR              /* CADR register */
        pEMIOS0->CH[13].CADR.R       = EMIOS0_UC13_CADR;
    #endif

    #ifdef EMIOS0_UC13_CBDR              /* CBDR register */
        pEMIOS0->CH[13].CBDR.R       = EMIOS0_UC13_CBDR;
    #endif

    #ifdef EMIOS0_UC13_CCR               /* CCR register */
        pEMIOS0->CH[13].CCR.R        = EMIOS0_UC13_CCR;
    #endif

    #ifdef EMIOS0_UC13_CSR               /* CSR register */
        pEMIOS0->CH[13].CSR.R        = EMIOS0_UC13_CSR;
    #endif

    #ifdef EMIOS0_UC13_ALTCADR            /* ALTCADR register */
        pEMIOS0->CH[13].ALTCADR.R    = EMIOS0_UC13_ALTCADR;
    #endif

    /*--------------------------------------------------------------------------
     * eMIOS0 unified channel 14 registers
    --------------------------------------------------------------------------*/
    #ifdef EMIOS0_UC14_CADR              /* CADR register */
        pEMIOS0->CH[14].CADR.R       = EMIOS0_UC14_CADR;
    #endif

    #ifdef EMIOS0_UC14_CBDR              /* CBDR register */
        pEMIOS0->CH[14].CBDR.R       = EMIOS0_UC14_CBDR;
    #endif

    #ifdef EMIOS0_UC14_CCR               /* CCR register */
        pEMIOS0->CH[14].CCR.R        = EMIOS0_UC14_CCR;
    #endif

    #ifdef EMIOS0_UC14_CSR               /* CSR register */
        pEMIOS0->CH[14].CSR.R        = EMIOS0_UC14_CSR;
    #endif

    #ifdef EMIOS0_UC14_ALTCADR            /* ALTCADR register */
        pEMIOS0->CH[14].ALTCADR.R    = EMIOS0_UC14_ALTCADR;
    #endif

    /*--------------------------------------------------------------------------
     * eMIOS0 unified channel 15 registers
    --------------------------------------------------------------------------*/
    #ifdef EMIOS0_UC15_CADR              /* CADR register */
        pEMIOS0->CH[15].CADR.R       = EMIOS0_UC15_CADR;
    #endif

    #ifdef EMIOS0_UC15_CBDR              /* CBDR register */
        pEMIOS0->CH[15].CBDR.R       = EMIOS0_UC15_CBDR;
    #endif

    #ifdef EMIOS0_UC15_CCR               /* CCR register */
        pEMIOS0->CH[15].CCR.R        = EMIOS0_UC15_CCR;
    #endif

    #ifdef EMIOS0_UC15_CSR               /* CSR register */
        pEMIOS0->CH[15].CSR.R        = EMIOS0_UC15_CSR;
    #endif

    #ifdef EMIOS0_UC15_ALTCADR            /* ALTCADR register */
        pEMIOS0->CH[15].ALTCADR.R    = EMIOS0_UC15_ALTCADR;
    #endif

    /*--------------------------------------------------------------------------
     * eMIOS0 unified channel 16 registers
    --------------------------------------------------------------------------*/
    #ifdef EMIOS0_UC16_CADR              /* CADR register */
        pEMIOS0->CH[16].CADR.R       = EMIOS0_UC16_CADR;
    #endif

    #ifdef EMIOS0_UC16_CBDR              /* CBDR register */
        pEMIOS0->CH[16].CBDR.R       = EMIOS0_UC16_CBDR;
    #endif

    #ifdef EMIOS0_UC16_CCR               /* CCR register */
        pEMIOS0->CH[16].CCR.R        = EMIOS0_UC16_CCR;
    #endif

    #ifdef EMIOS0_UC16_CSR               /* CSR register */
        pEMIOS0->CH[16].CSR.R        = EMIOS0_UC16_CSR;
    #endif

    #ifdef EMIOS0_UC16_ALTCADR            /* ALTCADR register */
        pEMIOS0->CH[16].ALTCADR.R    = EMIOS0_UC16_ALTCADR;
    #endif

    /*--------------------------------------------------------------------------
     * eMIOS0 unified channel 17 registers
    --------------------------------------------------------------------------*/
    #ifdef EMIOS0_UC17_CADR              /* CADR register */
        pEMIOS0->CH[17].CADR.R       = EMIOS0_UC17_CADR;
    #endif

    #ifdef EMIOS0_UC17_CBDR              /* CBDR register */
        pEMIOS0->CH[17].CBDR.R       = EMIOS0_UC17_CBDR;
    #endif

    #ifdef EMIOS0_UC17_CCR               /* CCR register */
        pEMIOS0->CH[17].CCR.R        = EMIOS0_UC17_CCR;
    #endif

    #ifdef EMIOS0_UC17_CSR               /* CSR register */
        pEMIOS0->CH[17].CSR.R        = EMIOS0_UC17_CSR;
    #endif

    #ifdef EMIOS0_UC17_ALTCADR            /* ALTCADR register */
        pEMIOS0->CH[17].ALTCADR.R    = EMIOS0_UC17_ALTCADR;
    #endif

    /*--------------------------------------------------------------------------
     * eMIOS0 unified channel 18 registers
    --------------------------------------------------------------------------*/
    #ifdef EMIOS0_UC18_CADR              /* CADR register */
        pEMIOS0->CH[18].CADR.R       = EMIOS0_UC18_CADR;
    #endif

    #ifdef EMIOS0_UC18_CBDR              /* CBDR register */
        pEMIOS0->CH[18].CBDR.R       = EMIOS0_UC18_CBDR;
    #endif

    #ifdef EMIOS0_UC18_CCR               /* CCR register */
        pEMIOS0->CH[18].CCR.R        = EMIOS0_UC18_CCR;
    #endif

    #ifdef EMIOS0_UC18_CSR               /* CSR register */
        pEMIOS0->CH[18].CSR.R        = EMIOS0_UC18_CSR;
    #endif

    #ifdef EMIOS0_UC18_ALTCADR            /* ALTCADR register */
        pEMIOS0->CH[18].ALTCADR.R    = EMIOS0_UC18_ALTCADR;
    #endif

    /*--------------------------------------------------------------------------
     * eMIOS0 unified channel 19 registers
    --------------------------------------------------------------------------*/
    #ifdef EMIOS0_UC19_CADR              /* CADR register */
        pEMIOS0->CH[19].CADR.R       = EMIOS0_UC19_CADR;
    #endif

    #ifdef EMIOS0_UC19_CBDR              /* CBDR register */
        pEMIOS0->CH[19].CBDR.R       = EMIOS0_UC19_CBDR;
    #endif

    #ifdef EMIOS0_UC19_CCR               /* CCR register */
        pEMIOS0->CH[19].CCR.R        = EMIOS0_UC19_CCR;
    #endif

    #ifdef EMIOS0_UC19_CSR               /* CSR register */
        pEMIOS0->CH[19].CSR.R        = EMIOS0_UC19_CSR;
    #endif

    #ifdef EMIOS0_UC19_ALTCADR            /* ALTCADR register */
        pEMIOS0->CH[19].ALTCADR.R    = EMIOS0_UC19_ALTCADR;
    #endif

    /*--------------------------------------------------------------------------
     * eMIOS0 unified channel 20 registers
    --------------------------------------------------------------------------*/
    #ifdef EMIOS0_UC20_CADR              /* CADR register */
        pEMIOS0->CH[20].CADR.R       = EMIOS0_UC20_CADR;
    #endif

    #ifdef EMIOS0_UC20_CBDR              /* CBDR register */
        pEMIOS0->CH[20].CBDR.R       = EMIOS0_UC20_CBDR;
    #endif

    #ifdef EMIOS0_UC20_CCR               /* CCR register */
        pEMIOS0->CH[20].CCR.R        = EMIOS0_UC20_CCR;
    #endif

    #ifdef EMIOS0_UC20_CSR               /* CSR register */
        pEMIOS0->CH[20].CSR.R        = EMIOS0_UC20_CSR;
    #endif

    #ifdef EMIOS0_UC20_ALTCADR            /* ALTCADR register */
        pEMIOS0->CH[20].ALTCADR.R    = EMIOS0_UC20_ALTCADR;
    #endif

    /*--------------------------------------------------------------------------
     * eMIOS0 unified channel 21 registers
    --------------------------------------------------------------------------*/
    #ifdef EMIOS0_UC21_CADR              /* CADR register */
        pEMIOS0->CH[21].CADR.R       = EMIOS0_UC21_CADR;
    #endif

    #ifdef EMIOS0_UC21_CBDR              /* CBDR register */
        pEMIOS0->CH[21].CBDR.R       = EMIOS0_UC21_CBDR;
    #endif

    #ifdef EMIOS0_UC21_CCR               /* CCR register */
        pEMIOS0->CH[21].CCR.R        = EMIOS0_UC21_CCR;
    #endif

    #ifdef EMIOS0_UC21_CSR               /* CSR register */
        pEMIOS0->CH[21].CSR.R        = EMIOS0_UC21_CSR;
    #endif

    #ifdef EMIOS0_UC21_ALTCADR            /* ALTCADR register */
        pEMIOS0->CH[21].ALTCADR.R    = EMIOS0_UC21_ALTCADR;
    #endif

    /*--------------------------------------------------------------------------
     * eMIOS0 unified channel 22 registers
    --------------------------------------------------------------------------*/
    #ifdef EMIOS0_UC22_CADR              /* CADR register */
        pEMIOS0->CH[22].CADR.R       = EMIOS0_UC22_CADR;
    #endif

    #ifdef EMIOS0_UC22_CBDR              /* CBDR register */
        pEMIOS0->CH[22].CBDR.R       = EMIOS0_UC22_CBDR;
    #endif

    #ifdef EMIOS0_UC22_CCR               /* CCR register */
        pEMIOS0->CH[22].CCR.R        = EMIOS0_UC22_CCR;
    #endif

    #ifdef EMIOS0_UC22_CSR               /* CSR register */
        pEMIOS0->CH[22].CSR.R        = EMIOS0_UC22_CSR;
    #endif

    #ifdef EMIOS0_UC22_ALTCADR            /* ALTCADR register */
        pEMIOS0->CH[22].ALTCADR.R    = EMIOS0_UC22_ALTCADR;
    #endif

    /*--------------------------------------------------------------------------
     * eMIOS0 unified channel 23 registers
    --------------------------------------------------------------------------*/
    #ifdef EMIOS0_UC23_CADR              /* CADR register */
        pEMIOS0->CH[23].CADR.R       = EMIOS0_UC23_CADR;
    #endif

    #ifdef EMIOS0_UC23_CBDR              /* CBDR register */
        pEMIOS0->CH[23].CBDR.R       = EMIOS0_UC23_CBDR;
    #endif

    #ifdef EMIOS0_UC23_CCR               /* CCR register */
        pEMIOS0->CH[23].CCR.R        = EMIOS0_UC23_CCR;
    #endif

    #ifdef EMIOS0_UC23_CSR               /* CSR register */
        pEMIOS0->CH[23].CSR.R        = EMIOS0_UC23_CSR;
    #endif

    #ifdef EMIOS0_UC23_ALTCADR            /* ALTCADR register */
        pEMIOS0->CH[23].ALTCADR.R    = EMIOS0_UC23_ALTCADR;
    #endif

    /*--------------------------------------------------------------------------
     * eMIOS0 unified channel 24 registers
    --------------------------------------------------------------------------*/
    #ifdef EMIOS0_UC24_CADR              /* CADR register */
        pEMIOS0->UC[24].CADR.R       = EMIOS0_UC24_CADR;
    #endif

    #ifdef EMIOS0_UC24_CBDR              /* CBDR register */
        pEMIOS0->UC[24].CBDR.R       = EMIOS0_UC24_CBDR;
    #endif

    #ifdef EMIOS0_UC24_CCR               /* CCR register */
        pEMIOS0->UC[24].CCR.R        = EMIOS0_UC24_CCR;
    #endif

    #ifdef EMIOS0_UC24_CSR               /* CSR register */
        pEMIOS0->UC[24].CSR.R        = EMIOS0_UC24_CSR;
    #endif

    #ifdef EMIOS0_UC24_ALTCADR            /* ALTCADR register */
        pEMIOS0->UC[24].ALTCADR.R    = EMIOS0_UC24_ALTCADR;
    #endif

    /*--------------------------------------------------------------------------
     * eMIOS0 unified channel 25 registers
    --------------------------------------------------------------------------*/
    #ifdef EMIOS0_UC25_CADR              /* CADR register */
        pEMIOS0->CH[25].CADR.R       = EMIOS0_UC25_CADR;
    #endif

    #ifdef EMIOS0_UC25_CBDR              /* CBDR register */
        pEMIOS0->CH[25].CBDR.R       = EMIOS0_UC25_CBDR;
    #endif

    #ifdef EMIOS0_UC25_CCR               /* CCR register */
        pEMIOS0->CH[25].CCR.R        = EMIOS0_UC25_CCR;
    #endif

    #ifdef EMIOS0_UC25_CSR               /* CSR register */
        pEMIOS0->CH[25].CSR.R        = EMIOS0_UC25_CSR;
    #endif

    #ifdef EMIOS0_UC25_ALTCADR            /* ALTCADR register */
        pEMIOS0->CH[25].ALTCADR.R    = EMIOS0_UC25_ALTCADR;
    #endif

    /*--------------------------------------------------------------------------
     * eMIOS0 unified channel 26 registers
    --------------------------------------------------------------------------*/
    #ifdef EMIOS0_UC26_CADR              /* CADR register */
        pEMIOS0->CH[26].CADR.R       = EMIOS0_UC26_CADR;
    #endif

    #ifdef EMIOS0_UC26_CBDR              /* CBDR register */
        pEMIOS0->CH[26].CBDR.R       = EMIOS0_UC26_CBDR;
    #endif

    #ifdef EMIOS0_UC26_CCR               /* CCR register */
        pEMIOS0->CH[26].CCR.R        = EMIOS0_UC26_CCR;
    #endif

    #ifdef EMIOS0_UC26_CSR               /* CSR register */
        pEMIOS0->CH[26].CSR.R        = EMIOS0_UC26_CSR;
    #endif

    #ifdef EMIOS0_UC26_ALTCADR            /* ALTCADR register */
        pEMIOS0->CH[26].ALTCADR.R    = EMIOS0_UC26_ALTCADR;
    #endif

    /*--------------------------------------------------------------------------
     * eMIOS0 unified channel 27 registers
    --------------------------------------------------------------------------*/
    #ifdef EMIOS0_UC27_CADR              /* CADR register */
        pEMIOS0->CH[27].CADR.R       = EMIOS0_UC27_CADR;
    #endif

    #ifdef EMIOS0_UC27_CBDR              /* CBDR register */
        pEMIOS0->CH[27].CBDR.R       = EMIOS0_UC27_CBDR;
    #endif

    #ifdef EMIOS0_UC27_CCR               /* CCR register */
        pEMIOS0->CH[27].CCR.R        = EMIOS0_UC27_CCR;
    #endif

    #ifdef EMIOS0_UC27_CSR               /* CSR register */
        pEMIOS0->CH[27].CSR.R        = EMIOS0_UC27_CSR;
    #endif

    #ifdef EMIOS0_UC27_ALTCADR            /* ALTCADR register */
        pEMIOS0->CH[27].ALTCADR.R    = EMIOS0_UC27_ALTCADR;
    #endif

    /*--------------------------------------------------------------------------
     * eMIOS0 unified channel 28 registers
    --------------------------------------------------------------------------*/
    #ifdef EMIOS0_UC28_CADR              /* CADR register */
        pEMIOS0->CH[28].CADR.R       = EMIOS0_UC28_CADR;
    #endif

    #ifdef EMIOS0_UC28_CBDR              /* CBDR register */
        pEMIOS0->CH[28].CBDR.R       = EMIOS0_UC28_CBDR;
    #endif

    #ifdef EMIOS0_UC28_CCR               /* CCR register */
        pEMIOS0->CH[28].CCR.R        = EMIOS0_UC28_CCR;
    #endif

    #ifdef EMIOS0_UC28_CSR               /* CSR register */
        pEMIOS0->CH[28].CSR.R        = EMIOS0_UC28_CSR;
    #endif

    #ifdef EMIOS0_UC28_ALTCADR            /* ALTCADR register */
        pEMIOS0->CH[28].ALTCADR.R    = EMIOS0_UC28_ALTCADR;
    #endif

    /*--------------------------------------------------------------------------
     * eMIOS0 unified channel 29 registers
    --------------------------------------------------------------------------*/
    #ifdef EMIOS0_UC29_CADR              /* CADR register */
        pEMIOS0->CH[29].CADR.R       = EMIOS0_UC29_CADR;
    #endif

    #ifdef EMIOS0_UC29_CBDR              /* CBDR register */
        pEMIOS0->CH[29].CBDR.R       = EMIOS0_UC29_CBDR;
    #endif

    #ifdef EMIOS0_UC29_CCR               /* CCR register */
        pEMIOS0->CH[29].CCR.R        = EMIOS0_UC29_CCR;
    #endif

    #ifdef EMIOS0_UC29_CSR               /* CSR register */
        pEMIOS0->CH[29].CSR.R        = EMIOS0_UC29_CSR;
    #endif

    #ifdef EMIOS0_UC29_ALTCADR            /* ALTCADR register */
        pEMIOS0->CH[29].ALTCADR.R    = EMIOS0_UC29_ALTCADR;
    #endif

    /*--------------------------------------------------------------------------
     * eMIOS0 unified channel 30 registers
    --------------------------------------------------------------------------*/
    #ifdef EMIOS0_UC30_CADR              /* CADR register */
        pEMIOS0->CH[30].CADR.R       = EMIOS0_UC30_CADR;
    #endif

    #ifdef EMIOS0_UC30_CBDR              /* CBDR register */
        pEMIOS0->CH[30].CBDR.R       = EMIOS0_UC30_CBDR;
    #endif

    #ifdef EMIOS0_UC30_CCR               /* CCR register */
        pEMIOS0->CH[30].CCR.R        = EMIOS0_UC30_CCR;
    #endif

    #ifdef EMIOS0_UC30_CSR               /* CSR register */
        pEMIOS0->CH[30].CSR.R        = EMIOS0_UC30_CSR;
    #endif

    #ifdef EMIOS0_UC30_ALTCADR            /* ALTCADR register */
        pEMIOS0->CH[30].ALTCADR.R    = EMIOS0_UC30_ALTCADR;
    #endif

    /*--------------------------------------------------------------------------
     * eMIOS0 unified channel 31 registers
    --------------------------------------------------------------------------*/
    #ifdef EMIOS0_UC31_CADR              /* CADR register */
        pEMIOS0->CH[31].CADR.R       = EMIOS0_UC31_CADR;
    #endif

    #ifdef EMIOS0_UC31_CBDR              /* CBDR register */
        pEMIOS0->CH[31].CBDR.R       = EMIOS0_UC31_CBDR;
    #endif

    #ifdef EMIOS0_UC31_CCR               /* CCR register */
        pEMIOS0->CH[31].CCR.R        = EMIOS0_UC31_CCR;
    #endif

    #ifdef EMIOS0_UC31_CSR               /* CSR register */
        pEMIOS0->CH[31].CSR.R        = EMIOS0_UC31_CSR;
    #endif

    #ifdef EMIOS0_UC31_ALTCADR            /* ALTCADR register */
        pEMIOS0->CH[31].ALTCADR.R    = EMIOS0_UC31_ALTCADR;
    #endif
}

/***************************************************************************//*!
@brief          eMIOS_1 initialization function

@param[in,out]  void
@param[in]      void

@return         void

@details        This function initializes eMIOS_1 module.
*******************************************************************************/
void emios1_init(void)
{
    static uint8_t i;

    pEMIOS1=(struct EMIOS_tag *)&EMIOS_1;

    /*--------------------------------------------------------------------------
     * eMIOS1 Reset
    --------------------------------------------------------------------------*/
    pEMIOS1->MCR.R            = 0x0;
    pEMIOS1->OUDR.R           = 0x0;
    pEMIOS1->UCDIS.R          = 0x0;

    for (i=0;i<=32;i++)
    {
        pEMIOS1->CH[i].CCR.R  = 0x0;
    }

    /*--------------------------------------------------------------------------
     * eMIOS1 Control registers
    --------------------------------------------------------------------------*/
    #ifdef EMIOS1_MCR                   /* MCR register */
        pEMIOS1->MCR.R        = EMIOS1_MCR;
    #endif

    #ifdef EMIOS1_OUDR                  /* OUDR register */
        pEMIOS1->OUDR.R       = EMIOS1_OUDR;
    #endif

    #ifdef EMIOS1_UCDIS                 /* UCDIS register */
        pEMIOS1->UCDIS.R      = EMIOS1_UCDIS;
    #endif

    /*--------------------------------------------------------------------------
     * eMIOS1 unified channel 0 registers
    --------------------------------------------------------------------------*/
    #ifdef EMIOS1_UC0_CADR              /* CADR register */
        pEMIOS1->CH[0].CADR.R       = EMIOS1_UC0_CADR;
    #endif

    #ifdef EMIOS1_UC0_CBDR              /* CBDR register */
        pEMIOS1->CH[0].CBDR.R       = EMIOS1_UC0_CBDR;
    #endif

    #ifdef EMIOS1_UC0_CCR               /* CCR register */
        pEMIOS1->CH[0].CCR.R        = EMIOS1_UC0_CCR;
    #endif

    #ifdef EMIOS1_UC0_CSR               /* CSR register */
        pEMIOS1->CH[0].CSR.R        = EMIOS1_UC0_CSR;
    #endif

    #ifdef EMIOS1_UC0_ALTCADR            /* ALTCADR register */
        pEMIOS1->CH[0].ALTCADR.R    = EMIOS1_UC0_ALTCADR;
    #endif

    /*--------------------------------------------------------------------------
     * eMIOS1 unified channel 1 registers
    --------------------------------------------------------------------------*/
    #ifdef EMIOS1_UC1_CADR              /* CADR register */
        pEMIOS1->CH[1].CADR.R       = EMIOS1_UC1_CADR;
    #endif

    #ifdef EMIOS1_UC1_CBDR              /* CBDR register */
        pEMIOS1->CH[1].CBDR.R       = EMIOS1_UC1_CBDR;
    #endif

    #ifdef EMIOS1_UC1_CCR               /* CCR register */
        pEMIOS1->CH[1].CCR.R        = EMIOS1_UC1_CCR;
    #endif

    #ifdef EMIOS1_UC1_CSR               /* CSR register */
        pEMIOS1->CH[1].CSR.R        = EMIOS1_UC1_CSR;
    #endif

    #ifdef EMIOS1_UC1_ALTCADR            /* ALTCADR register */
        pEMIOS1->CH[1].ALTCADR.R    = EMIOS1_UC1_ALTCADR;
    #endif

    /*--------------------------------------------------------------------------
     * eMIOS1 unified channel 2 registers
    --------------------------------------------------------------------------*/
    #ifdef EMIOS1_UC2_CADR              /* CADR register */
        pEMIOS1->CH[2].CADR.R       = EMIOS1_UC2_CADR;
    #endif

    #ifdef EMIOS1_UC2_CBDR              /* CBDR register */
        pEMIOS1->CH[2].CBDR.R       = EMIOS1_UC2_CBDR;
    #endif

    #ifdef EMIOS1_UC2_CCR               /* CCR register */
        pEMIOS1->CH[2].CCR.R        = EMIOS1_UC2_CCR;
    #endif

    #ifdef EMIOS1_UC2_CSR               /* CSR register */
        pEMIOS1->CH[2].CSR.R        = EMIOS1_UC2_CSR;
    #endif

    #ifdef EMIOS1_UC2_ALTCADR            /* ALTCADR register */
        pEMIOS1->CH[2].ALTCADR.R    = EMIOS1_UC2_ALTCADR;
    #endif

    /*--------------------------------------------------------------------------
     * eMIOS1 unified channel 3 registers
    --------------------------------------------------------------------------*/
    #ifdef EMIOS1_UC3_CADR              /* CADR register */
        pEMIOS1->CH[3].CADR.R       = EMIOS1_UC3_CADR;
    #endif

    #ifdef EMIOS1_UC3_CBDR              /* CBDR register */
        pEMIOS1->CH[3].CBDR.R       = EMIOS1_UC3_CBDR;
    #endif

    #ifdef EMIOS1_UC3_CCR               /* CCR register */
        pEMIOS1->CH[3].CCR.R        = EMIOS1_UC3_CCR;
    #endif

    #ifdef EMIOS1_UC3_CSR               /* CSR register */
        pEMIOS1->CH[3].CSR.R        = EMIOS1_UC3_CSR;
    #endif

    #ifdef EMIOS1_UC3_ALTCADR            /* ALTCADR register */
        pEMIOS1->CH[3].ALTCADR.R    = EMIOS1_UC3_ALTCADR;
    #endif

    /*--------------------------------------------------------------------------
     * eMIOS1 unified channel 4 registers
    --------------------------------------------------------------------------*/
    #ifdef EMIOS1_UC4_CADR              /* CADR register */
        pEMIOS1->CH[4].CADR.R       = EMIOS1_UC4_CADR;
    #endif

    #ifdef EMIOS1_UC4_CBDR              /* CBDR register */
        pEMIOS1->CH[4].CBDR.R       = EMIOS1_UC4_CBDR;
    #endif

    #ifdef EMIOS1_UC4_CCR               /* CCR register */
        pEMIOS1->CH[4].CCR.R        = EMIOS1_UC4_CCR;
    #endif

    #ifdef EMIOS1_UC4_CSR               /* CSR register */
        pEMIOS1->CH[4].CSR.R        = EMIOS1_UC4_CSR;
    #endif

    #ifdef EMIOS1_UC4_ALTCADR            /* ALTCADR register */
        pEMIOS1->CH[4].ALTCADR.R    = EMIOS1_UC4_ALTCADR;
    #endif

    /*--------------------------------------------------------------------------
     * eMIOS1 unified channel 5 registers
    --------------------------------------------------------------------------*/
    #ifdef EMIOS1_UC5_CADR              /* CADR register */
        pEMIOS1->CH[5].CADR.R       = EMIOS1_UC5_CADR;
    #endif

    #ifdef EMIOS1_UC5_CBDR              /* CBDR register */
        pEMIOS1->CH[5].CBDR.R       = EMIOS1_UC5_CBDR;
    #endif

    #ifdef EMIOS1_UC5_CCR               /* CCR register */
        pEMIOS1->CH[5].CCR.R        = EMIOS1_UC5_CCR;
    #endif

    #ifdef EMIOS1_UC5_CSR               /* CSR register */
        pEMIOS1->CH[5].CSR.R        = EMIOS1_UC5_CSR;
    #endif

    #ifdef EMIOS1_UC5_ALTCADR            /* ALTCADR register */
        pEMIOS1->CH[5].ALTCADR.R    = EMIOS1_UC5_ALTCADR;
    #endif

    /*--------------------------------------------------------------------------
     * eMIOS1 unified channel 6 registers
    --------------------------------------------------------------------------*/
    #ifdef EMIOS1_UC6_CADR              /* CADR register */
        pEMIOS1->CH[6].CADR.R       = EMIOS1_UC6_CADR;
    #endif

    #ifdef EMIOS1_UC6_CBDR              /* CBDR register */
        pEMIOS1->CH[6].CBDR.R       = EMIOS1_UC6_CBDR;
    #endif

    #ifdef EMIOS1_UC6_CCR               /* CCR register */
        pEMIOS1->CH[6].CCR.R        = EMIOS1_UC6_CCR;
    #endif

    #ifdef EMIOS1_UC6_CSR               /* CSR register */
        pEMIOS1->CH[6].CSR.R        = EMIOS1_UC6_CSR;
    #endif

    #ifdef EMIOS1_UC6_ALTCADR            /* ALTCADR register */
        pEMIOS1->CH[6].ALTCADR.R    = EMIOS1_UC6_ALTCADR;
    #endif

    /*--------------------------------------------------------------------------
     * eMIOS1 unified channel 7 registers
    --------------------------------------------------------------------------*/
    #ifdef EMIOS1_UC7_CADR              /* CADR register */
        pEMIOS1->CH[7].CADR.R       = EMIOS1_UC7_CADR;
    #endif

    #ifdef EMIOS1_UC7_CBDR              /* CBDR register */
        pEMIOS1->CH[7].CBDR.R       = EMIOS1_UC7_CBDR;
    #endif

    #ifdef EMIOS1_UC7_CCR               /* CCR register */
        pEMIOS1->CH[7].CCR.R        = EMIOS1_UC7_CCR;
    #endif

    #ifdef EMIOS1_UC7_CSR               /* CSR register */
        pEMIOS1->CH[7].CSR.R        = EMIOS1_UC7_CSR;
    #endif

    #ifdef EMIOS1_UC7_ALTCADR            /* ALTCADR register */
        pEMIOS1->CH[7].ALTCADR.R    = EMIOS1_UC7_ALTCADR;
    #endif

    /*--------------------------------------------------------------------------
     * eMIOS1 unified channel 8 registers
    --------------------------------------------------------------------------*/
    #ifdef EMIOS1_UC8_CADR              /* CADR register */
        pEMIOS1->UC[8].CADR.R       = EMIOS1_UC8_CADR;
    #endif

    #ifdef EMIOS1_UC8_CBDR              /* CBDR register */
        pEMIOS1->UC[8].CBDR.R       = EMIOS1_UC8_CBDR;
    #endif

    #ifdef EMIOS1_UC8_CCR               /* CCR register */
        pEMIOS1->UC[8].CCR.R        = EMIOS1_UC8_CCR;
    #endif

    #ifdef EMIOS1_UC8_CSR               /* CSR register */
        pEMIOS1->UC[8].CSR.R        = EMIOS1_UC8_CSR;
    #endif

    #ifdef EMIOS1_UC8_ALTCADR            /* ALTCADR register */
        pEMIOS1->UC[8].ALTCADR.R    = EMIOS1_UC8_ALTCADR;
    #endif

    /*--------------------------------------------------------------------------
     * eMIOS1 unified channel 9 registers
    --------------------------------------------------------------------------*/
    #ifdef EMIOS1_UC9_CADR              /* CADR register */
        pEMIOS1->CH[9].CADR.R       = EMIOS1_UC9_CADR;
    #endif

    #ifdef EMIOS1_UC9_CBDR              /* CBDR register */
        pEMIOS1->CH[9].CBDR.R       = EMIOS1_UC9_CBDR;
    #endif

    #ifdef EMIOS1_UC9_CCR               /* CCR register */
        pEMIOS1->CH[9].CCR.R        = EMIOS1_UC9_CCR;
    #endif

    #ifdef EMIOS1_UC9_CSR               /* CSR register */
        pEMIOS1->CH[9].CSR.R        = EMIOS1_UC9_CSR;
    #endif

    #ifdef EMIOS1_UC9_ALTCADR            /* ALTCADR register */
        pEMIOS1->CH[9].ALTCADR.R    = EMIOS1_UC9_ALTCADR;
    #endif

    /*--------------------------------------------------------------------------
     * eMIOS1 unified channel 10 registers
    --------------------------------------------------------------------------*/
    #ifdef EMIOS1_UC10_CADR              /* CADR register */
        pEMIOS1->CH[10].CADR.R       = EMIOS1_UC10_CADR;
    #endif

    #ifdef EMIOS1_UC10_CBDR              /* CBDR register */
        pEMIOS1->CH[10].CBDR.R       = EMIOS1_UC10_CBDR;
    #endif

    #ifdef EMIOS1_UC10_CCR               /* CCR register */
        pEMIOS1->CH[10].CCR.R        = EMIOS1_UC10_CCR;
    #endif

    #ifdef EMIOS1_UC10_CSR               /* CSR register */
        pEMIOS1->CH[10].CSR.R        = EMIOS1_UC10_CSR;
    #endif

    #ifdef EMIOS1_UC10_ALTCADR            /* ALTCADR register */
        pEMIOS1->CH[10].ALTCADR.R    = EMIOS1_UC10_ALTCADR;
    #endif

    /*--------------------------------------------------------------------------
     * eMIOS1 unified channel 11 registers
    --------------------------------------------------------------------------*/
    #ifdef EMIOS1_UC11_CADR              /* CADR register */
        pEMIOS1->CH[11].CADR.R       = EMIOS1_UC11_CADR;
    #endif

    #ifdef EMIOS1_UC11_CBDR              /* CBDR register */
        pEMIOS1->CH[11].CBDR.R       = EMIOS1_UC11_CBDR;
    #endif

    #ifdef EMIOS1_UC11_CCR               /* CCR register */
        pEMIOS1->CH[11].CCR.R        = EMIOS1_UC11_CCR;
    #endif

    #ifdef EMIOS1_UC11_CSR               /* CSR register */
        pEMIOS1->CH[11].CSR.R        = EMIOS1_UC11_CSR;
    #endif

    #ifdef EMIOS1_UC11_ALTCADR            /* ALTCADR register */
        pEMIOS1->CH[11].ALTCADR.R    = EMIOS1_UC11_ALTCADR;
    #endif

    /*--------------------------------------------------------------------------
     * eMIOS1 unified channel 12 registers
    --------------------------------------------------------------------------*/
    #ifdef EMIOS1_UC12_CADR              /* CADR register */
        pEMIOS1->CH[12].CADR.R       = EMIOS1_UC12_CADR;
    #endif

    #ifdef EMIOS1_UC12_CBDR              /* CBDR register */
        pEMIOS1->CH[12].CBDR.R       = EMIOS1_UC12_CBDR;
    #endif

    #ifdef EMIOS1_UC12_CCR               /* CCR register */
        pEMIOS1->CH[12].CCR.R        = EMIOS1_UC12_CCR;
    #endif

    #ifdef EMIOS1_UC12_CSR               /* CSR register */
        pEMIOS1->CH[12].CSR.R        = EMIOS1_UC12_CSR;
    #endif

    #ifdef EMIOS1_UC12_ALTCADR            /* ALTCADR register */
        pEMIOS1->CH[12].ALTCADR.R    = EMIOS1_UC12_ALTCADR;
    #endif

    /*--------------------------------------------------------------------------
     * eMIOS1 unified channel 13 registers
    --------------------------------------------------------------------------*/
    #ifdef EMIOS1_UC13_CADR              /* CADR register */
        pEMIOS1->CH[13].CADR.R       = EMIOS1_UC13_CADR;
    #endif

    #ifdef EMIOS1_UC13_CBDR              /* CBDR register */
        pEMIOS1->CH[13].CBDR.R       = EMIOS1_UC13_CBDR;
    #endif

    #ifdef EMIOS1_UC13_CCR               /* CCR register */
        pEMIOS1->CH[13].CCR.R        = EMIOS1_UC13_CCR;
    #endif

    #ifdef EMIOS1_UC13_CSR               /* CSR register */
        pEMIOS1->CH[13].CSR.R        = EMIOS1_UC13_CSR;
    #endif

    #ifdef EMIOS1_UC13_ALTCADR            /* ALTCADR register */
        pEMIOS1->CH[13].ALTCADR.R    = EMIOS1_UC13_ALTCADR;
    #endif

    /*--------------------------------------------------------------------------
     * eMIOS1 unified channel 14 registers
    --------------------------------------------------------------------------*/
    #ifdef EMIOS1_UC14_CADR              /* CADR register */
        pEMIOS1->CH[14].CADR.R       = EMIOS1_UC14_CADR;
    #endif

    #ifdef EMIOS1_UC14_CBDR              /* CBDR register */
        pEMIOS1->CH[14].CBDR.R       = EMIOS1_UC14_CBDR;
    #endif

    #ifdef EMIOS1_UC14_CCR               /* CCR register */
        pEMIOS1->CH[14].CCR.R        = EMIOS1_UC14_CCR;
    #endif

    #ifdef EMIOS1_UC14_CSR               /* CSR register */
        pEMIOS1->CH[14].CSR.R        = EMIOS1_UC14_CSR;
    #endif

    #ifdef EMIOS1_UC14_ALTCADR            /* ALTCADR register */
        pEMIOS1->CH[14].ALTCADR.R    = EMIOS1_UC14_ALTCADR;
    #endif

    /*--------------------------------------------------------------------------
     * eMIOS1 unified channel 15 registers
    --------------------------------------------------------------------------*/
    #ifdef EMIOS1_UC15_CADR              /* CADR register */
        pEMIOS1->CH[15].CADR.R       = EMIOS1_UC15_CADR;
    #endif

    #ifdef EMIOS1_UC15_CBDR              /* CBDR register */
        pEMIOS1->CH[15].CBDR.R       = EMIOS1_UC15_CBDR;
    #endif

    #ifdef EMIOS1_UC15_CCR               /* CCR register */
        pEMIOS1->CH[15].CCR.R        = EMIOS1_UC15_CCR;
    #endif

    #ifdef EMIOS1_UC15_CSR               /* CSR register */
        pEMIOS1->CH[15].CSR.R        = EMIOS1_UC15_CSR;
    #endif

    #ifdef EMIOS1_UC15_ALTCADR            /* ALTCADR register */
        pEMIOS1->CH[15].ALTCADR.R    = EMIOS1_UC15_ALTCADR;
    #endif

    /*--------------------------------------------------------------------------
     * eMIOS1 unified channel 16 registers
    --------------------------------------------------------------------------*/
    #ifdef EMIOS1_UC16_CADR              /* CADR register */
        pEMIOS1->CH[16].CADR.R       = EMIOS1_UC16_CADR;
    #endif

    #ifdef EMIOS1_UC16_CBDR              /* CBDR register */
        pEMIOS1->CH[16].CBDR.R       = EMIOS1_UC16_CBDR;
    #endif

    #ifdef EMIOS1_UC16_CCR               /* CCR register */
        pEMIOS1->CH[16].CCR.R        = EMIOS1_UC16_CCR;
    #endif

    #ifdef EMIOS1_UC16_CSR               /* CSR register */
        pEMIOS1->CH[16].CSR.R        = EMIOS1_UC16_CSR;
    #endif

    #ifdef EMIOS1_UC16_ALTCADR            /* ALTCADR register */
        pEMIOS1->CH[16].ALTCADR.R    = EMIOS1_UC16_ALTCADR;
    #endif

    /*--------------------------------------------------------------------------
     * eMIOS1 unified channel 17 registers
    --------------------------------------------------------------------------*/
    #ifdef EMIOS1_UC17_CADR              /* CADR register */
        pEMIOS1->CH[17].CADR.R       = EMIOS1_UC17_CADR;
    #endif

    #ifdef EMIOS1_UC17_CBDR              /* CBDR register */
        pEMIOS1->CH[17].CBDR.R       = EMIOS1_UC17_CBDR;
    #endif

    #ifdef EMIOS1_UC17_CCR               /* CCR register */
        pEMIOS1->CH[17].CCR.R        = EMIOS1_UC17_CCR;
    #endif

    #ifdef EMIOS1_UC17_CSR               /* CSR register */
        pEMIOS1->CH[17].CSR.R        = EMIOS1_UC17_CSR;
    #endif

    #ifdef EMIOS1_UC17_ALTCADR            /* ALTCADR register */
        pEMIOS1->CH[17].ALTCADR.R    = EMIOS1_UC17_ALTCADR;
    #endif

    /*--------------------------------------------------------------------------
     * eMIOS1 unified channel 18 registers
    --------------------------------------------------------------------------*/
    #ifdef EMIOS1_UC18_CADR              /* CADR register */
        pEMIOS1->CH[18].CADR.R       = EMIOS1_UC18_CADR;
    #endif

    #ifdef EMIOS1_UC18_CBDR              /* CBDR register */
        pEMIOS1->CH[18].CBDR.R       = EMIOS1_UC18_CBDR;
    #endif

    #ifdef EMIOS1_UC18_CCR               /* CCR register */
        pEMIOS1->CH[18].CCR.R        = EMIOS1_UC18_CCR;
    #endif

    #ifdef EMIOS1_UC18_CSR               /* CSR register */
        pEMIOS1->CH[18].CSR.R        = EMIOS1_UC18_CSR;
    #endif

    #ifdef EMIOS1_UC18_ALTCADR            /* ALTCADR register */
        pEMIOS1->CH[18].ALTCADR.R    = EMIOS1_UC18_ALTCADR;
    #endif

    /*--------------------------------------------------------------------------
     * eMIOS1 unified channel 19 registers
    --------------------------------------------------------------------------*/
    #ifdef EMIOS1_UC19_CADR              /* CADR register */
        pEMIOS1->CH[19].CADR.R       = EMIOS1_UC19_CADR;
    #endif

    #ifdef EMIOS1_UC19_CBDR              /* CBDR register */
        pEMIOS1->CH[19].CBDR.R       = EMIOS1_UC19_CBDR;
    #endif

    #ifdef EMIOS1_UC19_CCR               /* CCR register */
        pEMIOS1->CH[19].CCR.R        = EMIOS1_UC19_CCR;
    #endif

    #ifdef EMIOS1_UC19_CSR               /* CSR register */
        pEMIOS1->CH[19].CSR.R        = EMIOS1_UC19_CSR;
    #endif

    #ifdef EMIOS1_UC19_ALTCADR            /* ALTCADR register */
        pEMIOS1->CH[19].ALTCADR.R    = EMIOS1_UC19_ALTCADR;
    #endif

    /*--------------------------------------------------------------------------
     * eMIOS1 unified channel 20 registers
    --------------------------------------------------------------------------*/
    #ifdef EMIOS1_UC20_CADR              /* CADR register */
        pEMIOS1->CH[20].CADR.R       = EMIOS1_UC20_CADR;
    #endif

    #ifdef EMIOS1_UC20_CBDR              /* CBDR register */
        pEMIOS1->CH[20].CBDR.R       = EMIOS1_UC20_CBDR;
    #endif

    #ifdef EMIOS1_UC20_CCR               /* CCR register */
        pEMIOS1->CH[20].CCR.R        = EMIOS1_UC20_CCR;
    #endif

    #ifdef EMIOS1_UC20_CSR               /* CSR register */
        pEMIOS1->CH[20].CSR.R        = EMIOS1_UC20_CSR;
    #endif

    #ifdef EMIOS1_UC20_ALTCADR            /* ALTCADR register */
        pEMIOS1->CH[20].ALTCADR.R    = EMIOS1_UC20_ALTCADR;
    #endif

    /*--------------------------------------------------------------------------
     * eMIOS1 unified channel 21 registers
    --------------------------------------------------------------------------*/
    #ifdef EMIOS1_UC21_CADR              /* CADR register */
        pEMIOS1->CH[21].CADR.R       = EMIOS1_UC21_CADR;
    #endif

    #ifdef EMIOS1_UC21_CBDR              /* CBDR register */
        pEMIOS1->CH[21].CBDR.R       = EMIOS1_UC21_CBDR;
    #endif

    #ifdef EMIOS1_UC21_CCR               /* CCR register */
        pEMIOS1->CH[21].CCR.R        = EMIOS1_UC21_CCR;
    #endif

    #ifdef EMIOS1_UC21_CSR               /* CSR register */
        pEMIOS1->CH[21].CSR.R        = EMIOS1_UC21_CSR;
    #endif

    #ifdef EMIOS1_UC21_ALTCADR            /* ALTCADR register */
        pEMIOS1->CH[21].ALTCADR.R    = EMIOS1_UC21_ALTCADR;
    #endif

    /*--------------------------------------------------------------------------
     * eMIOS1 unified channel 22 registers
    --------------------------------------------------------------------------*/
    #ifdef EMIOS1_UC22_CADR              /* CADR register */
        pEMIOS1->CH[22].CADR.R       = EMIOS1_UC22_CADR;
    #endif

    #ifdef EMIOS1_UC22_CBDR              /* CBDR register */
        pEMIOS1->CH[22].CBDR.R       = EMIOS1_UC22_CBDR;
    #endif

    #ifdef EMIOS1_UC22_CCR               /* CCR register */
        pEMIOS1->CH[22].CCR.R        = EMIOS1_UC22_CCR;
    #endif

    #ifdef EMIOS1_UC22_CSR               /* CSR register */
        pEMIOS1->CH[22].CSR.R        = EMIOS1_UC22_CSR;
    #endif

    #ifdef EMIOS1_UC22_ALTCADR            /* ALTCADR register */
        pEMIOS1->CH[22].ALTCADR.R    = EMIOS1_UC22_ALTCADR;
    #endif

    /*--------------------------------------------------------------------------
     * eMIOS1 unified channel 23 registers
    --------------------------------------------------------------------------*/
    #ifdef EMIOS1_UC23_CADR              /* CADR register */
        pEMIOS1->CH[23].CADR.R       = EMIOS1_UC23_CADR;
    #endif

    #ifdef EMIOS1_UC23_CBDR              /* CBDR register */
        pEMIOS1->CH[23].CBDR.R       = EMIOS1_UC23_CBDR;
    #endif

    #ifdef EMIOS1_UC23_CCR               /* CCR register */
        pEMIOS1->CH[23].CCR.R        = EMIOS1_UC23_CCR;
    #endif

    #ifdef EMIOS1_UC23_CSR               /* CSR register */
        pEMIOS1->CH[23].CSR.R        = EMIOS1_UC23_CSR;
    #endif

    #ifdef EMIOS1_UC23_ALTCADR            /* ALTCADR register */
        pEMIOS1->CH[23].ALTCADR.R    = EMIOS1_UC23_ALTCADR;
    #endif

    /*--------------------------------------------------------------------------
     * eMIOS1 unified channel 24 registers
    --------------------------------------------------------------------------*/
    #ifdef EMIOS1_UC24_CADR              /* CADR register */
        pEMIOS1->CH[24].CADR.R       = EMIOS1_UC24_CADR;
    #endif

    #ifdef EMIOS1_UC24_CBDR              /* CBDR register */
        pEMIOS1->CH[24].CBDR.R       = EMIOS1_UC24_CBDR;
    #endif

    #ifdef EMIOS1_UC24_CCR               /* CCR register */
        pEMIOS1->CH[24].CCR.R        = EMIOS1_UC24_CCR;
    #endif

    #ifdef EMIOS1_UC24_CSR               /* CSR register */
        pEMIOS1->CH[24].CSR.R        = EMIOS1_UC24_CSR;
    #endif

    #ifdef EMIOS1_UC24_ALTCADR            /* ALTCADR register */
        pEMIOS1->CH[24].ALTCADR.R    = EMIOS1_UC24_ALTCADR;
    #endif

    /*--------------------------------------------------------------------------
     * eMIOS1 unified channel 25 registers
    --------------------------------------------------------------------------*/
    #ifdef EMIOS1_UC25_CADR              /* CADR register */
        pEMIOS1->CH[25].CADR.R       = EMIOS1_UC25_CADR;
    #endif

    #ifdef EMIOS1_UC25_CBDR              /* CBDR register */
        pEMIOS1->CH[25].CBDR.R       = EMIOS1_UC25_CBDR;
    #endif

    #ifdef EMIOS1_UC25_CCR               /* CCR register */
        pEMIOS1->CH[25].CCR.R        = EMIOS1_UC25_CCR;
    #endif

    #ifdef EMIOS1_UC25_CSR               /* CSR register */
        pEMIOS1->CH[25].CSR.R        = EMIOS1_UC25_CSR;
    #endif

    #ifdef EMIOS1_UC25_ALTCADR            /* ALTCADR register */
        pEMIOS1->CH[25].ALTCADR.R    = EMIOS1_UC25_ALTCADR;
    #endif

    /*--------------------------------------------------------------------------
     * eMIOS1 unified channel 26 registers
    --------------------------------------------------------------------------*/
    #ifdef EMIOS1_UC26_CADR              /* CADR register */
        pEMIOS1->CH[26].CADR.R       = EMIOS1_UC26_CADR;
    #endif

    #ifdef EMIOS1_UC26_CBDR              /* CBDR register */
        pEMIOS1->CH[26].CBDR.R       = EMIOS1_UC26_CBDR;
    #endif

    #ifdef EMIOS1_UC26_CCR               /* CCR register */
        pEMIOS1->CH[26].CCR.R        = EMIOS1_UC26_CCR;
    #endif

    #ifdef EMIOS1_UC26_CSR               /* CSR register */
        pEMIOS1->CH[26].CSR.R        = EMIOS1_UC26_CSR;
    #endif

    #ifdef EMIOS1_UC26_ALTCADR            /* ALTCADR register */
        pEMIOS1->CH[26].ALTCADR.R    = EMIOS1_UC26_ALTCADR;
    #endif

    /*--------------------------------------------------------------------------
     * eMIOS1 unified channel 27 registers
    --------------------------------------------------------------------------*/
    #ifdef EMIOS1_UC27_CADR              /* CADR register */
        pEMIOS1->CH[27].CADR.R       = EMIOS1_UC27_CADR;
    #endif

    #ifdef EMIOS1_UC27_CBDR              /* CBDR register */
        pEMIOS1->CH[27].CBDR.R       = EMIOS1_UC27_CBDR;
    #endif

    #ifdef EMIOS1_UC27_CCR               /* CCR register */
        pEMIOS1->CH[27].CCR.R        = EMIOS1_UC27_CCR;
    #endif

    #ifdef EMIOS1_UC27_CSR               /* CSR register */
        pEMIOS1->CH[27].CSR.R        = EMIOS1_UC27_CSR;
    #endif

    #ifdef EMIOS1_UC27_ALTCADR            /* ALTCADR register */
        pEMIOS1->CH[27].ALTCADR.R    = EMIOS1_UC27_ALTCADR;
    #endif

    /*--------------------------------------------------------------------------
     * eMIOS1 unified channel 28 registers
    --------------------------------------------------------------------------*/
    #ifdef EMIOS1_UC28_CADR              /* CADR register */
        pEMIOS1->CH[28].CADR.R       = EMIOS1_UC28_CADR;
    #endif

    #ifdef EMIOS1_UC28_CBDR              /* CBDR register */
        pEMIOS1->CH[28].CBDR.R       = EMIOS1_UC28_CBDR;
    #endif

    #ifdef EMIOS1_UC28_CCR               /* CCR register */
        pEMIOS1->CH[28].CCR.R        = EMIOS1_UC28_CCR;
    #endif

    #ifdef EMIOS1_UC28_CSR               /* CSR register */
        pEMIOS1->CH[28].CSR.R        = EMIOS1_UC28_CSR;
    #endif

    #ifdef EMIOS1_UC28_ALTCADR            /* ALTCADR register */
        pEMIOS1->CH[28].ALTCADR.R    = EMIOS1_UC28_ALTCADR;
    #endif

    /*--------------------------------------------------------------------------
     * eMIOS1 unified channel 29 registers
    --------------------------------------------------------------------------*/
    #ifdef EMIOS1_UC29_CADR              /* CADR register */
        pEMIOS1->CH[29].CADR.R       = EMIOS1_UC29_CADR;
    #endif

    #ifdef EMIOS1_UC29_CBDR              /* CBDR register */
        pEMIOS1->CH[29].CBDR.R       = EMIOS1_UC29_CBDR;
    #endif

    #ifdef EMIOS1_UC29_CCR               /* CCR register */
        pEMIOS1->CH[29].CCR.R        = EMIOS1_UC29_CCR;
    #endif

    #ifdef EMIOS1_UC29_CSR               /* CSR register */
        pEMIOS1->CH[29].CSR.R        = EMIOS1_UC29_CSR;
    #endif

    #ifdef EMIOS1_UC29_ALTCADR            /* ALTCADR register */
        pEMIOS1->CH[29].ALTCADR.R    = EMIOS1_UC29_ALTCADR;
    #endif

    /*--------------------------------------------------------------------------
     * eMIOS1 unified channel 30 registers
    --------------------------------------------------------------------------*/
    #ifdef EMIOS1_UC30_CADR              /* CADR register */
        pEMIOS1->CH[30].CADR.R       = EMIOS1_UC30_CADR;
    #endif

    #ifdef EMIOS1_UC30_CBDR              /* CBDR register */
        pEMIOS1->CH[30].CBDR.R       = EMIOS1_UC30_CBDR;
    #endif

    #ifdef EMIOS1_UC30_CCR               /* CCR register */
        pEMIOS1->CH[30].CCR.R        = EMIOS1_UC30_CCR;
    #endif

    #ifdef EMIOS1_UC30_CSR               /* CSR register */
        pEMIOS1->CH[30].CSR.R        = EMIOS1_UC30_CSR;
    #endif

    #ifdef EMIOS1_UC30_ALTCADR            /* ALTCADR register */
        pEMIOS1->CH[30].ALTCADR.R    = EMIOS1_UC30_ALTCADR;
    #endif

    /*--------------------------------------------------------------------------
     * eMIOS1 unified channel 31 registers
    --------------------------------------------------------------------------*/
    #ifdef EMIOS1_UC31_CADR              /* CADR register */
        pEMIOS1->CH[31].CADR.R       = EMIOS1_UC31_CADR;
    #endif

    #ifdef EMIOS1_UC31_CBDR              /* CBDR register */
        pEMIOS1->CH[31].CBDR.R       = EMIOS1_UC31_CBDR;
    #endif

    #ifdef EMIOS1_UC31_CCR               /* CCR register */
        pEMIOS1->CH[31].CCR.R        = EMIOS1_UC31_CCR;
    #endif

    #ifdef EMIOS1_UC31_CSR               /* CSR register */
        pEMIOS1->CH[31].CSR.R        = EMIOS1_UC31_CSR;
    #endif

    #ifdef EMIOS1_UC31_ALTCADR            /* ALTCADR register */
        pEMIOS1->CH[31].ALTCADR.R    = EMIOS1_UC31_ALTCADR;
    #endif
}