/*******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2012 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
****************************************************************************//*!
*
* @file     emios.h
*
* @author   b06050
*
* @version  1.0.2.0
*
* @date     Aug-3-2012
*
* @brief    eMIOS - eMIOS module on MPC5606B
*
********************************************************************************
*
* This file includes initial setting and MACRO definitions of MPC5606B eMIOS
* peripheral modules.
*
*******************************************************************************/
#ifndef __EMIOS_H
#define __EMIOS_H

/* eMIOS mode definitions */
#define EMIOS_MODE_GPO      0x01    /* GPIO (output) */
#define EMIOS_MODE_SAOC     0x03    /* Single Action Output Compare */
#define EMIOS_MODE_MC_UP    0x10    /* Modulus Counter (Up counter with clear on
                                       match end) */

/* CCR register bit masks */
#define EMIOS_CCR_ODIS_MASK     0x40000000
#define EMIOS_CCR_DMA_MASK      0x01000000
#define EMIOS_CCR_FEN_MASK      0x00020000
#define EMIOS_CCR_FORCMB_MASK   0x00001000

/* eMIOS CCR register values for PWM generation */
#define EMIOS_CCR_DUTY      (0x02000226 | EMIOS_CCR_FORCMB_MASK)
#define EMIOS_CCR_HS_OFF    (0x02000226 | EMIOS_CCR_ODIS_MASK)
#define EMIOS_CCR_LS_OFF    0x02000201
#define EMIOS_CCR_LS_ON     (0x02000226 | EMIOS_CCR_ODIS_MASK)

/* eMIOS0_CH0 CCR register address definition */
#define EMIOS0_BASE_ADDRESS     0xC3FA0000

/*******************************************************************************
* Global eMIOS variables definition
******************************************************************************/
// Pointer to eMIOS structure
struct EMIOS_tag *pEMIOS0;
struct EMIOS_tag *pEMIOS1;

/*******************************************************************************
* Exported functions
*******************************************************************************/
extern void emios0_init(void);
extern void emios1_init(void);

#endif /* __EMIOS_H */