/*******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2012 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
****************************************************************************//*!
*
* @file     pit.c
*
* @author   b06050
*
* @version  1.0.2.0
*
* @date     Aug-3-2012
*
* @brief    PIT - Periodic Interupt Timer for MPC5606B
*
********************************************************************************
*
* This file includes initial setting function of MPC5606B PIT peripheral module.
*
*******************************************************************************/
#include "MPC5606B.h"
#include "pit.h"
#include "MPC5606B_appconfig.h"
#include "BLDC_appconfig.h"

/*******************************************************************************
* PIT timer functions
*******************************************************************************/

/***************************************************************************//*!
@brief          Periodic Interupt Timer initialization function

@param[in,out]  void
@param[in]      void

@return         void

@details        This function initializes PIT timer.
*******************************************************************************/
void pit_init(void)
{
    // initialization of peripheral base address
    pPIT=(struct PIT_tag *)&PIT;

    // clock for PIT disabled
    pPIT->PITMCR.B.MDIS = 1;

    /*--------------------------------------------------------------------------
     * PIT channel 0 registers
    --------------------------------------------------------------------------*/
    #ifdef PIT_CH0_LDVAL                  /* LDVAL register */
        pPIT->CH[0].LDVAL.R       = PIT_CH0_LDVAL;
    #endif

    #ifdef PIT_CH0_TCTRL                  /* TCTRL register */
        pPIT->CH[0].TCTRL.R       = PIT_CH0_TCTRL;
    #endif

    /*--------------------------------------------------------------------------
     * PIT channel 1 registers
    --------------------------------------------------------------------------*/
    #ifdef PIT_CH1_LDVAL                  /* LDVAL register */
        pPIT->CH[1].LDVAL.R       = PIT_CH1_LDVAL;
    #endif

    #ifdef PIT_CH1_TCTRL                  /* TCTRL register */
        pPIT->CH[1].TCTRL.R       = PIT_CH1_TCTRL;
    #endif

    /*--------------------------------------------------------------------------
     * PIT channel 2 registers
    --------------------------------------------------------------------------*/
    #ifdef PIT_CH2_LDVAL                  /* LDVAL register */
        pPIT->CH[2].LDVAL.R       = PIT_CH2_LDVAL;
    #endif

    #ifdef PIT_CH2_TCTRL                  /* TCTRL register */
        pPIT->CH[2].TCTRL.R       = PIT_CH2_TCTRL;
    #endif

    /*--------------------------------------------------------------------------
     * PIT channel 3 registers
    --------------------------------------------------------------------------*/
    #ifdef PIT_CH3_LDVAL                  /* LDVAL register */
        pPIT->CH[3].LDVAL.R       = PIT_CH3_LDVAL;
    #endif

    #ifdef PIT_CH3_TCTRL                  /* TCTRL register */
        pPIT->CH[3].TCTRL.R       = PIT_CH3_TCTRL;
    #endif

    /*--------------------------------------------------------------------------
     * PIT Control registers
    --------------------------------------------------------------------------*/
    #ifdef PIT_PITMCR                     /* MCR register */
        pPIT->PITMCR.R            = PIT_PITMCR;
    #endif
}