/*******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2012 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
****************************************************************************//*!
*
* @file     pit.h
*
* @author   b06050
*
* @version  1.0.2.0
*
* @date     Aug-3-2012
*
* @brief    PIT - Periodic Interupt Timer for MPC5606B
*
********************************************************************************
*
* This file includes initial setting and MACRO definitions of MPC5606B PIT
* peripheral module.
*
*******************************************************************************/
#ifndef __PIT_H
#define __PIT_H

/*******************************************************************************
* Global PIT variables definition
*******************************************************************************/
// Pointer to PIT structure
struct PIT_tag *pPIT;

/*******************************************************************************
* PIT MACRO definitions
*******************************************************************************/
/* PIT2 TCTRL register address definition */
#define PIT2_TCTRL_ADDRESS      0xC3FF0128

// PIT channels definition
#define PIT0                    0x0
#define PIT1                    0x1
#define PIT2                    0x2
#define PIT3                    0x3

/*******************************************************************************
* Exported functions
*******************************************************************************/
extern void pit_init(void);

#endif /* __PIT_H */