/*******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2012 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
********************************************************************************
*
* $File Name: GH_BOLERO_ROM.ld&
*
* $Date: Aug-3-2012$
*
* $Version: 1.0.3.0$
*
* Description: MPC5606B Linker Command File for Internal FLASH
*
*******************************************************************************/
MEMORY {
    /* 1.0M Internal Flash */
    flash_rcw1        : ORIGIN = 0x00000000, LENGTH = 8
    int_flash         : ORIGIN = .,          LENGTH = 0xFF000 - 8
    flash_vec         : ORIGIN = 0x000FF000, LENGTH = 0x0D00
    flash_rcw2        : ORIGIN = .,          LENGTH = 0

    /* 80KB of internal SRAM */
    ram_rcw1          : ORIGIN = 0x40000000, LENGTH = 0
    int_sram          : ORIGIN = 0x40000000, LENGTH = 0x13000
    iram_stack        : ORIGIN = 0x40013000, LENGTH = 0x1000
    ram_rcw2          : ORIGIN = .,          LENGTH = 0
}

// Program layout for starting in ROM, copying data to RAM,
// and continuing to execute out of ROM.
SECTIONS
{
// RAM SECTIONS
    .PPC.EMB.sdata0                         ABS     : > int_sram
    .PPC.EMB.sbss0                      CLEAR ABS   : > .
    .sdabase                            ALIGN(8)    : > .
    .sdata                                          : > .
    .sbss                                           : > .
    .data                                           : > .
    .bss                                            : > .
    .stack                                ALIGN(16) : > iram_stack

// ROM SECTIONS
    .rcw                                            : > flash_rcw1
    .text                                           : > int_flash
    .vletext                                        : > .
    .rodata                                         : > .
    .syscall                                        : > .
    .sdata2                                         : > .
    .secinfo                                        : > .
    .fixaddr                                        : > .
    .fixtype                                        : > .

    .ROM.PPC.EMB.sdata0        ROM(.PPC.EMB.sdata0) : > .
    .ROM.sdata                          ROM(.sdata) : > .
    .ROM.data                            ROM(.data) : > .

    .xcptn                            ALIGN(0x1000) : > flash_vec
    .isrvectbl                         ALIGN(0x800) : > .


// These special symbols mark the bounds of RAM and ROM memory.
// They are used by the MULTI debugger.
    __ghs_ramstart  = MEMADDR(ram_rcw1);
    __ghs_ramend    = MEMENDADDR(ram_rcw2);
    __ghs_romstart  = MEMADDR(flash_rcw1);
    __ghs_romend    = MEMENDADDR(flash_rcw2);

    __IV_ADDR       = MEMADDR(flash_vec);

    INT_SRAM_START  = ADDR(int_sram);
    INT_SRAM_SIZE   = 80K/128;                        // Init 128 bytes at a time
    SBSS_SRAM_START = ADDR(.sbss);
    SBSS_SRAM_SIZE  = (SIZEOF(.sbss)+3)/4;            // Init 4 bytes at a time
    BSS_SRAM_START  = ADDR(.bss);
    BSS_SRAM_SIZE   = (SIZEOF(.bss)+3)/4;             // Init 4 bytes at a time
    SDATA_RW_START  = ADDR(.sdata)+0x8000;
    SDATA_RO_START  = ADDR(.sdata2)+0x8000;

    RC_PPC_SDATA2_SRC  = ADDR(.ROM.PPC.EMB.sdata0);
    RC_PPC_SDATA2_DEST = ADDR(.PPC.EMB.sdata0);
    RC_PPC_SDATA2_SIZE = (SIZEOF(.ROM.PPC.EMB.sdata0)+3)/4; // Copy 4 bytes at a time
    RC_SDATA_SRC       = ADDR(.ROM.sdata);
    RC_SDATA_DEST      = ADDR(.sdata);
    RC_SDATA_SIZE      = (SIZEOF(.ROM.sdata)+3)/4;          // Copy 4 bytes at a time
    RC_DATA_SRC        = ADDR(.ROM.data);
    RC_DATA_DEST       = ADDR(.data);
    RC_DATA_SIZE       = (SIZEOF(.ROM.data)+3)/4;           // Copy 4 bytes at a time

    __SP_INIT      = ADDR(iram_stack) + SIZEOF(iram_stack);
    __SP_END       = ADDR(iram_stack);
    __STACK_SIZE   = SIZEOF(iram_stack);
}