/*******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2012 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
****************************************************************************//*!
*
* @file     sys.c
*
* @author   b06050
*
* @version  1.0.2.0
*
* @date     Aug-3-2012
*
* @brief    System and interrupt initialization functions.
*
*******************************************************************************/
#include "MPC5606B.h"
#include "MPC5606B_appconfig.h"
#include "sys.h"

/***************************************************************************//*!
@brief          MPC5606B clock and operational mode initialization

@param[in,out]  void
@param[in]      void

@return         void

@details        The function setup clock generation module (CGM),
                mode entry (ME), reset generation, module (RGM),
                power control unit (PCU).
*******************************************************************************/
void mc_mode_init(void)
{
    //   Disable Software Watchdog (SWT)
    SWT.SR.R = 0xc520;
    SWT.SR.R = 0xd928;
    SWT.CR.R = 0x8000010A;

    /*====================================================
     External clock (Clockout) configuration
     ====================================================*/
    CGM.OCDSSC.B.SELCTL = OCDSSC_CLKOUT_SRC_SYSCLK; // system clock source
    CGM.OCDSSC.B.SELDIV = OCDSSC_CLKOUT_DIVBY_4;    // system clock division
    CGM.OCEN.B.EN = CLKOUT_ENABLE;                  // output clock enabled

    /*====================================================
     Peripheral Set 1 clock configuration
     ====================================================*/
    CGM.SCDC.B.DIV0 = SCDC0_DIV0(0);                // sysclk div by 1
    CGM.SCDC.B.DE0 = SCDC0_DIVIDER_ENABLE;

    /*====================================================
     Peripheral Set 2 clock configuration
     ====================================================*/
    CGM.SCDC.B.DIV1 = SCDC1_DIV1(0);                // sysclk div by 1
    CGM.SCDC.B.DE1 = SCDC1_DIVIDER_ENABLE;

    /*====================================================
     Peripheral Set 3 clock configuration
     ====================================================*/
    CGM.SCDC.B.DIV2 = SCDC2_DIV2(0);                // sysclk div by 1
    CGM.SCDC.B.DE2 = SCDC2_DIVIDER_ENABLE;

    /*====================================================
     Modes Configurations
     ====================================================*/
    // enable all modes
    ME.MER.B.STANDBY0 = ME_MODE_STANDBY0_DISABLED;
    ME.MER.B.STOP0 = ME_MODE_STOP0_ENABLED;
    ME.MER.B.HALT0 = ME_MODE_HALT0_ENABLED;
    ME.MER.B.RUN3 = ME_MODE_RUN3_ENABLED;
    ME.MER.B.RUN2 = ME_MODE_RUN2_ENABLED;
    ME.MER.B.RUN1 = ME_MODE_RUN1_ENABLED;
    ME.MER.B.RUN0 = ME_MODE_RUN0_ENABLED;
    ME.MER.B.DRUN = ME_MODE_DRUN_ENABLED;
    ME.MER.B.SAFE = ME_MODE_SAFE_ENABLED;
    ME.MER.B.TEST = ME_MODE_TEST_ENABLED;
    ME.MER.B.RESET = ME_MODE_RESET_ENABLED;

    // DRUN mode configuration
    ME.DRUN.B.DFLAON = DRUN_DFLASH_NORMAL_MODE;
    ME.DRUN.B.CFLAON = DRUN_CFLASH_NORMAL_MODE;
    ME.DRUN.B.PLL1ON = DRUN_SYSPLL_OFF;         // PLL0 disabled
    ME.DRUN.B.XOSC0ON = DRUN_XOSC_ON;           // Switch on external osc.
    ME.DRUN.B.IRCON = DRUN_INTOSC_ON;           // Switch on internal osc.
    ME.DRUN.B.SYSCLK = SYSCLK_SRC_OSC;          // select external 4MHz osc
                                                // for system clock

    CGM.CMU_0_CSR.B.RCDIV = 3;
    // to avoid CMU reset in case of Fmosc<Frcosc
    CGM.CMU_0_LFREFR_A.B.LFREF_A = 0x1;
    CGM.CMU_0_HFREFR_A.B.HFREF_A = 0xFFE;

    CGM.CMU_1_CSR.B.RCDIV = 3;
    // to avoid CMU reset in case of Fmosc<Frcosc
    CGM.CMU_1_LFREFR_A.B.LFREF_A = 0x1;
    CGM.CMU_1_HFREFR_A.B.HFREF_A = 0xFFE;

    // Re-enter in DRUN mode to update the configuration
    ME.MCTL.R = 0x30005AF0;     // DRUN Mode & Key
    ME.MCTL.R = 0x3000A50F;     // DRUN Mode & Key

    while(ME.GS.B.S_OSC==0);
    //ME_GS Wait for external osc to stabilize.
    //waiting for end of transaction
    while(ME.GS.B.S_MTRANS == 1) {asm("nop");}
    while(ME.GS.B.S_CURRENTMODE != 0x3 ){};
    //ME_GS Check DRUN mode has successfully been entered

    /*====================================================
     PLL frequency configuration
     ====================================================*/
    /*
    IDF
    0x0 Divide by 1
    0x1 Divide by 2
    0x2 Divide by 3
    0x3 Divide by 4
    ...

    ODF
    0x0 Divide by 2
    0x1 Divide by 4
    0x2 Divide by 8
    0x3 Divide by 16

    ------------------------------
    freq = XOSC*LDF / (IDF * ODF)
    ------------------------------
    */
    //PLL0 64 MHz system PLL
    CGM.FMPLL[0].CR.B.IDF = 0x1;
    CGM.FMPLL[0].CR.B.ODF = 0x1;
    CGM.FMPLL[0].CR.B.NDIV = 64;

    ME.DRUN.B.PLL1ON = 0x1;     // PLL0 enabled
    ME.DRUN.B.SYSCLK = PLL0;    // select SYS PLL

    ME.RUNPC[0].R = 0x000000FE;
    // Enable Periphs in all running modes
    ME.LPPC[0].R = 0x00000500;
    // Enable Periphs in low power modes

    // Re-enter in DRUN mode to update the configuration
    ME.MCTL.R = 0x30005AF0;     // DRUN Mode & Key
    ME.MCTL.R = 0x3000A50F;     // DRUN Mode & Key

    // ME_GS Wait for FPLL_0 to stabilize.
    while(ME.GS.B.S_PLL0==0);

    // waiting for end of transaction
    while (ME.GS.B.S_MTRANS == 1)
    {
    }

    // ME_GS Check DRUN mode has successfully been entered
    while(ME.GS.B.S_CURRENTMODE != 0x3 )
    {
    }

    // wait for PLL to lock - will not lock before DRUN re-entry
    while(CGM.FMPLL[0].CR.B.S_LOCK==0)
    {
    }

    //ME_GS Poll Global status register to get current system clock
    //fail if system clock is not pll
    //0000 16MHz internal RC oscillator
    //0001 divided 16MHz internal RC oscillator
    //0010 4MHz crystal oscillator
    //0011 divided 4MHz crystal oscillator
    //0100 system PLL
    //1111 system clock is disabled
    while(ME.GS.B.S_SYSCLK != 0x4)
    {
    }   //ME_GS fail here
}

/***************************************************************************//*!
@brief          This function intializes the INTC for software vector mode.

@param[in,out]  void
@param[in]      void

@return         void

@details        Set up INTC vector table base address to the  address defined
                in the linker. Satellite transmission interrupt has priority 2.
                Diagnostic transmission interrupt has priority 3.
*******************************************************************************/
void intc_init(void)
{
    // Initialize INTC for software vector mode
    INTC.MCR.B.HVEN = 0;

    // Use the default vector table entry offsets of 4 bytes
    INTC.MCR.B.VTES = 0;

    // Set INTC ISR vector table base addr.
    INTC.IACKR.R = (uint32_t) &IntcIsrVectorTable[0];

    #ifdef IRQ_0_PRIORITY        /* ISR 0 */
       INTC.PSR[0].B.PRI = IRQ_0_PRIORITY;
    #endif
    #ifdef IRQ_1_PRIORITY        /* ISR 1 */
       INTC.PSR[1].B.PRI = IRQ_1_PRIORITY;
    #endif
    #ifdef IRQ_2_PRIORITY        /* ISR 2 */
       INTC.PSR[2].B.PRI = IRQ_2_PRIORITY;
    #endif
    #ifdef IRQ_3_PRIORITY        /* ISR 3 */
       INTC.PSR[3].B.PRI = IRQ_3_PRIORITY;
    #endif
    #ifdef IRQ_4_PRIORITY        /* ISR 4 */
       INTC.PSR[4].B.PRI = IRQ_4_PRIORITY;
    #endif
    #ifdef IRQ_5_PRIORITY        /* ISR 5 */
       INTC.PSR[5].B.PRI = IRQ_5_PRIORITY;
    #endif
    #ifdef IRQ_6_PRIORITY        /* ISR 6 */
       INTC.PSR[6].B.PRI = IRQ_6_PRIORITY;
    #endif
    #ifdef IRQ_7_PRIORITY        /* ISR 7 */
       INTC.PSR[7].B.PRI = IRQ_7_PRIORITY;
    #endif
    #ifdef IRQ_8_PRIORITY        /* ISR 8 */
       INTC.PSR[8].B.PRI = IRQ_8_PRIORITY;
    #endif
    #ifdef IRQ_9_PRIORITY        /* ISR 9 */
       INTC.PSR[9].B.PRI = IRQ_9_PRIORITY;
    #endif
    #ifdef IRQ_10_PRIORITY       /* ISR 10 */
       INTC.PSR[10].B.PRI = IRQ_10_PRIORITY;
    #endif
    #ifdef IRQ_11_PRIORITY       /* ISR 11 */
       INTC.PSR[11].B.PRI = IRQ_11_PRIORITY;
    #endif
    #ifdef IRQ_12_PRIORITY       /* ISR 12 */
       INTC.PSR[12].B.PRI = IRQ_12_PRIORITY;
    #endif
    #ifdef IRQ_13_PRIORITY       /* ISR 13 */
       INTC.PSR[13].B.PRI = IRQ_13_PRIORITY;
    #endif
    #ifdef IRQ_14_PRIORITY       /* ISR 14 */
       INTC.PSR[14].B.PRI = IRQ_14_PRIORITY;
    #endif
    #ifdef IRQ_15_PRIORITY       /* ISR 15 */
       INTC.PSR[15].B.PRI = IRQ_15_PRIORITY;
    #endif
    #ifdef IRQ_16_PRIORITY       /* ISR 16 */
       INTC.PSR[16].B.PRI = IRQ_16_PRIORITY;
    #endif
    #ifdef IRQ_17_PRIORITY       /* ISR 17 */
       INTC.PSR[17].B.PRI = IRQ_17_PRIORITY;
    #endif
    #ifdef IRQ_18_PRIORITY       /* ISR 18 */
       INTC.PSR[18].B.PRI = IRQ_18_PRIORITY;
    #endif
    #ifdef IRQ_19_PRIORITY       /* ISR 19 */
       INTC.PSR[19].B.PRI = IRQ_19_PRIORITY;
    #endif
    #ifdef IRQ_20_PRIORITY       /* ISR 20 */
       INTC.PSR[20].B.PRI = IRQ_20_PRIORITY;
    #endif
    #ifdef IRQ_21_PRIORITY       /* ISR 21 */
       INTC.PSR[21].B.PRI = IRQ_21_PRIORITY;
    #endif
    #ifdef IRQ_22_PRIORITY       /* ISR 22 */
       INTC.PSR[22].B.PRI = IRQ_22_PRIORITY;
    #endif
    #ifdef IRQ_23_PRIORITY       /* ISR 23 */
       INTC.PSR[23].B.PRI = IRQ_23_PRIORITY;
    #endif
    #ifdef IRQ_24_PRIORITY       /* ISR 24 */
       INTC.PSR[24].B.PRI = IRQ_24_PRIORITY;
    #endif
    #ifdef IRQ_25_PRIORITY       /* ISR 25 */
       INTC.PSR[25].B.PRI = IRQ_25_PRIORITY;
    #endif
    #ifdef IRQ_26_PRIORITY       /* ISR 26 */
       INTC.PSR[26].B.PRI = IRQ_26_PRIORITY;
    #endif
    #ifdef IRQ_27_PRIORITY       /* ISR 27 */
       INTC.PSR[27].B.PRI = IRQ_27_PRIORITY;
    #endif
    #ifdef IRQ_28_PRIORITY       /* ISR 28 */
       INTC.PSR[28].B.PRI = IRQ_28_PRIORITY;
    #endif
    #ifdef IRQ_29_PRIORITY       /* ISR 29 */
       INTC.PSR[29].B.PRI = IRQ_29_PRIORITY;
    #endif
    #ifdef IRQ_30_PRIORITY       /* ISR 30 */
       INTC.PSR[30].B.PRI = IRQ_30_PRIORITY;
    #endif
    #ifdef IRQ_31_PRIORITY       /* ISR 31 */
       INTC.PSR[31].B.PRI = IRQ_31_PRIORITY;
    #endif
    #ifdef IRQ_32_PRIORITY       /* ISR 32 */
       INTC.PSR[32].B.PRI = IRQ_32_PRIORITY;
    #endif
    #ifdef IRQ_33_PRIORITY       /* ISR 33 */
       INTC.PSR[33].B.PRI = IRQ_33_PRIORITY;
    #endif
    #ifdef IRQ_34_PRIORITY       /* ISR 34 */
       INTC.PSR[34].B.PRI = IRQ_34_PRIORITY;
    #endif
    #ifdef IRQ_35_PRIORITY       /* ISR 35 */
       INTC.PSR[35].B.PRI = IRQ_35_PRIORITY;
    #endif
    #ifdef IRQ_36_PRIORITY       /* ISR 36 */
       INTC.PSR[36].B.PRI = IRQ_36_PRIORITY;
    #endif
    #ifdef IRQ_37_PRIORITY       /* ISR 37 */
       INTC.PSR[37].B.PRI = IRQ_37_PRIORITY;
    #endif
    #ifdef IRQ_38_PRIORITY       /* ISR 38 */
       INTC.PSR[38].B.PRI = IRQ_38_PRIORITY;
    #endif
    #ifdef IRQ_39_PRIORITY       /* ISR 39 */
       INTC.PSR[39].B.PRI = IRQ_39_PRIORITY;
    #endif
    #ifdef IRQ_40_PRIORITY       /* ISR 40 */
       INTC.PSR[40].B.PRI = IRQ_40_PRIORITY;
    #endif
    #ifdef IRQ_41_PRIORITY       /* ISR 41 */
       INTC.PSR[41].B.PRI = IRQ_41_PRIORITY;
    #endif
    #ifdef IRQ_42_PRIORITY       /* ISR 42 */
       INTC.PSR[42].B.PRI = IRQ_42_PRIORITY;
    #endif
    #ifdef IRQ_43_PRIORITY       /* ISR 43 */
       INTC.PSR[43].B.PRI = IRQ_43_PRIORITY;
    #endif
    #ifdef IRQ_44_PRIORITY       /* ISR 44 */
       INTC.PSR[44].B.PRI = IRQ_44_PRIORITY;
    #endif
    #ifdef IRQ_45_PRIORITY       /* ISR 45 */
       INTC.PSR[45].B.PRI = IRQ_45_PRIORITY;
    #endif
    #ifdef IRQ_46_PRIORITY       /* ISR 46 */
       INTC.PSR[46].B.PRI = IRQ_46_PRIORITY;
    #endif
    #ifdef IRQ_47_PRIORITY       /* ISR 47 */
       INTC.PSR[47].B.PRI = IRQ_47_PRIORITY;
    #endif
    #ifdef IRQ_48_PRIORITY       /* ISR 48 */
       INTC.PSR[48].B.PRI = IRQ_48_PRIORITY;
    #endif
    #ifdef IRQ_49_PRIORITY       /* ISR 49 */
       INTC.PSR[49].B.PRI = IRQ_49_PRIORITY;
    #endif
    #ifdef IRQ_50_PRIORITY       /* ISR 50 */
       INTC.PSR[50].B.PRI = IRQ_50_PRIORITY;
    #endif
    #ifdef IRQ_51_PRIORITY       /* ISR 51 */
       INTC.PSR[51].B.PRI = IRQ_51_PRIORITY;
    #endif
    #ifdef IRQ_52_PRIORITY       /* ISR 52 */
       INTC.PSR[52].B.PRI = IRQ_52_PRIORITY;
    #endif
    #ifdef IRQ_53_PRIORITY       /* ISR 53 */
       INTC.PSR[53].B.PRI = IRQ_53_PRIORITY;
    #endif
    #ifdef IRQ_54_PRIORITY       /* ISR 54 */
       INTC.PSR[54].B.PRI = IRQ_54_PRIORITY;
    #endif
    #ifdef IRQ_55_PRIORITY       /* ISR 55 */
       INTC.PSR[55].B.PRI = IRQ_55_PRIORITY;
    #endif
    #ifdef IRQ_56_PRIORITY       /* ISR 56 */
       INTC.PSR[56].B.PRI = IRQ_56_PRIORITY;
    #endif
    #ifdef IRQ_57_PRIORITY       /* ISR 57 */
       INTC.PSR[57].B.PRI = IRQ_57_PRIORITY;
    #endif
    #ifdef IRQ_58_PRIORITY       /* ISR 58 */
       INTC.PSR[58].B.PRI = IRQ_58_PRIORITY;
    #endif
    #ifdef IRQ_59_PRIORITY       /* ISR 59 */
       INTC.PSR[59].B.PRI = IRQ_59_PRIORITY;
    #endif
    #ifdef IRQ_60_PRIORITY       /* ISR 60 */
       INTC.PSR[60].B.PRI = IRQ_60_PRIORITY;
    #endif
    #ifdef IRQ_61_PRIORITY       /* ISR 61 */
       INTC.PSR[61].B.PRI = IRQ_61_PRIORITY;
    #endif
    #ifdef IRQ_62_PRIORITY       /* ISR 62 */
       INTC.PSR[62].B.PRI = IRQ_62_PRIORITY;
    #endif
    #ifdef IRQ_63_PRIORITY       /* ISR 63 */
       INTC.PSR[63].B.PRI = IRQ_63_PRIORITY;
    #endif
    #ifdef IRQ_64_PRIORITY       /* ISR 64 */
       INTC.PSR[64].B.PRI = IRQ_64_PRIORITY;
    #endif
    #ifdef IRQ_65_PRIORITY       /* ISR 65 */
       INTC.PSR[65].B.PRI = IRQ_65_PRIORITY;
    #endif
    #ifdef IRQ_66_PRIORITY       /* ISR 66 */
       INTC.PSR[66].B.PRI = IRQ_66_PRIORITY;
    #endif
    #ifdef IRQ_67_PRIORITY       /* ISR 67 */
       INTC.PSR[67].B.PRI = IRQ_67_PRIORITY;
    #endif
    #ifdef IRQ_68_PRIORITY       /* ISR 68 */
       INTC.PSR[68].B.PRI = IRQ_68_PRIORITY;
    #endif
    #ifdef IRQ_69_PRIORITY       /* ISR 69 */
       INTC.PSR[69].B.PRI = IRQ_69_PRIORITY;
    #endif
    #ifdef IRQ_70_PRIORITY       /* ISR 70 */
       INTC.PSR[70].B.PRI = IRQ_70_PRIORITY;
    #endif
    #ifdef IRQ_71_PRIORITY       /* ISR 71 */
       INTC.PSR[71].B.PRI = IRQ_71_PRIORITY;
    #endif
    #ifdef IRQ_72_PRIORITY       /* ISR 72 */
       INTC.PSR[72].B.PRI = IRQ_72_PRIORITY;
    #endif
    #ifdef IRQ_73_PRIORITY       /* ISR 73 */
       INTC.PSR[73].B.PRI = IRQ_73_PRIORITY;
    #endif
    #ifdef IRQ_74_PRIORITY       /* ISR 74 */
       INTC.PSR[74].B.PRI = IRQ_74_PRIORITY;
    #endif
    #ifdef IRQ_75_PRIORITY       /* ISR 75 */
       INTC.PSR[75].B.PRI = IRQ_75_PRIORITY;
    #endif
    #ifdef IRQ_76_PRIORITY       /* ISR 76 */
       INTC.PSR[76].B.PRI = IRQ_76_PRIORITY;
    #endif
    #ifdef IRQ_77_PRIORITY       /* ISR 77 */
       INTC.PSR[77].B.PRI = IRQ_77_PRIORITY;
    #endif
    #ifdef IRQ_78_PRIORITY       /* ISR 78 */
       INTC.PSR[78].B.PRI = IRQ_78_PRIORITY;
    #endif
    #ifdef IRQ_79_PRIORITY       /* ISR 79 */
       INTC.PSR[79].B.PRI = IRQ_79_PRIORITY;
    #endif
    #ifdef IRQ_80_PRIORITY       /* ISR 80 */
       INTC.PSR[80].B.PRI = IRQ_80_PRIORITY;
    #endif
    #ifdef IRQ_81_PRIORITY       /* ISR 81 */
       INTC.PSR[81].B.PRI = IRQ_81_PRIORITY;
    #endif
    #ifdef IRQ_82_PRIORITY       /* ISR 82 */
       INTC.PSR[82].B.PRI = IRQ_82_PRIORITY;
    #endif
    #ifdef IRQ_83_PRIORITY       /* ISR 83 */
       INTC.PSR[83].B.PRI = IRQ_83_PRIORITY;
    #endif
    #ifdef IRQ_84_PRIORITY       /* ISR 84 */
       INTC.PSR[84].B.PRI = IRQ_84_PRIORITY;
    #endif
    #ifdef IRQ_85_PRIORITY       /* ISR 85 */
       INTC.PSR[85].B.PRI = IRQ_85_PRIORITY;
    #endif
    #ifdef IRQ_86_PRIORITY       /* ISR 86 */
       INTC.PSR[86].B.PRI = IRQ_86_PRIORITY;
    #endif
    #ifdef IRQ_87_PRIORITY       /* ISR 87 */
       INTC.PSR[87].B.PRI = IRQ_87_PRIORITY;
    #endif
    #ifdef IRQ_88_PRIORITY       /* ISR 88 */
       INTC.PSR[88].B.PRI = IRQ_88_PRIORITY;
    #endif
    #ifdef IRQ_89_PRIORITY       /* ISR 89 */
       INTC.PSR[89].B.PRI = IRQ_89_PRIORITY;
    #endif
    #ifdef IRQ_90_PRIORITY       /* ISR 90 */
       INTC.PSR[90].B.PRI = IRQ_90_PRIORITY;
    #endif
    #ifdef IRQ_91_PRIORITY       /* ISR 91 */
       INTC.PSR[91].B.PRI = IRQ_91_PRIORITY;
    #endif
    #ifdef IRQ_92_PRIORITY       /* ISR 92 */
       INTC.PSR[92].B.PRI = IRQ_92_PRIORITY;
    #endif
    #ifdef IRQ_93_PRIORITY       /* ISR 93 */
       INTC.PSR[93].B.PRI = IRQ_93_PRIORITY;
    #endif
    #ifdef IRQ_94_PRIORITY       /* ISR 94 */
       INTC.PSR[94].B.PRI = IRQ_94_PRIORITY;
    #endif
    #ifdef IRQ_95_PRIORITY       /* ISR 95 */
       INTC.PSR[95].B.PRI = IRQ_95_PRIORITY;
    #endif
    #ifdef IRQ_96_PRIORITY       /* ISR 96 */
       INTC.PSR[96].B.PRI = IRQ_96_PRIORITY;
    #endif
    #ifdef IRQ_97_PRIORITY       /* ISR 97 */
       INTC.PSR[97].B.PRI = IRQ_97_PRIORITY;
    #endif
    #ifdef IRQ_98_PRIORITY       /* ISR 98 */
       INTC.PSR[98].B.PRI = IRQ_98_PRIORITY;
    #endif
    #ifdef IRQ_99_PRIORITY       /* ISR 99 */
       INTC.PSR[99].B.PRI = IRQ_99_PRIORITY;
    #endif
    #ifdef IRQ_100_PRIORITY      /* ISR 100 */
       INTC.PSR[100].B.PRI = IRQ_100_PRIORITY;
    #endif
    #ifdef IRQ_101_PRIORITY      /* ISR 101 */
       INTC.PSR[101].B.PRI = IRQ_101_PRIORITY;
    #endif
    #ifdef IRQ_102_PRIORITY      /* ISR 102 */
       INTC.PSR[102].B.PRI = IRQ_102_PRIORITY;
    #endif
    #ifdef IRQ_103_PRIORITY      /* ISR 103 */
       INTC.PSR[103].B.PRI = IRQ_103_PRIORITY;
    #endif
    #ifdef IRQ_104_PRIORITY      /* ISR 104 */
       INTC.PSR[104].B.PRI = IRQ_104_PRIORITY;
    #endif
    #ifdef IRQ_105_PRIORITY      /* ISR 105 */
       INTC.PSR[105].B.PRI = IRQ_105_PRIORITY;
    #endif
    #ifdef IRQ_106_PRIORITY      /* ISR 106 */
       INTC.PSR[106].B.PRI = IRQ_106_PRIORITY;
    #endif
    #ifdef IRQ_107_PRIORITY      /* ISR 107 */
       INTC.PSR[107].B.PRI = IRQ_107_PRIORITY;
    #endif
    #ifdef IRQ_108_PRIORITY      /* ISR 108 */
       INTC.PSR[108].B.PRI = IRQ_108_PRIORITY;
    #endif
    #ifdef IRQ_109_PRIORITY      /* ISR 109 */
       INTC.PSR[109].B.PRI = IRQ_109_PRIORITY;
    #endif
    #ifdef IRQ_110_PRIORITY      /* ISR 110 */
       INTC.PSR[110].B.PRI = IRQ_110_PRIORITY;
    #endif
    #ifdef IRQ_111_PRIORITY      /* ISR 111 */
       INTC.PSR[111].B.PRI = IRQ_111_PRIORITY;
    #endif
    #ifdef IRQ_112_PRIORITY      /* ISR 112 */
       INTC.PSR[112].B.PRI = IRQ_112_PRIORITY;
    #endif
    #ifdef IRQ_113_PRIORITY      /* ISR 113 */
       INTC.PSR[113].B.PRI = IRQ_113_PRIORITY;
    #endif
    #ifdef IRQ_114_PRIORITY      /* ISR 114 */
       INTC.PSR[114].B.PRI = IRQ_114_PRIORITY;
    #endif
    #ifdef IRQ_115_PRIORITY      /* ISR 115 */
       INTC.PSR[115].B.PRI = IRQ_115_PRIORITY;
    #endif
    #ifdef IRQ_116_PRIORITY      /* ISR 116 */
       INTC.PSR[116].B.PRI = IRQ_116_PRIORITY;
    #endif
    #ifdef IRQ_117_PRIORITY      /* ISR 117 */
       INTC.PSR[117].B.PRI = IRQ_117_PRIORITY;
    #endif
    #ifdef IRQ_118_PRIORITY      /* ISR 118 */
       INTC.PSR[118].B.PRI = IRQ_118_PRIORITY;
    #endif
    #ifdef IRQ_119_PRIORITY      /* ISR 119 */
       INTC.PSR[119].B.PRI = IRQ_119_PRIORITY;
    #endif
    #ifdef IRQ_120_PRIORITY      /* ISR 120 */
       INTC.PSR[120].B.PRI = IRQ_120_PRIORITY;
    #endif
    #ifdef IRQ_121_PRIORITY      /* ISR 121 */
       INTC.PSR[121].B.PRI = IRQ_121_PRIORITY;
    #endif
    #ifdef IRQ_122_PRIORITY      /* ISR 122 */
       INTC.PSR[122].B.PRI = IRQ_122_PRIORITY;
    #endif
    #ifdef IRQ_123_PRIORITY      /* ISR 123 */
       INTC.PSR[123].B.PRI = IRQ_123_PRIORITY;
    #endif
    #ifdef IRQ_124_PRIORITY      /* ISR 124 */
       INTC.PSR[124].B.PRI = IRQ_124_PRIORITY;
    #endif
    #ifdef IRQ_125_PRIORITY      /* ISR 125 */
       INTC.PSR[125].B.PRI = IRQ_125_PRIORITY;
    #endif
    #ifdef IRQ_126_PRIORITY      /* ISR 126 */
       INTC.PSR[126].B.PRI = IRQ_126_PRIORITY;
    #endif
    #ifdef IRQ_127_PRIORITY      /* ISR 127 */
       INTC.PSR[127].B.PRI = IRQ_127_PRIORITY;
    #endif
    #ifdef IRQ_128_PRIORITY      /* ISR 128 */
       INTC.PSR[128].B.PRI = IRQ_128_PRIORITY;
    #endif
    #ifdef IRQ_129_PRIORITY      /* ISR 129 */
       INTC.PSR[129].B.PRI = IRQ_129_PRIORITY;
    #endif
    #ifdef IRQ_130_PRIORITY      /* ISR 130 */
       INTC.PSR[130].B.PRI = IRQ_130_PRIORITY;
    #endif
    #ifdef IRQ_131_PRIORITY      /* ISR 131 */
       INTC.PSR[131].B.PRI = IRQ_131_PRIORITY;
    #endif
    #ifdef IRQ_132_PRIORITY      /* ISR 132 */
       INTC.PSR[132].B.PRI = IRQ_132_PRIORITY;
    #endif
    #ifdef IRQ_133_PRIORITY      /* ISR 133 */
       INTC.PSR[133].B.PRI = IRQ_133_PRIORITY;
    #endif
    #ifdef IRQ_134_PRIORITY      /* ISR 134 */
       INTC.PSR[134].B.PRI = IRQ_134_PRIORITY;
    #endif
    #ifdef IRQ_135_PRIORITY      /* ISR 135 */
       INTC.PSR[135].B.PRI = IRQ_135_PRIORITY;
    #endif
    #ifdef IRQ_136_PRIORITY      /* ISR 136 */
       INTC.PSR[136].B.PRI = IRQ_136_PRIORITY;
    #endif
    #ifdef IRQ_137_PRIORITY      /* ISR 137 */
       INTC.PSR[137].B.PRI = IRQ_137_PRIORITY;
    #endif
    #ifdef IRQ_138_PRIORITY      /* ISR 138 */
       INTC.PSR[138].B.PRI = IRQ_138_PRIORITY;
    #endif
    #ifdef IRQ_139_PRIORITY      /* ISR 139 */
       INTC.PSR[139].B.PRI = IRQ_139_PRIORITY;
    #endif
    #ifdef IRQ_140_PRIORITY      /* ISR 140 */
       INTC.PSR[140].B.PRI = IRQ_140_PRIORITY;
    #endif
    #ifdef IRQ_141_PRIORITY      /* ISR 141 */
       INTC.PSR[141].B.PRI = IRQ_141_PRIORITY;
    #endif
    #ifdef IRQ_142_PRIORITY      /* ISR 142 */
       INTC.PSR[142].B.PRI = IRQ_142_PRIORITY;
    #endif
    #ifdef IRQ_143_PRIORITY      /* ISR 143 */
       INTC.PSR[143].B.PRI = IRQ_143_PRIORITY;
    #endif
    #ifdef IRQ_144_PRIORITY      /* ISR 144 */
       INTC.PSR[144].B.PRI = IRQ_144_PRIORITY;
    #endif
    #ifdef IRQ_145_PRIORITY      /* ISR 145 */
       INTC.PSR[145].B.PRI = IRQ_145_PRIORITY;
    #endif
    #ifdef IRQ_146_PRIORITY      /* ISR 146 */
       INTC.PSR[146].B.PRI = IRQ_146_PRIORITY;
    #endif
    #ifdef IRQ_147_PRIORITY      /* ISR 147 */
       INTC.PSR[147].B.PRI = IRQ_147_PRIORITY;
    #endif
    #ifdef IRQ_148_PRIORITY      /* ISR 148 */
       INTC.PSR[148].B.PRI = IRQ_148_PRIORITY;
    #endif
    #ifdef IRQ_149_PRIORITY      /* ISR 149 */
       INTC.PSR[149].B.PRI = IRQ_149_PRIORITY;
    #endif
    #ifdef IRQ_150_PRIORITY      /* ISR 150 */
       INTC.PSR[150].B.PRI = IRQ_150_PRIORITY;
    #endif
    #ifdef IRQ_151_PRIORITY      /* ISR 151 */
       INTC.PSR[151].B.PRI = IRQ_151_PRIORITY;
    #endif
    #ifdef IRQ_152_PRIORITY      /* ISR 152 */
       INTC.PSR[152].B.PRI = IRQ_152_PRIORITY;
    #endif
    #ifdef IRQ_153_PRIORITY      /* ISR 153 */
       INTC.PSR[153].B.PRI = IRQ_153_PRIORITY;
    #endif
    #ifdef IRQ_154_PRIORITY      /* ISR 154 */
       INTC.PSR[154].B.PRI = IRQ_154_PRIORITY;
    #endif
    #ifdef IRQ_155_PRIORITY      /* ISR 155 */
       INTC.PSR[155].B.PRI = IRQ_155_PRIORITY;
    #endif
    #ifdef IRQ_156_PRIORITY      /* ISR 156 */
       INTC.PSR[156].B.PRI = IRQ_156_PRIORITY;
    #endif
    #ifdef IRQ_157_PRIORITY      /* ISR 157 */
       INTC.PSR[157].B.PRI = IRQ_157_PRIORITY;
    #endif
    #ifdef IRQ_158_PRIORITY      /* ISR 158 */
       INTC.PSR[158].B.PRI = IRQ_158_PRIORITY;
    #endif
    #ifdef IRQ_159_PRIORITY      /* ISR 159 */
       INTC.PSR[159].B.PRI = IRQ_159_PRIORITY;
    #endif
    #ifdef IRQ_160_PRIORITY      /* ISR 160 */
       INTC.PSR[160].B.PRI = IRQ_160_PRIORITY;
    #endif
    #ifdef IRQ_161_PRIORITY      /* ISR 161 */
       INTC.PSR[161].B.PRI = IRQ_161_PRIORITY;
    #endif
    #ifdef IRQ_162_PRIORITY      /* ISR 162 */
       INTC.PSR[162].B.PRI = IRQ_162_PRIORITY;
    #endif
    #ifdef IRQ_163_PRIORITY      /* ISR 163 */
       INTC.PSR[163].B.PRI = IRQ_163_PRIORITY;
    #endif
    #ifdef IRQ_164_PRIORITY      /* ISR 164 */
       INTC.PSR[164].B.PRI = IRQ_164_PRIORITY;
    #endif
    #ifdef IRQ_165_PRIORITY      /* ISR 165 */
       INTC.PSR[165].B.PRI = IRQ_165_PRIORITY;
    #endif
    #ifdef IRQ_166_PRIORITY      /* ISR 166 */
       INTC.PSR[166].B.PRI = IRQ_166_PRIORITY;
    #endif
    #ifdef IRQ_167_PRIORITY      /* ISR 167 */
       INTC.PSR[167].B.PRI = IRQ_167_PRIORITY;
    #endif
    #ifdef IRQ_168_PRIORITY      /* ISR 168 */
       INTC.PSR[168].B.PRI = IRQ_168_PRIORITY;
    #endif
    #ifdef IRQ_169_PRIORITY      /* ISR 169 */
       INTC.PSR[169].B.PRI = IRQ_169_PRIORITY;
    #endif
    #ifdef IRQ_170_PRIORITY      /* ISR 170 */
       INTC.PSR[170].B.PRI = IRQ_170_PRIORITY;
    #endif
    #ifdef IRQ_171_PRIORITY      /* ISR 171 */
       INTC.PSR[171].B.PRI = IRQ_171_PRIORITY;
    #endif
    #ifdef IRQ_172_PRIORITY      /* ISR 172 */
       INTC.PSR[172].B.PRI = IRQ_172_PRIORITY;
    #endif
    #ifdef IRQ_173_PRIORITY      /* ISR 173 */
       INTC.PSR[173].B.PRI = IRQ_173_PRIORITY;
    #endif
    #ifdef IRQ_174_PRIORITY      /* ISR 174 */
       INTC.PSR[174].B.PRI = IRQ_174_PRIORITY;
    #endif
    #ifdef IRQ_175_PRIORITY      /* ISR 175 */
       INTC.PSR[175].B.PRI = IRQ_175_PRIORITY;
    #endif
    #ifdef IRQ_176_PRIORITY      /* ISR 176 */
       INTC.PSR[176].B.PRI = IRQ_176_PRIORITY;
    #endif
    #ifdef IRQ_177_PRIORITY      /* ISR 177 */
       INTC.PSR[177].B.PRI = IRQ_177_PRIORITY;
    #endif
    #ifdef IRQ_178_PRIORITY      /* ISR 178 */
       INTC.PSR[178].B.PRI = IRQ_178_PRIORITY;
    #endif
    #ifdef IRQ_179_PRIORITY      /* ISR 179 */
       INTC.PSR[179].B.PRI = IRQ_179_PRIORITY;
    #endif
    #ifdef IRQ_180_PRIORITY      /* ISR 180 */
       INTC.PSR[180].B.PRI = IRQ_180_PRIORITY;
    #endif
    #ifdef IRQ_181_PRIORITY      /* ISR 181 */
       INTC.PSR[181].B.PRI = IRQ_181_PRIORITY;
    #endif
    #ifdef IRQ_182_PRIORITY      /* ISR 182 */
       INTC.PSR[182].B.PRI = IRQ_182_PRIORITY;
    #endif
    #ifdef IRQ_183_PRIORITY      /* ISR 183 */
       INTC.PSR[183].B.PRI = IRQ_183_PRIORITY;
    #endif
    #ifdef IRQ_184_PRIORITY      /* ISR 184 */
       INTC.PSR[184].B.PRI = IRQ_184_PRIORITY;
    #endif
    #ifdef IRQ_185_PRIORITY      /* ISR 185 */
       INTC.PSR[185].B.PRI = IRQ_185_PRIORITY;
    #endif
    #ifdef IRQ_186_PRIORITY      /* ISR 186 */
       INTC.PSR[186].B.PRI = IRQ_186_PRIORITY;
    #endif
    #ifdef IRQ_187_PRIORITY      /* ISR 187 */
       INTC.PSR[187].B.PRI = IRQ_187_PRIORITY;
    #endif
    #ifdef IRQ_188_PRIORITY      /* ISR 188 */
       INTC.PSR[188].B.PRI = IRQ_188_PRIORITY;
    #endif
    #ifdef IRQ_189_PRIORITY      /* ISR 189 */
       INTC.PSR[189].B.PRI = IRQ_189_PRIORITY;
    #endif
    #ifdef IRQ_190_PRIORITY      /* ISR 190 */
       INTC.PSR[190].B.PRI = IRQ_190_PRIORITY;
    #endif
    #ifdef IRQ_191_PRIORITY      /* ISR 191 */
       INTC.PSR[191].B.PRI = IRQ_191_PRIORITY;
    #endif
    #ifdef IRQ_192_PRIORITY      /* ISR 192 */
       INTC.PSR[192].B.PRI = IRQ_192_PRIORITY;
    #endif
    #ifdef IRQ_193_PRIORITY      /* ISR 193 */
       INTC.PSR[193].B.PRI = IRQ_193_PRIORITY;
    #endif
    #ifdef IRQ_194_PRIORITY      /* ISR 194 */
       INTC.PSR[194].B.PRI = IRQ_194_PRIORITY;
    #endif
    #ifdef IRQ_195_PRIORITY      /* ISR 195 */
       INTC.PSR[195].B.PRI = IRQ_195_PRIORITY;
    #endif
    #ifdef IRQ_196_PRIORITY      /* ISR 196 */
       INTC.PSR[196].B.PRI = IRQ_196_PRIORITY;
    #endif
    #ifdef IRQ_197_PRIORITY      /* ISR 197 */
       INTC.PSR[197].B.PRI = IRQ_197_PRIORITY;
    #endif
    #ifdef IRQ_198_PRIORITY      /* ISR 198 */
       INTC.PSR[198].B.PRI = IRQ_198_PRIORITY;
    #endif
    #ifdef IRQ_199_PRIORITY      /* ISR 199 */
       INTC.PSR[199].B.PRI = IRQ_199_PRIORITY;
    #endif
    #ifdef IRQ_200_PRIORITY      /* ISR 200 */
       INTC.PSR[200].B.PRI = IRQ_200_PRIORITY;
    #endif
    #ifdef IRQ_201_PRIORITY      /* ISR 201 */
       INTC.PSR[201].B.PRI = IRQ_201_PRIORITY;
    #endif
    #ifdef IRQ_202_PRIORITY      /* ISR 202 */
       INTC.PSR[202].B.PRI = IRQ_202_PRIORITY;
    #endif
    #ifdef IRQ_203_PRIORITY      /* ISR 203 */
       INTC.PSR[203].B.PRI = IRQ_203_PRIORITY;
    #endif
    #ifdef IRQ_204_PRIORITY      /* ISR 204 */
       INTC.PSR[204].B.PRI = IRQ_204_PRIORITY;
    #endif
    #ifdef IRQ_205_PRIORITY      /* ISR 205 */
       INTC.PSR[205].B.PRI = IRQ_205_PRIORITY;
    #endif
    #ifdef IRQ_206_PRIORITY      /* ISR 206 */
       INTC.PSR[206].B.PRI = IRQ_206_PRIORITY;
    #endif
    #ifdef IRQ_207_PRIORITY      /* ISR 207 */
       INTC.PSR[207].B.PRI = IRQ_207_PRIORITY;
    #endif
    #ifdef IRQ_208_PRIORITY      /* ISR 208 */
       INTC.PSR[208].B.PRI = IRQ_208_PRIORITY;
    #endif
    #ifdef IRQ_209_PRIORITY      /* ISR 209 */
       INTC.PSR[209].B.PRI = IRQ_209_PRIORITY;
    #endif
    #ifdef IRQ_210_PRIORITY      /* ISR 210 */
       INTC.PSR[210].B.PRI = IRQ_210_PRIORITY;
    #endif
    #ifdef IRQ_211_PRIORITY      /* ISR 211 */
       INTC.PSR[211].B.PRI = IRQ_211_PRIORITY;
    #endif
    #ifdef IRQ_212_PRIORITY      /* ISR 212 */
       INTC.PSR[212].B.PRI = IRQ_212_PRIORITY;
    #endif
    #ifdef IRQ_213_PRIORITY      /* ISR 213 */
       INTC.PSR[213].B.PRI = IRQ_213_PRIORITY;
    #endif
    #ifdef IRQ_214_PRIORITY      /* ISR 214 */
       INTC.PSR[214].B.PRI = IRQ_214_PRIORITY;
    #endif
    #ifdef IRQ_215_PRIORITY      /* ISR 215 */
       INTC.PSR[215].B.PRI = IRQ_215_PRIORITY;
    #endif
    #ifdef IRQ_216_PRIORITY      /* ISR 216 */
       INTC.PSR[216].B.PRI = IRQ_216_PRIORITY;
    #endif
    #ifdef IRQ_217_PRIORITY      /* ISR 217 */
       INTC.PSR[217].B.PRI = IRQ_217_PRIORITY;
    #endif
    #ifdef IRQ_218_PRIORITY      /* ISR 218 */
       INTC.PSR[218].B.PRI = IRQ_218_PRIORITY;
    #endif
    #ifdef IRQ_219_PRIORITY      /* ISR 219 */
       INTC.PSR[219].B.PRI = IRQ_219_PRIORITY;
    #endif
    #ifdef IRQ_220_PRIORITY      /* ISR 220 */
       INTC.PSR[220].B.PRI = IRQ_220_PRIORITY;
    #endif
    #ifdef IRQ_221_PRIORITY      /* ISR 221 */
       INTC.PSR[221].B.PRI = IRQ_221_PRIORITY;
    #endif
    #ifdef IRQ_222_PRIORITY      /* ISR 222 */
       INTC.PSR[222].B.PRI = IRQ_222_PRIORITY;
    #endif
    #ifdef IRQ_223_PRIORITY      /* ISR 223 */
       INTC.PSR[223].B.PRI = IRQ_223_PRIORITY;
    #endif
    #ifdef IRQ_224_PRIORITY      /* ISR 224 */
       INTC.PSR[224].B.PRI = IRQ_224_PRIORITY;
    #endif
    #ifdef IRQ_225_PRIORITY      /* ISR 225 */
       INTC.PSR[225].B.PRI = IRQ_225_PRIORITY;
    #endif
    #ifdef IRQ_226_PRIORITY      /* ISR 226 */
       INTC.PSR[226].B.PRI = IRQ_226_PRIORITY;
    #endif
    #ifdef IRQ_227_PRIORITY      /* ISR 227 */
       INTC.PSR[227].B.PRI = IRQ_227_PRIORITY;
    #endif
    #ifdef IRQ_228_PRIORITY      /* ISR 228 */
       INTC.PSR[228].B.PRI = IRQ_228_PRIORITY;
    #endif
    #ifdef IRQ_229_PRIORITY      /* ISR 229 */
       INTC.PSR[229].B.PRI = IRQ_229_PRIORITY;
    #endif
    #ifdef IRQ_230_PRIORITY      /* ISR 230 */
       INTC.PSR[230].B.PRI = IRQ_230_PRIORITY;
    #endif
    #ifdef IRQ_231_PRIORITY      /* ISR 231 */
       INTC.PSR[231].B.PRI = IRQ_231_PRIORITY;
    #endif
    #ifdef IRQ_232_PRIORITY      /* ISR 232 */
       INTC.PSR[232].B.PRI = IRQ_232_PRIORITY;
    #endif
    #ifdef IRQ_233_PRIORITY      /* ISR 233 */
       INTC.PSR[233].B.PRI = IRQ_233_PRIORITY;
    #endif
}

/***************************************************************************//*!
@brief          System init function define Pictus system

@param[in,out]  void
@param[in]      void

@return         void

@details        The function setup Pictus system behavior

@note           This function initializes the system and interrupt table
                and enable interrupt

*******************************************************************************/
void sys_init(void)
{
    // Initialize clock, operational mode, reset states etc.
    mc_mode_init();

    // Initialize INTC for software vector mode
    intc_init();
}
/******************************************************************************/