/*******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2012 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
****************************************************************************//*!
*
* @file     sys.h
*
* @author   b06050
*
* @version  1.0.2.0
*
* @date     Aug-3-2012
*
* @brief    Header file for system and interrupt initialization functions.
*
*******************************************************************************/
#ifndef __SYS_H
#define __SYS_H

/*******************************************************************************
* Macro definitions
*******************************************************************************/
#define INT_RC_16M          0x0     // Select the source for system/auxiliary
                                    // clock
#define INT_RC_16M_DIV16    0x0
#define CRYST_OSC           0x2
#define PLL0                0x4
#define XOSC                0x0     // Select the source for Clock Out
#define RC_OSC              0x1
#define SYS_FMPLL           0x2
#define SYS_CLK             0x3
#define RTC_CLK             0x3

//------------------------------------------------------------------------------
// Output Clock Enable Register (OCEN)
//------------------------------------------------------------------------------
// EN register
#define CLKOUT_DISABLE              0x1     // output clock is disabled
#define CLKOUT_ENABLE               0x1     // output clock is enabled

//------------------------------------------------------------------------------
// Output Clock Division Select Register (OCDSSC)
//------------------------------------------------------------------------------
// SELDIV bits - select division
#define OCDSSC_CLKOUT_NODIV         0x0     // output clock without division
#define OCDSSC_CLKOUT_DIVBY_2       0x1     // output clock divided by 2
#define OCDSSC_CLKOUT_DIVBY_4       0x2     // output clock divided by 4
#define OCDSSC_CLKOUT_DIVBY_8       0x3     // output clock divided by 8
// SELCTL bits - source selection
#define OCDSSC_CLKOUT_SRC_OSC       0x0     // 4-16MHz crystal oscillator
#define OCDSSC_CLKOUT_SRC_INT       0x1     // 16MHz internal RC oscillator
#define OCDSSC_CLKOUT_SRC_FMPLL     0x2     // FMPLL
#define OCDSSC_CLKOUT_SRC_SYSCLK    0x3     // system slock
#define OCDSSC_CLKOUT_SRC_RTC       0x4     // RTC clock
#define OCDSSC_CLKOUT_SRC_temp5     0x5     // clk_out_src[5]
#define OCDSSC_CLKOUT_SRC_temp6     0x6     // clk_out_src[6]
#define OCDSSC_CLKOUT_SRC_temp7     0x7     // clk_out_src[7]
#define OCDSSC_CLKOUT_SRC_temp8     0x8     // clk_out_src[8]
#define OCDSSC_CLKOUT_SRC_temp9     0x9     // clk_out_src[9]
#define OCDSSC_CLKOUT_SRC_temp10    0xa     // clk_out_src[10]
#define OCDSSC_CLKOUT_SRC_temp11    0xb     // clk_out_src[11]
#define OCDSSC_CLKOUT_SRC_temp12    0xc     // clk_out_src[12]
#define OCDSSC_CLKOUT_SRC_temp13    0xd     // clk_out_src[13]
#define OCDSSC_CLKOUT_SRC_temp14    0xe     // clk_out_src[14]
#define OCDSSC_CLKOUT_SRC_temp15    0xf     // clk_out_src[15]

//------------------------------------------------------------------------------
// System Clock Source selection (ME_DRUN_MC)
//------------------------------------------------------------------------------
// SYSCLK bits
#define SYSCLK_SRC_INT              0x0      // 16MHz internal RC oscillator
#define SYSCLK_SRC_INT_DIV16        0x1      // 16MHz internal RC oscillator /16
#define SYSCLK_SRC_OSC              0x2      // 4MHz crystal oscillator
#define SYSCLK_SRC_OSC_DIV          0x2      // divided 4MHz crystal oscillator
#define SYSCLK_SRC_SYSPLL           0x4      // system PLL
#define SYSCLK_DISABLED             0xf      // system clock is disabled

//------------------------------------------------------------------------------
// Peripheral Set 1 Select Control Register (SC_DC0)
// Used for IIC, LinFlex
//------------------------------------------------------------------------------
// SELCTL bits
#define SCDC0_DIV0(div0)            (div0)   // Divider 0 division value
// DE0 bit
#define SCDC0_DIVIDER_DISABLE       0x0      // Disable auxiliary clock 0 div 0
#define SCDC0_DIVIDER_ENABLE        0x1      // Enable auxiliary clock 0 div 0

//------------------------------------------------------------------------------
// Peripheral Set 2 Select Control Register (SC_DC1)
// Used for DSPI, FlexCAN
//------------------------------------------------------------------------------
// SELCTL bits
#define SCDC1_DIV1(div1)            (div1)   // Divider 1 division value
// DE1 bit
#define SCDC1_DIVIDER_DISABLE       0x0      // Disable auxiliary clock 1 div 0
#define SCDC1_DIVIDER_ENABLE        0x1      // Enable auxiliary clock 1 div 0

//------------------------------------------------------------------------------
// Peripheral Set 3 Select Control Register (SC_DC2)
// Used for ADC_0, ADC_1, CTU, eMIOS
//------------------------------------------------------------------------------
// SELCTL bits
#define SCDC2_DIV2(div2)            (div2)   // Divider 2 division value
// DE2 bit
#define SCDC2_DIVIDER_DISABLE       0x0      // Disable auxiliary clock 2 div 0
#define SCDC2_DIVIDER_ENABLE        0x1      // Enable auxiliary clock 2 div 0

//------------------------------------------------------------------------------
// Mode Enable register (ME_ME)
//------------------------------------------------------------------------------
#define ME_MODE_STANDBY0_DISABLED   0x0     // STANDBY0 mode is disabled
#define ME_MODE_STANDBY0_ENABLED    0x1     // STANDBY0 mode is enabled
#define ME_MODE_STOP0_DISABLED      0x0     // STOP0 mode is disabled
#define ME_MODE_STOP0_ENABLED       0x1     // STOP0 mode is enabled
#define ME_MODE_HALT0_DISABLED      0x0     // HALT0 mode is disabled
#define ME_MODE_HALT0_ENABLED       0x1     // HALT0 mode is enabled
#define ME_MODE_RUN3_DISABLED       0x0     // RUN3 mode is disabled
#define ME_MODE_RUN3_ENABLED        0x1     // RUN3 mode is enabled
#define ME_MODE_RUN2_DISABLED       0x0     // RUN2 mode is disabled
#define ME_MODE_RUN2_ENABLED        0x1     // RUN2 mode is enabled
#define ME_MODE_RUN1_DISABLED       0x0     // RUN1 mode is disabled
#define ME_MODE_RUN1_ENABLED        0x1     // RUN1 mode is enabled
#define ME_MODE_RUN0_DISABLED       0x0     // RUN0 mode is disabled
#define ME_MODE_RUN0_ENABLED        0x1     // RUN0 mode is enabled
#define ME_MODE_DRUN_DISABLED       0x0     // DRUN mode is disabled
#define ME_MODE_DRUN_ENABLED        0x1     // DRUN mode is enabled
#define ME_MODE_SAFE_DISABLED       0x0     // SAFE mode is disabled
#define ME_MODE_SAFE_ENABLED        0x1     // SAFE mode is enabled
#define ME_MODE_TEST_DISABLED       0x0     // TEST mode is disabled
#define ME_MODE_TEST_ENABLED        0x1     // TEST mode is enabled
#define ME_MODE_RESET_DISABLED      0x0     // RESET mode is disabled
#define ME_MODE_RESET_ENABLED       0x1     // RESET mode is enabled

//------------------------------------------------------------------------------
// DRUN mode configuration register (ME_DRUN_MC)
//------------------------------------------------------------------------------
#define DRUN_VOLT_REG_OFF           0x0     // main voltage regulator is off
#define DRUN_VOLT_REG_ON            0x1     // main voltage regulator is on
#define DRUN_DFLASH_POWER_DOWN_MODE 0x1     // data flash is in power-down mode
#define DRUN_DFLASH_LOW_POWER_MODE  0x2     // data flash is in low-power mode
#define DRUN_DFLASH_NORMAL_MODE     0x3     // data flash is in normal mode
#define DRUN_CFLASH_POWER_DOWN_MODE 0x1     // code flash is in power-down mode
#define DRUN_CFLASH_LOW_POWER_MODE  0x2     // code flash is in low-power mode
#define DRUN_CFLASH_NORMAL_MODE     0x3     // code flash is in normal mode
#define DRUN_SYSPLL_OFF             0x0     // system PLL is off
#define DRUN_SYSPLL_ON              0x1     // system PLL is on
#define DRUN_XOSC_OFF               0x0     // 4MHz crystal oscillator is off
#define DRUN_XOSC_ON                0x1     // 4MHz crystal oscillator is on
#define DRUN_INTOSC_OFF             0x0     // 16MHz internal RC oscillator is off
#define DRUN_INTOSC_ON              0x1     // 16MHz internal RC oscillator is on

/*******************************************************************************
* External variables
*******************************************************************************/
extern uint32_t IntcIsrVectorTable[];   // Reference the Vector Table

/*******************************************************************************
* External functions
*******************************************************************************/
extern void sys_init(void);

#endif /* __SYS_H */