/*******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2012 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
****************************************************************************//*!
*
* @file     S12G128_appconfig.h
*
* @author   RC574C
* 
* @version  1.0.2.0
* 
* @date     Jul-27-2012
* 
* @brief    S12G128 BLDC Hall sensor based motor control application
*           configuration parameter header file.
*
*******************************************************************************/

/* MC33937 Deadtime + MC33937 high side turn ON time (in PWM clock ticks) */
#define DELAY                   25                  /* 1us @ 25MHz */

/* Current and voltage sensing point = duty_cycle * SENSING_POINT_FRAC */
//#define BEMF_SENSING_POINT_FRAC FRAC16(0.66254)     /* 21710 */
#define SENSING_POINT_FRAC FRAC16(0.5)         /* 19005 */

/* PWM period in ticks */
#define PWM_MODULO              1250                /* fBUS/20kHz */

/* Duty cycle limit for DC-Bus current measurement */
#define DC_THRESHOLD            234

/* Mechanical speed constant: SPEED_CALC_NUMERATOR = (60 * fTIM1) / 4 */
#define SPEED_CALC_NUMERATOR    15000000
#define SPEED_LOOP_PRESCALER    2                   /* Speed loop period 2ms */

/* Speed PI controller parameters */
#define SPEED_PI_UPPER_LIMIT    FRAC16(0.9)
#define SPEED_PI_LOWER_LIMIT    FRAC16(0.02)  //FRAC16(0.1) //0.175
#define SPEED_PI_CC1            FRAC16(0.01)
#define SPEED_PI_CC2            FRAC16(0.00)

/* Current PI controller parameters */
#define CURRENT_PI_UPPER_LIMIT    FRAC16(0.9)
#define CURRENT_PI_LOWER_LIMIT    FRAC16(0.02) //FRAC16(0.1) //0.175
#define CURRENT_PI_CC1            FRAC16(0.01)
#define CURRENT_PI_CC2            FRAC16(0.04)

/* Voltage values used for scaling - determined by HW voltage sensing */
/* Vref=3.3V => Vdcb=<0,36.025>V, Idcb=<-10,10>A */
#define VOLT_RANGE_MAX          36.025
#define CURR_MAX                10.0    /* 10Amps ~ 3V3 */
#define CURR_MIN                -10.0   /* -10Amps ~ 0V */

/* DC-Bus braking trip voltage [V] */
#define U_DCB_TRIP              28
/* DC-Bus braking trip voltage hysteresis [V]*/
#define U_DCB_TRIP_HYST         1 
/* DC-bus overvoltage limit [V] */
#define DCBUS_OVERVOLT_THRESH   30
/* Brake resistor turn ON time; 1 tick equals 50us; 4000 equals 200ms ON */
#define BRAKE_ON_COUNT_MAX      4000

/* Current limitation threshold */
#define MAX_TORQUE              FRAC16(2.0/CURR_MAX)
#define TORQUE_FILT_CONST       FRAC16(0.16666667)

/* Min/max speed (RPM) */
#define MIN_SPEED               300 //2800
#define MAX_SPEED               9000
#define SPEED_STEP              50

/* LED toggle periods (1ms timebase) */
#define PERIOD_FAULT            64
#define PERIOD_STOP             250

/* User button defines (1ms timebase) */
#define SW_PRESS_LONG           1000
#define SW_PRESS_SHORT_MAX      300
#define SW_PRESS_DEBOUNCE       20

/* FreeMASTER scale constants */
#define FM_U_SCALE              (VOLT_RANGE_MAX * 1000)
#define FM_I_SCALE              (CURR_MAX * 1000)

/* Maximum stall count, period 1 ~ 2ms*/ 
#define MOTOR_STALL_LIMIT       3000 

/* Motor start duty cycle */
#define START_DUTY_CYCLE   100