/*******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2012 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
****************************************************************************//*!
*
* @file     sys.c
*
* @author   B06050
* 
* @version  1.0.1.0
* 
* @date     Jul-10-2012
* 
* @brief    System clock SW module header file.
*
*******************************************************************************/
#include "sys.h"

/*******************************************************************************
*
* Function: void PLL_Init(void)
*
* Description:  This function initializes the PLL and sets system clock to be
*               derived from the PLL clock (valid for 8MHz XOSC)
*
*******************************************************************************/
void PLL_Init(void)
{
    CPMUOSC = 0x80;     /* Enable external oscillator */
    CPMUSYNR = 0x58;    /* VCOFRQ=1, SYNDIV=24 */
    CPMUREFDIV = 0x07;  /* REFFRQ=0, REFDIV=7 */
    CPMUPOSTDIV = 0x00; /* POSTDIV=0 */
    
    /* Wait for PLL to lock */
    while(CPMUFLG_LOCK == 0)
    {
    }
    CPMUCLKS = 0x80;    /* System clock derived from PLL clock, RTI & COP running
                           from IRCCLK */
}