/****************************************************************************//*!
*
* Freescale Semiconductor Inc.
* (c) Copyright 2006-2010 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
********************************************************************************
*
* @file             Can_Isr.c
*
* @date             Feb-23-2012
*
* @version          0.0.1.0
*
* @brief            <b>CAN interrupt service routines source file</b>
*
* @note             MC9S12G128 version
*
*******************************************************************************/

#include "Can.h"
#include "Can_cfg.h"

#pragma CODE_SEG __NEAR_SEG NON_BANKED

/***************************************************************************//*!
*
*    @can_function    Can_ISR_Wake_0
*    @can_sync_async  Asynchronous
*    @can_reentrancy  Non Reentrant
*    @param[in]       None
*    @param[out]      None
*    @return          None
*    @brief           ISR wakeup function for CAN_0.
*    @attention       N/A
*
*******************************************************************************/

void interrupt Can_ISR_Wake_0(void){

  Can_Wakeup(0x00);
}


/***************************************************************************//*!
*
*    @can_function    Can_ISR_Rx_0
*    @can_sync_async  Asynchronous
*    @can_reentrancy  Non Reentrant
*    @param[in]       None
*    @param[out]      None
*    @return          None
*    @brief           ISR receive function for CAN_0.
*    @attention       N/A
*
*******************************************************************************/

void interrupt Can_ISR_Rx_0(void){

  Can_ReceiveData(0x00);
}

#pragma CODE_SEG DEFAULT