/*******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2012 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
****************************************************************************//*!
*
* @file     sci.c
*
* @author   B06050
* 
* @version  1.0.3.0
* 
* @date     Apr-18-2012
* 
* @brief    Serial Communication Interface SW module source file.
*
*******************************************************************************/
#include "sci.h"

/*******************************************************************************
*
* Function: void SCI_0_Init(void)
*
* Description:  This function initializes the SCI module baud rate.
*
* Note:         This function must before a call to FMSTR_Poll function.
*
*******************************************************************************/
void SCI_0_Init(void)
{
    /* SBR = SCI Bus Clock / (16 * Baud Rate),
       SBR = 25e6/(16 * 19200) = 81.38 = 0x51 */
    SCI0BD = 0x0051;
    SCI0CR1 = 0x00;
}