/*
** ###################################################################
**     This code is generated by the Device Initialization Tool.
**     It is overwritten during code generation.
**     USER MODIFICATION ARE PRESERVED ONLY INSIDE INTERRUPT SERVICE ROUTINES
**     OR EXPLICITLY MARKED SECTIONS
**
**     Project   : RS08_WatchDog
**     Processor : MC9RS08KA1CSC
**     Version   : Component 01.069, Driver 01.03, CPU db: 3.00.020
**     Datasheet : MC9RS08KA2 Rev. 3 9/2007
**     Date/Time : 6/2/2012, 8:01 AM
**     Abstract  :
**         This module contains device initialization code 
**         for selected on-chip peripherals.
**     Contents  :
**         Function "MCU_init" initializes selected peripherals
**
**     Copyright : 1997 - 2009 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################
*/

/* MODULE MCU_Init */

#include <MC9RS08KA2.h>                /* I/O map for MC9RS08KA1CSC */
#include "MCU_Init.h"

/* User declarations and definitions */
/*   Code, declarations and definitions here will be preserved during code generation */
/* End of user declarations and definitions */


/*
** ===================================================================
**     Method      :  MCU_init (component MC9RS08KA2_8)
**
**     Description :
**         Device initialization code for selected peripherals.
** ===================================================================
*/
void MCU_init(void)
{
  /* ### MC9RS08KA2_8 "Cpu" init code ... */
  /*  PE initialization code after reset */

  /* Common initialization of the write once registers */
  /* SOPT: COPE=1,COPT=0,STOPE=0,BKGDPE=1,RSTPE=1 */
  SOPT = 131;                                      
  /* SPMSC1: LVDF=0,LVDACK=0,LVDIE=0,LVDRE=1,LVDSE=1,LVDE=1,BGBE=0 */
  SPMSC1 = 28;                                      
  /*  System clock initialization */
  if (*(unsigned char* __paged)CONVERT_TO_PAGED(16378) != 255) { /* Test if the device trim value is stored on the specified address */
    ICSTRM = *(unsigned char* __paged)CONVERT_TO_PAGED(16378); /* Initialize ICSTRM register from a non volatile memory */
    ICSSC = *(unsigned char* __paged)CONVERT_TO_PAGED(16379); /* Initialize ICSSC register from a non volatile memory */
  }
  /* ICSC1: CLKS=1,IREFSTEN=0 */
  ICSC1 = 64;                          /* Initialization of the ICS control register 1 */
  /* ICSC2: BDIV=0,LP=1 */
  ICSC2 = 8;                           /* Initialization of the ICS control register 2 */
  /* Common initialization of the CPU registers */
  /* PTASE: PTASE5=1,PTASE4=1,PTASE3=1,PTASE1=1,PTASE0=1 */
  PTASE |= (unsigned char)59;                      
  /* ### Init_GPIO init code */
  /* PTAD: PTAD5=0,PTAD4=0,PTAD1=1,PTAD0=0 */
  PTAD = (PTAD & (unsigned char)~49) | (unsigned char)2;
  /* PTAPUD: PTAPUD5=0,PTAPUD4=0,PTAPUD1=0,PTAPUD0=0 */
  PTAPUD &= (unsigned char)~51;                     
  /* PTAPE: PTAPE5=1,PTAPE4=0,PTAPE1=0,PTAPE0=0 */
  PTAPE = (PTAPE & (unsigned char)~19) | (unsigned char)32;
  /* PTADD: PTADD5=0,PTADD4=0,PTADD1=0,PTADD0=0 */
  PTADD &= (unsigned char)~51;                     
  /* ### Init_COP init code */
  SRS = 255;                           /* Clear WatchDog counter */
  /* ### Init_MTIM init code */
  /* MTIMMOD: MOD7=1,MOD6=1,MOD5=1,MOD4=1,MOD3=1,MOD2=1,MOD1=1,MOD0=1 */
  MTIMMOD = 255;                                      
  /* MTIMCLK: CLKS1=0,CLKS0=0,PS3=0,PS2=1,PS1=1,PS0=1 */
  MTIMCLK = 7;                                      
  (void)(MTIMSC == 0);                 /* Overflow int. flag clearing (first part) */
  /* MTIMSC: TOF=0,TOIE=0,TRST=1,TSTP=0 */
  MTIMSC = 32;                         /* Int. flag clearing (2nd part) and timer control register setting */
  /* ### */
} /*MCU_init*/



/* Initialization of the reset vector */
extern void _Startup(void);

static const unsigned char JMPOpcode             @16381 = 188; /* Opcode of JMP extended */
static void far (*const ResetVector)(void)       @16382 = _Startup;

/* Initialization of the CPU registers in FLASH */

/* NVOPT: SECD=1 */
const unsigned char NVOPT_INIT @0x00003FFC = 255;


/* END MCU_Init */

/*
** ###################################################################
**
**     This file was created by Processor Expert 3.07 [04.34]
**     for the Freescale RS08 series of microcontrollers.
**
** ###################################################################
*/
