/**************************************************************************/
/* FILE NAME: $RCSfile: pwm_example1.h,v $   COPYRIGHT (c) FREESCALE 2007 */
/*                                                All Rights Reserved     */
/* DESCRIPTION:                                                           */
/* This file contains prototypes and definitions for the sample MPC5500   */
/* program using the the eTPU.                                            */
/*========================================================================*/
/* ORIGINAL AUTHOR: David Paterson                                        */ 
/* $Log: pwm_example1.h,v $
/* Revision 2.2  2007/09/19 12:36:57  r43562
/* updated comments, code layout
/*											      */
/*																		  */
/**************************************************************************/

#include "etpu_util.h"

/* define functions to channels */
#define PWM0  0
#define PWM1  1

#define ETPU_OUTPUT_PAD_CONFIG FS_GPIO_DRIVE_STRENGTH_50PF + \
							   FS_GPIO_MAXIMUM_SLEW_RATE + \
                               FS_GPIO_OUTPUT_DRAIN_DISABLE + \
                               FS_GPIO_READBACK_ENABLE + \
                               FS_GPIO_OUTPUT_BUFFER_ENABLE
                               
struct etpu_config_t my_etpu_config = {
	FS_ETPU_MISC_ENABLE,	//MCR register

	FS_ETPU_MISC,			//MISC value from eTPU compiler link file

	//Configure eTPU engine A
	FS_ETPU_FILTER_CLOCK_DIV8 +
	FS_ETPU_CHAN_FILTER_3SAMPLE +
	FS_ETPU_ENTRY_TABLE,

	//Configure eTPU engine A timebases
	FS_ETPU_TCR2CTL_DIV8 +
	( 7 << 16) +     //TCR2 prescaler of 8 (7+1)
	FS_ETPU_TCR1CTL_DIV2 +
	0,               //TCR1 prescaler of 1 (0+1)

	0,

	//Configure eTPU engine b
	FS_ETPU_FILTER_CLOCK_DIV4 +
    FS_ETPU_CHAN_FILTER_3SAMPLE +
	FS_ETPU_ENTRY_TABLE,

	//Configure eTPU engine B timebases
	FS_ETPU_TCR2CTL_DIV8 +
	( 7 << 16) +     //TCR2 prescaler of 8 (7+1)
	FS_ETPU_TCR1CTL_DIV2 +
	3,

	0
	};

/* function prototypes */
void mpc5500_init();
int16_t MySystem_etpu_init ();


