/**************************************************************************/
/* FILE NAME: $RCSfile: pwm_example1.c,v $   COPYRIGHT (c) Freescale 2007 */
/*                                                All Rights Reserved     */
/* DESCRIPTION:                                                           */
/* This is a sample MPC5500 program to show a top down approach to using  */
/* the eTPU.                                                              */
/* It presents a simplifed idea for initializing the device in order to   */
/* concentrate on the eTPU. This first pass assumes an initialization tool*/
/* is not used.                                                           */
/*========================================================================*/
/* ORIGINAL AUTHOR: David Paterson                                        */ 
/* $Log: pwm_example1.c,v $
/* Revision 2.3  2007/09/19 12:36:41  r43562
/* updated comments, integer 'x' to volatile, code layout
/*											      */
/*																		  */
/**************************************************************************/

/* Freescale provided include files */
#include "PXR4040.h"        	/* PXR4040 register definitions. */
#include "etpu_util.h"   		/* useful utility routines. */
#include "fs_gpio.h"
#include "_etpu_set\etpu_set.h"		/* eTPU standard function set 1 */
#include "etpu_pwm.h"       			/* eTPU PWM API */

/* User written include files */
#include "pwm_example1.h"  				/* include application specific defines. */

#include "mpc5674f_vars.h"

int32_t init_error;    					/* initialization error code. */
uint32_t *fs_free_param;
uint32_t q;

const uint32_t etpu_a_tcr1_freq = 15000000; /* 60 MHz/2=30 MHz(eTPU clock)/2(prescaler) = 15 MHz */

main()
{
	int new_freq;
	volatile int x;
	int32_t error_code; /* Returned value from etpu API functions */
	
	
    /* initialize eTPU hardware */
    fs_etpu_init( 	my_etpu_config, 
    				(uint32_t *)etpu_code, 
    				sizeof(etpu_code),
                    (uint32_t *)etpu_globals, 
                    sizeof(etpu_globals)
                );
					
	/* initialize eTPU channels */
    /* initialize channel PWM0 to:                           */
    /* 1000hz, 25%, active high, middle priority using TCR1 (64MHz) */
	error_code = fs_etpu_pwm_init (
									PWM0, 						/* channel */
									FS_ETPU_PRIORITY_MIDDLE, 	/* priority */
									1000, 						/* frequency */
									2500, 						/* duty */
									FS_ETPU_PWM_ACTIVEHIGH, 	/* polarity */
									FS_ETPU_TCR1, 				/* timebase */
									etpu_a_tcr1_freq			/* timebase frequency */
								   ); 
                                
    /* config pin */
    fs_gpio_config ( FS_GPIO_ETPUA0, FS_GPIO_PRIMARY_FUNCTION + ETPU_OUTPUT_PAD_CONFIG);			
	
	/* Enable all timebases */
	fs_timer_start (); 
	
	/* Delay */
	for(x=0; x<0x1000000; x++);	
	
	/* 2000hz, 60%, active high, middle priority using TCR1 (1MHz) */
	error_code = fs_etpu_pwm_update (PWM0, 2000, 6000, etpu_a_tcr1_freq); 
	
	/* Measure new frequency */
	new_freq = fs_etpu_pwm_get_freq(PWM0, etpu_a_tcr1_freq);		
	
	while(1); /* Wait forever */


}



