#include "PXR4040.h"
#include "pwm_etpu_gct.h"

void initSysclk_at_256_MHz (void) {
	FMPLL.ESYNCR2.R = 0x00000003; /* Change clk to PLL normal mode from crystal, initially 128 MHz with 40 MHz crystal */
	FMPLL.ESYNCR1.R = 0xF0040030;/* EPREDIV = 4; EMFD = 48; CLKCFG = 7 */
	while (FMPLL.SYNSR.B.LOCK != 1) {};/* Wait for FMPLL to LOCK */
	FMPLL.ESYNCR2.R = 0x00000001; /* Change divider final value for 256 MHz sysclk */
}

int main(void) {
	volatile int i = 0;
	
	initSysclk_at_256_MHz(); /* Init system clock at 256 MHz*/
	
	SIU.PCR[114].R = 0x0600; /* Enable ETPU_A Channel 0 as output */
	
	my_system_etpu_init (); /* Init the eTPU engine and eTPU channels */
	my_system_etpu_start(); /* Start eTPU (and eMIOS) timers */
	
	/* Loop forever */
	for (;;) {
		i++;
	}
}


