/******************************************************************************
* 
* Copyright (c) 2012 Freescale Semiconductor;
* All Rights Reserved                       
*
*******************************************************************************
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
/*!
********************************************************************************
*
* FILE NAME: ADC12_test.c   
*
* TARGET: MC56F8400 device
*
*******************************************************************************
*
* Detailed Description of the file.
*
***************************************************************************//*!

/*Include shared modules, which are used for whole project*/
#include "Types.h"
#include "derivative.h"
#include "ADC12_cfg.h"

/***************************************************************************//*!
*
* @brief   ADC Cyclic Module Initialization
*
* @param   void
*
* @return  none
*
******************************************************************************
*
*      
*
******************************************************************************/
void ADC12_Init(void)
{
	/* set GPIO_A as ADC inputs */
	SIM_PCE0 |= SIM_PCE0_GPIOA; // Enable GPIOA clock
	GPIOA_PER = 0x00FFU;       // PER Enable for GPIOA 0-7
	
	/* set GPIO_B as ADC inputs */
	SIM_PCE0 |= SIM_PCE0_GPIOB; // Enable GPIOB clock
	GPIOB_PER = 0x00FFU;       // PER Enable for GPIOB 0-7
	
	SIM_PCE2 |= SIM_PCE2_CYCADC; // enable clock to ADC modules
		
	/* ADC registers */
	ADC12_CTRL1 = 0x9805U;   //SMODE - triggered parallel, SYNC0 - enabled, End of scan ISR enabled
	ADC12_CTRL2  |= ADC12_CTRL2_DIV0_2 | ADC12_CTRL2_SIMULT; // Simultaneous parallel mode; DIV0 = 2 
	ADC12_CLIST1 = 0x3210U; // SAMPLE3 - ANA3, SAMPLE2 - ANA2,SAMPLE1 - ANA1, SAMPLE0 - ANA0
	ADC12_CLIST2 = 0x7654U; // SAMPLE7 - ANA7, SAMPLE6 - ANA6,SAMPLE5 - ANA5, SAMPLE4 - ANA4
	ADC12_CLIST3 = 0xBA98U; // SAMPLE11 - ANB3, SAMPLE10 - ANB2,SAMPLE9 - ANB1, SAMPLE8 - ANB0
	ADC12_CLIST4 = 0xFEDCU; // SAMPLE14 - ANB7, SAMPLE14 - ANB6,SAMPLE13 - ANB5, SAMPLE12 - ANB4
	ADC12_SDIS   = 0x0000U; // enable ADC channels 0&8 -> ANA0 (pin 22), ANB0 (pin33)
	ADC12_PWR 	 = 0x01A0U; // power-up delay set to 26 clocks
	ADC12_PWR2	 = 0x0405U; // ADCA Speed <=10MHz; ADCB Speed<=10MHz; DIV1 = 2
	
	XBARA_SEL6 = 0x0014U; //trigger signal connected to PWMB0 trigger - XBAR_IN10
	
}


/******************************************************************************/
/**************************         END          ******************************/
/******************************************************************************/