/******************************************************************************
* 
* Copyright (c) 2012 Freescale Semiconductor;
* All Rights Reserved                       
*
*******************************************************************************
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
/*!
********************************************************************************
*
* FILE NAME: Events.c   
*
* TARGET: MC56F8400 device
*
*******************************************************************************
*
* Detailed Description of the file.
*
***************************************************************************//*!*/

#include "Types.h"
#include "Cpu.h"
#include "Events.h"
#include "Main.h"


extern uint16_t  ui16ADCresults[16];
extern PWMA_REG_UPDATE  udtPWMAvalreg;
extern PWMB_REG_READ    udtPWMBcapreg;
/***************************************************************************//*!
*
* @brief   CPU ISR
*
* @param   void
*
* @return  none
*
******************************************************************************
*
*      
*
******************************************************************************/
#pragma interrupt alignsp
void Cpu_Interrupt(void)
{
  setReg16Bits(INTC_CTRL, 0x20);		/*Disable all interrupts*/
  while(1);// shouldn't reach here 
}

/***************************************************************************//*!
*
* @brief   DMA0 Transfer Completed ISR
*
* @param   void
*
* @return  none
*
******************************************************************************
*
******************************************************************************/
#pragma interrupt saveall
void DMA0_ISR()
{
	/* set DMA0 channel for new transfer */
	DMA0_Preset(&udtPWMBcapreg);
}	

/***************************************************************************//*!
*
* @brief   DMA1 Transfer Completed ISR
*
* @param   void
*
* @return  none
*
******************************************************************************
*
******************************************************************************/
#pragma interrupt alignsp
void DMA1_ISR(void)
{
	// set source and destination addresses
	DMA_SAR1 = ((uint32_t)(&ADC12_RSLT0)<<1);
	DMA_DAR1 = ((uint32_t)(ui16ADCresults)<<1);
	// clear all status register
	DMA_DSR_BCR1 |= DMA_DSR_BCR1_DONE;
	// set byte number to be transfered
	DMA_DSR_BCR1 |= (DMA_DSR_BCR1_BCR & 32);
	
}
/***************************************************************************//*!
*
* @brief   DMA2 Transfer Completed ISR
*
* @param   void
*
* @return  none
*
******************************************************************************
*
******************************************************************************/
#pragma interrupt saveall
void DMA2_ISR()
{
	/* set DMA2 channel for new transfer */
	DMA2_Preset(&udtPWMAvalreg);
}	



/* END Events */
