/******************************************************************************
* 
* Copyright (c) 2012 Freescale Semiconductor;
* All Rights Reserved                       
*
*******************************************************************************
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
/*!
********************************************************************************
*
* FILE NAME: PWM_A_test.c   
*
* TARGET: MC56F8400 device
*
*******************************************************************************
*
* Detailed Description of the file.
*
***************************************************************************//*!

/*Include shared modules, which are used for whole project*/
#include "Types.h"
#include "derivative.h"
#include "PWM_A_cfg.h"

/***************************************************************************//*!
*
* @brief   PWMA Module Initialization
*
* @param   void
*
* @return  none
*
******************************************************************************
*
*      
*
******************************************************************************/
void PWM_A_Init(PWMA_REG_UPDATE *ptr)
{
	/* set GPIOE pins 0-5 as PWM_A outputs  */
	SIM_PCE0 	|= SIM_PCE0_GPIOE; // Enable GPIOE clock
	GPIOE_PER 	|= (GPIOE_PER_PE_0 | GPIOE_PER_PE_1); 	// Enabled PWM peripheral on GPIO_E
	
	GPIOE_DDR |= GPIOE_DDR_DD_8 | GPIOE_DDR_DD_9;  //debug pins to check ISR functionality
	
	/* enable PWMA clock to SM0 */
	SIM_PCE3 	|= SIM_PCE3_PWMACH0; // Enable PWM Module Clock
	
	/***************************************************************************************/
	/* SM0 Module */
	PWMA_SM0CTRL 	= PWMA_SM0CTRL_FULL;  // full reload cycle
	PWMA_SM0CTRL2 	= PWMA_SM0CTRL2_FORCE_SEL_1; // Local Reload signal from this submodule 
	
	/* set 16kHz PWM period --> 62.5us = 10ns * 3125 * 2   */
	PWMA_SM0INIT = -3125; 
	PWMA_SM0VAL0 = 0;	
	PWMA_SM0VAL1 = 3124;  
		
	PWMA_SM0VAL2 = -(PWMA_SM0VAL1>>1); //50% duty cycle
	PWMA_SM0VAL3 = PWMA_SM0VAL1>>1;    //50% duty cycle

	PWMA_SM0VAL4 = 0; 
	PWMA_SM0VAL5 = 0;
	
	/* dead time = 1us */
	PWMA_SM0DTCNT0 = 100;
	PWMA_SM0DTCNT1 = 100;
	
	/* disable all faults */
	PWMA_SM0DISMAP0 = 0;
	PWMA_SM0DISMAP1 = 0;
	
	PWMA_OUTEN = (PWMA_OUTEN_PWMA_EN_0 | PWMA_OUTEN_PWMB_EN_0); // Enable output on PWMA_A0 &, PWMA_B0
		
	// Value registers DMA enable
	PWMA_SM0DMAEN = PWMA_SM0DMAEN_VALDE;  /* enable PWM value register update using DMA transfer */
	
	PWMA_MCTRL |= PWMA_MCTRL_CLDOK; // Clear LDOK bit 
	PWMA_MCTRL |= PWMA_MCTRL_LDOK; // LDOK
	PWMA_MCTRL |= PWMA_MCTRL_RUN; // Enable clock 
	
	/* Module SM0 */
	ptr->SM0.pwmsmval0 		= PWMA_SM0VAL0;
	ptr->SM0.pwmsmfracval1 	= PWMA_SM0FRACVAL1;
	ptr->SM0.pwmsmval1 		= PWMA_SM0VAL1;
	ptr->SM0.pwmsmfracval2 	= PWMA_SM0FRACVAL2;
	ptr->SM0.pwmsmval2 		= PWMA_SM0VAL2;
	ptr->SM0.pwmsmfracval3 	= PWMA_SM0FRACVAL3;
	ptr->SM0.pwmsmval3 		= PWMA_SM0VAL3;
	ptr->SM0.pwmsmfracval4 	= PWMA_SM0FRACVAL4;
	ptr->SM0.pwmsmval4 		= PWMA_SM0VAL4;
	ptr->SM0.pwmsmfracval5 	= PWMA_SM0FRACVAL5;
	ptr->SM0.pwmsmval5 		= PWMA_SM0VAL5;
	
		
	/* trigger signal 0 used to synchronize ADC via XBAR */
	PWMA_SM0TCTRL |= PWMA_SM0TCTRL_OUT_TRIG_EN_0;
		
}


/******************************************************************************/
/**************************         END          ******************************/
/******************************************************************************/