/******************************************************************************
* 
* Copyright (c) 2012 Freescale Semiconductor;
* All Rights Reserved                       
*
*******************************************************************************
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
/*!
********************************************************************************
*
* FILE NAME: PWM_B_Init.c   
*
* TARGET: MC56F8400 device
*
*******************************************************************************
*
* Detailed Description of the file.
*
***************************************************************************//*!

/*Include shared modules, which are used for whole project*/
#include "Types.h"
#include "derivative.h"
#include "PWM_B_cfg.h"

/***************************************************************************//*!
*
* @brief   PWMB Module Initialization
*
* @param   void
*
* @return  none
*
******************************************************************************
*
*      
*
******************************************************************************/
void PWM_B_Init(PWMB_REG_READ *ptr)
{
	/* set GPIOG pins 2,3,8 as PWMB_0A&B&X inputs  */
	SIM_PCE0 	|= SIM_PCE0_GPIOG; 							// Enable GPIOG clock
	GPIOG_PER |= (GPIOG_PER_PE_2 | GPIOG_PER_PE_3 | GPIOG_PER_PE_8); 		// Enabled PWM peripheral on GPIO_G
	
	
	/* enable PWM_B clock to SM0 */
	SIM_PCE3 	|= SIM_PCE3_PWMBCH0 ; // Enable PWM Module Clock
	
	/***************************************************************************************/
	/* SM0 Module */
	PWMB_SM0CTRL 	= PWMB_SM0CTRL_FULL;  // full reload cycle
	PWMB_SM0CTRL2 	= PWMB_SM0CTRL2_FORCE_SEL_1; // Local Reload signal from this submodule 
	
	/* set 10kHz PWM period --> 100us = 10ns * 5000 * 2   */
	PWMB_SM0INIT = -5000; 
	PWMB_SM0VAL0 = 0;	
	PWMB_SM0VAL1 = 4999;  
		
	PWMB_SM0VAL2 = 0; 
	PWMB_SM0VAL3 = 0; 

	PWMB_SM0VAL4 = 0; 
	PWMB_SM0VAL5 = 0;
	
	/* dead time = 0us */
	PWMB_SM0DTCNT0 = 0;
	PWMB_SM0DTCNT1 = 0;
	
	/* disable all faults */
	PWMB_SM0DISMAP0 = 0;
	PWMB_SM0DISMAP1 = 0;
	
	/* capture mode to capture rising and falling edge*/
	PWMB_SM0CAPTCTRLA |=   PWMB_SM0CAPTCTRLA_EDGA0_0 | PWMB_SM0CAPTCTRLA_EDGA1_1 ;
	PWMB_SM0CAPTCTRLB |=   PWMB_SM0CAPTCTRLB_EDGB0_0 | PWMB_SM0CAPTCTRLB_EDGB1_1 ;
	PWMB_SM0CAPTCTRLX |=   PWMB_SM0CAPTCTRLX_EDGX0_0 | PWMB_SM0CAPTCTRLX_EDGX1_1 ;

	/* start free-running capture */
	PWMB_SM0CAPTCTRLA |= PWMB_SM0CAPTCTRLA_ARMA;
	PWMB_SM0CAPTCTRLB |= PWMB_SM0CAPTCTRLB_ARMB;
	PWMB_SM0CAPTCTRLX |= PWMB_SM0CAPTCTRLX_ARMX;
		
	PWMB_MCTRL |= PWMB_MCTRL_CLDOK; // Clear LDOK bit 
	PWMB_MCTRL |= PWMB_MCTRL_LDOK; // LDOK
	PWMB_MCTRL |= PWMB_MCTRL_RUN; // Enable clock 
	
	/* enable DMA request on local sync event*/
	PWMB_SM0DMAEN |= PWMB_SM0DMAEN_CAPTDE_1; 
}

/***************************************************************************//*!
*
* @brief   PWMB Module Capture Register Reading
*
* @param   void
*
* @return  none
*
******************************************************************************
*
*      
*
******************************************************************************/
void PWM_B_Read_Cap(PWMB_REG_READ *ptr)
{
	/* Module SM0 */
	ptr->SM0.pwmsmcval0 	= PWMB_SM0CVAL0;
	ptr->SM0.pwmsmcval0cyc 	= PWMB_SM0CVAL0CYC;
	ptr->SM0.pwmsmcval1 	= PWMB_SM0CVAL1;
	ptr->SM0.pwmsmcval1cyc 	= PWMB_SM0CVAL1CYC;
	ptr->SM0.pwmsmcval2 	= PWMB_SM0CVAL2;
	ptr->SM0.pwmsmcval2cyc 	= PWMB_SM0CVAL2CYC;
	ptr->SM0.pwmsmcval3 	= PWMB_SM0CVAL3;
	ptr->SM0.pwmsmcval3cyc 	= PWMB_SM0CVAL3CYC;
	ptr->SM0.pwmsmcval4 	= PWMB_SM0CVAL4;
	ptr->SM0.pwmsmcval4cyc 	= PWMB_SM0CVAL4CYC;
	ptr->SM0.pwmsmcval5 	= PWMB_SM0CVAL5;
	ptr->SM0.pwmsmcval5cyc 	= PWMB_SM0CVAL5CYC;

}
/******************************************************************************/
/**************************         END          ******************************/
/******************************************************************************/