/*                                                                                 
 * File:		plat_l1pt.c                                                            
 * Purpose:		Main process                                                         
 *                                                                                 
 */                                                                                
                                                                                   
#include "common.h"                                                                
#include "FC_protocol.h"                                                           
#include "uart.h"                                                                 
#include "sysinit.h"                                                               
#include "flash_FTFL.h"   
#include "flag.h"
               
#include "iic_slave.h"                                                                              
                                                   
/********************************************************************/             
int main(void)                                                                     
{  
	uint32_t uiWorkMode;
	uint32_t uiCurrentAddress;
                                                
	//printf("start!\n");
    uiWorkMode = Check_WorkMode(FLASH_FLAG_START_ADDRESS,FLASH_FLAG_END_ADDRESS,
                         &uiCurrentAddress);
    
	if( uiWorkMode == WORK_MODE_USER_APP )
	{
		SCB_VTOR = RELOCATION_VERTOR_ADDR;                                       
		JumpToUserApplication(RELOCATION_VERTOR_ADDR); 
	}
	else
	{
        FC_Init(); 
        IIC_Init();
        while(1)
		{
			FC_Check();
		}
	}
}
                                                                        
 
                              
/********************************************************************/             
