/**************************************************************************
 * FILE NAME: MPC5746R.h                     COPYRIGHT (c) Freescale 2013 *
 * REVISION:  0.3.0                                   All Rights Reserved *
 *                                                                        *
 * DESCRIPTION:                                                           *
 * This file contains all of the register and bit field definitions for   *
 * the MPC5746R.                                                          *
 *========================================================================*
 * UPDATE HISTORY                                                         *
 * REV      AUTHOR      DATE       DESCRIPTION OF CHANGE                  *
 * ---   -----------  ---------    ---------------------                  *
 * 0.1      M.D.      27-FEB-13     -First release.                       *
 *                                                                        *
 * 0.2      M.D.      01-MAR-13     -PASS module PG.LOCK3 changed bit     *
 *                                   256LCK_U to L256LCK_U                *
 *                                  -SIUL2 module MSCR changed to array   *
 *                                   MSCR0_255[256] & MSCR512_955[484]    *
 *                                  -eTPU_CCCR module ENG1_C needed ';'   *
 *                                  -Memory definitions for SMPU added '_'*    
 *                                                                        *
 * 0.3      M.D.      23-AUG-13     -Regenerated per RM v3                *
 *                                    -eMIOS module is omitted            * 
 *                                                                        * 
 *========================================================================*
 * COPYRIGHT:                                                             *
 *  Freescale Semiconductor, INC. All Rights Reserved. You are hereby     *
 *  granted a copyright license to use, modify, and distribute the        *
 *  SOFTWARE so long as this entire notice is retained without alteration *
 *  in any modified and/or redistributed versions, and that such modified *
 *  versions are clearly identified as such. No licenses are granted by   *
 *  implication, estoppel or otherwise under any patentsor trademarks     *
 *  of Freescale Semiconductor, Inc. This software is provided on an      *
 *  "AS IS" basis and without warranty.                                   *
 *                                                                        *
 *  To the maximum extent permitted by applicable law, Freescale          *
 *  Semiconductor DISCLAIMS ALL WARRANTIES WHETHER EXPRESS OR IMPLIED,    *
 *  INCLUDING IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A      *
 *  PARTICULAR PURPOSE AND ANY WARRANTY AGAINST INFRINGEMENT WITH REGARD  *
 *  TO THE SOFTWARE (INCLUDING ANY MODIFIED VERSIONS THEREOF) AND ANY     *
 *  ACCOMPANYING WRITTEN MATERIALS.                                       *
 *                                                                        *
 *  To the maximum extent permitted by applicable law, IN NO EVENT        *
 *  SHALL Freescale Semiconductor BE LIABLE FOR ANY DAMAGES WHATSOEVER    *
 *  (INCLUDING WITHOUT LIMITATION, DAMAGES FOR LOSS OF BUSINESS PROFITS,  *
 *  BUSINESS INTERRUPTION, LOSS OF BUSINESS INFORMATION, OR OTHER         *
 *  PECUNIARY LOSS) ARISING OF THE USE OR INABILITY TO USE THE SOFTWARE.  *
 *                                                                        *
 *  Freescale Semiconductor assumes no responsibility for the             *
 *  maintenance and support of this software                              *
 *                                                                        *
 **************************************************************************/
/*>>>>>>> NOTE! this file is auto-generated please do not edit it! <<<<<<<*/

/**************************************************************************
 * Example register & bit field write:                                    *
 *                                                                        *
 *  <MODULE>.<REGISTER>.B.<BIT> = 1;                                      *
 *  <MODULE>.<REGISTER>.R       = 0x10000000;                             *
 *                                                                        *
 **************************************************************************/

#ifndef _mpc5746r_H_
#define _mpc5746r_H_
#include "typedefs.h"
#ifdef __cplusplus
extern "C" {
#endif
#ifdef __MWERKS__
#pragma push
#pragma ANSI_strict off
#endif
#ifdef __ghs__
#pragma ghs nowarning 618
#endif


/* ============================================================================
   =============================== Module: ADC ================================
   ============================================================================ */

struct ADC_tag {
  union {                              /* Main Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t OWREN:1;               /* Overwrite enable. */
      vuint32_t WLSIDE:1;              /* Write Left/Right aligned. */
      vuint32_t MODE:1;                /* One_Shot/Scan. */
      vuint32_t  :1;                   /* Reserved. */
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t NSTART:1;
      vuint32_t  :1;
      vuint32_t JTRGEN:1;              /* Injection external trigger enable. */
      vuint32_t JEDGE:1;               /* Injection trigger edge selection. */
      vuint32_t JSTART:1;              /* Injection start. */
      vuint32_t  :2;
      vuint32_t CTUEN:1;               /* Crosstrigger Unit Enable. */
      vuint32_t CTU_MODE:1;            /* Crosstrigger Unit MODE bit */
      vuint32_t STCL:1;                /* Self Testing Configuration Lock. */
      vuint32_t  :6;
      vuint32_t ADCLKSEL:1;            /* Analog Clock frequency Selector. */
      vuint32_t ABORT_CHAIN:1;         /* Abort Chain. */
      vuint32_t ABORT:1;               /* Abort Conversion. */
      vuint32_t ACKO:1;                /* Auto clock off enable. */
      vuint32_t  :2;
      vuint32_t REFSEL:2;              /* Reference voltage selection for ADC analog part. */
      vuint32_t PWDN:1;                /* Power-down enable. */
    } B;
  } MCR;

  union {                              /* Main Status register */
    vuint32_t R;
    struct {
      vuint32_t CALIBRTD:1;            /* This bit indicates the ADC calibration status. */
      vuint32_t  :6;
      vuint32_t NSTART:1;              /* This status bit is used to signal that a Normal conversion is ongoing. */
      vuint32_t JABORT:1;
      vuint32_t  :2;
      vuint32_t JSTART:1;              /* This status bit is used to signal that an Injected conversion is ongoing. */
      vuint32_t  :1;
      vuint32_t SELF_TEST_S:1;         /* This status bit signals that self test conversion is ongoing. */
      vuint32_t  :1;
      vuint32_t CTUSTART:1;            /* This status bit is used to signal that a CTU conversion is ongoing. */
      vuint32_t CHADDR:7;              /* Channel under measure address. */
      vuint32_t  :3;
      vuint32_t ACKO:1;                /* Auto clock off enable. */
      vuint32_t  :2;
      vuint32_t ADCSTATUS:3;           /* Status of the ADC. */
    } B;
  } MSR;

  uint8_t ADC_reserved0[8];
  union {                              /* Interrupt Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :27;
      vuint32_t EOCTU:1;
      vuint32_t JEOC:1;                /* End of injected channel conversion. */
      vuint32_t JECH:1;                /* End of injected chain conversion. */
      vuint32_t EOC:1;                 /* End of channel conversion. */
      vuint32_t ECH:1;                 /* End of chain conversion. */
    } B;
  } ISR;

  union {                              /* Channel Pending register 0 */
    vuint32_t R;
    struct {
      vuint32_t EOCCH31:1;             /* EOC Channel 31. */
      vuint32_t EOCCH30:1;             /* EOC Channel 30. */
      vuint32_t EOCCH29:1;             /* EOC Channel 29. */
      vuint32_t EOCCH28:1;             /* EOC Channel 28. */
      vuint32_t EOCCH27:1;             /* EOC Channel 27. */
      vuint32_t EOCCH26:1;             /* EOC Channel 26. */
      vuint32_t EOCCH25:1;             /* EOC Channel 25. */
      vuint32_t EOCCH24:1;             /* EOC Channel 24. */
      vuint32_t EOCCH23:1;             /* EOC Channel 23. */
      vuint32_t EOCCH22:1;             /* EOC Channel 22. */
      vuint32_t EOCCH21:1;             /* EOC Channel 21. */
      vuint32_t EOCCH20:1;             /* EOC Channel 20. */
      vuint32_t EOCCH19:1;             /* EOC Channel 19. */
      vuint32_t EOCCH18:1;             /* EOC Channel 18. */
      vuint32_t EOCCH17:1;             /* EOC Channel 17. */
      vuint32_t EOCCH16:1;             /* EOC Channel 16. */
      vuint32_t EOCCH15:1;             /* EOC Channel 15. */
      vuint32_t EOCCH14:1;             /* EOC Channel 14. */
      vuint32_t EOCCH13:1;             /* EOC Channel 13. */
      vuint32_t EOCCH12:1;             /* EOC Channel 12. */
      vuint32_t EOCCH11:1;             /* EOC Channel 11. */
      vuint32_t EOCCH10:1;             /* EOC Channel 10. */
      vuint32_t EOCCH9:1;              /* EOC Channel 9. */
      vuint32_t EOCCH8:1;              /* EOC Channel 8. */
      vuint32_t EOCCH7:1;              /* EOC Channel 7. */
      vuint32_t EOCCH6:1;              /* EOC Channel 6. */
      vuint32_t EOCCH5:1;              /* EOC Channel 5. */
      vuint32_t EOCCH4:1;              /* EOC Channel 4. */
      vuint32_t EOCCH3:1;              /* EOC Channel 3. */
      vuint32_t EOCCH2:1;              /* EOC Channel 2. */
      vuint32_t EOCCH1:1;              /* EOC Channel 1. */
      vuint32_t EOCCH0:1;              /* EOC Channel 0. */
    } B;
  } CEOCFR0;

  union {                              /* Channel Pending register 1 */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t EOCCH47:1;             /* EOC Channel 47. */
      vuint32_t EOCCH46:1;             /* EOC Channel 46. */
      vuint32_t EOCCH45:1;             /* EOC Channel 45. */
      vuint32_t EOCCH44:1;             /* EOC Channel 44. */
      vuint32_t EOCCH43:1;             /* EOC Channel 43. */
      vuint32_t EOCCH42:1;             /* EOC Channel 42. */
      vuint32_t EOCCH41:1;             /* EOC Channel 41. */
      vuint32_t EOCCH40:1;             /* EOC Channel 40. */
      vuint32_t EOCCH39:1;             /* EOC Channel 39. */
      vuint32_t EOCCH38:1;             /* EOC Channel 38. */
      vuint32_t EOCCH37:1;             /* EOC Channel 37. */
      vuint32_t EOCCH36:1;             /* EOC Channel 36. */
      vuint32_t EOCCH35:1;             /* EOC Channel 35. */
      vuint32_t EOCCH34:1;             /* EOC Channel 34. */
      vuint32_t EOCCH33:1;             /* EOC Channel 33. */
      vuint32_t EOCCH32:1;             /* EOC Channel 32. */
    } B;
  } CEOCFR1;

  union {                              /* Channel Pending register 2 */
    vuint32_t R;
    struct {
      vuint32_t EOCCH95:1;             /* EOC Channel 95. */
      vuint32_t EOCCH94:1;             /* EOC Channel 94. */
      vuint32_t EOCCH93:1;             /* EOC Channel 93. */
      vuint32_t EOCCH92:1;             /* EOC Channel 92. */
      vuint32_t EOCCH91:1;             /* EOC Channel 91. */
      vuint32_t EOCCH90:1;             /* EOC Channel 90. */
      vuint32_t EOCCH89:1;             /* EOC Channel 89. */
      vuint32_t EOCCH88:1;             /* EOC Channel 88. */
      vuint32_t EOCCH87:1;             /* EOC Channel 87. */
      vuint32_t EOCCH86:1;             /* EOC Channel 86. */
      vuint32_t EOCCH85:1;             /* EOC Channel 85. */
      vuint32_t EOCCH84:1;             /* EOC Channel 84. */
      vuint32_t EOCCH83:1;             /* EOC Channel 83. */
      vuint32_t EOCCH82:1;             /* EOC Channel 82. */
      vuint32_t EOCCH81:1;             /* EOC Channel 81. */
      vuint32_t EOCCH80:1;             /* EOC Channel 80. */
      vuint32_t EOCCH79:1;             /* EOC Channel 79. */
      vuint32_t EOCCH78:1;             /* EOC Channel 78. */
      vuint32_t EOCCH77:1;             /* EOC Channel 77. */
      vuint32_t EOCCH76:1;             /* EOC Channel 76. */
      vuint32_t EOCCH75:1;             /* EOC Channel 75. */
      vuint32_t EOCCH74:1;             /* EOC Channel 74. */
      vuint32_t EOCCH73:1;             /* EOC Channel 73. */
      vuint32_t EOCCH72:1;             /* EOC Channel 72. */
      vuint32_t EOCCH71:1;             /* EOC Channel 71. */
      vuint32_t EOCCH70:1;             /* EOC Channel 70. */
      vuint32_t EOCCH69:1;             /* EOC Channel 69. */
      vuint32_t EOCCH68:1;             /* EOC Channel 68. */
      vuint32_t EOCCH67:1;             /* EOC Channel 67. */
      vuint32_t EOCCH66:1;             /* EOC Channel 66. */
      vuint32_t EOCCH65:1;             /* EOC Channel 65. */
      vuint32_t EOCCH64:1;             /* EOC Channel 64. */
    } B;
  } CEOCFR2;

  union {                              /* Interrupt Mask Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t  :1;
      vuint32_t  :10;
      vuint32_t MSKEOCTU:1;            /* Mask bit for EOCTU. */
      vuint32_t MSKJEOC:1;             /* Mask bit for JEOC. */
      vuint32_t MSKJECH:1;             /* Mask bit for JECH. */
      vuint32_t MSKEOC:1;              /* Mask bit for EOC. */
      vuint32_t MSKECH:1;              /* Mask bit for ECH. */
    } B;
  } IMR;

  union {                              /* Channel Interrupt Mask Register 0 */
    vuint32_t R;
    struct {
      vuint32_t CIM31:1;               /* Channel 31 interrupt enable. */
      vuint32_t CIM30:1;               /* Channel 30 interrupt enable. */
      vuint32_t CIM29:1;               /* Channel 29 interrupt enable. */
      vuint32_t CIM28:1;               /* Channel 28 interrupt enable. */
      vuint32_t CIM27:1;               /* Channel 27 interrupt enable. */
      vuint32_t CIM26:1;               /* Channel 26 interrupt enable. */
      vuint32_t CIM25:1;               /* Channel 25 interrupt enable. */
      vuint32_t CIM24:1;               /* Channel 24 interrupt enable. */
      vuint32_t CIM23:1;               /* Channel 23 interrupt enable. */
      vuint32_t CIM22:1;               /* Channel 22 interrupt enable. */
      vuint32_t CIM21:1;               /* Channel 21 interrupt enable. */
      vuint32_t CIM20:1;               /* Channel 20 interrupt enable. */
      vuint32_t CIM19:1;               /* Channel 19 interrupt enable. */
      vuint32_t CIM18:1;               /* Channel 18 interrupt enable. */
      vuint32_t CIM17:1;               /* Channel 17 interrupt enable. */
      vuint32_t CIM16:1;               /* Channel 16 interrupt enable. */
      vuint32_t CIM15:1;               /* Channel 15 interrupt enable. */
      vuint32_t CIM14:1;               /* Channel 14 interrupt enable. */
      vuint32_t CIM13:1;               /* Channel 13 interrupt enable. */
      vuint32_t CIM12:1;               /* Channel 12 interrupt enable. */
      vuint32_t CIM11:1;               /* Channel 11 interrupt enable. */
      vuint32_t CIM10:1;               /* Channel 10 interrupt enable. */
      vuint32_t CIM9:1;                /* Channel 9 interrupt enable. */
      vuint32_t CIM8:1;                /* Channel 8 interrupt enable. */
      vuint32_t CIM7:1;                /* Channel 7 interrupt enable. */
      vuint32_t CIM6:1;                /* Channel 6 interrupt enable. */
      vuint32_t CIM5:1;                /* Channel 5 interrupt enable. */
      vuint32_t CIM4:1;                /* Channel 4 interrupt enable. */
      vuint32_t CIM3:1;                /* Channel 3 interrupt enable. */
      vuint32_t CIM2:1;                /* Channel 2 interrupt enable. */
      vuint32_t CIM1:1;                /* Channel 1 interrupt enable. */
      vuint32_t CIM0:1;                /* Channel 0 interrupt enable. */
    } B;
  } CIMR0;

  union {                              /* Channel Interrupt Mask Register 1 */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CIM47:1;               /* Channel 47 interrupt enable. */
      vuint32_t CIM46:1;               /* Channel 46 interrupt enable. */
      vuint32_t CIM45:1;               /* Channel 45 interrupt enable. */
      vuint32_t CIM44:1;               /* Channel 44 interrupt enable. */
      vuint32_t CIM43:1;               /* Channel 43 interrupt enable. */
      vuint32_t CIM42:1;               /* Channel 42 interrupt enable. */
      vuint32_t CIM41:1;               /* Channel 41 interrupt enable. */
      vuint32_t CIM40:1;               /* Channel 40 interrupt enable. */
      vuint32_t CIM39:1;               /* Channel 39 interrupt enable. */
      vuint32_t CIM38:1;               /* Channel 38 interrupt enable. */
      vuint32_t CIM37:1;               /* Channel 37 interrupt enable. */
      vuint32_t CIM36:1;               /* Channel 36 interrupt enable. */
      vuint32_t CIM35:1;               /* Channel 35 interrupt enable. */
      vuint32_t CIM34:1;               /* Channel 34 interrupt enable. */
      vuint32_t CIM33:1;               /* Channel 33 interrupt enable. */
      vuint32_t CIM32:1;               /* Channel 32 interrupt enable. */
    } B;
  } CIMR1;

  union {                              /* Channel Interrupt Mask Register 2 */
    vuint32_t R;
    struct {
      vuint32_t CIM95:1;               /* Channel 95 interrupt enable. */
      vuint32_t CIM94:1;               /* Channel 94 interrupt enable. */
      vuint32_t CIM93:1;               /* Channel 93 interrupt enable. */
      vuint32_t CIM92:1;               /* Channel 92 interrupt enable. */
      vuint32_t CIM91:1;               /* Channel 91 interrupt enable. */
      vuint32_t CIM90:1;               /* Channel 90 interrupt enable. */
      vuint32_t CIM89:1;               /* Channel 89 interrupt enable. */
      vuint32_t CIM88:1;               /* Channel 88 interrupt enable. */
      vuint32_t CIM87:1;               /* Channel 87 interrupt enable. */
      vuint32_t CIM86:1;               /* Channel 86 interrupt enable. */
      vuint32_t CIM85:1;               /* Channel 85 interrupt enable. */
      vuint32_t CIM84:1;               /* Channel 84 interrupt enable. */
      vuint32_t CIM83:1;               /* Channel 83 interrupt enable. */
      vuint32_t CIM82:1;               /* Channel 82 interrupt enable. */
      vuint32_t CIM81:1;               /* Channel 81 interrupt enable. */
      vuint32_t CIM80:1;               /* Channel 80 interrupt enable. */
      vuint32_t CIM79:1;               /* Channel 79 interrupt enable. */
      vuint32_t CIM78:1;               /* Channel 78 interrupt enable. */
      vuint32_t CIM77:1;               /* Channel 77 interrupt enable. */
      vuint32_t CIM76:1;               /* Channel 76 interrupt enable. */
      vuint32_t CIM75:1;               /* Channel 75 interrupt enable. */
      vuint32_t CIM74:1;               /* Channel 74 interrupt enable. */
      vuint32_t CIM73:1;               /* Channel 73 interrupt enable. */
      vuint32_t CIM72:1;               /* Channel 72 interrupt enable. */
      vuint32_t CIM71:1;               /* Channel 71 interrupt enable. */
      vuint32_t CIM70:1;               /* Channel 70 interrupt enable. */
      vuint32_t CIM69:1;               /* Channel 69 interrupt enable. */
      vuint32_t CIM68:1;               /* Channel 68 interrupt enable. */
      vuint32_t CIM67:1;               /* Channel 67 interrupt enable. */
      vuint32_t CIM66:1;               /* Channel 66 interrupt enable. */
      vuint32_t CIM65:1;               /* Channel 65 interrupt enable. */
      vuint32_t CIM64:1;               /* Channel 64 interrupt enable. */
    } B;
  } CIMR2;

  union {                              /* Watchdog Threshold Interrupt Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t WDG3H:1;
      vuint32_t WDG3L:1;
      vuint32_t WDG2H:1;
      vuint32_t WDG2L:1;
      vuint32_t WDG1H:1;
      vuint32_t WDG1L:1;
      vuint32_t WDG0H:1;
      vuint32_t WDG0L:1;
    } B;
  } WTISR;

  union {                              /* Watchdog Threshold Interrupt Mask Register */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t MSKWDG3H:1;
      vuint32_t MSKWDG3L:1;
      vuint32_t MSKWDG2H:1;
      vuint32_t MSKWDG2L:1;
      vuint32_t MSKWDG1H:1;
      vuint32_t MSKWDG1L:1;
      vuint32_t MSKWDG0H:1;
      vuint32_t MSKWDG0L:1;
    } B;
  } WTIMR;

  uint8_t ADC_reserved1[8];
  union {                              /* DMA Enable register */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t DCLR:1;                /* DMA Clear sequence enable. */
      vuint32_t DMAEN:1;               /* DMA global enable. */
    } B;
  } DMAE;

  union {                              /* DMA Channel Select Register 0 */
    vuint32_t R;
    struct {
      vuint32_t DMA31:1;               /* DMA enable for channel 31. */
      vuint32_t DMA30:1;               /* DMA enable for channel 30. */
      vuint32_t DMA29:1;               /* DMA enable for channel 29. */
      vuint32_t DMA28:1;               /* DMA enable for channel 28. */
      vuint32_t DMA27:1;               /* DMA enable for channel 27. */
      vuint32_t DMA26:1;               /* DMA enable for channel 26. */
      vuint32_t DMA25:1;               /* DMA enable for channel 25. */
      vuint32_t DMA24:1;               /* DMA enable for channel 24. */
      vuint32_t DMA23:1;               /* DMA enable for channel 23. */
      vuint32_t DMA22:1;               /* DMA enable for channel 22. */
      vuint32_t DMA21:1;               /* DMA enable for channel 21. */
      vuint32_t DMA20:1;               /* DMA enable for channel 20. */
      vuint32_t DMA19:1;               /* DMA enable for channel 19. */
      vuint32_t DMA18:1;               /* DMA enable for channel 18. */
      vuint32_t DMA17:1;               /* DMA enable for channel 17. */
      vuint32_t DMA16:1;               /* DMA enable for channel 16. */
      vuint32_t DMA15:1;               /* DMA enable for channel 15. */
      vuint32_t DMA14:1;               /* DMA enable for channel 14. */
      vuint32_t DMA13:1;               /* DMA enable for channel 13. */
      vuint32_t DMA12:1;               /* DMA enable for channel 12. */
      vuint32_t DMA11:1;               /* DMA enable for channel 11. */
      vuint32_t DMA10:1;               /* DMA enable for channel 10. */
      vuint32_t DMA9:1;                /* DMA enable for channel 9. */
      vuint32_t DMA8:1;                /* DMA enable for channel 8. */
      vuint32_t DMA7:1;                /* DMA enable for channel 7. */
      vuint32_t DMA6:1;                /* DMA enable for channel 6. */
      vuint32_t DMA5:1;                /* DMA enable for channel 5. */
      vuint32_t DMA4:1;                /* DMA enable for channel 4. */
      vuint32_t DMA3:1;                /* DMA enable for channel 3. */
      vuint32_t DMA2:1;                /* DMA enable for channel 2. */
      vuint32_t DMA1:1;                /* DMA enable for channel 1. */
      vuint32_t DMA0:1;                /* DMA enable for channel 0. */
    } B;
  } DMAR0;

  union {                              /* DMA Channel Select Register 1 */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t DMA47:1;               /* DMA enable for channel 47. */
      vuint32_t DMA46:1;               /* DMA enable for channel 46. */
      vuint32_t DMA45:1;               /* DMA enable for channel 45. */
      vuint32_t DMA44:1;               /* DMA enable for channel 44. */
      vuint32_t DMA43:1;               /* DMA enable for channel 43. */
      vuint32_t DMA42:1;               /* DMA enable for channel 42. */
      vuint32_t DMA41:1;               /* DMA enable for channel 41. */
      vuint32_t DMA40:1;               /* DMA enable for channel 40. */
      vuint32_t DMA39:1;               /* DMA enable for channel 39. */
      vuint32_t DMA38:1;               /* DMA enable for channel 38. */
      vuint32_t DMA37:1;               /* DMA enable for channel 37. */
      vuint32_t DMA36:1;               /* DMA enable for channel 36. */
      vuint32_t DMA35:1;               /* DMA enable for channel 35. */
      vuint32_t DMA34:1;               /* DMA enable for channel 34. */
      vuint32_t DMA33:1;               /* DMA enable for channel 33. */
      vuint32_t DMA32:1;               /* DMA enable for channel 32. */
    } B;
  } DMAR1;

  union {                              /* DMA Channel Select Register 2 */
    vuint32_t R;
    struct {
      vuint32_t DMA95:1;               /* DMA enable for channel 95. */
      vuint32_t DMA94:1;               /* DMA enable for channel 94. */
      vuint32_t DMA93:1;               /* DMA enable for channel 93. */
      vuint32_t DMA92:1;               /* DMA enable for channel 92. */
      vuint32_t DMA91:1;               /* DMA enable for channel 91. */
      vuint32_t DMA90:1;               /* DMA enable for channel 90. */
      vuint32_t DMA89:1;               /* DMA enable for channel 89. */
      vuint32_t DMA88:1;               /* DMA enable for channel 88. */
      vuint32_t DMA87:1;               /* DMA enable for channel 87. */
      vuint32_t DMA86:1;               /* DMA enable for channel 86. */
      vuint32_t DMA85:1;               /* DMA enable for channel 85. */
      vuint32_t DMA84:1;               /* DMA enable for channel 84. */
      vuint32_t DMA83:1;               /* DMA enable for channel 83. */
      vuint32_t DMA82:1;               /* DMA enable for channel 82. */
      vuint32_t DMA81:1;               /* DMA enable for channel 81. */
      vuint32_t DMA80:1;               /* DMA enable for channel 80. */
      vuint32_t DMA79:1;               /* DMA enable for channel 79. */
      vuint32_t DMA78:1;               /* DMA enable for channel 78. */
      vuint32_t DMA77:1;               /* DMA enable for channel 77. */
      vuint32_t DMA76:1;               /* DMA enable for channel 76. */
      vuint32_t DMA75:1;               /* DMA enable for channel 75. */
      vuint32_t DMA74:1;               /* DMA enable for channel 74. */
      vuint32_t DMA73:1;               /* DMA enable for channel 73. */
      vuint32_t DMA72:1;               /* DMA enable for channel 72. */
      vuint32_t DMA71:1;               /* DMA enable for channel 71. */
      vuint32_t DMA70:1;               /* DMA enable for channel 70. */
      vuint32_t DMA69:1;               /* DMA enable for channel 69. */
      vuint32_t DMA68:1;               /* DMA enable for channel 68. */
      vuint32_t DMA67:1;               /* DMA enable for channel 67. */
      vuint32_t DMA66:1;               /* DMA enable for channel 66. */
      vuint32_t DMA65:1;               /* DMA enable for channel 65. */
      vuint32_t DMA64:1;               /* DMA enable for channel 64. */
    } B;
  } DMAR2;

  uint8_t ADC_reserved2[16];
  union {                              /* Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t THRH:12;               /* High threshold value for watchdog n. */
      vuint32_t  :4;
      vuint32_t THRL:12;               /* Low threshold value for watchdog n. */
    } B;
  } THRHLR0;

  union {                              /* Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t THRH:12;               /* High threshold value for watchdog n. */
      vuint32_t  :4;
      vuint32_t THRL:12;               /* Low threshold value for watchdog n. */
    } B;
  } THRHLR1;

  union {                              /* Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t THRH:12;               /* High threshold value for watchdog n. */
      vuint32_t  :4;
      vuint32_t THRL:12;               /* Low threshold value for watchdog n. */
    } B;
  } THRHLR2;

  union {                              /* Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t THRH:12;               /* High threshold value for watchdog n. */
      vuint32_t  :4;
      vuint32_t THRL:12;               /* Low threshold value for watchdog n. */
    } B;
  } THRHLR3;

  uint8_t ADC_reserved3[16];
  union {                              /* Presampling Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :25;
      vuint32_t PREVAL2:2;             /* Internal voltage selection for Presampling */
      vuint32_t PREVAL1:2;             /* Internal voltage selection for Presampling. */
      vuint32_t PREVAL0:2;             /* Internal voltage selection for Presampling. */
      vuint32_t PRECONV:1;             /* Convert Presampled value */
    } B;
  } PSCR;

  union {                              /* Presampling register 0 */
    vuint32_t R;
    struct {
      vuint32_t PRES31:1;              /* Presampling enable for channel 31. */
      vuint32_t PRES30:1;              /* Presampling enable for channel 30. */
      vuint32_t PRES29:1;              /* Presampling enable for channel 29. */
      vuint32_t PRES28:1;              /* Presampling enable for channel 28. */
      vuint32_t PRES27:1;              /* Presampling enable for channel 27. */
      vuint32_t PRES26:1;              /* Presampling enable for channel 26. */
      vuint32_t PRES25:1;              /* Presampling enable for channel 25. */
      vuint32_t PRES24:1;              /* Presampling enable for channel 24. */
      vuint32_t PRES23:1;              /* Presampling enable for channel 23. */
      vuint32_t PRES22:1;              /* Presampling enable for channel 22. */
      vuint32_t PRES21:1;              /* Presampling enable for channel 21. */
      vuint32_t PRES20:1;              /* Presampling enable for channel 20. */
      vuint32_t PRES19:1;              /* Presampling enable for channel 19. */
      vuint32_t PRES18:1;              /* Presampling enable for channel 18. */
      vuint32_t PRES17:1;              /* Presampling enable for channel 17. */
      vuint32_t PRES16:1;              /* Presampling enable for channel 16. */
      vuint32_t PRES15:1;              /* Presampling enable for channel 15. */
      vuint32_t PRES14:1;              /* Presampling enable for channel 14. */
      vuint32_t PRES13:1;              /* Presampling enable for channel 13. */
      vuint32_t PRES12:1;              /* Presampling enable for channel 12. */
      vuint32_t PRES11:1;              /* Presampling enable for channel 11. */
      vuint32_t PRES10:1;              /* Presampling enable for channel 10. */
      vuint32_t PRES9:1;               /* Presampling enable for channel 9. */
      vuint32_t PRES8:1;               /* Presampling enable for channel 8. */
      vuint32_t PRES7:1;               /* Presampling enable for channel 7. */
      vuint32_t PRES6:1;               /* Presampling enable for channel 6. */
      vuint32_t PRES5:1;               /* Presampling enable for channel 5. */
      vuint32_t PRES4:1;               /* Presampling enable for channel 4. */
      vuint32_t PRES3:1;               /* Presampling enable for channel 3. */
      vuint32_t PRES2:1;               /* Presampling enable for channel 2. */
      vuint32_t PRES1:1;               /* Presampling enable for channel 1. */
      vuint32_t PRES0:1;               /* Presampling enable for channel 0. */
    } B;
  } PSR0;

  union {                              /* Presampling register 1 */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t PRES47:1;              /* Presampling enable for channel 47. */
      vuint32_t PRES46:1;              /* Presampling enable for channel 46. */
      vuint32_t PRES45:1;              /* Presampling enable for channel 45. */
      vuint32_t PRES44:1;              /* Presampling enable for channel 44. */
      vuint32_t PRES43:1;              /* Presampling enable for channel 43. */
      vuint32_t PRES42:1;              /* Presampling enable for channel 42. */
      vuint32_t PRES41:1;              /* Presampling enable for channel 41. */
      vuint32_t PRES40:1;              /* Presampling enable for channel 40. */
      vuint32_t PRES39:1;              /* Presampling enable for channel 39. */
      vuint32_t PRES38:1;              /* Presampling enable for channel 38. */
      vuint32_t PRES37:1;              /* Presampling enable for channel 37. */
      vuint32_t PRES36:1;              /* Presampling enable for channel 36. */
      vuint32_t PRES35:1;              /* Presampling enable for channel 35. */
      vuint32_t PRES34:1;              /* Presampling enable for channel 34. */
      vuint32_t PRES33:1;              /* Presampling enable for channel 33. */
      vuint32_t PRES32:1;              /* Presampling enable for channel 32. */
    } B;
  } PSR1;

  union {                              /* Presampling register 2 */
    vuint32_t R;
    struct {
      vuint32_t PRES95:1;              /* Presampling enable for channel 95. */
      vuint32_t PRES94:1;              /* Presampling enable for channel 94. */
      vuint32_t PRES93:1;              /* Presampling enable for channel 93. */
      vuint32_t PRES92:1;              /* Presampling enable for channel 92. */
      vuint32_t PRES91:1;              /* Presampling enable for channel 91. */
      vuint32_t PRES90:1;              /* Presampling enable for channel 90. */
      vuint32_t PRES89:1;              /* Presampling enable for channel 89. */
      vuint32_t PRES88:1;              /* Presampling enable for channel 88. */
      vuint32_t PRES87:1;              /* Presampling enable for channel 87. */
      vuint32_t PRES86:1;              /* Presampling enable for channel 86. */
      vuint32_t PRES85:1;              /* Presampling enable for channel 85. */
      vuint32_t PRES84:1;              /* Presampling enable for channel 84. */
      vuint32_t PRES83:1;              /* Presampling enable for channel 83. */
      vuint32_t PRES82:1;              /* Presampling enable for channel 82. */
      vuint32_t PRES81:1;              /* Presampling enable for channel 81. */
      vuint32_t PRES80:1;              /* Presampling enable for channel 80. */
      vuint32_t PRES79:1;              /* Presampling enable for channel 79. */
      vuint32_t PRES78:1;              /* Presampling enable for channel 78. */
      vuint32_t PRES77:1;              /* Presampling enable for channel 77. */
      vuint32_t PRES76:1;              /* Presampling enable for channel 76. */
      vuint32_t PRES75:1;              /* Presampling enable for channel 75. */
      vuint32_t PRES74:1;              /* Presampling enable for channel 74. */
      vuint32_t PRES73:1;              /* Presampling enable for channel 73. */
      vuint32_t PRES72:1;              /* Presampling enable for channel 72. */
      vuint32_t PRES71:1;              /* Presampling enable for channel 71. */
      vuint32_t PRES70:1;              /* Presampling enable for channel 70. */
      vuint32_t PRES69:1;              /* Presampling enable for channel 69. */
      vuint32_t PRES68:1;              /* Presampling enable for channel 68. */
      vuint32_t PRES67:1;              /* Presampling enable for channel 67. */
      vuint32_t PRES66:1;              /* Presampling enable for channel 66. */
      vuint32_t PRES65:1;              /* Presampling enable for channel 65. */
      vuint32_t PRES64:1;              /* Presampling enable for channel 64. */
    } B;
  } PSR2;

  uint8_t ADC_reserved4[4];
  union {                              /* Conversion Timing Register 0 */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t INPSAMP:8;             /* Configuration of sampling phase duration. */
    } B;
  } CTR0;

  union {                              /* Conversion Timing Register 1 */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t INPSAMP:8;             /* Configuration of sampling phase duration. */
    } B;
  } CTR1;

  union {                              /* Conversion Timing Register 2 */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t INPSAMP:8;             /* Configuration of sampling phase duration. */
    } B;
  } CTR2;

  uint8_t ADC_reserved5[4];
  union {                              /* Normal Conversion Mask Register 0 */
    vuint32_t R;
    struct {
      vuint32_t CH31:1;                /* Normal sampling enable for channel 31. */
      vuint32_t CH30:1;                /* Normal sampling enable for channel 30. */
      vuint32_t CH29:1;                /* Normal sampling enable for channel 29. */
      vuint32_t CH28:1;                /* Normal sampling enable for channel 28. */
      vuint32_t CH27:1;                /* Normal sampling enable for channel 27. */
      vuint32_t CH26:1;                /* Normal sampling enable for channel 26. */
      vuint32_t CH25:1;                /* Normal sampling enable for channel 25. */
      vuint32_t CH24:1;                /* Normal sampling enable for channel 24. */
      vuint32_t CH23:1;                /* Normal sampling enable for channel 23. */
      vuint32_t CH22:1;                /* Normal sampling enable for channel 22. */
      vuint32_t CH21:1;                /* Normal sampling enable for channel 21. */
      vuint32_t CH20:1;                /* Normal sampling enable for channel 20. */
      vuint32_t CH19:1;                /* Normal sampling enable for channel 19. */
      vuint32_t CH18:1;                /* Normal sampling enable for channel 18. */
      vuint32_t CH17:1;                /* Normal sampling enable for channel 17. */
      vuint32_t CH16:1;                /* Normal sampling enable for channel 16. */
      vuint32_t CH15:1;                /* Normal sampling enable for channel 15. */
      vuint32_t CH14:1;                /* Normal sampling enable for channel 14. */
      vuint32_t CH13:1;                /* Normal sampling enable for channel 13. */
      vuint32_t CH12:1;                /* Normal sampling enable for channel 12. */
      vuint32_t CH11:1;                /* Normal sampling enable for channel 11. */
      vuint32_t CH10:1;                /* Normal sampling enable for channel 10. */
      vuint32_t CH9:1;                 /* Normal sampling enable for channel 9. */
      vuint32_t CH8:1;                 /* Normal sampling enable for channel 8. */
      vuint32_t CH7:1;                 /* Normal sampling enable for channel 7. */
      vuint32_t CH6:1;                 /* Normal sampling enable for channel 6. */
      vuint32_t CH5:1;                 /* Normal sampling enable for channel 5. */
      vuint32_t CH4:1;                 /* Normal sampling enable for channel 4. */
      vuint32_t CH3:1;                 /* Normal sampling enable for channel 3. */
      vuint32_t CH2:1;                 /* Normal sampling enable for channel 2. */
      vuint32_t CH1:1;                 /* Normal sampling enable for channel 1. */
      vuint32_t CH0:1;                 /* Normal sampling enable for channel 0. */
    } B;
  } NCMR0;

  union {                              /* Normal Conversion Mask Register 1 */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CH47:1;                /* Normal sampling enable for channel 47. */
      vuint32_t CH46:1;                /* Normal sampling enable for channel 46. */
      vuint32_t CH45:1;                /* Normal sampling enable for channel 45. */
      vuint32_t CH44:1;                /* Normal sampling enable for channel 44. */
      vuint32_t CH43:1;                /* Normal sampling enable for channel 43. */
      vuint32_t CH42:1;                /* Normal sampling enable for channel 42. */
      vuint32_t CH41:1;                /* Normal sampling enable for channel 41. */
      vuint32_t CH40:1;                /* Normal sampling enable for channel 40. */
      vuint32_t CH39:1;                /* Normal sampling enable for channel 39. */
      vuint32_t CH38:1;                /* Normal sampling enable for channel 38. */
      vuint32_t CH37:1;                /* Normal sampling enable for channel 37. */
      vuint32_t CH36:1;                /* Normal sampling enable for channel 36. */
      vuint32_t CH35:1;                /* Normal sampling enable for channel 35. */
      vuint32_t CH34:1;                /* Normal sampling enable for channel 34. */
      vuint32_t CH33:1;                /* Normal sampling enable for channel 33. */
      vuint32_t CH32:1;                /* Normal sampling enable for channel 32. */
    } B;
  } NCMR1;

  union {                              /* Normal Conversion Mask Register 2 */
    vuint32_t R;
    struct {
      vuint32_t CH95:1;                /* Normal sampling enable for channel 95. */
      vuint32_t CH94:1;                /* Normal sampling enable for channel 94. */
      vuint32_t CH93:1;                /* Normal sampling enable for channel 93. */
      vuint32_t CH92:1;                /* Normal sampling enable for channel 92. */
      vuint32_t CH91:1;                /* Normal sampling enable for channel 91. */
      vuint32_t CH90:1;                /* Normal sampling enable for channel 90. */
      vuint32_t CH89:1;                /* Normal sampling enable for channel 89. */
      vuint32_t CH88:1;                /* Normal sampling enable for channel 88. */
      vuint32_t CH87:1;                /* Normal sampling enable for channel 87. */
      vuint32_t CH86:1;                /* Normal sampling enable for channel 86. */
      vuint32_t CH85:1;                /* Normal sampling enable for channel 85. */
      vuint32_t CH84:1;                /* Normal sampling enable for channel 84. */
      vuint32_t CH83:1;                /* Normal sampling enable for channel 83. */
      vuint32_t CH82:1;                /* Normal sampling enable for channel 82. */
      vuint32_t CH81:1;                /* Normal sampling enable for channel 81. */
      vuint32_t CH80:1;                /* Normal sampling enable for channel 80. */
      vuint32_t CH79:1;                /* Normal sampling enable for channel 79. */
      vuint32_t CH78:1;                /* Normal sampling enable for channel 78. */
      vuint32_t CH77:1;                /* Normal sampling enable for channel 77. */
      vuint32_t CH76:1;                /* Normal sampling enable for channel 76. */
      vuint32_t CH75:1;                /* Normal sampling enable for channel 75. */
      vuint32_t CH74:1;                /* Normal sampling enable for channel 74. */
      vuint32_t CH73:1;                /* Normal sampling enable for channel 73. */
      vuint32_t CH72:1;                /* Normal sampling enable for channel 72. */
      vuint32_t CH71:1;                /* Normal sampling enable for channel 71. */
      vuint32_t CH70:1;                /* Normal sampling enable for channel 70. */
      vuint32_t CH69:1;                /* Normal sampling enable for channel 69. */
      vuint32_t CH68:1;                /* Normal sampling enable for channel 68. */
      vuint32_t CH67:1;                /* Normal sampling enable for channel 67. */
      vuint32_t CH66:1;                /* Normal sampling enable for channel 66. */
      vuint32_t CH65:1;                /* Normal sampling enable for channel 65. */
      vuint32_t CH64:1;                /* Normal sampling enable for channel 64. */
    } B;
  } NCMR2;

  uint8_t ADC_reserved6[4];
  union {                              /* Injected Conversion Mask Register 0 */
    vuint32_t R;
    struct {
      vuint32_t CH31:1;                /* Injected sampling enable for channel 31. */
      vuint32_t CH30:1;                /* Injected sampling enable for channel 30. */
      vuint32_t CH29:1;                /* Injected sampling enable for channel 29. */
      vuint32_t CH28:1;                /* Injected sampling enable for channel 28. */
      vuint32_t CH27:1;                /* Injected sampling enable for channel 27. */
      vuint32_t CH26:1;                /* Injected sampling enable for channel 26. */
      vuint32_t CH25:1;                /* Injected sampling enable for channel 25. */
      vuint32_t CH24:1;                /* Injected sampling enable for channel 24. */
      vuint32_t CH23:1;                /* Injected sampling enable for channel 23. */
      vuint32_t CH22:1;                /* Injected sampling enable for channel 22. */
      vuint32_t CH21:1;                /* Injected sampling enable for channel 21. */
      vuint32_t CH20:1;                /* Injected sampling enable for channel 20. */
      vuint32_t CH19:1;                /* Injected sampling enable for channel 19. */
      vuint32_t CH18:1;                /* Injected sampling enable for channel 18. */
      vuint32_t CH17:1;                /* Injected sampling enable for channel 17. */
      vuint32_t CH16:1;                /* Injected sampling enable for channel 16. */
      vuint32_t CH15:1;                /* Injected sampling enable for channel 15. */
      vuint32_t CH14:1;                /* Injected sampling enable for channel 14. */
      vuint32_t CH13:1;                /* Injected sampling enable for channel 13. */
      vuint32_t CH12:1;                /* Injected sampling enable for channel 12. */
      vuint32_t CH11:1;                /* Injected sampling enable for channel 11. */
      vuint32_t CH10:1;                /* Injected sampling enable for channel 10. */
      vuint32_t CH9:1;                 /* Injected sampling enable for channel 9. */
      vuint32_t CH8:1;                 /* Injected sampling enable for channel 8. */
      vuint32_t CH7:1;                 /* Injected sampling enable for channel 7. */
      vuint32_t CH6:1;                 /* Injected sampling enable for channel 6. */
      vuint32_t CH5:1;                 /* Injected sampling enable for channel 5. */
      vuint32_t CH4:1;                 /* Injected sampling enable for channel 4. */
      vuint32_t CH3:1;                 /* Injected sampling enable for channel 3. */
      vuint32_t CH2:1;                 /* Injected sampling enable for channel 2. */
      vuint32_t CH1:1;                 /* Injected sampling enable for channel 1. */
      vuint32_t CH0:1;                 /* Injected sampling enable for channel 0. */
    } B;
  } JCMR0;

  union {                              /* Injected Conversion Mask Register 1 */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CH47:1;                /* Injected sampling enable for channel 47. */
      vuint32_t CH46:1;                /* Injected sampling enable for channel 46. */
      vuint32_t CH45:1;                /* Injected sampling enable for channel 45. */
      vuint32_t CH44:1;                /* Injected sampling enable for channel 44. */
      vuint32_t CH43:1;                /* Injected sampling enable for channel 43. */
      vuint32_t CH42:1;                /* Injected sampling enable for channel 42. */
      vuint32_t CH41:1;                /* Injected sampling enable for channel 41. */
      vuint32_t CH40:1;                /* Injected sampling enable for channel 40. */
      vuint32_t CH39:1;                /* Injected sampling enable for channel 39. */
      vuint32_t CH38:1;                /* Injected sampling enable for channel 38. */
      vuint32_t CH37:1;                /* Injected sampling enable for channel 37. */
      vuint32_t CH36:1;                /* Injected sampling enable for channel 36. */
      vuint32_t CH35:1;                /* Injected sampling enable for channel 35. */
      vuint32_t CH34:1;                /* Injected sampling enable for channel 34. */
      vuint32_t CH33:1;                /* Injected sampling enable for channel 33. */
      vuint32_t CH32:1;                /* Injected sampling enable for channel 32. */
    } B;
  } JCMR1;

  union {                              /* Injected Conversion Mask Register 2 */
    vuint32_t R;
    struct {
      vuint32_t CH95:1;                /* Injected sampling enable for channel 95. */
      vuint32_t CH94:1;                /* Injected sampling enable for channel 94. */
      vuint32_t CH93:1;                /* Injected sampling enable for channel 93. */
      vuint32_t CH92:1;                /* Injected sampling enable for channel 92. */
      vuint32_t CH91:1;                /* Injected sampling enable for channel 91. */
      vuint32_t CH90:1;                /* Injected sampling enable for channel 90. */
      vuint32_t CH89:1;                /* Injected sampling enable for channel 89. */
      vuint32_t CH88:1;                /* Injected sampling enable for channel 88. */
      vuint32_t CH87:1;                /* Injected sampling enable for channel 87. */
      vuint32_t CH86:1;                /* Injected sampling enable for channel 86. */
      vuint32_t CH85:1;                /* Injected sampling enable for channel 85. */
      vuint32_t CH84:1;                /* Injected sampling enable for channel 84. */
      vuint32_t CH83:1;                /* Injected sampling enable for channel 83. */
      vuint32_t CH82:1;                /* Injected sampling enable for channel 82. */
      vuint32_t CH81:1;                /* Injected sampling enable for channel 81. */
      vuint32_t CH80:1;                /* Injected sampling enable for channel 80. */
      vuint32_t CH79:1;                /* Injected sampling enable for channel 79. */
      vuint32_t CH78:1;                /* Injected sampling enable for channel 78. */
      vuint32_t CH77:1;                /* Injected sampling enable for channel 77. */
      vuint32_t CH76:1;                /* Injected sampling enable for channel 76. */
      vuint32_t CH75:1;                /* Injected sampling enable for channel 75. */
      vuint32_t CH74:1;                /* Injected sampling enable for channel 74. */
      vuint32_t CH73:1;                /* Injected sampling enable for channel 73. */
      vuint32_t CH72:1;                /* Injected sampling enable for channel 72. */
      vuint32_t CH71:1;                /* Injected sampling enable for channel 71. */
      vuint32_t CH70:1;                /* Injected sampling enable for channel 70. */
      vuint32_t CH69:1;                /* Injected sampling enable for channel 69. */
      vuint32_t CH68:1;                /* Injected sampling enable for channel 68. */
      vuint32_t CH67:1;                /* Injected sampling enable for channel 67. */
      vuint32_t CH66:1;                /* Injected sampling enable for channel 66. */
      vuint32_t CH65:1;                /* Injected sampling enable for channel 65. */
      vuint32_t CH64:1;                /* Injected sampling enable for channel 64. */
    } B;
  } JCMR2;

  uint8_t ADC_reserved7[4];
  union {                              /* Decode Signals Delay Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t DSD:16;
    } B;
  } DSDR;

  union {                              /* Power Down Exit Delay Register */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t PDED:8;
    } B;
  } PDEDR;

  uint8_t ADC_reserved8[52];

    /* Note on CDR registers: There are only some CDR implemented         */
    /*  In order to make the CDR easily addressable, these are defined     */
    /*  as an array (ie ADC.CDR[x].R). This means you have to be careful    */
    /*  when addressing these registers in order not to access a PCTL that  */
    /*  is not implemented. Following are available: 0-47, 64-95 */

  union {                              /* Channel Data Register n (Precision Channels) */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t VALID:1;               /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
      vuint32_t OVERW:1;               /* Overwrite data */
      vuint32_t RESULT:2;
      vuint32_t CDATA:16;              /* Converted Data 11:0. */
    } B;
  } CDR[96];

  uint8_t ADC_reserved9[48];
  union {                              /* Channel Watchdog Select Register 0 */
    vuint32_t R;
    struct {
      vuint32_t WSEL_CH7:4;            /* Channel Watchdog select for channel 7. */
      vuint32_t WSEL_CH6:4;            /* Channel Watchdog select for channel 6. */
      vuint32_t WSEL_CH5:4;            /* Channel Watchdog select for channel 5. */
      vuint32_t WSEL_CH4:4;            /* Channel Watchdog select for channel 4. */
      vuint32_t WSEL_CH3:4;            /* Channel Watchdog select for channel 3. */
      vuint32_t WSEL_CH2:4;            /* Channel Watchdog select for channel 2. */
      vuint32_t WSEL_CH1:4;            /* Channel Watchdog select for channel 1. */
      vuint32_t WSEL_CH0:4;            /* Channel Watchdog select for channel 0. */
    } B;
  } CWSELR0;

  union {                              /* Channel Watchdog Select Register 1 */
    vuint32_t R;
    struct {
      vuint32_t WSEL_CH15:4;           /* Channel Watchdog select for channel 15. */
      vuint32_t WSEL_CH14:4;           /* Channel Watchdog select for channel 14. */
      vuint32_t WSEL_CH13:4;           /* Channel Watchdog select for channel 13. */
      vuint32_t WSEL_CH12:4;           /* Channel Watchdog select for channel 12. */
      vuint32_t WSEL_CH11:4;           /* Channel Watchdog select for channel 11. */
      vuint32_t WSEL_CH10:4;           /* Channel Watchdog select for channel 10. */
      vuint32_t WSEL_CH9:4;            /* Channel Watchdog select for channel 9. */
      vuint32_t WSEL_CH8:4;            /* Channel Watchdog select for channel 8. */
    } B;
  } CWSELR1;

  union {                              /* Channel Watchdog Select Register 2 */
    vuint32_t R;
    struct {
      vuint32_t WSEL_CH23:4;           /* Channel Watchdog select for channel 23. */
      vuint32_t WSEL_CH22:4;           /* Channel Watchdog select for channel 22. */
      vuint32_t WSEL_CH21:4;           /* Channel Watchdog select for channel 21. */
      vuint32_t WSEL_CH20:4;           /* Channel Watchdog select for channel 20. */
      vuint32_t WSEL_CH19:4;           /* Channel Watchdog select for channel 19. */
      vuint32_t WSEL_CH18:4;           /* Channel Watchdog select for channel 18. */
      vuint32_t WSEL_CH17:4;           /* Channel Watchdog select for channel 17. */
      vuint32_t WSEL_CH16:4;           /* Channel Watchdog select for channel 16. */
    } B;
  } CWSELR2;

  union {                              /* Channel Watchdog Select Register 3 */
    vuint32_t R;
    struct {
      vuint32_t WSEL_CH31:4;           /* Channel Watchdog select for channel 31. */
      vuint32_t WSEL_CH30:4;           /* Channel Watchdog select for channel 30. */
      vuint32_t WSEL_CH29:4;           /* Channel Watchdog select for channel 29. */
      vuint32_t WSEL_CH28:4;           /* Channel Watchdog select for channel 28. */
      vuint32_t WSEL_CH27:4;           /* Channel Watchdog select for channel 27. */
      vuint32_t WSEL_CH26:4;           /* Channel Watchdog select for channel 26. */
      vuint32_t WSEL_CH25:4;           /* Channel Watchdog select for channel 25. */
      vuint32_t WSEL_CH24:4;           /* Channel Watchdog select for channel 24. */
    } B;
  } CWSELR3;

  union {                              /* Channel Watchdog Select Register 4 */
    vuint32_t R;
    struct {
      vuint32_t WSEL_CH39:4;           /* Channel Watchdog select for channel 39. */
      vuint32_t WSEL_CH38:4;           /* Channel Watchdog select for channel 38. */
      vuint32_t WSEL_CH37:4;           /* Channel Watchdog select for channel 37. */
      vuint32_t WSEL_CH36:4;           /* Channel Watchdog select for channel 36. */
      vuint32_t WSEL_CH35:4;           /* Channel Watchdog select for channel 35. */
      vuint32_t WSEL_CH34:4;           /* Channel Watchdog select for channel 34. */
      vuint32_t WSEL_CH33:4;           /* Channel Watchdog select for channel 33. */
      vuint32_t WSEL_CH32:4;           /* Channel Watchdog select for channel 32. */
    } B;
  } CWSELR4;

  union {                              /* Channel Watchdog Select Register 5 */
    vuint32_t R;
    struct {
      vuint32_t WSEL_CH47:4;           /* Channel Watchdog select for channel 47. */
      vuint32_t WSEL_CH46:4;           /* Channel Watchdog select for channel 46. */
      vuint32_t WSEL_CH45:4;           /* Channel Watchdog select for channel 45. */
      vuint32_t WSEL_CH44:4;           /* Channel Watchdog select for channel 44. */
      vuint32_t WSEL_CH43:4;           /* Channel Watchdog select for channel 43. */
      vuint32_t WSEL_CH42:4;           /* Channel Watchdog select for channel 42. */
      vuint32_t WSEL_CH41:4;           /* Channel Watchdog select for channel 41. */
      vuint32_t WSEL_CH40:4;           /* Channel Watchdog select for channel 40. */
    } B;
  } CWSELR5;

  uint8_t ADC_reserved10[8];
  union {                              /* Channel Watchdog Select Register 8 */
    vuint32_t R;
    struct {
      vuint32_t WSEL_CH71:4;           /* Channel Watchdog select for channel 71. */
      vuint32_t WSEL_CH70:4;           /* Channel Watchdog select for channel 70. */
      vuint32_t WSEL_CH69:4;           /* Channel Watchdog select for channel 69. */
      vuint32_t WSEL_CH68:4;           /* Channel Watchdog select for channel 68. */
      vuint32_t WSEL_CH67:4;           /* Channel Watchdog select for channel 67. */
      vuint32_t WSEL_CH66:4;           /* Channel Watchdog select for channel 66. */
      vuint32_t WSEL_CH65:4;           /* Channel Watchdog select for channel 65. */
      vuint32_t WSEL_CH64:4;           /* Channel Watchdog select for channel 64. */
    } B;
  } CWSELR8;

  union {                              /* Channel Watchdog Select Register 9 */
    vuint32_t R;
    struct {
      vuint32_t WSEL_CH79:4;           /* Channel Watchdog select for channel 79. */
      vuint32_t WSEL_CH78:4;           /* Channel Watchdog select for channel 78. */
      vuint32_t WSEL_CH77:4;           /* Channel Watchdog select for channel 77. */
      vuint32_t WSEL_CH76:4;           /* Channel Watchdog select for channel 76. */
      vuint32_t WSEL_CH75:4;           /* Channel Watchdog select for channel 75. */
      vuint32_t WSEL_CH74:4;           /* Channel Watchdog select for channel 74. */
      vuint32_t WSEL_CH73:4;           /* Channel Watchdog select for channel 73. */
      vuint32_t WSEL_CH72:4;           /* Channel Watchdog select for channel 72. */
    } B;
  } CWSELR9;

  union {                              /* Channel Watchdog Select Register 10 */
    vuint32_t R;
    struct {
      vuint32_t WSEL_CH87:4;           /* Channel Watchdog select for channel 87. */
      vuint32_t WSEL_CH86:4;           /* Channel Watchdog select for channel 86. */
      vuint32_t WSEL_CH85:4;           /* Channel Watchdog select for channel 85. */
      vuint32_t WSEL_CH84:4;           /* Channel Watchdog select for channel 84. */
      vuint32_t WSEL_CH83:4;           /* Channel Watchdog select for channel 83. */
      vuint32_t WSEL_CH82:4;           /* Channel Watchdog select for channel 82. */
      vuint32_t WSEL_CH81:4;           /* Channel Watchdog select for channel 81. */
      vuint32_t WSEL_CH80:4;           /* Channel Watchdog select for channel 80. */
    } B;
  } CWSELR10;

  union {                              /* Channel Watchdog Select Register 11 */
    vuint32_t R;
    struct {
      vuint32_t WSEL_CH95:4;           /* Channel Watchdog select for channel 95. */
      vuint32_t WSEL_CH94:4;           /* Channel Watchdog select for channel 94. */
      vuint32_t WSEL_CH93:4;           /* Channel Watchdog select for channel 93. */
      vuint32_t WSEL_CH92:4;           /* Channel Watchdog select for channel 92. */
      vuint32_t WSEL_CH91:4;           /* Channel Watchdog select for channel 91. */
      vuint32_t WSEL_CH90:4;           /* Channel Watchdog select for channel 90. */
      vuint32_t WSEL_CH89:4;           /* Channel Watchdog select for channel 89. */
      vuint32_t WSEL_CH88:4;           /* Channel Watchdog select for channel 88. */
    } B;
  } CWSELR11;

  union {                              /* Channel Watchdog Enable Register 0 */
    vuint32_t R;
    struct {
      vuint32_t CWEN31:1;              /* Watchdog enable for channel 31. */
      vuint32_t CWEN30:1;              /* Watchdog enable for channel 30. */
      vuint32_t CWEN29:1;              /* Watchdog enable for channel 29. */
      vuint32_t CWEN28:1;              /* Watchdog enable for channel 28. */
      vuint32_t CWEN27:1;              /* Watchdog enable for channel 27. */
      vuint32_t CWEN26:1;              /* Watchdog enable for channel 26. */
      vuint32_t CWEN25:1;              /* Watchdog enable for channel 25. */
      vuint32_t CWEN24:1;              /* Watchdog enable for channel 24. */
      vuint32_t CWEN23:1;              /* Watchdog enable for channel 23. */
      vuint32_t CWEN22:1;              /* Watchdog enable for channel 22. */
      vuint32_t CWEN21:1;              /* Watchdog enable for channel 21. */
      vuint32_t CWEN20:1;              /* Watchdog enable for channel 20. */
      vuint32_t CWEN19:1;              /* Watchdog enable for channel 19. */
      vuint32_t CWEN18:1;              /* Watchdog enable for channel 18. */
      vuint32_t CWEN17:1;              /* Watchdog enable for channel 17. */
      vuint32_t CWEN16:1;              /* Watchdog enable for channel 16. */
      vuint32_t CWEN15:1;              /* Watchdog enable for channel 15. */
      vuint32_t CWEN14:1;              /* Watchdog enable for channel 14. */
      vuint32_t CWEN13:1;              /* Watchdog enable for channel 13. */
      vuint32_t CWEN12:1;              /* Watchdog enable for channel 12. */
      vuint32_t CWEN11:1;              /* Watchdog enable for channel 11. */
      vuint32_t CWEN10:1;              /* Watchdog enable for channel 10. */
      vuint32_t CWEN9:1;               /* Watchdog enable for channel 9. */
      vuint32_t CWEN8:1;               /* Watchdog enable for channel 8. */
      vuint32_t CWEN7:1;               /* Watchdog enable for channel 7. */
      vuint32_t CWEN6:1;               /* Watchdog enable for channel 6. */
      vuint32_t CWEN5:1;               /* Watchdog enable for channel 5. */
      vuint32_t CWEN4:1;               /* Watchdog enable for channel 4. */
      vuint32_t CWEN3:1;               /* Watchdog enable for channel 3. */
      vuint32_t CWEN2:1;               /* Watchdog enable for channel 2. */
      vuint32_t CWEN1:1;               /* Watchdog enable for channel 1. */
      vuint32_t CWEN0:1;               /* Watchdog enable for channel 0. */
    } B;
  } CWENR0;

  union {                              /* Channel Watchdog Enable Register 1 */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CWEN47:1;              /* Watchdog enable for channel 47. */
      vuint32_t CWEN46:1;              /* Watchdog enable for channel 46. */
      vuint32_t CWEN45:1;              /* Watchdog enable for channel 45. */
      vuint32_t CWEN44:1;              /* Watchdog enable for channel 44. */
      vuint32_t CWEN43:1;              /* Watchdog enable for channel 43. */
      vuint32_t CWEN42:1;              /* Watchdog enable for channel 42. */
      vuint32_t CWEN41:1;              /* Watchdog enable for channel 41. */
      vuint32_t CWEN40:1;              /* Watchdog enable for channel 40. */
      vuint32_t CWEN39:1;              /* Watchdog enable for channel 39. */
      vuint32_t CWEN38:1;              /* Watchdog enable for channel 38. */
      vuint32_t CWEN37:1;              /* Watchdog enable for channel 37. */
      vuint32_t CWEN36:1;              /* Watchdog enable for channel 36. */
      vuint32_t CWEN35:1;              /* Watchdog enable for channel 35. */
      vuint32_t CWEN34:1;              /* Watchdog enable for channel 34. */
      vuint32_t CWEN33:1;              /* Watchdog enable for channel 33. */
      vuint32_t CWEN32:1;              /* Watchdog enable for channel 32. */
    } B;
  } CWENR1;

  union {                              /* Channel Watchdog Enable Register 2 */
    vuint32_t R;
    struct {
      vuint32_t CWEN95:1;              /* Watchdog enable for channel 95. */
      vuint32_t CWEN94:1;              /* Watchdog enable for channel 94. */
      vuint32_t CWEN93:1;              /* Watchdog enable for channel 93. */
      vuint32_t CWEN92:1;              /* Watchdog enable for channel 92. */
      vuint32_t CWEN91:1;              /* Watchdog enable for channel 91. */
      vuint32_t CWEN90:1;              /* Watchdog enable for channel 90. */
      vuint32_t CWEN89:1;              /* Watchdog enable for channel 89. */
      vuint32_t CWEN88:1;              /* Watchdog enable for channel 88. */
      vuint32_t CWEN87:1;              /* Watchdog enable for channel 87. */
      vuint32_t CWEN86:1;              /* Watchdog enable for channel 86. */
      vuint32_t CWEN85:1;              /* Watchdog enable for channel 85. */
      vuint32_t CWEN84:1;              /* Watchdog enable for channel 84. */
      vuint32_t CWEN83:1;              /* Watchdog enable for channel 83. */
      vuint32_t CWEN82:1;              /* Watchdog enable for channel 82. */
      vuint32_t CWEN81:1;              /* Watchdog enable for channel 81. */
      vuint32_t CWEN80:1;              /* Watchdog enable for channel 80. */
      vuint32_t CWEN79:1;              /* Watchdog enable for channel 79. */
      vuint32_t CWEN78:1;              /* Watchdog enable for channel 78. */
      vuint32_t CWEN77:1;              /* Watchdog enable for channel 77. */
      vuint32_t CWEN76:1;              /* Watchdog enable for channel 76. */
      vuint32_t CWEN75:1;              /* Watchdog enable for channel 75. */
      vuint32_t CWEN74:1;              /* Watchdog enable for channel 74. */
      vuint32_t CWEN73:1;              /* Watchdog enable for channel 73. */
      vuint32_t CWEN72:1;              /* Watchdog enable for channel 72. */
      vuint32_t CWEN71:1;              /* Watchdog enable for channel 71. */
      vuint32_t CWEN70:1;              /* Watchdog enable for channel 70. */
      vuint32_t CWEN69:1;              /* Watchdog enable for channel 69. */
      vuint32_t CWEN68:1;              /* Watchdog enable for channel 68. */
      vuint32_t CWEN67:1;              /* Watchdog enable for channel 67. */
      vuint32_t CWEN66:1;              /* Watchdog enable for channel 66. */
      vuint32_t CWEN65:1;              /* Watchdog enable for channel 65. */
      vuint32_t CWEN64:1;              /* Watchdog enable for channel 64. */
    } B;
  } CWENR2;

  uint8_t ADC_reserved11[4];
  union {                              /* Analog Watchdog Out of Range Register 0 */
    vuint32_t R;
    struct {
      vuint32_t AWOR_CH31:1;           /* Analog watchdog out of range for channel 31. */
      vuint32_t AWOR_CH30:1;           /* Analog watchdog out of range for channel 30. */
      vuint32_t AWOR_CH29:1;           /* Analog watchdog out of range for channel 29. */
      vuint32_t AWOR_CH28:1;           /* Analog watchdog out of range for channel 28. */
      vuint32_t AWOR_CH27:1;           /* Analog watchdog out of range for channel 27. */
      vuint32_t AWOR_CH26:1;           /* Analog watchdog out of range for channel 26. */
      vuint32_t AWOR_CH25:1;           /* Analog watchdog out of range for channel 25. */
      vuint32_t AWOR_CH24:1;           /* Analog watchdog out of range for channel 24. */
      vuint32_t AWOR_CH23:1;           /* Analog watchdog out of range for channel 23. */
      vuint32_t AWOR_CH22:1;           /* Analog watchdog out of range for channel 22. */
      vuint32_t AWOR_CH21:1;           /* Analog watchdog out of range for channel 21. */
      vuint32_t AWOR_CH20:1;           /* Analog watchdog out of range for channel 20. */
      vuint32_t AWOR_CH19:1;           /* Analog watchdog out of range for channel 19. */
      vuint32_t AWOR_CH18:1;           /* Analog watchdog out of range for channel 18. */
      vuint32_t AWOR_CH17:1;           /* Analog watchdog out of range for channel 17. */
      vuint32_t AWOR_CH16:1;           /* Analog watchdog out of range for channel 16. */
      vuint32_t AWOR_CH15:1;           /* Analog watchdog out of range for channel 15. */
      vuint32_t AWOR_CH14:1;           /* Analog watchdog out of range for channel 14. */
      vuint32_t AWOR_CH13:1;           /* Analog watchdog out of range for channel 13. */
      vuint32_t AWOR_CH12:1;           /* Analog watchdog out of range for channel 12. */
      vuint32_t AWOR_CH11:1;           /* Analog watchdog out of range for channel 11. */
      vuint32_t AWOR_CH10:1;           /* Analog watchdog out of range for channel 10. */
      vuint32_t AWOR_CH9:1;            /* Analog watchdog out of range for channel 9. */
      vuint32_t AWOR_CH8:1;            /* Analog watchdog out of range for channel 8. */
      vuint32_t AWOR_CH7:1;            /* Analog watchdog out of range for channel 7. */
      vuint32_t AWOR_CH6:1;            /* Analog watchdog out of range for channel 6. */
      vuint32_t AWOR_CH5:1;            /* Analog watchdog out of range for channel 5. */
      vuint32_t AWOR_CH4:1;            /* Analog watchdog out of range for channel 4. */
      vuint32_t AWOR_CH3:1;            /* Analog watchdog out of range for channel 3. */
      vuint32_t AWOR_CH2:1;            /* Analog watchdog out of range for channel 2. */
      vuint32_t AWOR_CH1:1;            /* Analog watchdog out of range for channel 1. */
      vuint32_t AWOR_CH0:1;            /* Analog watchdog out of range for channel 0. */
    } B;
  } AWORR0;

  union {                              /* Analog Watchdog Out of Range Register 1 */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t AWOR_CH47:1;           /* Analog watchdog out of range for channel 47. */
      vuint32_t AWOR_CH46:1;           /* Analog watchdog out of range for channel 46. */
      vuint32_t AWOR_CH45:1;           /* Analog watchdog out of range for channel 45. */
      vuint32_t AWOR_CH44:1;           /* Analog watchdog out of range for channel 44. */
      vuint32_t AWOR_CH43:1;           /* Analog watchdog out of range for channel 43. */
      vuint32_t AWOR_CH42:1;           /* Analog watchdog out of range for channel 42. */
      vuint32_t AWOR_CH41:1;           /* Analog watchdog out of range for channel 41. */
      vuint32_t AWOR_CH40:1;           /* Analog watchdog out of range for channel 40. */
      vuint32_t AWOR_CH39:1;           /* Analog watchdog out of range for channel 39. */
      vuint32_t AWOR_CH38:1;           /* Analog watchdog out of range for channel 38. */
      vuint32_t AWOR_CH37:1;           /* Analog watchdog out of range for channel 37. */
      vuint32_t AWOR_CH36:1;           /* Analog watchdog out of range for channel 36. */
      vuint32_t AWOR_CH35:1;           /* Analog watchdog out of range for channel 35. */
      vuint32_t AWOR_CH34:1;           /* Analog watchdog out of range for channel 34. */
      vuint32_t AWOR_CH33:1;           /* Analog watchdog out of range for channel 33. */
      vuint32_t AWOR_CH32:1;           /* Analog watchdog out of range for channel 32. */
    } B;
  } AWORR1;

  union {                              /* Analog Watchdog Out of Range Register 2 */
    vuint32_t R;
    struct {
      vuint32_t AWOR_CH95:1;           /* Analog watchdog out of range for channel 95. */
      vuint32_t AWOR_CH94:1;           /* Analog watchdog out of range for channel 94. */
      vuint32_t AWOR_CH93:1;           /* Analog watchdog out of range for channel 93. */
      vuint32_t AWOR_CH92:1;           /* Analog watchdog out of range for channel 92. */
      vuint32_t AWOR_CH91:1;           /* Analog watchdog out of range for channel 91. */
      vuint32_t AWOR_CH90:1;           /* Analog watchdog out of range for channel 90. */
      vuint32_t AWOR_CH89:1;           /* Analog watchdog out of range for channel 89. */
      vuint32_t AWOR_CH88:1;           /* Analog watchdog out of range for channel 88. */
      vuint32_t AWOR_CH87:1;           /* Analog watchdog out of range for channel 87. */
      vuint32_t AWOR_CH86:1;           /* Analog watchdog out of range for channel 86. */
      vuint32_t AWOR_CH85:1;           /* Analog watchdog out of range for channel 85. */
      vuint32_t AWOR_CH84:1;           /* Analog watchdog out of range for channel 84. */
      vuint32_t AWOR_CH83:1;           /* Analog watchdog out of range for channel 83. */
      vuint32_t AWOR_CH82:1;           /* Analog watchdog out of range for channel 82. */
      vuint32_t AWOR_CH81:1;           /* Analog watchdog out of range for channel 81. */
      vuint32_t AWOR_CH80:1;           /* Analog watchdog out of range for channel 80. */
      vuint32_t AWOR_CH79:1;           /* Analog watchdog out of range for channel 79. */
      vuint32_t AWOR_CH78:1;           /* Analog watchdog out of range for channel 78. */
      vuint32_t AWOR_CH77:1;           /* Analog watchdog out of range for channel 77. */
      vuint32_t AWOR_CH76:1;           /* Analog watchdog out of range for channel 76. */
      vuint32_t AWOR_CH75:1;           /* Analog watchdog out of range for channel 75. */
      vuint32_t AWOR_CH74:1;           /* Analog watchdog out of range for channel 74. */
      vuint32_t AWOR_CH73:1;           /* Analog watchdog out of range for channel 73. */
      vuint32_t AWOR_CH72:1;           /* Analog watchdog out of range for channel 72. */
      vuint32_t AWOR_CH71:1;           /* Analog watchdog out of range for channel 71. */
      vuint32_t AWOR_CH70:1;           /* Analog watchdog out of range for channel 70. */
      vuint32_t AWOR_CH69:1;           /* Analog watchdog out of range for channel 69. */
      vuint32_t AWOR_CH68:1;           /* Analog watchdog out of range for channel 68. */
      vuint32_t AWOR_CH67:1;           /* Analog watchdog out of range for channel 67. */
      vuint32_t AWOR_CH66:1;           /* Analog watchdog out of range for channel 66. */
      vuint32_t AWOR_CH65:1;           /* Analog watchdog out of range for channel 65. */
      vuint32_t AWOR_CH64:1;           /* Analog watchdog out of range for channel 64. */
    } B;
  } AWORR2;

  uint8_t ADC_reserved12[68];
  union {                              /* Self Test Configuration Register 1 */
    vuint32_t R;
    struct {
      vuint32_t INPSAMP_C:8;
      vuint32_t  :8;
      vuint32_t INPSAMP_S:8;
      vuint32_t  :8;
    } B;
  } STCR1;

  union {                              /* Self Test Configuration Register 2 */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t MSKWDSERR:1;
      vuint32_t SERR:1;
      vuint32_t MSKWDTERR:1;           /* Interrupt enable (STSR.WDTERR status bit) */
      vuint32_t  :1;
      vuint32_t MSKST_EOC:1;           /* Interrupt Enable bit for STSR2.ST_EOC */
      vuint32_t  :4;
      vuint32_t MSKWDG_EOA_C:1;        /* Interrupt enable (WDG_EOA_C status bit) */
      vuint32_t  :1;
      vuint32_t MSKWDG_EOA_S:1;        /* Interrupt enable (WDG_EOA_S status bit) */
      vuint32_t MSKERR_C:1;            /* Interrupt enable (ERR_C status bit) */
      vuint32_t  :1;
      vuint32_t MSKERR_S2:1;           /* Interrupt enable (ERR_S2 status bit) */
      vuint32_t MSKERR_S1:1;           /* Interrupt enable (ERR_S1 status bit) */
      vuint32_t  :1;
      vuint32_t  :3;
      vuint32_t EN:1;                  /* Self testing channel enable. The TEST conversions are enabled. */
      vuint32_t  :2;
      vuint32_t FMA_WDSERR:1;          /* Fault mapping for the Watchdog Sequence error. */
      vuint32_t FMA_WDTERR:1;          /* Fault mapping for the Watchdog Timer error. */
      vuint32_t FMA_C:1;               /* Fault mapping for self test algorithm C. */
      vuint32_t  :1;
      vuint32_t FMA_S:1;               /* Fault mapping for the self test algorithm BGAP. */
    } B;
  } STCR2;

  union {                              /* Self Test Configuration Register 3 */
    vuint32_t R;
    struct {
      vuint32_t  :22;
      vuint32_t ALG:2;                 /* Algorithm scheduling. */
      vuint32_t  :3;
      vuint32_t MSTEP:5;
    } B;
  } STCR3;

  union {                              /* Self Test Baud Rate Register */
    vuint32_t R;
    struct {
      vuint32_t  :13;
      vuint32_t WDT:3;
      vuint32_t  :8;
      vuint32_t BR:8;                  /* Baud rate for the selected algorithm in SCAN mode (MCR[MODE] = 1). */
    } B;
  } STBRR;

  union {                              /* Self Test Status Register 1 */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t WDSERR:1;
      vuint32_t  :1;
      vuint32_t WDTERR:1;
      vuint32_t OVERWR:1;              /* Overwrite error. */
      vuint32_t ST_EOC:1;              /* Self Test EOC Bit. */
      vuint32_t  :4;
      vuint32_t WDG_EOA_C:1;
      vuint32_t  :1;
      vuint32_t WDG_EOA_S:1;
      vuint32_t ERR_C:1;
      vuint32_t  :1;
      vuint32_t ERR_S2:1;
      vuint32_t ERR_S1:1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t STEP_C:5;              /* Step of the algorithm C when an ERR_C has occurred. */
      vuint32_t  :5;
    } B;
  } STSR1;

  union {                              /* Self Test Status Register 2 */
    vuint32_t R;
    struct {
      vuint32_t OVFL:1;                /* Overflow Bit */
      vuint32_t  :3;
      vuint32_t DATA1:12;              /* Test channel converted data when the ERR_S1 has occurred. */
      vuint32_t  :4;
      vuint32_t DATA0:12;              /* Test channel converted data when the ERR_S1 has occurred. */
    } B;
  } STSR2;

  union {                              /* Self Test Status Register 3 */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t DATA1:12;              /* Test channel converted data when the ERR_S2 has occurred. */
      vuint32_t  :4;
      vuint32_t  :12;
    } B;
  } STSR3;

  union {                              /* Self Test Status Register 4 */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t DATA1:12;              /* Test channel converted data when the ERR_C has occurred. */
      vuint32_t  :4;
      vuint32_t  :12;
    } B;
  } STSR4;

  uint8_t ADC_reserved13[16];
  union {                              /* Self Test Data Register 1 */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t VALID:1;               /* Valid data. */
      vuint32_t OWERWR:1;              /* Overwrite data. */
      vuint32_t  :6;
      vuint32_t TCDATA:12;             /* Test channel converted data. (In 2's complement format) */
    } B;
  } STDR1;

  union {                              /* Self Test Data Register 2 */
    vuint32_t R;
    struct {
      vuint32_t FDATA:12;
      vuint32_t VALID:1;               /* Valid data. */
      vuint32_t OWERWR:1;              /* Overwrite data. */
      vuint32_t  :6;
      vuint32_t IDATA:12;
    } B;
  } STDR2;

  uint8_t ADC_reserved14[8];
  union {                              /* Self Test Analog Watchdog Register 0 */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t WDTE:1;                /* Watchdog timer enable (related to the algorithm S) */
      vuint32_t  :2;
      vuint32_t THRH:12;               /* High threshold value for channel 0. */
      vuint32_t  :4;
      vuint32_t THRL:12;               /* Low threshold value for channel 0. */
    } B;
  } STAW0R;

  union {                              /* Self Test Analog Watchdog Register 1A */
    vuint32_t R;
    struct {
      vuint32_t AWDE:1;                /* Analog watchdog enable related to the algorithm S (step1). */
      vuint32_t  :3;
      vuint32_t THRH:12;               /* High threshold value (integer part) for test channel for algorithm S (step 1) (unsigned coding). */
      vuint32_t  :4;
      vuint32_t THRL:12;               /* Low threshold value (integer part) for test channel for algorithm S (step 1) (unsigned coding). */
    } B;
  } STAW1AR;

  union {                              /* Self Test Analog Watchdog Register 1B */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t THRH:12;               /* High threshold value (fractional part) for test channel for algorithm S (step 1)(unsigned coding). */
      vuint32_t  :4;
      vuint32_t THRL:12;               /* Low threshold value (fractional part) for test channel for algorithm S (step 1) (unsigned coding). */
    } B;
  } STAW1BR;

  union {                              /* Self Test Analog Watchdog Register 2 */
    vuint32_t R;
    struct {
      vuint32_t AWDE:1;                /* Analog watchdog enable related to the algorithm S (step2). */
      vuint32_t  :19;
      vuint32_t THRL:12;               /* Low threshold value for channel x (unsigned coding). If the analog watchdog is enabled, the STSR1.ERR_S2 status bit is set if STDR1.TCDATA < THRL. */
    } B;
  } STAW2R;

  uint8_t ADC_reserved15[4];
  union {                              /* Self Test Analog Watchdog Register 4 */
    vuint32_t R;
    struct {
      vuint32_t AWDE:1;                /* Analog watchdog enable (related to the algorithm C) */
      vuint32_t WDTE:1;                /* Watchdog timer enable (related to the algorithm C). */
      vuint32_t  :2;
      vuint32_t THRH:12;               /* High threshold value for channel sampled for C algorithm. */
      vuint32_t  :4;
      vuint32_t THRL:12;               /* Low threshold value for channel sampled for the C self test algorithm. */
    } B;
  } STAW4R;

  union {                              /* Self Test Analog Watchdog Register 5 */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t THRH:12;               /* High threshold value for the algorithm C (step1 to step CS-1). */
      vuint32_t  :4;
      vuint32_t THRL:12;               /* Low threshold value for the algorithm C (step1 to step CS-1). */
    } B;
  } STAW5R;

  uint8_t ADC_reserved16[4];
  union {                              /* Calibration, BIST Control and status Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t  :2;
      vuint32_t TSAMP:2;               /* Test Sample period in Calibration, BIST and Offset calculation process. */
      vuint32_t  :3;
      vuint32_t  :8;
      vuint32_t C_T_BUSY:1;
      vuint32_t  :1;
      vuint32_t  :6;
      vuint32_t  :1;
      vuint32_t NR_SMPL:2;             /* Number of Samples for averaging. */
      vuint32_t AVG_EN:1;              /* Average Enable (for Calibration only). */
      vuint32_t TEST_FAIL:1;           /* Test Fail. */
      vuint32_t  :2;
      vuint32_t TEST_EN:1;             /* Enable the test. */
    } B;
  } CALBISTREG;

  uint8_t ADC_reserved17[4];
  union {                              /* Offset and Gain User Register */
    vuint32_t R;
    struct {
      vuint32_t  :6;
      vuint32_t GAIN_USER:10;
      vuint32_t  :8;
      vuint32_t OFFSET_USER:8;
    } B;
  } OFSGNUSR;

  uint8_t ADC_reserved18[12];
  union {                              /* Alternate Result register */
    vuint32_t R;
    struct {
      vuint32_t  :32;
    } B;
  } ALTR;
};


/* ============================================================================
   =============================== Module: AIPS ===============================
   ============================================================================ */

struct AIPS_tag {
  union {                              /* Master Privilege Register A */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t MTR0:1;                /* Master 0 Trusted For Read */
      vuint32_t MTW0:1;                /* Master 0 Trusted For Writes */
      vuint32_t MPL0:1;                /* Master 0 Privilege Level */
      vuint32_t  :1;
      vuint32_t MTR1:1;                /* Master 1 trusted for read */
      vuint32_t MTW1:1;                /* Master 1 trusted for writes */
      vuint32_t MPL1:1;                /* Master 1 privilege level */
      vuint32_t  :4;
      vuint32_t  :1;
      vuint32_t MTR3:1;                /* Master 3 Trusted For Read */
      vuint32_t MTW3:1;                /* Master 3 Trusted For Writes */
      vuint32_t MPL3:1;                /* Master 3 Privilege Level */
      vuint32_t  :1;
      vuint32_t MTR4:1;                /* Master 4 Trusted For Read */
      vuint32_t MTW4:1;                /* Master 4 Trusted For Writes */
      vuint32_t MPL4:1;                /* Master 4 Privilege Level */
      vuint32_t  :4;
      vuint32_t  :4;
      vuint32_t  :1;
      vuint32_t MTR7:1;                /* Master 7 trusted for read */
      vuint32_t MTW7:1;                /* Master 7 trusted for writes */
      vuint32_t MPL7:1;                /* Master 7 privilege level */
    } B;
  } MPRA;

  union {                              /* Master Privilege Register B */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t  :1;
      vuint32_t MTR9:1;                /* Master 9 trusted for read */
      vuint32_t MTW9:1;                /* Master 9 trusted for writes */
      vuint32_t MPL9:1;                /* Master 9 privilege level */
      vuint32_t  :4;
      vuint32_t  :4;
      vuint32_t  :4;
      vuint32_t  :4;
      vuint32_t  :4;
      vuint32_t  :4;
    } B;
  } MPRB;

  uint8_t AIPS_reserved0[248];
  union {                              /* Peripheral Access Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t SP0:1;                 /* Supervisor Protect */
      vuint32_t WP0:1;                 /* Write Protect */
      vuint32_t TP0:1;                 /* Trusted Protect */
      vuint32_t  :1;
      vuint32_t SP1:1;                 /* Supervisor Protect */
      vuint32_t WP1:1;                 /* Write Protect */
      vuint32_t TP1:1;                 /* Trusted Protect */
      vuint32_t  :1;
      vuint32_t SP2:1;                 /* Supervisor Protect */
      vuint32_t WP2:1;                 /* Write Protect */
      vuint32_t TP2:1;                 /* Trusted Protect */
      vuint32_t  :1;
      vuint32_t SP3:1;                 /* Supervisor Protect */
      vuint32_t WP3:1;                 /* Write Protect */
      vuint32_t TP3:1;                 /* Trusted Protect */
      vuint32_t  :1;
      vuint32_t SP4:1;                 /* Supervisor Protect */
      vuint32_t WP4:1;                 /* Write Protect */
      vuint32_t TP4:1;                 /* Trusted Protect */
      vuint32_t  :1;
      vuint32_t SP5:1;                 /* Supervisor Protect */
      vuint32_t WP5:1;                 /* Write Protect */
      vuint32_t TP5:1;                 /* Trusted Protect */
      vuint32_t  :1;
      vuint32_t SP6:1;                 /* Supervisor Protect */
      vuint32_t WP6:1;                 /* Write Protect */
      vuint32_t TP6:1;                 /* Trusted Protect */
      vuint32_t  :1;
      vuint32_t SP7:1;                 /* Supervisor Protect */
      vuint32_t WP7:1;                 /* Write Protect */
      vuint32_t TP7:1;                 /* Trusted Protect */
    } B;
  } PACR[8];

  uint8_t AIPS_reserved1[32];
  union {                              /* Off-Platform Peripheral Access Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t SP0:1;                 /* Supervisor Protect */
      vuint32_t WP0:1;                 /* Write Protect */
      vuint32_t TP0:1;                 /* Trusted Protect */
      vuint32_t  :1;
      vuint32_t SP1:1;                 /* Supervisor Protect */
      vuint32_t WP1:1;                 /* Write Protect */
      vuint32_t TP1:1;                 /* Trusted Protect */
      vuint32_t  :1;
      vuint32_t SP2:1;                 /* Supervisor Protect */
      vuint32_t WP2:1;                 /* Write Protect */
      vuint32_t TP2:1;                 /* Trusted Protect */
      vuint32_t  :1;
      vuint32_t SP3:1;                 /* Supervisor Protect */
      vuint32_t WP3:1;                 /* Write Protect */
      vuint32_t TP3:1;                 /* Trusted Protect */
      vuint32_t  :1;
      vuint32_t SP4:1;                 /* Supervisor Protect */
      vuint32_t WP4:1;                 /* Write Protect */
      vuint32_t TP4:1;                 /* Trusted Protect */
      vuint32_t  :1;
      vuint32_t SP5:1;                 /* Supervisor Protect */
      vuint32_t WP5:1;                 /* Write Protect */
      vuint32_t TP5:1;                 /* Trusted Protect */
      vuint32_t  :1;
      vuint32_t SP6:1;                 /* Supervisor Protect */
      vuint32_t WP6:1;                 /* Write Protect */
      vuint32_t TP6:1;                 /* Trusted Protect */
      vuint32_t  :1;
      vuint32_t SP7:1;                 /* Supervisor Protect */
      vuint32_t WP7:1;                 /* Write Protect */
      vuint32_t TP7:1;                 /* Trusted Protect */
    } B;
  } OPACR[32];
};


/* ============================================================================
   =============================== Module: BCTU ===============================
   ============================================================================ */

struct BCTU_tag {
  union {                              /* Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t MDIS:1;                /* Module Disable */
      vuint32_t FRZ:1;                 /* Freeze mode - for debug operation. */
      vuint32_t  :2;
      vuint32_t GTRGEN:1;              /* Global Trigger Enable. */
      vuint32_t  :6;
      vuint32_t DMA3:1;                /* ADC3DR data transferring by DMA. */
      vuint32_t DMA2:1;                /* ADC2DR data transferring by DMA. */
      vuint32_t DMA1:1;                /* ADC1DR data transferring by DMA. */
      vuint32_t DMA0:1;                /* ADC0DR data transferring by DMA. */
      vuint32_t  :8;
      vuint32_t TRGEN:1;               /* Trigger interrupt request enable. */
      vuint32_t  :1;
      vuint32_t LIST_IEN:1;            /* LIST interrupt enable. */
      vuint32_t  :1;
      vuint32_t IEN3:1;                /* Interrupt enable bit for ADC3DR new data. */
      vuint32_t IEN2:1;                /* Interrupt enable bit for ADC2DR new data. */
      vuint32_t IEN1:1;                /* Interrupt enable bit for ADC1DR new data. */
      vuint32_t IEN0:1;                /* Interrupt enable bit for ADC0DR new data. */
    } B;
  } MCR;

  uint8_t BCTU_reserved0[4];
  union {                              /* Module Status register */
    vuint32_t R;
    struct {
      vuint32_t TRGF_CLR:1;            /* TRGF clear */
      vuint32_t  :3;
      vuint32_t LIST3_Last_CLR:1;
      vuint32_t LIST2_Last_CLR:1;
      vuint32_t LIST1_Last_CLR:1;
      vuint32_t LIST0_Last_CLR:1;
      vuint32_t DATAOVR3_CLR:1;        /* Clears DATAOVR3 flag */
      vuint32_t DATAOVR2_CLR:1;        /* Clears DATAOVR2 flag */
      vuint32_t DATAOVR1_CLR:1;        /* Clears DATAOVR1 flag */
      vuint32_t DATAOVR0_CLR:1;        /* Clears DATAOVR0 flag */
      vuint32_t NDATA3_CLR:1;
      vuint32_t NDATA2_CLR:1;          /* Clears NDATA2 flag */
      vuint32_t NDATA1_CLR:1;          /* Clears NDATA1 flag */
      vuint32_t NDATA0_CLR:1;          /* Clears NDATA0 flag */
      vuint32_t TRGF:1;                /* Trigger Flag */
      vuint32_t  :3;
      vuint32_t LIST3_Last:1;
      vuint32_t LIST2_Last:1;
      vuint32_t LIST1_Last:1;
      vuint32_t LIST0_Last:1;
      vuint32_t DATAOVR3:1;
      vuint32_t DATAOVR2:1;
      vuint32_t DATAOVR1:1;
      vuint32_t DATAOVR0:1;
      vuint32_t NDATA3:1;
      vuint32_t NDATA2:1;
      vuint32_t NDATA1:1;
      vuint32_t NDATA0:1;
    } B;
  } MSR;

  uint8_t BCTU_reserved1[12];
  union {                              /* Trigger Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t LOOP:1;                /* LOOP bit */
      vuint32_t  :7;
      vuint32_t  :4;                   /* Reserved. */
      vuint32_t CCP:4;                 /* Conversion Configuration Pointer (CCP) */
      vuint32_t TRIGEN:1;              /* Trigger enable */
      vuint32_t TRG_FLAG:1;
      vuint32_t TRS:1;                 /* Trigger resolution */
      vuint32_t  :1;
      vuint32_t ADC_SEL3:1;
      vuint32_t ADC_SEL2:1;
      vuint32_t ADC_SEL1:1;
      vuint32_t ADC_SEL0:1;
      vuint32_t CHANNEL_VALUE_OR_LADDR:8; /* Channel Value or List Address Value. */
    } B;
  } TRGCFG[32];

  uint8_t BCTU_reserved2[400];
  union {                              /* Write Protection register */
    vuint32_t R;
    struct {
      vuint32_t  :28;
      vuint32_t PROTEC_CODE:4;         /* The Protection code sets protection for the write protected registers */
    } B;
  } WRPROT;

  union {                              /* Software Trigger register 1 */
    vuint32_t R;
    struct {
      vuint32_t SFTRG_1:32;            /* Software trigger [31:0] slice. */
    } B;
  } SFTRGR1;

  uint8_t BCTU_reserved3[12];
  union {                              /* ADC0 Result Data register */
    vuint32_t R;
    struct {
      vuint32_t TRG_SRC:8;
      vuint32_t CH:8;
      vuint32_t LIST:1;
      vuint32_t LAST:1;
      vuint32_t  :2;
      vuint32_t ADC_DATA:12;
    } B;
  } ADCDR[4];

  union {                              /* LIST Size Status register */
    vuint32_t R;
    struct {
      vuint32_t  :24;                  /* Reserved. */
      vuint32_t LISTSZ:8;              /* Size of the LIST in number of elements. */
    } B;
  } LISTSTAR;

  union {                              /* LIST Channel Address Register */
    vuint32_t R;
    struct {
      vuint32_t LAST_y:1;              /* Last channel in the list of channels. */
      vuint32_t  :3;
      vuint32_t TAG_y:4;               /* TAG for the n LIST element */
      vuint32_t ADC_CH_y:8;            /* ADC channel selection. */
      vuint32_t LAST_y_plus_1:1;       /* Second to last channel in the list of channels. */
      vuint32_t  :3;
      vuint32_t TAG_y_plus_1:4;        /* TAG for the [y+1] LIST element. */
      vuint32_t ADC_CHL_n_plus_1:8;    /* ADC channel selection. */
    } B;
  } LISTCHR[32];

  union {                              /* Conversion configuration register */
    vuint32_t R;
    struct {
      vuint32_t  :22;
      vuint32_t DEST:2;                /* Destination selection */
      vuint32_t  :4;                   /* Reserved */
      vuint32_t TAG:4;                 /* The TAG field is used in the Parallel Side Port as the TAG bits. */
    } B;
  } CCR[11];
};


/* ============================================================================
   =============================== Module: C55FMC =============================
   ============================================================================ */

struct C55FMC_tag {
  union {                              /* Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t RVE:1;                 /* Read Voltage Error */
      vuint32_t RRE:1;                 /* Read Reference Error */
      vuint32_t AEE:1;                 /* Address Encode Error */
      vuint32_t EEE:1;                 /* ECC after ECC Error */
      vuint32_t  :12;
      vuint32_t EER:1;                 /* ECC Event Error */
      vuint32_t RWE:1;                 /* Read-While-Write Event Error */
      vuint32_t SBC:1;                 /* Single Bit Correction */
      vuint32_t  :1;
      vuint32_t PEAS:1;                /* Program Access Space */
      vuint32_t DONE:1;                /* State Machine Status */
      vuint32_t PEG:1;                 /* Program/Erase Good */
      vuint32_t PECIE:1;               /* Program/Erase Complete Interrupt Enable */
      vuint32_t  :3;
      vuint32_t PGM:1;                 /* Program */
      vuint32_t PSUS:1;                /* Program Suspend */
      vuint32_t ERS:1;                 /* Erase */
      vuint32_t ESUS:1;                /* Erase Suspend */
      vuint32_t EHV:1;                 /* Enable High Voltage */
    } B;
  } MCR;

  uint8_t C55FMC_reserved0[4];
  union {                              /* Extended Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t HT:1;                  /* High Temperature Enabled. */
      vuint32_t  :2;
      vuint32_t n256K:5;
      vuint32_t n64Kh:3;
      vuint32_t n32Kh:2;
      vuint32_t n16Kh:3;
      vuint32_t n64Km:3;
      vuint32_t n32Km:2;
      vuint32_t n16Km:3;
      vuint32_t n64Kl:3;
      vuint32_t n32Kl:2;
      vuint32_t n16Kl:3;
    } B;
  } MCRE;

  uint8_t C55FMC_reserved1[4];
  union {                              /* Lock 0 register */
    vuint32_t R;
    struct {
      vuint32_t TSLOCK:1;              /* UTest NVM Lock. */
      vuint32_t  :1;
      vuint32_t LOWLOCK:14;            /* Low Block Lock */
      vuint32_t MIDLOCK:16;            /* Mid Block Lock */
    } B;
  } LOCK0;

  union {                              /* Lock 1 register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t HIGHLOCK:16;           /* High Block Lock */
    } B;
  } LOCK1;

  union {                              /* Lock 2 register */
    vuint32_t R;
    struct {
      vuint32_t A256KLOCK:32;          /* 256 KB Block Lock */
    } B;
  } LOCK2;

  union {                              /* Lock 3 register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t A256KLOCK:16;          /* 256 KB Block Lock */
    } B;
  } LOCK3;

  uint8_t C55FMC_reserved2[24];
  union {                              /* Select 0 register */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t LOWSEL:14;             /* LOW Block Select. */
      vuint32_t MIDSEL:16;             /* Mid Block Select. */
    } B;
  } SEL0;

  union {                              /* Select 1 register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t HIGHSEL:16;            /* High Block Select. */
    } B;
  } SEL1;

  union {                              /* Select 2 register */
    vuint32_t R;
    struct {
      vuint32_t A256KSEL:32;           /* 256 KB Block Select. */
    } B;
  } SEL2;

  union {                              /* Select 3 register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t A256KSEL:16;           /* 256 KB Block Select. */
    } B;
  } SEL3;

  uint8_t C55FMC_reserved3[8];
  union {                              /* Address register */
    vuint32_t R;
    struct {
      vuint32_t SAD:1;
      vuint32_t aH:1;
      vuint32_t aM:1;
      vuint32_t aL:1;
      vuint32_t a256k:1;
      vuint32_t a64k:1;
      vuint32_t a32k:1;
      vuint32_t a16k:1;
      vuint32_t ADDR:21;
      vuint32_t  :3;
    } B;
  } ADR;

  union {                              /* UTest 0 register */
    vuint32_t R;
    struct {
      vuint32_t UTE:1;
      vuint32_t SBCE:1;
      vuint32_t  :11;
      vuint32_t CPR:1;
      vuint32_t CPA:1;
      vuint32_t CPE:1;
      vuint32_t  :6;
      vuint32_t NAIBP:1;
      vuint32_t AIBPE:1;
      vuint32_t  :1;
      vuint32_t AISUS:1;
      vuint32_t MRE:1;
      vuint32_t MRV:1;
      vuint32_t  :1;
      vuint32_t AIS:1;
      vuint32_t AIE:1;
      vuint32_t AID:1;
    } B;
  } UT0;

  union {                              /* UMISR register */
    vuint32_t R;
    struct {
      vuint32_t MISR:32;
    } B;
  } UM[9];

  union {                              /* UMISR register */
    vuint32_t R;
    struct {
      vuint32_t  :31;
      vuint32_t MISR:1;                /* MISR[288]. */
    } B;
  } UM9;

  union {                              /* Over-Program Protection 0 register */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t LOWOPP:14;             /* Low Block Over-Program Protection[13:0]. */
      vuint32_t MIDOPP:16;             /* Mid Block Over-Program Protection[15:0]. */
    } B;
  } OPP0;

  union {                              /* Over-Program Protection 1 register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t HIGHOPP:16;            /* High Block Over-Program Protection[15:0]. */
    } B;
  } OPP1;

  union {                              /* Over-Program Protection 2 register */
    vuint32_t R;
    struct {
      vuint32_t A256KOPP:32;           /* 256K Block Over-Program Protection[31:0]. */
    } B;
  } OPP2;

  union {                              /* Over-Program Protection 3 register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t A256KOPP:16;           /* 256K Block Over-Program Protection[47:32]. */
    } B;
  } OPP3;
};


/* ============================================================================
   =============================== Module: CAN ================================
   ============================================================================ */

struct CAN_tag {
  union {                              /* Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t MDIS:1;                /* Module Disable */
      vuint32_t FRZ:1;                 /* Freeze Enable */
      vuint32_t RFEN:1;                /* Rx FIFO Enable */
      vuint32_t HALT:1;                /* Halt FlexCAN */
      vuint32_t NOTRDY:1;              /* FlexCAN Not Ready */
      vuint32_t  :1;
      vuint32_t SOFTRST:1;             /* Soft Reset */
      vuint32_t FRZACK:1;              /* Freeze Mode Acknowledge */
      vuint32_t SUPV:1;                /* Supervisor Mode */
      vuint32_t  :1;
      vuint32_t WRNEN:1;               /* Warning Interrupt Enable */
      vuint32_t LPMACK:1;              /* Low-Power Mode Acknowledge */
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t SRXDIS:1;              /* Self Reception Disable */
      vuint32_t IRMQ:1;                /* Individual Rx Masking And Queue Enable */
      vuint32_t DMA:1;                 /* DMA Enable */
      vuint32_t  :1;
      vuint32_t LPRIOEN:1;             /* Local Priority Enable */
      vuint32_t AEN:1;                 /* Abort Enable */
      vuint32_t  :2;
      vuint32_t IDAM:2;                /* ID Acceptance Mode */
      vuint32_t  :1;
      vuint32_t MAXMB:7;               /* Number Of The Last Message Buffer */
    } B;
  } MCR;

  union {                              /* Control 1 register */
    vuint32_t R;
    struct {
      vuint32_t PRESDIV:8;             /* Prescaler Division Factor */
      vuint32_t RJW:2;                 /* Resync Jump Width */
      vuint32_t PSEG1:3;               /* Phase Segment 1 */
      vuint32_t PSEG2:3;               /* Phase Segment 2 */
      vuint32_t BOFFMSK:1;             /* Bus Off Mask */
      vuint32_t ERRMSK:1;              /* Error Mask */
      vuint32_t CLKSRC:1;              /* CAN Engine Clock Source */
      vuint32_t LPB:1;                 /* Loop Back Mode */
      vuint32_t TWRNMSK:1;             /* Tx Warning Interrupt Mask */
      vuint32_t RWRNMSK:1;             /* Rx Warning Interrupt Mask */
      vuint32_t  :2;
      vuint32_t SMP:1;                 /* CAN Bit Sampling */
      vuint32_t BOFFREC:1;             /* Bus Off Recovery */
      vuint32_t TSYN:1;                /* Timer Sync */
      vuint32_t LBUF:1;                /* Lowest Buffer Transmitted First */
      vuint32_t LOM:1;                 /* Listen-Only Mode */
      vuint32_t PROPSEG:3;             /* Propagation Segment */
    } B;
  } CTRL1;

  union {                              /* Free Running Timer */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t TIMER:16;              /* Timer Value */
    } B;
  } TIMER;

  uint8_t CAN_reserved0[4];
  union {                              /* Rx Mailboxes Global Mask Register */
    vuint32_t R;
    struct {
      vuint32_t MG:32;                 /* Rx Mailboxes Global Mask Bits */
    } B;
  } RXMGMASK;

  union {                              /* Rx 14 Mask register */
    vuint32_t R;
    struct {
      vuint32_t RX14M:32;              /* Rx Buffer 14 Mask Bits */
    } B;
  } RX14MASK;

  union {                              /* Rx 15 Mask register */
    vuint32_t R;
    struct {
      vuint32_t RX15M:32;              /* Rx Buffer 15 Mask Bits */
    } B;
  } RX15MASK;

  union {                              /* Error Counter */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t RXERRCNT:8;            /* Receive Error Counter */
      vuint32_t TXERRCNT:8;            /* Transmit Error Counter */
    } B;
  } ECR;

  union {                              /* Error and Status 1 register */
    vuint32_t R;
    struct {
      vuint32_t  :13;
      vuint32_t SYNCH:1;               /* CAN Synchronization Status */
      vuint32_t TWRNINT:1;             /* Tx Warning Interrupt Flag */
      vuint32_t RWRNINT:1;             /* Rx Warning Interrupt Flag */
      vuint32_t BIT1ERR:1;             /* Bit1 Error */
      vuint32_t BIT0ERR:1;             /* Bit0 Error */
      vuint32_t ACKERR:1;              /* Acknowledge Error */
      vuint32_t CRCERR:1;              /* Cyclic Redundancy Check Error */
      vuint32_t FRMERR:1;              /* Form Error */
      vuint32_t STFERR:1;              /* Stuffing Error */
      vuint32_t TXWRN:1;               /* TX Error Warning */
      vuint32_t RXWRN:1;               /* Rx Error Warning */
      vuint32_t IDLE:1;
      vuint32_t TX:1;                  /* FlexCAN In Transmission */
      vuint32_t FLTCONF:2;             /* Fault Confinement State */
      vuint32_t RX:1;                  /* FlexCAN In Reception */
      vuint32_t BOFFINT:1;             /* Bus Off Interrupt */
      vuint32_t ERRINT:1;              /* Error Interrupt */
      vuint32_t  :1;
    } B;
  } ESR1;

  union {                              /* Interrupt Masks 2 register */
    vuint32_t R;
    struct {
      vuint32_t BUFHM:32;              /* Buffer MB i Mask */
    } B;
  } IMASK2;

  union {                              /* Interrupt Masks 1 register */
    vuint32_t R;
    struct {
      vuint32_t BUFLM:32;              /* Buffer MB i Mask */
    } B;
  } IMASK1;

  union {                              /* Interrupt Flags 2 register */
    vuint32_t R;
    struct {
      vuint32_t BUFHI:32;              /* Buffer MB i Interrupt */
    } B;
  } IFLAG2;

  union {                              /* Interrupt Flags 1 register */
    vuint32_t R;
    struct {
      vuint32_t BUF31TO8I:24;          /* Buffer MBi Interrupt */
      vuint32_t BUF7I:1;               /* Buffer MB7 Interrupt Or "Rx FIFO Overflow" */
      vuint32_t BUF6I:1;               /* Buffer MB6 Interrupt Or "Rx FIFO Warning" */
      vuint32_t BUF5I:1;               /* Buffer MB5 Interrupt Or "Frames available in Rx FIFO" */
      vuint32_t BUF4TO1I:4;            /* Buffer MB i Interrupt Or "reserved" */
      vuint32_t BUF0I:1;               /* Buffer MB0 Interrupt Or Clear FIFO bit */
    } B;
  } IFLAG1;

  union {                              /* Control 2 register */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t ECRWRE:1;              /* Error-correction Configuration Register Write Enable */
      vuint32_t WRMFRZ:1;              /* Write-Access To Memory In Freeze Mode */
      vuint32_t RFFN:4;                /* Number Of Rx FIFO Filters */
      vuint32_t TASD:5;                /* Tx Arbitration Start Delay */
      vuint32_t MRP:1;                 /* Mailboxes Reception Priority */
      vuint32_t RRS:1;                 /* Remote Request Storing */
      vuint32_t EACEN:1;               /* Entire Frame Arbitration Field Comparison Enable For Rx Mailboxes */
      vuint32_t  :16;
    } B;
  } CTRL2;

  union {                              /* Error and Status 2 register */
    vuint32_t R;
    struct {
      vuint32_t  :9;
      vuint32_t LPTM:7;                /* Lowest Priority Tx Mailbox */
      vuint32_t  :1;
      vuint32_t VPS:1;                 /* Valid Priority Status */
      vuint32_t IMB:1;                 /* Inactive Mailbox */
      vuint32_t  :13;
    } B;
  } ESR2;

  uint8_t CAN_reserved1[8];
  union {                              /* CRC Register */
    vuint32_t R;
    struct {
      vuint32_t  :9;
      vuint32_t MBCRC:7;               /* CRC Mailbox */
      vuint32_t  :1;
      vuint32_t TXCRC:15;              /* CRC Transmitted */
    } B;
  } CRCR;

  union {                              /* Rx FIFO Global Mask register */
    vuint32_t R;
    struct {
      vuint32_t FGM:32;                /* Rx FIFO Global Mask Bits */
    } B;
  } RXFGMASK;

  union {                              /* Rx FIFO Information Register */
    vuint32_t R;
    struct {
      vuint32_t  :23;
      vuint32_t IDHIT:9;               /* Identifier Acceptance Filter Hit Indicator */
    } B;
  } RXFIR;

  uint8_t CAN_reserved2[48];
  struct {
    union {                            /* Message Buffer 0 CS Register */
      vuint32_t R;
      struct {
        vuint32_t  :4;
        vuint32_t CODE:4;              /* Message Buffer Code */
        vuint32_t  :1;
        vuint32_t SRR:1;               /* Substitute Remote Request. Contains a fixed recessive bit. */
        vuint32_t IDE:1;               /* ID Extended. One/zero for extended/standard format frame. */
        vuint32_t RTR:1;               /* Remote Transmission Request. One/zero for remote/data frame. */
        vuint32_t DLC:4;               /* Length of the data to be stored/transmitted. */
        vuint32_t TIMESTAMP:16;        /* Free-Running Counter Time stamp. This 16-bit field is a copy of the Free-Running Timer, captured for Tx and Rx frames at the time when the beginning of the Identifier field appears on the CAN bus. */
      } B;
    } CS;
    union {                            /* Message Buffer 0 ID Register */
      vuint32_t R;
      struct {
        vuint32_t PRIO:3;              /* Local Priority */
        vuint32_t ID_STD:11;           /* Frame Identifier Standard */
        vuint32_t ID_EXT:18;           /* Frame Identifier Extended */
      } B;
    } ID;
    union {
      vuint8_t B[8];
      vuint16_t H[4];
      vuint32_t W[2];
    } DATA;
  } MB[64];

  uint8_t CAN_reserved3[1024];
  union {                              /* Rx Individual Mask Registers */
    vuint32_t R;
    struct {
      vuint32_t MI:32;                 /* Individual Mask Bits */
    } B;
  } RXIMR[64];

  uint8_t CAN_reserved4[352];
  union {                              /* Memory Error Control Register */
    vuint32_t R;
    struct {
      vuint32_t ECRWRDIS:1;            /* Error Configuration Register Write Disable */
      vuint32_t  :11;
      vuint32_t HANCEI_MSK:1;          /* Host Access With Non-Correctable Errors Interrupt Mask */
      vuint32_t FANCEI_MSK:1;          /* FlexCAN Access With Non-Correctable Errors Interrupt Mask */
      vuint32_t  :1;
      vuint32_t CEI_MSK:1;             /* Correctable Errors Interrupt Mask */
      vuint32_t HAERRIE:1;             /* Host Access Error Injection Enable */
      vuint32_t FAERRIE:1;             /* FlexCAN Access Error Injection Enable */
      vuint32_t EXTERRIE:1;            /* Extended Error Injection Enable */
      vuint32_t  :3;
      vuint32_t RERRDIS:1;             /* Error Report Disable */
      vuint32_t ECCDIS:1;              /* Error Correction Disable */
      vuint32_t NCEFAFRZ:1;            /* Non-Correctable Errors In FlexCAN Access Put Device In Freeze Mode */
      vuint32_t  :7;
    } B;
  } MECR;

  union {                              /* Error Injection Address Register */
    vuint32_t R;
    struct {
      vuint32_t  :18;
      vuint32_t INJADDR:14;            /* Address Where Error Is To Be Injected */
    } B;
  } ERRIAR;

  union {                              /* Error Injection Data Pattern Register */
    vuint32_t R;
    struct {
      vuint32_t DFLIP:32;              /* Data flip pattern */
    } B;
  } ERRIDPR;

  union {                              /* Error Injection Parity Pattern Register */
    vuint32_t R;
    struct {
      vuint32_t  :3;
      vuint32_t PFLIP3:5;              /* Parity Flip Pattern For Byte 3 (most significant) */
      vuint32_t  :3;
      vuint32_t PFLIP2:5;              /* Parity Flip Pattern For Byte 2 */
      vuint32_t  :3;
      vuint32_t PFLIP1:5;              /* Parity Flip Pattern For Byte 1 */
      vuint32_t  :3;
      vuint32_t PFLIP0:5;              /* Parity Flip Pattern For Byte 0 (Least Significant) */
    } B;
  } ERRIPPR;

  union {                              /* Error Report Address Register */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t NCE:1;                 /* Non-Correctable Error */
      vuint32_t  :5;
      vuint32_t SAID:3;
      vuint32_t  :2;
      vuint32_t ERRADDR:14;            /* Address Where The Error Was Detected */
    } B;
  } RERRAR;

  union {                              /* Error Report Data Register */
    vuint32_t R;
    struct {
      vuint32_t RDATA:32;              /* Raw data word read from memory with error */
    } B;
  } RERRDR;

  union {                              /* Error Report Syndrome Register */
    vuint32_t R;
    struct {
      vuint32_t BE3:1;                 /* Byte Enabled For Byte 3 (Most Significant) */
      vuint32_t  :2;
      vuint32_t SYND3:5;               /* Error Syndrome For Byte 3 (Most Significant) */
      vuint32_t BE2:1;                 /* Byte Enabled For Byte 2 */
      vuint32_t  :2;
      vuint32_t SYND2:5;               /* Error Syndrome For Byte 2 */
      vuint32_t BE1:1;                 /* Byte Enabled For Byte 1 */
      vuint32_t  :2;
      vuint32_t SYND1:5;               /* Error Syndrome for Byte 1 */
      vuint32_t BE0:1;                 /* Byte Enabled For Byte 0 (least significant) */
      vuint32_t  :2;
      vuint32_t SYND0:5;               /* Error Syndrome For Byte 0 (least significant) */
    } B;
  } RERRSYNR;

  union {                              /* Error Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t HANCEIF:1;             /* Host Access With Non-Correctable Error Interrupt Flag */
      vuint32_t FANCEIF:1;             /* FlexCAN Access With Non-Correctable Error Interrupt Flag */
      vuint32_t  :1;
      vuint32_t CEIF:1;                /* Correctable Error Interrupt Flag */
      vuint32_t  :12;
      vuint32_t HANCEIOF:1;            /* Host Access With Non-Correctable Error Interrupt Overrun Flag */
      vuint32_t FANCEIOF:1;            /* FlexCAN Access With Non-Correctable Error Interrupt Overrun Flag */
      vuint32_t  :1;
      vuint32_t CEIOF:1;               /* Correctable Error Interrupt Overrun Flag */
    } B;
  } ERRSR;
};


/* ============================================================================
   =============================== Module: CMU ================================
   ============================================================================ */

struct CMU_tag {
  union {                              /* CMU Control Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t SFM:1;                 /* Start frequency measure. */
      vuint32_t  :13;
      vuint32_t CKSEL1:2;              /* Frequency measure clock selection bit. */
      vuint32_t  :5;
      vuint32_t RCDIV:2;               /* CLKMT0_RMN division factor. */
      vuint32_t CME:1;                 /* CLKMN1 monitor enable. */
    } B;
  } CSR;

  union {                              /* CMU Frequency Display Register */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t FD:20;                 /* Measured frequency bits. */
    } B;
  } FDR;

  union {                              /* CMU High Frequency Reference Register CLKMN1 */
    vuint32_t R;
    struct {
      vuint32_t  :20;
      vuint32_t HFREF:12;              /* High Frequency reference value. */
    } B;
  } HFREFR;

  union {                              /* CMU Low Frequency Reference Register CLKMN1 */
    vuint32_t R;
    struct {
      vuint32_t  :20;
      vuint32_t LFREF:12;              /* Low Frequency reference value. */
    } B;
  } LFREFR;

  union {                              /* CMU Interrupt Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :28;
      vuint32_t  :1;
      vuint32_t FHHI:1;                /* CLKMN1 frequency higher than high reference event status. */
      vuint32_t FLLI:1;                /* CLKMN1 frequency less than low reference event status. */
      vuint32_t OLRI:1;                /* Oscillator frequency less than f CLKMT0_RMN * 2RCDIVevent status. */
    } B;
  } ISR;

  uint8_t CMU_reserved0[4];
  union {                              /* CMU Measurement Duration Register */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t MD:20;                 /* Measurement duration bits */
    } B;
  } MDR;
};


/* ============================================================================
   =============================== Module: CRC ================================
   ============================================================================ */

struct CRC_tag {
  union {                              /* Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t  :18;
      vuint32_t SWAP_BYTEWISE:1;       /* Swap CRC_INP byte-wise */
      vuint32_t SWAP_BITWISE:1;        /* Swap CRC_INP bit-wise */
      vuint32_t POLYG:2;               /* Polynomial selection */
      vuint32_t SWAP:1;                /* Swap selection */
      vuint32_t INV:1;                 /* Inversion selection */
    } B;
  } CFG;

  union {                              /* Input Register */
    vuint32_t R;
    struct {
      vuint32_t INP:32;                /* Input data for the CRC computation */
    } B;
  } INP;

  union {                              /* Current Status Register */
    vuint32_t R;
    struct {
      vuint32_t CSTAT:32;              /* CRC signature status */
    } B;
  } CSTAT;

  union {                              /* Output Register */
    vuint32_t R;
    struct {
      vuint32_t OUTP:32;               /* Final CRC signature */
    } B;
  } OUTP;
};


/* ============================================================================
   =============================== Module: DECFILTER ==========================
   ============================================================================ */

struct DECFILTER_tag {
  union {                              /* Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t MDIS:1;                /* Module Disable */
      vuint32_t FREN:1;                /* Freeze Enable */
      vuint32_t  :1;
      vuint32_t FRZ:1;                 /* Freeze Mode */
      vuint32_t SRES:1;                /* Software-reset bit */
      vuint32_t CASCD:2;               /* Cascade Mode Configuration */
      vuint32_t IDEN:1;                /* Input Data Interrupt Enable */
      vuint32_t ODEN:1;                /* Output Data Interrupt Enable */
      vuint32_t ERREN:1;               /* Error Interrupt Enable */
      vuint32_t  :1;
      vuint32_t FTYPE:2;               /* Filter Type Selection bits */
      vuint32_t  :1;
      vuint32_t SCAL:2;                /* Filter Scaling Factor */
      vuint32_t IDIS:1;                /* Input Disable */
      vuint32_t SAT:1;                 /* Saturation Enable */
      vuint32_t ISEL:1;                /* Input Selection */
      vuint32_t  :1;
      vuint32_t DEC_RATE:4;            /* Decimation Rate Selection */
      vuint32_t SDIE:1;                /* Integrator Data Interrupt Enable */
      vuint32_t DSEL:1;                /* DMA Selection */
      vuint32_t IBIE:1;                /* Input Buffer Interrupt Request Enable */
      vuint32_t OBIE:1;                /* Output Buffer Interrupt Request Enable */
      vuint32_t  :4;
    } B;
  } MCR;

  union {                              /* Module Status Register */
    vuint32_t R;
    struct {
      vuint32_t BSY:1;                 /* Decimation Filter Busy indication */
      vuint32_t  :1;
      vuint32_t DEC_COUNTER:4;         /* Decimation Counter */
      vuint32_t IDFC:1;                /* Input Data Flag Clear bit */
      vuint32_t ODFC:1;                /* Output Data Flag Clear bit */
      vuint32_t  :1;
      vuint32_t IBIC:1;                /* Input Buffer Interrupt Request Clear bit */
      vuint32_t OBIC:1;                /* Output Buffer Interrupt Request Clear bit */
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t OVFC:1;                /* OVF Clear bit */
      vuint32_t OVRC:1;                /* OVR Clear bit */
      vuint32_t IVRC:1;                /* IVR Clear bit */
      vuint32_t  :6;
      vuint32_t IDF:1;                 /* Input Data Flag */
      vuint32_t ODF:1;                 /* Output Data Flag */
      vuint32_t  :1;
      vuint32_t IBIF:1;                /* Input Buffer Interrupt Request Flag */
      vuint32_t OBIF:1;                /* Output Buffer Interrupt Request Flag */
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t OVF:1;                 /* Filter Overflow Flag */
      vuint32_t OVR:1;                 /* Output Interface Buffer Overrun */
      vuint32_t IVR:1;                 /* Input Interface Buffer Overrun */
    } B;
  } MSR;

  union {                              /* Module Extended Config Register */
    vuint32_t R;
    struct {
      vuint32_t SDMAE:1;               /* Integrator DMA Enable */
      vuint32_t SSIG:1;                /* Integrator Signal operation selection */
      vuint32_t SSAT:1;                /* Integrator Saturated operation selection */
      vuint32_t SCSAT:1;               /* Integrator Counter Saturated operation selection */
      vuint32_t  :10;
      vuint32_t SRQ:1;                 /* Integrator Output Request */
      vuint32_t SZRO:1;                /* Integrator Zero */
      vuint32_t SISEL:1;               /* Integrator Input Selection */
      vuint32_t  :1;
      vuint32_t SZROSEL:2;             /* Integrator Zero Control Mode Selection */
      vuint32_t  :2;
      vuint32_t SHLTSEL:2;             /* Integrator Halt Control Selection */
      vuint32_t  :1;
      vuint32_t SRQSEL:3;              /* Integrator Output Read Request Mode Selection */
      vuint32_t  :2;
      vuint32_t SENSEL:2;              /* Integrator Enable Control Selection */
    } B;
  } MXCR;

  union {                              /* Module Extended Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t SDFC:1;                /* Integrator Output Data Flag Clear bit */
      vuint32_t  :2;
      vuint32_t SSEC:1;                /* Integrator Sum Exception Clear bit */
      vuint32_t SCEC:1;                /* Integrator Count Exception Clear bit */
      vuint32_t  :1;
      vuint32_t SSOVFC:1;              /* Integrator Sum Overflow Clear bit */
      vuint32_t SCOVFC:1;              /* Integrator Count Overflow Clear bit */
      vuint32_t SVRC:1;                /* SVR Clear bit */
      vuint32_t  :7;
      vuint32_t SDF:1;                 /* Integrator Data Flag */
      vuint32_t  :2;
      vuint32_t SSE:1;                 /* Integrator Sum Exception flag */
      vuint32_t SCE:1;                 /* Integrator Count Exception flag */
      vuint32_t  :1;
      vuint32_t SSOVF:1;               /* Integrator Sum Overflow Flag */
      vuint32_t SCOVF:1;               /* Integrator Count Overflow Flag */
      vuint32_t SVR:1;                 /* Integrator Data Overrun */
    } B;
  } MXSR;

  union {                              /* Interface Input Buffer */
    vuint32_t R;
    struct {
      vuint32_t  :3;
      vuint32_t  :1;
      vuint32_t INTAG:4;               /* Decimation filter input tag bits */
      vuint32_t  :6;
      vuint32_t PREFILL:1;             /* Decimation Filter Prefill/Filter control bit */
      vuint32_t FLUSH:1;               /* Decimation Filter Flush control bit */
      vuint32_t INPBUF:16;             /* Input Buffer Data */
    } B;
  } IB;

  union {                              /* Interface Output Buffer */
    vuint32_t R;
    struct {
      vuint32_t  :11;
      vuint32_t  :1;
      vuint32_t OUTTAG:4;              /* Decimation filter output tag bits */
      vuint32_t OUTBUF:16;             /* Output Buffer Data */
    } B;
  } OB;

  uint8_t DECFILTER_reserved0[8];
  union {                              /* Filter Coefficient */
    vuint32_t R;
    struct {
      vuint32_t COEFnSIGNR:8;          /* COEFn sign repeated */
      vuint32_t COEFn:24;              /* Coefficient n field */
    } B;
  } COEF[9];

  uint8_t DECFILTER_reserved1[52];
  union {                              /* Filter TAP */
    vuint32_t R;
    struct {
      vuint32_t TAPnSIGNR:8;           /* TAPn sign repeated */
      vuint32_t TAPn:24;               /* TAPn Register */
    } B;
  } TAP[8];

  uint8_t DECFILTER_reserved2[72];
  union {                              /* Final Integer Value Register */
    vuint32_t R;
    struct {
      vuint32_t SUM_VALUE:32;          /* Integration Sum Value */
    } B;
  } FINTVAL;

  union {                              /* Final Integer Count Register */
    vuint32_t R;
    struct {
      vuint32_t COUNT:32;              /* Integration Count Value */
    } B;
  } FINTCNT;

  union {                              /* Current Integer Value Register */
    vuint32_t R;
    struct {
      vuint32_t SUM_VALUE:32;          /* Integration Sum Value */
    } B;
  } CINTVAL;

  union {                              /* Current Integer Count Register */
    vuint32_t R;
    struct {
      vuint32_t COUNT:32;              /* Integration Count Value */
    } B;
  } CINTCNT;
};


/* ============================================================================
   =============================== Module: DMAMUX =============================
   ============================================================================ */

struct DMAMUX_tag {
  union {                              /* Channel Configuration register */
    vuint8_t R;
    struct {
      vuint8_t ENBL:1;                 /* DMA Channel Enable */
      vuint8_t TRIG:1;                 /* DMA Channel Trigger Enable */
      vuint8_t SOURCE:6;               /* DMA Channel Source (Slot) */
    } B;
  } CHCFG[16];
};


/* ============================================================================
   =============================== Module: DMA ================================
   ============================================================================ */

struct DMA_tag {
  union {                              /* Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :14;
      vuint32_t CX:1;                  /* Cancel Transfer */
      vuint32_t ECX:1;                 /* Error Cancel Transfer */
      vuint32_t GRP3PRI:2;             /* Channel Group 3 Priority */
      vuint32_t GRP2PRI:2;             /* Channel Group 2 Priority */
      vuint32_t GRP1PRI:2;             /* Channel Group 1 Priority */
      vuint32_t GRP0PRI:2;             /* Channel Group 0 Priority */
      vuint32_t EMLM:1;                /* Enable Minor Loop Mapping. */
      vuint32_t CLM:1;                 /* Continuous Link Mode */
      vuint32_t HALT:1;                /* Halt DMA Operations */
      vuint32_t HOE:1;                 /* Halt On Error */
      vuint32_t ERGA:1;                /* Enable Round Robin Group Arbitration */
      vuint32_t ERCA:1;                /* Enable Round Robin Channel Arbitration */
      vuint32_t EDBG:1;                /* Enable Debug */
      vuint32_t EBW:1;                 /* Enable Buffered Writes */
    } B;
  } CR;

  union {                              /* Error Status Register */
    vuint32_t R;
    struct {
      vuint32_t VLD:1;
      vuint32_t  :13;
      vuint32_t UCE:1;                 /* Uncorrectable ECC error. */
      vuint32_t ECX:1;                 /* Transfer Canceled. */
      vuint32_t GPE:1;                 /* Group Priority Error. */
      vuint32_t CPE:1;                 /* Channel Priority Error. */
      vuint32_t ERRCHN:6;              /* Error/Cancelled Channel Number. */
      vuint32_t SAE:1;                 /* Source Address Error. */
      vuint32_t SOE:1;                 /* Source Offset Error */
      vuint32_t DAE:1;                 /* Destination Address Error. */
      vuint32_t DOE:1;                 /* Destination Offset Error. */
      vuint32_t NCE:1;                 /* NBYTES/CITER Configuration Error. */
      vuint32_t SGE:1;                 /* Scatter/Gather Configuration Error. */
      vuint32_t SBE:1;                 /* Source Bus Error. */
      vuint32_t DBE:1;                 /* Destination Bus Error. */
    } B;
  } ES;

  union {                              /* Enable Request Register High */
    vuint32_t R;
    struct {
      vuint32_t ERQ63:1;               /* Enable DMA Request 63 */
      vuint32_t ERQ62:1;               /* Enable DMA Request 62 */
      vuint32_t ERQ61:1;               /* Enable DMA Request 61 */
      vuint32_t ERQ60:1;               /* Enable DMA Request 60 */
      vuint32_t ERQ59:1;               /* Enable DMA Request 59 */
      vuint32_t ERQ58:1;               /* Enable DMA Request 58 */
      vuint32_t ERQ57:1;               /* Enable DMA Request 57 */
      vuint32_t ERQ56:1;               /* Enable DMA Request 56 */
      vuint32_t ERQ55:1;               /* Enable DMA Request 55 */
      vuint32_t ERQ54:1;               /* Enable DMA Request 54 */
      vuint32_t ERQ53:1;               /* Enable DMA Request 53 */
      vuint32_t ERQ52:1;               /* Enable DMA Request 52 */
      vuint32_t ERQ51:1;               /* Enable DMA Request 51 */
      vuint32_t ERQ50:1;               /* Enable DMA Request 50 */
      vuint32_t ERQ49:1;               /* Enable DMA Request 49 */
      vuint32_t ERQ48:1;               /* Enable DMA Request 48 */
      vuint32_t ERQ47:1;               /* Enable DMA Request 47 */
      vuint32_t ERQ46:1;               /* Enable DMA Request 46 */
      vuint32_t ERQ45:1;               /* Enable DMA Request 45 */
      vuint32_t ERQ44:1;               /* Enable DMA Request 44 */
      vuint32_t ERQ43:1;               /* Enable DMA Request 43 */
      vuint32_t ERQ42:1;               /* Enable DMA Request 42 */
      vuint32_t ERQ41:1;               /* Enable DMA Request 41 */
      vuint32_t ERQ40:1;               /* Enable DMA Request 40 */
      vuint32_t ERQ39:1;               /* Enable DMA Request 39 */
      vuint32_t ERQ38:1;               /* Enable DMA Request 38 */
      vuint32_t ERQ37:1;               /* Enable DMA Request 37 */
      vuint32_t ERQ36:1;               /* Enable DMA Request 36 */
      vuint32_t ERQ35:1;               /* Enable DMA Request 35 */
      vuint32_t ERQ34:1;               /* Enable DMA Request 34 */
      vuint32_t ERQ33:1;               /* Enable DMA Request 33 */
      vuint32_t ERQ32:1;               /* Enable DMA Request 32 */
    } B;
  } ERQH;

  union {                              /* Enable Request Register Low */
    vuint32_t R;
    struct {
      vuint32_t ERQ31:1;               /* Enable DMA Request 31 */
      vuint32_t ERQ30:1;               /* Enable DMA Request 30 */
      vuint32_t ERQ29:1;               /* Enable DMA Request 29 */
      vuint32_t ERQ28:1;               /* Enable DMA Request 28 */
      vuint32_t ERQ27:1;               /* Enable DMA Request 27 */
      vuint32_t ERQ26:1;               /* Enable DMA Request 26 */
      vuint32_t ERQ25:1;               /* Enable DMA Request 25 */
      vuint32_t ERQ24:1;               /* Enable DMA Request 24 */
      vuint32_t ERQ23:1;               /* Enable DMA Request 23 */
      vuint32_t ERQ22:1;               /* Enable DMA Request 22 */
      vuint32_t ERQ21:1;               /* Enable DMA Request 21 */
      vuint32_t ERQ20:1;               /* Enable DMA Request 20 */
      vuint32_t ERQ19:1;               /* Enable DMA Request 19 */
      vuint32_t ERQ18:1;               /* Enable DMA Request 18 */
      vuint32_t ERQ17:1;               /* Enable DMA Request 17 */
      vuint32_t ERQ16:1;               /* Enable DMA Request 16 */
      vuint32_t ERQ15:1;               /* Enable DMA Request 15 */
      vuint32_t ERQ14:1;               /* Enable DMA Request 14 */
      vuint32_t ERQ13:1;               /* Enable DMA Request 13 */
      vuint32_t ERQ12:1;               /* Enable DMA Request 12 */
      vuint32_t ERQ11:1;               /* Enable DMA Request 11 */
      vuint32_t ERQ10:1;               /* Enable DMA Request 10 */
      vuint32_t ERQ9:1;                /* Enable DMA Request 9 */
      vuint32_t ERQ8:1;                /* Enable DMA Request 8 */
      vuint32_t ERQ7:1;                /* Enable DMA Request 7 */
      vuint32_t ERQ6:1;                /* Enable DMA Request 6 */
      vuint32_t ERQ5:1;                /* Enable DMA Request 5 */
      vuint32_t ERQ4:1;                /* Enable DMA Request 4 */
      vuint32_t ERQ3:1;                /* Enable DMA Request 3 */
      vuint32_t ERQ2:1;                /* Enable DMA Request 2 */
      vuint32_t ERQ1:1;                /* Enable DMA Request 1 */
      vuint32_t ERQ0:1;                /* Enable DMA Request 0 */
    } B;
  } ERQL;

  union {                              /* Enable Error Interrupt Register High */
    vuint32_t R;
    struct {
      vuint32_t EEI63:1;               /* Enable Error Interrupt 63 */
      vuint32_t EEI62:1;               /* Enable Error Interrupt 62 */
      vuint32_t EEI61:1;               /* Enable Error Interrupt 61 */
      vuint32_t EEI60:1;               /* Enable Error Interrupt 60 */
      vuint32_t EEI59:1;               /* Enable Error Interrupt 59 */
      vuint32_t EEI58:1;               /* Enable Error Interrupt 58 */
      vuint32_t EEI57:1;               /* Enable Error Interrupt 57 */
      vuint32_t EEI56:1;               /* Enable Error Interrupt 56 */
      vuint32_t EEI55:1;               /* Enable Error Interrupt 55 */
      vuint32_t EEI54:1;               /* Enable Error Interrupt 54 */
      vuint32_t EEI53:1;               /* Enable Error Interrupt 53 */
      vuint32_t EEI52:1;               /* Enable Error Interrupt 52 */
      vuint32_t EEI51:1;               /* Enable Error Interrupt 51 */
      vuint32_t EEI50:1;               /* Enable Error Interrupt 50 */
      vuint32_t EEI49:1;               /* Enable Error Interrupt 49 */
      vuint32_t EEI48:1;               /* Enable Error Interrupt 48 */
      vuint32_t EEI47:1;               /* Enable Error Interrupt 47 */
      vuint32_t EEI46:1;               /* Enable Error Interrupt 46 */
      vuint32_t EEI45:1;               /* Enable Error Interrupt 45 */
      vuint32_t EEI44:1;               /* Enable Error Interrupt 44 */
      vuint32_t EEI43:1;               /* Enable Error Interrupt 43 */
      vuint32_t EEI42:1;               /* Enable Error Interrupt 42 */
      vuint32_t EEI41:1;               /* Enable Error Interrupt 41 */
      vuint32_t EEI40:1;               /* Enable Error Interrupt 40 */
      vuint32_t EEI39:1;               /* Enable Error Interrupt 39 */
      vuint32_t EEI38:1;               /* Enable ErrorInterrupt 38 */
      vuint32_t EEI37:1;               /* Enable Error Interrupt 37 */
      vuint32_t EEI36:1;               /* Enable Error Interrupt 36 */
      vuint32_t EEI35:1;               /* Enable Error Interrupt 35 */
      vuint32_t EEI34:1;               /* Enable Error Interrupt 34 */
      vuint32_t EEI33:1;               /* Enable Error Interrupt 33 */
      vuint32_t EEI32:1;               /* Enable Error Interrupt 32 */
    } B;
  } EEIH;

  union {                              /* Enable Error Interrupt Register High */
    vuint32_t R;
    struct {
      vuint32_t EEI31:1;               /* Enable Error Interrupt 31 */
      vuint32_t EEI30:1;               /* Enable Error Interrupt 30 */
      vuint32_t EEI29:1;               /* Enable Error Interrupt 29 */
      vuint32_t EEI28:1;               /* Enable Error Interrupt 28 */
      vuint32_t EEI27:1;               /* Enable Error Interrupt 27 */
      vuint32_t EEI26:1;               /* Enable Error Interrupt 26 */
      vuint32_t EEI25:1;               /* Enable Error Interrupt 25 */
      vuint32_t EEI24:1;               /* Enable Error Interrupt 24 */
      vuint32_t EEI23:1;               /* Enable Error Interrupt 23 */
      vuint32_t EEI22:1;               /* Enable Error Interrupt 22 */
      vuint32_t EEI21:1;               /* Enable Error Interrupt 21 */
      vuint32_t EEI20:1;               /* Enable Error Interrupt 20 */
      vuint32_t EEI19:1;               /* Enable Error Interrupt 19 */
      vuint32_t EEI18:1;               /* Enable Error Interrupt 18 */
      vuint32_t EEI17:1;               /* Enable Error Interrupt 17 */
      vuint32_t EEI16:1;               /* Enable Error Interrupt 16 */
      vuint32_t EEI15:1;               /* Enable Error Interrupt 15 */
      vuint32_t EEI14:1;               /* Enable Error Interrupt 14 */
      vuint32_t EEI13:1;               /* Enable Error Interrupt 13 */
      vuint32_t EEI12:1;               /* Enable Error Interrupt 12 */
      vuint32_t EEI11:1;               /* Enable Error Interrupt 11 */
      vuint32_t EEI10:1;               /* Enable Error Interrupt 10 */
      vuint32_t EEI9:1;                /* Enable Error Interrupt 9 */
      vuint32_t EEI8:1;                /* Enable Error Interrupt 8 */
      vuint32_t EEI7:1;                /* Enable Error Interrupt 7 */
      vuint32_t EEI6:1;                /* Enable ErrorInterrupt 6 */
      vuint32_t EEI5:1;                /* Enable Error Interrupt 5 */
      vuint32_t EEI4:1;                /* Enable Error Interrupt 4 */
      vuint32_t EEI3:1;                /* Enable Error Interrupt 3 */
      vuint32_t EEI2:1;                /* Enable Error Interrupt 2 */
      vuint32_t EEI1:1;                /* Enable Error Interrupt 1 */
      vuint32_t EEI0:1;                /* Enable Error Interrupt 0 */
    } B;
  } EEIL;

  union {                              /* Set Enable Request Register */
    vuint8_t R;
    struct {
      vuint8_t NOP:1;                  /* No Op enable */
      vuint8_t SERQ:7;                 /* Set Enable Request. */
    } B;
  } SERQ;

  union {                              /* Clear Enable Request Register */
    vuint8_t R;
    struct {
      vuint8_t NOP:1;                  /* No Op enable. */
      vuint8_t CERQ:7;                 /* Clear enable request. */
    } B;
  } CERQ;

  union {                              /* Set Enable Error Interrupt Register */
    vuint8_t R;
    struct {
      vuint8_t NOP:1;                  /* No Op enable */
      vuint8_t SEEI:7;                 /* Set enable error interrupt */
    } B;
  } SEEI;

  union {                              /* Clear Enable Error Interrupt Register */
    vuint8_t R;
    struct {
      vuint8_t NOP:1;                  /* No Op enable */
      vuint8_t CEEI:7;                 /* Clear Enable Error Interrupt. */
    } B;
  } CEEI;

  union {                              /* Clear Interrupt Request Register */
    vuint8_t R;
    struct {
      vuint8_t NOP:1;                  /* No Op enable. */
      vuint8_t CINT:7;                 /* Clear Interrupt Request. */
    } B;
  } CINT;

  union {                              /* Clear Error Register */
    vuint8_t R;
    struct {
      vuint8_t NOP:1;                  /* No Op enable. */
      vuint8_t CERR:7;                 /* Clear Error Indicator. */
    } B;
  } CERR;

  union {                              /* Set START Bit Register */
    vuint8_t R;
    struct {
      vuint8_t NOP:1;                  /* No Op enable. */
      vuint8_t SSRT:7;                 /* Set START Bit */
    } B;
  } SSRT;

  union {                              /* Clear DONE Status Bit Register */
    vuint8_t R;
    struct {
      vuint8_t NOP:1;                  /* No Op enable. */
      vuint8_t CDNE:7;                 /* Clear DONE Status Bit. */
    } B;
  } CDNE;

  union {                              /* Interrupt Request Register High */
    vuint32_t R;
    struct {
      vuint32_t INT63:1;               /* Interrupt Request 63 */
      vuint32_t INT62:1;               /* Interrupt Request 62 */
      vuint32_t INT61:1;               /* Interrupt Request 61 */
      vuint32_t INT60:1;               /* Interrupt Request 60 */
      vuint32_t INT59:1;               /* Interrupt Request 59 */
      vuint32_t INT58:1;               /* Interrupt Request 58 */
      vuint32_t INT57:1;               /* Interrupt Request 57 */
      vuint32_t INT56:1;               /* Interrupt Request 56 */
      vuint32_t INT55:1;               /* Interrupt Request 55 */
      vuint32_t INT54:1;               /* Interrupt Request 54 */
      vuint32_t INT53:1;               /* Interrupt Request 53 */
      vuint32_t INT52:1;               /* Interrupt Request 52 */
      vuint32_t INT51:1;               /* Interrupt Request 51 */
      vuint32_t INT50:1;               /* Interrupt Request 50 */
      vuint32_t INT49:1;               /* Interrupt Request 49 */
      vuint32_t INT48:1;               /* Interrupt Request 48 */
      vuint32_t INT47:1;               /* Interrupt Request 47 */
      vuint32_t INT46:1;               /* Interrupt Request 46 */
      vuint32_t INT45:1;               /* Interrupt Request 45 */
      vuint32_t INT44:1;               /* Interrupt Request 44 */
      vuint32_t INT43:1;               /* Interrupt Request 43 */
      vuint32_t INT42:1;               /* Interrupt Request 42 */
      vuint32_t INT41:1;               /* Interrupt Request 41 */
      vuint32_t INT40:1;               /* Interrupt Request 40 */
      vuint32_t INT39:1;               /* Interrupt Request 30 */
      vuint32_t INT38:1;               /* Interrupt Request 38 */
      vuint32_t INT37:1;               /* Interrupt Request 37 */
      vuint32_t INT36:1;               /* Interrupt Request 36 */
      vuint32_t INT35:1;               /* Interrupt Request 35 */
      vuint32_t INT34:1;               /* Interrupt Request 34 */
      vuint32_t INT33:1;               /* Interrupt Request 33 */
      vuint32_t INT32:1;               /* Interrupt Request 32 */
    } B;
  } INTH;

  union {                              /* Interrupt Request Register Low */
    vuint32_t R;
    struct {
      vuint32_t INT31:1;               /* Interrupt Request 31 */
      vuint32_t INT30:1;               /* Interrupt Request 30 */
      vuint32_t INT29:1;               /* Interrupt Request 29 */
      vuint32_t INT28:1;               /* Interrupt Request 28 */
      vuint32_t INT27:1;               /* Interrupt Request 27 */
      vuint32_t INT26:1;               /* Interrupt Request 26 */
      vuint32_t INT25:1;               /* Interrupt Request 25 */
      vuint32_t INT24:1;               /* Interrupt Request 24 */
      vuint32_t INT23:1;               /* Interrupt Request 23 */
      vuint32_t INT22:1;               /* Interrupt Request 22 */
      vuint32_t INT21:1;               /* Interrupt Request 21 */
      vuint32_t INT20:1;               /* Interrupt Request 20 */
      vuint32_t INT19:1;               /* Interrupt Request 19 */
      vuint32_t INT18:1;               /* Interrupt Request 18 */
      vuint32_t INT17:1;               /* Interrupt Request 17 */
      vuint32_t INT16:1;               /* Interrupt Request 16 */
      vuint32_t INT15:1;               /* Interrupt Request 15 */
      vuint32_t INT14:1;               /* Interrupt Request 14 */
      vuint32_t INT13:1;               /* Interrupt Request 13 */
      vuint32_t INT12:1;               /* Interrupt Request 12 */
      vuint32_t INT11:1;               /* Interrupt Request 11 */
      vuint32_t INT10:1;               /* Interrupt Request 10 */
      vuint32_t INT9:1;                /* Interrupt Request 9 */
      vuint32_t INT8:1;                /* Interrupt Request 8 */
      vuint32_t INT7:1;                /* Interrupt Request 7 */
      vuint32_t INT6:1;                /* Interrupt Request 6 */
      vuint32_t INT5:1;                /* Interrupt Request 5 */
      vuint32_t INT4:1;                /* Interrupt Request 4 */
      vuint32_t INT3:1;                /* Interrupt Request 3 */
      vuint32_t INT2:1;                /* Interrupt Request 2 */
      vuint32_t INT1:1;                /* Interrupt Request 1 */
      vuint32_t INT0:1;                /* Interrupt Request 0 */
    } B;
  } INTL;

  union {                              /* Error Register High */
    vuint32_t R;
    struct {
      vuint32_t ERR63:1;               /* Error In Channel 63 */
      vuint32_t ERR62:1;               /* Error In Channel 62 */
      vuint32_t ERR61:1;               /* Error In Channel 61 */
      vuint32_t ERR60:1;               /* Error In Channel 60 */
      vuint32_t ERR59:1;               /* Error In Channel 59 */
      vuint32_t ERR58:1;               /* Error In Channel 58 */
      vuint32_t ERR57:1;               /* Error In Channel 57 */
      vuint32_t ERR56:1;               /* Error In Channel 56 */
      vuint32_t ERR55:1;               /* Error In Channel 55 */
      vuint32_t ERR54:1;               /* Error In Channel 54 */
      vuint32_t ERR53:1;               /* Error In Channel 53 */
      vuint32_t ERR52:1;               /* Error In Channel 52 */
      vuint32_t ERR51:1;               /* Error In Channel 51 */
      vuint32_t ERR50:1;               /* Error In Channel 50 */
      vuint32_t ERR49:1;               /* Error In Channel 49 */
      vuint32_t ERR48:1;               /* Error In Channel 48 */
      vuint32_t ERR47:1;               /* Error In Channel 47 */
      vuint32_t ERR46:1;               /* Error In Channel 46 */
      vuint32_t ERR45:1;               /* Error In Channel 45 */
      vuint32_t ERR44:1;               /* Error In Channel 44 */
      vuint32_t ERR43:1;               /* Error In Channel 43 */
      vuint32_t ERR42:1;               /* Error In Channel 42 */
      vuint32_t ERR41:1;               /* Error In Channel 41 */
      vuint32_t ERR40:1;               /* Error In Channel 40 */
      vuint32_t ERR39:1;               /* Error In Channel 39 */
      vuint32_t ERR38:1;               /* Error In Channel 38 */
      vuint32_t ERR37:1;               /* Error In Channel 37 */
      vuint32_t ERR36:1;               /* Error In Channel 36 */
      vuint32_t ERR35:1;               /* Error In Channel 35 */
      vuint32_t ERR34:1;               /* Error In Channel 34 */
      vuint32_t ERR33:1;               /* Error In Channel 33 */
      vuint32_t ERR32:1;               /* Error In Channel 32 */
    } B;
  } ERRH;

  union {                              /* Error Register Low */
    vuint32_t R;
    struct {
      vuint32_t ERR31:1;               /* Error In Channel 31 */
      vuint32_t ERR30:1;               /* Error In Channel 30 */
      vuint32_t ERR29:1;               /* Error In Channel 29 */
      vuint32_t ERR28:1;               /* Error In Channel 28 */
      vuint32_t ERR27:1;               /* Error In Channel 27 */
      vuint32_t ERR26:1;               /* Error In Channel 26 */
      vuint32_t ERR25:1;               /* Error In Channel 25 */
      vuint32_t ERR24:1;               /* Error In Channel 24 */
      vuint32_t ERR23:1;               /* Error In Channel 23 */
      vuint32_t ERR22:1;               /* Error In Channel 22 */
      vuint32_t ERR21:1;               /* Error In Channel 21 */
      vuint32_t ERR20:1;               /* Error In Channel 20 */
      vuint32_t ERR19:1;               /* Error In Channel 19 */
      vuint32_t ERR18:1;               /* Error In Channel 18 */
      vuint32_t ERR17:1;               /* Error In Channel 17 */
      vuint32_t ERR16:1;               /* Error In Channel 16 */
      vuint32_t ERR15:1;               /* Error In Channel 15 */
      vuint32_t ERR14:1;               /* Error In Channel 14 */
      vuint32_t ERR13:1;               /* Error In Channel 13 */
      vuint32_t ERR12:1;               /* Error In Channel 12 */
      vuint32_t ERR11:1;               /* Error In Channel 11 */
      vuint32_t ERR10:1;               /* Error In Channel 10 */
      vuint32_t ERR9:1;                /* Error In Channel 9 */
      vuint32_t ERR8:1;                /* Error In Channel 8 */
      vuint32_t ERR7:1;                /* Error In Channel 7 */
      vuint32_t ERR6:1;                /* Error In Channel 6 */
      vuint32_t ERR5:1;                /* Error In Channel 5 */
      vuint32_t ERR4:1;                /* Error In Channel 4 */
      vuint32_t ERR3:1;                /* Error In Channel 3 */
      vuint32_t ERR2:1;                /* Error In Channel 2 */
      vuint32_t ERR1:1;                /* Error In Channel 1 */
      vuint32_t ERR0:1;                /* Error In Channel 0 */
    } B;
  } ERRL;

  union {                              /* Hardware Request Status Register High */
    vuint32_t R;
    struct {
      vuint32_t HRS63:1;               /* Hardware Request Status Channel 63 */
      vuint32_t HRS62:1;               /* Hardware Request Status Channel 62 */
      vuint32_t HRS61:1;               /* Hardware Request Status Channel 61 */
      vuint32_t HRS60:1;               /* Hardware Request Status Channel 60 */
      vuint32_t HRS59:1;               /* Hardware Request Status Channel 59 */
      vuint32_t HRS58:1;               /* Hardware Request Status Channel 58 */
      vuint32_t HRS57:1;               /* Hardware Request Status Channel 57 */
      vuint32_t HRS56:1;               /* Hardware Request Status Channel 56 */
      vuint32_t HRS55:1;               /* Hardware Request Status Channel 55 */
      vuint32_t HRS54:1;               /* Hardware Request Status Channel 54 */
      vuint32_t HRS53:1;               /* Hardware Request Status Channel 53 */
      vuint32_t HRS52:1;               /* Hardware Request Status Channel 52 */
      vuint32_t HRS51:1;               /* Hardware Request Status Channel 51 */
      vuint32_t HRS50:1;               /* Hardware Request Status Channel 50 */
      vuint32_t HRS49:1;               /* Hardware Request Status Channel 49 */
      vuint32_t HRS48:1;               /* Hardware Request Status Channel 48 */
      vuint32_t HRS47:1;               /* Hardware Request Status Channel 47 */
      vuint32_t HRS46:1;               /* Hardware Request Status Channel 46 */
      vuint32_t HRS45:1;               /* Hardware Request Status Channel 45 */
      vuint32_t HRS44:1;               /* Hardware Request Status Channel 44 */
      vuint32_t HRS43:1;               /* Hardware Request Status Channel 43 */
      vuint32_t HRS42:1;               /* Hardware Request Status Channel 42 */
      vuint32_t HRS41:1;               /* Hardware Request Status Channel 41 */
      vuint32_t HRS40:1;               /* Hardware Request Status Channel 40 */
      vuint32_t HRS39:1;               /* Hardware Request Status Channel 39 */
      vuint32_t HRS38:1;               /* Hardware Request Status Channel 38 */
      vuint32_t HRS37:1;               /* Hardware Request Status Channel 37 */
      vuint32_t HRS36:1;               /* Hardware Request Status Channel 36 */
      vuint32_t HRS35:1;               /* Hardware Request Status Channel 35 */
      vuint32_t HRS34:1;               /* Hardware Request Status Channel 34 */
      vuint32_t HRS33:1;               /* Hardware Request Status Channel 33 */
      vuint32_t HRS32:1;               /* Hardware Request Status Channel 32 */
    } B;
  } HRSH;

  union {                              /* Hardware Request Status Register Low */
    vuint32_t R;
    struct {
      vuint32_t HRS31:1;               /* Hardware Request Status Channel 31 */
      vuint32_t HRS30:1;               /* Hardware Request Status Channel 30 */
      vuint32_t HRS29:1;               /* Hardware Request Status Channel 29 */
      vuint32_t HRS28:1;               /* Hardware Request Status Channel 28 */
      vuint32_t HRS27:1;               /* Hardware Request Status Channel 27 */
      vuint32_t HRS26:1;               /* Hardware Request Status Channel 26 */
      vuint32_t HRS25:1;               /* Hardware Request Status Channel 25 */
      vuint32_t HRS24:1;               /* Hardware Request Status Channel 24 */
      vuint32_t HRS23:1;               /* Hardware Request Status Channel 23 */
      vuint32_t HRS22:1;               /* Hardware Request Status Channel 22 */
      vuint32_t HRS21:1;               /* Hardware Request Status Channel 21 */
      vuint32_t HRS20:1;               /* Hardware Request Status Channel 20 */
      vuint32_t HRS19:1;               /* Hardware Request Status Channel 19 */
      vuint32_t HRS18:1;               /* Hardware Request Status Channel 18 */
      vuint32_t HRS17:1;               /* Hardware Request Status Channel 17 */
      vuint32_t HRS16:1;               /* Hardware Request Status Channel 16 */
      vuint32_t HRS15:1;               /* Hardware Request Status Channel 15 */
      vuint32_t HRS14:1;               /* Hardware Request Status Channel 14 */
      vuint32_t HRS13:1;               /* Hardware Request Status Channel 13 */
      vuint32_t HRS12:1;               /* Hardware Request Status Channel 12 */
      vuint32_t HRS11:1;               /* Hardware Request Status Channel 11 */
      vuint32_t HRS10:1;               /* Hardware Request Status Channel 10 */
      vuint32_t HRS9:1;                /* Hardware Request Status Channel 9 */
      vuint32_t HRS8:1;                /* Hardware Request Status Channel 8 */
      vuint32_t HRS7:1;                /* Hardware Request Status Channel 7 */
      vuint32_t HRS6:1;                /* Hardware Request Status Channel 6 */
      vuint32_t HRS5:1;                /* Hardware Request Status Channel 5 */
      vuint32_t HRS4:1;                /* Hardware Request Status Channel 4 */
      vuint32_t HRS3:1;                /* Hardware Request Status Channel 3 */
      vuint32_t HRS2:1;                /* Hardware Request Status Channel 2 */
      vuint32_t HRS1:1;                /* Hardware Request Status Channel 1 */
      vuint32_t HRS0:1;                /* Hardware Request Status Channel 0 */
    } B;
  } HRSL;

  uint8_t DMA_reserved0[200];
  union {                              /* Channel n Priority Register */
    vuint8_t R;
    struct {
      vuint8_t ECP:1;                  /* Enable Channel Preemption. */
      vuint8_t DPA:1;                  /* Disable Preempt Ability. */
      vuint8_t GRPPRI:2;               /* Channel n Current Group Priority */
      vuint8_t CHPRI:4;                /* Channel n Arbitration Priority */
    } B;
  } DCHPRI[64];

  union {                              /* Channel n Master ID Register */
    vuint8_t R;
    struct {
      vuint8_t EMI:1;                  /* Enable Master ID replication. */
      vuint8_t PAL:1;                  /* Privileged Access Level. */
      vuint8_t  :2;
      vuint8_t MID:4;                  /* Master ID. */
    } B;
  } DCHMID[64];

  uint8_t DMA_reserved1[3712];
  struct {
    union {                            /* TCD Source Address */
      vuint32_t R;
      struct {
        vuint32_t SADDR:32;            /* Source Address. */
      } B;
    } WORD_0;
    union {                            /* TCD Transfer Attributes */
      vuint32_t R;
      struct {
        vuint32_t SMOD:5;              /* Source Address Modulo. */
        vuint32_t SSIZE:3;             /* Source data transfer size. */
        vuint32_t DMOD:5;              /* Destination Address Modulo. */
        vuint32_t DSIZE:3;             /* Destination data transfer size */
        vuint32_t SOFF:16;             /* Source address signed offset. */
      } B;
    } WORD_1;
    union {                            /* TCD Number of bytes to be transferred */
      vuint32_t R;
      struct {
        vuint32_t NBYTES:32;           /* Inner "Minor" Byte Transfer Count */
      } B;
    } WORD_2;
    union {                            /* TCD Last Source Address Adjustment */
      vuint32_t R;
      struct {
        vuint32_t SLAST:32;            /* Last Source Address Adjustment */
      } B;
    } WORD_3;
    union {                            /* TCD Destination Address */
      vuint32_t R;
      struct {
        vuint32_t DADDR:32;            /* Destination Address. */
      } B;
    } WORD_4;
    union {                            /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
      vuint32_t R;
      struct {
        vuint32_t CITER_E_LINK:1;      /* Enable channel-to-channel linking on minor-loop complete. */
        vuint32_t LINKCH_CITER:6;      /* Current "major" iteration count or Link channel number. */
        vuint32_t CITER:9;             /* Current Major Iteration Count */
        vuint32_t DOFF:16;             /* Destination address signed offset. */
      } B;
    } WORD_5;
    union {                            /* TCD Last Destination Address Adjustment/Scatter Gather Address */
      vuint32_t R;
      struct {
        vuint32_t DLAST_SGA:32;        /* Last destination address adjustment or the memory address for the next transfer control descriptor to be loaded into this channel (scatter/gather). */
      } B;
    } WORD_6;
    union {                            /* TCD Control and Status */
      vuint32_t R;
      struct {
        vuint32_t BITER_E_LINK:1;      /* Enable channel-to-channel linking on minor loop complete. */
        vuint32_t BITER_BITER_LINKCH:6; /* "Beginning major iteration count" or "Beginning Link channel number". */
        vuint32_t BITER:9;             /* Beginning "major" iteration count. */
        vuint32_t BWC:2;               /* Bandwidth Control. */
        vuint32_t MAJOR_LINKCH:6;      /* Link Channel Number. */
        vuint32_t DONE:1;              /* Channel Done. */
        vuint32_t ACTIVE:1;            /* Channel Active. */
        vuint32_t MAJOR_E_LINK:1;      /* Enable channel-to-channel linking on major loop complete. */
        vuint32_t E_SG:1;              /* Enable Scatter/Cather Processing. */
        vuint32_t DREQ:1;              /* Disable Request. */
        vuint32_t INT_HALF:1;          /* Enable an interrupt when major counter is half complete. */
        vuint32_t INT_MAJOR:1;         /* Enable an interrupt when major iteration count completes. */
        vuint32_t START:1;             /* Channel Start. */
      } B;
    } WORD_7;
  } TCD[64];
};


/* ============================================================================
   =============================== Module: DSPI ===============================
   ============================================================================ */

struct DSPI_tag {
  union {                              /* Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t MSTR:1;                /* Master/Slave Mode Select */
      vuint32_t CONT_SCKE:1;           /* Continuous SCK Enable */
      vuint32_t DCONF:2;               /* DSPI Configuration */
      vuint32_t FRZ:1;                 /* Freeze */
      vuint32_t MTFE:1;                /* Modified Timing Format Enable */
      vuint32_t PCSSE:1;               /* Peripheral Chip Select Strobe Enable */
      vuint32_t ROOE:1;                /* Receive FIFO Overflow Overwrite Enable */
      vuint32_t  :2;
      vuint32_t PCSIS:6;               /* Peripheral Chip Select x Inactive State */
      vuint32_t  :1;
      vuint32_t MDIS:1;                /* Module Disable */
      vuint32_t DIS_TXF:1;             /* Disable Transmit FIFO */
      vuint32_t DIS_RXF:1;             /* Disable Receive FIFO */
      vuint32_t CLR_TXF:1;             /* Clear TX FIFO */
      vuint32_t CLR_RXF:1;
      vuint32_t SMPL_PT:2;             /* Sample Point */
      vuint32_t  :4;
      vuint32_t XSPI:1;                /* Extended SPI Mode */
      vuint32_t FCPCS:1;               /* Fast Continuous PCS Mode. */
      vuint32_t PES:1;                 /* Parity Error Stop */
      vuint32_t HALT:1;                /* Halt */
    } B;
  } MCR;

  uint8_t DSPI_reserved0[4];
  union {                              /* Transfer Count Register */
    vuint32_t R;
    struct {
      vuint32_t SPI_TCNT:16;           /* SPI Transfer Counter */
      vuint32_t  :16;
    } B;
  } TCR;

  union {
    union {                            /* Clock and Transfer Attributes Register (In Master Mode) */
      vuint32_t R;
      struct {
        vuint32_t DBR:1;               /* Double Baud Rate */
        vuint32_t FMSZ:4;              /* Frame Size */
        vuint32_t CPOL:1;              /* Clock Polarity */
        vuint32_t CPHA:1;              /* Clock Phase */
        vuint32_t LSBFE:1;             /* LSB First */
        vuint32_t PCSSCK:2;            /* PCS to SCK Delay Prescaler */
        vuint32_t PASC:2;              /* After SCK Delay Prescaler */
        vuint32_t PDT:2;               /* Delay after Transfer Prescaler */
        vuint32_t PBR:2;               /* Baud Rate Prescaler */
        vuint32_t CSSCK:4;             /* PCS to SCK Delay Scaler */
        vuint32_t ASC:4;               /* After SCK Delay Scaler */
        vuint32_t DT:4;                /* Delay After Transfer Scaler */
        vuint32_t BR:4;                /* Baud Rate Scaler */
      } B;
    } CTAR[6];
    union {                            /* Clock and Transfer Attributes Register (In Slave Mode) */
      vuint32_t R;
      struct {
        vuint32_t FMSZ:5;              /* Frame Size */
        vuint32_t CPOL:1;              /* Clock Polarity */
        vuint32_t CPHA:1;              /* Clock Phase */
        vuint32_t PE:1;                /* Parity Enable */
        vuint32_t PP:1;                /* Parity Polarity */
        vuint32_t FMSZ5:1;             /* MSB of Frame Size when DSI is used in 64-bit Mode */
        vuint32_t  :22;
      } B;
    } CTAR_SLAVE[2];
  } MODE;

  union {                              /* Clock and Transfer Attributes Register (In Master Mode) */
    vuint32_t R;
    struct {
      vuint32_t DBR:1;                 /* Double Baud Rate */
      vuint32_t FMSZ:4;                /* Frame Size */
      vuint32_t CPOL:1;                /* Clock Polarity */
      vuint32_t CPHA:1;                /* Clock Phase */
      vuint32_t LSBFE:1;               /* LSB First */
      vuint32_t PCSSCK:2;              /* PCS to SCK Delay Prescaler */
      vuint32_t PASC:2;                /* After SCK Delay Prescaler */
      vuint32_t PDT:2;                 /* Delay after Transfer Prescaler */
      vuint32_t PBR:2;                 /* Baud Rate Prescaler */
      vuint32_t CSSCK:4;               /* PCS to SCK Delay Scaler */
      vuint32_t ASC:4;                 /* After SCK Delay Scaler */
      vuint32_t DT:4;                  /* Delay After Transfer Scaler */
      vuint32_t BR:4;                  /* Baud Rate Scaler */
    } B;
  } CTAR[2];

  union {                              /* Status Register */
    vuint32_t R;
    struct {
      vuint32_t TCF:1;                 /* Transfer Complete Flag */
      vuint32_t TXRXS:1;               /* TX and RX Status */
      vuint32_t SPITCF:1;              /* SPI Frame Transfer Complete Flag. */
      vuint32_t EOQF:1;                /* End of Queue Flag */
      vuint32_t TFUF:1;                /* Transmit FIFO Underflow Flag */
      vuint32_t DSITCF:1;              /* DSI Frame Transfer Complete Flag. */
      vuint32_t TFFF:1;                /* Transmit FIFO Fill Flag */
      vuint32_t BSYF:1;                /* Busy Flag. */
      vuint32_t CMDTCF:1;              /* Command Transfer Complete Flag. */
      vuint32_t DPEF:1;                /* DSI Parity Error Flag */
      vuint32_t SPEF:1;                /* SPI Parity Error Flag */
      vuint32_t DDIF:1;                /* DSI Data Received with Active Bits */
      vuint32_t RFOF:1;                /* Receive FIFO Overflow Flag */
      vuint32_t TFIWF:1;               /* Tranmit FIFO Invalid Write Flag */
      vuint32_t RFDF:1;                /* Receive FIFO Drain Flag */
      vuint32_t CMDFFF:1;              /* Command FIFO Fill Flag */
      vuint32_t TXCTR:4;               /* TX FIFO Counter */
      vuint32_t TXNXTPTR:4;            /* Transmit Next Pointer */
      vuint32_t RXCTR:4;               /* RX FIFO Counter */
      vuint32_t POPNXTPTR:4;           /* Pop Next Pointer */
    } B;
  } SR;

  union {                              /* DMA/Interrupt Request Select and Enable Register */
    vuint32_t R;
    struct {
      vuint32_t TCF_RE:1;              /* Transmission Complete Request Enable */
      vuint32_t CMDFFF_RE:1;           /* Command FIFO Fill Flag Request Enable. */
      vuint32_t SPITCF_RE:1;           /* SPI Frame Transmission Complete Request Enable. */
      vuint32_t EOQF_RE:1;             /* Finished Request Enable */
      vuint32_t TFUF_RE:1;             /* Transmit FIFO Underflow Request Enable */
      vuint32_t DSITCF_RE:1;           /* DSI Frame Transmission Complete Request Enable. */
      vuint32_t TFFF_RE:1;             /* Transmit FIFO Fill Request Enable */
      vuint32_t TFFF_DIRS:1;           /* Transmit FIFO Fill DMA or Interrupt Request Select */
      vuint32_t CMDTCF_RE:1;           /* Command Transmission Complete Request Enable. */
      vuint32_t DPEF_RE:1;             /* DSI Parity Error Request Enable */
      vuint32_t SPEF_RE:1;             /* SPI Parity Error Request Enable */
      vuint32_t DDIF_RE:1;             /* DSI data received with active bits Request Enable */
      vuint32_t RFOF_RE:1;             /* Receive FIFO Overflow Request Enable */
      vuint32_t TFIWF_RE:1;            /* Transmit FIFO Invalid Write Request Enable. */
      vuint32_t RFDF_RE:1;             /* Receive FIFO Drain Request Enable */
      vuint32_t RFDF_DIRS:1;           /* Receive FIFO Drain DMA or Interrupt Request Select */
      vuint32_t CMDFFF_DIRS:1;         /* Command FIFO Fill DMA or Interrupt Request Select */
      vuint32_t DDIF_DIRS:1;           /* DSI data received with active bits - DMA or Interrupt Request Select. */
      vuint32_t  :14;
    } B;
  } RSER;

  union {
    union {                            /* PUSH TX FIFO Register In Master Mode */
      vuint32_t R;
      struct {
        vuint32_t CONT:1;              /* Continuous Peripheral Chip Select Enable */
        vuint32_t CTAS:3;              /* Clock and Transfer Attributes Select */
        vuint32_t EOQ:1;               /* End Of Queue */
        vuint32_t CTCNT:1;             /* Clear Transfer Counter */
        vuint32_t PE_MASC:1;           /* Parity Enable or Mask T ASC delay in the current frame */
        vuint32_t PP_MCSC:1;           /* Parity Polarity or Mask T CSC delay in the next frame */
        vuint32_t  :2;
        vuint32_t PCS:6;
        vuint32_t TXDATA:16;           /* Transmit Data */
      } B;
    } PUSHR;
    union {                            /* PUSH TX FIFO Register In Slave Mode */
      vuint32_t R;
      struct {
        vuint32_t  :16;
        vuint32_t TXDATA:16;           /* Transmit Data */
      } B;
    } PUSHR_SLAVE;
  } PUSHR;

  union {                              /* POP RX FIFO Register */
    vuint32_t R;
    struct {
      vuint32_t RXDATA:32;             /* Received Data */
    } B;
  } POPR;

  union {                              /* Transmit FIFO Registers */
    vuint32_t R;
    struct {
      vuint32_t TXCMD_TXDATA:16;       /* Transmit Command or Transmit Data */
      vuint32_t TXDATA:16;             /* Transmit Data */
    } B;
  } TXFR[4];

  uint8_t DSPI_reserved1[48];
  union {                              /* Receive FIFO Registers */
    vuint32_t R;
    struct {
      vuint32_t RXDATA:32;             /* Receive Data */
    } B;
  } RXFR[4];

  uint8_t DSPI_reserved2[48];
  union {                              /* DSI Configuration Register 0 */
    vuint32_t R;
    struct {
      vuint32_t MTOE:1;                /* Multiple Transfer Operation Enable */
      vuint32_t FMSZ4:1;               /* MSB of the frame size in master mode. */
      vuint32_t MTOCNT:6;              /* Multiple Transfer Operation Count */
      vuint32_t FMSZ5:1;               /* MSB of the frame size in master mode when DSI is used in 64-bit mode. */
      vuint32_t  :1;
      vuint32_t ITSB:1;                /* Interleaved TSB mode. */
      vuint32_t TSBC:1;                /* Timed Serial Bus Configuration. */
      vuint32_t TXSS:1;                /* Transmit Data Source Select. */
      vuint32_t  :2;
      vuint32_t CID:1;                 /* Change In Data Transfer Enable */
      vuint32_t DCONT:1;               /* DSI Continuous Peripheral Chip Select Enable */
      vuint32_t DSICTAS:3;             /* DSI Clock and Transfer Attributes Select */
      vuint32_t DMS:1;                 /* Data Match Stop */
      vuint32_t PES:1;                 /* Parity Error Stop */
      vuint32_t PE:1;                  /* Parity Enable */
      vuint32_t PP:1;                  /* Parity Polarity */
      vuint32_t DPCSx:8;               /* DSI Peripheral Chip Select 0-7 */
    } B;
  } DSICR0;

  union {                              /* DSI Serialization Data Register 0 */
    vuint32_t R;
    struct {
      vuint32_t SER_DATA:32;           /* Serialized Data */
    } B;
  } SDR0;

  union {                              /* DSI Alternate Serialization Data Register 0 */
    vuint32_t R;
    struct {
      vuint32_t ASER_DATA:32;          /* Alternate Serialized Data */
    } B;
  } ASDR0;

  union {                              /* DSI Transmit Comparison Register 0 */
    vuint32_t R;
    struct {
      vuint32_t COMP_DATA:32;          /* Compare Data */
    } B;
  } COMPR0;

  uint8_t DSPI_reserved3[4];
  union {                              /* DSI Configuration Register 1 */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t TSBCNT:6;              /* Timed Serial Bus Operation Count */
      vuint32_t  :3;
      vuint32_t CSI_PRTY:1;            /* CSI Priority */
      vuint32_t CSE:1;                 /* Command Select Enable */
      vuint32_t DSI64E:1;              /* DSI 64-bit Mode Enable */
      vuint32_t DSE1:1;                /* Data Select Enable 1 */
      vuint32_t DSE0:1;                /* Data Select Enable 0 */
      vuint32_t  :8;
      vuint32_t DPCS1_x:8;             /* DSI Peripheral Chip Select 0-7 */
    } B;
  } DSICR1;

  union {                              /* DSI Serialization Source Select Register 0 */
    vuint32_t R;
    struct {
      vuint32_t SS:32;                 /* Source Select */
    } B;
  } SSR0;

  uint8_t DSPI_reserved4[24];
  union {                              /* DSI Serialization Data Register 1 */
    vuint32_t R;
    struct {
      vuint32_t SER_DATA:32;           /* Serialized Data */
    } B;
  } SDR1;

  union {                              /* DSI Alternate Serialization Data Register 1 */
    vuint32_t R;
    struct {
      vuint32_t ASER_DATA:32;          /* Alternate Serialized Data */
    } B;
  } ASDR1;

  union {                              /* DSI Transmit Comparison Register 1 */
    vuint32_t R;
    struct {
      vuint32_t COMP_DATA:32;          /* Compare Data */
    } B;
  } COMPR1;

  union {                              /* DSI Deserialization Data Register 1 */
    vuint32_t R;
    struct {
      vuint32_t DESER_DATA:32;         /* Deserialized Data */
    } B;
  } DDR1;

  union {                              /* DSI Serialization Source Select Register 1 */
    vuint32_t R;
    struct {
      vuint32_t SS:32;                 /* Source Select */
    } B;
  } SSR1;

  uint8_t DSPI_reserved5[16];
  union {                              /* DSI Deserialized Data Interrupt Mask Register 1 */
    vuint32_t R;
    struct {
      vuint32_t MASK:32;               /* Mask */
    } B;
  } DIMR1;

  union {                              /* DSI Deserialized Data Polarity Interrupt Register 1 */
    vuint32_t R;
    struct {
      vuint32_t DP:32;                 /* Data Polarity */
    } B;
  } DPIR1;

  union {                              /* Clock and Transfer Attributes Register Extended */
    vuint32_t R;
    struct {
      vuint32_t  :15;
      vuint32_t FMSZE:1;               /* Frame Size Extended */
      vuint32_t  :5;
      vuint32_t DTCP:11;               /* Data Transfer Count Preload */
    } B;
  } CTARE[8];

  union {                              /* Status Register Extended */
    vuint32_t R;
    struct {
      vuint32_t  :17;
      vuint32_t RXCTR4:1;              /* RX FIFO Counter[4] */
      vuint32_t  :2;
      vuint32_t TXCTR4:1;              /* TX FIFO Counter[4] */
      vuint32_t  :2;
      vuint32_t CMDCTR:5;              /* CMD FIFO Counter */
      vuint32_t CMDNXTPTR:4;           /* Command Next Pointer */
    } B;
  } SREX;

  union {                              /* Trigger Register */
    vuint32_t R;
    struct {
      vuint32_t ENABLE:1;              /* Trigger Register Enable */
      vuint32_t  :27;
      vuint32_t  :1;
      vuint32_t ASDR_WT:1;             /* ASDR Write Trigger Enable */
      vuint32_t CID:1;                 /* Change In Data Transfer Enable */
      vuint32_t  :1;
    } B;
  } TRIG;

  uint8_t DSPI_reserved6[12];
  union {                              /* Time Slot Length Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t TS3_LEN:7;             /* Time Slot 3 Length */
      vuint32_t  :1;
      vuint32_t TS2_LEN:7;             /* Time Slot 2 Length */
      vuint32_t  :1;
      vuint32_t TS1_LEN:7;             /* Time Slot 1 Length */
      vuint32_t  :1;
      vuint32_t TS0_LEN:7;             /* Time Slot 0 Length */
    } B;
  } TSL;

  union {                              /* Time Slot Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t TS3:4;                 /* Time Slot 3 */
      vuint32_t TS2:4;                 /* Time Slot 2 */
      vuint32_t TS1:4;                 /* Time Slot 1 */
      vuint32_t TS0:4;                 /* Time Slot 0 */
    } B;
  } TS_CONF;
};


/* ============================================================================
   =============================== Module: DTS ================================
   ============================================================================ */

struct DTS_tag {
  union {                              /* Output Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t DTS_EN_B:1;
      vuint32_t DTS_EN:1;
    } B;
  } ENABLE;

  union {                              /* Startup Register */
    vuint32_t R;
    struct {
      vuint32_t AD:32;
    } B;
  } STARTUP;

  union {                              /* Semaphore Register */
    vuint32_t R;
    struct {
      vuint32_t ST:32;
    } B;
  } SEMAPHORE;

  union {                              /* Semaphore Extension */
    vuint32_t R;
    struct {
      vuint32_t ST_B:32;
    } B;
  } SEMAPHORE_B;
};


/* ============================================================================
   =============================== Module: FCCU ===============================
   ============================================================================ */

struct FCCU_tag {
  union {                              /* Control Register */
    vuint32_t R;
    struct {
      vuint32_t FILTER_BYPASS:1;
      vuint32_t FILTER_WIDTH:2;
      vuint32_t  :19;
      vuint32_t DEBUG:1;
      vuint32_t NVML:1;
      vuint32_t OPS:2;
      vuint32_t  :1;
      vuint32_t OPR:5;
    } B;
  } CTRL;

  union {                              /* CTRL Key Register */
    vuint32_t R;
    struct {
      vuint32_t CTRLK:32;
    } B;
  } CTRLK;

  union {                              /* Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t FCCU_SET_AFTER_RESET:1;
      vuint32_t FCCU_SET_CLEAR:2;
      vuint32_t  :2;
      vuint32_t  :4;
      vuint32_t  :1;
      vuint32_t  :2;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t SM:1;
      vuint32_t PS:1;
      vuint32_t FOM:3;
      vuint32_t  :6;
    } B;
  } CFG;

  uint8_t FCCU_reserved0[16];
  union {                              /* NCF Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t NCFC31:1;
      vuint32_t NCFC30:1;
      vuint32_t NCFC29:1;
      vuint32_t NCFC28:1;
      vuint32_t NCFC27:1;
      vuint32_t NCFC26:1;
      vuint32_t NCFC25:1;
      vuint32_t NCFC24:1;
      vuint32_t NCFC23:1;
      vuint32_t NCFC22:1;
      vuint32_t NCFC21:1;
      vuint32_t NCFC20:1;
      vuint32_t NCFC19:1;
      vuint32_t NCFC18:1;
      vuint32_t NCFC17:1;
      vuint32_t NCFC16:1;
      vuint32_t NCFC15:1;
      vuint32_t NCFC14:1;
      vuint32_t NCFC13:1;
      vuint32_t NCFC12:1;
      vuint32_t NCFC11:1;
      vuint32_t NCFC10:1;
      vuint32_t NCFC9:1;
      vuint32_t NCFC8:1;
      vuint32_t NCFC7:1;
      vuint32_t NCFC6:1;
      vuint32_t NCFC5:1;
      vuint32_t NCFC4:1;
      vuint32_t NCFC3:1;
      vuint32_t NCFC2:1;
      vuint32_t NCFC1:1;
      vuint32_t NCFC0:1;
    } B;
  } NCF_CFG[3];

  uint8_t FCCU_reserved1[36];
  union {                              /* NCFS Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t NCFSC31:1;
      vuint32_t NCFSC30:1;
      vuint32_t NCFSC29:1;
      vuint32_t NCFSC28:1;
      vuint32_t NCFSC27:1;
      vuint32_t NCFSC26:1;
      vuint32_t NCFSC25:1;
      vuint32_t NCFSC24:1;
      vuint32_t NCFSC23:1;
      vuint32_t NCFSC22:1;
      vuint32_t NCFSC21:1;
      vuint32_t NCFSC20:1;
      vuint32_t NCFSC19:1;
      vuint32_t NCFSC18:1;
      vuint32_t NCFSC17:1;
      vuint32_t NCFSC16:1;
      vuint32_t NCFSC15:1;
      vuint32_t NCFSC14:1;
      vuint32_t NCFSC13:1;
      vuint32_t NCFSC12:1;
      vuint32_t NCFSC11:1;
      vuint32_t NCFSC10:1;
      vuint32_t NCFSC9:1;
      vuint32_t NCFSC8:1;
      vuint32_t NCFSC7:1;
      vuint32_t NCFSC6:1;
      vuint32_t NCFSC5:1;
      vuint32_t NCFSC4:1;
      vuint32_t NCFSC3:1;
      vuint32_t NCFSC2:1;
      vuint32_t NCFSC1:1;
      vuint32_t NCFSC0:1;
    } B;
  } NCFS_CFG[6];

  uint8_t FCCU_reserved2[28];
  union {                              /* NCF Status Register */
    vuint32_t R;
    struct {
      vuint32_t NCFS31:1;
      vuint32_t NCFS30:1;
      vuint32_t NCFS29:1;
      vuint32_t NCFS28:1;
      vuint32_t NCFS27:1;
      vuint32_t NCFS26:1;
      vuint32_t NCFS25:1;
      vuint32_t NCFS24:1;
      vuint32_t NCFS23:1;
      vuint32_t NCFS22:1;
      vuint32_t NCFS21:1;
      vuint32_t NCFS20:1;
      vuint32_t NCFS19:1;
      vuint32_t NCFS18:1;
      vuint32_t NCFS17:1;
      vuint32_t NCFS16:1;
      vuint32_t NCFS15:1;
      vuint32_t NCFS14:1;
      vuint32_t NCFS13:1;
      vuint32_t NCFS12:1;
      vuint32_t NCFS11:1;
      vuint32_t NCFS10:1;
      vuint32_t NCFS9:1;
      vuint32_t NCFS8:1;
      vuint32_t NCFS7:1;
      vuint32_t NCFS6:1;
      vuint32_t NCFS5:1;
      vuint32_t NCFS4:1;
      vuint32_t NCFS3:1;
      vuint32_t NCFS2:1;
      vuint32_t NCFS1:1;
      vuint32_t NCFS0:1;
    } B;
  } NCF_S[3];

  uint8_t FCCU_reserved3[4];
  union {                              /* NCF Key Register */
    vuint32_t R;
    struct {
      vuint32_t NCFK:32;
    } B;
  } NCFK;

  union {                              /* NCF Enable Register */
    vuint32_t R;
    struct {
      vuint32_t NCFE31:1;
      vuint32_t NCFE30:1;
      vuint32_t NCFE29:1;
      vuint32_t NCFE28:1;
      vuint32_t NCFE27:1;
      vuint32_t NCFE26:1;
      vuint32_t NCFE25:1;
      vuint32_t NCFE24:1;
      vuint32_t NCFE23:1;
      vuint32_t NCFE22:1;
      vuint32_t NCFE21:1;
      vuint32_t NCFE20:1;
      vuint32_t NCFE19:1;
      vuint32_t NCFE18:1;
      vuint32_t NCFE17:1;
      vuint32_t NCFE16:1;
      vuint32_t NCFE15:1;
      vuint32_t NCFE14:1;
      vuint32_t NCFE13:1;
      vuint32_t NCFE12:1;
      vuint32_t NCFE11:1;
      vuint32_t NCFE10:1;
      vuint32_t NCFE9:1;
      vuint32_t NCFE8:1;
      vuint32_t NCFE7:1;
      vuint32_t NCFE6:1;
      vuint32_t NCFE5:1;
      vuint32_t NCFE4:1;
      vuint32_t NCFE3:1;
      vuint32_t NCFE2:1;
      vuint32_t NCFE1:1;
      vuint32_t NCFE0:1;
    } B;
  } NCF_E[3];

  uint8_t FCCU_reserved4[4];
  union {                              /* NCF Time-out Enable Register */
    vuint32_t R;
    struct {
      vuint32_t NCFTOE31:1;
      vuint32_t NCFTOE30:1;
      vuint32_t NCFTOE29:1;
      vuint32_t NCFTOE28:1;
      vuint32_t NCFTOE27:1;
      vuint32_t NCFTOE26:1;
      vuint32_t NCFTOE25:1;
      vuint32_t NCFTOE24:1;
      vuint32_t NCFTOE23:1;
      vuint32_t NCFTOE22:1;
      vuint32_t NCFTOE21:1;
      vuint32_t NCFTOE20:1;
      vuint32_t NCFTOE19:1;
      vuint32_t NCFTOE18:1;
      vuint32_t NCFTOE17:1;
      vuint32_t NCFTOE16:1;
      vuint32_t NCFTOE15:1;
      vuint32_t NCFTOE14:1;
      vuint32_t NCFTOE13:1;
      vuint32_t NCFTOE12:1;
      vuint32_t NCFTOE11:1;
      vuint32_t NCFTOE10:1;
      vuint32_t NCFTOE9:1;
      vuint32_t NCFTOE8:1;
      vuint32_t NCFTOE7:1;
      vuint32_t NCFTOE6:1;
      vuint32_t NCFTOE5:1;
      vuint32_t NCFTOE4:1;
      vuint32_t NCFTOE3:1;
      vuint32_t NCFTOE2:1;
      vuint32_t NCFTOE1:1;
      vuint32_t NCFTOE0:1;
    } B;
  } NCF_TOE[3];

  uint8_t FCCU_reserved5[4];
  union {                              /* NCF Time-out Register */
    vuint32_t R;
    struct {
      vuint32_t TO:32;
    } B;
  } NCF_TO;

  union {                              /* CFG Timeout Register */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t TO:3;
    } B;
  } CFG_TO;

  union {                              /* IO Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t EIN1:1;
      vuint32_t EIN0:1;
      vuint32_t  :2;
      vuint32_t EOUT1:1;
      vuint32_t EOUT0:1;
    } B;
  } EINOUT;

  union {                              /* Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t PhysicErrorPin:2;
      vuint32_t ESTAT:1;
      vuint32_t STATUS:3;
    } B;
  } STAT;

  union {                              /* NA Freeze Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t NAFS:8;
    } B;
  } N2AF_STATUS;

  union {                              /* AF Freeze Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :22;
      vuint32_t AF_SRC:2;
      vuint32_t AFFS:8;
    } B;
  } A2FF_STATUS;

  union {                              /* NF Freeze Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :22;
      vuint32_t NF_SRC:2;
      vuint32_t NFFS:8;
    } B;
  } N2FF_STATUS;

  union {                              /* FA Freeze Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :23;
      vuint32_t FAFS:9;
    } B;
  } F2A_STATUS;

  uint8_t FCCU_reserved6[8];
  union {                              /* NCF Fake Register */
    vuint32_t R;
    struct {
      vuint32_t  :25;
      vuint32_t FNCFC:7;
    } B;
  } NCFF;

  union {                              /* IRQ Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :27;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t NMI_STAT:1;
      vuint32_t ALRM_STAT:1;
      vuint32_t CFG_TO_STAT:1;
    } B;
  } IRQ_STAT;

  union {                              /* IRQ Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :28;
      vuint32_t  :1;
      vuint32_t  :2;
      vuint32_t CFG_TO_IEN:1;
    } B;
  } IRQ_EN;

  union {                              /* XTMR Register */
    vuint32_t R;
    struct {
      vuint32_t XTMR:32;
    } B;
  } XTMR;

  union {                              /* MCS Register */
    vuint32_t R;
    struct {
      vuint32_t VL3:1;
      vuint32_t FS3:1;
      vuint32_t  :2;
      vuint32_t MCS3:4;
      vuint32_t VL2:1;
      vuint32_t FS2:1;
      vuint32_t  :2;
      vuint32_t MCS2:4;
      vuint32_t VL1:1;
      vuint32_t FS1:1;
      vuint32_t  :2;
      vuint32_t MCS1:4;
      vuint32_t VL0:1;
      vuint32_t FS0:1;
      vuint32_t  :2;
      vuint32_t MCS0:4;
    } B;
  } MCS;

  union {                              /* Transient Lock Register */
    vuint32_t R;
    struct {
      vuint32_t  :23;
      vuint32_t TRANSKEY:9;
    } B;
  } TRANS_LOCK;

  union {                              /* Permanent Lock Register */
    vuint32_t R;
    struct {
      vuint32_t  :23;
      vuint32_t PERMNTKEY:9;
    } B;
  } PERMNT_LOCK;

  union {                              /* Delta T Register */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t  :14;
      vuint32_t  :2;
      vuint32_t DELTA_T:14;
    } B;
  } DELTA_T;

  union {                              /* IRQ Alarm Enable Register */
    vuint32_t R;
    struct {
      vuint32_t IRQEN31:1;
      vuint32_t IRQEN30:1;
      vuint32_t IRQEN29:1;
      vuint32_t IRQEN28:1;
      vuint32_t IRQEN27:1;
      vuint32_t IRQEN26:1;
      vuint32_t IRQEN25:1;
      vuint32_t IRQEN24:1;
      vuint32_t IRQEN23:1;
      vuint32_t IRQEN22:1;
      vuint32_t IRQEN21:1;
      vuint32_t IRQEN20:1;
      vuint32_t IRQEN19:1;
      vuint32_t IRQEN18:1;
      vuint32_t IRQEN17:1;
      vuint32_t IRQEN16:1;
      vuint32_t IRQEN15:1;
      vuint32_t IRQEN14:1;
      vuint32_t IRQEN13:1;
      vuint32_t IRQEN12:1;
      vuint32_t IRQEN11:1;
      vuint32_t IRQEN10:1;
      vuint32_t IRQEN9:1;
      vuint32_t IRQEN8:1;
      vuint32_t IRQEN7:1;
      vuint32_t IRQEN6:1;
      vuint32_t IRQEN5:1;
      vuint32_t IRQEN4:1;
      vuint32_t IRQEN3:1;
      vuint32_t IRQEN2:1;
      vuint32_t IRQEN1:1;
      vuint32_t IRQEN0:1;
    } B;
  } IRQ_ALARM_EN[3];

  uint8_t FCCU_reserved7[4];
  union {                              /* NMI Enable Register */
    vuint32_t R;
    struct {
      vuint32_t NMIEN31:1;
      vuint32_t NMIEN30:1;
      vuint32_t NMIEN29:1;
      vuint32_t NMIEN28:1;
      vuint32_t NMIEN27:1;
      vuint32_t NMIEN26:1;
      vuint32_t NMIEN25:1;
      vuint32_t NMIEN24:1;
      vuint32_t NMIEN23:1;
      vuint32_t NMIEN22:1;
      vuint32_t NMIEN21:1;
      vuint32_t NMIEN20:1;
      vuint32_t NMIEN19:1;
      vuint32_t NMIEN18:1;
      vuint32_t NMIEN17:1;
      vuint32_t NMIEN16:1;
      vuint32_t NMIEN15:1;
      vuint32_t NMIEN14:1;
      vuint32_t NMIEN13:1;
      vuint32_t NMIEN12:1;
      vuint32_t NMIEN11:1;
      vuint32_t NMIEN10:1;
      vuint32_t NMIEN9:1;
      vuint32_t NMIEN8:1;
      vuint32_t NMIEN7:1;
      vuint32_t NMIEN6:1;
      vuint32_t NMIEN5:1;
      vuint32_t NMIEN4:1;
      vuint32_t NMIEN3:1;
      vuint32_t NMIEN2:1;
      vuint32_t NMIEN1:1;
      vuint32_t NMIEN0:1;
    } B;
  } NMI_EN[3];

  uint8_t FCCU_reserved8[4];
  union {                              /* EOUT Signaling Enable Register */
    vuint32_t R;
    struct {
      vuint32_t EOUTEN31:1;
      vuint32_t EOUTEN30:1;
      vuint32_t EOUTEN29:1;
      vuint32_t EOUTEN28:1;
      vuint32_t EOUTEN27:1;
      vuint32_t EOUTEN26:1;
      vuint32_t EOUTEN25:1;
      vuint32_t EOUTEN24:1;
      vuint32_t EOUTEN23:1;
      vuint32_t EOUTEN22:1;
      vuint32_t EOUTEN21:1;
      vuint32_t EOUTEN20:1;
      vuint32_t EOUTEN19:1;
      vuint32_t EOUTEN18:1;
      vuint32_t EOUTEN17:1;
      vuint32_t EOUTEN16:1;
      vuint32_t EOUTEN15:1;
      vuint32_t EOUTEN14:1;
      vuint32_t EOUTEN13:1;
      vuint32_t EOUTEN12:1;
      vuint32_t EOUTEN11:1;
      vuint32_t EOUTEN10:1;
      vuint32_t EOUTEN9:1;
      vuint32_t EOUTEN8:1;
      vuint32_t EOUTEN7:1;
      vuint32_t EOUTEN6:1;
      vuint32_t EOUTEN5:1;
      vuint32_t EOUTEN4:1;
      vuint32_t EOUTEN3:1;
      vuint32_t EOUTEN2:1;
      vuint32_t EOUTEN1:1;
      vuint32_t EOUTEN0:1;
    } B;
  } EOUT_SIG_EN[3];
};


/* ============================================================================
   =============================== Module: FEC ================================
   ============================================================================ */

struct FEC_tag {
  uint8_t FEC_reserved0[4];
  union {                              /* Interrupt Event Register */
    vuint32_t R;
    struct {
      vuint32_t HBERR:1;
      vuint32_t BABR:1;
      vuint32_t BABT:1;
      vuint32_t GRA:1;
      vuint32_t TXF:1;
      vuint32_t TXB:1;
      vuint32_t RXF:1;
      vuint32_t RXB:1;
      vuint32_t MII:1;
      vuint32_t EBERR:1;
      vuint32_t LC:1;
      vuint32_t RL:1;
      vuint32_t UN:1;
      vuint32_t  :19;
    } B;
  } EIR;

  union {                              /* Interrupt Mask Register */
    vuint32_t R;
    struct {
      vuint32_t HBERR:1;
      vuint32_t BABR:1;
      vuint32_t BABT:1;
      vuint32_t GRA:1;
      vuint32_t TXF:1;
      vuint32_t TXB:1;
      vuint32_t RXF:1;
      vuint32_t RXB:1;
      vuint32_t MII:1;
      vuint32_t EBERR:1;
      vuint32_t LC:1;
      vuint32_t RL:1;
      vuint32_t UN:1;
      vuint32_t  :19;
    } B;
  } EIMR;

  uint8_t FEC_reserved1[4];
  union {                              /* Receive Descriptor Active Register */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t RDAR:1;
      vuint32_t  :24;
    } B;
  } RDAR;

  union {                              /* Transmit Descriptor Active Register */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t TDAR:1;
      vuint32_t  :24;
    } B;
  } TDAR;

  uint8_t FEC_reserved2[12];
  union {                              /* Ethernet Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :23;
      vuint32_t  :1;
      vuint32_t ETHER_EN:1;
      vuint32_t RESET:1;
    } B;
  } ECR;

  uint8_t FEC_reserved3[24];
  union {                              /* MII Management Frame Register */
    vuint32_t R;
    struct {
      vuint32_t ST:2;
      vuint32_t OP:2;
      vuint32_t PA:5;
      vuint32_t RA:5;
      vuint32_t TA:2;
      vuint32_t DATA:16;
    } B;
  } MMFR;

  union {                              /* MII Speed Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t DIS_PRE:1;
      vuint32_t MII_SPEED:6;
      vuint32_t  :1;
    } B;
  } MSCR;

  uint8_t FEC_reserved4[28];
  union {                              /* MIB Control Register */
    vuint32_t R;
    struct {
      vuint32_t MIB_DIS:1;
      vuint32_t MIB_IDLE:1;
      vuint32_t  :30;
    } B;
  } MIBC;

  uint8_t FEC_reserved5[28];
  union {                              /* Receive Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :5;
      vuint32_t MAX_FL:11;
      vuint32_t  :4;
      vuint32_t RMII_ECHO:1;
      vuint32_t RMII_LOOP:1;
      vuint32_t RMII_10T:1;
      vuint32_t RMII_MODE:1;
      vuint32_t  :2;
      vuint32_t FCE:1;
      vuint32_t BC_REJ:1;
      vuint32_t PROM:1;
      vuint32_t MII_MODE:1;
      vuint32_t DRT:1;
      vuint32_t LOOP:1;
    } B;
  } RCR;

  uint8_t FEC_reserved6[60];
  union {                              /* Transmit Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :27;
      vuint32_t RFC_PAUSE:1;
      vuint32_t TFC_PAUSE:1;
      vuint32_t FDEN:1;
      vuint32_t HBC:1;
      vuint32_t GTS:1;
    } B;
  } TCR;

  uint8_t FEC_reserved7[28];
  union {                              /* Physical Address Low Register */
    vuint32_t R;
    struct {
      vuint32_t PADDR1:32;
    } B;
  } PALR;

  union {                              /* Physical Address High Register and Type Field */
    vuint32_t R;
    struct {
      vuint32_t PADDR2:16;
      vuint32_t TYPE:16;
    } B;
  } PAUR;

  union {                              /* Opcode/Pause Duration */
    vuint32_t R;
    struct {
      vuint32_t OPCODE:16;
      vuint32_t PAUSE_DUR:16;
    } B;
  } OPD;

  uint8_t FEC_reserved8[40];
  union {                              /* Descriptor Individual Upper Address Register */
    vuint32_t R;
    struct {
      vuint32_t IADDR1:32;
    } B;
  } IAUR;

  union {                              /* Descriptor Individual Lower Address Register */
    vuint32_t R;
    struct {
      vuint32_t IADDR2:32;
    } B;
  } IALR;

  union {                              /* Descriptor Group Upper Address Register */
    vuint32_t R;
    struct {
      vuint32_t GADDR1:32;
    } B;
  } GAUR;

  union {                              /* Descriptor Group Lower Address Register */
    vuint32_t R;
    struct {
      vuint32_t GADDR2:32;
    } B;
  } GALR;

  uint8_t FEC_reserved9[28];
  union {                              /* Transmit FIFO Watermark */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t TFWR:2;
    } B;
  } TFWR;

  uint8_t FEC_reserved10[4];
  union {                              /* FIFO Receive Bound Register */
    vuint32_t R;
    struct {
      vuint32_t  :21;
      vuint32_t  :1;
      vuint32_t R_BOUND:8;
      vuint32_t  :2;
    } B;
  } FRBR;

  union {                              /* FIFO Receive Start Register */
    vuint32_t R;
    struct {
      vuint32_t  :21;
      vuint32_t  :1;
      vuint32_t R_FSTART:8;
      vuint32_t  :2;
    } B;
  } FRSR;

  uint8_t FEC_reserved11[44];
  union {                              /* Receive Descriptor Ring Start Register */
    vuint32_t R;
    struct {
      vuint32_t R_DES_START:30;
      vuint32_t  :2;
    } B;
  } ERDSR;

  union {                              /* Transmit Buffer Descriptor Ring Start Register */
    vuint32_t R;
    struct {
      vuint32_t X_DES_START:30;
      vuint32_t  :2;
    } B;
  } ETDSR;

  union {                              /* Receive Buffer Size Register */
    vuint32_t R;
    struct {
      vuint32_t  :21;
      vuint32_t R_BUF_SIZE:7;
      vuint32_t  :4;
    } B;
  } EMRBR;

  uint8_t FEC_reserved12[116];
  union {                              /* Count of frames not counted correctly */
    vuint32_t R;
    struct {
      vuint32_t RMON_T_DROP:32;
    } B;
  } RMON_T_DROP;

  union {                              /* RMON Tx packet count */
    vuint32_t R;
    struct {
      vuint32_t RMON_T_PACKETS:32;
    } B;
  } RMON_T_PACKETS;

  union {                              /* RMON Tx broadcast packets */
    vuint32_t R;
    struct {
      vuint32_t RMON_T_BC_PKT:32;
    } B;
  } RMON_T_BC_PKT;

  union {                              /* RMON Tx multicast packets */
    vuint32_t R;
    struct {
      vuint32_t RMON_T_MC_PKT:32;
    } B;
  } RMON_T_MC_PKT;

  union {                              /* RMON Tx packets with CRC/align error */
    vuint32_t R;
    struct {
      vuint32_t RMON_T_CRC_ALIGN:32;
    } B;
  } RMON_T_CRC_ALIGN;

  union {                              /* RMON Tx packets < 64 bytes, good CRC */
    vuint32_t R;
    struct {
      vuint32_t RMON_T_UNDERSIZE:32;
    } B;
  } RMON_T_UNDERSIZE;

  union {                              /* RMON Tx packets > MAX_FL bytes, good CRC */
    vuint32_t R;
    struct {
      vuint32_t RMON_T_OVERSIZE:32;
    } B;
  } RMON_T_OVERSIZE;

  union {                              /* RMON Tx packets < 64 bytes, bad CRC */
    vuint32_t R;
    struct {
      vuint32_t RMON_T_FRAG:32;
    } B;
  } RMON_T_FRAG;

  union {                              /* RMON Tx packets > MAX_FL bytes, bad CRC */
    vuint32_t R;
    struct {
      vuint32_t RMON_T_JAB:32;
    } B;
  } RMON_T_JAB;

  union {                              /* RMON Tx collision count */
    vuint32_t R;
    struct {
      vuint32_t RMON_T_COL:32;
    } B;
  } RMON_T_COL;

  union {                              /* RMON Tx 64 byte packets */
    vuint32_t R;
    struct {
      vuint32_t RMON_T_P64:32;
    } B;
  } RMON_T_P64;

  union {                              /* RMON Tx 65 to 127 byte packets */
    vuint32_t R;
    struct {
      vuint32_t RMON_T_P65TO127:32;
    } B;
  } RMON_T_P65TO127;

  union {                              /* RMON Tx 128 to 255 byte packets */
    vuint32_t R;
    struct {
      vuint32_t RMON_T_P128TO255:32;
    } B;
  } RMON_T_P128TO255;

  union {                              /* RMON Tx 256 to 511 byte packets */
    vuint32_t R;
    struct {
      vuint32_t RMON_T_P256TO511:32;
    } B;
  } RMON_T_P256TO511;

  union {                              /* RMON Tx 512 to 1023 byte packets */
    vuint32_t R;
    struct {
      vuint32_t RMON_T_P512TO1023:32;
    } B;
  } RMON_T_P512TO1023;

  union {                              /* RMON Tx 1024 to 2047 byte packets */
    vuint32_t R;
    struct {
      vuint32_t RMON_T_P1024TO2047:32;
    } B;
  } RMON_T_P1024TO2047;

  union {                              /* RMON Tx packets with > 2048 bytes */
    vuint32_t R;
    struct {
      vuint32_t RMON_T_P_GTE2048:32;
    } B;
  } RMON_T_P_GTE2048;

  union {                              /* RMON Tx Octets */
    vuint32_t R;
    struct {
      vuint32_t RMON_T_OCTETS:32;
    } B;
  } RMON_T_OCTETS;

  union {                              /* Count of transmitted frames not counted correctly */
    vuint32_t R;
    struct {
      vuint32_t IEEE_T_DROP:32;
    } B;
  } IEEE_T_DROP;

  union {                              /* Frames transmitted OK */
    vuint32_t R;
    struct {
      vuint32_t IEEE_T_FRAME_OK:32;
    } B;
  } IEEE_T_FRAME_OK;

  union {                              /* Frames transmitted with single collision */
    vuint32_t R;
    struct {
      vuint32_t IEEE_T_1COL:32;
    } B;
  } IEEE_T_1COL;

  union {                              /* Frames transmitted with multiple collisions */
    vuint32_t R;
    struct {
      vuint32_t IEEE_T_MCOL:32;
    } B;
  } IEEE_T_MCOL;

  union {                              /* Frames transmitted after deferral delay */
    vuint32_t R;
    struct {
      vuint32_t IEEE_T_DEF:32;
    } B;
  } IEEE_T_DEF;

  union {                              /* Frames transmitted with late collision */
    vuint32_t R;
    struct {
      vuint32_t IEEE_T_LCOL:32;
    } B;
  } IEEE_T_LCOL;

  union {                              /* Frames transmitted with excessive collisions */
    vuint32_t R;
    struct {
      vuint32_t IEEE_T_EXCOL:32;
    } B;
  } IEEE_T_EXCOL;

  union {                              /* Frames transmitted with Tx FIFO underrun */
    vuint32_t R;
    struct {
      vuint32_t IEEE_T_MACERR:32;
    } B;
  } IEEE_T_MACERR;

  union {                              /* Frames transmitted with carrier sense error */
    vuint32_t R;
    struct {
      vuint32_t IEEE_T_CSERR:32;
    } B;
  } IEEE_T_CSERR;

  union {                              /* Frames transmitted with SQE error */
    vuint32_t R;
    struct {
      vuint32_t IEEE_T_SQE:32;
    } B;
  } IEEE_T_SQE;

  union {                              /* Flow control pause frames transmitted */
    vuint32_t R;
    struct {
      vuint32_t IEEE_T_FDXFC:32;
    } B;
  } IEEE_T_FDXFC;

  union {                              /* Octet count for frames transmitted without error */
    vuint32_t R;
    struct {
      vuint32_t IEEE_T_OCTETS_OK:32;
    } B;
  } IEEE_T_OCTETS_OK;

  uint8_t FEC_reserved13[8];
  union {                              /* Count of received frames not counted correctly */
    vuint32_t R;
    struct {
      vuint32_t RMON_R_DROP:32;
    } B;
  } RMON_R_DROP;

  union {                              /* RMON Rx packet count */
    vuint32_t R;
    struct {
      vuint32_t RMON_R_PACKETS:32;
    } B;
  } RMON_R_PACKETS;

  union {                              /* RMON Rx broadcast packets */
    vuint32_t R;
    struct {
      vuint32_t RMON_R_BC_PKT:32;
    } B;
  } RMON_R_BC_PKT;

  union {                              /* RMON Rx multicast packets */
    vuint32_t R;
    struct {
      vuint32_t RMON_R_MC_PKT:32;
    } B;
  } RMON_R_MC_PKT;

  union {                              /* RMON Rx packets with CRC/Align error */
    vuint32_t R;
    struct {
      vuint32_t RMON_R_CRC_ALIGN:32;
    } B;
  } RMON_R_CRC_ALIGN;

  union {                              /* RMON Rx packets < 64 bytes, good CRC */
    vuint32_t R;
    struct {
      vuint32_t RMON_R_UNDERSIZE:32;
    } B;
  } RMON_R_UNDERSIZE;

  union {                              /* RMON Rx packets > MAX_FL bytes, good CRC */
    vuint32_t R;
    struct {
      vuint32_t RMON_R_OVERSIZE:32;
    } B;
  } RMON_R_OVERSIZE;

  union {                              /* RMON Rx packets < 64 bytes, bad CRC */
    vuint32_t R;
    struct {
      vuint32_t RMON_R_FRAG:32;
    } B;
  } RMON_R_FRAG;

  union {                              /* RMON Rx packets > MAX_FL bytes, bad CRC */
    vuint32_t R;
    struct {
      vuint32_t RMON_R_JAB:32;
    } B;
  } RMON_R_JAB;

  union {                              /* Reserved */
    vuint32_t R;
    struct {
      vuint32_t RMON_R_RESVD_0:32;
    } B;
  } RMON_R_RESVD_0;

  union {                              /* RMON Rx 64 byte packets */
    vuint32_t R;
    struct {
      vuint32_t RMON_R_P64:32;
    } B;
  } RMON_R_P64;

  union {                              /* RMON Rx 65 to 127 byte packets */
    vuint32_t R;
    struct {
      vuint32_t RMON_R_P65TO127:32;
    } B;
  } RMON_R_P65TO127;

  union {                              /* RMON Rx 128 to 255 byte packets */
    vuint32_t R;
    struct {
      vuint32_t RMON_R_P128TO255:32;
    } B;
  } RMON_R_P128TO255;

  union {                              /* RMON Rx 256 to 511 byte packets */
    vuint32_t R;
    struct {
      vuint32_t RMON_R_P256TO511:32;
    } B;
  } RMON_R_P256TO511;

  union {                              /* RMON Rx 512 to 1023 byte packets */
    vuint32_t R;
    struct {
      vuint32_t RMON_R_P512TO1023:32;
    } B;
  } RMON_R_P512TO1023;

  union {                              /* RMON Rx 1024 to 2047 byte packets */
    vuint32_t R;
    struct {
      vuint32_t RMON_R_P1024TO2047:32;
    } B;
  } RMON_R_P1024TO2047;

  union {                              /* RMON Rx packets with > 2048 bytes */
    vuint32_t R;
    struct {
      vuint32_t RMON_R_P_GTE2048:32;
    } B;
  } RMON_R_P_GTE2048;

  union {                              /* RMON Rx octets */
    vuint32_t R;
    struct {
      vuint32_t RMON_R_OCTETS:32;
    } B;
  } RMON_R_OCTETS;

  union {                              /* Count of received frames not counted correctly */
    vuint32_t R;
    struct {
      vuint32_t IEEE_R_DROP:32;
    } B;
  } IEEE_R_DROP;

  union {                              /* Frames received OK */
    vuint32_t R;
    struct {
      vuint32_t IEEE_R_FRAME_OK:32;
    } B;
  } IEEE_R_FRAME_OK;

  union {                              /* Frames received with CRC error */
    vuint32_t R;
    struct {
      vuint32_t IEEE_R_CRC:32;
    } B;
  } IEEE_R_CRC;

  union {                              /* Frames received with alignment error */
    vuint32_t R;
    struct {
      vuint32_t IEEE_R_ALIGN:32;
    } B;
  } IEEE_R_ALIGN;

  union {                              /* Receive FIFO overflow count */
    vuint32_t R;
    struct {
      vuint32_t IEEE_R_MACERR:32;
    } B;
  } IEEE_R_MACERR;

  union {                              /* Flow control pause frames received */
    vuint32_t R;
    struct {
      vuint32_t IEEE_R_FDXFC:32;
    } B;
  } IEEE_R_FDXFC;

  union {                              /* Octet count for frames received without error */
    vuint32_t R;
    struct {
      vuint32_t IEEE_R_OCTETS_OK:32;
    } B;
  } IEEE_R_OCTETS_OK;
};


/* ============================================================================
   =============================== Module: IGF ================================
   ============================================================================ */

struct IGF_tag {
  union {                              /* Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t MDIS:1;                /* Module Disable */
      vuint32_t FRZ:1;                 /* Freeze bit for debug operation */
      vuint32_t FBP:1;                 /* Force Bypass */
      vuint32_t FOH:1;                 /* Force filter output high */
      vuint32_t FOL:1;                 /* Force filter output low */
      vuint32_t  :16;
      vuint32_t IMM:1;                 /* Immediate edge propagation control bit */
      vuint32_t PSSEL:1;               /* Prescaler selection bit */
      vuint32_t POL:1;                 /* Output polarity bit */
      vuint32_t FGEN:1;                /* Filter global enable */
      vuint32_t  :1;
      vuint32_t FFM:2;                 /* Falling edge filter type selection */
      vuint32_t  :1;
      vuint32_t RFM:2;                 /* Rising edge filter type selection */
    } B;
  } MCR;

  union {                              /* Module Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t WEDGE:1;               /* Filter is active waiting for an edge */
      vuint32_t FEDGE:1;               /* Filter is active processing an edge */
      vuint32_t RNDET:1;               /* Rise noise detected bit */
      vuint32_t FNDET:1;               /* Fall noise detected bit */
      vuint32_t FLI:1;                 /* Filter input */
      vuint32_t FLO:1;                 /* Filter output */
    } B;
  } MSR0;

  uint8_t IGF_reserved0[8];
  union {                              /* Prescaler Register */
    vuint32_t R;
    struct {
      vuint32_t  :23;
      vuint32_t FPRE:9;                /* Filter prescaler */
    } B;
  } PRESR0;

  uint8_t IGF_reserved1[8];
  union {                              /* Rising edge Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t RTH:24;                /* Rising edge threshold */
    } B;
  } RTHR0;

  union {                              /* Falling edge Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t FTH:24;                /* Falling edge threshold */
    } B;
  } FTHR0;

  uint8_t IGF_reserved2[28];
  union {                              /* Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t MDIS:1;                /* Module Disable */
      vuint32_t FRZ:1;                 /* Freeze bit for debug operation */
      vuint32_t FBP:1;                 /* Force Bypass */
      vuint32_t FOH:1;                 /* Force filter output high */
      vuint32_t FOL:1;                 /* Force filter output low */
      vuint32_t  :16;
      vuint32_t IMM:1;                 /* Immediate edge propagation control bit */
      vuint32_t PSSEL:1;               /* Prescaler selection bit */
      vuint32_t POL:1;                 /* Output polarity bit */
      vuint32_t FGEN:1;                /* Filter global enable */
      vuint32_t  :1;
      vuint32_t FFM:2;                 /* Falling edge filter type selection */
      vuint32_t  :1;
      vuint32_t RFM:2;                 /* Rising edge filter type selection */
    } B;
  } MCR1;

  union {                              /* Module Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t WEDGE:1;               /* Filter is active waiting for an edge */
      vuint32_t FEDGE:1;               /* Filter is active processing an edge */
      vuint32_t RNDET:1;               /* Rise noise detected bit */
      vuint32_t FNDET:1;               /* Fall noise detected bit */
      vuint32_t FLI:1;                 /* Filter input */
      vuint32_t FLO:1;                 /* Filter output */
    } B;
  } MSR1;

  uint8_t IGF_reserved3[20];
  union {                              /* Rising edge Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t RTH:24;                /* Rising edge threshold */
    } B;
  } RTHR1;

  union {                              /* Falling edge Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t FTH:24;                /* Falling edge threshold */
    } B;
  } FTHR1;

  uint8_t IGF_reserved4[28];
  union {                              /* Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t MDIS:1;                /* Module Disable */
      vuint32_t FRZ:1;                 /* Freeze bit for debug operation */
      vuint32_t FBP:1;                 /* Force Bypass */
      vuint32_t FOH:1;                 /* Force filter output high */
      vuint32_t FOL:1;                 /* Force filter output low */
      vuint32_t  :16;
      vuint32_t IMM:1;                 /* Immediate edge propagation control bit */
      vuint32_t PSSEL:1;               /* Prescaler selection bit */
      vuint32_t POL:1;                 /* Output polarity bit */
      vuint32_t FGEN:1;                /* Filter global enable */
      vuint32_t  :1;
      vuint32_t FFM:2;                 /* Falling edge filter type selection */
      vuint32_t  :1;
      vuint32_t RFM:2;                 /* Rising edge filter type selection */
    } B;
  } MCR2;

  union {                              /* Module Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t WEDGE:1;               /* Filter is active waiting for an edge */
      vuint32_t FEDGE:1;               /* Filter is active processing an edge */
      vuint32_t RNDET:1;               /* Rise noise detected bit */
      vuint32_t FNDET:1;               /* Fall noise detected bit */
      vuint32_t FLI:1;                 /* Filter input */
      vuint32_t FLO:1;                 /* Filter output */
    } B;
  } MSR2;

  uint8_t IGF_reserved5[20];
  union {                              /* Rising edge Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t RTH:24;                /* Rising edge threshold */
    } B;
  } RTHR2;

  union {                              /* Falling edge Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t FTH:24;                /* Falling edge threshold */
    } B;
  } FTHR2;

  uint8_t IGF_reserved6[28];
  union {                              /* Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t MDIS:1;                /* Module Disable */
      vuint32_t FRZ:1;                 /* Freeze bit for debug operation */
      vuint32_t FBP:1;                 /* Force Bypass */
      vuint32_t FOH:1;                 /* Force filter output high */
      vuint32_t FOL:1;                 /* Force filter output low */
      vuint32_t  :16;
      vuint32_t IMM:1;                 /* Immediate edge propagation control bit */
      vuint32_t PSSEL:1;               /* Prescaler selection bit */
      vuint32_t POL:1;                 /* Output polarity bit */
      vuint32_t FGEN:1;                /* Filter global enable */
      vuint32_t  :1;
      vuint32_t FFM:2;                 /* Falling edge filter type selection */
      vuint32_t  :1;
      vuint32_t RFM:2;                 /* Rising edge filter type selection */
    } B;
  } MCR3;

  union {                              /* Module Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t WEDGE:1;               /* Filter is active waiting for an edge */
      vuint32_t FEDGE:1;               /* Filter is active processing an edge */
      vuint32_t RNDET:1;               /* Rise noise detected bit */
      vuint32_t FNDET:1;               /* Fall noise detected bit */
      vuint32_t FLI:1;                 /* Filter input */
      vuint32_t FLO:1;                 /* Filter output */
    } B;
  } MSR3;

  uint8_t IGF_reserved7[20];
  union {                              /* Rising edge Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t RTH:24;                /* Rising edge threshold */
    } B;
  } RTHR3;

  union {                              /* Falling edge Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t FTH:24;                /* Falling edge threshold */
    } B;
  } FTHR3;

  uint8_t IGF_reserved8[28];
  union {                              /* Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t MDIS:1;                /* Module Disable */
      vuint32_t FRZ:1;                 /* Freeze bit for debug operation */
      vuint32_t FBP:1;                 /* Force Bypass */
      vuint32_t FOH:1;                 /* Force filter output high */
      vuint32_t FOL:1;                 /* Force filter output low */
      vuint32_t  :16;
      vuint32_t IMM:1;                 /* Immediate edge propagation control bit */
      vuint32_t PSSEL:1;               /* Prescaler selection bit */
      vuint32_t POL:1;                 /* Output polarity bit */
      vuint32_t FGEN:1;                /* Filter global enable */
      vuint32_t  :1;
      vuint32_t FFM:2;                 /* Falling edge filter type selection */
      vuint32_t  :1;
      vuint32_t RFM:2;                 /* Rising edge filter type selection */
    } B;
  } MCR4;

  union {                              /* Module Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t WEDGE:1;               /* Filter is active waiting for an edge */
      vuint32_t FEDGE:1;               /* Filter is active processing an edge */
      vuint32_t RNDET:1;               /* Rise noise detected bit */
      vuint32_t FNDET:1;               /* Fall noise detected bit */
      vuint32_t FLI:1;                 /* Filter input */
      vuint32_t FLO:1;                 /* Filter output */
    } B;
  } MSR4;

  uint8_t IGF_reserved9[20];
  union {                              /* Rising edge Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t RTH:24;                /* Rising edge threshold */
    } B;
  } RTHR4;

  union {                              /* Falling edge Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t FTH:24;                /* Falling edge threshold */
    } B;
  } FTHR4;

  uint8_t IGF_reserved10[28];
  union {                              /* Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t MDIS:1;                /* Module Disable */
      vuint32_t FRZ:1;                 /* Freeze bit for debug operation */
      vuint32_t FBP:1;                 /* Force Bypass */
      vuint32_t FOH:1;                 /* Force filter output high */
      vuint32_t FOL:1;                 /* Force filter output low */
      vuint32_t  :16;
      vuint32_t IMM:1;                 /* Immediate edge propagation control bit */
      vuint32_t PSSEL:1;               /* Prescaler selection bit */
      vuint32_t POL:1;                 /* Output polarity bit */
      vuint32_t FGEN:1;                /* Filter global enable */
      vuint32_t  :1;
      vuint32_t FFM:2;                 /* Falling edge filter type selection */
      vuint32_t  :1;
      vuint32_t RFM:2;                 /* Rising edge filter type selection */
    } B;
  } MCR5;

  union {                              /* Module Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t WEDGE:1;               /* Filter is active waiting for an edge */
      vuint32_t FEDGE:1;               /* Filter is active processing an edge */
      vuint32_t RNDET:1;               /* Rise noise detected bit */
      vuint32_t FNDET:1;               /* Fall noise detected bit */
      vuint32_t FLI:1;                 /* Filter input */
      vuint32_t FLO:1;                 /* Filter output */
    } B;
  } MSR5;

  uint8_t IGF_reserved11[20];
  union {                              /* Rising edge Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t RTH:24;                /* Rising edge threshold */
    } B;
  } RTHR5;

  union {                              /* Falling edge Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t FTH:24;                /* Falling edge threshold */
    } B;
  } FTHR5;

  uint8_t IGF_reserved12[28];
  union {                              /* Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t MDIS:1;                /* Module Disable */
      vuint32_t FRZ:1;                 /* Freeze bit for debug operation */
      vuint32_t FBP:1;                 /* Force Bypass */
      vuint32_t FOH:1;                 /* Force filter output high */
      vuint32_t FOL:1;                 /* Force filter output low */
      vuint32_t  :16;
      vuint32_t IMM:1;                 /* Immediate edge propagation control bit */
      vuint32_t PSSEL:1;               /* Prescaler selection bit */
      vuint32_t POL:1;                 /* Output polarity bit */
      vuint32_t FGEN:1;                /* Filter global enable */
      vuint32_t  :1;
      vuint32_t FFM:2;                 /* Falling edge filter type selection */
      vuint32_t  :1;
      vuint32_t RFM:2;                 /* Rising edge filter type selection */
    } B;
  } MCR6;

  union {                              /* Module Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t WEDGE:1;               /* Filter is active waiting for an edge */
      vuint32_t FEDGE:1;               /* Filter is active processing an edge */
      vuint32_t RNDET:1;               /* Rise noise detected bit */
      vuint32_t FNDET:1;               /* Fall noise detected bit */
      vuint32_t FLI:1;                 /* Filter input */
      vuint32_t FLO:1;                 /* Filter output */
    } B;
  } MSR6;

  uint8_t IGF_reserved13[20];
  union {                              /* Rising edge Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t RTH:24;                /* Rising edge threshold */
    } B;
  } RTHR6;

  union {                              /* Falling edge Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t FTH:24;                /* Falling edge threshold */
    } B;
  } FTHR6;

  uint8_t IGF_reserved14[28];
  union {                              /* Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t MDIS:1;                /* Module Disable */
      vuint32_t FRZ:1;                 /* Freeze bit for debug operation */
      vuint32_t FBP:1;                 /* Force Bypass */
      vuint32_t FOH:1;                 /* Force filter output high */
      vuint32_t FOL:1;                 /* Force filter output low */
      vuint32_t  :16;
      vuint32_t IMM:1;                 /* Immediate edge propagation control bit */
      vuint32_t PSSEL:1;               /* Prescaler selection bit */
      vuint32_t POL:1;                 /* Output polarity bit */
      vuint32_t FGEN:1;                /* Filter global enable */
      vuint32_t  :1;
      vuint32_t FFM:2;                 /* Falling edge filter type selection */
      vuint32_t  :1;
      vuint32_t RFM:2;                 /* Rising edge filter type selection */
    } B;
  } MCR7;

  union {                              /* Module Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t WEDGE:1;               /* Filter is active waiting for an edge */
      vuint32_t FEDGE:1;               /* Filter is active processing an edge */
      vuint32_t RNDET:1;               /* Rise noise detected bit */
      vuint32_t FNDET:1;               /* Fall noise detected bit */
      vuint32_t FLI:1;                 /* Filter input */
      vuint32_t FLO:1;                 /* Filter output */
    } B;
  } MSR7;

  uint8_t IGF_reserved15[20];
  union {                              /* Rising edge Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t RTH:24;                /* Rising edge threshold */
    } B;
  } RTHR7;

  union {                              /* Falling edge Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t FTH:24;                /* Falling edge threshold */
    } B;
  } FTHR7;

  uint8_t IGF_reserved16[28];
  union {                              /* Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t MDIS:1;                /* Module Disable */
      vuint32_t FRZ:1;                 /* Freeze bit for debug operation */
      vuint32_t FBP:1;                 /* Force Bypass */
      vuint32_t FOH:1;                 /* Force filter output high */
      vuint32_t FOL:1;                 /* Force filter output low */
      vuint32_t  :16;
      vuint32_t IMM:1;                 /* Immediate edge propagation control bit */
      vuint32_t PSSEL:1;               /* Prescaler selection bit */
      vuint32_t POL:1;                 /* Output polarity bit */
      vuint32_t FGEN:1;                /* Filter global enable */
      vuint32_t  :1;
      vuint32_t FFM:2;                 /* Falling edge filter type selection */
      vuint32_t  :1;
      vuint32_t RFM:2;                 /* Rising edge filter type selection */
    } B;
  } MCR8;

  union {                              /* Module Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t WEDGE:1;               /* Filter is active waiting for an edge */
      vuint32_t FEDGE:1;               /* Filter is active processing an edge */
      vuint32_t RNDET:1;               /* Rise noise detected bit */
      vuint32_t FNDET:1;               /* Fall noise detected bit */
      vuint32_t FLI:1;                 /* Filter input */
      vuint32_t FLO:1;                 /* Filter output */
    } B;
  } MSR8;

  uint8_t IGF_reserved17[20];
  union {                              /* Rising edge Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t RTH:24;                /* Rising edge threshold */
    } B;
  } RTHR8;

  union {                              /* Falling edge Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t FTH:24;                /* Falling edge threshold */
    } B;
  } FTHR8;

  uint8_t IGF_reserved18[28];
  union {                              /* Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t MDIS:1;                /* Module Disable */
      vuint32_t FRZ:1;                 /* Freeze bit for debug operation */
      vuint32_t FBP:1;                 /* Force Bypass */
      vuint32_t FOH:1;                 /* Force filter output high */
      vuint32_t FOL:1;                 /* Force filter output low */
      vuint32_t  :16;
      vuint32_t IMM:1;                 /* Immediate edge propagation control bit */
      vuint32_t PSSEL:1;               /* Prescaler selection bit */
      vuint32_t POL:1;                 /* Output polarity bit */
      vuint32_t FGEN:1;                /* Filter global enable */
      vuint32_t  :1;
      vuint32_t FFM:2;                 /* Falling edge filter type selection */
      vuint32_t  :1;
      vuint32_t RFM:2;                 /* Rising edge filter type selection */
    } B;
  } MCR9;

  union {                              /* Module Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t WEDGE:1;               /* Filter is active waiting for an edge */
      vuint32_t FEDGE:1;               /* Filter is active processing an edge */
      vuint32_t RNDET:1;               /* Rise noise detected bit */
      vuint32_t FNDET:1;               /* Fall noise detected bit */
      vuint32_t FLI:1;                 /* Filter input */
      vuint32_t FLO:1;                 /* Filter output */
    } B;
  } MSR9;

  uint8_t IGF_reserved19[20];
  union {                              /* Rising edge Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t RTH:24;                /* Rising edge threshold */
    } B;
  } RTHR9;

  union {                              /* Falling edge Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t FTH:24;                /* Falling edge threshold */
    } B;
  } FTHR9;

  uint8_t IGF_reserved20[28];
  union {                              /* Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t MDIS:1;                /* Module Disable */
      vuint32_t FRZ:1;                 /* Freeze bit for debug operation */
      vuint32_t FBP:1;                 /* Force Bypass */
      vuint32_t FOH:1;                 /* Force filter output high */
      vuint32_t FOL:1;                 /* Force filter output low */
      vuint32_t  :16;
      vuint32_t IMM:1;                 /* Immediate edge propagation control bit */
      vuint32_t PSSEL:1;               /* Prescaler selection bit */
      vuint32_t POL:1;                 /* Output polarity bit */
      vuint32_t FGEN:1;                /* Filter global enable */
      vuint32_t  :1;
      vuint32_t FFM:2;                 /* Falling edge filter type selection */
      vuint32_t  :1;
      vuint32_t RFM:2;                 /* Rising edge filter type selection */
    } B;
  } MCR10;

  union {                              /* Module Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t WEDGE:1;               /* Filter is active waiting for an edge */
      vuint32_t FEDGE:1;               /* Filter is active processing an edge */
      vuint32_t RNDET:1;               /* Rise noise detected bit */
      vuint32_t FNDET:1;               /* Fall noise detected bit */
      vuint32_t FLI:1;                 /* Filter input */
      vuint32_t FLO:1;                 /* Filter output */
    } B;
  } MSR10;

  uint8_t IGF_reserved21[20];
  union {                              /* Rising edge Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t RTH:24;                /* Rising edge threshold */
    } B;
  } RTHR10;

  union {                              /* Falling edge Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t FTH:24;                /* Falling edge threshold */
    } B;
  } FTHR10;

  uint8_t IGF_reserved22[28];
  union {                              /* Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t MDIS:1;                /* Module Disable */
      vuint32_t FRZ:1;                 /* Freeze bit for debug operation */
      vuint32_t FBP:1;                 /* Force Bypass */
      vuint32_t FOH:1;                 /* Force filter output high */
      vuint32_t FOL:1;                 /* Force filter output low */
      vuint32_t  :16;
      vuint32_t IMM:1;                 /* Immediate edge propagation control bit */
      vuint32_t PSSEL:1;               /* Prescaler selection bit */
      vuint32_t POL:1;                 /* Output polarity bit */
      vuint32_t FGEN:1;                /* Filter global enable */
      vuint32_t  :1;
      vuint32_t FFM:2;                 /* Falling edge filter type selection */
      vuint32_t  :1;
      vuint32_t RFM:2;                 /* Rising edge filter type selection */
    } B;
  } MCR11;

  union {                              /* Module Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t WEDGE:1;               /* Filter is active waiting for an edge */
      vuint32_t FEDGE:1;               /* Filter is active processing an edge */
      vuint32_t RNDET:1;               /* Rise noise detected bit */
      vuint32_t FNDET:1;               /* Fall noise detected bit */
      vuint32_t FLI:1;                 /* Filter input */
      vuint32_t FLO:1;                 /* Filter output */
    } B;
  } MSR11;

  uint8_t IGF_reserved23[20];
  union {                              /* Rising edge Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t RTH:24;                /* Rising edge threshold */
    } B;
  } RTHR11;

  union {                              /* Falling edge Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t FTH:24;                /* Falling edge threshold */
    } B;
  } FTHR11;

  uint8_t IGF_reserved24[28];
  union {                              /* Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t MDIS:1;                /* Module Disable */
      vuint32_t FRZ:1;                 /* Freeze bit for debug operation */
      vuint32_t FBP:1;                 /* Force Bypass */
      vuint32_t FOH:1;                 /* Force filter output high */
      vuint32_t FOL:1;                 /* Force filter output low */
      vuint32_t  :16;
      vuint32_t IMM:1;                 /* Immediate edge propagation control bit */
      vuint32_t PSSEL:1;               /* Prescaler selection bit */
      vuint32_t POL:1;                 /* Output polarity bit */
      vuint32_t FGEN:1;                /* Filter global enable */
      vuint32_t  :1;
      vuint32_t FFM:2;                 /* Falling edge filter type selection */
      vuint32_t  :1;
      vuint32_t RFM:2;                 /* Rising edge filter type selection */
    } B;
  } MCR12;

  union {                              /* Module Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t WEDGE:1;               /* Filter is active waiting for an edge */
      vuint32_t FEDGE:1;               /* Filter is active processing an edge */
      vuint32_t RNDET:1;               /* Rise noise detected bit */
      vuint32_t FNDET:1;               /* Fall noise detected bit */
      vuint32_t FLI:1;                 /* Filter input */
      vuint32_t FLO:1;                 /* Filter output */
    } B;
  } MSR12;

  uint8_t IGF_reserved25[20];
  union {                              /* Rising edge Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t RTH:24;                /* Rising edge threshold */
    } B;
  } RTHR12;

  union {                              /* Falling edge Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t FTH:24;                /* Falling edge threshold */
    } B;
  } FTHR12;

  uint8_t IGF_reserved26[28];
  union {                              /* Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t MDIS:1;                /* Module Disable */
      vuint32_t FRZ:1;                 /* Freeze bit for debug operation */
      vuint32_t FBP:1;                 /* Force Bypass */
      vuint32_t FOH:1;                 /* Force filter output high */
      vuint32_t FOL:1;                 /* Force filter output low */
      vuint32_t  :16;
      vuint32_t IMM:1;                 /* Immediate edge propagation control bit */
      vuint32_t PSSEL:1;               /* Prescaler selection bit */
      vuint32_t POL:1;                 /* Output polarity bit */
      vuint32_t FGEN:1;                /* Filter global enable */
      vuint32_t  :1;
      vuint32_t FFM:2;                 /* Falling edge filter type selection */
      vuint32_t  :1;
      vuint32_t RFM:2;                 /* Rising edge filter type selection */
    } B;
  } MCR13;

  union {                              /* Module Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t WEDGE:1;               /* Filter is active waiting for an edge */
      vuint32_t FEDGE:1;               /* Filter is active processing an edge */
      vuint32_t RNDET:1;               /* Rise noise detected bit */
      vuint32_t FNDET:1;               /* Fall noise detected bit */
      vuint32_t FLI:1;                 /* Filter input */
      vuint32_t FLO:1;                 /* Filter output */
    } B;
  } MSR13;

  uint8_t IGF_reserved27[20];
  union {                              /* Rising edge Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t RTH:24;                /* Rising edge threshold */
    } B;
  } RTHR13;

  union {                              /* Falling edge Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t FTH:24;                /* Falling edge threshold */
    } B;
  } FTHR13;

  uint8_t IGF_reserved28[28];
  union {                              /* Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t MDIS:1;                /* Module Disable */
      vuint32_t FRZ:1;                 /* Freeze bit for debug operation */
      vuint32_t FBP:1;                 /* Force Bypass */
      vuint32_t FOH:1;                 /* Force filter output high */
      vuint32_t FOL:1;                 /* Force filter output low */
      vuint32_t  :16;
      vuint32_t IMM:1;                 /* Immediate edge propagation control bit */
      vuint32_t PSSEL:1;               /* Prescaler selection bit */
      vuint32_t POL:1;                 /* Output polarity bit */
      vuint32_t FGEN:1;                /* Filter global enable */
      vuint32_t  :1;
      vuint32_t FFM:2;                 /* Falling edge filter type selection */
      vuint32_t  :1;
      vuint32_t RFM:2;                 /* Rising edge filter type selection */
    } B;
  } MCR14;

  union {                              /* Module Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t WEDGE:1;               /* Filter is active waiting for an edge */
      vuint32_t FEDGE:1;               /* Filter is active processing an edge */
      vuint32_t RNDET:1;               /* Rise noise detected bit */
      vuint32_t FNDET:1;               /* Fall noise detected bit */
      vuint32_t FLI:1;                 /* Filter input */
      vuint32_t FLO:1;                 /* Filter output */
    } B;
  } MSR14;

  uint8_t IGF_reserved29[20];
  union {                              /* Rising edge Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t RTH:24;                /* Rising edge threshold */
    } B;
  } RTHR14;

  union {                              /* Falling edge Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t FTH:24;                /* Falling edge threshold */
    } B;
  } FTHR14;

  uint8_t IGF_reserved30[28];
  union {                              /* Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t MDIS:1;                /* Module Disable */
      vuint32_t FRZ:1;                 /* Freeze bit for debug operation */
      vuint32_t FBP:1;                 /* Force Bypass */
      vuint32_t FOH:1;                 /* Force filter output high */
      vuint32_t FOL:1;                 /* Force filter output low */
      vuint32_t  :16;
      vuint32_t IMM:1;                 /* Immediate edge propagation control bit */
      vuint32_t PSSEL:1;               /* Prescaler selection bit */
      vuint32_t POL:1;                 /* Output polarity bit */
      vuint32_t FGEN:1;                /* Filter global enable */
      vuint32_t  :1;
      vuint32_t FFM:2;                 /* Falling edge filter type selection */
      vuint32_t  :1;
      vuint32_t RFM:2;                 /* Rising edge filter type selection */
    } B;
  } MCR15;

  union {                              /* Module Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t WEDGE:1;               /* Filter is active waiting for an edge */
      vuint32_t FEDGE:1;               /* Filter is active processing an edge */
      vuint32_t RNDET:1;               /* Rise noise detected bit */
      vuint32_t FNDET:1;               /* Fall noise detected bit */
      vuint32_t FLI:1;                 /* Filter input */
      vuint32_t FLO:1;                 /* Filter output */
    } B;
  } MSR15;

  uint8_t IGF_reserved31[20];
  union {                              /* Rising edge Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t RTH:24;                /* Rising edge threshold */
    } B;
  } RTHR15;

  union {                              /* Falling edge Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t FTH:24;                /* Falling edge threshold */
    } B;
  } FTHR15;

  uint8_t IGF_reserved32[28];
  union {                              /* Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t MDIS:1;                /* Module Disable */
      vuint32_t FRZ:1;                 /* Freeze bit for debug operation */
      vuint32_t FBP:1;                 /* Force Bypass */
      vuint32_t FOH:1;                 /* Force filter output high */
      vuint32_t FOL:1;                 /* Force filter output low */
      vuint32_t  :16;
      vuint32_t IMM:1;                 /* Immediate edge propagation control bit */
      vuint32_t PSSEL:1;               /* Prescaler selection bit */
      vuint32_t POL:1;                 /* Output polarity bit */
      vuint32_t FGEN:1;                /* Filter global enable */
      vuint32_t  :1;
      vuint32_t FFM:2;                 /* Falling edge filter type selection */
      vuint32_t  :1;
      vuint32_t RFM:2;                 /* Rising edge filter type selection */
    } B;
  } MCR16;

  union {                              /* Module Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t WEDGE:1;               /* Filter is active waiting for an edge */
      vuint32_t FEDGE:1;               /* Filter is active processing an edge */
      vuint32_t RNDET:1;               /* Rise noise detected bit */
      vuint32_t FNDET:1;               /* Fall noise detected bit */
      vuint32_t FLI:1;                 /* Filter input */
      vuint32_t FLO:1;                 /* Filter output */
    } B;
  } MSR16;

  uint8_t IGF_reserved33[20];
  union {                              /* Rising edge Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t RTH:24;                /* Rising edge threshold */
    } B;
  } RTHR16;

  union {                              /* Falling edge Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t FTH:24;                /* Falling edge threshold */
    } B;
  } FTHR16;

  uint8_t IGF_reserved34[28];
  union {                              /* Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t MDIS:1;                /* Module Disable */
      vuint32_t FRZ:1;                 /* Freeze bit for debug operation */
      vuint32_t FBP:1;                 /* Force Bypass */
      vuint32_t FOH:1;                 /* Force filter output high */
      vuint32_t FOL:1;                 /* Force filter output low */
      vuint32_t  :16;
      vuint32_t IMM:1;                 /* Immediate edge propagation control bit */
      vuint32_t PSSEL:1;               /* Prescaler selection bit */
      vuint32_t POL:1;                 /* Output polarity bit */
      vuint32_t FGEN:1;                /* Filter global enable */
      vuint32_t  :1;
      vuint32_t FFM:2;                 /* Falling edge filter type selection */
      vuint32_t  :1;
      vuint32_t RFM:2;                 /* Rising edge filter type selection */
    } B;
  } MCR17;

  union {                              /* Module Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t WEDGE:1;               /* Filter is active waiting for an edge */
      vuint32_t FEDGE:1;               /* Filter is active processing an edge */
      vuint32_t RNDET:1;               /* Rise noise detected bit */
      vuint32_t FNDET:1;               /* Fall noise detected bit */
      vuint32_t FLI:1;                 /* Filter input */
      vuint32_t FLO:1;                 /* Filter output */
    } B;
  } MSR17;

  uint8_t IGF_reserved35[20];
  union {                              /* Rising edge Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t RTH:24;                /* Rising edge threshold */
    } B;
  } RTHR17;

  union {                              /* Falling edge Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t FTH:24;                /* Falling edge threshold */
    } B;
  } FTHR17;

  uint8_t IGF_reserved36[28];
  union {                              /* Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t MDIS:1;                /* Module Disable */
      vuint32_t FRZ:1;                 /* Freeze bit for debug operation */
      vuint32_t FBP:1;                 /* Force Bypass */
      vuint32_t FOH:1;                 /* Force filter output high */
      vuint32_t FOL:1;                 /* Force filter output low */
      vuint32_t  :16;
      vuint32_t IMM:1;                 /* Immediate edge propagation control bit */
      vuint32_t PSSEL:1;               /* Prescaler selection bit */
      vuint32_t POL:1;                 /* Output polarity bit */
      vuint32_t FGEN:1;                /* Filter global enable */
      vuint32_t  :1;
      vuint32_t FFM:2;                 /* Falling edge filter type selection */
      vuint32_t  :1;
      vuint32_t RFM:2;                 /* Rising edge filter type selection */
    } B;
  } MCR18;

  union {                              /* Module Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t WEDGE:1;               /* Filter is active waiting for an edge */
      vuint32_t FEDGE:1;               /* Filter is active processing an edge */
      vuint32_t RNDET:1;               /* Rise noise detected bit */
      vuint32_t FNDET:1;               /* Fall noise detected bit */
      vuint32_t FLI:1;                 /* Filter input */
      vuint32_t FLO:1;                 /* Filter output */
    } B;
  } MSR18;

  uint8_t IGF_reserved37[20];
  union {                              /* Rising edge Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t RTH:24;                /* Rising edge threshold */
    } B;
  } RTHR18;

  union {                              /* Falling edge Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t FTH:24;                /* Falling edge threshold */
    } B;
  } FTHR18;

  uint8_t IGF_reserved38[28];
  union {                              /* Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t MDIS:1;                /* Module Disable */
      vuint32_t FRZ:1;                 /* Freeze bit for debug operation */
      vuint32_t FBP:1;                 /* Force Bypass */
      vuint32_t FOH:1;                 /* Force filter output high */
      vuint32_t FOL:1;                 /* Force filter output low */
      vuint32_t  :16;
      vuint32_t IMM:1;                 /* Immediate edge propagation control bit */
      vuint32_t PSSEL:1;               /* Prescaler selection bit */
      vuint32_t POL:1;                 /* Output polarity bit */
      vuint32_t FGEN:1;                /* Filter global enable */
      vuint32_t  :1;
      vuint32_t FFM:2;                 /* Falling edge filter type selection */
      vuint32_t  :1;
      vuint32_t RFM:2;                 /* Rising edge filter type selection */
    } B;
  } MCR19;

  union {                              /* Module Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t WEDGE:1;               /* Filter is active waiting for an edge */
      vuint32_t FEDGE:1;               /* Filter is active processing an edge */
      vuint32_t RNDET:1;               /* Rise noise detected bit */
      vuint32_t FNDET:1;               /* Fall noise detected bit */
      vuint32_t FLI:1;                 /* Filter input */
      vuint32_t FLO:1;                 /* Filter output */
    } B;
  } MSR19;

  uint8_t IGF_reserved39[20];
  union {                              /* Rising edge Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t RTH:24;                /* Rising edge threshold */
    } B;
  } RTHR19;

  union {                              /* Falling edge Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t FTH:24;                /* Falling edge threshold */
    } B;
  } FTHR19;

  uint8_t IGF_reserved40[28];
  union {                              /* Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t MDIS:1;                /* Module Disable */
      vuint32_t FRZ:1;                 /* Freeze bit for debug operation */
      vuint32_t FBP:1;                 /* Force Bypass */
      vuint32_t FOH:1;                 /* Force filter output high */
      vuint32_t FOL:1;                 /* Force filter output low */
      vuint32_t  :16;
      vuint32_t IMM:1;                 /* Immediate edge propagation control bit */
      vuint32_t PSSEL:1;               /* Prescaler selection bit */
      vuint32_t POL:1;                 /* Output polarity bit */
      vuint32_t FGEN:1;                /* Filter global enable */
      vuint32_t  :1;
      vuint32_t FFM:2;                 /* Falling edge filter type selection */
      vuint32_t  :1;
      vuint32_t RFM:2;                 /* Rising edge filter type selection */
    } B;
  } MCR20;

  union {                              /* Module Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t WEDGE:1;               /* Filter is active waiting for an edge */
      vuint32_t FEDGE:1;               /* Filter is active processing an edge */
      vuint32_t RNDET:1;               /* Rise noise detected bit */
      vuint32_t FNDET:1;               /* Fall noise detected bit */
      vuint32_t FLI:1;                 /* Filter input */
      vuint32_t FLO:1;                 /* Filter output */
    } B;
  } MSR20;

  uint8_t IGF_reserved41[20];
  union {                              /* Rising edge Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t RTH:24;                /* Rising edge threshold */
    } B;
  } RTHR20;

  union {                              /* Falling edge Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t FTH:24;                /* Falling edge threshold */
    } B;
  } FTHR20;

  uint8_t IGF_reserved42[28];
  union {                              /* Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t MDIS:1;                /* Module Disable */
      vuint32_t FRZ:1;                 /* Freeze bit for debug operation */
      vuint32_t FBP:1;                 /* Force Bypass */
      vuint32_t FOH:1;                 /* Force filter output high */
      vuint32_t FOL:1;                 /* Force filter output low */
      vuint32_t  :16;
      vuint32_t IMM:1;                 /* Immediate edge propagation control bit */
      vuint32_t PSSEL:1;               /* Prescaler selection bit */
      vuint32_t POL:1;                 /* Output polarity bit */
      vuint32_t FGEN:1;                /* Filter global enable */
      vuint32_t  :1;
      vuint32_t FFM:2;                 /* Falling edge filter type selection */
      vuint32_t  :1;
      vuint32_t RFM:2;                 /* Rising edge filter type selection */
    } B;
  } MCR21;

  union {                              /* Module Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t WEDGE:1;               /* Filter is active waiting for an edge */
      vuint32_t FEDGE:1;               /* Filter is active processing an edge */
      vuint32_t RNDET:1;               /* Rise noise detected bit */
      vuint32_t FNDET:1;               /* Fall noise detected bit */
      vuint32_t FLI:1;                 /* Filter input */
      vuint32_t FLO:1;                 /* Filter output */
    } B;
  } MSR21;

  uint8_t IGF_reserved43[20];
  union {                              /* Rising edge Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t RTH:24;                /* Rising edge threshold */
    } B;
  } RTHR21;

  union {                              /* Falling edge Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t FTH:24;                /* Falling edge threshold */
    } B;
  } FTHR21;

  uint8_t IGF_reserved44[28];
  union {                              /* Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t MDIS:1;                /* Module Disable */
      vuint32_t FRZ:1;                 /* Freeze bit for debug operation */
      vuint32_t FBP:1;                 /* Force Bypass */
      vuint32_t FOH:1;                 /* Force filter output high */
      vuint32_t FOL:1;                 /* Force filter output low */
      vuint32_t  :16;
      vuint32_t IMM:1;                 /* Immediate edge propagation control bit */
      vuint32_t PSSEL:1;               /* Prescaler selection bit */
      vuint32_t POL:1;                 /* Output polarity bit */
      vuint32_t FGEN:1;                /* Filter global enable */
      vuint32_t  :1;
      vuint32_t FFM:2;                 /* Falling edge filter type selection */
      vuint32_t  :1;
      vuint32_t RFM:2;                 /* Rising edge filter type selection */
    } B;
  } MCR22;

  union {                              /* Module Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t WEDGE:1;               /* Filter is active waiting for an edge */
      vuint32_t FEDGE:1;               /* Filter is active processing an edge */
      vuint32_t RNDET:1;               /* Rise noise detected bit */
      vuint32_t FNDET:1;               /* Fall noise detected bit */
      vuint32_t FLI:1;                 /* Filter input */
      vuint32_t FLO:1;                 /* Filter output */
    } B;
  } MSR22;

  uint8_t IGF_reserved45[20];
  union {                              /* Rising edge Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t RTH:24;                /* Rising edge threshold */
    } B;
  } RTHR22;

  union {                              /* Falling edge Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t FTH:24;                /* Falling edge threshold */
    } B;
  } FTHR22;

  uint8_t IGF_reserved46[28];
  union {                              /* Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t MDIS:1;                /* Module Disable */
      vuint32_t FRZ:1;                 /* Freeze bit for debug operation */
      vuint32_t FBP:1;                 /* Force Bypass */
      vuint32_t FOH:1;                 /* Force filter output high */
      vuint32_t FOL:1;                 /* Force filter output low */
      vuint32_t  :16;
      vuint32_t IMM:1;                 /* Immediate edge propagation control bit */
      vuint32_t PSSEL:1;               /* Prescaler selection bit */
      vuint32_t POL:1;                 /* Output polarity bit */
      vuint32_t FGEN:1;                /* Filter global enable */
      vuint32_t  :1;
      vuint32_t FFM:2;                 /* Falling edge filter type selection */
      vuint32_t  :1;
      vuint32_t RFM:2;                 /* Rising edge filter type selection */
    } B;
  } MCR23;

  union {                              /* Module Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t WEDGE:1;               /* Filter is active waiting for an edge */
      vuint32_t FEDGE:1;               /* Filter is active processing an edge */
      vuint32_t RNDET:1;               /* Rise noise detected bit */
      vuint32_t FNDET:1;               /* Fall noise detected bit */
      vuint32_t FLI:1;                 /* Filter input */
      vuint32_t FLO:1;                 /* Filter output */
    } B;
  } MSR23;

  uint8_t IGF_reserved47[20];
  union {                              /* Rising edge Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t RTH:24;                /* Rising edge threshold */
    } B;
  } RTHR23;

  union {                              /* Falling edge Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t FTH:24;                /* Falling edge threshold */
    } B;
  } FTHR23;

  uint8_t IGF_reserved48[28];
  union {                              /* Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t MDIS:1;                /* Module Disable */
      vuint32_t FRZ:1;                 /* Freeze bit for debug operation */
      vuint32_t FBP:1;                 /* Force Bypass */
      vuint32_t FOH:1;                 /* Force filter output high */
      vuint32_t FOL:1;                 /* Force filter output low */
      vuint32_t  :16;
      vuint32_t IMM:1;                 /* Immediate edge propagation control bit */
      vuint32_t PSSEL:1;               /* Prescaler selection bit */
      vuint32_t POL:1;                 /* Output polarity bit */
      vuint32_t FGEN:1;                /* Filter global enable */
      vuint32_t  :1;
      vuint32_t FFM:2;                 /* Falling edge filter type selection */
      vuint32_t  :1;
      vuint32_t RFM:2;                 /* Rising edge filter type selection */
    } B;
  } MCR24;

  union {                              /* Module Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t WEDGE:1;               /* Filter is active waiting for an edge */
      vuint32_t FEDGE:1;               /* Filter is active processing an edge */
      vuint32_t RNDET:1;               /* Rise noise detected bit */
      vuint32_t FNDET:1;               /* Fall noise detected bit */
      vuint32_t FLI:1;                 /* Filter input */
      vuint32_t FLO:1;                 /* Filter output */
    } B;
  } MSR24;

  uint8_t IGF_reserved49[20];
  union {                              /* Rising edge Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t RTH:24;                /* Rising edge threshold */
    } B;
  } RTHR24;

  union {                              /* Falling edge Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t FTH:24;                /* Falling edge threshold */
    } B;
  } FTHR24;

  uint8_t IGF_reserved50[28];
  union {                              /* Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t MDIS:1;                /* Module Disable */
      vuint32_t FRZ:1;                 /* Freeze bit for debug operation */
      vuint32_t FBP:1;                 /* Force Bypass */
      vuint32_t FOH:1;                 /* Force filter output high */
      vuint32_t FOL:1;                 /* Force filter output low */
      vuint32_t  :16;
      vuint32_t IMM:1;                 /* Immediate edge propagation control bit */
      vuint32_t PSSEL:1;               /* Prescaler selection bit */
      vuint32_t POL:1;                 /* Output polarity bit */
      vuint32_t FGEN:1;                /* Filter global enable */
      vuint32_t  :1;
      vuint32_t FFM:2;                 /* Falling edge filter type selection */
      vuint32_t  :1;
      vuint32_t RFM:2;                 /* Rising edge filter type selection */
    } B;
  } MCR25;

  union {                              /* Module Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t WEDGE:1;               /* Filter is active waiting for an edge */
      vuint32_t FEDGE:1;               /* Filter is active processing an edge */
      vuint32_t RNDET:1;               /* Rise noise detected bit */
      vuint32_t FNDET:1;               /* Fall noise detected bit */
      vuint32_t FLI:1;                 /* Filter input */
      vuint32_t FLO:1;                 /* Filter output */
    } B;
  } MSR25;

  uint8_t IGF_reserved51[20];
  union {                              /* Rising edge Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t RTH:24;                /* Rising edge threshold */
    } B;
  } RTHR25;

  union {                              /* Falling edge Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t FTH:24;                /* Falling edge threshold */
    } B;
  } FTHR25;

  uint8_t IGF_reserved52[28];
  union {                              /* Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t MDIS:1;                /* Module Disable */
      vuint32_t FRZ:1;                 /* Freeze bit for debug operation */
      vuint32_t FBP:1;                 /* Force Bypass */
      vuint32_t FOH:1;                 /* Force filter output high */
      vuint32_t FOL:1;                 /* Force filter output low */
      vuint32_t  :16;
      vuint32_t IMM:1;                 /* Immediate edge propagation control bit */
      vuint32_t PSSEL:1;               /* Prescaler selection bit */
      vuint32_t POL:1;                 /* Output polarity bit */
      vuint32_t FGEN:1;                /* Filter global enable */
      vuint32_t  :1;
      vuint32_t FFM:2;                 /* Falling edge filter type selection */
      vuint32_t  :1;
      vuint32_t RFM:2;                 /* Rising edge filter type selection */
    } B;
  } MCR26;

  union {                              /* Module Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t WEDGE:1;               /* Filter is active waiting for an edge */
      vuint32_t FEDGE:1;               /* Filter is active processing an edge */
      vuint32_t RNDET:1;               /* Rise noise detected bit */
      vuint32_t FNDET:1;               /* Fall noise detected bit */
      vuint32_t FLI:1;                 /* Filter input */
      vuint32_t FLO:1;                 /* Filter output */
    } B;
  } MSR26;

  uint8_t IGF_reserved53[20];
  union {                              /* Rising edge Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t RTH:24;                /* Rising edge threshold */
    } B;
  } RTHR26;

  union {                              /* Falling edge Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t FTH:24;                /* Falling edge threshold */
    } B;
  } FTHR26;

  uint8_t IGF_reserved54[28];
  union {                              /* Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t MDIS:1;                /* Module Disable */
      vuint32_t FRZ:1;                 /* Freeze bit for debug operation */
      vuint32_t FBP:1;                 /* Force Bypass */
      vuint32_t FOH:1;                 /* Force filter output high */
      vuint32_t FOL:1;                 /* Force filter output low */
      vuint32_t  :16;
      vuint32_t IMM:1;                 /* Immediate edge propagation control bit */
      vuint32_t PSSEL:1;               /* Prescaler selection bit */
      vuint32_t POL:1;                 /* Output polarity bit */
      vuint32_t FGEN:1;                /* Filter global enable */
      vuint32_t  :1;
      vuint32_t FFM:2;                 /* Falling edge filter type selection */
      vuint32_t  :1;
      vuint32_t RFM:2;                 /* Rising edge filter type selection */
    } B;
  } MCR27;

  union {                              /* Module Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t WEDGE:1;               /* Filter is active waiting for an edge */
      vuint32_t FEDGE:1;               /* Filter is active processing an edge */
      vuint32_t RNDET:1;               /* Rise noise detected bit */
      vuint32_t FNDET:1;               /* Fall noise detected bit */
      vuint32_t FLI:1;                 /* Filter input */
      vuint32_t FLO:1;                 /* Filter output */
    } B;
  } MSR27;

  uint8_t IGF_reserved55[20];
  union {                              /* Rising edge Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t RTH:24;                /* Rising edge threshold */
    } B;
  } RTHR27;

  union {                              /* Falling edge Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t FTH:24;                /* Falling edge threshold */
    } B;
  } FTHR27;

  uint8_t IGF_reserved56[28];
  union {                              /* Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t MDIS:1;                /* Module Disable */
      vuint32_t FRZ:1;                 /* Freeze bit for debug operation */
      vuint32_t FBP:1;                 /* Force Bypass */
      vuint32_t FOH:1;                 /* Force filter output high */
      vuint32_t FOL:1;                 /* Force filter output low */
      vuint32_t  :16;
      vuint32_t IMM:1;                 /* Immediate edge propagation control bit */
      vuint32_t PSSEL:1;               /* Prescaler selection bit */
      vuint32_t POL:1;                 /* Output polarity bit */
      vuint32_t FGEN:1;                /* Filter global enable */
      vuint32_t  :1;
      vuint32_t FFM:2;                 /* Falling edge filter type selection */
      vuint32_t  :1;
      vuint32_t RFM:2;                 /* Rising edge filter type selection */
    } B;
  } MCR28;

  union {                              /* Module Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t WEDGE:1;               /* Filter is active waiting for an edge */
      vuint32_t FEDGE:1;               /* Filter is active processing an edge */
      vuint32_t RNDET:1;               /* Rise noise detected bit */
      vuint32_t FNDET:1;               /* Fall noise detected bit */
      vuint32_t FLI:1;                 /* Filter input */
      vuint32_t FLO:1;                 /* Filter output */
    } B;
  } MSR28;

  uint8_t IGF_reserved57[20];
  union {                              /* Rising edge Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t RTH:24;                /* Rising edge threshold */
    } B;
  } RTHR28;

  union {                              /* Falling edge Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t FTH:24;                /* Falling edge threshold */
    } B;
  } FTHR28;

  uint8_t IGF_reserved58[28];
  union {                              /* Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t MDIS:1;                /* Module Disable */
      vuint32_t FRZ:1;                 /* Freeze bit for debug operation */
      vuint32_t FBP:1;                 /* Force Bypass */
      vuint32_t FOH:1;                 /* Force filter output high */
      vuint32_t FOL:1;                 /* Force filter output low */
      vuint32_t  :16;
      vuint32_t IMM:1;                 /* Immediate edge propagation control bit */
      vuint32_t PSSEL:1;               /* Prescaler selection bit */
      vuint32_t POL:1;                 /* Output polarity bit */
      vuint32_t FGEN:1;                /* Filter global enable */
      vuint32_t  :1;
      vuint32_t FFM:2;                 /* Falling edge filter type selection */
      vuint32_t  :1;
      vuint32_t RFM:2;                 /* Rising edge filter type selection */
    } B;
  } MCR29;

  union {                              /* Module Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t WEDGE:1;               /* Filter is active waiting for an edge */
      vuint32_t FEDGE:1;               /* Filter is active processing an edge */
      vuint32_t RNDET:1;               /* Rise noise detected bit */
      vuint32_t FNDET:1;               /* Fall noise detected bit */
      vuint32_t FLI:1;                 /* Filter input */
      vuint32_t FLO:1;                 /* Filter output */
    } B;
  } MSR29;

  uint8_t IGF_reserved59[20];
  union {                              /* Rising edge Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t RTH:24;                /* Rising edge threshold */
    } B;
  } RTHR29;

  union {                              /* Falling edge Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t FTH:24;                /* Falling edge threshold */
    } B;
  } FTHR29;

  uint8_t IGF_reserved60[28];
  union {                              /* Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t MDIS:1;                /* Module Disable */
      vuint32_t FRZ:1;                 /* Freeze bit for debug operation */
      vuint32_t FBP:1;                 /* Force Bypass */
      vuint32_t FOH:1;                 /* Force filter output high */
      vuint32_t FOL:1;                 /* Force filter output low */
      vuint32_t  :16;
      vuint32_t IMM:1;                 /* Immediate edge propagation control bit */
      vuint32_t PSSEL:1;               /* Prescaler selection bit */
      vuint32_t POL:1;                 /* Output polarity bit */
      vuint32_t FGEN:1;                /* Filter global enable */
      vuint32_t  :1;
      vuint32_t FFM:2;                 /* Falling edge filter type selection */
      vuint32_t  :1;
      vuint32_t RFM:2;                 /* Rising edge filter type selection */
    } B;
  } MCR30;

  union {                              /* Module Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t WEDGE:1;               /* Filter is active waiting for an edge */
      vuint32_t FEDGE:1;               /* Filter is active processing an edge */
      vuint32_t RNDET:1;               /* Rise noise detected bit */
      vuint32_t FNDET:1;               /* Fall noise detected bit */
      vuint32_t FLI:1;                 /* Filter input */
      vuint32_t FLO:1;                 /* Filter output */
    } B;
  } MSR30;

  uint8_t IGF_reserved61[20];
  union {                              /* Rising edge Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t RTH:24;                /* Rising edge threshold */
    } B;
  } RTHR30;

  union {                              /* Falling edge Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t FTH:24;                /* Falling edge threshold */
    } B;
  } FTHR30;

  uint8_t IGF_reserved62[28];
  union {                              /* Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t MDIS:1;                /* Module Disable */
      vuint32_t FRZ:1;                 /* Freeze bit for debug operation */
      vuint32_t FBP:1;                 /* Force Bypass */
      vuint32_t FOH:1;                 /* Force filter output high */
      vuint32_t FOL:1;                 /* Force filter output low */
      vuint32_t  :16;
      vuint32_t IMM:1;                 /* Immediate edge propagation control bit */
      vuint32_t PSSEL:1;               /* Prescaler selection bit */
      vuint32_t POL:1;                 /* Output polarity bit */
      vuint32_t FGEN:1;                /* Filter global enable */
      vuint32_t  :1;
      vuint32_t FFM:2;                 /* Falling edge filter type selection */
      vuint32_t  :1;
      vuint32_t RFM:2;                 /* Rising edge filter type selection */
    } B;
  } MCR31;

  union {                              /* Module Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t WEDGE:1;               /* Filter is active waiting for an edge */
      vuint32_t FEDGE:1;               /* Filter is active processing an edge */
      vuint32_t RNDET:1;               /* Rise noise detected bit */
      vuint32_t FNDET:1;               /* Fall noise detected bit */
      vuint32_t FLI:1;                 /* Filter input */
      vuint32_t FLO:1;                 /* Filter output */
    } B;
  } MSR31;

  uint8_t IGF_reserved63[20];
  union {                              /* Rising edge Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t RTH:24;                /* Rising edge threshold */
    } B;
  } RTHR31;

  union {                              /* Falling edge Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t FTH:24;                /* Falling edge threshold */
    } B;
  } FTHR31;
};


/* ============================================================================
   =============================== Module: INTC ===============================
   ============================================================================ */

struct INTC_tag {
  union {                              /* INTC Block Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :19;
      vuint32_t HVEN3:1;
      vuint32_t  :3;
      vuint32_t HVEN2:1;
      vuint32_t  :3;
      vuint32_t HVEN1:1;
      vuint32_t  :3;
      vuint32_t HVEN0:1;
    } B;
  } BCR;

  uint8_t INTC_reserved0[12];
  union {                              /* INTC Current Priority Register for Processor n */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t PRI:6;
    } B;
  } CPR[2];

  uint8_t INTC_reserved1[8];
  union {                              /* INTC Interrupt Acknowledge Register for Processor n */
    vuint32_t R;
    struct {
      vuint32_t VTBA:20;
      vuint32_t INTVEC:10;
      vuint32_t  :2;
    } B;
  } IACKR[2];

  uint8_t INTC_reserved2[8];
  union {                              /* INTC End Of Interrupt Register for Processor n */
    vuint32_t R;
    struct {
      vuint32_t EOI:32;
    } B;
  } EOIR[2];

  uint8_t INTC_reserved3[8];
  union {                              /* INTC Software Set/Clear Interrupt Register */
    vuint8_t R;
    struct {
      vuint8_t  :6;
      vuint8_t SET:1;
      vuint8_t CLR:1;
    } B;
  } SSCIR[32];

  union {                              /* INTC Priority Select Register */
    vuint16_t R;
    struct {
      vuint16_t PRC_SELN:4;
      vuint16_t  :3;
      vuint16_t SWTN:1;
      vuint16_t  :2;
      vuint16_t PRIN:6;
    } B;
  } PSR[1024];

  uint8_t INTC_reserved4[1952];
  struct {
    union {                            /* INTC Monitor Mode Register */
      vuint32_t R;
      struct {
        vuint32_t  :30;
        vuint32_t MM:2;
      } B;
    } MMRC;
    union {                            /* INTC HIPRI Register */
      vuint32_t R;
      struct {
        vuint32_t  :22;
        vuint32_t IRQ:10;
      } B;
    } HIPRIC[4];
    union {                            /* INTC LAT Register */
      vuint32_t R;
      struct {
        vuint32_t  :8;
        vuint32_t LAT:24;
      } B;
    } LATC[4];
    union {                            /* INTC Timer Register */
      vuint32_t R;
      struct {
        vuint32_t  :8;
        vuint32_t TIMER:24;
      } B;
    } TIMERC[4];
  } CHANNEL[2];
};


/* ============================================================================
   =============================== Module: IRCOSC =============================
   ============================================================================ */

struct IRCOSC_tag {
  union {                              /* IRCOSC Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t  :1;
      vuint32_t  :3;
      vuint32_t USER_TRIM:5;
      vuint32_t  :3;
      vuint32_t  :5;
      vuint32_t  :2;
      vuint32_t  :1;
      vuint32_t  :5;
    } B;
  } CTL;
};


/* ============================================================================
   =============================== Module: JDC ================================
   ============================================================================ */

struct JDC_tag {
  union {                              /* Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :15;
      vuint32_t JIN_IEN:1;
      vuint32_t  :15;
      vuint32_t JOUT_IEN:1;
    } B;
  } MCR;

  union {                              /* Module Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :13;
      vuint32_t JIN_RDY:1;
      vuint32_t  :1;
      vuint32_t JIN_INT:1;
      vuint32_t  :13;
      vuint32_t JOUT_RDY:1;
      vuint32_t  :1;
      vuint32_t JOUT_INT:1;
    } B;
  } MSR;

  union {                              /* JTAG Output Data Register */
    vuint32_t R;
    struct {
      vuint32_t Data:32;
    } B;
  } JOUT_IPS;

  union {                              /* JTAG Input Data Register */
    vuint32_t R;
    struct {
      vuint32_t Data:32;
    } B;
  } JIN_IPS;
};


/* ============================================================================
   =============================== Module: JTAGM ==============================
   ============================================================================ */

struct JTAGM_tag {
  union {                              /* Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t SWRESET:1;
      vuint32_t  :17;
      vuint32_t inter_jtag_frame_timer:6;
      vuint32_t  :1;
      vuint32_t SIE:1;
      vuint32_t IIE:1;
      vuint32_t TCKSEL:3;
      vuint32_t jtagm_JCOMP:1;
      vuint32_t DTM:1;
    } B;
  } MCR;

  union {                              /* Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :6;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t JTAGEN:1;
      vuint32_t  :1;
      vuint32_t JTAGSAFE:1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t TOOL:1;
      vuint32_t  :2;
      vuint32_t SPU_INT_CLR:1;
      vuint32_t SPU_INT:1;
      vuint32_t  :1;
      vuint32_t Nexus_err:1;
      vuint32_t Idle:1;
      vuint32_t NR:1;
      vuint32_t  :8;
    } B;
  } SR;

  union {                              /* Data Out Register 0 */
    vuint32_t R;
    struct {
      vuint32_t TMS_HIGH:32;
    } B;
  } DOR0;

  union {                              /* Data Out Register 1 */
    vuint32_t R;
    struct {
      vuint32_t TMS_LOW:28;
      vuint32_t  :4;
    } B;
  } DOR1;

  union {                              /* Data Out Register 2 */
    vuint32_t R;
    struct {
      vuint32_t TDI_HIGH:32;
    } B;
  } DOR2;

  union {                              /* Data Out Register 3 */
    vuint32_t R;
    struct {
      vuint32_t TDI_LOW:28;
      vuint32_t  :3;
      vuint32_t Send:1;
    } B;
  } DOR3;

  uint8_t JTAGM_reserved0[4];
  union {                              /* Data Input Register 0 */
    vuint32_t R;
    struct {
      vuint32_t TDO_LOW:32;
    } B;
  } DIR0;

  union {                              /* Data Input Register 1 */
    vuint32_t R;
    struct {
      vuint32_t TDO_HIGH:28;
      vuint32_t  :4;
    } B;
  } DIR1;
};


/* ============================================================================
   =============================== Module: LFAST ==============================
   ============================================================================ */

struct LFAST_tag {
  union {                              /* LFAST Mode Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t MSEN:1;
      vuint32_t  :6;
      vuint32_t IPGDBG:1;
      vuint32_t  :7;
      vuint32_t LSSEL:1;
      vuint32_t DRFEN:1;
      vuint32_t RXEN:1;
      vuint32_t TXEN:1;
      vuint32_t  :8;
      vuint32_t TXARBD:1;
      vuint32_t CTSEN:1;
      vuint32_t  :1;
      vuint32_t DRFRST:1;
      vuint32_t DATAEN:1;
    } B;
  } MCR;

  union {                              /* LFAST Speed Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :15;
      vuint32_t DRMD:1;
      vuint32_t  :7;
      vuint32_t RDR:1;
      vuint32_t  :7;
      vuint32_t TDR:1;
    } B;
  } SCR;

  union {                              /* LFAST Correlator Control Register */
    vuint32_t R;
    struct {
      vuint32_t SMPSEL:8;
      vuint32_t  :6;
      vuint32_t  :2;
      vuint32_t  :12;
      vuint32_t CORRTH:3;
      vuint32_t PHSSEL:1;
    } B;
  } COCR;

  union {                              /* LFAST Test Mode Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :6;
      vuint32_t CLKTST:1;
      vuint32_t LPON:1;
      vuint32_t  :5;
      vuint32_t LPMOD:3;
      vuint32_t LPFRMTH:16;
    } B;
  } TMCR;

  union {                              /* LFAST Auto Loopback Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :15;
      vuint32_t LPCNTEN:1;
      vuint32_t LPFMCNT:16;
    } B;
  } ALCR;

  union {                              /* LFAST Rate Change Delay Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t DRCNT:4;
      vuint32_t  :16;
    } B;
  } RCDCR;

  union {                              /* LFAST Wakeup Delay Control Register */
    vuint32_t R;
    struct {
      vuint32_t HSCNT:8;
      vuint32_t  :4;
      vuint32_t LSCNT:4;
      vuint32_t HWKCNT:8;
      vuint32_t  :4;
      vuint32_t LWKCNT:4;
    } B;
  } SLCR;

  union {                              /* LFAST ICLC Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :14;
      vuint32_t ICLCSEQ:1;
      vuint32_t SNDICLC:1;
      vuint32_t  :8;
      vuint32_t ICLCPLD:8;
    } B;
  } ICR;

  union {                              /* LFAST Ping Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :15;
      vuint32_t PNGREQ:1;
      vuint32_t PNGAUTO:1;
      vuint32_t  :7;
      vuint32_t PNGPYLD:8;
    } B;
  } PICR;

  uint8_t LFAST_reserved0[8];
  union {                              /* LFAST Rx FIFO CTS Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :10;
      vuint32_t RCTSMX:6;
      vuint32_t  :10;
      vuint32_t RCTSMN:6;
    } B;
  } RFCR;

  union {                              /* LFAST Tx Interrupt Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :14;
      vuint32_t TXIIE:1;
      vuint32_t TXOVIE:1;
      vuint32_t  :11;
      vuint32_t TXPNGIE:1;
      vuint32_t  :1;
      vuint32_t TXUNSIE:1;
      vuint32_t TXICLCIE:1;
      vuint32_t TXDTIE:1;
    } B;
  } TIER;

  union {                              /* LFAST Rx Interrupt Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t RXUOIE:1;
      vuint32_t RXMNIE:1;
      vuint32_t RXMXIE:1;
      vuint32_t RXUFIE:1;
      vuint32_t RXOFIE:1;
      vuint32_t RXSZIE:1;
      vuint32_t RXICIE:1;
      vuint32_t RXLCEIE:1;
      vuint32_t  :12;
      vuint32_t RXCTSIE:1;
      vuint32_t RXDIE:1;
      vuint32_t RXUNSIE:1;
      vuint32_t  :1;
    } B;
  } RIER;

  union {                              /* LFAST Rx ICLC Interrupt Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :18;
      vuint32_t ICPFIE:1;
      vuint32_t ICPSIE:1;
      vuint32_t ICPRIE:1;
      vuint32_t ICTOIE:1;
      vuint32_t ICLPIE:1;
      vuint32_t ICCTIE:1;
      vuint32_t ICTDIE:1;
      vuint32_t ICTEIE:1;
      vuint32_t ICRFIE:1;
      vuint32_t ICRSIE:1;
      vuint32_t ICTFIE:1;
      vuint32_t ICTSIE:1;
      vuint32_t ICPOFIE:1;
      vuint32_t ICPONIE:1;
    } B;
  } RIIER;

  union {                              /* LFAST PLL Control Register */
    vuint32_t R;
    struct {
      vuint32_t IPTMOD:3;
      vuint32_t  :11;
      vuint32_t SWPOFF:1;
      vuint32_t SWPON:1;
      vuint32_t REFINV:1;
      vuint32_t LPCFG:2;
      vuint32_t  :2;
      vuint32_t PLCKCW:2;
      vuint32_t FDIVEN:1;
      vuint32_t FBDIV:6;
      vuint32_t PREDIV:2;
    } B;
  } PLLCR;

  union {                              /* LFAST LVDS Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t SWWKLD:1;
      vuint32_t SWSLPLD:1;
      vuint32_t SWWKLR:1;
      vuint32_t SWSLPLR:1;
      vuint32_t SWOFFLD:1;
      vuint32_t SWONLD:1;
      vuint32_t SWOFFLR:1;
      vuint32_t SWONLR:1;
      vuint32_t LVRXOFF:1;
      vuint32_t LVTXOE:1;
      vuint32_t TXCMUX:1;
      vuint32_t LVRFEN:1;
      vuint32_t LVLPEN:1;
      vuint32_t  :5;
      vuint32_t LVRXOP:3;
      vuint32_t LVTXOP:1;
      vuint32_t LVCKSS:1;
      vuint32_t LVCKP:1;
    } B;
  } LCR;

  union {                              /* LFAST Unsolicited Tx Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :15;
      vuint32_t USNDRQ:1;
      vuint32_t  :9;
      vuint32_t UNSHDR:7;
    } B;
  } UNSTCR;

  union {                              /* LFAST Unsolicited Tx Data Registers */
    vuint32_t R;
    struct {
      vuint32_t UNTXD:32;
    } B;
  } UNSTDR[9];

  uint8_t LFAST_reserved1[20];
  union {                              /* LFAST Global Status Register */
    vuint32_t R;
    struct {
      vuint32_t DUALMD:1;
      vuint32_t  :12;
      vuint32_t LRMD:1;
      vuint32_t LDSM:1;
      vuint32_t DRSM:1;
      vuint32_t  :11;
      vuint32_t LPTXDN:1;
      vuint32_t LPFPDV:1;
      vuint32_t LPCPDV:1;
      vuint32_t LPCHDV:1;
      vuint32_t LPCSDV:1;
    } B;
  } GSR;

  union {                              /* LFAST Ping Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t RXPNGD:8;
    } B;
  } PISR;

  uint8_t LFAST_reserved2[12];
  union {                              /* LFAST Data Frame Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t RXDCNT:6;
      vuint32_t  :5;
      vuint32_t RXFCNT:3;
      vuint32_t  :2;
      vuint32_t TXDCNT:6;
      vuint32_t  :5;
      vuint32_t TXFCNT:3;
    } B;
  } DFSR;

  union {                              /* LFAST Tx Interrupt Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :14;
      vuint32_t TXIEF:1;
      vuint32_t TXOVF:1;
      vuint32_t  :11;
      vuint32_t TXPNGF:1;
      vuint32_t  :1;
      vuint32_t TXUNSF:1;
      vuint32_t TXICLCF:1;
      vuint32_t TXDTF:1;
    } B;
  } TISR;

  union {                              /* LFAST Rx Interrupt Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t RXUOF:1;
      vuint32_t RXMNF:1;
      vuint32_t RXMXF:1;
      vuint32_t RXUFF:1;
      vuint32_t RXOFF:1;
      vuint32_t RXSZF:1;
      vuint32_t RXICF:1;
      vuint32_t RXLCEF:1;
      vuint32_t  :12;
      vuint32_t RXCTSF:1;
      vuint32_t RXDF:1;
      vuint32_t RXUNSF:1;
      vuint32_t  :1;
    } B;
  } RISR;

  union {                              /* LFAST Rx ICLC Interrupt Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :18;
      vuint32_t ICPFF:1;
      vuint32_t ICPSF:1;
      vuint32_t ICPRF:1;
      vuint32_t ICTOF:1;
      vuint32_t ICLPF:1;
      vuint32_t ICCTF:1;
      vuint32_t ICTDF:1;
      vuint32_t ICTEF:1;
      vuint32_t ICRFF:1;
      vuint32_t ICRSF:1;
      vuint32_t ICTFF:1;
      vuint32_t ICTSF:1;
      vuint32_t ICPOFF:1;
      vuint32_t ICPONF:1;
    } B;
  } RIISR;

  union {                              /* LFAST PLL and LVDS Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :14;
      vuint32_t PLLDIS:1;
      vuint32_t PLDCR:1;
      vuint32_t  :12;
      vuint32_t LRSLPS:1;
      vuint32_t LDSLPS:1;
      vuint32_t LDPDS:1;
      vuint32_t LRPDS:1;
    } B;
  } PLLLSR;

  union {                              /* LFAST Unsolicited Rx Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :23;
      vuint32_t URXDV:1;
      vuint32_t  :5;
      vuint32_t URPCNT:3;
    } B;
  } UNSRSR;

  union {                              /* LFAST Unsolicited Rx Data Register */
    vuint32_t R;
    struct {
      vuint32_t UNRXD:32;
    } B;
  } UNSRDR[9];
};


/* ============================================================================
   =============================== Module: LINFlexD ===========================
   ============================================================================ */

struct LINFlexD_tag {
  union {                              /* LIN Control Register 1 */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CCD:1;
      vuint32_t CFD:1;
      vuint32_t LASE:1;
      vuint32_t AUTOWU:1;
      vuint32_t MBL:4;
      vuint32_t BF:1;
      vuint32_t  :1;
      vuint32_t LBKM:1;
      vuint32_t MME:1;
      vuint32_t SSBL:1;
      vuint32_t RBLM:1;
      vuint32_t SLEEP:1;
      vuint32_t INIT:1;
    } B;
  } LINCR1;

  union {                              /* LIN Interrupt enable register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SZIE:1;
      vuint32_t OCIE:1;
      vuint32_t BEIE:1;
      vuint32_t CEIE:1;
      vuint32_t HEIE:1;
      vuint32_t  :2;
      vuint32_t FEIE:1;
      vuint32_t BOIE:1;
      vuint32_t LSIE:1;
      vuint32_t WUIE:1;
      vuint32_t DBFIE:1;
      vuint32_t DBEIETOIE:1;
      vuint32_t DRIE:1;
      vuint32_t DTIE:1;
      vuint32_t HRIE:1;
    } B;
  } LINIER;

  union {                              /* LIN Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t AUTOSYNC_COMP:1;
      vuint32_t RDC:3;
      vuint32_t LINS:4;                /* LIN state */
      vuint32_t  :2;
      vuint32_t RMB:1;
      vuint32_t DRBNE:1;
      vuint32_t RXbusy:1;
      vuint32_t RDI:1;
      vuint32_t WUF:1;
      vuint32_t DBFF:1;
      vuint32_t DBEF:1;
      vuint32_t DRF:1;
      vuint32_t DTF:1;
      vuint32_t HRF:1;
    } B;
  } LINSR;

  union {                              /* LIN Error Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SZF:1;
      vuint32_t OCF:1;
      vuint32_t BEF:1;
      vuint32_t CEF:1;
      vuint32_t SFEF:1;
      vuint32_t SDEF:1;
      vuint32_t IDPEF:1;
      vuint32_t FEF:1;
      vuint32_t BOF:1;
      vuint32_t  :6;
      vuint32_t NF:1;
    } B;
  } LINESR;

  union {                              /* UART Mode Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t  :8;
      vuint32_t NEF:3;
      vuint32_t DTU_PCETX:1;           /* Disable Timeout in UART mode */
      vuint32_t SBUR:2;
      vuint32_t WLS:1;
      vuint32_t TDFL_TFC:3;
      vuint32_t RDFL_RFC:3;
      vuint32_t RFBM:1;
      vuint32_t TFBM:1;
      vuint32_t WL1:1;
      vuint32_t PC1:1;
      vuint32_t RxEn:1;
      vuint32_t TxEn:1;
      vuint32_t PC0:1;
      vuint32_t PCE:1;
      vuint32_t WL0:1;
      vuint32_t UART:1;
    } B;
  } UARTCR;

  union {                              /* UART Mode Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SZF:1;
      vuint32_t OCF:1;
      vuint32_t PE:4;
      vuint32_t RMB:1;
      vuint32_t FEF:1;
      vuint32_t BOF:1;
      vuint32_t RDI:1;
      vuint32_t WUF:1;
      vuint32_t RFNE:1;
      vuint32_t TO:1;
      vuint32_t DRFRFE:1;
      vuint32_t DTFTFF:1;
      vuint32_t NF:1;
    } B;
  } UARTSR;

  union {                              /* LIN Time-Out Control Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :21;
      vuint32_t MODE:1;
      vuint32_t IOT:1;
      vuint32_t TOCE:1;
      vuint32_t CNT:8;
    } B;
  } LINTCSR;

  union {                              /* LIN Output Compare Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t OC2:8;
      vuint32_t OC1:8;
    } B;
  } LINOCR;

  union {                              /* LIN Time-Out Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :20;
      vuint32_t RTO:4;
      vuint32_t  :1;
      vuint32_t HTO:7;
    } B;
  } LINTOCR;

  union {                              /* LIN Fractional Baud Rate Register */
    vuint32_t R;
    struct {
      vuint32_t  :28;
      vuint32_t FBR:4;
    } B;
  } LINFBRR;

  union {                              /* LIN Integer Baud Rate Register */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t IBR:20;
    } B;
  } LINIBRR;

  union {                              /* LIN Checksum Field Register */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t CF:8;
    } B;
  } LINCFR;

  union {                              /* LIN Control Register 2 */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t TBDE:1;
      vuint32_t IOBE:1;
      vuint32_t IOPE:1;
      vuint32_t WURQ:1;
      vuint32_t DDRQ:1;
      vuint32_t DTRQ:1;
      vuint32_t ABRQ:1;
      vuint32_t HTRQ:1;
      vuint32_t  :8;
    } B;
  } LINCR2;

  union {                              /* Buffer Identifier Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t DFL:6;
      vuint32_t DIR:1;
      vuint32_t CCS:1;
      vuint32_t  :2;
      vuint32_t ID:6;
    } B;
  } BIDR;

  union {                              /* Buffer Data Register Least Significant */
    vuint32_t R;
    struct {
      vuint32_t DATA3:8;
      vuint32_t DATA2:8;
      vuint32_t DATA1:8;
      vuint32_t DATA0:8;
    } B;
  } BDRL;

  union {                              /* Buffer Data Register Most Significant */
    vuint32_t R;
    struct {
      vuint32_t DATA7:8;
      vuint32_t DATA6:8;
      vuint32_t DATA5:8;
      vuint32_t DATA4:8;
    } B;
  } BDRM;

  union {                              /* Identifier Filter Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t FACT:16;
    } B;
  } IFER;

  union {                              /* Identifier Filter Match Index */
    vuint32_t R;
    struct {
      vuint32_t  :27;
      vuint32_t IFMI:5;
    } B;
  } IFMI;

  union {                              /* Identifier Filter Mode Register */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t IFM:8;
    } B;
  } IFMR;

  union {                              /* Identifier Filter Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t DFL:6;                 /* Data Field Length */
      vuint32_t DIR:1;                 /* Direction */
      vuint32_t CCS:1;                 /* Classic Checksum */
      vuint32_t  :2;
      vuint32_t ID:6;                  /* Identifier */
    } B;
  } IFCR[16];

  union {                              /* Global Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t TDFBM:1;
      vuint32_t RDFBM:1;
      vuint32_t TDLIS:1;
      vuint32_t RDLIS:1;
      vuint32_t STOP:1;
      vuint32_t SR:1;
    } B;
  } GCR;

  union {                              /* UART Preset Timeout Register */
    vuint32_t R;
    struct {
      vuint32_t  :20;
      vuint32_t PTO:12;
    } B;
  } UARTPTO;

  union {                              /* UART Current Timeout Register */
    vuint32_t R;
    struct {
      vuint32_t  :20;
      vuint32_t CTO:12;
    } B;
  } UARTCTO;

  union {                              /* DMA Tx Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t DTE:16;
    } B;
  } DMATXE;

  union {                              /* DMA Rx Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t DRE:16;
    } B;
  } DMARXE;
};


/* ============================================================================
   =============================== Module: MC_CGM =============================
   ============================================================================ */

struct MC_CGM_tag {
  uint8_t MC_CGM_reserved0[1792];
  union {                              /* PCS Switch Duration */
    vuint8_t R;
    struct {
      vuint8_t SDUR:8;
    } B;
  } PCS_SDUR;

  uint8_t MC_CGM_reserved1[3];
  union {                              /* PCS Divider Change for external crystal oscillator */
    vuint32_t R;
    struct {
      vuint32_t INIT:16;
      vuint32_t  :8;
      vuint32_t RATE:8;
    } B;
  } PCS_DIVC1;

  union {                              /* PCS Divider End for external crystal oscillator */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t DIVE:20;
    } B;
  } PCS_DIVE1;

  union {                              /* PCS Divider Start for external crystal oscillator */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t DIVS:20;
    } B;
  } PCS_DIVS1;

  union {                              /* PCS Divider Change for PLL0 PHI */
    vuint32_t R;
    struct {
      vuint32_t INIT:16;
      vuint32_t  :8;
      vuint32_t RATE:8;
    } B;
  } PCS_DIVC2;

  union {                              /* PCS Divider End for PLL0 PHI */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t DIVE:20;
    } B;
  } PCS_DIVE2;

  union {                              /* PCS Divider Start for PLL0 PHI */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t DIVS:20;
    } B;
  } PCS_DIVS2;

  uint8_t MC_CGM_reserved2[12];
  union {                              /* PCS Divider Change for PLL1 PHI */
    vuint32_t R;
    struct {
      vuint32_t INIT:16;
      vuint32_t  :8;
      vuint32_t RATE:8;
    } B;
  } PCS_DIVC4;

  union {                              /* PCS Divider End for PLL1 PHI */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t DIVE:20;
    } B;
  } PCS_DIVE4;

  union {                              /* PCS Divider Start for PLL1 PHI */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t DIVS:20;
    } B;
  } PCS_DIVS4;

  uint8_t MC_CGM_reserved3[156];
  union {                              /* System Clock Divider Ratio Change Register */
    vuint32_t R;
    struct {
      vuint32_t  :31;
      vuint32_t SYS_DIV_RATIO_CHNG:1;
    } B;
  } SC_DIV_RC;

  union {                              /* Divider Update Type */
    vuint32_t R;
    struct {
      vuint32_t SYS_UPD_TYPE:1;
      vuint32_t  :20;
      vuint32_t AUX10_UPD_TYPE:1;
      vuint32_t AUX9_UPD_TYPE:1;
      vuint32_t AUX8_UPD_TYPE:1;
      vuint32_t  :1;
      vuint32_t AUX6_UPD_TYPE:1;
      vuint32_t AUX5_UPD_TYPE:1;
      vuint32_t  :2;
      vuint32_t AUX2_UPD_TYPE:1;
      vuint32_t AUX1_UPD_TYPE:1;
      vuint32_t AUX0_UPD_TYPE:1;
    } B;
  } DIV_UPD_TYPE;

  union {                              /* Divider Update Trigger */
    vuint32_t R;
    struct {
      vuint32_t DIV_UPD_TRIGGER:32;
    } B;
  } DIV_UPD_TRIG;

  union {                              /* Divider Update Status */
    vuint32_t R;
    struct {
      vuint32_t SYS_UPD_STAT:1;
      vuint32_t  :20;
      vuint32_t AUX10_UPD_STAT:1;
      vuint32_t AUX9_UPD_STAT:1;
      vuint32_t AUX8_UPD_STAT:1;
      vuint32_t  :1;
      vuint32_t AUX6_UPD_STAT:1;
      vuint32_t AUX5_UPD_STAT:1;
      vuint32_t  :2;
      vuint32_t AUX2_UPD_STAT:1;
      vuint32_t AUX1_UPD_STAT:1;
      vuint32_t AUX0_UPD_STAT:1;
    } B;
  } DIV_UPD_STAT;

  uint8_t MC_CGM_reserved4[4];
  union {                              /* System Clock Select Status */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t SELSTAT:4;
      vuint32_t  :4;
      vuint32_t SWTRG:3;
      vuint32_t SWIP:1;
      vuint32_t  :16;
    } B;
  } SC_SS;

  union {                              /* System Clock Divider Configuration 0 */
    vuint32_t R;
    struct {
      vuint32_t DE:1;
      vuint32_t  :9;
      vuint32_t DIV:6;
      vuint32_t  :16;
    } B;
  } SC_DC[3];

  uint8_t MC_CGM_reserved5[12];
  union {                              /* Aux Clock 0 Select Control */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t SELCTL:4;
      vuint32_t  :24;
    } B;
  } AC0_SC;

  union {                              /* Aux Clock 0 Select Status */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t SELSTAT:4;
      vuint32_t  :24;
    } B;
  } AC0_SS;

  union {                              /* Aux Clock 0 Divider Configuration 0 */
    vuint32_t R;
    struct {
      vuint32_t DE:1;
      vuint32_t  :11;
      vuint32_t DIV:4;
      vuint32_t  :16;
    } B;
  } AC0_DC0;

  union {                              /* Aux Clock 0 Divider Configuration 1 */
    vuint32_t R;
    struct {
      vuint32_t DE:1;
      vuint32_t  :8;
      vuint32_t DIV:7;
      vuint32_t  :16;
    } B;
  } AC0_DC1;

  union {                              /* Aux Clock 0 Divider Configuration 2 */
    vuint32_t R;
    struct {
      vuint32_t DE:1;
      vuint32_t  :8;
      vuint32_t DIV:7;
      vuint32_t  :16;
    } B;
  } AC0_DC2;

  union {                              /* Aux Clock 0 Divider Configuration 3 */
    vuint32_t R;
    struct {
      vuint32_t DE:1;
      vuint32_t  :2;
      vuint32_t DIV:13;
      vuint32_t  :14;
      vuint32_t DIV_FMT:2;
    } B;
  } AC0_DC3;

  union {                              /* Aux Clock 0 Divider Configuration 4 */
    vuint32_t R;
    struct {
      vuint32_t DE:1;
      vuint32_t  :9;
      vuint32_t DIV:6;
      vuint32_t  :16;
    } B;
  } AC0_DC4;

  uint8_t MC_CGM_reserved6[4];
  union {                              /* Aux Clock 1 Select Control */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t SELCTL:4;
      vuint32_t  :24;
    } B;
  } AC1_SC;

  union {                              /* Aux Clock 1 Select Status */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t SELSTAT:4;
      vuint32_t  :24;
    } B;
  } AC1_SS;

  union {                              /* Aux Clock 1 Divider Configuration 0 */
    vuint32_t R;
    struct {
      vuint32_t DE:1;
      vuint32_t  :8;
      vuint32_t DIV:7;
      vuint32_t  :16;
    } B;
  } AC1_DC0;

  uint8_t MC_CGM_reserved7[20];
  union {                              /* Aux Clock 2 Select Control */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t SELCTL:4;
      vuint32_t  :24;
    } B;
  } AC2_SC;

  union {                              /* Aux Clock 2 Select Status */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t SELSTAT:4;
      vuint32_t  :24;
    } B;
  } AC2_SS;

  union {                              /* Aux Clock 2 Divider Configuration 0 */
    vuint32_t R;
    struct {
      vuint32_t DE:1;
      vuint32_t  :9;
      vuint32_t DIV:6;
      vuint32_t  :16;
    } B;
  } AC2_DC0;

  uint8_t MC_CGM_reserved8[20];
  union {                              /* Aux Clock 3 Select Control */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t SELCTL:4;
      vuint32_t  :24;
    } B;
  } AC3_SC;

  union {                              /* Aux Clock 3 Select Status */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t SELSTAT:4;
      vuint32_t  :24;
    } B;
  } AC3_SS;

  uint8_t MC_CGM_reserved9[24];
  union {                              /* Aux Clock 4 Select Control */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t SELCTL:4;
      vuint32_t  :24;
    } B;
  } AC4_SC;

  union {                              /* Aux Clock 4 Select Status */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t SELSTAT:4;
      vuint32_t  :24;
    } B;
  } AC4_SS;

  uint8_t MC_CGM_reserved10[24];
  union {                              /* Aux Clock 5 Select Control */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t SELCTL:4;
      vuint32_t  :24;
    } B;
  } AC5_SC;

  union {                              /* Aux Clock 5 Select Status */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t SELSTAT:4;
      vuint32_t  :24;
    } B;
  } AC5_SS;

  union {                              /* Aux Clock 5 Divider Configuration 0 */
    vuint32_t R;
    struct {
      vuint32_t DE:1;
      vuint32_t  :9;
      vuint32_t DIV:6;
      vuint32_t  :16;
    } B;
  } AC5_DC0;

  union {                              /* Aux Clock 5 Divider Configuration 1 */
    vuint32_t R;
    struct {
      vuint32_t DE:1;
      vuint32_t  :9;
      vuint32_t DIV:6;
      vuint32_t  :16;
    } B;
  } AC5_DC1;

  uint8_t MC_CGM_reserved11[16];
  union {                              /* Aux Clock 6 Select Control */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t SELCTL:4;
      vuint32_t  :24;
    } B;
  } AC6_SC;

  union {                              /* Aux Clock 6 Select Status */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t SELSTAT:4;
      vuint32_t  :24;
    } B;
  } AC6_SS;

  union {                              /* Aux Clock 6 Divider Configuration 0 */
    vuint32_t R;
    struct {
      vuint32_t DE:1;
      vuint32_t  :9;
      vuint32_t DIV:6;
      vuint32_t  :16;
    } B;
  } AC6_DC0;

  uint8_t MC_CGM_reserved12[52];
  union {                              /* Aux Clock 8 Select Control */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t SELCTL:4;
      vuint32_t  :24;
    } B;
  } AC8_SC;

  union {                              /* Aux Clock 8 Select Status */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t SELSTAT:4;
      vuint32_t  :24;
    } B;
  } AC8_SS;

  union {                              /* Aux Clock 8 Divider Configuration 0 */
    vuint32_t R;
    struct {
      vuint32_t DE:1;
      vuint32_t  :9;
      vuint32_t DIV:6;
      vuint32_t  :16;
    } B;
  } AC8_DC0;

  uint8_t MC_CGM_reserved13[20];
  union {                              /* Aux Clock 9 Select Control */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t SELCTL:4;
      vuint32_t  :24;
    } B;
  } AC9_SC;

  union {                              /* Aux Clock 9 Select Status */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t SELSTAT:4;
      vuint32_t  :24;
    } B;
  } AC9_SS;

  union {                              /* Aux Clock 9 Divider Configuration 0 */
    vuint32_t R;
    struct {
      vuint32_t DE:1;
      vuint32_t  :9;
      vuint32_t DIV:6;
      vuint32_t  :16;
    } B;
  } AC9_DC0;

  uint8_t MC_CGM_reserved14[20];
  union {                              /* Aux Clock 10 Select Control */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t SELCTL:4;
      vuint32_t  :24;
    } B;
  } AC10_SC;

  union {                              /* Aux Clock 10 Select Status */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t SELSTAT:4;
      vuint32_t  :24;
    } B;
  } AC10_SS;

  union {                              /* Aux Clock 10 Divider Configuration 0 */
    vuint32_t R;
    struct {
      vuint32_t DE:1;
      vuint32_t  :11;
      vuint32_t DIV:4;
      vuint32_t  :16;
    } B;
  } AC10_DC0;
};


/* ============================================================================
   =============================== Module: MC_ME ==============================
   ============================================================================ */

struct MC_ME_tag {
  union {                              /* Global Status */
    vuint32_t R;
    struct {
      vuint32_t S_CURRENT_MODE:4;
      vuint32_t S_MTRANS:1;
      vuint32_t  :1;
      vuint32_t  :2;
      vuint32_t S_PDO:1;
      vuint32_t  :2;
      vuint32_t S_MVR:1;
      vuint32_t  :2;
      vuint32_t S_FLA:2;
      vuint32_t  :8;
      vuint32_t S_PLL1:1;
      vuint32_t S_PLL0:1;
      vuint32_t S_XOSC:1;
      vuint32_t S_IRC:1;
      vuint32_t S_SYSCLK:4;
    } B;
  } GS;

  union {                              /* Mode Control */
    vuint32_t R;
    struct {
      vuint32_t TARGET_MODE:4;
      vuint32_t  :12;
      vuint32_t KEY:16;
    } B;
  } MCTL;

  union {                              /* Mode Enable */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t RESET_DEST:1;
      vuint32_t  :4;
      vuint32_t STOP0:1;
      vuint32_t  :1;
      vuint32_t HALT0:1;
      vuint32_t RUN3:1;
      vuint32_t RUN2:1;
      vuint32_t RUN1:1;
      vuint32_t RUN0:1;
      vuint32_t DRUN:1;
      vuint32_t SAFE:1;
      vuint32_t TEST:1;
      vuint32_t RESET_FUNC:1;
    } B;
  } ME;

  union {                              /* Interrupt Status */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t I_ICONF_CC:1;
      vuint32_t I_CONF_CU:1;
      vuint32_t I_ICONF:1;
      vuint32_t I_IMODE:1;
      vuint32_t I_SAFE:1;
      vuint32_t I_MTC:1;
    } B;
  } IS;

  union {                              /* Interrupt Mask */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t M_ICONF_CC:1;
      vuint32_t M_ICONF_CU:1;
      vuint32_t M_ICONF:1;
      vuint32_t M_IMODE:1;
      vuint32_t M_SAFE:1;
      vuint32_t M_MTC:1;
    } B;
  } IM;

  union {                              /* Invalid Mode Transition Status */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t S_MRIG:1;
      vuint32_t S_MTI:1;
      vuint32_t S_MRI:1;
      vuint32_t S_DMA:1;
      vuint32_t S_NMA:1;
      vuint32_t S_SEA:1;
    } B;
  } IMTS;

  union {                              /* Debug Mode Transition Status */
    vuint32_t R;
    struct {
      vuint32_t PREVIOUS_MODE:4;
      vuint32_t  :4;
      vuint32_t MPH_BUSY:1;
      vuint32_t  :2;
      vuint32_t PMC_PROG:1;
      vuint32_t DBG_MODE:1;
      vuint32_t CCKL_PROG:1;
      vuint32_t PCS_PROG:1;
      vuint32_t SMR:1;
      vuint32_t CDP_PRPH_0_255:1;
      vuint32_t VREG_CSRC_SC:1;
      vuint32_t CSRC_CSRC_SC:1;
      vuint32_t IRC_SC:1;
      vuint32_t SCSRC_SC:1;
      vuint32_t SYSCLK_SW:1;
      vuint32_t  :1;
      vuint32_t FLASH_SC:1;
      vuint32_t CDP_PRPH_244_255:1;
      vuint32_t CDP_PRPH_192_223:1;
      vuint32_t CDP_PRPH_160_191:1;
      vuint32_t CDP_PRPH_128_159:1;
      vuint32_t CDP_PRPH_96_127:1;
      vuint32_t CDP_PRPH_64_95:1;
      vuint32_t CDP_PRPH_32_63:1;
      vuint32_t CDP_PRPH_0_31:1;
    } B;
  } DMTS;

  uint8_t MC_ME_reserved0[4];
  union {                              /* RESET Mode Configuration */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t PWRLVL:3;
      vuint32_t  :4;
      vuint32_t PDO:1;
      vuint32_t  :2;
      vuint32_t MVRON:1;
      vuint32_t  :2;
      vuint32_t FLAON:2;
      vuint32_t  :8;
      vuint32_t PLL1ON:1;
      vuint32_t PLL0ON:1;
      vuint32_t XOSCON:1;
      vuint32_t IRCON:1;
      vuint32_t SYSCLK:4;
    } B;
  } RESET_MC;

  union {                              /* TEST Mode Configuration */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t PWRLVL:3;
      vuint32_t  :4;
      vuint32_t PDO:1;
      vuint32_t  :2;
      vuint32_t MVRON:1;
      vuint32_t  :2;
      vuint32_t FLAON:2;
      vuint32_t  :8;
      vuint32_t PLL10N:1;
      vuint32_t PLL0ON:1;
      vuint32_t XOSCON:1;
      vuint32_t IRCON:1;
      vuint32_t SYSCLK:4;
    } B;
  } TEST_MC;

  union {                              /* SAFE Mode Configuration */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t PWRLVL:3;
      vuint32_t  :4;
      vuint32_t PDO:1;
      vuint32_t  :2;
      vuint32_t MVRON:1;
      vuint32_t  :2;
      vuint32_t FLAON:2;
      vuint32_t  :8;
      vuint32_t PLL1ON:1;
      vuint32_t PLL0ON:1;
      vuint32_t XOSCON:1;
      vuint32_t IRCON:1;
      vuint32_t SYSCLK:4;
    } B;
  } SAFE_MC;

  union {                              /* DRUN Mode Configuration */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t PWRLVL:3;
      vuint32_t  :4;
      vuint32_t PDO:1;
      vuint32_t  :2;
      vuint32_t MVRON:1;
      vuint32_t  :2;
      vuint32_t FLAON:2;
      vuint32_t  :8;
      vuint32_t PLL1ON:1;
      vuint32_t PLL0ON:1;
      vuint32_t XOSCON:1;
      vuint32_t IRCON:1;
      vuint32_t SYSCLK:4;
    } B;
  } DRUN_MC;

  union {                              /* RUN0 Mode Configuration */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t PWRLVL:3;
      vuint32_t  :4;
      vuint32_t PDO:1;
      vuint32_t  :2;
      vuint32_t MVRON:1;
      vuint32_t  :2;
      vuint32_t FLAON:2;
      vuint32_t  :8;
      vuint32_t PLL1ON:1;
      vuint32_t PLL0ON:1;
      vuint32_t XOSCON:1;
      vuint32_t IRCON:1;
      vuint32_t SYSCLK:4;
    } B;
  } RUN_MC[4];

  union {                              /* HALT0 Mode Configuration */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t PWRLVL:3;
      vuint32_t  :4;
      vuint32_t PDO:1;
      vuint32_t  :2;
      vuint32_t MVRON:1;
      vuint32_t  :2;
      vuint32_t FLAON:2;
      vuint32_t  :8;
      vuint32_t PLL1ON:1;
      vuint32_t PLL0ON:1;
      vuint32_t XOSCON:1;
      vuint32_t IRCON:1;
      vuint32_t SYSCLK:4;
    } B;
  } HALT0_MC;

  uint8_t MC_ME_reserved1[4];
  union {                              /* STOP0 Mode Configuration */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t PWRLVL:3;
      vuint32_t  :4;
      vuint32_t PDO:1;
      vuint32_t  :2;
      vuint32_t MVRON:1;
      vuint32_t  :2;
      vuint32_t FLAON:2;
      vuint32_t  :8;
      vuint32_t PLL1ON:1;
      vuint32_t PLL0ON:1;
      vuint32_t XOSCON:1;
      vuint32_t IRCON:1;
      vuint32_t SYSCLK:4;
    } B;
  } STOP0_MC;

  uint8_t MC_ME_reserved2[20];
  union {                              /* Peripheral Status 0 */
    vuint32_t R;
    struct {
      vuint32_t S_PIT_RTI_1:1;
      vuint32_t S_PIT_RTI_0:1;
      vuint32_t S_DECFILT_0:1;
      vuint32_t S_DECFILT_1:1;
      vuint32_t  :12;
      vuint32_t S_SIUL2_0:1;
      vuint32_t  :3;
      vuint32_t S_SIPI_0:1;
      vuint32_t  :1;
      vuint32_t S_LFAST_0:1;
      vuint32_t  :9;
    } B;
  } PS0;

  union {                              /* Peripheral Status 1 */
    vuint32_t R;
    struct {
      vuint32_t  :3;
      vuint32_t S_ADCSD_0:1;
      vuint32_t S_ADCSD_2:1;
      vuint32_t  :13;
      vuint32_t S_JTAGM_0:1;
      vuint32_t  :6;
      vuint32_t S_CRC_0:1;
      vuint32_t  :1;
      vuint32_t S_DMA_CH_MUX0_2:1;
      vuint32_t  :4;
    } B;
  } PS1;

  union {                              /* Peripheral Status 2 */
    vuint32_t R;
    struct {
      vuint32_t  :3;
      vuint32_t S_LINFLEX_0:1;
      vuint32_t S_LINFLEX_2:1;
      vuint32_t  :5;
      vuint32_t S_LINFLEX_M0:1;
      vuint32_t  :1;
      vuint32_t S_FLEXCAN_0:1;
      vuint32_t  :1;
      vuint32_t S_FLEXCAN_2:1;
      vuint32_t  :9;
      vuint32_t S_ADCSAR_0:1;
      vuint32_t  :1;
      vuint32_t S_ADCSAR_2:1;
      vuint32_t  :5;
    } B;
  } PS2;

  union {                              /* Peripheral Status 3 */
    vuint32_t R;
    struct {
      vuint32_t  :23;
      vuint32_t S_SENT_0:1;
      vuint32_t  :1;
      vuint32_t S_EMIOS_0:1;
      vuint32_t  :2;
      vuint32_t S_DSPI_0:1;
      vuint32_t S_DSPI_2:1;
      vuint32_t S_DSPI_4:1;
      vuint32_t S_DSPI_M0:1;
    } B;
  } PS3;

  union {                              /* Peripheral Status 4 */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t S_DMA_CH_MUX3:1;
      vuint32_t  :15;
    } B;
  } PS4;

  union {                              /* Peripheral Status 5 */
    vuint32_t R;
    struct {
      vuint32_t  :3;
      vuint32_t ADC_SD1:1;
      vuint32_t  :21;
      vuint32_t CRC_1:1;
      vuint32_t  :6;
    } B;
  } PS5;

  union {                              /* Peripheral Status 6 */
    vuint32_t R;
    struct {
      vuint32_t  :3;
      vuint32_t LINFLEX_1:1;
      vuint32_t LINFLEX_3:1;
      vuint32_t  :5;
      vuint32_t LINFLEX_M1:1;
      vuint32_t  :2;
      vuint32_t FLEXCAN1:1;
      vuint32_t  :1;
      vuint32_t FLEXCAN3:1;
      vuint32_t ETPU:1;
      vuint32_t REACM:1;
      vuint32_t ETPU_SPRAM0:1;
      vuint32_t ETPU_SPRAM1:1;
      vuint32_t ETPU_SCRAM0:1;
      vuint32_t ETPU_SCRAM1:1;
      vuint32_t  :3;
      vuint32_t ADCSAR_1:1;
      vuint32_t IGF:1;
      vuint32_t ADCSAR_3:1;
      vuint32_t  :4;
    } B;
  } PS6;

  union {                              /* Peripheral Status 7 */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t BCTU_1:1;
      vuint32_t  :18;
      vuint32_t SENT_1:1;
      vuint32_t  :1;
      vuint32_t EMIOS_1:1;
      vuint32_t  :2;
      vuint32_t DSPI_1:1;
      vuint32_t DSPI_3:1;
      vuint32_t DSPI_M1:1;
      vuint32_t  :1;
    } B;
  } PS7;

  union {                              /* Run Peripheral Configuration 0 */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t RUN3:1;
      vuint32_t RUN2:1;
      vuint32_t RUN1:1;
      vuint32_t RUN0:1;
      vuint32_t DRUN:1;
      vuint32_t SAFE:1;
      vuint32_t TEST:1;
      vuint32_t RESET:1;
    } B;
  } RUN_PC[8];

  union {                              /* Low-Power Peripheral Configuration 0 */
    vuint32_t R;
    struct {
      vuint32_t  :21;
      vuint32_t STOP0:1;
      vuint32_t  :1;
      vuint32_t HATL0:1;
      vuint32_t  :8;
    } B;
  } LP_PC[8];

    /* Note on PCTL registers: There are only some PCTL implemented          */
    /*  In order to make the PCTL easily addressable, these are defined      */
    /*  as an array (ie MC_ME.PCTL[x].R). This means you have to be careful  */
    /*  when addressing these registers in order not to access a PCTL that   */
    /*  is not implemented. Following are available: 9, 11, 15, 28-31, 36,   */
    /*  38, 45, 59-60, 69, 71, 81, 83, 85, 91-92, 96-99, 102, 104, 143, 166, */
    /*  188, 196-198, 202-208, 210, 213, 219-220, 225-227, 230, 232, 251     */

  union {
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL[252];

  uint8_t MC_ME_reserved3[4];
  union {                              /* Core Status */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t S_CORE2:1;
      vuint32_t S_CORE1:1;
      vuint32_t S_CORE0:1;
    } B;
  } CS;

  union {                              /* CORE0 Control */
    vuint16_t R;
    struct {
      vuint16_t  :5;
      vuint16_t STOP0:1;
      vuint16_t  :1;
      vuint16_t HALT0:1;
      vuint16_t RUN3:1;
      vuint16_t RUN2:1;
      vuint16_t RUN1:1;
      vuint16_t RUN0:1;
      vuint16_t DRUN:1;
      vuint16_t SAFE:1;
      vuint16_t TEST:1;
      vuint16_t RESET:1;
    } B;
  } CCTL[3];

  uint8_t MC_ME_reserved4[22];
  union {                              /* CORE0 Address */
    vuint32_t R;
    struct {
      vuint32_t ADDR:30;
      vuint32_t  :1;
      vuint32_t RMC:1;
    } B;
  } CADDR[3];
};


/* ============================================================================
   =============================== Module: MC_PCU =============================
   ============================================================================ */

struct MC_PCU_tag {
  uint8_t MC_PCU_reserved0[64];
  union {                              /* Power Domain Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :31;
      vuint32_t PD0:1;
    } B;
  } PSTAT;
};


/* ============================================================================
   =============================== Module: MC_RGM =============================
   ============================================================================ */

struct MC_RGM_tag {
  union {                              /* 'Destructive' Event Status */
    vuint32_t R;
    struct {
      vuint32_t  :6;
      vuint32_t F_PMC:1;               /* Flag for PMC self test failure after boot up (POR) */
      vuint32_t F_VOR:1;               /* Flag for Voltage Out of Range */
      vuint32_t F_TSR:1;               /* Flag for Temperature sensor */
      vuint32_t  :12;
      vuint32_t F_JTAG:1;              /* Flag for JTAG destructive reset */
      vuint32_t F_FIF:1;               /* Flag for Flash Initialization Failure */
      vuint32_t F_EDR:1;               /* Flag for 'Functional' reset Escalation */
      vuint32_t  :1;
      vuint32_t F_SSR:1;               /* Flag for SSCM security reset */
      vuint32_t F_SUF:1;               /* Flag for STCU Unrecoverable Fault */
      vuint32_t F_FFRR:1;              /* Flag for FCCU Failure to React reset */
      vuint32_t F_SOFT_DEST:1;         /* Flag for Software destructive reset */
      vuint32_t  :1;
      vuint32_t F_PORST:1;             /* Flag for External PowerOn reset */
      vuint32_t F_POR:1;               /* Flag for Power-On reset */
    } B;
  } DES;

  uint8_t MC_RGM_reserved0[12];
  union {                              /* 'Destructive' Event Reset Disable */
    vuint32_t R;
    struct {
      vuint32_t  :6;
      vuint32_t D_PMC_STF:1;           /* Disable PMC Self_Test Failure */
      vuint32_t D_VOR:1;
      vuint32_t D_TSR:1;
      vuint32_t  :12;
      vuint32_t D_JTAG:1;
      vuint32_t D_FIF:1;
      vuint32_t D_EDR:1;
      vuint32_t  :2;
      vuint32_t D_SUF:1;
      vuint32_t D_FFRR:1;
      vuint32_t D_SOFT_DEST:1;
      vuint32_t  :1;
      vuint32_t D_PORST:1;
      vuint32_t  :1;
    } B;
  } DERD;

  uint8_t MC_RGM_reserved1[12];
  union {                              /* 'Destructive' Event Alternate Request */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t AR_TSR:1;
      vuint32_t  :21;
      vuint32_t AR_PORST:1;
      vuint32_t  :1;
    } B;
  } DEAR;

  uint8_t MC_RGM_reserved2[12];
  union {                              /* 'Destructive' Bidirectional Reset Enable */
    vuint32_t R;
    struct {
      vuint32_t  :6;
      vuint32_t BE_PMC_STF:1;          /* Bidirectional Reset Enables for PMC Selt Test Failure 'Destructive' Reset */
      vuint32_t BE_VOR:1;
      vuint32_t BE_TSR:1;
      vuint32_t  :12;
      vuint32_t BE_JTAG:1;
      vuint32_t BE_FIF:1;
      vuint32_t BE_EDR:1;
      vuint32_t  :2;
      vuint32_t BE_SUF:1;
      vuint32_t BE_FFRR:1;
      vuint32_t BE_SOFT_DEST:1;
      vuint32_t  :1;
      vuint32_t BE_PORST:1;
      vuint32_t BE_POR:1;
    } B;
  } DBRE;

  uint8_t MC_RGM_reserved3[716];
  union {                              /* 'Functional' Event Status */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t F_VOR_FUNC:1;
      vuint32_t F_TSR_FUNC:1;
      vuint32_t  :12;
      vuint32_t F_JTAG_FUNC:1;
      vuint32_t  :3;
      vuint32_t F_FCCU_SOFT:1;
      vuint32_t F_FCCU_HARD:1;
      vuint32_t  :1;
      vuint32_t F_SOFT_FUNC:1;
      vuint32_t F_ST_DONE:1;
      vuint32_t  :1;
      vuint32_t F_EXR:1;
    } B;
  } FES;

  uint8_t MC_RGM_reserved4[12];
  union {                              /* 'Functional' Event Reset Disable */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t D_VOR_FUNC:1;          /* Disable Voltage Out of Range 'Functional' Reset */
      vuint32_t D_TSR_FUNC:1;
      vuint32_t  :12;
      vuint32_t D_JTAG_FUNC:1;         /* Disable JTAG 'Functional' Reset */
      vuint32_t  :3;
      vuint32_t D_FCCU_SOFT:1;
      vuint32_t D_FCCU_HARD:1;
      vuint32_t  :1;
      vuint32_t D_SOFT_FUNC:1;
      vuint32_t D_ST_DONE:1;
      vuint32_t  :2;
    } B;
  } FERD;

  uint8_t MC_RGM_reserved5[12];
  union {                              /* 'Functional' Event Alternate Request */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t AR_VOR_FUNC:1;
      vuint32_t AR_TSR_FUNC:1;
      vuint32_t  :23;
    } B;
  } FEAR;

  uint8_t MC_RGM_reserved6[12];
  union {                              /* 'Functional' Bidirectional Reset Enable */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t BE_VOR_FUNC:1;
      vuint32_t BE_TSR_FUNC:1;         /* Bidirectional Reset Enable for Temperature Sensor 'Functional' Reset */
      vuint32_t  :12;
      vuint32_t BE_JTAG_FUNC:1;
      vuint32_t  :3;
      vuint32_t BE_FCCU_SOFT:1;
      vuint32_t BE_FCCU_HARD:1;
      vuint32_t  :1;
      vuint32_t BE_SOFT_FUNC:1;
      vuint32_t BE_ST_DONE:1;
      vuint32_t  :1;
      vuint32_t BE_ESR0:1;
    } B;
  } FBRE;

  uint8_t MC_RGM_reserved7[12];
  union {                              /* 'Functional' Event Short Sequence */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t SS_VOR_FUNC:1;
      vuint32_t SS_TSR_FUNC:1;
      vuint32_t  :12;
      vuint32_t SS_JTAG_FUNC:1;
      vuint32_t  :3;
      vuint32_t SS_FCCU_SOFT:1;
      vuint32_t SS_FCCU_HARD:1;
      vuint32_t  :1;
      vuint32_t SS_SOFT_FUNC:1;
      vuint32_t SS_ST_DONE:1;
      vuint32_t  :1;
      vuint32_t SS_EXR:1;
    } B;
  } FESS;

  uint8_t MC_RGM_reserved8[704];
  union {                              /* Functional Reset Threshold */
    vuint8_t R;
    struct {
      vuint8_t  :4;
      vuint8_t FRET:4;
    } B;
  } FRET;

  uint8_t MC_RGM_reserved9[3];
  union {                              /* 'Destructive' Reset Threshold */
    vuint8_t R;
    struct {
      vuint8_t  :4;
      vuint8_t DRET:4;
    } B;
  } DRET;
};


/* ============================================================================
   =============================== Module: MEMU ===============================
   ============================================================================ */

struct MEMU_tag {
  union {                              /* Control register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SWR:1;
      vuint32_t  :15;
    } B;
  } CTRL;

  union {                              /* Error flag register */
    vuint32_t R;
    struct {
      vuint32_t  :11;
      vuint32_t PR_CE:1;
      vuint32_t PR_UCE:1;
      vuint32_t PR_CEO:1;
      vuint32_t PR_UCO:1;
      vuint32_t PR_EBO:1;
      vuint32_t  :3;
      vuint32_t F_CE:1;
      vuint32_t F_UCE:1;
      vuint32_t F_CEO:1;
      vuint32_t F_UCO:1;
      vuint32_t F_EBO:1;
      vuint32_t  :3;
      vuint32_t SR_CE:1;
      vuint32_t SR_UCE:1;
      vuint32_t SR_CEO:1;
      vuint32_t SR_UCO:1;
      vuint32_t SR_EBO:1;
    } B;
  } ERR_FLAG;

  uint8_t MEMU_reserved0[4];
  union {                              /* Debug register */
    vuint32_t R;
    struct {
      vuint32_t  :11;
      vuint32_t FR_PR_CE:1;
      vuint32_t FR_PR_UCE:1;
      vuint32_t FR_PR_CEO:1;
      vuint32_t FR_PR_UCO:1;
      vuint32_t FR_PR_EBO:1;
      vuint32_t  :3;
      vuint32_t FR_F_CE:1;
      vuint32_t FR_F_UCE:1;
      vuint32_t FR_F_CEO:1;
      vuint32_t FR_F_UCO:1;
      vuint32_t FR_F_EBO:1;
      vuint32_t  :3;
      vuint32_t FR_SR_CE:1;
      vuint32_t FR_SR_UCE:1;
      vuint32_t FR_SR_CEO:1;
      vuint32_t FR_SR_UCO:1;
      vuint32_t FR_SR_EBO:1;
    } B;
  } DEBUG;

  uint8_t MEMU_reserved1[16];
  struct {
    union {                            /* System RAM correctable error reporting table status register */
      vuint32_t R;
      struct {
        vuint32_t VLD:1;
        vuint32_t  :23;
        vuint32_t BAD_BIT:8;
      } B;
    } STS;
    union {                            /* System RAM correctable error reporting table address register */
      vuint32_t R;
      struct {
        vuint32_t ERR_ADD:32;
      } B;
    } ADDR;
  } SYS_RAM_CERR[10];

  union {                              /* System RAM uncorrectable error reporting table status register */
    vuint32_t R;
    struct {
      vuint32_t VLD:1;
      vuint32_t  :31;
    } B;
  } SYS_RAM_UNCERR_STS;

  union {                              /* System RAM uncorrectable error reporting table address register */
    vuint32_t R;
    struct {
      vuint32_t ERR_ADD:32;
    } B;
  } SYS_RAM_UNCERR_ADDR;

  union {                              /* System RAM concurrent overflow register */
    vuint32_t R;
    struct {
      vuint32_t OFLW:32;
    } B;
  } SYS_RAM_OFLW[1];

  uint8_t MEMU_reserved2[1444];
  struct {
    union {                            /* Peripheral RAM correctable error reporting table status register */
      vuint32_t R;
      struct {
        vuint32_t VLD:1;
        vuint32_t  :23;
        vuint32_t BAD_BIT:8;
      } B;
    } STS;
    union {                            /* Peripheral RAM correctable error reporting table address register */
      vuint32_t R;
      struct {
        vuint32_t ERR_ADD:32;
      } B;
    } ADDR;
  } PERIPH_RAM_CERR[2];

  union {                              /* Peripheral RAM uncorrectable error reporting table status register */
    vuint32_t R;
    struct {
      vuint32_t VLD:1;
      vuint32_t  :31;
    } B;
  } PERIPH_RAM_UNCERR_STS;

  union {                              /* Peripheral RAM uncorrectable error reporting table address register */
    vuint32_t R;
    struct {
      vuint32_t ERR_ADD:32;
    } B;
  } PERIPH_RAM_UNCERR_ADDR;

  union {                              /* Peripheral RAM concurrent overflow register */
    vuint32_t R;
    struct {
      vuint32_t OFLW:32;
    } B;
  } PERIPH_RAM_OFLW0;

  uint8_t MEMU_reserved3[1508];
  struct {
    union {                            /* Flash memory correctable error reporting table status register */
      vuint32_t R;
      struct {
        vuint32_t VLD:1;
        vuint32_t  :23;
        vuint32_t BAD_BIT:8;
      } B;
    } STS;
    union {                            /* Flash memory correctable error reporting table address register */
      vuint32_t R;
      struct {
        vuint32_t ERR_ADD:32;
      } B;
    } ADDR;
  } FLASH_CERR[20];

  union {                              /* Flash memory uncorrectable error reporting table status register */
    vuint32_t R;
    struct {
      vuint32_t VLD:1;
      vuint32_t  :31;
    } B;
  } FLASH_UNCERR_STS;

  union {                              /* Flash memory uncorrectable error reporting table address register */
    vuint32_t R;
    struct {
      vuint32_t ERR_ADD:32;
    } B;
  } FLASH_UNCERR_ADDR;

  union {                              /* Flash memory concurrent overflow register */
    vuint32_t R;
    struct {
      vuint32_t OFLW:32;
    } B;
  } FLASH_OFLW0;
};


/* ============================================================================
   =============================== Module: PASS ===============================
   ============================================================================ */

struct PASS_tag {
  union {                              /* Life Cycle Status Register */
    vuint32_t R;
    struct {
      vuint32_t CNS:1;
      vuint32_t JUN:1;
      vuint32_t  :1;
      vuint32_t  :21;
      vuint32_t LIFE:8;
    } B;
  } LCSTAT;

  uint8_t PASS_reserved0[4];
  union {                              /* Challenge Selector Register */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t GRP:2;
    } B;
  } CHSEL;

  uint8_t PASS_reserved1[4];
  union {                              /* Challenge Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :28;
      vuint32_t CMST:4;
    } B;
  } CSTAT;

  uint8_t PASS_reserved2[12];
  union {                              /* Challenge Input Register */
    vuint32_t R;
    struct {
      vuint32_t PW32:32;
    } B;
  } CIN[8];

  uint8_t PASS_reserved3[192];
  struct {
    union {                            /* Password Group n - Lock 0 Status Register */
      vuint32_t R;
      struct {
        vuint32_t TSLOCK:1;
        vuint32_t ATSL:1;
        vuint32_t LOWLOCK:14;
        vuint32_t MIDLOCK:16;
      } B;
    } LOCK0;
    union {                            /* Password Group n - Lock 1 Status Register */
      vuint32_t R;
      struct {
        vuint32_t  :16;
        vuint32_t HIGHLOCK:16;
      } B;
    } LOCK1;
    union {                            /* Password Group n - Lock 2 Status Register */
      vuint32_t R;
      struct {
        vuint32_t L_256LCK:32;
      } B;
    } LOCK2;
    union {                            /* Password Group n - Lock 3 Status Register */
      vuint32_t R;
      struct {
        vuint32_t PGL:1;
        vuint32_t DBL:1;
        vuint32_t MO:1;
        vuint32_t  :1;
        vuint32_t MSTR:4;
        vuint32_t  :3;
        vuint32_t  :1;
        vuint32_t  :1;
        vuint32_t RL2:1;
        vuint32_t RL1:1;
        vuint32_t RL0:1;
        vuint32_t U_256LCK:16;
      } B;
    } LOCK3;
  } PG[4];
};


/* ============================================================================
   =============================== Module: PCM ================================
   ============================================================================ */

struct PCM_tag {
  union {                              /* FEC Burst Optimization Master Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :21;
      vuint32_t ACCERR:1;
      vuint32_t WBEN:1;
      vuint32_t RBEN:1;
      vuint32_t FXSBE:8;
    } B;
  } FBOMCR;

  union {                              /* Bus Bridge Configuration Register 1 */
    vuint32_t R;
    struct {
      vuint32_t  :13;
      vuint32_t PRE_DMA:1;             /* Pending read enable (PRE) DMA */
      vuint32_t BRE_DMA:1;             /* Burst read enable (BRE) DMA */
      vuint32_t BWE_DMA:1;             /* Burst write enable (BWE) DMA */
      vuint32_t  :5;
      vuint32_t PRE_S0:1;              /* Pending read enable (PRE) S0 */
      vuint32_t BRE_S0:1;              /* Burst read enable (BRE) S0. */
      vuint32_t BWE_S0:1;              /* Burst write enable (BWE) S0. */
      vuint32_t  :5;
      vuint32_t PRE_M3:1;              /* Pending read enable (PRE) M3. */
      vuint32_t BRE_M3:1;              /* Burst read enable (BRE) M3. */
      vuint32_t BWE_M3:1;              /* Burst write enable (BWE) M3. */
    } B;
  } IAHB_BE1;

  union {                              /* Bus Bridge Configuration Register 2 */
    vuint32_t R;
    struct {
      vuint32_t  :13;
      vuint32_t PRE_SIPI:1;            /* Pending read enable (PRE) SIPI. */
      vuint32_t BRE_SIPI:1;            /* Burst read enable (BRE) SIPI. */
      vuint32_t BWE_SIPI:1;            /* Burst write enable (BWE) SIPI. */
      vuint32_t  :13;
      vuint32_t PRE_FEC:1;             /* Pending read enable (PRE) FEC. */
      vuint32_t BRE_FEC:1;             /* Burst read enable (BRE) FEC. */
      vuint32_t BWE_FEC:1;             /* Burst write enable (BWE) FEC. */
    } B;
  } IAHB_BE2;
};


/* ============================================================================
   =============================== Module: PFLASH =============================
   ============================================================================ */

struct PFLASH_tag {
  union {                              /* Platform Flash Configuration Register 1 */
    vuint32_t R;
    struct {
      vuint32_t P0_M15PFE:1;
      vuint32_t P0_M14PFE:1;
      vuint32_t P0_M13PFE:1;
      vuint32_t P0_M12PFE:1;
      vuint32_t P0_M11PFE:1;
      vuint32_t P0_M10PFE:1;
      vuint32_t P0_M9PFE:1;
      vuint32_t P0_M8PFE:1;
      vuint32_t P0_M7PFE:1;
      vuint32_t P0_M6PFE:1;
      vuint32_t P0_M5PFE:1;
      vuint32_t P0_M4PFE:1;
      vuint32_t P0_M3PFE:1;
      vuint32_t P0_M2PFE:1;
      vuint32_t P0_M1PFE:1;
      vuint32_t P0_M0PFE:1;
      vuint32_t APC:3;
      vuint32_t RWSC:5;
      vuint32_t  :1;
      vuint32_t P0_DPFEN:1;
      vuint32_t  :1;
      vuint32_t P0_IPFEN:1;
      vuint32_t  :1;
      vuint32_t P0_PFLIM:2;
      vuint32_t P0_BFEN:1;
    } B;
  } PFCR1;

  union {                              /* Platform Flash Configuration Register 2 */
    vuint32_t R;
    struct {
      vuint32_t P1_M15PFE:1;
      vuint32_t P1_M14PFE:1;
      vuint32_t P1_M13PFE:1;
      vuint32_t P1_M12PFE:1;
      vuint32_t P1_M11PFE:1;
      vuint32_t P1_M10PFE:1;
      vuint32_t P1_M9PFE:1;
      vuint32_t P1_M8PFE:1;
      vuint32_t P1_M7PFE:1;
      vuint32_t P1_M6PFE:1;
      vuint32_t P1_M5PFE:1;
      vuint32_t P1_M4PFE:1;
      vuint32_t P1_M3PFE:1;
      vuint32_t P1_M2PFE:1;
      vuint32_t P1_M1PFE:1;
      vuint32_t P1_M0PFE:1;
      vuint32_t  :9;
      vuint32_t P1_DPFEN:1;
      vuint32_t  :1;
      vuint32_t P1_IPFEN:1;
      vuint32_t  :1;
      vuint32_t P1_PFLIM:2;
      vuint32_t P1_BFEN:1;
    } B;
  } PFCR2;

  union {                              /* Platform Flash Configuration Register 3 */
    vuint32_t R;
    struct {
      vuint32_t P0_WCFG:2;
      vuint32_t P1_WCFG:2;
      vuint32_t  :2;
      vuint32_t  :5;
      vuint32_t BDRM:1;
      vuint32_t  :3;
      vuint32_t BAF_DIS:1;
      vuint32_t ARBM:2;
      vuint32_t  :2;
      vuint32_t  :11;
      vuint32_t DERR_SUP:1;
    } B;
  } PFCR3;

  union {                              /* Platform Flash Access Protection Register */
    vuint32_t R;
    struct {
      vuint32_t M0AP:2;
      vuint32_t M1AP:2;
      vuint32_t M2AP:2;
      vuint32_t M3AP:2;
      vuint32_t M4AP:2;
      vuint32_t M5AP:2;
      vuint32_t M6AP:2;
      vuint32_t M7AP:2;
      vuint32_t M8AP:2;
      vuint32_t M9AP:2;
      vuint32_t M10AP:2;
      vuint32_t M11AP:2;
      vuint32_t M12AP:2;
      vuint32_t M13AP:2;
      vuint32_t M14AP:2;
      vuint32_t M15AP:2;
    } B;
  } PFAPR;

  union {                              /* Platform Flash Remap Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :23;
      vuint32_t SAFE_CAL:1;
      vuint32_t  :3;
      vuint32_t IRMEN:1;
      vuint32_t  :3;
      vuint32_t GRMEN:1;
    } B;
  } PFCRCR;

  union {                              /* Platform Flash Remap Descriptor Enable Register */
    vuint32_t R;
    struct {
      vuint32_t CRD0EN:1;
      vuint32_t CRD1EN:1;
      vuint32_t CRD2EN:1;
      vuint32_t CRD3EN:1;
      vuint32_t CRD4EN:1;
      vuint32_t CRD5EN:1;
      vuint32_t CRD6EN:1;
      vuint32_t CRD7EN:1;
      vuint32_t CRD8EN:1;
      vuint32_t CRD9EN:1;
      vuint32_t CRD10EN:1;
      vuint32_t CRD11EN:1;
      vuint32_t CRD12EN:1;
      vuint32_t CRD13EN:1;
      vuint32_t CRD14EN:1;
      vuint32_t CRD15EN:1;
      vuint32_t CRD16EN:1;
      vuint32_t CRD17EN:1;
      vuint32_t CRD18EN:1;
      vuint32_t CRD19EN:1;
      vuint32_t CRD20EN:1;
      vuint32_t CRD21EN:1;
      vuint32_t CRD22EN:1;
      vuint32_t CRD23EN:1;
      vuint32_t CRD24EN:1;
      vuint32_t CRD25EN:1;
      vuint32_t CRD26EN:1;
      vuint32_t CRD27EN:1;
      vuint32_t CRD28EN:1;
      vuint32_t CRD29EN:1;
      vuint32_t CRD30EN:1;
      vuint32_t CRD31EN:1;
    } B;
  } PFCRDE;

  uint8_t PFLASH_reserved0[232];
  struct {
    union {                            /* Platform Flash Calibration Region Descriptor n Word0 */
      vuint32_t R;
      struct {
        vuint32_t LSTARTADDR:32;
      } B;
    } Word0;
    union {                            /* Platform Flash Calibration Region Descriptor n Word1 */
      vuint32_t R;
      struct {
        vuint32_t PSTARTADDR:32;
      } B;
    } Word1;
    union {                            /* Platform Flash Calibration Region Descriptor n Word2 */
      vuint32_t R;
      struct {
        vuint32_t M0EN:1;
        vuint32_t M1EN:1;
        vuint32_t M2EN:1;
        vuint32_t M3EN:1;
        vuint32_t M4EN:1;
        vuint32_t M5EN:1;
        vuint32_t M6EN:1;
        vuint32_t M7EN:1;
        vuint32_t M8EN:1;
        vuint32_t M9EN:1;
        vuint32_t M10EN:1;
        vuint32_t M11EN:1;
        vuint32_t M12EN:1;
        vuint32_t M13EN:1;
        vuint32_t M14EN:1;
        vuint32_t M15EN:1;
        vuint32_t  :11;
        vuint32_t CRDSize:5;
      } B;
    } Word2;
    uint8_t PFCRD_reserved0[4];
  } PFCRD[32];
};


/* ============================================================================
   =============================== Module: PIT ================================
   ============================================================================ */

struct PIT_tag {
  union {                              /* PIT Module Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t MDIS_RTI:1;            /* Module Disable - RTI section */
      vuint32_t MDIS:1;                /* Module Disable - (PIT section) */
      vuint32_t FRZ:1;                 /* Freeze */
    } B;
  } MCR;

  uint8_t PIT_reserved0[220];
  union {                              /* PIT Upper Lifetime Timer Register */
    vuint32_t R;
    struct {
      vuint32_t LTH:32;                /* Life Timer value */
    } B;
  } LTMR64H;

  union {                              /* PIT Lower Lifetime Timer Register */
    vuint32_t R;
    struct {
      vuint32_t LTL:32;                /* Life Timer value */
    } B;
  } LTMR64L;

  uint8_t PIT_reserved1[8];
  union {                              /* Timer Load Value Register */
    vuint32_t R;
    struct {
      vuint32_t TSV:32;                /* Timer Start Value */
    } B;
  } RTI_LDVAL;

  union {                              /* Current Timer Value Register */
    vuint32_t R;
    struct {
      vuint32_t TVL:32;                /* Current Timer Value */
    } B;
  } RTI_CVAL;

  union {                              /* Timer Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t TIE:1;                 /* Timer Interrupt Enable */
      vuint32_t TEN:1;                 /* Timer Enable Bit */
    } B;
  } RTI_TCTRL;

  union {                              /* Timer Flag Register */
    vuint32_t R;
    struct {
      vuint32_t  :31;
      vuint32_t TIF:1;                 /* Timer Interrupt Flag. */
    } B;
  } RTI_TFLG;

  struct {
    union {                            /* Timer Load Value Register */
      vuint32_t R;
      struct {
        vuint32_t TSV:32;              /* Timer Start Value */
      } B;
    } LDVAL;
    union {                            /* Current Timer Value Register */
      vuint32_t R;
      struct {
        vuint32_t TVL:32;              /* Current Timer Value */
      } B;
    } CVAL;
    union {                            /* Timer Control Register */
      vuint32_t R;
      struct {
        vuint32_t  :29;
        vuint32_t CHN:1;               /* Chain Mode */
        vuint32_t TIE:1;               /* Timer Interrupt Enable */
        vuint32_t TEN:1;               /* Timer Enable */
      } B;
    } TCTRL;
    union {                            /* Timer Flag Register */
      vuint32_t R;
      struct {
        vuint32_t  :31;
        vuint32_t TIF:1;               /* Timer Interrupt Flag */
      } B;
    } TFLG;
  } TIMER[8];
};


/* ============================================================================
   =============================== Module: PLLDIG =============================
   ============================================================================ */

struct PLLDIG_tag {
  union {                              /* PLLDIG PLL0 Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :22;
      vuint32_t CLKCFG:2;              /* Clock Configuration */
      vuint32_t EXPDIE:1;              /* External Power Down Cycle Complete indication interrupt enable. */
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t LOLIE:1;               /* Loss-of-lock interrupt enable. */
      vuint32_t LOLRE:1;               /* Loss-of-lock reset enable. */
      vuint32_t  :1;
      vuint32_t  :1;
    } B;
  } PLL0CR;

  union {                              /* PLLDIG PLL0 Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t EXTPDF:1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t LOLF:1;
      vuint32_t LOCK:1;
      vuint32_t  :1;
      vuint32_t  :1;
    } B;
  } PLL0SR;

  union {                              /* PLLDIG PLL0 Divider Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t RFDPHI1:4;             /* PHI1 reduced frequency divider. */
      vuint32_t  :5;
      vuint32_t RFDPHI:6;              /* PHI reduced frequency divider. */
      vuint32_t  :1;
      vuint32_t PREDIV:3;              /* Input clock predivider. */
      vuint32_t  :5;
      vuint32_t MFD:7;                 /* Loop multiplication factor divider. */
    } B;
  } PLL0DV;

  uint8_t PLLDIG_reserved0[20];
  union {                              /* PLLDIG PLL1 Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :22;
      vuint32_t CLKCFG:2;              /* Clock Configuration */
      vuint32_t EXPDIE:1;              /* External Power Down Cycle Complete indication interrupt enable. */
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t LOLIE:1;               /* Loss-of-lock interrupt enable. */
      vuint32_t LOLRE:1;               /* Loss-of-lock reset enable. */
      vuint32_t  :1;
      vuint32_t  :1;
    } B;
  } PLL1CR;

  union {                              /* PLLDIG PLL1 Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :22;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t EXTPDF:1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t LOLF:1;
      vuint32_t LOCK:1;
      vuint32_t  :1;
      vuint32_t  :1;
    } B;
  } PLL1SR;

  union {                              /* PLLDIG PLL1 Divider Register */
    vuint32_t R;
    struct {
      vuint32_t  :10;
      vuint32_t RFDPHI:6;
      vuint32_t  :5;
      vuint32_t  :4;
      vuint32_t MFD:7;                 /* Loop multiplication factor divider. */
    } B;
  } PLL1DV;

  union {                              /* PLLDIG PLL1 Frequency Modulation Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t MODEN:1;               /* Modulation enable. */
      vuint32_t MODSEL:1;              /* Modulation selection. */
      vuint32_t MODPRD:13;             /* Modulation period. */
      vuint32_t  :1;
      vuint32_t INCSTP:15;             /* Increment step. */
    } B;
  } PLL1FM;

  union {                              /* PLLDIG PLL1 Fractional Divide Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t FDEN:1;                /* Fractional Divide Enable */
      vuint32_t  :12;
      vuint32_t DTHDIS:2;              /* Dither Disable. */
      vuint32_t  :4;
      vuint32_t FRCDIV:12;
    } B;
  } PLL1FD;
};


/* ============================================================================
   =============================== Module: PMC ================================
   ============================================================================ */

struct PMC_tag {
  uint8_t PMC_reserved0[164];
  union {                              /* Temperature Sensor Interrupt Enable Register */
    vuint32_t R;
    struct {
      vuint32_t TS_EN:1;               /* Temperature Sensor interrupts Enable */
      vuint32_t  :25;
      vuint32_t TS1_3IE:1;             /* Temperature Sensor 1 input 3 Interrupt Enable. */
      vuint32_t TS1_2IE:1;             /* Temperature Sensor 1 input 2 Interrupt Enable. */
      vuint32_t TS1_0IE:1;             /* Temperature Sensor 1 input 0 Interrupt Enable. */
      vuint32_t TS0_3IE:1;             /* Temperature Sensor 0 input 3 Interrupt Enable. */
      vuint32_t TS0_2IE:1;             /* Temperature Sensor 0 input 2 Interrupt Enable. */
      vuint32_t TS0_0IE:1;             /* Temperature Sensor 0 input 0 Interrupt Enable. */
    } B;
  } TS_IER;

  union {                              /* Temperature Event Status register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t TEMP1_3:1;
      vuint32_t TEMP1_2:1;
      vuint32_t TEMP1_0:1;
      vuint32_t TEMP0_3:1;
      vuint32_t TEMP0_2:1;
      vuint32_t TEMP0_0:1;
    } B;
  } ESR_TD;

  union {                              /* Temperature Reset Event Enable register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t TEMP1_3:1;
      vuint32_t TEMP1_2:1;
      vuint32_t TEMP1_0:1;
      vuint32_t TEMP0_3:1;
      vuint32_t TEMP0_2:1;
      vuint32_t TEMP0_0:1;
    } B;
  } REE_TD;

  union {                              /* Temperature Reset Event Selection register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t TEMP1_3:1;             /* TEMP1_3 Reset Event Select. */
      vuint32_t TEMP1_2:1;             /* TEMP1_2 Reset Event Select. */
      vuint32_t TEMP1_0:1;             /* TEMP1_0 Reset Event Select. */
      vuint32_t TEMP0_3:1;             /* TEMP0_3 Reset Event Select. */
      vuint32_t TEMP0_2:1;             /* TEMP0_2 Reset Event Select. */
      vuint32_t TEMP0_0:1;             /* TEMP0_0 Reset Event Select. */
    } B;
  } RES_TD;

  union {                              /* Temperature detector configuration register */
    vuint32_t R;
    struct {
      vuint32_t  :22;
      vuint32_t TS1_DOUT_EN:1;
      vuint32_t TS1_AOUT_EN:1;
      vuint32_t  :6;
      vuint32_t TS0_DOUT_EN:1;
      vuint32_t TS0_AOUT_EN:1;
    } B;
  } CTL_TD;

  uint8_t PMC_reserved1[8];
  union {                              /* Temperature Fault Injection Register */
    vuint32_t R;
    struct {
      vuint32_t  :31;
      vuint32_t TSNS_FAULT:1;          /* Temperature Sensor Fault injection. */
    } B;
  } TS_FIR;

  union {                              /* Temp Sensor Test Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t TS1_SELTSH:1;          /* Temperature Sensor 1 Select Threshold. */
      vuint32_t  :3;
      vuint32_t TS0_SELTSH:1;          /* Temperature Sensor 0 Select Threshold. */
      vuint32_t  :3;
    } B;
  } TS_TMC;

  uint8_t PMC_reserved2[4];
  union {                              /* LVD Self Test Time Window Register */
    vuint32_t R;
    struct {
      vuint32_t  :20;
      vuint32_t STTW:12;
    } B;
  } LVD_STTW;

  union {                              /* Voltage Detect User Mode Test Register */
    vuint32_t R;
    struct {
      vuint32_t  :14;
      vuint32_t ST_RESULT:1;
      vuint32_t ST_DONE:1;
      vuint32_t  :8;
      vuint32_t ST_MODE:2;             /* Self Test mode bits for testing of LVDs and HVDs. */
      vuint32_t VD_ST_CTRL:6;
    } B;
  } SELF_TEST_UM_VD_REG;

  union {                              /* FCCU Fault Injection Register */
    vuint32_t R;
    struct {
      vuint32_t  :28;
      vuint32_t STEST_FAULT:1;
      vuint32_t  :1;
      vuint32_t HVD_FAULT:1;           /* High Voltage Detect Fault injection. */
      vuint32_t LVD_FAULT:1;           /* Low Voltage Detect Fault injection. */
    } B;
  } FIR;

  union {                              /* LVD HVD Interrupt Enable Control Register */
    vuint32_t R;
    struct {
      vuint32_t PMC_ENABLE:1;          /* PMC Enable Control */
      vuint32_t  :15;
      vuint32_t LVD_JTAG:1;            /* LVD_JTAG Control */
      vuint32_t LVD_PMC:1;             /* LVD_PMC Control */
      vuint32_t LVD_FEC:1;             /* LVD FEC Control */
      vuint32_t LVD_MSC_3:1;           /* LVD_MSC3 Control */
      vuint32_t LVD_MSC_5:1;           /* LVD_MSC5 Control */
      vuint32_t LVD_SAR_ADC:1;         /* LVD_SAR_ADC Control */
      vuint32_t LVD_SD_ADC:1;          /* LVD_SD_ADC Control */
      vuint32_t HVD_SAR_ADC:1;         /* HVD_SAR_ADC Control */
      vuint32_t HVD_SD_ADC:1;          /* HVD_SD_ADC Control */
      vuint32_t LVD_IO:1;              /* LVD_IO Control */
      vuint32_t HVD_FLASH:1;           /* HVD FLASH Control */
      vuint32_t LVD_FLASH:1;           /* LVD FLASH Control */
      vuint32_t HVD_HV:1;              /* HVD HV Control */
      vuint32_t HVD_CORE:1;            /* HVD Core Control */
      vuint32_t LVD_CORE_HOT:1;        /* LVD Core Hot Control */
      vuint32_t LVD_CORE_COLD:1;       /* LVD Core Cold Control */
    } B;
  } LVD_HVD_INTR_ENB;

  union {                              /* LVD HVD Event Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t LVD_JTAG:1;
      vuint32_t LVD_PMC:1;
      vuint32_t LVD_FEC:1;
      vuint32_t LVD_MSC_3:1;
      vuint32_t LVD_MSC_5:1;
      vuint32_t LVD_SAR_ADC:1;
      vuint32_t LVD_SD_ADC:1;
      vuint32_t HVD_SAR_ADC:1;
      vuint32_t HVD_SD_ADC:1;
      vuint32_t LVD_IO:1;
      vuint32_t HVD_FLASH:1;
      vuint32_t LVD_FLASH:1;
      vuint32_t HVD_HV:1;
      vuint32_t HVD_CORE:1;
      vuint32_t LVD_CORE_HOT:1;
      vuint32_t LVD_CORE_COLD:1;
    } B;
  } LVD_HVD_EVENT_STATUS;

  union {                              /* Reset Enable Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t LVD_JTAG:1;            /* Reset Enable/Disable Control */
      vuint32_t  :1;
      vuint32_t LVD_FEC:1;             /* Reset Enable/Disable Control */
      vuint32_t LVD_MSC_3:1;           /* Reset Enable/Disable Control */
      vuint32_t LVD_MSC_5:1;           /* Reset Enable/Disable Control */
      vuint32_t LVD_SAR_ADC:1;         /* Reset Enable/Disable Control */
      vuint32_t LVD_SD_ADC:1;          /* Reset Enable/Disable Control */
      vuint32_t HVD_SAR_ADC:1;         /* Reset Enable/Disable Control */
      vuint32_t HVD_SD_ADC:1;          /* Reset Enable/Disable Control */
      vuint32_t  :1;
      vuint32_t HVD_FLASH:1;           /* Reset Enable/Disable Control */
      vuint32_t  :1;
      vuint32_t HVD_HV:1;              /* Reset Enable/Disable Control */
      vuint32_t HVD_CORE:1;            /* Reset Enable/Disable Control */
      vuint32_t LVD_CORE_HOT:1;        /* Reset Enable/Disable Control */
      vuint32_t LVD_CORE_COLD:1;       /* Reset Enable/Disable Control */
    } B;
  } REE;

  union {                              /* Reset Type ( Destructive / Functional) Selection Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t LVD_JTAG:1;
      vuint32_t  :1;
      vuint32_t LVD_FEC:1;
      vuint32_t LVD_MSC_3:1;
      vuint32_t LVD_MSC_5:1;
      vuint32_t LVD_SAR_ADC:1;
      vuint32_t LVD_SD_ADC:1;
      vuint32_t HVD_SAR_ADC:1;
      vuint32_t HVD_SD_ADC:1;
      vuint32_t  :1;
      vuint32_t HVD_FLASH:1;
      vuint32_t  :1;
      vuint32_t HVD_HV:1;
      vuint32_t HVD_CORE:1;
      vuint32_t  :1;
      vuint32_t LVD_CORE_COLD:1;       /* LVD Core Enable Disable Bit */
    } B;
  } RES;

  union {                              /* ADC Channel Select Register */
    vuint32_t R;
    struct {
      vuint32_t  :22;
      vuint32_t STND_BY_RAM_BO_CLR:1;
      vuint32_t STND_BY_RAM_BR_DETCT:1;
      vuint32_t  :2;
      vuint32_t ADC_CHSE:6;
    } B;
  } ADC_CS;
};


/* ============================================================================
   =============================== Module: PRAMC ==============================
   ============================================================================ */

struct PRAMC_tag {
  union {                              /* Platform RAM Configuration Register 1 */
    vuint32_t R;
    struct {
      vuint32_t  :22;
      vuint32_t PRI:2;                 /* AHB port arbitration mode. */
      vuint32_t P1_BO_DIS:1;           /* Port p1 read burst optimization disable. */
      vuint32_t P0_BO_DIS:1;           /* Port p0 read burst optimization disable. */
      vuint32_t  :5;
      vuint32_t FT_DIS:1;              /* Flow through disabled. */
    } B;
  } PRCR1;
};


/* ============================================================================
   =============================== Module: REACM2 =============================
   ============================================================================ */

struct REACM2_tag {
  union {                              /* Module Configuration */
    vuint32_t R;
    struct {
      vuint32_t OVRC:1;                /* Overrun Detection Flag Clear */
      vuint32_t MDIS:1;                /* Module Disable */
      vuint32_t FRZ:1;                 /* Freeze Control */
      vuint32_t  :1;
      vuint32_t FREN:1;                /* Freeze Enable */
      vuint32_t TPREN:1;               /* Timer Prescaler Enable */
      vuint32_t HPREN:1;               /* Hold Timer Prescaler Enable */
      vuint32_t GIEN:1;                /* Global Interrupt Enable */
      vuint32_t OVREN:1;               /* Overrun Detection Interrupt Enable */
      vuint32_t  :23;
    } B;
  } MCR;

  union {                              /* Timer Configuration */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t HPRE:12;               /* Hold Timer Prescaler */
      vuint32_t  :8;
      vuint32_t TPRE:8;                /* Timer Prescaler */
    } B;
  } TCR;

  union {                              /* Threshold Router Register */
    vuint32_t R;
    struct {
      vuint32_t  :6;
      vuint32_t WREN1:1;               /* Write Enable Bit for THRADC1 */
      vuint32_t WREN0:1;               /* Write Enable Bit for THRADC0 */
      vuint32_t  :12;
      vuint32_t THRADC1:4;             /* ADC result Router value for Threshold Bank address one */
      vuint32_t  :4;
      vuint32_t THRADC0:4;             /* ADC result Router for Threshold Bank address zero */
    } B;
  } THRR;

  uint8_t REACM2_reserved0[4];
  union {                              /* ADC Sensor Input Register */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t ADC_TAG:4;             /* TAG value */
      vuint32_t ADC_RESULT:16;         /* ADC conversion result value */
    } B;
  } SINR;

  union {                              /* Period Generator Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t PERPRESC:8;            /* Period prescaler rate value */
      vuint32_t PER:16;                /* Period time value */
    } B;
  } PCR;

  union {                              /* Period Shift Delay Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t DLY:16;                /* Delay value between two consecutive channel period pulses */
    } B;
  } PSCR;

  uint8_t REACM2_reserved1[4];
  union {                              /* Global Error Flag Register */
    vuint32_t R;
    struct {
      vuint32_t OVR:1;                 /* Overrun Detection Flag */
      vuint32_t  :21;
      vuint32_t EF9:1;                 /* Error Flag */
      vuint32_t EF8:1;                 /* Error Flag */
      vuint32_t EF7:1;                 /* Error Flag */
      vuint32_t EF6:1;                 /* Error Flag */
      vuint32_t EF5:1;                 /* Error Flag */
      vuint32_t EF4:1;                 /* Error Flag */
      vuint32_t EF3:1;                 /* Error Flag */
      vuint32_t EF2:1;                 /* Error Flag */
      vuint32_t EF1:1;                 /* Error Flag */
      vuint32_t EF0:1;                 /* Error Flag */
    } B;
  } GEFR;

  uint8_t REACM2_reserved2[220];
  struct {
    union {                            /* Channel n Configuration Register */
      vuint32_t R;
      struct {
        vuint32_t CHEN:2;              /* Channel Enable Bits */
        vuint32_t SWMC:1;              /* Software Modulation Control bit */
        vuint32_t MAXLEN:1;            /* ADC result Maximum Limit Interrupt Enable bit */
        vuint32_t OCDFEN:1;            /* OCDF Interrupt Enable bit */
        vuint32_t SCDFEN:1;            /* SCDF Interrupt Enable bit */
        vuint32_t TAEREN:1;            /* TAER Interrupt Enable bit */
        vuint32_t SQEREN:1;            /* Modulation Word Sequence Error Interrupt Enable */
        vuint32_t RAEREN:1;            /* Resource Allocation Error Interrupt Enable */
        vuint32_t DMAEN:1;             /* Direct Memory Access Enable bit */
        vuint32_t CHOFF:1;             /* Output Disable bit */
        vuint32_t SDCM:1;              /* Short Detection Counting Mode */
        vuint32_t  :1;
        vuint32_t DOFF:3;              /* Drive Off Control field */
        vuint32_t  :5;
        vuint32_t BSB:3;               /* Bank Support Bits */
        vuint32_t  :3;
        vuint32_t MODULATION_ADDR:5;   /* Address for Modulation Control Bank */
      } B;
    } CR;
    union {                            /* Channel n Status Register */
      vuint32_t R;
      struct {
        vuint32_t  :2;
        vuint32_t MODACT:1;            /* Modulation Active Flag */
        vuint32_t MAXL:1;              /* ADC Maximum Limit Detection Flag */
        vuint32_t OCDF:1;              /* Open Circuit Detection Flag */
        vuint32_t SCDF:1;              /* Short Circuit Detection Flag */
        vuint32_t TAER:1;              /* Timer Allocation Error */
        vuint32_t SQER:1;              /* Modulation Word Sequence Error Flag */
        vuint32_t RAER:1;              /* Resource Allocation Error Flag */
        vuint32_t CHOUT:3;             /* Channel Output Monitoring bits */
        vuint32_t  :7;
        vuint32_t MAXLC:1;             /* ADC Maximum Limit Flag Clear */
        vuint32_t OCDFC:1;             /* Open Circuit Detection Flag Clear */
        vuint32_t SCDFC:1;             /* Short Circuit Detection Flag clear */
        vuint32_t TAERC:1;             /* TAER Clear bit */
        vuint32_t SQERC:1;             /* Modulation Word Sequence Error Flag clear */
        vuint32_t RAERC:1;             /* Resource Allocation Error Flag clear */
        vuint32_t  :1;
        vuint32_t MODULATION_POINTER:6; /* Modulation bank address generated by the channel */
      } B;
    } SR;
    union {                            /* Channel n Router Register */
      vuint32_t R;
      struct {
        vuint32_t  :12;
        vuint32_t ADCR:4;              /* ADC result router field */
        vuint32_t  :12;
        vuint32_t CHIR:4;              /* Channel Input router field */
      } B;
    } RR;
    uint8_t CH_reserved0[4];
  } CH[10];

  uint8_t REACM2_reserved3[352];
  union {                              /* Shared Timer Bank */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SHARED_TIMER:16;       /* Timer Value */
    } B;
  } STBK[5];

  uint8_t REACM2_reserved4[108];
  union {                              /* Hold Timer Bank */
    vuint32_t R;
    struct {
      vuint32_t  :20;
      vuint32_t HOLD_TIM:12;           /* Hold Timer Value */
    } B;
  } HOTBK[5];

  uint8_t REACM2_reserved5[108];
  union {                              /* Threshold Bank */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t THRESHOLD_VALUE:16;    /* Threshold Value */
    } B;
  } THBK[32];

  uint8_t REACM2_reserved6[384];
  union {                              /* ADC Result Maximum Limit Check */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t ADC_MAX_LIMIT:16;      /* Maximum Limit allowed for the ADC result */
    } B;
  } ADCMAX;

  uint8_t REACM2_reserved7[124];
  union {                              /* Modulation Range Pulse Width */
    vuint32_t R;
    struct {
      vuint32_t  :20;
      vuint32_t RANGE_PWD:12;          /* Range Pulse Width */
    } B;
  } RANGE_PWD;

  uint8_t REACM2_reserved8[60];
  union {                              /* Modulation Minimum Pulse Width */
    vuint32_t R;
    struct {
      vuint32_t  :20;
      vuint32_t MIN_PWD:12;            /* Minimum Pulse Width */
    } B;
  } MIN_PWD;

  uint8_t REACM2_reserved9[60];
  union {                              /* Modulation Control Word Bank */
    vuint32_t R;
    struct {
      vuint32_t LOOP:1;                /* Loop Control Bit */
      vuint32_t IOSS:1;                /* Initial Output State Selection */
      vuint32_t DMA:1;                 /* DMA bit */
      vuint32_t MM:2;                  /* Modulation Mode */
      vuint32_t  :1;
      vuint32_t SM:2;                  /* Sequencer Mode */
      vuint32_t  :1;
      vuint32_t HOD:3;                 /* High Output Drive */
      vuint32_t  :1;
      vuint32_t LOD:3;                 /* Low Output Drive */
      vuint32_t  :2;
      vuint32_t THRESPT:5;             /* Threshold Pointer */
      vuint32_t  :1;
      vuint32_t STPT:3;                /* Shared Timer Pointer */
      vuint32_t  :2;
      vuint32_t HDOFFTPT:3;            /* Hold on/off Pointer */
    } B;
  } MWBK[32];
};


/* ============================================================================
   =============================== Module: SDADC ==============================
   ============================================================================ */

struct SDADC_tag {
  union {                              /* Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :3;
      vuint32_t PDR:5;
      vuint32_t  :1;
      vuint32_t PGAN:3;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t HPFEN:1;
      vuint32_t WDGEN:1;
      vuint32_t TRIGEDSEL:2;
      vuint32_t TRIGEN:1;
      vuint32_t  :2;
      vuint32_t TRIGSEL:2;
      vuint32_t FRZ:1;
      vuint32_t  :2;
      vuint32_t VCOMSEL:1;
      vuint32_t WRMODE:1;
      vuint32_t GECEN:1;               /* Accurate Gain Error Mode Enable */
      vuint32_t MODE:1;
      vuint32_t EN:1;
    } B;
  } MCR;

  union {                              /* Channel Selection Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t BIASEN:8;
      vuint32_t  :5;
      vuint32_t ANCHSEL_WRAP:3;
      vuint32_t  :5;
      vuint32_t ANCHSEL:3;
    } B;
  } CSR;

  union {                              /* Reset Key Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t RESET_KEY:16;
    } B;
  } RKR;

  union {                              /* Status Flag Register */
    vuint32_t R;
    struct {
      vuint32_t  :13;
      vuint32_t ANCHSEL_CNT:3;
      vuint32_t  :7;
      vuint32_t DFEF:1;
      vuint32_t  :3;
      vuint32_t WTHH:1;
      vuint32_t WTHL:1;
      vuint32_t CDVF:1;
      vuint32_t DFORF:1;
      vuint32_t DFFF:1;
    } B;
  } SFR;

  union {                              /* Request Select and Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :14;
      vuint32_t WTHDIRS:1;
      vuint32_t DFFDIRS:1;
      vuint32_t GDIGE:1;
      vuint32_t  :11;
      vuint32_t WTHDIRE:1;
      vuint32_t CDVEE:1;
      vuint32_t DFORIE:1;
      vuint32_t DFFDIRE:1;
    } B;
  } RSER;

  uint8_t SDADC_reserved0[4];
  union {                              /* FIFO Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :19;
      vuint32_t FTHLD:5;
      vuint32_t  :5;
      vuint32_t FSIZE:2;
      vuint32_t FE:1;
    } B;
  } FCR;

  union {                              /* Software Trigger Key Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t ST_KEY:16;
    } B;
  } STKR;

  union {                              /* Converted Data Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CDATA:16;
    } B;
  } CDR;

  union {                              /* WDG Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t THRH:16;
      vuint32_t THRL:16;
    } B;
  } WTHHLR;
};


/* ============================================================================
   =============================== Module: SEMA42 =============================
   ============================================================================ */

struct SEMA42_tag {
  union {                              /* Gate Register */
    vuint8_t R;
    struct {
      vuint8_t  :4;
      vuint8_t GTFSM:4;                /* Gate Finite State Machine. */
    } B;
  } GATE[16];

  uint8_t SEMA42_reserved0[48];
  union {
    union {                            /* Reset Gate Read */
      vuint16_t R;
      struct {
        vuint16_t  :2;
        vuint16_t RSTGSM:2;
        vuint16_t RSTGMS:4;
        vuint16_t RSTGTN:8;
      } B;
    } R;
    union {                            /* Reset Gate Write */
      vuint16_t R;
      struct {
        vuint16_t RSTGDP:8;
        vuint16_t RSTGTN:8;
      } B;
    } W;
  } RSTGT;
};


/* ============================================================================
   =============================== Module: SIPI ===============================
   ============================================================================ */

struct SIPI_tag {
  union {                              /* SIPI Channel Control Register 0 */
    vuint32_t R;
    struct {
      vuint32_t  :15;
      vuint32_t TC:1;                  /* Send Trigger Command. */
      vuint32_t  :8;
      vuint32_t WL:2;                  /* Word Length Transfer. */
      vuint32_t CHEN:1;                /* Channel Enable. */
      vuint32_t ST:1;                  /* Streaming Transfer. */
      vuint32_t IDT:1;                 /* ID Read Request Transfer. */
      vuint32_t RRT:1;                 /* Read Request Transfer. */
      vuint32_t WRT:1;                 /* Write Request Transfer. */
      vuint32_t DEN:1;                 /* DMA Enable. */
    } B;
  } CCR0;

  union {                              /* SIPI Channel Status Register 0 */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t RAR:1;
      vuint32_t TID:3;                 /* Transaction ID of transmitted frame. */
      vuint32_t ACKR:1;
      vuint32_t CB:1;                  /* Channel Busy. */
      vuint32_t  :2;
    } B;
  } CSR0;

  uint8_t SIPI_reserved0[4];
  union {                              /* SIPI Channel Interrupt Register 0 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t WAIE:1;                /* Write Acknowledge Interrupt Enable. */
      vuint32_t RAIE:1;                /* Read Answer Interrupt Enable. */
      vuint32_t TCIE:1;                /* Trigger Command Interrupt Enable. */
      vuint32_t TOIE:1;                /* Timeout Error Interrupt Enabled. */
      vuint32_t TIDIE:1;               /* Transaction ID Error Interrupt Enable. */
      vuint32_t ACKIE:1;               /* Acknowledge Error Interrupt Enable. */
    } B;
  } CIR0;

  union {                              /* SIPI Channel Timeout Register 0 */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t TOR:8;                 /* Timeout value for transmitted requests. */
    } B;
  } CTOR0;

  union {                              /* SIPI Channel CRC Register 0 */
    vuint32_t R;
    struct {
      vuint32_t CRCI:16;
      vuint32_t CRCT:16;
    } B;
  } CCRC0;

  union {                              /* SIPI Channel Address Register 0 */
    vuint32_t R;
    struct {
      vuint32_t CAR:32;
    } B;
  } CAR0;

  union {                              /* SIPI Channel Data Register 0 */
    vuint32_t R;
    struct {
      vuint32_t CDR:32;
    } B;
  } CDR0;

  union {                              /* SIPI Channel Control Register 1 */
    vuint32_t R;
    struct {
      vuint32_t  :15;
      vuint32_t TC:1;                  /* Send Trigger Command. */
      vuint32_t  :8;
      vuint32_t WL:2;                  /* Word Length Transfer. */
      vuint32_t CHEN:1;                /* Channel Enable. */
      vuint32_t ST:1;
      vuint32_t IDT:1;                 /* ID Read Request Transfer. */
      vuint32_t RRT:1;
      vuint32_t WRT:1;
      vuint32_t DEN:1;                 /* DMA Enable. */
    } B;
  } CCR1;

  union {                              /* SIPI Channel Status Register 1 */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t RAR:1;
      vuint32_t TID:3;
      vuint32_t ACKR:1;
      vuint32_t CB:1;                  /* Channel Busy. */
      vuint32_t  :2;
    } B;
  } CSR1;

  uint8_t SIPI_reserved1[4];
  union {                              /* SIPI Channel Interrupt Register 1 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t WAIE:1;
      vuint32_t RAIE:1;
      vuint32_t TCIE:1;
      vuint32_t TOIE:1;
      vuint32_t TIDIE:1;
      vuint32_t ACKIE:1;
    } B;
  } CIR1;

  union {                              /* SIPI Channel Timeout Register 1 */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t TOR:8;                 /* Timeout value for transmitted requests. */
    } B;
  } CTOR1;

  union {                              /* SIPI Channel CRC Register 1 */
    vuint32_t R;
    struct {
      vuint32_t CRCI:16;
      vuint32_t CRCT:16;
    } B;
  } CCRC1;

  union {                              /* SIPI Channel Address Register 1 */
    vuint32_t R;
    struct {
      vuint32_t CAR:32;
    } B;
  } CAR1;

  union {                              /* SIPI Channel Data Register 1 */
    vuint32_t R;
    struct {
      vuint32_t CDR:32;
    } B;
  } CDR1;

  union {                              /* SIPI Channel Control Register 2 */
    vuint32_t R;
    struct {
      vuint32_t  :15;
      vuint32_t TC:1;                  /* Send Trigger Command. */
      vuint32_t  :8;
      vuint32_t WL:2;                  /* Word Length Transfer. */
      vuint32_t CHEN:1;                /* Channel Enable. */
      vuint32_t ST:1;
      vuint32_t IDT:1;                 /* ID Read Request Transfer. */
      vuint32_t RRT:1;                 /* Read Request Transfer. */
      vuint32_t WRT:1;
      vuint32_t DEN:1;                 /* DMA Enable. */
    } B;
  } CCR2;

  union {                              /* SIPI Channel Status Register 2 */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t RAR:1;
      vuint32_t TID:3;                 /* Transaction ID of transmitted frame. */
      vuint32_t ACKR:1;
      vuint32_t CB:1;                  /* Channel Busy. */
      vuint32_t  :2;
    } B;
  } CSR2;

  uint8_t SIPI_reserved2[4];
  union {                              /* SIPI Channel Interrupt Register 2 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t WAIE:1;
      vuint32_t RAIE:1;
      vuint32_t TCIE:1;
      vuint32_t TOIE:1;
      vuint32_t TIDIE:1;
      vuint32_t ACKIE:1;
    } B;
  } CIR2;

  union {                              /* SIPI Channel Timeout Register 2 */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t TOR:8;
    } B;
  } CTOR2;

  union {                              /* SIPI Channel CRC Register 2 */
    vuint32_t R;
    struct {
      vuint32_t CRCI:16;
      vuint32_t CRCT:16;
    } B;
  } CCRC2;

  union {                              /* SIPI Channel Address Register 2 */
    vuint32_t R;
    struct {
      vuint32_t CAR:32;
    } B;
  } CAR2;

  union {                              /* SIPI Channel Data Register 2 */
    vuint32_t R;
    struct {
      vuint32_t CDR2:32;
    } B;
  } CDR2[8];

  union {                              /* SIPI Channel Control Register 3 */
    vuint32_t R;
    struct {
      vuint32_t  :15;
      vuint32_t TC:1;                  /* Send Trigger Command. */
      vuint32_t  :8;
      vuint32_t WL:2;                  /* Word Length Transfer. */
      vuint32_t CHEN:1;                /* Channel Enable. */
      vuint32_t ST:1;                  /* Streaming Transfer. */
      vuint32_t IDT:1;                 /* ID Read Request Transfer. */
      vuint32_t RRT:1;
      vuint32_t WRT:1;
      vuint32_t DEN:1;                 /* DMA Enable. */
    } B;
  } CCR3;

  union {                              /* SIPI Channel Status Register 3 */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t RAR:1;
      vuint32_t TID:3;                 /* Transaction ID of transmitted frame. */
      vuint32_t ACKR:1;
      vuint32_t CB:1;                  /* Channel Busy. */
      vuint32_t  :2;
    } B;
  } CSR3;

  uint8_t SIPI_reserved3[4];
  union {                              /* SIPI Channel Interrupt Register 3 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t WAIE:1;
      vuint32_t RAIE:1;
      vuint32_t TCIE:1;
      vuint32_t TOIE:1;
      vuint32_t TIDIE:1;
      vuint32_t ACKIE:1;
    } B;
  } CIR3;

  union {                              /* SIPI Channel Timeout Register 3 */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t TOR:8;                 /* Timeout value for transmitted requests. */
    } B;
  } CTOR3;

  union {                              /* SIPI Channel CRC Register 3 */
    vuint32_t R;
    struct {
      vuint32_t CRCI:16;
      vuint32_t CRCT:16;
    } B;
  } CCRC3;

  union {                              /* SIPI Channel Address Register 3 */
    vuint32_t R;
    struct {
      vuint32_t CAR:32;
    } B;
  } CAR3;

  union {                              /* SIPI Channel Data Register 3 */
    vuint32_t R;
    struct {
      vuint32_t CDR:32;
    } B;
  } CDR3;

  union {                              /* SIPI Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t FRZ:1;                 /* Freeze Enable */
      vuint32_t  :1;
      vuint32_t HALT:1;                /* Halt Mode Enable */
      vuint32_t  :2;
      vuint32_t PRSCLR:11;             /* Timeout counter prescaler */
      vuint32_t AID:2;                 /* Address Increment/Decrement */
      vuint32_t  :3;
      vuint32_t CRCIE:1;               /* CRC Error Interrupt Enable */
      vuint32_t MCRIE:1;               /* Max Count Reached Interrupt Enable */
      vuint32_t  :4;
      vuint32_t CHNSB:1;               /* Channel coding select bit. */
      vuint32_t TEN:1;                 /* Target Enable */
      vuint32_t INIT:1;                /* Initialization Mode */
      vuint32_t MOEN:1;                /* Module Enable */
      vuint32_t SR:1;                  /* Soft Reset */
    } B;
  } MCR;

  union {                              /* SIPI Status Register */
    vuint32_t R;
    struct {
      vuint32_t FRZACK:1;
      vuint32_t LPMACK:1;              /* Low Power Mode Acknowledge. */
      vuint32_t  :19;
      vuint32_t GCRCE:1;
      vuint32_t MCR:1;                 /* Maximum Count Reached. */
      vuint32_t  :1;
      vuint32_t TE:4;
      vuint32_t STATE:4;
    } B;
  } SR;

  union {                              /* SIPI Max Count Register */
    vuint32_t R;
    struct {
      vuint32_t MXCNT:30;
      vuint32_t  :2;
    } B;
  } MAXCR;

  union {                              /* SIPI Address Reload Register */
    vuint32_t R;
    struct {
      vuint32_t ADRLD:30;
      vuint32_t  :2;
    } B;
  } ARR;

  union {                              /* SIPI Address Count Register */
    vuint32_t R;
    struct {
      vuint32_t ADCNT:30;              /* Feflects the count value of address counter at target node. */
      vuint32_t  :2;
    } B;
  } ACR;

  union {                              /* SIPI Error Register */
    vuint32_t R;
    struct {
      vuint32_t  :5;
      vuint32_t TOE3:1;
      vuint32_t TIDE3:1;
      vuint32_t ACKE3:1;
      vuint32_t  :5;
      vuint32_t TOE2:1;
      vuint32_t TIDE2:1;
      vuint32_t ACKE2:1;
      vuint32_t  :5;
      vuint32_t TOE1:1;
      vuint32_t TIDE1:1;
      vuint32_t ACKE1:1;
      vuint32_t  :5;
      vuint32_t TOE0:1;
      vuint32_t TIDE0:1;
      vuint32_t ACKE0:1;
    } B;
  } ERR;
};


/* ============================================================================
   =============================== Module: SIUL2 ==============================
   ============================================================================ */

struct SIUL2_tag {
  uint8_t SIUL2_reserved0[4];
  union {                              /* SIUL2 MCU ID Register #1 */
    vuint32_t R;
    struct {
      vuint32_t PARTNUM:16;            /* MCU Part Number */
      vuint32_t ED:1;
      vuint32_t PKG:5;                 /* Package Settings */
      vuint32_t  :2;
      vuint32_t MAJOR_MASK:4;          /* Major Mask Revision */
      vuint32_t MINOR_MASK:4;          /* Minor Mask Revision */
    } B;
  } MIDR1;

  union {                              /* SIUL2 MCU ID Register #2 */
    vuint32_t R;
    struct {
      vuint32_t SF:1;                  /* Manufacturer */
      vuint32_t FLASH_SIZE_1:4;        /* Coarse granularity for flash memory size */
      vuint32_t FLASH_SIZE_2:4;        /* Fine granularity for flash memory size */
      vuint32_t  :7;
      vuint32_t PARTNUM:8;             /* ASCII character in MCU Part Number */
      vuint32_t  :8;
    } B;
  } MIDR2;

  uint8_t SIUL2_reserved1[4];
  union {                              /* SIUL2 DMA/Interrupt Status Flag Register0 */
    vuint32_t R;
    struct {
      vuint32_t  :21;
      vuint32_t EIF10:1;               /* External Interrupt Status Flag 10 */
      vuint32_t EIF9:1;                /* External Interrupt Status Flag 9 */
      vuint32_t EIF8:1;                /* External Interrupt Status Flag 8 */
      vuint32_t EIF7:1;                /* External Interrupt Status Flag 7 */
      vuint32_t EIF6:1;                /* External Interrupt Status Flag 6 */
      vuint32_t EIF5:1;                /* External Interrupt Status Flag 5 */
      vuint32_t EIF4:1;                /* External Interrupt Status Flag 4 */
      vuint32_t EIF3:1;                /* External Interrupt Status Flag 3 */
      vuint32_t EIF2:1;                /* External Interrupt Status Flag 2 */
      vuint32_t EIF1:1;                /* External Interrupt Status Flag 1 */
      vuint32_t EIF0:1;                /* External Interrupt Status Flag 0 */
    } B;
  } DISR0;

  uint8_t SIUL2_reserved2[4];
  union {                              /* SIUL2 DMA/Interrupt Request Enable Register0 */
    vuint32_t R;
    struct {
      vuint32_t  :21;
      vuint32_t EIRE10:1;
      vuint32_t EIRE9:1;
      vuint32_t EIRE8:1;
      vuint32_t EIRE7:1;
      vuint32_t EIRE6:1;
      vuint32_t EIRE5:1;
      vuint32_t EIRE4:1;
      vuint32_t EIRE3:1;
      vuint32_t EIRE2:1;
      vuint32_t EIRE1:1;
      vuint32_t EIRE0:1;
    } B;
  } DIRER0;

  uint8_t SIUL2_reserved3[4];
  union {                              /* SIUL2 DMA/Interrupt Request Select Register0 */
    vuint32_t R;
    struct {
      vuint32_t  :21;
      vuint32_t DIRSR10:1;
      vuint32_t DIRSR9:1;
      vuint32_t DIRSR8:1;
      vuint32_t DIRSR7:1;
      vuint32_t DIRSR6:1;
      vuint32_t DIRSR5:1;
      vuint32_t DIRSR4:1;
      vuint32_t DIRSR3:1;
      vuint32_t DIRSR2:1;
      vuint32_t DIRSR1:1;
      vuint32_t DIRSR0:1;
    } B;
  } DIRSR0;

  uint8_t SIUL2_reserved4[4];
  union {                              /* SIUL2 Interrupt Rising-Edge Event Enable Register 0 */
    vuint32_t R;
    struct {
      vuint32_t  :21;
      vuint32_t IREE10:1;
      vuint32_t IREE9:1;
      vuint32_t IREE8:1;
      vuint32_t IREE7:1;
      vuint32_t IREE6:1;
      vuint32_t IREE5:1;
      vuint32_t IREE4:1;
      vuint32_t IREE3:1;
      vuint32_t IREE2:1;
      vuint32_t IREE1:1;
      vuint32_t IREE0:1;
    } B;
  } IREER0;

  uint8_t SIUL2_reserved5[4];
  union {                              /* SIUL2 Interrupt Falling-Edge Event Enable Register 0 */
    vuint32_t R;
    struct {
      vuint32_t  :21;
      vuint32_t IFEE10:1;
      vuint32_t IFEE9:1;
      vuint32_t IFEE8:1;
      vuint32_t IFEE7:1;
      vuint32_t IFEE6:1;
      vuint32_t IFEE5:1;
      vuint32_t IFEE4:1;
      vuint32_t IFEE3:1;
      vuint32_t IFEE2:1;
      vuint32_t IFEE1:1;
      vuint32_t IFEE0:1;
    } B;
  } IFEER0;

  uint8_t SIUL2_reserved6[4];
  union {                              /* SIUL2 Interrupt Filter Enable Register 0 */
    vuint32_t R;
    struct {
      vuint32_t  :21;
      vuint32_t IFE10:1;
      vuint32_t IFE9:1;
      vuint32_t IFE8:1;
      vuint32_t IFE7:1;
      vuint32_t IFE6:1;
      vuint32_t IFE5:1;
      vuint32_t IFE4:1;
      vuint32_t IFE3:1;
      vuint32_t IFE2:1;
      vuint32_t IFE1:1;
      vuint32_t IFE0:1;
    } B;
  } IFER0;

  uint8_t SIUL2_reserved7[4];
  union {                              /* SIUL2 Interrupt Filter Maximum Counter Register */
    vuint32_t R;
    struct {
      vuint32_t  :28;
      vuint32_t MAXCNT:4;              /* Maximum Interrupt Filter Counter setting */
    } B;
  } IFMCR[32];

  union {                              /* SIUL2 Interrupt Filter Clock Prescaler Register */
    vuint32_t R;
    struct {
      vuint32_t  :28;
      vuint32_t IFCP:4;                /* Interrupt Filter Clock Prescaler setting */
    } B;
  } IFCPR;

  uint8_t SIUL2_reserved8[60];
  union {                              /* SoC Configuration Register 0 */
    vuint16_t R;
    struct {
      vuint16_t FEC_MODE:1;
      vuint16_t  :15;
    } B;
  } SCR0[1];

  uint8_t SIUL2_reserved9[318];
  union {                              /* SIUL2 Multiplexed Signal Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t OERC:2;                /* Output Edge Rate Control */
      vuint32_t  :2;
      vuint32_t ODC:2;                 /* Output Drive Control */
      vuint32_t SMC:1;                 /* Safe Mode Control */
      vuint32_t APC:1;                 /* Analog Pad Control */
      vuint32_t ILS:2;                 /* Input Level Selection */
      vuint32_t IBE:1;                 /* Input Buffer Enable */
      vuint32_t HYS:1;                 /* Input Hysteresis */
      vuint32_t WPDE:1;                /* Weak Pulldown Enable */
      vuint32_t WPUE:1;                /* Weak Pullup Enable */
      vuint32_t  :8;
      vuint32_t SSS:8;                 /* Source Signal Select */
    } B;
  } MSCR0_255[256];

  uint8_t SIUL2_reserved10[1024];
  union {                              /* SIUL2 Input Multiplexed Signal Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t SSS:8;                 /* Source Signal Select */
    } B;
  } MSCR512_995[484];

  uint8_t SIUL2_reserved11[112];
  union {                              /* General Purpose Register 0 */
    vuint32_t R;
    struct {
      vuint32_t GPI243_STR1:1;
      vuint32_t GPI243_STR0:1;
      vuint32_t GPI243_SEL1:1;
      vuint32_t GPI243_SEL0:1;
      vuint32_t GPI242_STR1:1;
      vuint32_t GPI242_STR0:1;
      vuint32_t GPI242_SEL1:1;
      vuint32_t GPI242_SEL0:1;
      vuint32_t GPI241_STR1:1;
      vuint32_t GPI241_STR0:1;
      vuint32_t GPI241_SEL1:1;
      vuint32_t GPI241_SEL0:1;
      vuint32_t GPI240_STR1:1;
      vuint32_t GPI240_STR0:1;
      vuint32_t GPI240_SEL1:1;
      vuint32_t GPI240_SEL0:1;
      vuint32_t GPI227_STR1:1;
      vuint32_t GPI227_STR0:1;
      vuint32_t GPI227_SEL1:1;
      vuint32_t GPI227_SEL0:1;
      vuint32_t GPI226_STR1:1;
      vuint32_t GPI226_STR0:1;
      vuint32_t GPI226_SEL1:1;
      vuint32_t GPI226_SEL0:1;
      vuint32_t GPI225_STR1:1;
      vuint32_t GPI225_STR0:1;
      vuint32_t GPI225_SEL1:1;
      vuint32_t GPI225_SEL0:1;
      vuint32_t GPI224_STR1:1;
      vuint32_t GPI224_STR0:1;
      vuint32_t GPI224_SEL1:1;
      vuint32_t GPI224_SEL0:1;
    } B;
  } GPR0;

  union {                              /* General Purpose Register 1 */
    vuint32_t R;
    struct {
      vuint32_t GPI251_STR1:1;
      vuint32_t GPI251_STR0:1;
      vuint32_t GPI251_SEL1:1;
      vuint32_t GPI251_SEL0:1;
      vuint32_t GPI250_STR1:1;
      vuint32_t GPI250_STR0:1;
      vuint32_t GPI250_SEL1:1;
      vuint32_t GPI250_SEL0:1;
      vuint32_t GPI249_STR1:1;
      vuint32_t GPI249_STR0:1;
      vuint32_t GPI249_SEL1:1;
      vuint32_t GPI249_SEL0:1;
      vuint32_t GPI248_STR1:1;
      vuint32_t GPI248_STR0:1;
      vuint32_t GPI248_SEL1:1;
      vuint32_t GPI248_SEL0:1;
      vuint32_t GPI247_STR1:1;
      vuint32_t GPI247_STR0:1;
      vuint32_t GPI247_SEL1:1;
      vuint32_t GPI247_SEL0:1;
      vuint32_t GPI246_STR1:1;
      vuint32_t GPI246_STR0:1;
      vuint32_t GPI246_SEL1:1;
      vuint32_t GPI246_SEL0:1;
      vuint32_t GPI245_STR1:1;
      vuint32_t GPI245_STR0:1;
      vuint32_t GPI245_SEL1:1;
      vuint32_t GPI245_SEL0:1;
      vuint32_t GPI244_STR1:1;
      vuint32_t GPI244_STR0:1;
      vuint32_t GPI244_SEL1:1;
      vuint32_t GPI244_SEL0:1;
    } B;
  } GPR1;

  union {                              /* General Purpose Register 2 */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t GPI255_STR1:1;
      vuint32_t GPI255_STR0:1;
      vuint32_t GPI255_SEL1:1;
      vuint32_t GPI255_SEL0:1;
      vuint32_t GPI254_STR1:1;
      vuint32_t GPI254_STR0:1;
      vuint32_t GPI254_SEL1:1;
      vuint32_t GPI254_SEL0:1;
      vuint32_t GPI253_STR1:1;
      vuint32_t GPI253_STR0:1;
      vuint32_t GPI253_SEL1:1;
      vuint32_t GPI253_SEL0:1;
      vuint32_t GPI252_STR1:1;
      vuint32_t GPI252_STR0:1;
      vuint32_t GPI252_SEL1:1;
      vuint32_t GPI252_SEL0:1;
    } B;
  } GPR2;

  union {                              /* General Purpose Register 3 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t LF_CLK:1;              /* LinFlex Clock */
      vuint32_t POR_MASK:1;            /* Power-on Reset Mask */
    } B;
  } GPR3;

  uint8_t SIUL2_reserved12[176];
  union {                              /* SIUL2 GPIO Pad Data Output Register */
    vuint8_t R;
    struct {
      vuint8_t  :7;
      vuint8_t PDO:1;                  /* Pad Data Out */
    } B;
  } GPDO[256];

  uint8_t SIUL2_reserved13[256];
  union {                              /* SIUL2 GPIO Pad Data Input Register */
    vuint8_t R;
    struct {
      vuint8_t  :7;
      vuint8_t PDI:1;                  /* Pad Data In */
    } B;
  } GPDI[256];

  uint8_t SIUL2_reserved14[256];
  union {                              /* SIUL2 Parallel GPIO Pad Data Out Register */
    vuint16_t R;
    struct {
      vuint16_t PPDO:16;               /* Parallel Pad Data Out */
    } B;
  } PGPDO[16];

  uint8_t SIUL2_reserved15[32];
  union {                              /* SIUL2 Parallel GPIO Pad Data In Register */
    vuint16_t R;
    struct {
      vuint16_t PPDI:16;               /* Parallel Pad Data In */
    } B;
  } PGPDI[16];

  uint8_t SIUL2_reserved16[32];
  union {                              /* SIUL2 Masked Parallel GPIO Pad Data Out Register */
    vuint32_t R;
    struct {
      vuint32_t MASK:16;               /* Mask Field */
      vuint32_t MPPDO:16;              /* Masked Parallel Pad Data Out */
    } B;
  } MPGPDO[16];
};


/* ============================================================================
   =============================== Module: SMPU ===============================
   ============================================================================ */

struct SMPU_tag {
  union {                              /* Control/Error Status Register 0 */
    vuint32_t R;
    struct {
      vuint32_t MERR:16;               /* Master n error, where the bus master number matches the bit number */
      vuint32_t  :1;
      vuint32_t  :11;
      vuint32_t HRL:3;                 /* Hardware revision level */
      vuint32_t GVLD:1;                /* Global Valid (global enable/disable for the SMPU) */
    } B;
  } CESR0;

  union {                              /* Control/Error Status Register 1 */
    vuint32_t R;
    struct {
      vuint32_t MEOVR:16;              /* Master n error overrun, where the bus master number matches the bit number */
      vuint32_t  :1;
      vuint32_t  :11;
      vuint32_t NRGD:4;                /* Number of region descriptors */
    } B;
  } CESR1;

  uint8_t SMPU_reserved0[248];
  struct {
    union {                            /* Error Address Register, Bus Master n */
      vuint32_t R;
      struct {
        vuint32_t EADDR:32;            /* Error address */
      } B;
    } EAR;
    union {                            /* Error Detail Register, Bus Master n */
      vuint32_t R;
      struct {
        vuint32_t EACD:24;             /* Error access control detail */
        vuint32_t  :1;
        vuint32_t EATTR:2;             /* Error attributes */
        vuint32_t ERW:1;               /* Error read/write */
        vuint32_t EMN:4;               /* Error master number */
      } B;
    } EDR;
  } ERROR[16];

  uint8_t SMPU_reserved1[640];
  struct {
    union {                            /* Region Descriptor n, Word 0 */
      vuint32_t R;
      struct {
        vuint32_t SRTADDR:32;          /* Start address */
      } B;
    } WORD0;
    union {                            /* Region Descriptor n, Word 1 */
      vuint32_t R;
      struct {
        vuint32_t ENDADDR:32;          /* End address */
      } B;
    } WORD1;
    union {                            /* Region Descriptor n, Word 2 */
      vuint32_t R;
      struct {
        vuint32_t M0P:2;               /* Bus master 0 permissions */
        vuint32_t M1P:2;               /* Bus master 1 permissions */
        vuint32_t M2P:2;               /* Bus master 2 permissions */
        vuint32_t M3P:2;               /* Bus master 3 permissions */
        vuint32_t M4P:2;               /* Bus master 4 permissions */
        vuint32_t M5P:2;               /* Bus master 5 permissions */
        vuint32_t M6P:2;               /* Bus master 6 permissions */
        vuint32_t M7P:2;               /* Bus master 7 permissions */
        vuint32_t M8P:2;               /* Bus master 8 permissions */
        vuint32_t M9P:2;               /* Bus master 9 permissions */
        vuint32_t M10P:2;              /* Bus master 10 permissions */
        vuint32_t M11P:2;              /* Bus master 11 permissions */
        vuint32_t M12P:2;              /* Bus master 12 permissions */
        vuint32_t M13P:2;              /* Bus master 13 permissions */
        vuint32_t M14P:2;              /* Bus master 14 permissions */
        vuint32_t M15P:2;              /* Bus master 15 permissions */
      } B;
    } WORD2;
    union {                            /* Region Descriptor n, Word 3 */
      vuint32_t R;
      struct {
        vuint32_t  :28;
        vuint32_t RO:1;                /* Read-Only */
        vuint32_t  :1;
        vuint32_t CI:1;                /* Cache Inhibit */
        vuint32_t VLD:1;               /* Valid */
      } B;
    } WORD3;
  } RGD[12];
};


/* ============================================================================
   =============================== Module: SRX ================================
   ============================================================================ */

struct SRX_tag {
  union {                              /* Global Control Register */
    vuint32_t R;
    struct {
      vuint32_t TSPRSC:8;
      vuint32_t  :14;
      vuint32_t FMDUIE:1;
      vuint32_t SMDUIE:1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t FAST_CLR:1;
      vuint32_t  :1;
      vuint32_t DBG_FRZ:1;
      vuint32_t  :1;
      vuint32_t SENT_EN:1;
    } B;
  } GBL_CTRL;

  union {                              /* Channel Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t EN_CH:16;
    } B;
  } CHNL_EN;

  union {                              /* Global Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :22;
      vuint32_t FDMU:1;
      vuint32_t SMDU:1;
      vuint32_t  :8;
    } B;
  } GBL_STATUS;

  union {                              /* Fast Message Ready Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t F_RDY:16;
    } B;
  } FMSG_RDY;

  union {                              /* Slow Serial Message Ready Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t S_RDY:16;
    } B;
  } SMSG_RDY;

  uint8_t SRX_reserved0[4];
  union {                              /* Data Control Register 1 */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t NIBBCH0:3;
      vuint32_t  :1;
      vuint32_t NIBBCH1:3;
      vuint32_t  :1;
      vuint32_t NIBBCH2:3;
      vuint32_t  :1;
      vuint32_t NIBBCH3:3;
      vuint32_t  :1;
      vuint32_t NIBBCH4:3;
      vuint32_t  :1;
      vuint32_t NIBBCH5:3;
      vuint32_t  :1;
      vuint32_t NIBBCH6:3;
      vuint32_t  :1;
      vuint32_t NIBBCH7:3;
    } B;
  } DATA_CTRL1;

  union {                              /* Data Control Register 2 */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t NIBBCH8:3;
      vuint32_t  :1;
      vuint32_t NIBBCH9:3;
      vuint32_t  :1;
      vuint32_t NIBBCH10:3;
      vuint32_t  :1;
      vuint32_t NIBBCH11:3;
      vuint32_t  :1;
      vuint32_t NIBBCH12:3;
      vuint32_t  :1;
      vuint32_t NIBBCH13:3;
      vuint32_t  :1;
      vuint32_t NIBBCH14:3;
      vuint32_t  :1;
      vuint32_t NIBBCH15:3;
    } B;
  } DATA_CTRL2;

  uint8_t SRX_reserved1[8];
  union {                              /* Fast Message DMA Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t FDMA_EN:16;
    } B;
  } FDMA_CTRL;

  union {                              /* Slow Serial Message DMA Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SDMA_EN:16;
    } B;
  } SDMA_CTRL;

  uint8_t SRX_reserved2[4];
  union {                              /* Fast Message Ready Interrupt Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t FRDY_IE:16;
    } B;
  } FRDY_IE;

  union {                              /* Slow Serial Message Ready Interrupt Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SRDY_IE:16;
    } B;
  } SRDY_IE;

  uint8_t SRX_reserved3[4];
  union {                              /* DMA Fast Message Data Read Register */
    vuint32_t R;
    struct {
      vuint32_t CHNUM:4;
      vuint32_t SCNIB:4;
      vuint32_t DNIB1:4;
      vuint32_t DNIB2:4;
      vuint32_t DNIB3:4;
      vuint32_t DNIB4:4;
      vuint32_t DNIB5:4;
      vuint32_t DNIB6:4;
    } B;
  } DMA_FMSG_DATA;

  union {                              /* DMA Fast Message CRC Read Register */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t CRC4b:4;
      vuint32_t  :16;
    } B;
  } DMA_FMSG_CRC;

  union {                              /* DMA Fast Message Time Stamp Read Register */
    vuint32_t R;
    struct {
      vuint32_t TS:32;
    } B;
  } DMA_FMSG_TS;

  uint8_t SRX_reserved4[4];
  union {                              /* DMA Slow Serial Message Bit3 Read Register */
    vuint32_t R;
    struct {
      vuint32_t CHNUM:4;
      vuint32_t TYPE:1;
      vuint32_t  :16;
      vuint32_t CFG:1;
      vuint32_t ID7_4_D3_0:4;
      vuint32_t  :1;
      vuint32_t ID3_0_DATA15_12:4;
      vuint32_t  :1;
    } B;
  } DMA_SMSG_BIT3;

  union {                              /* DMA Slow Serial Message Bit2 Read Register */
    vuint32_t R;
    struct {
      vuint32_t  :10;
      vuint32_t SMCRC:6;
      vuint32_t  :4;
      vuint32_t DATA:12;
    } B;
  } DMA_SMSG_BIT2;

  union {                              /* DMA Slow Serial Message Time Stamp Read Register */
    vuint32_t R;
    struct {
      vuint32_t TS:32;
    } B;
  } DMA_SMSG_TS;

  uint8_t SRX_reserved5[4];
  struct {
    union {                            /* Channel 'n' Clock Control Register (n = 0 to (CH-1)) */
      vuint32_t R;
      struct {
        vuint32_t  :1;
        vuint32_t CM_PRSC:15;
        vuint32_t COMP_EN:1;
        vuint32_t  :1;
        vuint32_t PRSC:14;
      } B;
    } CLK_CTRL;
    union {                            /* Channel 'n' Status Register (n=0 to (CH-1)) */
      vuint32_t R;
      struct {
        vuint32_t BUS_IDLE:1;
        vuint32_t  :3;
        vuint32_t CAL_RESYNC:1;
        vuint32_t CAL_20_25:1;
        vuint32_t SMSG_OFLW:1;
        vuint32_t FMSG_OFLW:1;
        vuint32_t  :1;
        vuint32_t PP_DIAG_ERR:1;
        vuint32_t CAL_LEN_ERR:1;
        vuint32_t CAL_DIAG_ERR:1;
        vuint32_t NIB_VAL_ERR:1;
        vuint32_t SMSG_CRC_ERR:1;
        vuint32_t FMSG_CRC_ERR:1;
        vuint32_t NUM_EDGES_ERR:1;
        vuint32_t  :16;
      } B;
    } STATUS;
    union {                            /* Channel 'n' Configuration Register (n=0 to (CH-1)) */
      vuint32_t R;
      struct {
        vuint32_t BUS_IDLE_CNT:4;
        vuint32_t IE_CAL_RESYNC:1;
        vuint32_t IE_CAL_20_25:1;
        vuint32_t IE_SMSG_OFLW:1;
        vuint32_t IE_FMSG_OFLW:1;
        vuint32_t FCRC_CHK_OFF:1;
        vuint32_t IE_PP_DIAG_ERR:1;
        vuint32_t IE_CAL_LEN_ERR:1;
        vuint32_t IE_CAL_DIAG_ERR:1;
        vuint32_t IE_NIB_VAL_ERR:1;
        vuint32_t IE_SMSG_CRC_ERR:1;
        vuint32_t IE_FMSG_CRC_ERR:1;
        vuint32_t IE_NUM_EDGES_ERR:1;
        vuint32_t DCHNG_INT:1;
        vuint32_t CAL_RNG:1;
        vuint32_t PP_CHKSEL:1;
        vuint32_t FCRC_TYPE:1;
        vuint32_t FCRC_SC_EN:1;
        vuint32_t SCRC_TYPE:1;
        vuint32_t PAUSE_EN:1;
        vuint32_t SUCC_CAL_CHK:1;
        vuint32_t FIL_CNT:8;
      } B;
    } CONFIG;
    uint8_t CH_reserved0[4];
  } CH[16];

  struct {
    union {                            /* Channel 'n' Fast Message Data Read Register (n=0 to (CH-1)) */
      vuint32_t R;
      struct {
        vuint32_t CHNUM:4;
        vuint32_t SCNIB:4;
        vuint32_t DNIB1:4;
        vuint32_t DNIB2:4;
        vuint32_t DNIB3:4;
        vuint32_t DNIB4:4;
        vuint32_t DNIB5:4;
        vuint32_t DNIB6:4;
      } B;
    } FMSG_DATA;
    union {                            /* Channel 'n' Fast Message CRC Read Register (n=0 to (CH-1)) */
      vuint32_t R;
      struct {
        vuint32_t  :12;
        vuint32_t CRC4b:4;
        vuint32_t  :16;
      } B;
    } FMSG_CRC;
    union {                            /* Channel 'n' Fast Message Time Stamp Read Register (n=0 to (CH-1)) */
      vuint32_t R;
      struct {
        vuint32_t TS:32;
      } B;
    } FMSG_TS;
    union {                            /* Channel 'n' Serial Message Read Register (Bit 3) (n=0 to (CH-1)) */
      vuint32_t R;
      struct {
        vuint32_t CHNUM:4;
        vuint32_t TYPE:1;
        vuint32_t  :16;
        vuint32_t CFG:1;
        vuint32_t ID7_4_ID3_0:4;
        vuint32_t  :1;
        vuint32_t ID3_0_DATA15_12:4;
        vuint32_t  :1;
      } B;
    } SMSG_BIT3;
    union {                            /* Channel 'n' Serial Message Read Register (Bit 2)(n=0 to (CH-1)) */
      vuint32_t R;
      struct {
        vuint32_t  :10;
        vuint32_t SMCRC:6;
        vuint32_t  :4;
        vuint32_t DATA:12;
      } B;
    } SMSG_BIT2;
    union {                            /* Channel 'n' Serial Message Time Stamp Read Register (n=0 to (CH-1)) */
      vuint32_t R;
      struct {
        vuint32_t TS:32;
      } B;
    } SMSG_TS;
  } CHANNEL[16];
};


/* ============================================================================
   =============================== Module: SSCM ===============================
   ============================================================================ */

struct SSCM_tag {
  union {                              /* SSCM System Status */
    vuint16_t R;
    struct {
      vuint16_t  :1;
      vuint16_t CER:1;                 /* Configuration Error */
      vuint16_t CERS:1;                /* Configuration Error for Safe DCF Clients */
      vuint16_t NXEN1:1;               /* Processor 1 Nexus enable status */
      vuint16_t NXEN:1;                /* Processor 0 Nexus enable status */
      vuint16_t  :1;
      vuint16_t  :1;
      vuint16_t  :1;
      vuint16_t BMODE:3;               /* Device Boot Mode */
      vuint16_t VLE:1;
      vuint16_t  :1;
      vuint16_t  :1;
      vuint16_t  :2;
    } B;
  } STATUS;

  union {                              /* SSCM System Memory and ID Register */
    vuint16_t R;
    struct {
      vuint16_t JPIN:10;
      vuint16_t  :1;
      vuint16_t MREV:4;                /* Minor Mask Revision */
      vuint16_t  :1;
    } B;
  } MEMCONFIG;

  uint8_t SSCM_reserved0[36];
  union {                              /* Processor Start Address Register */
    vuint32_t R;
    struct {
      vuint32_t SADR:32;               /* Processor Start Address */
    } B;
  } PSA;

  union {                              /* Code Length Register */
    vuint32_t R;
    struct {
      vuint32_t CL:32;                 /* Length of the code for the identified boot sector */
    } B;
  } CLEN;

  uint8_t SSCM_reserved1[4];
  union {                              /* Life Cycle Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :22;
      vuint32_t TLC:2;                 /* Test Life Cycle */
      vuint32_t  :5;
      vuint32_t LC:3;                  /* Life Cycle */
    } B;
  } LCSTAT;
};


/* ============================================================================
   =============================== Module: STCU2 ==============================
   ============================================================================ */

struct STCU2_tag {
  union {                              /* STCU2 Run Register */
    vuint32_t R;
    struct {
      vuint32_t  :21;
      vuint32_t BYP:1;
      vuint32_t MBPLLEN:1;
      vuint32_t LBPLLEN:1;
      vuint32_t  :7;
      vuint32_t RUN:1;
    } B;
  } RUN;

  union {                              /* STCU2 Run Software Register */
    vuint32_t R;
    struct {
      vuint32_t  :20;
      vuint32_t MBIE:1;
      vuint32_t LBIE:1;
      vuint32_t MBSWPLLEN:1;
      vuint32_t LBSWPLLEN:1;
      vuint32_t  :6;
      vuint32_t RUNSW_ABORT:1;
      vuint32_t RUNSW:1;
    } B;
  } RUNSW;

  union {                              /* STCU2 SK Code Register */
    vuint32_t R;
    struct {
      vuint32_t SKC:32;
    } B;
  } SKC;

  union {                              /* STCU2 Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t PTR:7;
      vuint32_t LB_DELAY:8;
      vuint32_t  :7;
      vuint32_t WRP:1;
      vuint32_t  :2;
      vuint32_t CRCEN:1;
      vuint32_t PMOSEN:1;
      vuint32_t MBU:1;
      vuint32_t CLK_CFG:3;
    } B;
  } CFG;

  union {                              /* STCU2 PLL Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t PLLODF:6;
      vuint32_t  :5;
      vuint32_t PLLIDF:3;
      vuint32_t  :9;
      vuint32_t PLLLDF:7;
    } B;
  } PLL_CFG;

  union {                              /* STCU2 Watchdog Register Granularity */
    vuint32_t R;
    struct {
      vuint32_t WDGEOC:32;
    } B;
  } WDG;

  union {                              /* STCU2 Interrupt Flag Register */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t MBIFLG:1;
      vuint32_t LBIFLG:1;
    } B;
  } INT_FLG;

  union {                              /* STCU2 CRC Expected Status Register */
    vuint32_t R;
    struct {
      vuint32_t CRCE:32;
    } B;
  } CRCE;

  union {                              /* STCU2 CRC Read Status Register */
    vuint32_t R;
    struct {
      vuint32_t CRCR:32;
    } B;
  } CRCR;

  union {                              /* STCU2 Error Register */
    vuint32_t R;
    struct {
      vuint32_t  :6;
      vuint32_t ABORTHW:1;
      vuint32_t ABORTSW:1;
      vuint32_t  :3;
      vuint32_t LOCKESW:1;
      vuint32_t WDTOSW:1;
      vuint32_t CRCSSW:1;
      vuint32_t ENGESW:1;
      vuint32_t INVPSW:1;
      vuint32_t  :6;
      vuint32_t UFSF:1;
      vuint32_t RFSF:1;
      vuint32_t  :3;
      vuint32_t LOCKE:1;
      vuint32_t WDTO:1;
      vuint32_t CRCS:1;
      vuint32_t ENGE:1;
      vuint32_t INVP:1;
    } B;
  } ERR_STAT;

  union {                              /* STCU2 Error FM Register */
    vuint32_t R;
    struct {
      vuint32_t  :27;
      vuint32_t LOCKEUFM:1;
      vuint32_t WDTOUFM:1;
      vuint32_t CRCSUFM:1;
      vuint32_t ENGEUFM:1;
      vuint32_t INVPUFM:1;
    } B;
  } ERR_FM;

  union {                              /* STCU2 Off-Line LBIST Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t LBS15:1;
      vuint32_t LBS14:1;
      vuint32_t LBS13:1;
      vuint32_t LBS12:1;
      vuint32_t LBS11:1;
      vuint32_t LBS10:1;
      vuint32_t LBS9:1;
      vuint32_t LBS8:1;
      vuint32_t LBS7:1;
      vuint32_t LBS6:1;
      vuint32_t LBS5:1;
      vuint32_t LBS4:1;
      vuint32_t LBS3:1;
      vuint32_t LBS2:1;
      vuint32_t LBS1:1;
      vuint32_t LBS0:1;
    } B;
  } LBS;

  union {                              /* STCU2 Off-Line LBIST End Flag Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t LBE15:1;
      vuint32_t LBE14:1;
      vuint32_t LBE13:1;
      vuint32_t LBE12:1;
      vuint32_t LBE11:1;
      vuint32_t LBE10:1;
      vuint32_t LBE9:1;
      vuint32_t LBE8:1;
      vuint32_t LBE7:1;
      vuint32_t LBE6:1;
      vuint32_t LBE5:1;
      vuint32_t LBE4:1;
      vuint32_t LBE3:1;
      vuint32_t LBE2:1;
      vuint32_t LBE1:1;
      vuint32_t LBE0:1;
    } B;
  } LBE;

  union {                              /* STCU2 On-Line LBIST Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t LBSSW15:1;
      vuint32_t LBSSW14:1;
      vuint32_t LBSSW13:1;
      vuint32_t LBSSW12:1;
      vuint32_t LBSSW11:1;
      vuint32_t LBSSW10:1;
      vuint32_t LBSSW9:1;
      vuint32_t LBSSW8:1;
      vuint32_t LBSSW7:1;
      vuint32_t LBSSW6:1;
      vuint32_t LBSSW5:1;
      vuint32_t LBSSW4:1;
      vuint32_t LBSSW3:1;
      vuint32_t LBSSW2:1;
      vuint32_t LBSSW1:1;
      vuint32_t LBSSW0:1;
    } B;
  } LBSSW;

  union {                              /* STCU2 On-Line LBIST End Flag Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t LBESW15:1;
      vuint32_t LBESW14:1;
      vuint32_t LBESW13:1;
      vuint32_t LBESW12:1;
      vuint32_t LBESW11:1;
      vuint32_t LBESW10:1;
      vuint32_t LBESW9:1;
      vuint32_t LBESW8:1;
      vuint32_t LBESW7:1;
      vuint32_t LBESW6:1;
      vuint32_t LBESW5:1;
      vuint32_t LBESW4:1;
      vuint32_t LBESW3:1;
      vuint32_t LBESW2:1;
      vuint32_t LBESW1:1;
      vuint32_t LBESW0:1;
    } B;
  } LBESW;

  uint8_t STCU2_reserved0[4];
  union {                              /* STCU2 LBIST Unrecoverable FM Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t LBUFM15:1;
      vuint32_t LBUFM14:1;
      vuint32_t LBUFM13:1;
      vuint32_t LBUFM12:1;
      vuint32_t LBUFM11:1;
      vuint32_t LBUFM10:1;
      vuint32_t LBUFM9:1;
      vuint32_t LBUFM8:1;
      vuint32_t LBUFM7:1;
      vuint32_t LBUFM6:1;
      vuint32_t LBUFM5:1;
      vuint32_t LBUFM4:1;
      vuint32_t LBUFM3:1;
      vuint32_t LBUFM2:1;
      vuint32_t LBUFM1:1;
      vuint32_t LBUFM0:1;
    } B;
  } LBUFM;

  union {                              /* STCU2 Off-Line MBIST Status Low Register */
    vuint32_t R;
    struct {
      vuint32_t MBS31:1;
      vuint32_t MBS30:1;
      vuint32_t MBS29:1;
      vuint32_t MBS28:1;
      vuint32_t MBS27:1;
      vuint32_t MBS26:1;
      vuint32_t MBS25:1;
      vuint32_t MBS24:1;
      vuint32_t MBS23:1;
      vuint32_t MBS22:1;
      vuint32_t MBS21:1;
      vuint32_t MBS20:1;
      vuint32_t MBS19:1;
      vuint32_t MBS18:1;
      vuint32_t MBS17:1;
      vuint32_t MBS16:1;
      vuint32_t MBS15:1;
      vuint32_t MBS14:1;
      vuint32_t MBS13:1;
      vuint32_t MBS12:1;
      vuint32_t MBS11:1;
      vuint32_t MBS10:1;
      vuint32_t MBS9:1;
      vuint32_t MBS8:1;
      vuint32_t MBS7:1;
      vuint32_t MBS6:1;
      vuint32_t MBS5:1;
      vuint32_t MBS4:1;
      vuint32_t MBS3:1;
      vuint32_t MBS2:1;
      vuint32_t MBS1:1;
      vuint32_t MBS0:1;
    } B;
  } MBSL;

  union {                              /* STCU2 Off-Line MBIST Status Medium Register */
    vuint32_t R;
    struct {
      vuint32_t MBS63:1;
      vuint32_t MBS62:1;
      vuint32_t MBS61:1;
      vuint32_t MBS60:1;
      vuint32_t MBS59:1;
      vuint32_t MBS58:1;
      vuint32_t MBS57:1;
      vuint32_t MBS56:1;
      vuint32_t MBS55:1;
      vuint32_t MBS54:1;
      vuint32_t MBS53:1;
      vuint32_t MBS52:1;
      vuint32_t MBS51:1;
      vuint32_t MBS50:1;
      vuint32_t MBS49:1;
      vuint32_t MBS48:1;
      vuint32_t MBS47:1;
      vuint32_t MBS46:1;
      vuint32_t MBS45:1;
      vuint32_t MBS44:1;
      vuint32_t MBS43:1;
      vuint32_t MBS42:1;
      vuint32_t MBS41:1;
      vuint32_t MBS40:1;
      vuint32_t MBS39:1;
      vuint32_t MBS38:1;
      vuint32_t MBS37:1;
      vuint32_t MBS36:1;
      vuint32_t MBS35:1;
      vuint32_t MBS34:1;
      vuint32_t MBS33:1;
      vuint32_t MBS32:1;
    } B;
  } MBSM;

  union {                              /* STCU2 Off-Line MBIST Status High Register */
    vuint32_t R;
    struct {
      vuint32_t MBS95:1;
      vuint32_t MBS94:1;
      vuint32_t MBS93:1;
      vuint32_t MBS92:1;
      vuint32_t MBS91:1;
      vuint32_t MBS90:1;
      vuint32_t MBS89:1;
      vuint32_t MBS88:1;
      vuint32_t MBS87:1;
      vuint32_t MBS86:1;
      vuint32_t MBS85:1;
      vuint32_t MBS84:1;
      vuint32_t MBS83:1;
      vuint32_t MBS82:1;
      vuint32_t MBS81:1;
      vuint32_t MBS80:1;
      vuint32_t MBS79:1;
      vuint32_t MBS78:1;
      vuint32_t MBS77:1;
      vuint32_t MBS76:1;
      vuint32_t MBS75:1;
      vuint32_t MBS74:1;
      vuint32_t MBS73:1;
      vuint32_t MBS72:1;
      vuint32_t MBS71:1;
      vuint32_t MBS70:1;
      vuint32_t MBS69:1;
      vuint32_t MBS68:1;
      vuint32_t MBS67:1;
      vuint32_t MBS66:1;
      vuint32_t MBS65:1;
      vuint32_t MBS64:1;
    } B;
  } MBSH;

  union {                              /* STCU2 Off-Line MBIST End Flag Low Register */
    vuint32_t R;
    struct {
      vuint32_t MBE31:1;
      vuint32_t MBE30:1;
      vuint32_t MBE29:1;
      vuint32_t MBE28:1;
      vuint32_t MBE27:1;
      vuint32_t MBE26:1;
      vuint32_t MBE25:1;
      vuint32_t MBE24:1;
      vuint32_t MBE23:1;
      vuint32_t MBE22:1;
      vuint32_t MBE21:1;
      vuint32_t MBE20:1;
      vuint32_t MBE19:1;
      vuint32_t MBE18:1;
      vuint32_t MBE17:1;
      vuint32_t MBE16:1;
      vuint32_t MBE15:1;
      vuint32_t MBE14:1;
      vuint32_t MBE13:1;
      vuint32_t MBE12:1;
      vuint32_t MBE11:1;
      vuint32_t MBE10:1;
      vuint32_t MBE9:1;
      vuint32_t MBE8:1;
      vuint32_t MBE7:1;
      vuint32_t MBE6:1;
      vuint32_t MBE5:1;
      vuint32_t MBE4:1;
      vuint32_t MBE3:1;
      vuint32_t MBE2:1;
      vuint32_t MBE1:1;
      vuint32_t MBE0:1;
    } B;
  } MBEL;

  union {                              /* STCU2 Off-Line MBIST End Flag Medium Register */
    vuint32_t R;
    struct {
      vuint32_t MBE63:1;
      vuint32_t MBE62:1;
      vuint32_t MBE61:1;
      vuint32_t MBE60:1;
      vuint32_t MBE59:1;
      vuint32_t MBE58:1;
      vuint32_t MBE57:1;
      vuint32_t MBE56:1;
      vuint32_t MBE55:1;
      vuint32_t MBE54:1;
      vuint32_t MBE53:1;
      vuint32_t MBE52:1;
      vuint32_t MBE51:1;
      vuint32_t MBE50:1;
      vuint32_t MBE49:1;
      vuint32_t MBE48:1;
      vuint32_t MBE47:1;
      vuint32_t MBE46:1;
      vuint32_t MBE45:1;
      vuint32_t MBE44:1;
      vuint32_t MBE43:1;
      vuint32_t MBE42:1;
      vuint32_t MBE41:1;
      vuint32_t MBE40:1;
      vuint32_t MBE39:1;
      vuint32_t MBE38:1;
      vuint32_t MBE37:1;
      vuint32_t MBE36:1;
      vuint32_t MBE35:1;
      vuint32_t MBE34:1;
      vuint32_t MBE33:1;
      vuint32_t MBE32:1;
    } B;
  } MBEM;

  union {                              /* STCU2 Off-Line MBIST End Flag High Register */
    vuint32_t R;
    struct {
      vuint32_t MBE95:1;
      vuint32_t MBE94:1;
      vuint32_t MBE93:1;
      vuint32_t MBE92:1;
      vuint32_t MBE91:1;
      vuint32_t MBE90:1;
      vuint32_t MBE89:1;
      vuint32_t MBE88:1;
      vuint32_t MBE87:1;
      vuint32_t MBE86:1;
      vuint32_t MBE85:1;
      vuint32_t MBE84:1;
      vuint32_t MBE83:1;
      vuint32_t MBE82:1;
      vuint32_t MBE81:1;
      vuint32_t MBE80:1;
      vuint32_t MBE79:1;
      vuint32_t MBE78:1;
      vuint32_t MBE77:1;
      vuint32_t MBE76:1;
      vuint32_t MBE75:1;
      vuint32_t MBE74:1;
      vuint32_t MBE73:1;
      vuint32_t MBE72:1;
      vuint32_t MBE71:1;
      vuint32_t MBE70:1;
      vuint32_t MBE69:1;
      vuint32_t MBE68:1;
      vuint32_t MBE67:1;
      vuint32_t MBE66:1;
      vuint32_t MBE65:1;
      vuint32_t MBE64:1;
    } B;
  } MBEH;

  union {                              /* STCU2 On-Line MBIST Status Low Register */
    vuint32_t R;
    struct {
      vuint32_t MBSSW31:1;
      vuint32_t MBSSW30:1;
      vuint32_t MBSSW29:1;
      vuint32_t MBSSW28:1;
      vuint32_t MBSSW27:1;
      vuint32_t MBSSW26:1;
      vuint32_t MBSSW25:1;
      vuint32_t MBSSW24:1;
      vuint32_t MBSSW23:1;
      vuint32_t MBSSW22:1;
      vuint32_t MBSSW21:1;
      vuint32_t MBSSW20:1;
      vuint32_t MBSSW19:1;
      vuint32_t MBSSW18:1;
      vuint32_t MBSSW17:1;
      vuint32_t MBSSW16:1;
      vuint32_t MBSSW15:1;
      vuint32_t MBSSW14:1;
      vuint32_t MBSSW13:1;
      vuint32_t MBSSW12:1;
      vuint32_t MBSSW11:1;
      vuint32_t MBSSW10:1;
      vuint32_t MBSSW9:1;
      vuint32_t MBSSW8:1;
      vuint32_t MBSSW7:1;
      vuint32_t MBSSW6:1;
      vuint32_t MBSSW5:1;
      vuint32_t MBSSW4:1;
      vuint32_t MBSSW3:1;
      vuint32_t MBSSW2:1;
      vuint32_t MBSSW1:1;
      vuint32_t MBSSW0:1;
    } B;
  } MBSLSW;

  union {                              /* STCU2 On-Line MBIST Status Medium Register */
    vuint32_t R;
    struct {
      vuint32_t MBSSW63:1;
      vuint32_t MBSSW62:1;
      vuint32_t MBSSW61:1;
      vuint32_t MBSSW60:1;
      vuint32_t MBSSW59:1;
      vuint32_t MBSSW58:1;
      vuint32_t MBSSW57:1;
      vuint32_t MBSSW56:1;
      vuint32_t MBSSW55:1;
      vuint32_t MBSSW54:1;
      vuint32_t MBSSW53:1;
      vuint32_t MBSSW52:1;
      vuint32_t MBSSW51:1;
      vuint32_t MBSSW50:1;
      vuint32_t MBSSW49:1;
      vuint32_t MBSSW48:1;
      vuint32_t MBSSW47:1;
      vuint32_t MBSSW46:1;
      vuint32_t MBSSW45:1;
      vuint32_t MBSSW44:1;
      vuint32_t MBSSW43:1;
      vuint32_t MBSSW42:1;
      vuint32_t MBSSW41:1;
      vuint32_t MBSSW40:1;
      vuint32_t MBSSW39:1;
      vuint32_t MBSSW38:1;
      vuint32_t MBSSW37:1;
      vuint32_t MBSSW36:1;
      vuint32_t MBSSW35:1;
      vuint32_t MBSSW34:1;
      vuint32_t MBSSW33:1;
      vuint32_t MBSSW32:1;
    } B;
  } MBSMSW;

  union {                              /* STCU2 On-Line MBIST Status High Register */
    vuint32_t R;
    struct {
      vuint32_t MBSSW95:1;
      vuint32_t MBSSW94:1;
      vuint32_t MBSSW93:1;
      vuint32_t MBSSW92:1;
      vuint32_t MBSSW91:1;
      vuint32_t MBSSW90:1;
      vuint32_t MBSSW89:1;
      vuint32_t MBSSW88:1;
      vuint32_t MBSSW87:1;
      vuint32_t MBSSW86:1;
      vuint32_t MBSSW85:1;
      vuint32_t MBSSW84:1;
      vuint32_t MBSSW83:1;
      vuint32_t MBSSW82:1;
      vuint32_t MBSSW81:1;
      vuint32_t MBSSW80:1;
      vuint32_t MBSSW79:1;
      vuint32_t MBSSW78:1;
      vuint32_t MBSSW77:1;
      vuint32_t MBSSW76:1;
      vuint32_t MBSSW75:1;
      vuint32_t MBSSW74:1;
      vuint32_t MBSSW73:1;
      vuint32_t MBSSW72:1;
      vuint32_t MBSSW71:1;
      vuint32_t MBSSW70:1;
      vuint32_t MBSSW69:1;
      vuint32_t MBSSW68:1;
      vuint32_t MBSSW67:1;
      vuint32_t MBSSW66:1;
      vuint32_t MBSSW65:1;
      vuint32_t MBSSW64:1;
    } B;
  } MBSHSW;

  union {                              /* STCU2 On-Line MBIST End Flag Low Register */
    vuint32_t R;
    struct {
      vuint32_t MBESW31:1;
      vuint32_t MBESW30:1;
      vuint32_t MBESW29:1;
      vuint32_t MBESW28:1;
      vuint32_t MBESW27:1;
      vuint32_t MBESW26:1;
      vuint32_t MBESW25:1;
      vuint32_t MBESW24:1;
      vuint32_t MBESW23:1;
      vuint32_t MBESW22:1;
      vuint32_t MBESW21:1;
      vuint32_t MBESW20:1;
      vuint32_t MBESW19:1;
      vuint32_t MBESW18:1;
      vuint32_t MBESW17:1;
      vuint32_t MBESW16:1;
      vuint32_t MBESW15:1;
      vuint32_t MBESW14:1;
      vuint32_t MBESW13:1;
      vuint32_t MBESW12:1;
      vuint32_t MBESW11:1;
      vuint32_t MBESW10:1;
      vuint32_t MBESW9:1;
      vuint32_t MBESW8:1;
      vuint32_t MBESW7:1;
      vuint32_t MBESW6:1;
      vuint32_t MBESW5:1;
      vuint32_t MBESW4:1;
      vuint32_t MBESW3:1;
      vuint32_t MBESW2:1;
      vuint32_t MBESW1:1;
      vuint32_t MBESW0:1;
    } B;
  } MBELSW;

  union {                              /* STCU2 On-Line MBIST End Flag Medium Register */
    vuint32_t R;
    struct {
      vuint32_t MBESW63:1;
      vuint32_t MBESW62:1;
      vuint32_t MBESW61:1;
      vuint32_t MBESW60:1;
      vuint32_t MBESW59:1;
      vuint32_t MBESW58:1;
      vuint32_t MBESW57:1;
      vuint32_t MBESW56:1;
      vuint32_t MBESW55:1;
      vuint32_t MBESW54:1;
      vuint32_t MBESW53:1;
      vuint32_t MBESW52:1;
      vuint32_t MBESW51:1;
      vuint32_t MBESW50:1;
      vuint32_t MBESW49:1;
      vuint32_t MBESW48:1;
      vuint32_t MBESW47:1;
      vuint32_t MBESW46:1;
      vuint32_t MBESW45:1;
      vuint32_t MBESW44:1;
      vuint32_t MBESW43:1;
      vuint32_t MBESW42:1;
      vuint32_t MBESW41:1;
      vuint32_t MBESW40:1;
      vuint32_t MBESW39:1;
      vuint32_t MBESW38:1;
      vuint32_t MBESW37:1;
      vuint32_t MBESW36:1;
      vuint32_t MBESW35:1;
      vuint32_t MBESW34:1;
      vuint32_t MBESW33:1;
      vuint32_t MBESW32:1;
    } B;
  } MBEMSW;

  union {                              /* STCU2 On-Line MBIST End Flag High Register */
    vuint32_t R;
    struct {
      vuint32_t MBESW95:1;
      vuint32_t MBESW94:1;
      vuint32_t MBESW93:1;
      vuint32_t MBESW92:1;
      vuint32_t MBESW91:1;
      vuint32_t MBESW90:1;
      vuint32_t MBESW89:1;
      vuint32_t MBESW88:1;
      vuint32_t MBESW87:1;
      vuint32_t MBESW86:1;
      vuint32_t MBESW85:1;
      vuint32_t MBESW84:1;
      vuint32_t MBESW83:1;
      vuint32_t MBESW82:1;
      vuint32_t MBESW81:1;
      vuint32_t MBESW80:1;
      vuint32_t MBESW79:1;
      vuint32_t MBESW78:1;
      vuint32_t MBESW77:1;
      vuint32_t MBESW76:1;
      vuint32_t MBESW75:1;
      vuint32_t MBESW74:1;
      vuint32_t MBESW73:1;
      vuint32_t MBESW72:1;
      vuint32_t MBESW71:1;
      vuint32_t MBESW70:1;
      vuint32_t MBESW69:1;
      vuint32_t MBESW68:1;
      vuint32_t MBESW67:1;
      vuint32_t MBESW66:1;
      vuint32_t MBESW65:1;
      vuint32_t MBESW64:1;
    } B;
  } MBEHSW;

  union {                              /* STCU2 MBIST Unrecoverable FM Low Register */
    vuint32_t R;
    struct {
      vuint32_t MBUFM31:1;
      vuint32_t MBUFM30:1;
      vuint32_t MBUFM29:1;
      vuint32_t MBUFM28:1;
      vuint32_t MBUFM27:1;
      vuint32_t MBUFM26:1;
      vuint32_t MBUFM25:1;
      vuint32_t MBUFM24:1;
      vuint32_t MBUFM23:1;
      vuint32_t MBUFM22:1;
      vuint32_t MBUFM21:1;
      vuint32_t MBUFM20:1;
      vuint32_t MBUFM19:1;
      vuint32_t MBUFM18:1;
      vuint32_t MBUFM17:1;
      vuint32_t MBUFM16:1;
      vuint32_t MBUFM15:1;
      vuint32_t MBUFM14:1;
      vuint32_t MBUFM13:1;
      vuint32_t MBUFM12:1;
      vuint32_t MBUFM11:1;
      vuint32_t MBUFM10:1;
      vuint32_t MBUFM9:1;
      vuint32_t MBUFM8:1;
      vuint32_t MBUFM7:1;
      vuint32_t MBUFM6:1;
      vuint32_t MBUFM5:1;
      vuint32_t MBUFM4:1;
      vuint32_t MBUFM3:1;
      vuint32_t MBUFM2:1;
      vuint32_t MBUFM1:1;
      vuint32_t MBUFM0:1;
    } B;
  } MBUFML;

  union {                              /* STCU2 MBIST Unrecoverable FM Medium Register */
    vuint32_t R;
    struct {
      vuint32_t MBUFM63:1;
      vuint32_t MBUFM62:1;
      vuint32_t MBUFM61:1;
      vuint32_t MBUFM60:1;
      vuint32_t MBUFM59:1;
      vuint32_t MBUFM58:1;
      vuint32_t MBUFM57:1;
      vuint32_t MBUFM56:1;
      vuint32_t MBUFM55:1;
      vuint32_t MBUFM54:1;
      vuint32_t MBUFM53:1;
      vuint32_t MBUFM52:1;
      vuint32_t MBUFM51:1;
      vuint32_t MBUFM50:1;
      vuint32_t MBUFM49:1;
      vuint32_t MBUFM48:1;
      vuint32_t MBUFM47:1;
      vuint32_t MBUFM46:1;
      vuint32_t MBUFM45:1;
      vuint32_t MBUFM44:1;
      vuint32_t MBUFM43:1;
      vuint32_t MBUFM42:1;
      vuint32_t MBUFM41:1;
      vuint32_t MBUFM40:1;
      vuint32_t MBUFM39:1;
      vuint32_t MBUFM38:1;
      vuint32_t MBUFM37:1;
      vuint32_t MBUFM36:1;
      vuint32_t MBUFM35:1;
      vuint32_t MBUFM34:1;
      vuint32_t MBUFM33:1;
      vuint32_t MBUFM32:1;
    } B;
  } MBUFMM;

  union {                              /* STCU2 MBIST Unrecoverable FM High Register */
    vuint32_t R;
    struct {
      vuint32_t MBUFM95:1;
      vuint32_t MBUFM94:1;
      vuint32_t MBUFM93:1;
      vuint32_t MBUFM92:1;
      vuint32_t MBUFM91:1;
      vuint32_t MBUFM90:1;
      vuint32_t MBUFM89:1;
      vuint32_t MBUFM88:1;
      vuint32_t MBUFM87:1;
      vuint32_t MBUFM86:1;
      vuint32_t MBUFM85:1;
      vuint32_t MBUFM84:1;
      vuint32_t MBUFM83:1;
      vuint32_t MBUFM82:1;
      vuint32_t MBUFM81:1;
      vuint32_t MBUFM80:1;
      vuint32_t MBUFM79:1;
      vuint32_t MBUFM78:1;
      vuint32_t MBUFM77:1;
      vuint32_t MBUFM76:1;
      vuint32_t MBUFM75:1;
      vuint32_t MBUFM74:1;
      vuint32_t MBUFM73:1;
      vuint32_t MBUFM72:1;
      vuint32_t MBUFM71:1;
      vuint32_t MBUFM70:1;
      vuint32_t MBUFM69:1;
      vuint32_t MBUFM68:1;
      vuint32_t MBUFM67:1;
      vuint32_t MBUFM66:1;
      vuint32_t MBUFM65:1;
      vuint32_t MBUFM64:1;
    } B;
  } MBUFMH;

  uint8_t STCU2_reserved1[128];
  struct {
    union {                            /* STCU2 LBIST Control Register */
      vuint32_t R;
      struct {
        vuint32_t CSM:1;
        vuint32_t PTR:7;
        vuint32_t  :4;
        vuint32_t PRPGEN:1;
        vuint32_t SHS:3;
        vuint32_t SCEN_OFF:4;
        vuint32_t SCEN_ON:4;
        vuint32_t  :4;
        vuint32_t PFT:1;
        vuint32_t CWS:3;
      } B;
    } CTRL;
    union {                            /* STCU2 LBIST PC Stop Register */
      vuint32_t R;
      struct {
        vuint32_t  :6;
        vuint32_t PCS:26;
      } B;
    } PCS;
    union {                            /* STCU2 LBIST PRPG Low Register */
      vuint32_t R;
      struct {
        vuint32_t PRPGx:32;
      } B;
    } PRPGL;
    union {                            /* STCU2 LBIST PRPG High Register */
      vuint32_t R;
      struct {
        vuint32_t PRPGx:32;
      } B;
    } PRPGH;
    union {                            /* STCU2 Off-Line LBIST MISR Expected Low Register */
      vuint32_t R;
      struct {
        vuint32_t MISREx:32;
      } B;
    } MISREL;
    union {                            /* STCU2 Off-Line LBIST MISR Expected High Register */
      vuint32_t R;
      struct {
        vuint32_t MISREx:32;
      } B;
    } MISREH;
    union {                            /* STCU2 Off-Line LBIST MISR Read Low Register */
      vuint32_t R;
      struct {
        vuint32_t MISRRx:32;
      } B;
    } MISRRL;
    union {                            /* STCU2 Off-Line LBIST MISR Read High Register */
      vuint32_t R;
      struct {
        vuint32_t MISRRx:32;
      } B;
    } MISRRH;
    union {                            /* STCU2 On-Line LBIST MISR Expected Low Register */
      vuint32_t R;
      struct {
        vuint32_t MISRESWx:32;
      } B;
    } MISRELSW;
    union {                            /* STCU2 On-Line LBIST MISR Expected High Register */
      vuint32_t R;
      struct {
        vuint32_t MISRESWx:32;
      } B;
    } MISREHSW;
    union {                            /* STCU2 On-Line LBIST MISR Read Low Register */
      vuint32_t R;
      struct {
        vuint32_t MISRRSWx:32;
      } B;
    } MISRRLSW;
    union {                            /* STCU2 On-Line LBIST MISR Read High Register */
      vuint32_t R;
      struct {
        vuint32_t MISRRSWx:32;
      } B;
    } MISRRHSW;
    uint8_t LB_reserved0[16];
  } LB[10];

  uint8_t STCU2_reserved2[640];
  union {                              /* STCU2 MBIST Control Register */
    vuint32_t R;
    struct {
      vuint32_t CSM:1;
      vuint32_t PTR:7;
      vuint32_t  :24;
    } B;
  } MB_CTRL[70];
};


/* ============================================================================
   =============================== Module: STM ================================
   ============================================================================ */

struct STM_tag {
  union {                              /* STM Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CPS:8;                 /* Counter Prescaler. */
      vuint32_t  :6;
      vuint32_t FRZ:1;                 /* Freeze. */
      vuint32_t TEN:1;                 /* Timer counter Enabled. */
    } B;
  } CR;

  union {                              /* STM Count Register */
    vuint32_t R;
    struct {
      vuint32_t CNT:32;                /* Timer count value used as the time base for all channels. */
    } B;
  } CNT;

  uint8_t STM_reserved0[8];
  struct {
    union {                            /* STM Channel Control Register */
      vuint32_t R;
      struct {
        vuint32_t  :31;
        vuint32_t CEN:1;               /* Channel Enable */
      } B;
    } CCR;
    union {                            /* STM Channel Interrupt Register */
      vuint32_t R;
      struct {
        vuint32_t  :31;
        vuint32_t CIF:1;               /* Channel Interrupt Flag */
      } B;
    } CIR;
    union {                            /* STM Channel Compare Register */
      vuint32_t R;
      struct {
        vuint32_t CMP:32;              /* Compare value for channel n. */
      } B;
    } CMP;
    uint8_t CHANNEL_reserved0[4];
  } CHANNEL[4];
};


/* ============================================================================
   =============================== Module: SWT ================================
   ============================================================================ */

struct SWT_tag {
  union {                              /* SWT Control Register */
    vuint32_t R;
    struct {
      vuint32_t MAP0:1;
      vuint32_t MAP1:1;
      vuint32_t MAP2:1;
      vuint32_t MAP3:1;
      vuint32_t MAP4:1;
      vuint32_t MAP5:1;
      vuint32_t MAP6:1;
      vuint32_t MAP7:1;
      vuint32_t  :13;
      vuint32_t SMD:2;                 /* Service Mode. */
      vuint32_t RIA:1;
      vuint32_t WND:1;
      vuint32_t ITR:1;
      vuint32_t HLK:1;
      vuint32_t SLK:1;
      vuint32_t  :1;                   /* Reserved. */
      vuint32_t STP:1;
      vuint32_t FRZ:1;
      vuint32_t WEN:1;
    } B;
  } CR;

  union {                              /* SWT Interrupt Register */
    vuint32_t R;
    struct {
      vuint32_t  :31;
      vuint32_t TIF:1;
    } B;
  } IR;

  union {                              /* SWT Time-out Register */
    vuint32_t R;
    struct {
      vuint32_t WTO:32;
    } B;
  } TO;

  union {                              /* SWT Window Register */
    vuint32_t R;
    struct {
      vuint32_t WST:32;
    } B;
  } WN;

  union {                              /* SWT Service Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t WSC:16;
    } B;
  } SR;

  union {                              /* SWT Counter Output Register */
    vuint32_t R;
    struct {
      vuint32_t CNT:32;
    } B;
  } CO;

  union {                              /* SWT Service Key Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SK:16;                 /* Service Key. */
    } B;
  } SK;
};


/* ============================================================================
   =============================== Module: TDM ================================
   ============================================================================ */

struct TDM_tag {
  union {                              /* TDR Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t TDRSR5:1;
      vuint32_t TDRSR4:1;
      vuint32_t TDRSR3:1;
      vuint32_t TDRSR2:1;
      vuint32_t TDRSR1:1;
      vuint32_t TDRSR0:1;
    } B;
  } TDRSR;

  union {                              /* Last Flash Programmed Address Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t LFPAR:24;
    } B;
  } LFPAR;

  union {                              /* Diary Base Address */
    vuint32_t R;
    struct {
      vuint32_t DBA:32;
    } B;
  } DBA;
};


/* ============================================================================
   =============================== Module: WKPU ===============================
   ============================================================================ */

struct WKPU_tag {
  union {                              /* NMI Status Flag Register */
    vuint32_t R;
    struct {
      vuint32_t NIF0:1;                /* NMI Status Flag 0 (safety core) */
      vuint32_t NOVF0:1;               /* NMI Overrun Status Flag 0 (safety core) */
      vuint32_t  :6;
      vuint32_t NIF1:1;                /* NMI Status Flag 1 (Core 1) */
      vuint32_t NOVF1:1;               /* NMI Overrun Status Flag 1 (Core 1) */
      vuint32_t  :6;
      vuint32_t  :8;
      vuint32_t  :8;
    } B;
  } NSR;

  uint8_t WKPU_reserved0[4];
  union {                              /* NMI Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t NLOCK0:1;              /* NMI Configuration Lock Register 0 */
      vuint32_t NDSS0:2;               /* NMI Destination Source Select 0 */
      vuint32_t NWRE0:1;               /* NMI Wakeup Request Enable 0 */
      vuint32_t  :1;
      vuint32_t NREE0:1;               /* NMI Rising-edge Events Enable 0 */
      vuint32_t NFEE0:1;               /* NMI Falling-edge Events Enable 0 */
      vuint32_t NFE0:1;                /* NMI Filter Enable */
      vuint32_t NLOCK1:1;              /* NMI Configuration Lock Register 1 */
      vuint32_t NDSS1:2;               /* NMI Destination Source Select 1 */
      vuint32_t NWRE1:1;               /* NMI Wakeup Request Enable 1 */
      vuint32_t  :1;
      vuint32_t NREE1:1;               /* NMI Rising-edge Events Enable 1 */
      vuint32_t NFEE1:1;               /* NMI Falling-edge Events Enable 1 */
      vuint32_t  :1;
      vuint32_t  :8;
      vuint32_t  :8;
    } B;
  } NCR;
};


/* ============================================================================
   =============================== Module: XBAR ===============================
   ============================================================================ */

struct XBAR_tag {
  struct {
    union {                            /* Priority Registers Slave */
      vuint32_t R;
      struct {
        vuint32_t  :1;
        vuint32_t  :3;
        vuint32_t  :1;
        vuint32_t  :3;
        vuint32_t  :1;
        vuint32_t  :3;
        vuint32_t  :1;
        vuint32_t M4:3;                /* Master 4 Priority. Sets the arbitration priority for this port on the associated slave port. */
        vuint32_t  :1;
        vuint32_t M3:3;                /* Master 3 Priority. Sets the arbitration priority for this port on the associated slave port. */
        vuint32_t  :1;
        vuint32_t M2:3;                /* Master 2 Priority. Sets the arbitration priority for this port on the associated slave port. */
        vuint32_t  :1;
        vuint32_t M1:3;                /* Master 1 Priority. Sets the arbitration priority for this port on the associated slave port. */
        vuint32_t  :1;
        vuint32_t M0:3;                /* Master 0 Priority. Sets the arbitration priority for this port on the associated slave port. */
      } B;
    } PRS;
    uint8_t PORT_reserved0[12];
    union {                            /* Control Register */
      vuint32_t R;
      struct {
        vuint32_t RO:1;                /* Read Only */
        vuint32_t  :1;
        vuint32_t  :20;
        vuint32_t ARB:2;               /* Arbitration Mode */
        vuint32_t  :2;
        vuint32_t PCTL:2;              /* Parking Control */
        vuint32_t  :1;
        vuint32_t PARK:3;              /* Park */
      } B;
    } CRS;
    uint8_t PORT_reserved1[236];
  } PORT[8];

  struct {
    union {                            /* Master General Purpose Control Register */
      vuint32_t R;
      struct {
        vuint32_t  :29;
        vuint32_t AULB:3;              /* Arbitrates On Undefined Length Bursts */
      } B;
    } MGPCR;
    uint8_t MGPCR_reserved0[252];
  } MGPCR[8];
};


/* ============================================================================
   =============================== Module: XOSC ===============================
   ============================================================================ */

struct XOSC_tag {
  union {                              /* XOSC Control Register */
    vuint32_t R;
    struct {
      vuint32_t OSCBYP:1;
      vuint32_t  :7;
      vuint32_t EOCV:8;                /* End of Count Value */
      vuint32_t M_OSC:1;               /* Crystal oscillator clock interrupt mask */
      vuint32_t  :2;
      vuint32_t  :5;
      vuint32_t I_OSC:1;
      vuint32_t  :5;
      vuint32_t  :1;
      vuint32_t  :1;
    } B;
  } CTL;
};


/* ============================================================================
   =============================== Module: eTPU_CCCR ==========================
   ============================================================================ */

struct eTPU_CCCR_tag {
  uint8_t eTPU_CCCR_reserved0[1024];
  struct {
    union {                            /* eTPU Channel n Configuration Register for Engine 1 */
      vuint32_t R;
      struct {
        vuint32_t CIE:1;               /* Channel Interrupt Enable (see the eTPU Channel Interrupt Enable Register (ETPUCIER)). */
        vuint32_t DTRE:1;              /* Channel Data Transfer Request Enable (see the "Channel Interrupt and Data Transfer Requests" section). */
        vuint32_t CPR:2;               /* Channel Priority. */
        vuint32_t T4DIS:1;             /* T4 channel action Disable. */
        vuint32_t SSMAE:1;             /* Shared Subsystem Microengine Access Enable. */
        vuint32_t ETPD:1;              /* Entry Table Pin Direction. */
        vuint32_t ETCS:1;              /* Entry Table Condition Select. */
        vuint32_t  :3;                 /* Reserved. */
        vuint32_t CFS:5;               /* Channel Function Select. */
        vuint32_t ODIS:1;              /* Output Disable. */
        vuint32_t OPOL:1;              /* Output Polarity. */
        vuint32_t  :3;                 /* Reserved. */
        vuint32_t CPBA:11;             /* Channel n Parameter Base Address. */
      } B;
    } CR;
    union {                            /* eTPU Channel n Status Control Register for Engine 1 */
      vuint32_t R;
      struct {
        vuint32_t CIS:1;               /* Channel Interrupt Status. */
        vuint32_t CIOS:1;              /* Channel Interrupt Overflow Status. */
        vuint32_t  :6;                 /* Reserved. */
        vuint32_t DTRS:1;              /* Data Transfer Request Status. */
        vuint32_t DTROS:1;             /* Data Transfer Request Overflow Status. */
        vuint32_t  :6;                 /* Reserved. */
        vuint32_t IPS:1;               /* Channel Input Pin State. */
        vuint32_t OPS:1;               /* Channel Output Pin State. */
        vuint32_t  :1;                 /* Reserved. */
        vuint32_t  :11;                /* Reserved. */
        vuint32_t FM:2;                /* Channel Function Mode. */
      } B;
    } SCR;
    union {                            /* eTPU Channel n Host Service Request Register for Engine 1 */
      vuint32_t R;
      struct {
        vuint32_t  :29;                /* Reserved. */
        vuint32_t HSR:3;               /* Host Service Request */
      } B;
    } HSRR;
    uint8_t ENG1_C_reserved0[4];
  } ENG1_C[32];       /* C(0-32)CR_ENG1, C(0-32)SCR_ENG1, C(0-32)HSRR_ENG1 */

  uint8_t eTPU_CCCR_reserved1[512];
  struct {
    union {                            /* eTPU Channel n Configuration Register for Engine 2 */
      vuint32_t R;
      struct {
        vuint32_t CIE:1;               /* Channel Interrupt Enable (see the Channel Interrupts ad Data Transfer Requests section). */
        vuint32_t DTRE:1;              /* Channel Data Transfer Request Enable (see the "Channel Interrupt and Data Transfer Requests" section). */
        vuint32_t CPR:2;               /* Channel Priority. */
        vuint32_t T4DIS:1;             /* T4 channel action Disable. */
        vuint32_t SSMAE:1;             /* Shared Subsystem Microengine Access Enable. */
        vuint32_t ETPD:1;              /* Entry Table Pin Direction. */
        vuint32_t ETCS:1;              /* Entry Table Condition Select. */
        vuint32_t  :3;                 /* Reserved. */
        vuint32_t CFS:5;               /* Channel Function Select. */
        vuint32_t ODIS:1;              /* Output Disable. */
        vuint32_t OPOL:1;              /* Output Polarity. */
        vuint32_t  :3;                 /* Reserved. */
        vuint32_t CPBA:11;             /* Channel n Parameter Base Address. */
      } B;
    } CR;
    union {                            /* eTPU Channel n Status Control Register for Engine 2 */
      vuint32_t R;
      struct {
        vuint32_t CIS:1;               /* Channel Interrupt Status. */
        vuint32_t CIOS:1;              /* Channel Interrupt Overflow Status. */
        vuint32_t  :6;                 /* Reserved. */
        vuint32_t DTRS:1;              /* Data Transfer Request Status. */
        vuint32_t DTROS:1;             /* Data Transfer Request Overflow Status. */
        vuint32_t  :6;                 /* Reserved. */
        vuint32_t IPS:1;               /* Channel Input Pin State. */
        vuint32_t OPS:1;               /* Channel Output Pin State. */
        vuint32_t  :1;                 /* Reserved. */
        vuint32_t  :11;                /* Reserved. */
        vuint32_t FM:2;                /* Channel Function Mode. */
      } B;
    } SCR;
    union {                            /* eTPU Channel n Host Service Request Register for Engine 2 */
      vuint32_t R;
      struct {
        vuint32_t  :29;                /* Reserved. */
        vuint32_t HSR:3;               /* Host Service Request */
      } B;
    } HSRR;
    uint8_t ENG2_C_reserved0[4];
  } ENG2_C[32];       /* C(0-32)CR_ENG2, C(0-32)SCR_ENG1, C(0-32)HSRR_ENG2 */
};


/* ============================================================================
   =============================== Module: eTPU_ER ============================
   ============================================================================ */

struct eTPU_ER_tag {
  uint8_t eTPU_ER_reserved0[96];
  union {                              /* eTPU Watchdog Timer Register for Engine 1 */
    vuint32_t R;
    struct {
      vuint32_t WDM:2;                 /* Watchdog Mode. */
      vuint32_t  :1;
      vuint32_t WMO:1;                 /* Watchdog Monitor Operation. */
      vuint32_t  :12;
      vuint32_t WDCNT:16;              /* Watchdog Count. */
    } B;
  } WDTR_ENG1;

  uint8_t eTPU_ER_reserved1[4];
  union {                              /* eTPU Idle Register for Engine 1 */
    vuint32_t R;
    struct {
      vuint32_t IDLE_CNT:31;           /* Idle Count. */
      vuint32_t ICLR:1;                /* Idle Clear. */
    } B;
  } IDLER_ENG1;

  uint8_t eTPU_ER_reserved2[4];
  union {                              /* eTPU Watchdog Timer Register for Engine 2 */
    vuint32_t R;
    struct {
      vuint32_t WDM:2;                 /* Watchdog Mode. */
      vuint32_t  :1;
      vuint32_t WMO:1;                 /* Watchdog Monitor Operation. */
      vuint32_t  :12;
      vuint32_t WDCNT:16;              /* Watchdog Count. */
    } B;
  } WDTR_ENG2;

  uint8_t eTPU_ER_reserved3[4];
  union {                              /* eTPU Idle Register for Engine 2 */
    vuint32_t R;
    struct {
      vuint32_t IDLE_CNT:31;           /* Idle Count. */
      vuint32_t ICLR:1;                /* Idle Clear. */
    } B;
  } IDLER_ENG2;
};


/* ============================================================================
   =============================== Module: eTPU_GCR ===========================
   ============================================================================ */

struct eTPU_GCR_tag {
  uint8_t eTPU_GCR_reserved0[512];
  union {                              /* eTPU Channel Interrupt Status Register for Engine 1 */
    vuint32_t R;
    struct {
      vuint32_t CISn:32;               /* Channel n Interrupt Status. */
    } B;
  } CISR_ENG1;

  union {                              /* eTPU Channel Interrupt Status Register for Engine 2 */
    vuint32_t R;
    struct {
      vuint32_t CISn:32;               /* Channel n Interrupt Status. */
    } B;
  } CISR_ENG2;

  uint8_t eTPU_GCR_reserved1[8];
  union {                              /* eTPU Channel Data Transfer Request Status Register for Engine 1 */
    vuint32_t R;
    struct {
      vuint32_t DTRSn:32;              /* Channel n Data Transfer Request Status. */
    } B;
  } CDTRSR_ENG1;

  union {                              /* eTPU Channel Data Transfer Request Status Register for Engine 2 */
    vuint32_t R;
    struct {
      vuint32_t DTRSn:32;              /* Channel n Data Transfer Request Status. */
    } B;
  } CDTRSR_ENG2;

  uint8_t eTPU_GCR_reserved2[8];
  union {                              /* eTPU Channel Interrupt Overflow Status Register for Engine 1 */
    vuint32_t R;
    struct {
      vuint32_t CIOSn:32;              /* Channel n Interrupt Overflow Status */
    } B;
  } CIOSR_ENG1;

  union {                              /* eTPU Channel Interrupt Overflow Status Register for Engine 2 */
    vuint32_t R;
    struct {
      vuint32_t CIOSn:32;              /* Channel n Interrupt Overflow Status */
    } B;
  } CIOSR_ENG2;

  uint8_t eTPU_GCR_reserved3[8];
  union {                              /* eTPU Channel Data Transfer Request Overflow Status Register for Engine 1 */
    vuint32_t R;
    struct {
      vuint32_t DTROSn:32;             /* Channel n Data Transfer Request Overflow Status. */
    } B;
  } CDTROSR_ENG1;

  union {                              /* eTPU Channel Data Transfer Request Overflow Status Register for Engine 2 */
    vuint32_t R;
    struct {
      vuint32_t DTROSn:32;             /* Channel n Data Transfer Request Overflow Status. */
    } B;
  } CDTROSR_ENG2;

  uint8_t eTPU_GCR_reserved4[8];
  union {                              /* eTPU Channel Interrupt Enable Register for Engine 1 */
    vuint32_t R;
    struct {
      vuint32_t CIEn:32;               /* Channel n Interrupt Enable. */
    } B;
  } CIER_ENG1;

  union {                              /* eTPU Channel Interrupt Enable Register for Engine 2 */
    vuint32_t R;
    struct {
      vuint32_t CIEn:32;               /* Channel n Interrupt Enable. */
    } B;
  } CIER_ENG2;

  uint8_t eTPU_GCR_reserved5[8];
  union {                              /* eTPU Channel Data Transfer Request Enable Register for Engine 1 */
    vuint32_t R;
    struct {
      vuint32_t DTREn:32;              /* Channel n Data Transfer Request Enable. */
    } B;
  } CDTRER_ENG1;

  union {                              /* eTPU Channel Data Transfer Request Enable Register for Engine 2 */
    vuint32_t R;
    struct {
      vuint32_t DTREn:32;              /* Channel n Data Transfer Request Enable. */
    } B;
  } CDTRER_ENG2;

  uint8_t eTPU_GCR_reserved6[8];
  union {                              /* eTPU Watchdog Status Register for Engine 1 */
    vuint32_t R;
    struct {
      vuint32_t WDSn:32;               /* Channel n Watchdog Status. For details about Watchdog mechanism, see the Watchdog section. */
    } B;
  } WDSR_ENG1;

  union {                              /* eTPU Watchdog Status Register for Engine 2 */
    vuint32_t R;
    struct {
      vuint32_t WDSn:32;               /* Channel n Watchdog Status. For details about Watchdog mechanism, see the Watchdog section. */
    } B;
  } WDSR_ENG2;

  uint8_t eTPU_GCR_reserved7[24];
  union {                              /* eTPU Channel Pending Service Status Register for Engine 1 */
    vuint32_t R;
    struct {
      vuint32_t SRn:32;                /* Pending Service Request n. */
    } B;
  } CPSSR_ENG1;

  union {                              /* eTPU Channel Pending Service Status Register for Engine 2 */
    vuint32_t R;
    struct {
      vuint32_t SRn:32;                /* Pending Service Request n. */
    } B;
  } CPSSR_ENG2;

  uint8_t eTPU_GCR_reserved8[8];
  union {                              /* eTPU Channel Service Status Register for Engine 1 */
    vuint32_t R;
    struct {
      vuint32_t SSn:32;                /* Service Status n. */
    } B;
  } CSSR_ENG1;

  union {                              /* eTPU Channel Service Status Register for Engine 2 */
    vuint32_t R;
    struct {
      vuint32_t SSn:32;                /* Service Status n. */
    } B;
  } CSSR_ENG2;
};


/* ============================================================================
   =============================== Module: eTPU_LMR ===========================
   ============================================================================ */

struct eTPU_LMR_tag {
  uint8_t eTPU_LMR_reserved0[128];
  struct {
    union {                            /* eTPU Latency Monitor n Configuration Register for Engine 1 */
      vuint32_t R;
      struct {
        vuint32_t LMM:2;               /* Latency Monitor Mode. */
        vuint32_t  :3;                 /* Reserved. */
        vuint32_t SRSEL:3;             /* Service Request Selection */
        vuint32_t  :3;                 /* Reserved. */
        vuint32_t MONCHAN:5;           /* Monitored Channel. */
        vuint32_t MAXLAT:16;           /* Maximum Latency. */
      } B;
    } CR;
    union {                            /* eTPU Latency Monitor n Measure Register for Engine 1 */
      vuint32_t R;
      struct {
        vuint32_t  :16;                /* Reserved. */
        vuint32_t LATENCY:15;          /* Latency measurement. */
        vuint32_t LTC:1;               /* Latency measurement clear */
      } B;
    } MR;
  } ENG1_LM[6];        /* LM(0-5)CR_ENG1 & LM(0-5)MR_ENG1 */

  uint8_t eTPU_LMR_reserved1[16];
  struct {
    union {                            /* eTPU Latency Monitor n Configuration Register for Engine 2 */
      vuint32_t R;
      struct {
        vuint32_t LMM:2;               /* Latency Monitor Mode. */
        vuint32_t  :3;                 /* Reserved. */
        vuint32_t SRSEL:3;             /* Service Request Selection */
        vuint32_t  :3;                 /* Reserved. */
        vuint32_t MONCHAN:5;           /* Monitored Channel. */
        vuint32_t MAXLAT:16;           /* Maximum Latency. */
      } B;
    } CR;
    union {                            /* eTPU Latency Monitor n Measure Register for Engine 2 */
      vuint32_t R;
      struct {
        vuint32_t  :16;                /* Reserved. */
        vuint32_t LATENCY:15;          /* Latency measurement. */
        vuint32_t LTC:1;               /* Latency measurement clear. */
      } B;
    } MR;
  } ENG2_LM[6];        /* LM(0-5)CR_ENG1 & LM(0-5)MR_ENG1 */ 
};


/* ============================================================================
   =============================== Module: eTPU_MESR ==========================
   ============================================================================ */

struct eTPU_MESR_tag {
  uint8_t eTPU_MESR_reserved0[256];
  union {                              /* eTPU Memory Error Control Register */
    vuint32_t R;
    struct {
      vuint32_t FME:1;                 /* Field Modification Enable. */
      vuint32_t  :14;                  /* Reserved. */
      vuint32_t MECIE:1;               /* Memory Error Correction Interrupt Enable. */
      vuint32_t HDEIE:1;               /* Host Data Error Injection Enable */
      vuint32_t MDEIE:1;               /* Microengine(s) Data Error Injection Enable. */
      vuint32_t  :3;                   /* Reserved. */
      vuint32_t DTEND:1;               /* Thread End on Data Non-correctable Error. */
      vuint32_t DRDIS:1;               /* Data Error Report Disable. */
      vuint32_t DEDD:1;                /* Data Error Detection Disable. */
      vuint32_t CEIE:1;                /* Code Error Injection Enable. */
      vuint32_t  :4;                   /* Reserved. */
      vuint32_t CTEND:1;               /* Thread End on Code Non-correctable Error. */
      vuint32_t CRDIS:1;               /* Code Error Report Disable. */
      vuint32_t CEDD:1;                /* Code Error Detection Disable. */
    } B;
  } MECR;

  union {                              /* eTPU Data Error Injection Address Register */
    vuint32_t R;
    struct {
      vuint32_t  :18;                  /* Reserved. */
      vuint32_t INJ_ADDR:12;           /* Injection Address. */
      vuint32_t  :2;                   /* Reserved. */
    } B;
  } DEIAR;

  union {                              /* eTPU Data Error Injection Data Pattern Register */
    vuint32_t R;
    struct {
      vuint32_t DFLIP:32;              /* Data Flip bits. */
    } B;
  } DEIDPR;

  union {                              /* eTPU Data Error Injection Parity Pattern Register */
    vuint32_t R;
    struct {
      vuint32_t  :3;                   /* Reserved. */
      vuint32_t PFLIP_19_15:5;         /* Parity Flip bits. */
      vuint32_t  :3;                   /* Reserved. */
      vuint32_t PFLIP_14_10:5;         /* Parity Flip bits. */
      vuint32_t  :3;                   /* Reserved. */
      vuint32_t PFLIP_9_5:5;           /* Parity Flip bits. */
      vuint32_t  :3;                   /* Reserved. */
      vuint32_t PFLIP_4_0:5;           /* Parity Flip bits. */
    } B;
  } DEIPPR;

  union {                              /* eTPU Data Error Report Address Register */
    vuint32_t R;
    struct {
      vuint32_t ERR_ACC:2;             /* Error Access Source Indication. */
      vuint32_t  :1;                   /* Reserved. */
      vuint32_t ERR_CHANNEL:5;         /* Error Channel Access Indication. */
      vuint32_t  :10;                  /* Reserved. */
      vuint32_t ERR_ADDR:12;           /* Error Address. */
      vuint32_t  :2;                   /* Reserved. */
    } B;
  } DERAR;

  union {                              /* eTPU Data Error Report Data Register */
    vuint32_t R;
    struct {
      vuint32_t DATA:32;               /* DATA. */
    } B;
  } DERDR;

  union {                              /* eTPU Data Error Report Syndrome Register */
    vuint32_t R;
    struct {
      vuint32_t BE3:1;                 /* Byte Enable 3. */
      vuint32_t  :2;                   /* Reserved. */
      vuint32_t SYND3:5;               /* Error Syndrome 3. */
      vuint32_t BE2:1;                 /* Byte Enable 2. */
      vuint32_t  :2;                   /* Reserved. */
      vuint32_t SYND2:5;               /* Error Syndrome 2. */
      vuint32_t BE1:1;                 /* Byte Enable 1. */
      vuint32_t  :2;                   /* Reserved. */
      vuint32_t SYND1:5;               /* Error Syndrome 1. */
      vuint32_t BE0:1;                 /* Byte Enable 0. */
      vuint32_t  :2;                   /* Reserved. */
      vuint32_t SYND0:5;               /* Error Syndrome 0. */
    } B;
  } DERSR;

  uint8_t eTPU_MESR_reserved1[4];
  union {                              /* eTPU Memory Error Status Register */
    vuint32_t R;
    struct {
      vuint32_t DCERR:1;               /* Data Correctable Error flag. */
      vuint32_t  :6;                   /* Reserved. */
      vuint32_t DCOVR:1;               /* Data Correctable Overrun flag. */
      vuint32_t CCERR:1;               /* Code Error flag. */
      vuint32_t  :6;                   /* Reserved. */
      vuint32_t CCOVR:1;               /* Code Correctable Overrun flag */
      vuint32_t DNCERR:1;              /* Data Non-Correctable Error flag */
      vuint32_t  :6;                   /* Reserved. */
      vuint32_t DNCOVR:1;              /* Data Non-Correctable Overrun flag. */
      vuint32_t CNCERR:1;              /* Code Non-Correctable Error flag */
      vuint32_t  :6;                   /* Reserved. */
      vuint32_t CNCOVR:1;              /* Code Non-Correctable Overrun flag. */
    } B;
  } MESR;

  union {                              /* eTPU Code Error Injection Address Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;                  /* Reserved. */
      vuint32_t INJ_ADDR:14;           /* Injection Address. */
      vuint32_t  :2;                   /* Reserved. */
    } B;
  } CEIAR;

  union {                              /* eTPU Code Error Injection Data Pattern Register */
    vuint32_t R;
    struct {
      vuint32_t DFLIP:32;              /* Data Flip bits. */
    } B;
  } CEIDPR;

  union {                              /* eTPU Code Error Injection Parity Pattern Register */
    vuint32_t R;
    struct {
      vuint32_t  :25;                  /* Reserved. */
      vuint32_t PFLIP:7;               /* Parity Flip bits. */
    } B;
  } CEIPPR;

  union {                              /* eTPU Code Error Report Address Register */
    vuint32_t R;
    struct {
      vuint32_t ERR_ACC:2;             /* Error Access Source Indication. */
      vuint32_t  :1;                   /* Reserved. */
      vuint32_t ERR_CHANNEL:5;         /* Error Channel Access Indication. */
      vuint32_t  :8;                   /* Reserved. */
      vuint32_t ERR_ADDR:14;           /* Error Address. */
      vuint32_t  :2;                   /* Reserved. */
    } B;
  } CERAR;

  union {                              /* eTPU Code Error Report Data Register */
    vuint32_t R;
    struct {
      vuint32_t CODE:32;               /* CODE[31-0]. */
    } B;
  } CERDR;

  union {                              /* eTPU Code Error Report Syndrome Register */
    vuint32_t R;
    struct {
      vuint32_t  :25;                  /* Reserved. */
      vuint32_t SYND:7;                /* Error Syndrome. */
    } B;
  } CERSR;

  union {                              /* eTPU Code Error Fix Register */
    vuint32_t R;
    struct {
      vuint32_t CFIXM:2;               /* Code Fix Mode. */
      vuint32_t  :14;                  /* Reserved. */
      vuint32_t CFIX_ADDR:14;          /* Code Fix Address. */
      vuint32_t  :2;                   /* Reserved. */
    } B;
  } CEFR;
};


/* ============================================================================
   =============================== Module: eTPU_SCR ===========================
   ============================================================================ */

struct eTPU_SCR_tag {
  union {                              /* eTPU Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t GEC:1;                 /* Global Exception Clear. */
      vuint32_t SDMERR:1;              /* SDM Read Error */
      vuint32_t WDTO1:1;               /* Watchdog 1 Timeout. */
      vuint32_t WDTO2:1;               /* Watchdog 2 Timeout. */
      vuint32_t MGE1:1;                /* Microcode Global Exception Engine 1. */
      vuint32_t MGE2:1;                /* Microcode Global Exception Engine 2. */
      vuint32_t ILF1:1;                /* Illegal Instruction Flag for Engine 1. */
      vuint32_t ILF2:1;                /* Illegal Instruction Flag for Engine 2. */
      vuint32_t  :1;                   /* Reserved. */
      vuint32_t  :1;                   /* Reserved. */
      vuint32_t  :1;                   /* Reserved. */
      vuint32_t SCMSIZE:5;             /* SCM Size = 64 Kbytes. */
      vuint32_t LTO1:1;                /* Latency Timeout for Engine 1. */
      vuint32_t LTO2:1;                /* Latency Timeout for Engine 2. */
      vuint32_t  :2;                   /* Reserved. */
      vuint32_t SCMMISC:1;             /* SCM MISC Complete flag. */
      vuint32_t SCMMISF:1;             /* SCM MISC Flag. */
      vuint32_t SCMMISEN:1;            /* SCM MISC Enable. */
      vuint32_t SCMERR:1;              /* SCM Read Error. */
      vuint32_t  :1;
      vuint32_t VIS:1;                 /* SCM Visibility Bit. */
      vuint32_t  :5;                   /* Reserved. */
      vuint32_t GTBE:1;                /* Global Time Base Enable. */
    } B;
  } MCR;

  union {                              /* eTPU Coherent Dual-Parameter Controller Register */
    vuint32_t R;
    struct {
      vuint32_t STS:1;                 /* Start Bit. */
      vuint32_t CTBASE:5;              /* Channel Transfer Base. */
      vuint32_t PBBASE:10;             /* Parameter Buffer Base Address. */
      vuint32_t PWIDTH:1;              /* Parameter Width Selection. */
      vuint32_t PARM0:7;               /* Channel Parameter number 0. */
      vuint32_t WR:1;                  /* Read/Write selection. */
      vuint32_t PARM1:7;               /* Channel Parameter number 1. */
    } B;
  } CDCR;

  uint8_t eTPU_SCR_reserved0[4];
  union {                              /* eTPU MISC Compare Register */
    vuint32_t R;
    struct {
      vuint32_t ETPUMISCCMP:32;        /* Expected Multiple Input Signature Register value. */
    } B;
  } MISCCMPR;

  union {                              /* eTPU SCM Off-range Data Register */
    vuint32_t R;
    struct {
      vuint32_t ETPUSCMOFFDATAR:32;    /* SCM Off-range read data value. */
    } B;
  } SCMOFFDATAR;

  union {                              /* eTPU Engine 1 Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t FEND:1;                /* Force End. */
      vuint32_t MDIS:1;                /* Module Disable Bit. */
      vuint32_t  :1;                   /* Reserved. */
      vuint32_t STF:1;                 /* Stop Flag Bit. */
      vuint32_t  :4;                   /* Reserved. */
      vuint32_t HLTF:1;                /* Halt Mode Flag. */
      vuint32_t  :3;                   /* Reserved. */
      vuint32_t FCSS:1;                /* Filter Clock Source Selection */
      vuint32_t FPSCK:3;               /* Filter Prescaler Clock Control. */
      vuint32_t CDFC:2;                /* Channel Digital Filter Control. */
      vuint32_t  :1;                   /* Reserved. */
      vuint32_t ERBA:5;                /* Engine Relative Base Address. */
      vuint32_t SPPDIS:1;              /* Schedule Priority Passing Disable. */
      vuint32_t  :2;                   /* Reserved. */
      vuint32_t ETB:5;                 /* Entry Table Base. */
    } B;
  } ECR_ENG1;

  union {                              /* eTPU Engine 2 Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t FEND:1;                /* Force End. */
      vuint32_t MDIS:1;                /* Module Disable Bit. */
      vuint32_t  :1;                   /* Reserved. */
      vuint32_t STF:1;                 /* Stop Flag Bit. */
      vuint32_t  :4;                   /* Reserved. */
      vuint32_t HLTF:1;                /* Halt Mode Flag. */
      vuint32_t  :3;                   /* Reserved. */
      vuint32_t FCSS:1;                /* Filter Clock Source Selection */
      vuint32_t FPSCK:3;               /* Filter Prescaler Clock Control. */
      vuint32_t CDFC:2;                /* Channel Digital Filter Control. */
      vuint32_t  :1;                   /* Reserved. */
      vuint32_t ERBA:5;                /* Engine Relative Base Address. */
      vuint32_t SPPDIS:1;              /* Schedule Priority Passing Disable. */
      vuint32_t  :2;                   /* Reserved. */
      vuint32_t ETB:5;                 /* Entry Table Base. */
    } B;
  } ECR_ENG2;
};


/* ============================================================================
   =============================== Module: eTPU_SSIR ==========================
   ============================================================================ */

struct eTPU_SSIR_tag {
  uint8_t eTPU_SSIR_reserved0[3072];
  union {                              /* eTPU Shared Subsystem n Integration Register */
    vuint32_t R;
    struct {
      vuint32_t  :24;                  /* Reserved. */
      vuint32_t LENG:2;                /* Link Engine. */
      vuint32_t  :1;                   /* Reserved. */
      vuint32_t LCHAN:5;               /* Link Channel. */
    } B;
  } ETPUSSSIR;
};


/* ============================================================================
   =============================== Module: eTPU_TBR ===========================
   ============================================================================ */

struct eTPU_TBR_tag {
  uint8_t eTPU_TBR_reserved0[32];
  union {                              /* eTPU Engine 1 Time Base Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t TCR2CTL:3;             /* TCR2 Clock/Gate Control. */
      vuint32_t TCRCF:2;               /* TCRCLK Signal Filter Control. */
      vuint32_t AM:2;                  /* Angle Mode Selection. */
      vuint32_t ATGC:1;                /* Angle Tick Generator Clock. */
      vuint32_t  :2;                   /* Reserved. */
      vuint32_t TCR2P:6;               /* Timer Count Register 2 Prescaler Control. */
      vuint32_t TCR1CTL:2;             /* TCR1 Clock/Gate Control. */
      vuint32_t TCR1CS:1;              /* TCR1 Clock Source */
      vuint32_t  :5;                   /* Reserved. */
      vuint32_t TCR1P:8;               /* Timer Count Register 1 Prescaler Control. */
    } B;
  } TBCR_ENG1;

  union {                              /* eTPU Engine 1 Time Base 1 (TCR1) Visibility Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;                   /* Reserved. */
      vuint32_t TCR1:24;               /* TCR1 value. */
    } B;
  } TB1R_ENG1;

  union {                              /* eTPU Engine 1 Time Base 2 (TCR2) Visibility Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;                   /* Reserved. */
      vuint32_t TCR2:24;               /* TCR2 value. */
    } B;
  } TB2R_ENG1;

  union {                              /* eTPU Engine 1 STAC Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t REN1:1;                /* TCR1 Resource Client/Server Operation Enable Bit. */
      vuint32_t RSC1:1;                /* TCR1 Resource Server/Client Assignment Bits. */
      vuint32_t  :2;                   /* Reserved. */
      vuint32_t SERVER_ID1:4;          /* STAC ID 1. */
      vuint32_t  :4;                   /* Reserved. */
      vuint32_t SRV1:4;                /* TCR1 Resource Server. */
      vuint32_t REN2:1;                /* TCR2 Resource Client/Server Operation Enable Bit. */
      vuint32_t RSC2:1;                /* TCR2 ResourceEither time or angle TCR2 values. Server/Client Assignment Bits. */
      vuint32_t  :2;                   /* Reserved. */
      vuint32_t SERVER_ID2:4;          /* STAC ID 2. */
      vuint32_t  :4;                   /* Reserved. */
      vuint32_t SRV2:4;                /* TCR2 Resource Server. */
    } B;
  } STAC_ENG1;

  uint8_t eTPU_TBR_reserved1[16];
  union {                              /* eTPU Engine 2 Time Base Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t TCR2CTL:3;             /* TCR2 Clock/Gate Control. */
      vuint32_t TCRCF:2;               /* TCRCLK Signal Filter Control. */
      vuint32_t AM:2;                  /* Angle Mode Selection. */
      vuint32_t ATGC:1;                /* Angle Tick Generator Clock. */
      vuint32_t  :2;                   /* Reserved. */
      vuint32_t TCR2P:6;               /* Timer Count Register 2 Prescaler Control. */
      vuint32_t TCR1CTL:2;             /* TCR1 Clock/Gate Control. */
      vuint32_t TCR1CS:1;              /* TCR1 Clock Source */
      vuint32_t  :5;                   /* Reserved. */
      vuint32_t TCR1P:8;               /* Timer Count Register 1 Prescaler Control. */
    } B;
  } TBCR_ENG2;

  union {                              /* eTPU Engine 2 Time Base 1 (TCR1) Visibility Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;                   /* Reserved. */
      vuint32_t TCR1:24;               /* TCR1 value. */
    } B;
  } TB1R_ENG2;

  union {                              /* eTPU Engine 2 Time Base 2 (TCR2) Visibility Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;                   /* Reserved. */
      vuint32_t TCR2:24;               /* TCR2 value. */
    } B;
  } TB2R_ENG2;

  union {                              /* eTPU Engine 2 STAC Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t REN1:1;                /* TCR1 Resource Client/Server Operation Enable Bit. */
      vuint32_t RSC1:1;                /* TCR1 ResourceResource identifies any parameter that changes along the time and can be exported / imported from other device. In eTPU context, a resource can be TCR1 or TCR2 (either Time or Angle values). Server/Client Assignment Bits. */
      vuint32_t  :2;                   /* Reserved. */
      vuint32_t SERVER_ID1:4;          /* STAC ID 1. */
      vuint32_t  :4;                   /* Reserved. */
      vuint32_t SRV1:4;                /* TCR1 Resource Server. */
      vuint32_t REN2:1;                /* TCR2 Resource Client/Server Operation Enable Bit. */
      vuint32_t RSC2:1;                /* TCR2 Resource #Resource_ID Server/Client Assignment Bits. */
      vuint32_t  :2;                   /* Reserved. */
      vuint32_t SERVER_ID2:4;          /* STAC ID 2. */
      vuint32_t  :4;                   /* Reserved. */
      vuint32_t SRV2:4;                /* TCR2 Resource Server. */
    } B;
  } STAC_ENG2;
};
#define SRAM0_START 0x40000000UL;
#define ADC_0 (*(volatile struct ADC_tag *) 0xFFEE4000UL)
#define ADC_1 (*(volatile struct ADC_tag *) 0xFBEE4000UL)
#define ADC_2 (*(volatile struct ADC_tag *) 0xFFEEC000UL)
#define ADC_3 (*(volatile struct ADC_tag *) 0xFBEF0000UL)
#define AIPS_A (*(volatile struct AIPS_tag *) 0xFC000000UL)
#define AIPS_B (*(volatile struct AIPS_tag *) 0xF8000000UL)
#define BCTU (*(volatile struct BCTU_tag *) 0xFFC10000UL)
#define C55FMC (*(volatile struct C55FMC_tag *) 0xFFFE0000UL)
#define CAN_0 (*(volatile struct CAN_tag *) 0xFFEB4000UL)
#define CAN_1 (*(volatile struct CAN_tag *) 0xFBEB4000UL)
#define CAN_2 (*(volatile struct CAN_tag *) 0xFFEB8000UL)
#define CAN_3 (*(volatile struct CAN_tag *) 0xFBEBC000UL)
#define CMU_ADCSD (*(volatile struct CMU_tag *) 0xFBFB0300UL)
#define CMU_AIPS (*(volatile struct CMU_tag *) 0xFBFB0280UL)
#define CMU_CLKOUT (*(volatile struct CMU_tag *) 0xFBFB04C0UL)
#define CMU_FXBAR (*(volatile struct CMU_tag *) 0xFBFB0200UL)
#define CMU_PER (*(volatile struct CMU_tag *) 0xFBFB02C0UL)
#define CMU_PLL (*(volatile struct CMU_tag *) 0xFBFB0500UL)
#define CMU_SARADC (*(volatile struct CMU_tag *) 0xFBFB0340UL)
#define CMU_SENT (*(volatile struct CMU_tag *) 0xFBFB0380UL)
#define CMU_SXBAR (*(volatile struct CMU_tag *) 0xFBFB0240UL)
#define CMU_eMIOS (*(volatile struct CMU_tag *) 0xFBFB0400UL)
#define CMU_eTPU2 (*(volatile struct CMU_tag *) 0xFBFB0440UL)
#define CRC_0 (*(volatile struct CRC_tag *) 0xFFF64000UL)
#define CRC_1 (*(volatile struct CRC_tag *) 0xFBF64000UL)
#define DECFILTER_0 (*(volatile struct DECFILTER_tag *) 0xFFF88000UL)
#define DECFILTER_1 (*(volatile struct DECFILTER_tag *) 0xFFF8C000UL)
#define DMAMUX_0 (*(volatile struct DMAMUX_tag *) 0xFFF6C000UL)
#define DMAMUX_1 (*(volatile struct DMAMUX_tag *) 0xFFF6C200UL)
#define DMAMUX_2 (*(volatile struct DMAMUX_tag *) 0xFFF6C400UL)
#define DMAMUX_3 (*(volatile struct DMAMUX_tag *) 0xFBFC0000UL)
#define DMA_0 (*(volatile struct DMA_tag *) 0xFC0A0000UL)
#define DSPI_0 (*(volatile struct DSPI_tag *) 0xFFE70000UL)
#define DSPI_1 (*(volatile struct DSPI_tag *) 0xFBE70000UL)
#define DSPI_2 (*(volatile struct DSPI_tag *) 0xFFE74000UL)
#define DSPI_3 (*(volatile struct DSPI_tag *) 0xFBE74000UL)
#define DSPI_4 (*(volatile struct DSPI_tag *) 0xFFE78000UL)
#define DSPI_M0 (*(volatile struct DSPI_tag *) 0xFFE7C000UL)
#define DSPI_M1 (*(volatile struct DSPI_tag *) 0xFBE78000UL)
#define DTS (*(volatile struct DTS_tag *) 0xFFF38000UL)
#define FCCU (*(volatile struct FCCU_tag *) 0xFBF58000UL)
#define FEC (*(volatile struct FEC_tag *) 0xFC0B0000UL)
#define IGF (*(volatile struct IGF_tag *) 0xFFCE8000UL)
#define INTC_0 (*(volatile struct INTC_tag *) 0xFC040000UL)
#define IRCOSC (*(volatile struct IRCOSC_tag *) 0xFFFB0000UL)
#define JDC (*(volatile struct JDC_tag *) 0xFFF3C000UL)
#define JTAGM (*(volatile struct JTAGM_tag *) 0xFFF48000UL)
#define LFAST (*(volatile struct LFAST_tag *) 0xFFFD8000UL)
#define LINFlexD_0 (*(volatile struct LINFlexD_tag *) 0xFFE8C000UL)
#define LINFlexD_1 (*(volatile struct LINFlexD_tag *) 0xFBE8C000UL)
#define LINFlexD_2 (*(volatile struct LINFlexD_tag *) 0xFFE90000UL)
#define LINFlexD_3 (*(volatile struct LINFlexD_tag *) 0xFBE90000UL)
#define LINFlexD_M0 (*(volatile struct LINFlexD_tag *) 0xFFEA8000UL)
#define LINFlexD_M1 (*(volatile struct LINFlexD_tag *) 0xFBEA8000UL)
#define MC_CGM (*(volatile struct MC_CGM_tag *) 0xFFFB0700UL)
#define MC_ME (*(volatile struct MC_ME_tag *) 0xFFFB8000UL)
#define MC_PCU (*(volatile struct MC_PCU_tag *) 0xFFFA0000UL)
#define MC_RGM (*(volatile struct MC_RGM_tag *) 0xFFFA8000UL)
#define MEMU (*(volatile struct MEMU_tag *) 0xFFF50000UL)
#define PASS (*(volatile struct PASS_tag *) 0xFFFF4000UL)
#define PCM (*(volatile struct PCM_tag *) 0xFC028000UL)
#define PFLASH (*(volatile struct PFLASH_tag *) 0xFC030000UL)
#define PIT_0 (*(volatile struct PIT_tag *) 0xFFF84000UL)
#define PIT_1 (*(volatile struct PIT_tag *) 0xFFF80000UL)
#define PLLDIG (*(volatile struct PLLDIG_tag *) 0xFFFB0100UL)
#define PMC (*(volatile struct PMC_tag *) 0xFFFA0400UL)
#define PRAMC (*(volatile struct PRAMC_tag *) 0xFC020000UL)
#define REACM2 (*(volatile struct REACM2_tag *) 0xFFCC4000UL)
#define SDADC_0 (*(volatile struct SDADC_tag *) 0xFFF0C000UL)
#define SDADC_1 (*(volatile struct SDADC_tag *) 0xFBF0C000UL)
#define SDADC_2 (*(volatile struct SDADC_tag *) 0xFFF10000UL)
#define SDADC_3 (*(volatile struct SDADC_tag *) 0xFBF10000UL)
#define SDADC_4 (*(volatile struct SDADC_tag *) 0xFFF14000UL)
#define SDADC_5 (*(volatile struct SDADC_tag *) 0xFBF14000UL)
#define SDADC_6 (*(volatile struct SDADC_tag *) 0xFFF18000UL)
#define SDADC_7 (*(volatile struct SDADC_tag *) 0xFBF18000UL)
#define SDADC_8 (*(volatile struct SDADC_tag *) 0xFFF1C000UL)
#define SDADC_9 (*(volatile struct SDADC_tag *) 0xFBF1C000UL)
#define SEMA42 (*(volatile struct SEMA42_tag *) 0xFC03C000UL)
#define SIPI (*(volatile struct SIPI_tag *) 0xFFFD0000UL)
#define SIUL2 (*(volatile struct SIUL2_tag *) 0xFFFC0000UL)
#define SMPU0 (*(volatile struct SMPU_tag *) 0xFC010000UL)
#define SMPU1 (*(volatile struct SMPU_tag *) 0xFC014000UL)
#define SRX_0 (*(volatile struct SRX_tag *) 0xFFE5C000UL)
#define SRX_1 (*(volatile struct SRX_tag *) 0xFBE5C000UL)
#define SSCM (*(volatile struct SSCM_tag *) 0xFFFF8000UL)
#define STCU2 (*(volatile struct STCU2_tag *) 0xFFF44000UL)
#define STM_0 (*(volatile struct STM_tag *) 0xFC068000UL)
#define STM_1 (*(volatile struct STM_tag *) 0xFC06C000UL)
#define SWT_0 (*(volatile struct SWT_tag *) 0xFC050000UL)
#define SWT_1 (*(volatile struct SWT_tag *) 0xFC054000UL)
#define SWT_3 (*(volatile struct SWT_tag *) 0xFC05C000UL)
#define TDM (*(volatile struct TDM_tag *) 0xFFF34000UL)
#define WKPU (*(volatile struct WKPU_tag *) 0xFFF98000UL)
#define XBAR_0 (*(volatile struct XBAR_tag *) 0xFC004000UL)
#define XBAR_1 (*(volatile struct XBAR_tag *) 0xFC008000UL)
#define XOSC (*(volatile struct XOSC_tag *) 0xFFFB0080UL)
#define eTPU_CCCR_0 (*(volatile struct eTPU_CCCR_tag *) 0xFFCC0400UL)
#define eTPU_ER_0 (*(volatile struct eTPU_ER_tag *) 0xFFCC0060UL)
#define eTPU_GCR_0 (*(volatile struct eTPU_GCR_tag *) 0xFFCC0200UL)
#define eTPU_LMR_0 (*(volatile struct eTPU_LMR_tag *) 0xFFCC0080UL)
#define eTPU_MESR_0 (*(volatile struct eTPU_MESR_tag *) 0xFFCC0100UL)
#define eTPU_SCR_0 (*(volatile struct eTPU_SCR_tag *) 0xFFCC0000UL)
#define eTPU_SSIR_0 (*(volatile struct eTPU_SSIR_tag *) 0xFFCC0C00UL)
#define eTPU_TBR_0 (*(volatile struct eTPU_TBR_tag *) 0xFFCC0020UL)

/* ADC */
#define ADC_0_MCR            ADC_0.MCR.R                   /* Main Configuration Register */
#define ADC_0_MSR            ADC_0.MSR.R                   /* Main Status register */
#define ADC_0_ISR            ADC_0.ISR.R                   /* Interrupt Status Register */
#define ADC_0_CEOCFR0        ADC_0.CEOCFR0.R               /* Channel Pending register 0 */
#define ADC_0_CEOCFR1        ADC_0.CEOCFR1.R               /* Channel Pending register 1 */
#define ADC_0_CEOCFR2        ADC_0.CEOCFR2.R               /* Channel Pending register 2 */
#define ADC_0_IMR            ADC_0.IMR.R                   /* Interrupt Mask Register */
#define ADC_0_CIMR0          ADC_0.CIMR0.R                 /* Channel Interrupt Mask Register 0 */
#define ADC_0_CIMR1          ADC_0.CIMR1.R                 /* Channel Interrupt Mask Register 1 */
#define ADC_0_CIMR2          ADC_0.CIMR2.R                 /* Channel Interrupt Mask Register 2 */
#define ADC_0_WTISR          ADC_0.WTISR.R                 /* Watchdog Threshold Interrupt Status Register */
#define ADC_0_WTIMR          ADC_0.WTIMR.R                 /* Watchdog Threshold Interrupt Mask Register */
#define ADC_0_DMAE           ADC_0.DMAE.R                  /* DMA Enable register */
#define ADC_0_DMAR0          ADC_0.DMAR0.R                 /* DMA Channel Select Register 0 */
#define ADC_0_DMAR1          ADC_0.DMAR1.R                 /* DMA Channel Select Register 1 */
#define ADC_0_DMAR2          ADC_0.DMAR2.R                 /* DMA Channel Select Register 2 */
#define ADC_0_THRHLR0        ADC_0.THRHLR0.R               /* Threshold Register */
#define ADC_0_THRHLR1        ADC_0.THRHLR1.R               /* Threshold Register */
#define ADC_0_THRHLR2        ADC_0.THRHLR2.R               /* Threshold Register */
#define ADC_0_THRHLR3        ADC_0.THRHLR3.R               /* Threshold Register */
#define ADC_0_PSCR           ADC_0.PSCR.R                  /* Presampling Control Register */
#define ADC_0_PSR0           ADC_0.PSR0.R                  /* Presampling register 0 */
#define ADC_0_PSR1           ADC_0.PSR1.R                  /* Presampling register 1 */
#define ADC_0_PSR2           ADC_0.PSR2.R                  /* Presampling register 2 */
#define ADC_0_CTR0           ADC_0.CTR0.R                  /* Conversion Timing Register 0 */
#define ADC_0_CTR1           ADC_0.CTR1.R                  /* Conversion Timing Register 1 */
#define ADC_0_CTR2           ADC_0.CTR2.R                  /* Conversion Timing Register 2 */
#define ADC_0_NCMR0          ADC_0.NCMR0.R                 /* Normal Conversion Mask Register 0 */
#define ADC_0_NCMR1          ADC_0.NCMR1.R                 /* Normal Conversion Mask Register 1 */
#define ADC_0_NCMR2          ADC_0.NCMR2.R                 /* Normal Conversion Mask Register 2 */
#define ADC_0_JCMR0          ADC_0.JCMR0.R                 /* Injected Conversion Mask Register 0 */
#define ADC_0_JCMR1          ADC_0.JCMR1.R                 /* Injected Conversion Mask Register 1 */
#define ADC_0_JCMR2          ADC_0.JCMR2.R                 /* Injected Conversion Mask Register 2 */
#define ADC_0_DSDR           ADC_0.DSDR.R                  /* Decode Signals Delay Register */
#define ADC_0_PDEDR          ADC_0.PDEDR.R                 /* Power Down Exit Delay Register */
#define ADC_0_CDR0           ADC_0.CDR[0].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR1           ADC_0.CDR[1].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR2           ADC_0.CDR[2].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR3           ADC_0.CDR[3].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR4           ADC_0.CDR[4].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR5           ADC_0.CDR[5].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR6           ADC_0.CDR[6].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR7           ADC_0.CDR[7].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR8           ADC_0.CDR[8].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR9           ADC_0.CDR[9].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR10          ADC_0.CDR[10].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR11          ADC_0.CDR[11].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR12          ADC_0.CDR[12].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR13          ADC_0.CDR[13].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR14          ADC_0.CDR[14].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR15          ADC_0.CDR[15].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR16          ADC_0.CDR[16].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR17          ADC_0.CDR[17].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR18          ADC_0.CDR[18].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR19          ADC_0.CDR[19].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR20          ADC_0.CDR[20].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR21          ADC_0.CDR[21].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR22          ADC_0.CDR[22].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR23          ADC_0.CDR[23].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR24          ADC_0.CDR[24].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR25          ADC_0.CDR[25].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR26          ADC_0.CDR[26].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR27          ADC_0.CDR[27].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR28          ADC_0.CDR[28].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR29          ADC_0.CDR[29].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR30          ADC_0.CDR[30].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR31          ADC_0.CDR[31].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR32          ADC_0.CDR[32].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR33          ADC_0.CDR[33].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR34          ADC_0.CDR[34].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR35          ADC_0.CDR[35].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR36          ADC_0.CDR[36].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR37          ADC_0.CDR[37].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR38          ADC_0.CDR[38].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR39          ADC_0.CDR[39].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR40          ADC_0.CDR[40].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR41          ADC_0.CDR[41].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR42          ADC_0.CDR[42].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR43          ADC_0.CDR[43].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR44          ADC_0.CDR[44].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR45          ADC_0.CDR[45].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR46          ADC_0.CDR[46].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR47          ADC_0.CDR[47].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR48          ADC_0.CDR[48].R               /*  */
#define ADC_0_CDR49          ADC_0.CDR[49].R               /*  */
#define ADC_0_CDR50          ADC_0.CDR[50].R               /*  */
#define ADC_0_CDR51          ADC_0.CDR[51].R               /*  */
#define ADC_0_CDR52          ADC_0.CDR[52].R               /*  */
#define ADC_0_CDR53          ADC_0.CDR[53].R               /*  */
#define ADC_0_CDR54          ADC_0.CDR[54].R               /*  */
#define ADC_0_CDR55          ADC_0.CDR[55].R               /*  */
#define ADC_0_CDR56          ADC_0.CDR[56].R               /*  */
#define ADC_0_CDR57          ADC_0.CDR[57].R               /*  */
#define ADC_0_CDR58          ADC_0.CDR[58].R               /*  */
#define ADC_0_CDR59          ADC_0.CDR[59].R               /*  */
#define ADC_0_CDR60          ADC_0.CDR[60].R               /*  */
#define ADC_0_CDR61          ADC_0.CDR[61].R               /*  */
#define ADC_0_CDR62          ADC_0.CDR[62].R               /*  */
#define ADC_0_CDR63          ADC_0.CDR[63].R               /*  */
#define ADC_0_CDR64          ADC_0.CDR[64].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR65          ADC_0.CDR[65].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR66          ADC_0.CDR[66].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR67          ADC_0.CDR[67].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR68          ADC_0.CDR[68].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR69          ADC_0.CDR[69].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR70          ADC_0.CDR[70].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR71          ADC_0.CDR[71].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR72          ADC_0.CDR[72].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR73          ADC_0.CDR[73].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR74          ADC_0.CDR[74].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR75          ADC_0.CDR[75].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR76          ADC_0.CDR[76].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR77          ADC_0.CDR[77].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR78          ADC_0.CDR[78].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR79          ADC_0.CDR[79].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR80          ADC_0.CDR[80].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR81          ADC_0.CDR[81].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR82          ADC_0.CDR[82].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR83          ADC_0.CDR[83].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR84          ADC_0.CDR[84].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR85          ADC_0.CDR[85].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR86          ADC_0.CDR[86].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR87          ADC_0.CDR[87].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR88          ADC_0.CDR[88].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR89          ADC_0.CDR[89].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR90          ADC_0.CDR[90].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR91          ADC_0.CDR[91].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR92          ADC_0.CDR[92].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR93          ADC_0.CDR[93].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR94          ADC_0.CDR[94].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR95          ADC_0.CDR[95].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CWSELR0        ADC_0.CWSELR0.R               /* Channel Watchdog Select Register 0 */
#define ADC_0_CWSELR1        ADC_0.CWSELR1.R               /* Channel Watchdog Select Register 1 */
#define ADC_0_CWSELR2        ADC_0.CWSELR2.R               /* Channel Watchdog Select Register 2 */
#define ADC_0_CWSELR3        ADC_0.CWSELR3.R               /* Channel Watchdog Select Register 3 */
#define ADC_0_CWSELR4        ADC_0.CWSELR4.R               /* Channel Watchdog Select Register 4 */
#define ADC_0_CWSELR5        ADC_0.CWSELR5.R               /* Channel Watchdog Select Register 5 */
#define ADC_0_CWSELR8        ADC_0.CWSELR8.R               /* Channel Watchdog Select Register 8 */
#define ADC_0_CWSELR9        ADC_0.CWSELR9.R               /* Channel Watchdog Select Register 9 */
#define ADC_0_CWSELR10       ADC_0.CWSELR10.R              /* Channel Watchdog Select Register 10 */
#define ADC_0_CWSELR11       ADC_0.CWSELR11.R              /* Channel Watchdog Select Register 11 */
#define ADC_0_CWENR0         ADC_0.CWENR0.R                /* Channel Watchdog Enable Register 0 */
#define ADC_0_CWENR1         ADC_0.CWENR1.R                /* Channel Watchdog Enable Register 1 */
#define ADC_0_CWENR2         ADC_0.CWENR2.R                /* Channel Watchdog Enable Register 2 */
#define ADC_0_AWORR0         ADC_0.AWORR0.R                /* Analog Watchdog Out of Range Register 0 */
#define ADC_0_AWORR1         ADC_0.AWORR1.R                /* Analog Watchdog Out of Range Register 1 */
#define ADC_0_AWORR2         ADC_0.AWORR2.R                /* Analog Watchdog Out of Range Register 2 */
#define ADC_0_STCR1          ADC_0.STCR1.R                 /* Self Test Configuration Register 1 */
#define ADC_0_STCR2          ADC_0.STCR2.R                 /* Self Test Configuration Register 2 */
#define ADC_0_STCR3          ADC_0.STCR3.R                 /* Self Test Configuration Register 3 */
#define ADC_0_STBRR          ADC_0.STBRR.R                 /* Self Test Baud Rate Register */
#define ADC_0_STSR1          ADC_0.STSR1.R                 /* Self Test Status Register 1 */
#define ADC_0_STSR2          ADC_0.STSR2.R                 /* Self Test Status Register 2 */
#define ADC_0_STSR3          ADC_0.STSR3.R                 /* Self Test Status Register 3 */
#define ADC_0_STSR4          ADC_0.STSR4.R                 /* Self Test Status Register 4 */
#define ADC_0_STDR1          ADC_0.STDR1.R                 /* Self Test Data Register 1 */
#define ADC_0_STDR2          ADC_0.STDR2.R                 /* Self Test Data Register 2 */
#define ADC_0_STAW0R         ADC_0.STAW0R.R                /* Self Test Analog Watchdog Register 0 */
#define ADC_0_STAW1AR        ADC_0.STAW1AR.R               /* Self Test Analog Watchdog Register 1A */
#define ADC_0_STAW1BR        ADC_0.STAW1BR.R               /* Self Test Analog Watchdog Register 1B */
#define ADC_0_STAW2R         ADC_0.STAW2R.R                /* Self Test Analog Watchdog Register 2 */
#define ADC_0_STAW4R         ADC_0.STAW4R.R                /* Self Test Analog Watchdog Register 4 */
#define ADC_0_STAW5R         ADC_0.STAW5R.R                /* Self Test Analog Watchdog Register 5 */
#define ADC_0_CALBISTREG     ADC_0.CALBISTREG.R            /* Calibration, BIST Control and status Register */
#define ADC_0_OFSGNUSR       ADC_0.OFSGNUSR.R              /* Offset and Gain User Register */
#define ADC_0_ALTR           ADC_0.ALTR.R                  /* Alternate Result register */

/* ADC */
#define ADC_1_MCR            ADC_1.MCR.R                   /* Main Configuration Register */
#define ADC_1_MSR            ADC_1.MSR.R                   /* Main Status register */
#define ADC_1_ISR            ADC_1.ISR.R                   /* Interrupt Status Register */
#define ADC_1_CEOCFR0        ADC_1.CEOCFR0.R               /* Channel Pending register 0 */
#define ADC_1_CEOCFR1        ADC_1.CEOCFR1.R               /* Channel Pending register 1 */
#define ADC_1_CEOCFR2        ADC_1.CEOCFR2.R               /* Channel Pending register 2 */
#define ADC_1_IMR            ADC_1.IMR.R                   /* Interrupt Mask Register */
#define ADC_1_CIMR0          ADC_1.CIMR0.R                 /* Channel Interrupt Mask Register 0 */
#define ADC_1_CIMR1          ADC_1.CIMR1.R                 /* Channel Interrupt Mask Register 1 */
#define ADC_1_CIMR2          ADC_1.CIMR2.R                 /* Channel Interrupt Mask Register 2 */
#define ADC_1_WTISR          ADC_1.WTISR.R                 /* Watchdog Threshold Interrupt Status Register */
#define ADC_1_WTIMR          ADC_1.WTIMR.R                 /* Watchdog Threshold Interrupt Mask Register */
#define ADC_1_DMAE           ADC_1.DMAE.R                  /* DMA Enable register */
#define ADC_1_DMAR0          ADC_1.DMAR0.R                 /* DMA Channel Select Register 0 */
#define ADC_1_DMAR1          ADC_1.DMAR1.R                 /* DMA Channel Select Register 1 */
#define ADC_1_DMAR2          ADC_1.DMAR2.R                 /* DMA Channel Select Register 2 */
#define ADC_1_THRHLR0        ADC_1.THRHLR0.R               /* Threshold Register */
#define ADC_1_THRHLR1        ADC_1.THRHLR1.R               /* Threshold Register */
#define ADC_1_THRHLR2        ADC_1.THRHLR2.R               /* Threshold Register */
#define ADC_1_THRHLR3        ADC_1.THRHLR3.R               /* Threshold Register */
#define ADC_1_PSCR           ADC_1.PSCR.R                  /* Presampling Control Register */
#define ADC_1_PSR0           ADC_1.PSR0.R                  /* Presampling register 0 */
#define ADC_1_PSR1           ADC_1.PSR1.R                  /* Presampling register 1 */
#define ADC_1_PSR2           ADC_1.PSR2.R                  /* Presampling register 2 */
#define ADC_1_CTR0           ADC_1.CTR0.R                  /* Conversion Timing Register 0 */
#define ADC_1_CTR1           ADC_1.CTR1.R                  /* Conversion Timing Register 1 */
#define ADC_1_CTR2           ADC_1.CTR2.R                  /* Conversion Timing Register 2 */
#define ADC_1_NCMR0          ADC_1.NCMR0.R                 /* Normal Conversion Mask Register 0 */
#define ADC_1_NCMR1          ADC_1.NCMR1.R                 /* Normal Conversion Mask Register 1 */
#define ADC_1_NCMR2          ADC_1.NCMR2.R                 /* Normal Conversion Mask Register 2 */
#define ADC_1_JCMR0          ADC_1.JCMR0.R                 /* Injected Conversion Mask Register 0 */
#define ADC_1_JCMR1          ADC_1.JCMR1.R                 /* Injected Conversion Mask Register 1 */
#define ADC_1_JCMR2          ADC_1.JCMR2.R                 /* Injected Conversion Mask Register 2 */
#define ADC_1_DSDR           ADC_1.DSDR.R                  /* Decode Signals Delay Register */
#define ADC_1_PDEDR          ADC_1.PDEDR.R                 /* Power Down Exit Delay Register */
#define ADC_1_CDR0           ADC_1.CDR[0].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR1           ADC_1.CDR[1].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR2           ADC_1.CDR[2].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR3           ADC_1.CDR[3].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR4           ADC_1.CDR[4].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR5           ADC_1.CDR[5].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR6           ADC_1.CDR[6].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR7           ADC_1.CDR[7].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR8           ADC_1.CDR[8].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR9           ADC_1.CDR[9].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR10          ADC_1.CDR[10].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR11          ADC_1.CDR[11].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR12          ADC_1.CDR[12].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR13          ADC_1.CDR[13].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR14          ADC_1.CDR[14].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR15          ADC_1.CDR[15].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR16          ADC_1.CDR[16].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR17          ADC_1.CDR[17].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR18          ADC_1.CDR[18].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR19          ADC_1.CDR[19].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR20          ADC_1.CDR[20].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR21          ADC_1.CDR[21].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR22          ADC_1.CDR[22].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR23          ADC_1.CDR[23].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR24          ADC_1.CDR[24].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR25          ADC_1.CDR[25].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR26          ADC_1.CDR[26].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR27          ADC_1.CDR[27].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR28          ADC_1.CDR[28].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR29          ADC_1.CDR[29].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR30          ADC_1.CDR[30].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR31          ADC_1.CDR[31].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR32          ADC_1.CDR[32].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR33          ADC_1.CDR[33].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR34          ADC_1.CDR[34].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR35          ADC_1.CDR[35].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR36          ADC_1.CDR[36].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR37          ADC_1.CDR[37].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR38          ADC_1.CDR[38].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR39          ADC_1.CDR[39].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR40          ADC_1.CDR[40].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR41          ADC_1.CDR[41].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR42          ADC_1.CDR[42].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR43          ADC_1.CDR[43].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR44          ADC_1.CDR[44].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR45          ADC_1.CDR[45].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR46          ADC_1.CDR[46].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR47          ADC_1.CDR[47].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR48          ADC_1.CDR[48].R               /*  */
#define ADC_1_CDR49          ADC_1.CDR[49].R               /*  */
#define ADC_1_CDR50          ADC_1.CDR[50].R               /*  */
#define ADC_1_CDR51          ADC_1.CDR[51].R               /*  */
#define ADC_1_CDR52          ADC_1.CDR[52].R               /*  */
#define ADC_1_CDR53          ADC_1.CDR[53].R               /*  */
#define ADC_1_CDR54          ADC_1.CDR[54].R               /*  */
#define ADC_1_CDR55          ADC_1.CDR[55].R               /*  */
#define ADC_1_CDR56          ADC_1.CDR[56].R               /*  */
#define ADC_1_CDR57          ADC_1.CDR[57].R               /*  */
#define ADC_1_CDR58          ADC_1.CDR[58].R               /*  */
#define ADC_1_CDR59          ADC_1.CDR[59].R               /*  */
#define ADC_1_CDR60          ADC_1.CDR[60].R               /*  */
#define ADC_1_CDR61          ADC_1.CDR[61].R               /*  */
#define ADC_1_CDR62          ADC_1.CDR[62].R               /*  */
#define ADC_1_CDR63          ADC_1.CDR[63].R               /*  */
#define ADC_1_CDR64          ADC_1.CDR[64].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR65          ADC_1.CDR[65].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR66          ADC_1.CDR[66].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR67          ADC_1.CDR[67].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR68          ADC_1.CDR[68].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR69          ADC_1.CDR[69].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR70          ADC_1.CDR[70].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR71          ADC_1.CDR[71].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR72          ADC_1.CDR[72].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR73          ADC_1.CDR[73].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR74          ADC_1.CDR[74].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR75          ADC_1.CDR[75].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR76          ADC_1.CDR[76].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR77          ADC_1.CDR[77].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR78          ADC_1.CDR[78].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR79          ADC_1.CDR[79].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR80          ADC_1.CDR[80].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR81          ADC_1.CDR[81].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR82          ADC_1.CDR[82].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR83          ADC_1.CDR[83].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR84          ADC_1.CDR[84].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR85          ADC_1.CDR[85].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR86          ADC_1.CDR[86].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR87          ADC_1.CDR[87].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR88          ADC_1.CDR[88].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR89          ADC_1.CDR[89].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR90          ADC_1.CDR[90].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR91          ADC_1.CDR[91].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR92          ADC_1.CDR[92].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR93          ADC_1.CDR[93].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR94          ADC_1.CDR[94].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR95          ADC_1.CDR[95].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CWSELR0        ADC_1.CWSELR0.R               /* Channel Watchdog Select Register 0 */
#define ADC_1_CWSELR1        ADC_1.CWSELR1.R               /* Channel Watchdog Select Register 1 */
#define ADC_1_CWSELR2        ADC_1.CWSELR2.R               /* Channel Watchdog Select Register 2 */
#define ADC_1_CWSELR3        ADC_1.CWSELR3.R               /* Channel Watchdog Select Register 3 */
#define ADC_1_CWSELR4        ADC_1.CWSELR4.R               /* Channel Watchdog Select Register 4 */
#define ADC_1_CWSELR5        ADC_1.CWSELR5.R               /* Channel Watchdog Select Register 5 */
#define ADC_1_CWSELR8        ADC_1.CWSELR8.R               /* Channel Watchdog Select Register 8 */
#define ADC_1_CWSELR9        ADC_1.CWSELR9.R               /* Channel Watchdog Select Register 9 */
#define ADC_1_CWSELR10       ADC_1.CWSELR10.R              /* Channel Watchdog Select Register 10 */
#define ADC_1_CWSELR11       ADC_1.CWSELR11.R              /* Channel Watchdog Select Register 11 */
#define ADC_1_CWENR0         ADC_1.CWENR0.R                /* Channel Watchdog Enable Register 0 */
#define ADC_1_CWENR1         ADC_1.CWENR1.R                /* Channel Watchdog Enable Register 1 */
#define ADC_1_CWENR2         ADC_1.CWENR2.R                /* Channel Watchdog Enable Register 2 */
#define ADC_1_AWORR0         ADC_1.AWORR0.R                /* Analog Watchdog Out of Range Register 0 */
#define ADC_1_AWORR1         ADC_1.AWORR1.R                /* Analog Watchdog Out of Range Register 1 */
#define ADC_1_AWORR2         ADC_1.AWORR2.R                /* Analog Watchdog Out of Range Register 2 */
#define ADC_1_STCR1          ADC_1.STCR1.R                 /* Self Test Configuration Register 1 */
#define ADC_1_STCR2          ADC_1.STCR2.R                 /* Self Test Configuration Register 2 */
#define ADC_1_STCR3          ADC_1.STCR3.R                 /* Self Test Configuration Register 3 */
#define ADC_1_STBRR          ADC_1.STBRR.R                 /* Self Test Baud Rate Register */
#define ADC_1_STSR1          ADC_1.STSR1.R                 /* Self Test Status Register 1 */
#define ADC_1_STSR2          ADC_1.STSR2.R                 /* Self Test Status Register 2 */
#define ADC_1_STSR3          ADC_1.STSR3.R                 /* Self Test Status Register 3 */
#define ADC_1_STSR4          ADC_1.STSR4.R                 /* Self Test Status Register 4 */
#define ADC_1_STDR1          ADC_1.STDR1.R                 /* Self Test Data Register 1 */
#define ADC_1_STDR2          ADC_1.STDR2.R                 /* Self Test Data Register 2 */
#define ADC_1_STAW0R         ADC_1.STAW0R.R                /* Self Test Analog Watchdog Register 0 */
#define ADC_1_STAW1AR        ADC_1.STAW1AR.R               /* Self Test Analog Watchdog Register 1A */
#define ADC_1_STAW1BR        ADC_1.STAW1BR.R               /* Self Test Analog Watchdog Register 1B */
#define ADC_1_STAW2R         ADC_1.STAW2R.R                /* Self Test Analog Watchdog Register 2 */
#define ADC_1_STAW4R         ADC_1.STAW4R.R                /* Self Test Analog Watchdog Register 4 */
#define ADC_1_STAW5R         ADC_1.STAW5R.R                /* Self Test Analog Watchdog Register 5 */
#define ADC_1_CALBISTREG     ADC_1.CALBISTREG.R            /* Calibration, BIST Control and status Register */
#define ADC_1_OFSGNUSR       ADC_1.OFSGNUSR.R              /* Offset and Gain User Register */
#define ADC_1_ALTR           ADC_1.ALTR.R                  /* Alternate Result register */

/* ADC */
#define ADC_2_MCR            ADC_2.MCR.R                   /* Main Configuration Register */
#define ADC_2_MSR            ADC_2.MSR.R                   /* Main Status register */
#define ADC_2_ISR            ADC_2.ISR.R                   /* Interrupt Status Register */
#define ADC_2_CEOCFR0        ADC_2.CEOCFR0.R               /* Channel Pending register 0 */
#define ADC_2_CEOCFR1        ADC_2.CEOCFR1.R               /* Channel Pending register 1 */
#define ADC_2_CEOCFR2        ADC_2.CEOCFR2.R               /* Channel Pending register 2 */
#define ADC_2_IMR            ADC_2.IMR.R                   /* Interrupt Mask Register */
#define ADC_2_CIMR0          ADC_2.CIMR0.R                 /* Channel Interrupt Mask Register 0 */
#define ADC_2_CIMR1          ADC_2.CIMR1.R                 /* Channel Interrupt Mask Register 1 */
#define ADC_2_CIMR2          ADC_2.CIMR2.R                 /* Channel Interrupt Mask Register 2 */
#define ADC_2_WTISR          ADC_2.WTISR.R                 /* Watchdog Threshold Interrupt Status Register */
#define ADC_2_WTIMR          ADC_2.WTIMR.R                 /* Watchdog Threshold Interrupt Mask Register */
#define ADC_2_DMAE           ADC_2.DMAE.R                  /* DMA Enable register */
#define ADC_2_DMAR0          ADC_2.DMAR0.R                 /* DMA Channel Select Register 0 */
#define ADC_2_DMAR1          ADC_2.DMAR1.R                 /* DMA Channel Select Register 1 */
#define ADC_2_DMAR2          ADC_2.DMAR2.R                 /* DMA Channel Select Register 2 */
#define ADC_2_THRHLR0        ADC_2.THRHLR0.R               /* Threshold Register */
#define ADC_2_THRHLR1        ADC_2.THRHLR1.R               /* Threshold Register */
#define ADC_2_THRHLR2        ADC_2.THRHLR2.R               /* Threshold Register */
#define ADC_2_THRHLR3        ADC_2.THRHLR3.R               /* Threshold Register */
#define ADC_2_PSCR           ADC_2.PSCR.R                  /* Presampling Control Register */
#define ADC_2_PSR0           ADC_2.PSR0.R                  /* Presampling register 0 */
#define ADC_2_PSR1           ADC_2.PSR1.R                  /* Presampling register 1 */
#define ADC_2_PSR2           ADC_2.PSR2.R                  /* Presampling register 2 */
#define ADC_2_CTR0           ADC_2.CTR0.R                  /* Conversion Timing Register 0 */
#define ADC_2_CTR1           ADC_2.CTR1.R                  /* Conversion Timing Register 1 */
#define ADC_2_CTR2           ADC_2.CTR2.R                  /* Conversion Timing Register 2 */
#define ADC_2_NCMR0          ADC_2.NCMR0.R                 /* Normal Conversion Mask Register 0 */
#define ADC_2_NCMR1          ADC_2.NCMR1.R                 /* Normal Conversion Mask Register 1 */
#define ADC_2_NCMR2          ADC_2.NCMR2.R                 /* Normal Conversion Mask Register 2 */
#define ADC_2_JCMR0          ADC_2.JCMR0.R                 /* Injected Conversion Mask Register 0 */
#define ADC_2_JCMR1          ADC_2.JCMR1.R                 /* Injected Conversion Mask Register 1 */
#define ADC_2_JCMR2          ADC_2.JCMR2.R                 /* Injected Conversion Mask Register 2 */
#define ADC_2_DSDR           ADC_2.DSDR.R                  /* Decode Signals Delay Register */
#define ADC_2_PDEDR          ADC_2.PDEDR.R                 /* Power Down Exit Delay Register */
#define ADC_2_CDR0           ADC_2.CDR[0].R                /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR1           ADC_2.CDR[1].R                /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR2           ADC_2.CDR[2].R                /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR3           ADC_2.CDR[3].R                /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR4           ADC_2.CDR[4].R                /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR5           ADC_2.CDR[5].R                /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR6           ADC_2.CDR[6].R                /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR7           ADC_2.CDR[7].R                /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR8           ADC_2.CDR[8].R                /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR9           ADC_2.CDR[9].R                /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR10          ADC_2.CDR[10].R               /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR11          ADC_2.CDR[11].R               /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR12          ADC_2.CDR[12].R               /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR13          ADC_2.CDR[13].R               /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR14          ADC_2.CDR[14].R               /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR15          ADC_2.CDR[15].R               /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR16          ADC_2.CDR[16].R               /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR17          ADC_2.CDR[17].R               /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR18          ADC_2.CDR[18].R               /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR19          ADC_2.CDR[19].R               /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR20          ADC_2.CDR[20].R               /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR21          ADC_2.CDR[21].R               /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR22          ADC_2.CDR[22].R               /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR23          ADC_2.CDR[23].R               /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR24          ADC_2.CDR[24].R               /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR25          ADC_2.CDR[25].R               /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR26          ADC_2.CDR[26].R               /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR27          ADC_2.CDR[27].R               /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR28          ADC_2.CDR[28].R               /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR29          ADC_2.CDR[29].R               /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR30          ADC_2.CDR[30].R               /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR31          ADC_2.CDR[31].R               /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR32          ADC_2.CDR[32].R               /* Channel Data Register n (Internal Channels) */
#define ADC_2_CDR33          ADC_2.CDR[33].R               /* Channel Data Register n (Internal Channels) */
#define ADC_2_CDR34          ADC_2.CDR[34].R               /* Channel Data Register n (Internal Channels) */
#define ADC_2_CDR35          ADC_2.CDR[35].R               /* Channel Data Register n (Internal Channels) */
#define ADC_2_CDR36          ADC_2.CDR[36].R               /* Channel Data Register n (Internal Channels) */
#define ADC_2_CDR37          ADC_2.CDR[37].R               /* Channel Data Register n (Internal Channels) */
#define ADC_2_CDR38          ADC_2.CDR[38].R               /* Channel Data Register n (Internal Channels) */
#define ADC_2_CDR39          ADC_2.CDR[39].R               /* Channel Data Register n (Internal Channels) */
#define ADC_2_CDR40          ADC_2.CDR[40].R               /* Channel Data Register n (Internal Channels) */
#define ADC_2_CDR41          ADC_2.CDR[41].R               /* Channel Data Register n (Internal Channels) */
#define ADC_2_CDR42          ADC_2.CDR[42].R               /* Channel Data Register n (Internal Channels) */
#define ADC_2_CDR43          ADC_2.CDR[43].R               /* Channel Data Register n (Internal Channels) */
#define ADC_2_CDR44          ADC_2.CDR[44].R               /* Channel Data Register n (Internal Channels) */
#define ADC_2_CDR45          ADC_2.CDR[45].R               /* Channel Data Register n (Internal Channels) */
#define ADC_2_CDR46          ADC_2.CDR[46].R               /* Channel Data Register n (Internal Channels) */
#define ADC_2_CDR47          ADC_2.CDR[47].R               /* Channel Data Register n (Internal Channels) */
#define ADC_2_CDR48          ADC_2.CDR[48].R               /*  */
#define ADC_2_CDR49          ADC_2.CDR[49].R               /*  */
#define ADC_2_CDR50          ADC_2.CDR[50].R               /*  */
#define ADC_2_CDR51          ADC_2.CDR[51].R               /*  */
#define ADC_2_CDR52          ADC_2.CDR[52].R               /*  */
#define ADC_2_CDR53          ADC_2.CDR[53].R               /*  */
#define ADC_2_CDR54          ADC_2.CDR[54].R               /*  */
#define ADC_2_CDR55          ADC_2.CDR[55].R               /*  */
#define ADC_2_CDR56          ADC_2.CDR[56].R               /*  */
#define ADC_2_CDR57          ADC_2.CDR[57].R               /*  */
#define ADC_2_CDR58          ADC_2.CDR[58].R               /*  */
#define ADC_2_CDR59          ADC_2.CDR[59].R               /*  */
#define ADC_2_CDR60          ADC_2.CDR[60].R               /*  */
#define ADC_2_CDR61          ADC_2.CDR[61].R               /*  */
#define ADC_2_CDR62          ADC_2.CDR[62].R               /*  */
#define ADC_2_CDR63          ADC_2.CDR[63].R               /*  */
#define ADC_2_CDR64          ADC_2.CDR[64].R               /* Channel Data Register n (External Channels) */
#define ADC_2_CDR65          ADC_2.CDR[65].R               /* Channel Data Register n (External Channels) */
#define ADC_2_CDR66          ADC_2.CDR[66].R               /* Channel Data Register n (External Channels) */
#define ADC_2_CDR67          ADC_2.CDR[67].R               /* Channel Data Register n (External Channels) */
#define ADC_2_CDR68          ADC_2.CDR[68].R               /* Channel Data Register n (External Channels) */
#define ADC_2_CDR69          ADC_2.CDR[69].R               /* Channel Data Register n (External Channels) */
#define ADC_2_CDR70          ADC_2.CDR[70].R               /* Channel Data Register n (External Channels) */
#define ADC_2_CDR71          ADC_2.CDR[71].R               /* Channel Data Register n (External Channels) */
#define ADC_2_CDR72          ADC_2.CDR[72].R               /* Channel Data Register n (External Channels) */
#define ADC_2_CDR73          ADC_2.CDR[73].R               /* Channel Data Register n (External Channels) */
#define ADC_2_CDR74          ADC_2.CDR[74].R               /* Channel Data Register n (External Channels) */
#define ADC_2_CDR75          ADC_2.CDR[75].R               /* Channel Data Register n (External Channels) */
#define ADC_2_CDR76          ADC_2.CDR[76].R               /* Channel Data Register n (External Channels) */
#define ADC_2_CDR77          ADC_2.CDR[77].R               /* Channel Data Register n (External Channels) */
#define ADC_2_CDR78          ADC_2.CDR[78].R               /* Channel Data Register n (External Channels) */
#define ADC_2_CDR79          ADC_2.CDR[79].R               /* Channel Data Register n (External Channels) */
#define ADC_2_CDR80          ADC_2.CDR[80].R               /* Channel Data Register n (External Channels) */
#define ADC_2_CDR81          ADC_2.CDR[81].R               /* Channel Data Register n (External Channels) */
#define ADC_2_CDR82          ADC_2.CDR[82].R               /* Channel Data Register n (External Channels) */
#define ADC_2_CDR83          ADC_2.CDR[83].R               /* Channel Data Register n (External Channels) */
#define ADC_2_CDR84          ADC_2.CDR[84].R               /* Channel Data Register n (External Channels) */
#define ADC_2_CDR85          ADC_2.CDR[85].R               /* Channel Data Register n (External Channels) */
#define ADC_2_CDR86          ADC_2.CDR[86].R               /* Channel Data Register n (External Channels) */
#define ADC_2_CDR87          ADC_2.CDR[87].R               /* Channel Data Register n (External Channels) */
#define ADC_2_CDR88          ADC_2.CDR[88].R               /* Channel Data Register n (External Channels) */
#define ADC_2_CDR89          ADC_2.CDR[89].R               /* Channel Data Register n (External Channels) */
#define ADC_2_CDR90          ADC_2.CDR[90].R               /* Channel Data Register n (External Channels) */
#define ADC_2_CDR91          ADC_2.CDR[91].R               /* Channel Data Register n (External Channels) */
#define ADC_2_CDR92          ADC_2.CDR[92].R               /* Channel Data Register n (External Channels) */
#define ADC_2_CDR93          ADC_2.CDR[93].R               /* Channel Data Register n (External Channels) */
#define ADC_2_CDR94          ADC_2.CDR[94].R               /* Channel Data Register n (External Channels) */
#define ADC_2_CDR95          ADC_2.CDR[95].R               /* Channel Data Register n (External Channels) */
#define ADC_2_CWSELR0        ADC_2.CWSELR0.R               /* Channel Watchdog Select Register 0 */
#define ADC_2_CWSELR1        ADC_2.CWSELR1.R               /* Channel Watchdog Select Register 1 */
#define ADC_2_CWSELR2        ADC_2.CWSELR2.R               /* Channel Watchdog Select Register 2 */
#define ADC_2_CWSELR3        ADC_2.CWSELR3.R               /* Channel Watchdog Select Register 3 */
#define ADC_2_CWSELR4        ADC_2.CWSELR4.R               /* Channel Watchdog Select Register 4 */
#define ADC_2_CWSELR5        ADC_2.CWSELR5.R               /* Channel Watchdog Select Register 5 */
#define ADC_2_CWSELR8        ADC_2.CWSELR8.R               /* Channel Watchdog Select Register 8 */
#define ADC_2_CWSELR9        ADC_2.CWSELR9.R               /* Channel Watchdog Select Register 9 */
#define ADC_2_CWSELR10       ADC_2.CWSELR10.R              /* Channel Watchdog Select Register 10 */
#define ADC_2_CWSELR11       ADC_2.CWSELR11.R              /* Channel Watchdog Select Register 11 */
#define ADC_2_CWENR0         ADC_2.CWENR0.R                /* Channel Watchdog Enable Register 0 */
#define ADC_2_CWENR1         ADC_2.CWENR1.R                /* Channel Watchdog Enable Register 1 */
#define ADC_2_CWENR2         ADC_2.CWENR2.R                /* Channel Watchdog Enable Register 2 */
#define ADC_2_AWORR0         ADC_2.AWORR0.R                /* Analog Watchdog Out of Range Register 0 */
#define ADC_2_AWORR1         ADC_2.AWORR1.R                /* Analog Watchdog Out of Range Register 1 */
#define ADC_2_AWORR2         ADC_2.AWORR2.R                /* Analog Watchdog Out of Range Register 2 */
#define ADC_2_STCR1          ADC_2.STCR1.R                 /* Self Test Configuration Register 1 */
#define ADC_2_STCR2          ADC_2.STCR2.R                 /* Self Test Configuration Register 2 */
#define ADC_2_STCR3          ADC_2.STCR3.R                 /* Self Test Configuration Register 3 */
#define ADC_2_STBRR          ADC_2.STBRR.R                 /* Self Test Baud Rate Register */
#define ADC_2_STSR1          ADC_2.STSR1.R                 /* Self Test Status Register 1 */
#define ADC_2_STSR2          ADC_2.STSR2.R                 /* Self Test Status Register 2 */
#define ADC_2_STSR3          ADC_2.STSR3.R                 /* Self Test Status Register 3 */
#define ADC_2_STSR4          ADC_2.STSR4.R                 /* Self Test Status Register 4 */
#define ADC_2_STDR1          ADC_2.STDR1.R                 /* Self Test Data Register 1 */
#define ADC_2_STDR2          ADC_2.STDR2.R                 /* Self Test Data Register 2 */
#define ADC_2_STAW0R         ADC_2.STAW0R.R                /* Self Test Analog Watchdog Register 0 */
#define ADC_2_STAW1AR        ADC_2.STAW1AR.R               /* Self Test Analog Watchdog Register 1A */
#define ADC_2_STAW1BR        ADC_2.STAW1BR.R               /* Self Test Analog Watchdog Register 1B */
#define ADC_2_STAW2R         ADC_2.STAW2R.R                /* Self Test Analog Watchdog Register 2 */
#define ADC_2_STAW4R         ADC_2.STAW4R.R                /* Self Test Analog Watchdog Register 4 */
#define ADC_2_STAW5R         ADC_2.STAW5R.R                /* Self Test Analog Watchdog Register 5 */
#define ADC_2_CALBISTREG     ADC_2.CALBISTREG.R            /* Calibration, BIST Control and status Register */
#define ADC_2_OFSGNUSR       ADC_2.OFSGNUSR.R              /* Offset and Gain User Register */
#define ADC_2_ALTR           ADC_2.ALTR.R                  /* Alternate Result register */

/* ADC */
#define ADC_3_MCR            ADC_3.MCR.R                   /* Main Configuration Register */
#define ADC_3_MSR            ADC_3.MSR.R                   /* Main Status register */
#define ADC_3_ISR            ADC_3.ISR.R                   /* Interrupt Status Register */
#define ADC_3_CEOCFR0        ADC_3.CEOCFR0.R               /* Channel Pending register 0 */
#define ADC_3_CEOCFR1        ADC_3.CEOCFR1.R               /* Channel Pending register 1 */
#define ADC_3_CEOCFR2        ADC_3.CEOCFR2.R               /* Channel Pending register 2 */
#define ADC_3_IMR            ADC_3.IMR.R                   /* Interrupt Mask Register */
#define ADC_3_CIMR0          ADC_3.CIMR0.R                 /* Channel Interrupt Mask Register 0 */
#define ADC_3_CIMR1          ADC_3.CIMR1.R                 /* Channel Interrupt Mask Register 1 */
#define ADC_3_CIMR2          ADC_3.CIMR2.R                 /* Channel Interrupt Mask Register 2 */
#define ADC_3_WTISR          ADC_3.WTISR.R                 /* Watchdog Threshold Interrupt Status Register */
#define ADC_3_WTIMR          ADC_3.WTIMR.R                 /* Watchdog Threshold Interrupt Mask Register */
#define ADC_3_DMAE           ADC_3.DMAE.R                  /* DMA Enable register */
#define ADC_3_DMAR0          ADC_3.DMAR0.R                 /* DMA Channel Select Register 0 */
#define ADC_3_DMAR1          ADC_3.DMAR1.R                 /* DMA Channel Select Register 1 */
#define ADC_3_DMAR2          ADC_3.DMAR2.R                 /* DMA Channel Select Register 2 */
#define ADC_3_THRHLR0        ADC_3.THRHLR0.R               /* Threshold Register */
#define ADC_3_THRHLR1        ADC_3.THRHLR1.R               /* Threshold Register */
#define ADC_3_THRHLR2        ADC_3.THRHLR2.R               /* Threshold Register */
#define ADC_3_THRHLR3        ADC_3.THRHLR3.R               /* Threshold Register */
#define ADC_3_PSCR           ADC_3.PSCR.R                  /* Presampling Control Register */
#define ADC_3_PSR0           ADC_3.PSR0.R                  /* Presampling register 0 */
#define ADC_3_PSR1           ADC_3.PSR1.R                  /* Presampling register 1 */
#define ADC_3_PSR2           ADC_3.PSR2.R                  /* Presampling register 2 */
#define ADC_3_CTR0           ADC_3.CTR0.R                  /* Conversion Timing Register 0 */
#define ADC_3_CTR1           ADC_3.CTR1.R                  /* Conversion Timing Register 1 */
#define ADC_3_CTR2           ADC_3.CTR2.R                  /* Conversion Timing Register 2 */
#define ADC_3_NCMR0          ADC_3.NCMR0.R                 /* Normal Conversion Mask Register 0 */
#define ADC_3_NCMR1          ADC_3.NCMR1.R                 /* Normal Conversion Mask Register 1 */
#define ADC_3_NCMR2          ADC_3.NCMR2.R                 /* Normal Conversion Mask Register 2 */
#define ADC_3_JCMR0          ADC_3.JCMR0.R                 /* Injected Conversion Mask Register 0 */
#define ADC_3_JCMR1          ADC_3.JCMR1.R                 /* Injected Conversion Mask Register 1 */
#define ADC_3_JCMR2          ADC_3.JCMR2.R                 /* Injected Conversion Mask Register 2 */
#define ADC_3_DSDR           ADC_3.DSDR.R                  /* Decode Signals Delay Register */
#define ADC_3_PDEDR          ADC_3.PDEDR.R                 /* Power Down Exit Delay Register */
#define ADC_3_CDR0           ADC_3.CDR[0].R                /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR1           ADC_3.CDR[1].R                /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR2           ADC_3.CDR[2].R                /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR3           ADC_3.CDR[3].R                /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR4           ADC_3.CDR[4].R                /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR5           ADC_3.CDR[5].R                /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR6           ADC_3.CDR[6].R                /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR7           ADC_3.CDR[7].R                /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR8           ADC_3.CDR[8].R                /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR9           ADC_3.CDR[9].R                /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR10          ADC_3.CDR[10].R               /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR11          ADC_3.CDR[11].R               /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR12          ADC_3.CDR[12].R               /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR13          ADC_3.CDR[13].R               /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR14          ADC_3.CDR[14].R               /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR15          ADC_3.CDR[15].R               /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR16          ADC_3.CDR[16].R               /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR17          ADC_3.CDR[17].R               /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR18          ADC_3.CDR[18].R               /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR19          ADC_3.CDR[19].R               /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR20          ADC_3.CDR[20].R               /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR21          ADC_3.CDR[21].R               /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR22          ADC_3.CDR[22].R               /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR23          ADC_3.CDR[23].R               /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR24          ADC_3.CDR[24].R               /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR25          ADC_3.CDR[25].R               /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR26          ADC_3.CDR[26].R               /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR27          ADC_3.CDR[27].R               /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR28          ADC_3.CDR[28].R               /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR29          ADC_3.CDR[29].R               /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR30          ADC_3.CDR[30].R               /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR31          ADC_3.CDR[31].R               /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR32          ADC_3.CDR[32].R               /* Channel Data Register n (Internal Channels) */
#define ADC_3_CDR33          ADC_3.CDR[33].R               /* Channel Data Register n (Internal Channels) */
#define ADC_3_CDR34          ADC_3.CDR[34].R               /* Channel Data Register n (Internal Channels) */
#define ADC_3_CDR35          ADC_3.CDR[35].R               /* Channel Data Register n (Internal Channels) */
#define ADC_3_CDR36          ADC_3.CDR[36].R               /* Channel Data Register n (Internal Channels) */
#define ADC_3_CDR37          ADC_3.CDR[37].R               /* Channel Data Register n (Internal Channels) */
#define ADC_3_CDR38          ADC_3.CDR[38].R               /* Channel Data Register n (Internal Channels) */
#define ADC_3_CDR39          ADC_3.CDR[39].R               /* Channel Data Register n (Internal Channels) */
#define ADC_3_CDR40          ADC_3.CDR[40].R               /* Channel Data Register n (Internal Channels) */
#define ADC_3_CDR41          ADC_3.CDR[41].R               /* Channel Data Register n (Internal Channels) */
#define ADC_3_CDR42          ADC_3.CDR[42].R               /* Channel Data Register n (Internal Channels) */
#define ADC_3_CDR43          ADC_3.CDR[43].R               /* Channel Data Register n (Internal Channels) */
#define ADC_3_CDR44          ADC_3.CDR[44].R               /* Channel Data Register n (Internal Channels) */
#define ADC_3_CDR45          ADC_3.CDR[45].R               /* Channel Data Register n (Internal Channels) */
#define ADC_3_CDR46          ADC_3.CDR[46].R               /* Channel Data Register n (Internal Channels) */
#define ADC_3_CDR47          ADC_3.CDR[47].R               /* Channel Data Register n (Internal Channels) */
#define ADC_3_CDR48          ADC_3.CDR[48].R               /*  */
#define ADC_3_CDR49          ADC_3.CDR[49].R               /*  */
#define ADC_3_CDR50          ADC_3.CDR[50].R               /*  */
#define ADC_3_CDR51          ADC_3.CDR[51].R               /*  */
#define ADC_3_CDR52          ADC_3.CDR[52].R               /*  */
#define ADC_3_CDR53          ADC_3.CDR[53].R               /*  */
#define ADC_3_CDR54          ADC_3.CDR[54].R               /*  */
#define ADC_3_CDR55          ADC_3.CDR[55].R               /*  */
#define ADC_3_CDR56          ADC_3.CDR[56].R               /*  */
#define ADC_3_CDR57          ADC_3.CDR[57].R               /*  */
#define ADC_3_CDR58          ADC_3.CDR[58].R               /*  */
#define ADC_3_CDR59          ADC_3.CDR[59].R               /*  */
#define ADC_3_CDR60          ADC_3.CDR[60].R               /*  */
#define ADC_3_CDR61          ADC_3.CDR[61].R               /*  */
#define ADC_3_CDR62          ADC_3.CDR[62].R               /*  */
#define ADC_3_CDR63          ADC_3.CDR[63].R               /*  */
#define ADC_3_CDR64          ADC_3.CDR[64].R               /* Channel Data Register n (External Channels) */
#define ADC_3_CDR65          ADC_3.CDR[65].R               /* Channel Data Register n (External Channels) */
#define ADC_3_CDR66          ADC_3.CDR[66].R               /* Channel Data Register n (External Channels) */
#define ADC_3_CDR67          ADC_3.CDR[67].R               /* Channel Data Register n (External Channels) */
#define ADC_3_CDR68          ADC_3.CDR[68].R               /* Channel Data Register n (External Channels) */
#define ADC_3_CDR69          ADC_3.CDR[69].R               /* Channel Data Register n (External Channels) */
#define ADC_3_CDR70          ADC_3.CDR[70].R               /* Channel Data Register n (External Channels) */
#define ADC_3_CDR71          ADC_3.CDR[71].R               /* Channel Data Register n (External Channels) */
#define ADC_3_CDR72          ADC_3.CDR[72].R               /* Channel Data Register n (External Channels) */
#define ADC_3_CDR73          ADC_3.CDR[73].R               /* Channel Data Register n (External Channels) */
#define ADC_3_CDR74          ADC_3.CDR[74].R               /* Channel Data Register n (External Channels) */
#define ADC_3_CDR75          ADC_3.CDR[75].R               /* Channel Data Register n (External Channels) */
#define ADC_3_CDR76          ADC_3.CDR[76].R               /* Channel Data Register n (External Channels) */
#define ADC_3_CDR77          ADC_3.CDR[77].R               /* Channel Data Register n (External Channels) */
#define ADC_3_CDR78          ADC_3.CDR[78].R               /* Channel Data Register n (External Channels) */
#define ADC_3_CDR79          ADC_3.CDR[79].R               /* Channel Data Register n (External Channels) */
#define ADC_3_CDR80          ADC_3.CDR[80].R               /* Channel Data Register n (External Channels) */
#define ADC_3_CDR81          ADC_3.CDR[81].R               /* Channel Data Register n (External Channels) */
#define ADC_3_CDR82          ADC_3.CDR[82].R               /* Channel Data Register n (External Channels) */
#define ADC_3_CDR83          ADC_3.CDR[83].R               /* Channel Data Register n (External Channels) */
#define ADC_3_CDR84          ADC_3.CDR[84].R               /* Channel Data Register n (External Channels) */
#define ADC_3_CDR85          ADC_3.CDR[85].R               /* Channel Data Register n (External Channels) */
#define ADC_3_CDR86          ADC_3.CDR[86].R               /* Channel Data Register n (External Channels) */
#define ADC_3_CDR87          ADC_3.CDR[87].R               /* Channel Data Register n (External Channels) */
#define ADC_3_CDR88          ADC_3.CDR[88].R               /* Channel Data Register n (External Channels) */
#define ADC_3_CDR89          ADC_3.CDR[89].R               /* Channel Data Register n (External Channels) */
#define ADC_3_CDR90          ADC_3.CDR[90].R               /* Channel Data Register n (External Channels) */
#define ADC_3_CDR91          ADC_3.CDR[91].R               /* Channel Data Register n (External Channels) */
#define ADC_3_CDR92          ADC_3.CDR[92].R               /* Channel Data Register n (External Channels) */
#define ADC_3_CDR93          ADC_3.CDR[93].R               /* Channel Data Register n (External Channels) */
#define ADC_3_CDR94          ADC_3.CDR[94].R               /* Channel Data Register n (External Channels) */
#define ADC_3_CDR95          ADC_3.CDR[95].R               /* Channel Data Register n (External Channels) */
#define ADC_3_CWSELR0        ADC_3.CWSELR0.R               /* Channel Watchdog Select Register 0 */
#define ADC_3_CWSELR1        ADC_3.CWSELR1.R               /* Channel Watchdog Select Register 1 */
#define ADC_3_CWSELR2        ADC_3.CWSELR2.R               /* Channel Watchdog Select Register 2 */
#define ADC_3_CWSELR3        ADC_3.CWSELR3.R               /* Channel Watchdog Select Register 3 */
#define ADC_3_CWSELR4        ADC_3.CWSELR4.R               /* Channel Watchdog Select Register 4 */
#define ADC_3_CWSELR5        ADC_3.CWSELR5.R               /* Channel Watchdog Select Register 5 */
#define ADC_3_CWSELR8        ADC_3.CWSELR8.R               /* Channel Watchdog Select Register 8 */
#define ADC_3_CWSELR9        ADC_3.CWSELR9.R               /* Channel Watchdog Select Register 9 */
#define ADC_3_CWSELR10       ADC_3.CWSELR10.R              /* Channel Watchdog Select Register 10 */
#define ADC_3_CWSELR11       ADC_3.CWSELR11.R              /* Channel Watchdog Select Register 11 */
#define ADC_3_CWENR0         ADC_3.CWENR0.R                /* Channel Watchdog Enable Register 0 */
#define ADC_3_CWENR1         ADC_3.CWENR1.R                /* Channel Watchdog Enable Register 1 */
#define ADC_3_CWENR2         ADC_3.CWENR2.R                /* Channel Watchdog Enable Register 2 */
#define ADC_3_AWORR0         ADC_3.AWORR0.R                /* Analog Watchdog Out of Range Register 0 */
#define ADC_3_AWORR1         ADC_3.AWORR1.R                /* Analog Watchdog Out of Range Register 1 */
#define ADC_3_AWORR2         ADC_3.AWORR2.R                /* Analog Watchdog Out of Range Register 2 */
#define ADC_3_STCR1          ADC_3.STCR1.R                 /* Self Test Configuration Register 1 */
#define ADC_3_STCR2          ADC_3.STCR2.R                 /* Self Test Configuration Register 2 */
#define ADC_3_STCR3          ADC_3.STCR3.R                 /* Self Test Configuration Register 3 */
#define ADC_3_STBRR          ADC_3.STBRR.R                 /* Self Test Baud Rate Register */
#define ADC_3_STSR1          ADC_3.STSR1.R                 /* Self Test Status Register 1 */
#define ADC_3_STSR2          ADC_3.STSR2.R                 /* Self Test Status Register 2 */
#define ADC_3_STSR3          ADC_3.STSR3.R                 /* Self Test Status Register 3 */
#define ADC_3_STSR4          ADC_3.STSR4.R                 /* Self Test Status Register 4 */
#define ADC_3_STDR1          ADC_3.STDR1.R                 /* Self Test Data Register 1 */
#define ADC_3_STDR2          ADC_3.STDR2.R                 /* Self Test Data Register 2 */
#define ADC_3_STAW0R         ADC_3.STAW0R.R                /* Self Test Analog Watchdog Register 0 */
#define ADC_3_STAW1AR        ADC_3.STAW1AR.R               /* Self Test Analog Watchdog Register 1A */
#define ADC_3_STAW1BR        ADC_3.STAW1BR.R               /* Self Test Analog Watchdog Register 1B */
#define ADC_3_STAW2R         ADC_3.STAW2R.R                /* Self Test Analog Watchdog Register 2 */
#define ADC_3_STAW4R         ADC_3.STAW4R.R                /* Self Test Analog Watchdog Register 4 */
#define ADC_3_STAW5R         ADC_3.STAW5R.R                /* Self Test Analog Watchdog Register 5 */
#define ADC_3_CALBISTREG     ADC_3.CALBISTREG.R            /* Calibration, BIST Control and status Register */
#define ADC_3_OFSGNUSR       ADC_3.OFSGNUSR.R              /* Offset and Gain User Register */
#define ADC_3_ALTR           ADC_3.ALTR.R                  /* Alternate Result register */

/* AIPS */
#define AIPS_A_MPRA          AIPS_A.MPRA.R                 /* Master Privilege Register A */
#define AIPS_A_MPRB          AIPS_A.MPRB.R                 /* Master Privilege Register B */
#define AIPS_A_PACRA         AIPS_A.PACR[0].R              /* Peripheral Access Control Register */
#define AIPS_A_PACRB         AIPS_A.PACR[1].R              /* Peripheral Access Control Register */
#define AIPS_A_PACRC         AIPS_A.PACR[2].R              /* Peripheral Access Control Register */
#define AIPS_A_PACRD         AIPS_A.PACR[3].R              /* Peripheral Access Control Register */
#define AIPS_A_PACR_Reserved AIPS_A.PACR[4].R              /* Peripheral Access Control Register */
#define AIPS_A_PACRF         AIPS_A.PACR[5].R              /* Peripheral Access Control Register */
#define AIPS_A_PACRG         AIPS_A.PACR[6].R              /* Peripheral Access Control Register */
#define AIPS_A_PACRH         AIPS_A.PACR[7].R              /* Peripheral Access Control Register */
#define AIPS_A_OPACRA        AIPS_A.OPACR[0].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRB        AIPS_A.OPACR[1].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRC        AIPS_A.OPACR[2].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRD        AIPS_A.OPACR[3].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRE        AIPS_A.OPACR[4].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRF        AIPS_A.OPACR[5].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRG        AIPS_A.OPACR[6].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRH        AIPS_A.OPACR[7].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRI        AIPS_A.OPACR[8].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRJ        AIPS_A.OPACR[9].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRK        AIPS_A.OPACR[10].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRL        AIPS_A.OPACR[11].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRM        AIPS_A.OPACR[12].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRN        AIPS_A.OPACR[13].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRO        AIPS_A.OPACR[14].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRP        AIPS_A.OPACR[15].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRQ        AIPS_A.OPACR[16].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRR        AIPS_A.OPACR[17].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRS        AIPS_A.OPACR[18].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRT        AIPS_A.OPACR[19].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRU        AIPS_A.OPACR[20].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRV        AIPS_A.OPACR[21].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRW        AIPS_A.OPACR[22].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRX        AIPS_A.OPACR[23].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRY        AIPS_A.OPACR[24].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRZ        AIPS_A.OPACR[25].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRAA       AIPS_A.OPACR[26].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRAB       AIPS_A.OPACR[27].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRAC       AIPS_A.OPACR[28].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRAD       AIPS_A.OPACR[29].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRAE       AIPS_A.OPACR[30].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRAF       AIPS_A.OPACR[31].R            /* Off-Platform Peripheral Access Control Register */

/* AIPS */
#define AIPS_B_MPRA          AIPS_B.MPRA.R                 /* Master Privilege Register A */
#define AIPS_B_MPRB          AIPS_B.MPRB.R                 /* Master Privilege Register B */
#define AIPS_B_PACRA         AIPS_B.PACR[0].R              /* Peripheral Access Control Register */
#define AIPS_B_PACRB         AIPS_B.PACR[1].R              /* Peripheral Access Control Register */
#define AIPS_B_PACRC         AIPS_B.PACR[2].R              /* Peripheral Access Control Register */
#define AIPS_B_PACRD         AIPS_B.PACR[3].R              /* Peripheral Access Control Register */
#define AIPS_B_PACR_Reserved AIPS_B.PACR[4].R              /* Peripheral Access Control Register */
#define AIPS_B_PACRF         AIPS_B.PACR[5].R              /* Peripheral Access Control Register */
#define AIPS_B_PACRG         AIPS_B.PACR[6].R              /* Peripheral Access Control Register */
#define AIPS_B_PACRH         AIPS_B.PACR[7].R              /* Peripheral Access Control Register */
#define AIPS_B_OPACRA        AIPS_B.OPACR[0].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRB        AIPS_B.OPACR[1].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRC        AIPS_B.OPACR[2].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRD        AIPS_B.OPACR[3].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRE        AIPS_B.OPACR[4].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRF        AIPS_B.OPACR[5].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRG        AIPS_B.OPACR[6].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRH        AIPS_B.OPACR[7].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRI        AIPS_B.OPACR[8].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRJ        AIPS_B.OPACR[9].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRK        AIPS_B.OPACR[10].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRL        AIPS_B.OPACR[11].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRM        AIPS_B.OPACR[12].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRN        AIPS_B.OPACR[13].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRO        AIPS_B.OPACR[14].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRP        AIPS_B.OPACR[15].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRQ        AIPS_B.OPACR[16].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRR        AIPS_B.OPACR[17].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRS        AIPS_B.OPACR[18].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRT        AIPS_B.OPACR[19].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRU        AIPS_B.OPACR[20].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRV        AIPS_B.OPACR[21].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRW        AIPS_B.OPACR[22].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRX        AIPS_B.OPACR[23].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRY        AIPS_B.OPACR[24].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRZ        AIPS_B.OPACR[25].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRAA       AIPS_B.OPACR[26].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRAB       AIPS_B.OPACR[27].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRAC       AIPS_B.OPACR[28].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRAD       AIPS_B.OPACR[29].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRAE       AIPS_B.OPACR[30].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRAF       AIPS_B.OPACR[31].R            /* Off-Platform Peripheral Access Control Register */

/* BCTU */
#define BCTU_MCR             BCTU.MCR.R                    /* Module Configuration Register */
#define BCTU_MSR             BCTU.MSR.R                    /* Module Status register */
#define BCTU_TRGCFG_0        BCTU.TRGCFG[0].R              /* Trigger Configuration Register */
#define BCTU_TRGCFG_1        BCTU.TRGCFG[1].R              /* Trigger Configuration Register */
#define BCTU_TRGCFG_2        BCTU.TRGCFG[2].R              /* Trigger Configuration Register */
#define BCTU_TRGCFG_3        BCTU.TRGCFG[3].R              /* Trigger Configuration Register */
#define BCTU_TRGCFG_4        BCTU.TRGCFG[4].R              /* Trigger Configuration Register */
#define BCTU_TRGCFG_5        BCTU.TRGCFG[5].R              /* Trigger Configuration Register */
#define BCTU_TRGCFG_6        BCTU.TRGCFG[6].R              /* Trigger Configuration Register */
#define BCTU_TRGCFG_7        BCTU.TRGCFG[7].R              /* Trigger Configuration Register */
#define BCTU_TRGCFG_8        BCTU.TRGCFG[8].R              /* Trigger Configuration Register */
#define BCTU_TRGCFG_9        BCTU.TRGCFG[9].R              /* Trigger Configuration Register */
#define BCTU_TRGCFG_10       BCTU.TRGCFG[10].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_11       BCTU.TRGCFG[11].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_12       BCTU.TRGCFG[12].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_13       BCTU.TRGCFG[13].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_14       BCTU.TRGCFG[14].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_15       BCTU.TRGCFG[15].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_16       BCTU.TRGCFG[16].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_17       BCTU.TRGCFG[17].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_18       BCTU.TRGCFG[18].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_19       BCTU.TRGCFG[19].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_20       BCTU.TRGCFG[20].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_21       BCTU.TRGCFG[21].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_22       BCTU.TRGCFG[22].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_23       BCTU.TRGCFG[23].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_24       BCTU.TRGCFG[24].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_25       BCTU.TRGCFG[25].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_26       BCTU.TRGCFG[26].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_27       BCTU.TRGCFG[27].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_28       BCTU.TRGCFG[28].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_29       BCTU.TRGCFG[29].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_30       BCTU.TRGCFG[30].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_31       BCTU.TRGCFG[31].R             /* Trigger Configuration Register */
#define BCTU_WRPROT          BCTU.WRPROT.R                 /* Write Protection register */
#define BCTU_SFTRGR1         BCTU.SFTRGR1.R                /* Software Trigger register 1 */
#define BCTU_ADC0DR          BCTU.ADCDR[0].R               /* ADC0 Result Data register */
#define BCTU_ADC1DR          BCTU.ADCDR[1].R               /* ADC1 result data register */
#define BCTU_ADC2DR          BCTU.ADCDR[2].R               /* ADC2 result data register */
#define BCTU_ADC3DR          BCTU.ADCDR[3].R               /* ADC3 result data register */
#define BCTU_LISTSTAR        BCTU.LISTSTAR.R               /* LIST Size Status register */
#define BCTU_LISTCHR_0       BCTU.LISTCHR[0].R             /* LIST Channel Address Register */
#define BCTU_LISTCHR_1       BCTU.LISTCHR[1].R             /* LIST Channel Address Register */
#define BCTU_LISTCHR_2       BCTU.LISTCHR[2].R             /* LIST Channel Address Register */
#define BCTU_LISTCHR_3       BCTU.LISTCHR[3].R             /* LIST Channel Address Register */
#define BCTU_LISTCHR_4       BCTU.LISTCHR[4].R             /* LIST Channel Address Register */
#define BCTU_LISTCHR_5       BCTU.LISTCHR[5].R             /* LIST Channel Address Register */
#define BCTU_LISTCHR_6       BCTU.LISTCHR[6].R             /* LIST Channel Address Register */
#define BCTU_LISTCHR_7       BCTU.LISTCHR[7].R             /* LIST Channel Address Register */
#define BCTU_LISTCHR_8       BCTU.LISTCHR[8].R             /* LIST Channel Address Register */
#define BCTU_LISTCHR_9       BCTU.LISTCHR[9].R             /* LIST Channel Address Register */
#define BCTU_LISTCHR_10      BCTU.LISTCHR[10].R            /* LIST Channel Address Register */
#define BCTU_LISTCHR_11      BCTU.LISTCHR[11].R            /* LIST Channel Address Register */
#define BCTU_LISTCHR_12      BCTU.LISTCHR[12].R            /* LIST Channel Address Register */
#define BCTU_LISTCHR_13      BCTU.LISTCHR[13].R            /* LIST Channel Address Register */
#define BCTU_LISTCHR_14      BCTU.LISTCHR[14].R            /* LIST Channel Address Register */
#define BCTU_LISTCHR_15      BCTU.LISTCHR[15].R            /* LIST Channel Address Register */
#define BCTU_LISTCHR_16      BCTU.LISTCHR[16].R            /* LIST Channel Address Register */
#define BCTU_LISTCHR_17      BCTU.LISTCHR[17].R            /* LIST Channel Address Register */
#define BCTU_LISTCHR_18      BCTU.LISTCHR[18].R            /* LIST Channel Address Register */
#define BCTU_LISTCHR_19      BCTU.LISTCHR[19].R            /* LIST Channel Address Register */
#define BCTU_LISTCHR_20      BCTU.LISTCHR[20].R            /* LIST Channel Address Register */
#define BCTU_LISTCHR_21      BCTU.LISTCHR[21].R            /* LIST Channel Address Register */
#define BCTU_LISTCHR_22      BCTU.LISTCHR[22].R            /* LIST Channel Address Register */
#define BCTU_LISTCHR_23      BCTU.LISTCHR[23].R            /* LIST Channel Address Register */
#define BCTU_LISTCHR_24      BCTU.LISTCHR[24].R            /* LIST Channel Address Register */
#define BCTU_LISTCHR_25      BCTU.LISTCHR[25].R            /* LIST Channel Address Register */
#define BCTU_LISTCHR_26      BCTU.LISTCHR[26].R            /* LIST Channel Address Register */
#define BCTU_LISTCHR_27      BCTU.LISTCHR[27].R            /* LIST Channel Address Register */
#define BCTU_LISTCHR_28      BCTU.LISTCHR[28].R            /* LIST Channel Address Register */
#define BCTU_LISTCHR_29      BCTU.LISTCHR[29].R            /* LIST Channel Address Register */
#define BCTU_LISTCHR_30      BCTU.LISTCHR[30].R            /* LIST Channel Address Register */
#define BCTU_LISTCHR_31      BCTU.LISTCHR[31].R            /* LIST Channel Address Register */
#define BCTU_CCR_0           BCTU.CCR[0].R                 /* Conversion configuration register */
#define BCTU_CCR_1           BCTU.CCR[1].R                 /* Conversion configuration register */
#define BCTU_CCR_2           BCTU.CCR[2].R                 /* Conversion configuration register */
#define BCTU_CCR_3           BCTU.CCR[3].R                 /* Conversion configuration register */
#define BCTU_CCR_4           BCTU.CCR[4].R                 /* Conversion configuration register */
#define BCTU_CCR_5           BCTU.CCR[5].R                 /* Conversion configuration register */
#define BCTU_CCR_6           BCTU.CCR[6].R                 /* Conversion configuration register */
#define BCTU_CCR_7           BCTU.CCR[7].R                 /* Conversion configuration register */
#define BCTU_CCR_8           BCTU.CCR[8].R                 /* Conversion configuration register */
#define BCTU_CCR_9           BCTU.CCR[9].R                 /* Conversion configuration register */
#define BCTU_CCR_10          BCTU.CCR[10].R                /* Conversion configuration register */

/* C55FMC */
#define C55FMC_MCR           C55FMC.MCR.R                  /* Module Configuration Register */
#define C55FMC_MCRE          C55FMC.MCRE.R                 /* Extended Module Configuration Register */
#define C55FMC_LOCK0         C55FMC.LOCK0.R                /* Lock 0 register */
#define C55FMC_LOCK1         C55FMC.LOCK1.R                /* Lock 1 register */
#define C55FMC_LOCK2         C55FMC.LOCK2.R                /* Lock 2 register */
#define C55FMC_LOCK3         C55FMC.LOCK3.R                /* Lock 3 register */
#define C55FMC_SEL0          C55FMC.SEL0.R                 /* Select 0 register */
#define C55FMC_SEL1          C55FMC.SEL1.R                 /* Select 1 register */
#define C55FMC_SEL2          C55FMC.SEL2.R                 /* Select 2 register */
#define C55FMC_SEL3          C55FMC.SEL3.R                 /* Select 3 register */
#define C55FMC_ADR           C55FMC.ADR.R                  /* Address register */
#define C55FMC_UT0           C55FMC.UT0.R                  /* UTest 0 register */
#define C55FMC_UM0           C55FMC.UM[0].R                /* UMISR register */
#define C55FMC_UM1           C55FMC.UM[1].R                /* UMISR register */
#define C55FMC_UM2           C55FMC.UM[2].R                /* UMISR register */
#define C55FMC_UM3           C55FMC.UM[3].R                /* UMISR register */
#define C55FMC_UM4           C55FMC.UM[4].R                /* UMISR register */
#define C55FMC_UM5           C55FMC.UM[5].R                /* UMISR register */
#define C55FMC_UM6           C55FMC.UM[6].R                /* UMISR register */
#define C55FMC_UM7           C55FMC.UM[7].R                /* UMISR register */
#define C55FMC_UM8           C55FMC.UM[8].R                /* UMISR register */
#define C55FMC_UM9           C55FMC.UM9.R                  /* UMISR register */
#define C55FMC_OPP0          C55FMC.OPP0.R                 /* Over-Program Protection 0 register */
#define C55FMC_OPP1          C55FMC.OPP1.R                 /* Over-Program Protection 1 register */
#define C55FMC_OPP2          C55FMC.OPP2.R                 /* Over-Program Protection 2 register */
#define C55FMC_OPP3          C55FMC.OPP3.R                 /* Over-Program Protection 3 register */

/* CAN */
#define CAN_0_MCR            CAN_0.MCR.R                   /* Module Configuration Register */
#define CAN_0_CTRL1          CAN_0.CTRL1.R                 /* Control 1 register */
#define CAN_0_TIMER          CAN_0.TIMER.R                 /* Free Running Timer */
#define CAN_0_RXMGMASK       CAN_0.RXMGMASK.R              /* Rx Mailboxes Global Mask Register */
#define CAN_0_RX14MASK       CAN_0.RX14MASK.R              /* Rx 14 Mask register */
#define CAN_0_RX15MASK       CAN_0.RX15MASK.R              /* Rx 15 Mask register */
#define CAN_0_ECR            CAN_0.ECR.R                   /* Error Counter */
#define CAN_0_ESR1           CAN_0.ESR1.R                  /* Error and Status 1 register */
#define CAN_0_IMASK2         CAN_0.IMASK2.R                /* Interrupt Masks 2 register */
#define CAN_0_IMASK1         CAN_0.IMASK1.R                /* Interrupt Masks 1 register */
#define CAN_0_IFLAG2         CAN_0.IFLAG2.R                /* Interrupt Flags 2 register */
#define CAN_0_IFLAG1         CAN_0.IFLAG1.R                /* Interrupt Flags 1 register */
#define CAN_0_CTRL2          CAN_0.CTRL2.R                 /* Control 2 register */
#define CAN_0_ESR2           CAN_0.ESR2.R                  /* Error and Status 2 register */
#define CAN_0_CRCR           CAN_0.CRCR.R                  /* CRC Register */
#define CAN_0_RXFGMASK       CAN_0.RXFGMASK.R              /* Rx FIFO Global Mask register */
#define CAN_0_RXFIR          CAN_0.RXFIR.R                 /* Rx FIFO Information Register */
#define CAN_0_CS0            CAN_0.MB[0].CS.R              /* Message Buffer 0 CS Register */
#define CAN_0_ID0            CAN_0.MB[0].ID.R              /* Message Buffer 0 ID Register */
#define CAN_0_B0             CAN_0.MB[0].DATA.B.R          /* Message Buffer 0 B Register */
#define CAN_0_H0             CAN_0.MB[0].DATA.H.R          /* Message Buffer 0 H Register */
#define CAN_0_W0             CAN_0.MB[0].DATA.W.R          /* Message Buffer 0 W Register */
#define CAN_0_CS1            CAN_0.MB[1].CS.R              /* Message Buffer 1 CS Register */
#define CAN_0_ID1            CAN_0.MB[1].ID.R              /* Message Buffer 1 ID Register */
#define CAN_0_B1             CAN_0.MB[1].DATA.B.R          /* Message Buffer 1 B Register */
#define CAN_0_H1             CAN_0.MB[1].DATA.H.R          /* Message Buffer 1 H Register */
#define CAN_0_W1             CAN_0.MB[1].DATA.W.R          /* Message Buffer 1 W Register */
#define CAN_0_CS2            CAN_0.MB[2].CS.R              /* Message Buffer 2 CS Register */
#define CAN_0_ID2            CAN_0.MB[2].ID.R              /* Message Buffer 2 ID Register */
#define CAN_0_B2             CAN_0.MB[2].DATA.B.R          /* Message Buffer 2 B Register */
#define CAN_0_H2             CAN_0.MB[2].DATA.H.R          /* Message Buffer 2 H Register */
#define CAN_0_W2             CAN_0.MB[2].DATA.W.R          /* Message Buffer 2 W Register */
#define CAN_0_CS3            CAN_0.MB[3].CS.R              /* Message Buffer 3 CS Register */
#define CAN_0_ID3            CAN_0.MB[3].ID.R              /* Message Buffer 3 ID Register */
#define CAN_0_B3             CAN_0.MB[3].DATA.B.R          /* Message Buffer 3 B Register */
#define CAN_0_H3             CAN_0.MB[3].DATA.H.R          /* Message Buffer 3 H Register */
#define CAN_0_W3             CAN_0.MB[3].DATA.W.R          /* Message Buffer 3 W Register */
#define CAN_0_CS4            CAN_0.MB[4].CS.R              /* Message Buffer 4 CS Register */
#define CAN_0_ID4            CAN_0.MB[4].ID.R              /* Message Buffer 4 ID Register */
#define CAN_0_B4             CAN_0.MB[4].DATA.B.R          /* Message Buffer 4 B Register */
#define CAN_0_H4             CAN_0.MB[4].DATA.H.R          /* Message Buffer 4 H Register */
#define CAN_0_W4             CAN_0.MB[4].DATA.W.R          /* Message Buffer 4 W Register */
#define CAN_0_CS5            CAN_0.MB[5].CS.R              /* Message Buffer 5 CS Register */
#define CAN_0_ID5            CAN_0.MB[5].ID.R              /* Message Buffer 5 ID Register */
#define CAN_0_B5             CAN_0.MB[5].DATA.B.R          /* Message Buffer 5 B Register */
#define CAN_0_H5             CAN_0.MB[5].DATA.H.R          /* Message Buffer 5 H Register */
#define CAN_0_W5             CAN_0.MB[5].DATA.W.R          /* Message Buffer 5 W Register */
#define CAN_0_CS6            CAN_0.MB[6].CS.R              /* Message Buffer 6 CS Register */
#define CAN_0_ID6            CAN_0.MB[6].ID.R              /* Message Buffer 6 ID Register */
#define CAN_0_B6             CAN_0.MB[6].DATA.B.R          /* Message Buffer 6 B Register */
#define CAN_0_H6             CAN_0.MB[6].DATA.H.R          /* Message Buffer 6 H Register */
#define CAN_0_W6             CAN_0.MB[6].DATA.W.R          /* Message Buffer 6 W Register */
#define CAN_0_CS7            CAN_0.MB[7].CS.R              /* Message Buffer 7 CS Register */
#define CAN_0_ID7            CAN_0.MB[7].ID.R              /* Message Buffer 7 ID Register */
#define CAN_0_B7             CAN_0.MB[7].DATA.B.R          /* Message Buffer 7 B Register */
#define CAN_0_H7             CAN_0.MB[7].DATA.H.R          /* Message Buffer 7 H Register */
#define CAN_0_W7             CAN_0.MB[7].DATA.W.R          /* Message Buffer 7 W Register */
#define CAN_0_CS8            CAN_0.MB[8].CS.R              /* Message Buffer 8 CS Register */
#define CAN_0_ID8            CAN_0.MB[8].ID.R              /* Message Buffer 8 ID Register */
#define CAN_0_B8             CAN_0.MB[8].DATA.B.R          /* Message Buffer 8 B Register */
#define CAN_0_H8             CAN_0.MB[8].DATA.H.R          /* Message Buffer 8 H Register */
#define CAN_0_W8             CAN_0.MB[8].DATA.W.R          /* Message Buffer 8 W Register */
#define CAN_0_CS9            CAN_0.MB[9].CS.R              /* Message Buffer 9 CS Register */
#define CAN_0_ID9            CAN_0.MB[9].ID.R              /* Message Buffer 9 ID Register */
#define CAN_0_B9             CAN_0.MB[9].DATA.B.R          /* Message Buffer 9 B Register */
#define CAN_0_H9             CAN_0.MB[9].DATA.H.R          /* Message Buffer 9 H Register */
#define CAN_0_W9             CAN_0.MB[9].DATA.W.R          /* Message Buffer 9 W Register */
#define CAN_0_CS10           CAN_0.MB[10].CS.R             /* Message Buffer 10 CS Register */
#define CAN_0_ID10           CAN_0.MB[10].ID.R             /* Message Buffer 10 ID Register */
#define CAN_0_B10            CAN_0.MB[10].DATA.B.R         /* Message Buffer 10 B Register */
#define CAN_0_H10            CAN_0.MB[10].DATA.H.R         /* Message Buffer 10 H Register */
#define CAN_0_W10            CAN_0.MB[10].DATA.W.R         /* Message Buffer 10 W Register */
#define CAN_0_CS11           CAN_0.MB[11].CS.R             /* Message Buffer 11 CS Register */
#define CAN_0_ID11           CAN_0.MB[11].ID.R             /* Message Buffer 11 ID Register */
#define CAN_0_B11            CAN_0.MB[11].DATA.B.R         /* Message Buffer 11 B Register */
#define CAN_0_H11            CAN_0.MB[11].DATA.H.R         /* Message Buffer 11 H Register */
#define CAN_0_W11            CAN_0.MB[11].DATA.W.R         /* Message Buffer 11 W Register */
#define CAN_0_CS12           CAN_0.MB[12].CS.R             /* Message Buffer 12 CS Register */
#define CAN_0_ID12           CAN_0.MB[12].ID.R             /* Message Buffer 12 ID Register */
#define CAN_0_B12            CAN_0.MB[12].DATA.B.R         /* Message Buffer 12 B Register */
#define CAN_0_H12            CAN_0.MB[12].DATA.H.R         /* Message Buffer 12 H Register */
#define CAN_0_W12            CAN_0.MB[12].DATA.W.R         /* Message Buffer 12 W Register */
#define CAN_0_CS13           CAN_0.MB[13].CS.R             /* Message Buffer 13 CS Register */
#define CAN_0_ID13           CAN_0.MB[13].ID.R             /* Message Buffer 13 ID Register */
#define CAN_0_B13            CAN_0.MB[13].DATA.B.R         /* Message Buffer 13 B Register */
#define CAN_0_H13            CAN_0.MB[13].DATA.H.R         /* Message Buffer 13 H Register */
#define CAN_0_W13            CAN_0.MB[13].DATA.W.R         /* Message Buffer 13 W Register */
#define CAN_0_CS14           CAN_0.MB[14].CS.R             /* Message Buffer 14 CS Register */
#define CAN_0_ID14           CAN_0.MB[14].ID.R             /* Message Buffer 14 ID Register */
#define CAN_0_B14            CAN_0.MB[14].DATA.B.R         /* Message Buffer 14 B Register */
#define CAN_0_H14            CAN_0.MB[14].DATA.H.R         /* Message Buffer 14 H Register */
#define CAN_0_W14            CAN_0.MB[14].DATA.W.R         /* Message Buffer 14 W Register */
#define CAN_0_CS15           CAN_0.MB[15].CS.R             /* Message Buffer 15 CS Register */
#define CAN_0_ID15           CAN_0.MB[15].ID.R             /* Message Buffer 15 ID Register */
#define CAN_0_B15            CAN_0.MB[15].DATA.B.R         /* Message Buffer 15 B Register */
#define CAN_0_H15            CAN_0.MB[15].DATA.H.R         /* Message Buffer 15 H Register */
#define CAN_0_W15            CAN_0.MB[15].DATA.W.R         /* Message Buffer 15 W Register */
#define CAN_0_CS16           CAN_0.MB[16].CS.R             /* Message Buffer 16 CS Register */
#define CAN_0_ID16           CAN_0.MB[16].ID.R             /* Message Buffer 16 ID Register */
#define CAN_0_B16            CAN_0.MB[16].DATA.B.R         /* Message Buffer 16 B Register */
#define CAN_0_H16            CAN_0.MB[16].DATA.H.R         /* Message Buffer 16 H Register */
#define CAN_0_W16            CAN_0.MB[16].DATA.W.R         /* Message Buffer 16 W Register */
#define CAN_0_CS17           CAN_0.MB[17].CS.R             /* Message Buffer 17 CS Register */
#define CAN_0_ID17           CAN_0.MB[17].ID.R             /* Message Buffer 17 ID Register */
#define CAN_0_B17            CAN_0.MB[17].DATA.B.R         /* Message Buffer 17 B Register */
#define CAN_0_H17            CAN_0.MB[17].DATA.H.R         /* Message Buffer 17 H Register */
#define CAN_0_W17            CAN_0.MB[17].DATA.W.R         /* Message Buffer 17 W Register */
#define CAN_0_CS18           CAN_0.MB[18].CS.R             /* Message Buffer 18 CS Register */
#define CAN_0_ID18           CAN_0.MB[18].ID.R             /* Message Buffer 18 ID Register */
#define CAN_0_B18            CAN_0.MB[18].DATA.B.R         /* Message Buffer 18 B Register */
#define CAN_0_H18            CAN_0.MB[18].DATA.H.R         /* Message Buffer 18 H Register */
#define CAN_0_W18            CAN_0.MB[18].DATA.W.R         /* Message Buffer 18 W Register */
#define CAN_0_CS19           CAN_0.MB[19].CS.R             /* Message Buffer 19 CS Register */
#define CAN_0_ID19           CAN_0.MB[19].ID.R             /* Message Buffer 19 ID Register */
#define CAN_0_B19            CAN_0.MB[19].DATA.B.R         /* Message Buffer 19 B Register */
#define CAN_0_H19            CAN_0.MB[19].DATA.H.R         /* Message Buffer 19 H Register */
#define CAN_0_W19            CAN_0.MB[19].DATA.W.R         /* Message Buffer 19 W Register */
#define CAN_0_CS20           CAN_0.MB[20].CS.R             /* Message Buffer 20 CS Register */
#define CAN_0_ID20           CAN_0.MB[20].ID.R             /* Message Buffer 20 ID Register */
#define CAN_0_B20            CAN_0.MB[20].DATA.B.R         /* Message Buffer 20 B Register */
#define CAN_0_H20            CAN_0.MB[20].DATA.H.R         /* Message Buffer 20 H Register */
#define CAN_0_W20            CAN_0.MB[20].DATA.W.R         /* Message Buffer 20 W Register */
#define CAN_0_CS21           CAN_0.MB[21].CS.R             /* Message Buffer 21 CS Register */
#define CAN_0_ID21           CAN_0.MB[21].ID.R             /* Message Buffer 21 ID Register */
#define CAN_0_B21            CAN_0.MB[21].DATA.B.R         /* Message Buffer 21 B Register */
#define CAN_0_H21            CAN_0.MB[21].DATA.H.R         /* Message Buffer 21 H Register */
#define CAN_0_W21            CAN_0.MB[21].DATA.W.R         /* Message Buffer 21 W Register */
#define CAN_0_CS22           CAN_0.MB[22].CS.R             /* Message Buffer 22 CS Register */
#define CAN_0_ID22           CAN_0.MB[22].ID.R             /* Message Buffer 22 ID Register */
#define CAN_0_B22            CAN_0.MB[22].DATA.B.R         /* Message Buffer 22 B Register */
#define CAN_0_H22            CAN_0.MB[22].DATA.H.R         /* Message Buffer 22 H Register */
#define CAN_0_W22            CAN_0.MB[22].DATA.W.R         /* Message Buffer 22 W Register */
#define CAN_0_CS23           CAN_0.MB[23].CS.R             /* Message Buffer 23 CS Register */
#define CAN_0_ID23           CAN_0.MB[23].ID.R             /* Message Buffer 23 ID Register */
#define CAN_0_B23            CAN_0.MB[23].DATA.B.R         /* Message Buffer 23 B Register */
#define CAN_0_H23            CAN_0.MB[23].DATA.H.R         /* Message Buffer 23 H Register */
#define CAN_0_W23            CAN_0.MB[23].DATA.W.R         /* Message Buffer 23 W Register */
#define CAN_0_CS24           CAN_0.MB[24].CS.R             /* Message Buffer 24 CS Register */
#define CAN_0_ID24           CAN_0.MB[24].ID.R             /* Message Buffer 24 ID Register */
#define CAN_0_B24            CAN_0.MB[24].DATA.B.R         /* Message Buffer 24 B Register */
#define CAN_0_H24            CAN_0.MB[24].DATA.H.R         /* Message Buffer 24 H Register */
#define CAN_0_W24            CAN_0.MB[24].DATA.W.R         /* Message Buffer 24 W Register */
#define CAN_0_CS25           CAN_0.MB[25].CS.R             /* Message Buffer 25 CS Register */
#define CAN_0_ID25           CAN_0.MB[25].ID.R             /* Message Buffer 25 ID Register */
#define CAN_0_B25            CAN_0.MB[25].DATA.B.R         /* Message Buffer 25 B Register */
#define CAN_0_H25            CAN_0.MB[25].DATA.H.R         /* Message Buffer 25 H Register */
#define CAN_0_W25            CAN_0.MB[25].DATA.W.R         /* Message Buffer 25 W Register */
#define CAN_0_CS26           CAN_0.MB[26].CS.R             /* Message Buffer 26 CS Register */
#define CAN_0_ID26           CAN_0.MB[26].ID.R             /* Message Buffer 26 ID Register */
#define CAN_0_B26            CAN_0.MB[26].DATA.B.R         /* Message Buffer 26 B Register */
#define CAN_0_H26            CAN_0.MB[26].DATA.H.R         /* Message Buffer 26 H Register */
#define CAN_0_W26            CAN_0.MB[26].DATA.W.R         /* Message Buffer 26 W Register */
#define CAN_0_CS27           CAN_0.MB[27].CS.R             /* Message Buffer 27 CS Register */
#define CAN_0_ID27           CAN_0.MB[27].ID.R             /* Message Buffer 27 ID Register */
#define CAN_0_B27            CAN_0.MB[27].DATA.B.R         /* Message Buffer 27 B Register */
#define CAN_0_H27            CAN_0.MB[27].DATA.H.R         /* Message Buffer 27 H Register */
#define CAN_0_W27            CAN_0.MB[27].DATA.W.R         /* Message Buffer 27 W Register */
#define CAN_0_CS28           CAN_0.MB[28].CS.R             /* Message Buffer 28 CS Register */
#define CAN_0_ID28           CAN_0.MB[28].ID.R             /* Message Buffer 28 ID Register */
#define CAN_0_B28            CAN_0.MB[28].DATA.B.R         /* Message Buffer 28 B Register */
#define CAN_0_H28            CAN_0.MB[28].DATA.H.R         /* Message Buffer 28 H Register */
#define CAN_0_W28            CAN_0.MB[28].DATA.W.R         /* Message Buffer 28 W Register */
#define CAN_0_CS29           CAN_0.MB[29].CS.R             /* Message Buffer 29 CS Register */
#define CAN_0_ID29           CAN_0.MB[29].ID.R             /* Message Buffer 29 ID Register */
#define CAN_0_B29            CAN_0.MB[29].DATA.B.R         /* Message Buffer 29 B Register */
#define CAN_0_H29            CAN_0.MB[29].DATA.H.R         /* Message Buffer 29 H Register */
#define CAN_0_W29            CAN_0.MB[29].DATA.W.R         /* Message Buffer 29 W Register */
#define CAN_0_CS30           CAN_0.MB[30].CS.R             /* Message Buffer 30 CS Register */
#define CAN_0_ID30           CAN_0.MB[30].ID.R             /* Message Buffer 30 ID Register */
#define CAN_0_B30            CAN_0.MB[30].DATA.B.R         /* Message Buffer 30 B Register */
#define CAN_0_H30            CAN_0.MB[30].DATA.H.R         /* Message Buffer 30 H Register */
#define CAN_0_W30            CAN_0.MB[30].DATA.W.R         /* Message Buffer 30 W Register */
#define CAN_0_CS31           CAN_0.MB[31].CS.R             /* Message Buffer 31 CS Register */
#define CAN_0_ID31           CAN_0.MB[31].ID.R             /* Message Buffer 31 ID Register */
#define CAN_0_B31            CAN_0.MB[31].DATA.B.R         /* Message Buffer 31 B Register */
#define CAN_0_H31            CAN_0.MB[31].DATA.H.R         /* Message Buffer 31 H Register */
#define CAN_0_W31            CAN_0.MB[31].DATA.W.R         /* Message Buffer 31 W Register */
#define CAN_0_CS32           CAN_0.MB[32].CS.R             /* Message Buffer 32 CS Register */
#define CAN_0_ID32           CAN_0.MB[32].ID.R             /* Message Buffer 32 ID Register */
#define CAN_0_B32            CAN_0.MB[32].DATA.B.R         /* Message Buffer 32 B Register */
#define CAN_0_H32            CAN_0.MB[32].DATA.H.R         /* Message Buffer 32 H Register */
#define CAN_0_W32            CAN_0.MB[32].DATA.W.R         /* Message Buffer 32 W Register */
#define CAN_0_CS33           CAN_0.MB[33].CS.R             /* Message Buffer 33 CS Register */
#define CAN_0_ID33           CAN_0.MB[33].ID.R             /* Message Buffer 33 ID Register */
#define CAN_0_B33            CAN_0.MB[33].DATA.B.R         /* Message Buffer 33 B Register */
#define CAN_0_H33            CAN_0.MB[33].DATA.H.R         /* Message Buffer 33 H Register */
#define CAN_0_W33            CAN_0.MB[33].DATA.W.R         /* Message Buffer 33 W Register */
#define CAN_0_CS34           CAN_0.MB[34].CS.R             /* Message Buffer 34 CS Register */
#define CAN_0_ID34           CAN_0.MB[34].ID.R             /* Message Buffer 34 ID Register */
#define CAN_0_B34            CAN_0.MB[34].DATA.B.R         /* Message Buffer 34 B Register */
#define CAN_0_H34            CAN_0.MB[34].DATA.H.R         /* Message Buffer 34 H Register */
#define CAN_0_W34            CAN_0.MB[34].DATA.W.R         /* Message Buffer 34 W Register */
#define CAN_0_CS35           CAN_0.MB[35].CS.R             /* Message Buffer 35 CS Register */
#define CAN_0_ID35           CAN_0.MB[35].ID.R             /* Message Buffer 35 ID Register */
#define CAN_0_B35            CAN_0.MB[35].DATA.B.R         /* Message Buffer 35 B Register */
#define CAN_0_H35            CAN_0.MB[35].DATA.H.R         /* Message Buffer 35 H Register */
#define CAN_0_W35            CAN_0.MB[35].DATA.W.R         /* Message Buffer 35 W Register */
#define CAN_0_CS36           CAN_0.MB[36].CS.R             /* Message Buffer 36 CS Register */
#define CAN_0_ID36           CAN_0.MB[36].ID.R             /* Message Buffer 36 ID Register */
#define CAN_0_B36            CAN_0.MB[36].DATA.B.R         /* Message Buffer 36 B Register */
#define CAN_0_H36            CAN_0.MB[36].DATA.H.R         /* Message Buffer 36 H Register */
#define CAN_0_W36            CAN_0.MB[36].DATA.W.R         /* Message Buffer 36 W Register */
#define CAN_0_CS37           CAN_0.MB[37].CS.R             /* Message Buffer 37 CS Register */
#define CAN_0_ID37           CAN_0.MB[37].ID.R             /* Message Buffer 37 ID Register */
#define CAN_0_B37            CAN_0.MB[37].DATA.B.R         /* Message Buffer 37 B Register */
#define CAN_0_H37            CAN_0.MB[37].DATA.H.R         /* Message Buffer 37 H Register */
#define CAN_0_W37            CAN_0.MB[37].DATA.W.R         /* Message Buffer 37 W Register */
#define CAN_0_CS38           CAN_0.MB[38].CS.R             /* Message Buffer 38 CS Register */
#define CAN_0_ID38           CAN_0.MB[38].ID.R             /* Message Buffer 38 ID Register */
#define CAN_0_B38            CAN_0.MB[38].DATA.B.R         /* Message Buffer 38 B Register */
#define CAN_0_H38            CAN_0.MB[38].DATA.H.R         /* Message Buffer 38 H Register */
#define CAN_0_W38            CAN_0.MB[38].DATA.W.R         /* Message Buffer 38 W Register */
#define CAN_0_CS39           CAN_0.MB[39].CS.R             /* Message Buffer 39 CS Register */
#define CAN_0_ID39           CAN_0.MB[39].ID.R             /* Message Buffer 39 ID Register */
#define CAN_0_B39            CAN_0.MB[39].DATA.B.R         /* Message Buffer 39 B Register */
#define CAN_0_H39            CAN_0.MB[39].DATA.H.R         /* Message Buffer 39 H Register */
#define CAN_0_W39            CAN_0.MB[39].DATA.W.R         /* Message Buffer 39 W Register */
#define CAN_0_CS40           CAN_0.MB[40].CS.R             /* Message Buffer 40 CS Register */
#define CAN_0_ID40           CAN_0.MB[40].ID.R             /* Message Buffer 40 ID Register */
#define CAN_0_B40            CAN_0.MB[40].DATA.B.R         /* Message Buffer 40 B Register */
#define CAN_0_H40            CAN_0.MB[40].DATA.H.R         /* Message Buffer 40 H Register */
#define CAN_0_W40            CAN_0.MB[40].DATA.W.R         /* Message Buffer 40 W Register */
#define CAN_0_CS41           CAN_0.MB[41].CS.R             /* Message Buffer 41 CS Register */
#define CAN_0_ID41           CAN_0.MB[41].ID.R             /* Message Buffer 41 ID Register */
#define CAN_0_B41            CAN_0.MB[41].DATA.B.R         /* Message Buffer 41 B Register */
#define CAN_0_H41            CAN_0.MB[41].DATA.H.R         /* Message Buffer 41 H Register */
#define CAN_0_W41            CAN_0.MB[41].DATA.W.R         /* Message Buffer 41 W Register */
#define CAN_0_CS42           CAN_0.MB[42].CS.R             /* Message Buffer 42 CS Register */
#define CAN_0_ID42           CAN_0.MB[42].ID.R             /* Message Buffer 42 ID Register */
#define CAN_0_B42            CAN_0.MB[42].DATA.B.R         /* Message Buffer 42 B Register */
#define CAN_0_H42            CAN_0.MB[42].DATA.H.R         /* Message Buffer 42 H Register */
#define CAN_0_W42            CAN_0.MB[42].DATA.W.R         /* Message Buffer 42 W Register */
#define CAN_0_CS43           CAN_0.MB[43].CS.R             /* Message Buffer 43 CS Register */
#define CAN_0_ID43           CAN_0.MB[43].ID.R             /* Message Buffer 43 ID Register */
#define CAN_0_B43            CAN_0.MB[43].DATA.B.R         /* Message Buffer 43 B Register */
#define CAN_0_H43            CAN_0.MB[43].DATA.H.R         /* Message Buffer 43 H Register */
#define CAN_0_W43            CAN_0.MB[43].DATA.W.R         /* Message Buffer 43 W Register */
#define CAN_0_CS44           CAN_0.MB[44].CS.R             /* Message Buffer 44 CS Register */
#define CAN_0_ID44           CAN_0.MB[44].ID.R             /* Message Buffer 44 ID Register */
#define CAN_0_B44            CAN_0.MB[44].DATA.B.R         /* Message Buffer 44 B Register */
#define CAN_0_H44            CAN_0.MB[44].DATA.H.R         /* Message Buffer 44 H Register */
#define CAN_0_W44            CAN_0.MB[44].DATA.W.R         /* Message Buffer 44 W Register */
#define CAN_0_CS45           CAN_0.MB[45].CS.R             /* Message Buffer 45 CS Register */
#define CAN_0_ID45           CAN_0.MB[45].ID.R             /* Message Buffer 45 ID Register */
#define CAN_0_B45            CAN_0.MB[45].DATA.B.R         /* Message Buffer 45 B Register */
#define CAN_0_H45            CAN_0.MB[45].DATA.H.R         /* Message Buffer 45 H Register */
#define CAN_0_W45            CAN_0.MB[45].DATA.W.R         /* Message Buffer 45 W Register */
#define CAN_0_CS46           CAN_0.MB[46].CS.R             /* Message Buffer 46 CS Register */
#define CAN_0_ID46           CAN_0.MB[46].ID.R             /* Message Buffer 46 ID Register */
#define CAN_0_B46            CAN_0.MB[46].DATA.B.R         /* Message Buffer 46 B Register */
#define CAN_0_H46            CAN_0.MB[46].DATA.H.R         /* Message Buffer 46 H Register */
#define CAN_0_W46            CAN_0.MB[46].DATA.W.R         /* Message Buffer 46 W Register */
#define CAN_0_CS47           CAN_0.MB[47].CS.R             /* Message Buffer 47 CS Register */
#define CAN_0_ID47           CAN_0.MB[47].ID.R             /* Message Buffer 47 ID Register */
#define CAN_0_B47            CAN_0.MB[47].DATA.B.R         /* Message Buffer 47 B Register */
#define CAN_0_H47            CAN_0.MB[47].DATA.H.R         /* Message Buffer 47 H Register */
#define CAN_0_W47            CAN_0.MB[47].DATA.W.R         /* Message Buffer 47 W Register */
#define CAN_0_CS48           CAN_0.MB[48].CS.R             /* Message Buffer 48 CS Register */
#define CAN_0_ID48           CAN_0.MB[48].ID.R             /* Message Buffer 48 ID Register */
#define CAN_0_B48            CAN_0.MB[48].DATA.B.R         /* Message Buffer 48 B Register */
#define CAN_0_H48            CAN_0.MB[48].DATA.H.R         /* Message Buffer 48 H Register */
#define CAN_0_W48            CAN_0.MB[48].DATA.W.R         /* Message Buffer 48 W Register */
#define CAN_0_CS49           CAN_0.MB[49].CS.R             /* Message Buffer 49 CS Register */
#define CAN_0_ID49           CAN_0.MB[49].ID.R             /* Message Buffer 49 ID Register */
#define CAN_0_B49            CAN_0.MB[49].DATA.B.R         /* Message Buffer 49 B Register */
#define CAN_0_H49            CAN_0.MB[49].DATA.H.R         /* Message Buffer 49 H Register */
#define CAN_0_W49            CAN_0.MB[49].DATA.W.R         /* Message Buffer 49 W Register */
#define CAN_0_CS50           CAN_0.MB[50].CS.R             /* Message Buffer 50 CS Register */
#define CAN_0_ID50           CAN_0.MB[50].ID.R             /* Message Buffer 50 ID Register */
#define CAN_0_B50            CAN_0.MB[50].DATA.B.R         /* Message Buffer 50 B Register */
#define CAN_0_H50            CAN_0.MB[50].DATA.H.R         /* Message Buffer 50 H Register */
#define CAN_0_W50            CAN_0.MB[50].DATA.W.R         /* Message Buffer 50 W Register */
#define CAN_0_CS51           CAN_0.MB[51].CS.R             /* Message Buffer 51 CS Register */
#define CAN_0_ID51           CAN_0.MB[51].ID.R             /* Message Buffer 51 ID Register */
#define CAN_0_B51            CAN_0.MB[51].DATA.B.R         /* Message Buffer 51 B Register */
#define CAN_0_H51            CAN_0.MB[51].DATA.H.R         /* Message Buffer 51 H Register */
#define CAN_0_W51            CAN_0.MB[51].DATA.W.R         /* Message Buffer 51 W Register */
#define CAN_0_CS52           CAN_0.MB[52].CS.R             /* Message Buffer 52 CS Register */
#define CAN_0_ID52           CAN_0.MB[52].ID.R             /* Message Buffer 52 ID Register */
#define CAN_0_B52            CAN_0.MB[52].DATA.B.R         /* Message Buffer 52 B Register */
#define CAN_0_H52            CAN_0.MB[52].DATA.H.R         /* Message Buffer 52 H Register */
#define CAN_0_W52            CAN_0.MB[52].DATA.W.R         /* Message Buffer 52 W Register */
#define CAN_0_CS53           CAN_0.MB[53].CS.R             /* Message Buffer 53 CS Register */
#define CAN_0_ID53           CAN_0.MB[53].ID.R             /* Message Buffer 53 ID Register */
#define CAN_0_B53            CAN_0.MB[53].DATA.B.R         /* Message Buffer 53 B Register */
#define CAN_0_H53            CAN_0.MB[53].DATA.H.R         /* Message Buffer 53 H Register */
#define CAN_0_W53            CAN_0.MB[53].DATA.W.R         /* Message Buffer 53 W Register */
#define CAN_0_CS54           CAN_0.MB[54].CS.R             /* Message Buffer 54 CS Register */
#define CAN_0_ID54           CAN_0.MB[54].ID.R             /* Message Buffer 54 ID Register */
#define CAN_0_B54            CAN_0.MB[54].DATA.B.R         /* Message Buffer 54 B Register */
#define CAN_0_H54            CAN_0.MB[54].DATA.H.R         /* Message Buffer 54 H Register */
#define CAN_0_W54            CAN_0.MB[54].DATA.W.R         /* Message Buffer 54 W Register */
#define CAN_0_CS55           CAN_0.MB[55].CS.R             /* Message Buffer 55 CS Register */
#define CAN_0_ID55           CAN_0.MB[55].ID.R             /* Message Buffer 55 ID Register */
#define CAN_0_B55            CAN_0.MB[55].DATA.B.R         /* Message Buffer 55 B Register */
#define CAN_0_H55            CAN_0.MB[55].DATA.H.R         /* Message Buffer 55 H Register */
#define CAN_0_W55            CAN_0.MB[55].DATA.W.R         /* Message Buffer 55 W Register */
#define CAN_0_CS56           CAN_0.MB[56].CS.R             /* Message Buffer 56 CS Register */
#define CAN_0_ID56           CAN_0.MB[56].ID.R             /* Message Buffer 56 ID Register */
#define CAN_0_B56            CAN_0.MB[56].DATA.B.R         /* Message Buffer 56 B Register */
#define CAN_0_H56            CAN_0.MB[56].DATA.H.R         /* Message Buffer 56 H Register */
#define CAN_0_W56            CAN_0.MB[56].DATA.W.R         /* Message Buffer 56 W Register */
#define CAN_0_CS57           CAN_0.MB[57].CS.R             /* Message Buffer 57 CS Register */
#define CAN_0_ID57           CAN_0.MB[57].ID.R             /* Message Buffer 57 ID Register */
#define CAN_0_B57            CAN_0.MB[57].DATA.B.R         /* Message Buffer 57 B Register */
#define CAN_0_H57            CAN_0.MB[57].DATA.H.R         /* Message Buffer 57 H Register */
#define CAN_0_W57            CAN_0.MB[57].DATA.W.R         /* Message Buffer 57 W Register */
#define CAN_0_CS58           CAN_0.MB[58].CS.R             /* Message Buffer 58 CS Register */
#define CAN_0_ID58           CAN_0.MB[58].ID.R             /* Message Buffer 58 ID Register */
#define CAN_0_B58            CAN_0.MB[58].DATA.B.R         /* Message Buffer 58 B Register */
#define CAN_0_H58            CAN_0.MB[58].DATA.H.R         /* Message Buffer 58 H Register */
#define CAN_0_W58            CAN_0.MB[58].DATA.W.R         /* Message Buffer 58 W Register */
#define CAN_0_CS59           CAN_0.MB[59].CS.R             /* Message Buffer 59 CS Register */
#define CAN_0_ID59           CAN_0.MB[59].ID.R             /* Message Buffer 59 ID Register */
#define CAN_0_B59            CAN_0.MB[59].DATA.B.R         /* Message Buffer 59 B Register */
#define CAN_0_H59            CAN_0.MB[59].DATA.H.R         /* Message Buffer 59 H Register */
#define CAN_0_W59            CAN_0.MB[59].DATA.W.R         /* Message Buffer 59 W Register */
#define CAN_0_CS60           CAN_0.MB[60].CS.R             /* Message Buffer 60 CS Register */
#define CAN_0_ID60           CAN_0.MB[60].ID.R             /* Message Buffer 60 ID Register */
#define CAN_0_B60            CAN_0.MB[60].DATA.B.R         /* Message Buffer 60 B Register */
#define CAN_0_H60            CAN_0.MB[60].DATA.H.R         /* Message Buffer 60 H Register */
#define CAN_0_W60            CAN_0.MB[60].DATA.W.R         /* Message Buffer 60 W Register */
#define CAN_0_CS61           CAN_0.MB[61].CS.R             /* Message Buffer 61 CS Register */
#define CAN_0_ID61           CAN_0.MB[61].ID.R             /* Message Buffer 61 ID Register */
#define CAN_0_B61            CAN_0.MB[61].DATA.B.R         /* Message Buffer 61 B Register */
#define CAN_0_H61            CAN_0.MB[61].DATA.H.R         /* Message Buffer 61 H Register */
#define CAN_0_W61            CAN_0.MB[61].DATA.W.R         /* Message Buffer 61 W Register */
#define CAN_0_CS62           CAN_0.MB[62].CS.R             /* Message Buffer 62 CS Register */
#define CAN_0_ID62           CAN_0.MB[62].ID.R             /* Message Buffer 62 ID Register */
#define CAN_0_B62            CAN_0.MB[62].DATA.B.R         /* Message Buffer 62 B Register */
#define CAN_0_H62            CAN_0.MB[62].DATA.H.R         /* Message Buffer 62 H Register */
#define CAN_0_W62            CAN_0.MB[62].DATA.W.R         /* Message Buffer 62 W Register */
#define CAN_0_CS63           CAN_0.MB[63].CS.R             /* Message Buffer 63 CS Register */
#define CAN_0_ID63           CAN_0.MB[63].ID.R             /* Message Buffer 63 ID Register */
#define CAN_0_B63            CAN_0.MB[63].DATA.B.R         /* Message Buffer 63 B Register */
#define CAN_0_H63            CAN_0.MB[63].DATA.H.R         /* Message Buffer 63 H Register */
#define CAN_0_W63            CAN_0.MB[63].DATA.W.R         /* Message Buffer 63 W Register */
#define CAN_0_RXIMR0         CAN_0.RXIMR[0].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR1         CAN_0.RXIMR[1].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR2         CAN_0.RXIMR[2].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR3         CAN_0.RXIMR[3].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR4         CAN_0.RXIMR[4].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR5         CAN_0.RXIMR[5].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR6         CAN_0.RXIMR[6].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR7         CAN_0.RXIMR[7].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR8         CAN_0.RXIMR[8].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR9         CAN_0.RXIMR[9].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR10        CAN_0.RXIMR[10].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR11        CAN_0.RXIMR[11].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR12        CAN_0.RXIMR[12].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR13        CAN_0.RXIMR[13].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR14        CAN_0.RXIMR[14].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR15        CAN_0.RXIMR[15].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR16        CAN_0.RXIMR[16].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR17        CAN_0.RXIMR[17].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR18        CAN_0.RXIMR[18].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR19        CAN_0.RXIMR[19].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR20        CAN_0.RXIMR[20].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR21        CAN_0.RXIMR[21].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR22        CAN_0.RXIMR[22].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR23        CAN_0.RXIMR[23].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR24        CAN_0.RXIMR[24].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR25        CAN_0.RXIMR[25].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR26        CAN_0.RXIMR[26].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR27        CAN_0.RXIMR[27].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR28        CAN_0.RXIMR[28].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR29        CAN_0.RXIMR[29].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR30        CAN_0.RXIMR[30].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR31        CAN_0.RXIMR[31].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR32        CAN_0.RXIMR[32].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR33        CAN_0.RXIMR[33].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR34        CAN_0.RXIMR[34].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR35        CAN_0.RXIMR[35].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR36        CAN_0.RXIMR[36].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR37        CAN_0.RXIMR[37].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR38        CAN_0.RXIMR[38].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR39        CAN_0.RXIMR[39].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR40        CAN_0.RXIMR[40].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR41        CAN_0.RXIMR[41].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR42        CAN_0.RXIMR[42].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR43        CAN_0.RXIMR[43].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR44        CAN_0.RXIMR[44].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR45        CAN_0.RXIMR[45].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR46        CAN_0.RXIMR[46].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR47        CAN_0.RXIMR[47].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR48        CAN_0.RXIMR[48].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR49        CAN_0.RXIMR[49].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR50        CAN_0.RXIMR[50].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR51        CAN_0.RXIMR[51].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR52        CAN_0.RXIMR[52].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR53        CAN_0.RXIMR[53].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR54        CAN_0.RXIMR[54].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR55        CAN_0.RXIMR[55].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR56        CAN_0.RXIMR[56].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR57        CAN_0.RXIMR[57].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR58        CAN_0.RXIMR[58].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR59        CAN_0.RXIMR[59].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR60        CAN_0.RXIMR[60].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR61        CAN_0.RXIMR[61].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR62        CAN_0.RXIMR[62].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR63        CAN_0.RXIMR[63].R             /* Rx Individual Mask Registers */
#define CAN_0_MECR           CAN_0.MECR.R                  /* Memory Error Control Register */
#define CAN_0_ERRIAR         CAN_0.ERRIAR.R                /* Error Injection Address Register */
#define CAN_0_ERRIDPR        CAN_0.ERRIDPR.R               /* Error Injection Data Pattern Register */
#define CAN_0_ERRIPPR        CAN_0.ERRIPPR.R               /* Error Injection Parity Pattern Register */
#define CAN_0_RERRAR         CAN_0.RERRAR.R                /* Error Report Address Register */
#define CAN_0_RERRDR         CAN_0.RERRDR.R                /* Error Report Data Register */
#define CAN_0_RERRSYNR       CAN_0.RERRSYNR.R              /* Error Report Syndrome Register */
#define CAN_0_ERRSR          CAN_0.ERRSR.R                 /* Error Status Register */

/* CAN */
#define CAN_1_MCR            CAN_1.MCR.R                   /* Module Configuration Register */
#define CAN_1_CTRL1          CAN_1.CTRL1.R                 /* Control 1 register */
#define CAN_1_TIMER          CAN_1.TIMER.R                 /* Free Running Timer */
#define CAN_1_RXMGMASK       CAN_1.RXMGMASK.R              /* Rx Mailboxes Global Mask Register */
#define CAN_1_RX14MASK       CAN_1.RX14MASK.R              /* Rx 14 Mask register */
#define CAN_1_RX15MASK       CAN_1.RX15MASK.R              /* Rx 15 Mask register */
#define CAN_1_ECR            CAN_1.ECR.R                   /* Error Counter */
#define CAN_1_ESR1           CAN_1.ESR1.R                  /* Error and Status 1 register */
#define CAN_1_IMASK2         CAN_1.IMASK2.R                /* Interrupt Masks 2 register */
#define CAN_1_IMASK1         CAN_1.IMASK1.R                /* Interrupt Masks 1 register */
#define CAN_1_IFLAG2         CAN_1.IFLAG2.R                /* Interrupt Flags 2 register */
#define CAN_1_IFLAG1         CAN_1.IFLAG1.R                /* Interrupt Flags 1 register */
#define CAN_1_CTRL2          CAN_1.CTRL2.R                 /* Control 2 register */
#define CAN_1_ESR2           CAN_1.ESR2.R                  /* Error and Status 2 register */
#define CAN_1_CRCR           CAN_1.CRCR.R                  /* CRC Register */
#define CAN_1_RXFGMASK       CAN_1.RXFGMASK.R              /* Rx FIFO Global Mask register */
#define CAN_1_RXFIR          CAN_1.RXFIR.R                 /* Rx FIFO Information Register */
#define CAN_1_CS0            CAN_1.MB[0].CS.R              /* Message Buffer 0 CS Register */
#define CAN_1_ID0            CAN_1.MB[0].ID.R              /* Message Buffer 0 ID Register */
#define CAN_1_B0             CAN_1.MB[0].DATA.B.R          /* Message Buffer 0 B Register */
#define CAN_1_H0             CAN_1.MB[0].DATA.H.R          /* Message Buffer 0 H Register */
#define CAN_1_W0             CAN_1.MB[0].DATA.W.R          /* Message Buffer 0 W Register */
#define CAN_1_CS1            CAN_1.MB[1].CS.R              /* Message Buffer 1 CS Register */
#define CAN_1_ID1            CAN_1.MB[1].ID.R              /* Message Buffer 1 ID Register */
#define CAN_1_B1             CAN_1.MB[1].DATA.B.R          /* Message Buffer 1 B Register */
#define CAN_1_H1             CAN_1.MB[1].DATA.H.R          /* Message Buffer 1 H Register */
#define CAN_1_W1             CAN_1.MB[1].DATA.W.R          /* Message Buffer 1 W Register */
#define CAN_1_CS2            CAN_1.MB[2].CS.R              /* Message Buffer 2 CS Register */
#define CAN_1_ID2            CAN_1.MB[2].ID.R              /* Message Buffer 2 ID Register */
#define CAN_1_B2             CAN_1.MB[2].DATA.B.R          /* Message Buffer 2 B Register */
#define CAN_1_H2             CAN_1.MB[2].DATA.H.R          /* Message Buffer 2 H Register */
#define CAN_1_W2             CAN_1.MB[2].DATA.W.R          /* Message Buffer 2 W Register */
#define CAN_1_CS3            CAN_1.MB[3].CS.R              /* Message Buffer 3 CS Register */
#define CAN_1_ID3            CAN_1.MB[3].ID.R              /* Message Buffer 3 ID Register */
#define CAN_1_B3             CAN_1.MB[3].DATA.B.R          /* Message Buffer 3 B Register */
#define CAN_1_H3             CAN_1.MB[3].DATA.H.R          /* Message Buffer 3 H Register */
#define CAN_1_W3             CAN_1.MB[3].DATA.W.R          /* Message Buffer 3 W Register */
#define CAN_1_CS4            CAN_1.MB[4].CS.R              /* Message Buffer 4 CS Register */
#define CAN_1_ID4            CAN_1.MB[4].ID.R              /* Message Buffer 4 ID Register */
#define CAN_1_B4             CAN_1.MB[4].DATA.B.R          /* Message Buffer 4 B Register */
#define CAN_1_H4             CAN_1.MB[4].DATA.H.R          /* Message Buffer 4 H Register */
#define CAN_1_W4             CAN_1.MB[4].DATA.W.R          /* Message Buffer 4 W Register */
#define CAN_1_CS5            CAN_1.MB[5].CS.R              /* Message Buffer 5 CS Register */
#define CAN_1_ID5            CAN_1.MB[5].ID.R              /* Message Buffer 5 ID Register */
#define CAN_1_B5             CAN_1.MB[5].DATA.B.R          /* Message Buffer 5 B Register */
#define CAN_1_H5             CAN_1.MB[5].DATA.H.R          /* Message Buffer 5 H Register */
#define CAN_1_W5             CAN_1.MB[5].DATA.W.R          /* Message Buffer 5 W Register */
#define CAN_1_CS6            CAN_1.MB[6].CS.R              /* Message Buffer 6 CS Register */
#define CAN_1_ID6            CAN_1.MB[6].ID.R              /* Message Buffer 6 ID Register */
#define CAN_1_B6             CAN_1.MB[6].DATA.B.R          /* Message Buffer 6 B Register */
#define CAN_1_H6             CAN_1.MB[6].DATA.H.R          /* Message Buffer 6 H Register */
#define CAN_1_W6             CAN_1.MB[6].DATA.W.R          /* Message Buffer 6 W Register */
#define CAN_1_CS7            CAN_1.MB[7].CS.R              /* Message Buffer 7 CS Register */
#define CAN_1_ID7            CAN_1.MB[7].ID.R              /* Message Buffer 7 ID Register */
#define CAN_1_B7             CAN_1.MB[7].DATA.B.R          /* Message Buffer 7 B Register */
#define CAN_1_H7             CAN_1.MB[7].DATA.H.R          /* Message Buffer 7 H Register */
#define CAN_1_W7             CAN_1.MB[7].DATA.W.R          /* Message Buffer 7 W Register */
#define CAN_1_CS8            CAN_1.MB[8].CS.R              /* Message Buffer 8 CS Register */
#define CAN_1_ID8            CAN_1.MB[8].ID.R              /* Message Buffer 8 ID Register */
#define CAN_1_B8             CAN_1.MB[8].DATA.B.R          /* Message Buffer 8 B Register */
#define CAN_1_H8             CAN_1.MB[8].DATA.H.R          /* Message Buffer 8 H Register */
#define CAN_1_W8             CAN_1.MB[8].DATA.W.R          /* Message Buffer 8 W Register */
#define CAN_1_CS9            CAN_1.MB[9].CS.R              /* Message Buffer 9 CS Register */
#define CAN_1_ID9            CAN_1.MB[9].ID.R              /* Message Buffer 9 ID Register */
#define CAN_1_B9             CAN_1.MB[9].DATA.B.R          /* Message Buffer 9 B Register */
#define CAN_1_H9             CAN_1.MB[9].DATA.H.R          /* Message Buffer 9 H Register */
#define CAN_1_W9             CAN_1.MB[9].DATA.W.R          /* Message Buffer 9 W Register */
#define CAN_1_CS10           CAN_1.MB[10].CS.R             /* Message Buffer 10 CS Register */
#define CAN_1_ID10           CAN_1.MB[10].ID.R             /* Message Buffer 10 ID Register */
#define CAN_1_B10            CAN_1.MB[10].DATA.B.R         /* Message Buffer 10 B Register */
#define CAN_1_H10            CAN_1.MB[10].DATA.H.R         /* Message Buffer 10 H Register */
#define CAN_1_W10            CAN_1.MB[10].DATA.W.R         /* Message Buffer 10 W Register */
#define CAN_1_CS11           CAN_1.MB[11].CS.R             /* Message Buffer 11 CS Register */
#define CAN_1_ID11           CAN_1.MB[11].ID.R             /* Message Buffer 11 ID Register */
#define CAN_1_B11            CAN_1.MB[11].DATA.B.R         /* Message Buffer 11 B Register */
#define CAN_1_H11            CAN_1.MB[11].DATA.H.R         /* Message Buffer 11 H Register */
#define CAN_1_W11            CAN_1.MB[11].DATA.W.R         /* Message Buffer 11 W Register */
#define CAN_1_CS12           CAN_1.MB[12].CS.R             /* Message Buffer 12 CS Register */
#define CAN_1_ID12           CAN_1.MB[12].ID.R             /* Message Buffer 12 ID Register */
#define CAN_1_B12            CAN_1.MB[12].DATA.B.R         /* Message Buffer 12 B Register */
#define CAN_1_H12            CAN_1.MB[12].DATA.H.R         /* Message Buffer 12 H Register */
#define CAN_1_W12            CAN_1.MB[12].DATA.W.R         /* Message Buffer 12 W Register */
#define CAN_1_CS13           CAN_1.MB[13].CS.R             /* Message Buffer 13 CS Register */
#define CAN_1_ID13           CAN_1.MB[13].ID.R             /* Message Buffer 13 ID Register */
#define CAN_1_B13            CAN_1.MB[13].DATA.B.R         /* Message Buffer 13 B Register */
#define CAN_1_H13            CAN_1.MB[13].DATA.H.R         /* Message Buffer 13 H Register */
#define CAN_1_W13            CAN_1.MB[13].DATA.W.R         /* Message Buffer 13 W Register */
#define CAN_1_CS14           CAN_1.MB[14].CS.R             /* Message Buffer 14 CS Register */
#define CAN_1_ID14           CAN_1.MB[14].ID.R             /* Message Buffer 14 ID Register */
#define CAN_1_B14            CAN_1.MB[14].DATA.B.R         /* Message Buffer 14 B Register */
#define CAN_1_H14            CAN_1.MB[14].DATA.H.R         /* Message Buffer 14 H Register */
#define CAN_1_W14            CAN_1.MB[14].DATA.W.R         /* Message Buffer 14 W Register */
#define CAN_1_CS15           CAN_1.MB[15].CS.R             /* Message Buffer 15 CS Register */
#define CAN_1_ID15           CAN_1.MB[15].ID.R             /* Message Buffer 15 ID Register */
#define CAN_1_B15            CAN_1.MB[15].DATA.B.R         /* Message Buffer 15 B Register */
#define CAN_1_H15            CAN_1.MB[15].DATA.H.R         /* Message Buffer 15 H Register */
#define CAN_1_W15            CAN_1.MB[15].DATA.W.R         /* Message Buffer 15 W Register */
#define CAN_1_CS16           CAN_1.MB[16].CS.R             /* Message Buffer 16 CS Register */
#define CAN_1_ID16           CAN_1.MB[16].ID.R             /* Message Buffer 16 ID Register */
#define CAN_1_B16            CAN_1.MB[16].DATA.B.R         /* Message Buffer 16 B Register */
#define CAN_1_H16            CAN_1.MB[16].DATA.H.R         /* Message Buffer 16 H Register */
#define CAN_1_W16            CAN_1.MB[16].DATA.W.R         /* Message Buffer 16 W Register */
#define CAN_1_CS17           CAN_1.MB[17].CS.R             /* Message Buffer 17 CS Register */
#define CAN_1_ID17           CAN_1.MB[17].ID.R             /* Message Buffer 17 ID Register */
#define CAN_1_B17            CAN_1.MB[17].DATA.B.R         /* Message Buffer 17 B Register */
#define CAN_1_H17            CAN_1.MB[17].DATA.H.R         /* Message Buffer 17 H Register */
#define CAN_1_W17            CAN_1.MB[17].DATA.W.R         /* Message Buffer 17 W Register */
#define CAN_1_CS18           CAN_1.MB[18].CS.R             /* Message Buffer 18 CS Register */
#define CAN_1_ID18           CAN_1.MB[18].ID.R             /* Message Buffer 18 ID Register */
#define CAN_1_B18            CAN_1.MB[18].DATA.B.R         /* Message Buffer 18 B Register */
#define CAN_1_H18            CAN_1.MB[18].DATA.H.R         /* Message Buffer 18 H Register */
#define CAN_1_W18            CAN_1.MB[18].DATA.W.R         /* Message Buffer 18 W Register */
#define CAN_1_CS19           CAN_1.MB[19].CS.R             /* Message Buffer 19 CS Register */
#define CAN_1_ID19           CAN_1.MB[19].ID.R             /* Message Buffer 19 ID Register */
#define CAN_1_B19            CAN_1.MB[19].DATA.B.R         /* Message Buffer 19 B Register */
#define CAN_1_H19            CAN_1.MB[19].DATA.H.R         /* Message Buffer 19 H Register */
#define CAN_1_W19            CAN_1.MB[19].DATA.W.R         /* Message Buffer 19 W Register */
#define CAN_1_CS20           CAN_1.MB[20].CS.R             /* Message Buffer 20 CS Register */
#define CAN_1_ID20           CAN_1.MB[20].ID.R             /* Message Buffer 20 ID Register */
#define CAN_1_B20            CAN_1.MB[20].DATA.B.R         /* Message Buffer 20 B Register */
#define CAN_1_H20            CAN_1.MB[20].DATA.H.R         /* Message Buffer 20 H Register */
#define CAN_1_W20            CAN_1.MB[20].DATA.W.R         /* Message Buffer 20 W Register */
#define CAN_1_CS21           CAN_1.MB[21].CS.R             /* Message Buffer 21 CS Register */
#define CAN_1_ID21           CAN_1.MB[21].ID.R             /* Message Buffer 21 ID Register */
#define CAN_1_B21            CAN_1.MB[21].DATA.B.R         /* Message Buffer 21 B Register */
#define CAN_1_H21            CAN_1.MB[21].DATA.H.R         /* Message Buffer 21 H Register */
#define CAN_1_W21            CAN_1.MB[21].DATA.W.R         /* Message Buffer 21 W Register */
#define CAN_1_CS22           CAN_1.MB[22].CS.R             /* Message Buffer 22 CS Register */
#define CAN_1_ID22           CAN_1.MB[22].ID.R             /* Message Buffer 22 ID Register */
#define CAN_1_B22            CAN_1.MB[22].DATA.B.R         /* Message Buffer 22 B Register */
#define CAN_1_H22            CAN_1.MB[22].DATA.H.R         /* Message Buffer 22 H Register */
#define CAN_1_W22            CAN_1.MB[22].DATA.W.R         /* Message Buffer 22 W Register */
#define CAN_1_CS23           CAN_1.MB[23].CS.R             /* Message Buffer 23 CS Register */
#define CAN_1_ID23           CAN_1.MB[23].ID.R             /* Message Buffer 23 ID Register */
#define CAN_1_B23            CAN_1.MB[23].DATA.B.R         /* Message Buffer 23 B Register */
#define CAN_1_H23            CAN_1.MB[23].DATA.H.R         /* Message Buffer 23 H Register */
#define CAN_1_W23            CAN_1.MB[23].DATA.W.R         /* Message Buffer 23 W Register */
#define CAN_1_CS24           CAN_1.MB[24].CS.R             /* Message Buffer 24 CS Register */
#define CAN_1_ID24           CAN_1.MB[24].ID.R             /* Message Buffer 24 ID Register */
#define CAN_1_B24            CAN_1.MB[24].DATA.B.R         /* Message Buffer 24 B Register */
#define CAN_1_H24            CAN_1.MB[24].DATA.H.R         /* Message Buffer 24 H Register */
#define CAN_1_W24            CAN_1.MB[24].DATA.W.R         /* Message Buffer 24 W Register */
#define CAN_1_CS25           CAN_1.MB[25].CS.R             /* Message Buffer 25 CS Register */
#define CAN_1_ID25           CAN_1.MB[25].ID.R             /* Message Buffer 25 ID Register */
#define CAN_1_B25            CAN_1.MB[25].DATA.B.R         /* Message Buffer 25 B Register */
#define CAN_1_H25            CAN_1.MB[25].DATA.H.R         /* Message Buffer 25 H Register */
#define CAN_1_W25            CAN_1.MB[25].DATA.W.R         /* Message Buffer 25 W Register */
#define CAN_1_CS26           CAN_1.MB[26].CS.R             /* Message Buffer 26 CS Register */
#define CAN_1_ID26           CAN_1.MB[26].ID.R             /* Message Buffer 26 ID Register */
#define CAN_1_B26            CAN_1.MB[26].DATA.B.R         /* Message Buffer 26 B Register */
#define CAN_1_H26            CAN_1.MB[26].DATA.H.R         /* Message Buffer 26 H Register */
#define CAN_1_W26            CAN_1.MB[26].DATA.W.R         /* Message Buffer 26 W Register */
#define CAN_1_CS27           CAN_1.MB[27].CS.R             /* Message Buffer 27 CS Register */
#define CAN_1_ID27           CAN_1.MB[27].ID.R             /* Message Buffer 27 ID Register */
#define CAN_1_B27            CAN_1.MB[27].DATA.B.R         /* Message Buffer 27 B Register */
#define CAN_1_H27            CAN_1.MB[27].DATA.H.R         /* Message Buffer 27 H Register */
#define CAN_1_W27            CAN_1.MB[27].DATA.W.R         /* Message Buffer 27 W Register */
#define CAN_1_CS28           CAN_1.MB[28].CS.R             /* Message Buffer 28 CS Register */
#define CAN_1_ID28           CAN_1.MB[28].ID.R             /* Message Buffer 28 ID Register */
#define CAN_1_B28            CAN_1.MB[28].DATA.B.R         /* Message Buffer 28 B Register */
#define CAN_1_H28            CAN_1.MB[28].DATA.H.R         /* Message Buffer 28 H Register */
#define CAN_1_W28            CAN_1.MB[28].DATA.W.R         /* Message Buffer 28 W Register */
#define CAN_1_CS29           CAN_1.MB[29].CS.R             /* Message Buffer 29 CS Register */
#define CAN_1_ID29           CAN_1.MB[29].ID.R             /* Message Buffer 29 ID Register */
#define CAN_1_B29            CAN_1.MB[29].DATA.B.R         /* Message Buffer 29 B Register */
#define CAN_1_H29            CAN_1.MB[29].DATA.H.R         /* Message Buffer 29 H Register */
#define CAN_1_W29            CAN_1.MB[29].DATA.W.R         /* Message Buffer 29 W Register */
#define CAN_1_CS30           CAN_1.MB[30].CS.R             /* Message Buffer 30 CS Register */
#define CAN_1_ID30           CAN_1.MB[30].ID.R             /* Message Buffer 30 ID Register */
#define CAN_1_B30            CAN_1.MB[30].DATA.B.R         /* Message Buffer 30 B Register */
#define CAN_1_H30            CAN_1.MB[30].DATA.H.R         /* Message Buffer 30 H Register */
#define CAN_1_W30            CAN_1.MB[30].DATA.W.R         /* Message Buffer 30 W Register */
#define CAN_1_CS31           CAN_1.MB[31].CS.R             /* Message Buffer 31 CS Register */
#define CAN_1_ID31           CAN_1.MB[31].ID.R             /* Message Buffer 31 ID Register */
#define CAN_1_B31            CAN_1.MB[31].DATA.B.R         /* Message Buffer 31 B Register */
#define CAN_1_H31            CAN_1.MB[31].DATA.H.R         /* Message Buffer 31 H Register */
#define CAN_1_W31            CAN_1.MB[31].DATA.W.R         /* Message Buffer 31 W Register */
#define CAN_1_CS32           CAN_1.MB[32].CS.R             /* Message Buffer 32 CS Register */
#define CAN_1_ID32           CAN_1.MB[32].ID.R             /* Message Buffer 32 ID Register */
#define CAN_1_B32            CAN_1.MB[32].DATA.B.R         /* Message Buffer 32 B Register */
#define CAN_1_H32            CAN_1.MB[32].DATA.H.R         /* Message Buffer 32 H Register */
#define CAN_1_W32            CAN_1.MB[32].DATA.W.R         /* Message Buffer 32 W Register */
#define CAN_1_CS33           CAN_1.MB[33].CS.R             /* Message Buffer 33 CS Register */
#define CAN_1_ID33           CAN_1.MB[33].ID.R             /* Message Buffer 33 ID Register */
#define CAN_1_B33            CAN_1.MB[33].DATA.B.R         /* Message Buffer 33 B Register */
#define CAN_1_H33            CAN_1.MB[33].DATA.H.R         /* Message Buffer 33 H Register */
#define CAN_1_W33            CAN_1.MB[33].DATA.W.R         /* Message Buffer 33 W Register */
#define CAN_1_CS34           CAN_1.MB[34].CS.R             /* Message Buffer 34 CS Register */
#define CAN_1_ID34           CAN_1.MB[34].ID.R             /* Message Buffer 34 ID Register */
#define CAN_1_B34            CAN_1.MB[34].DATA.B.R         /* Message Buffer 34 B Register */
#define CAN_1_H34            CAN_1.MB[34].DATA.H.R         /* Message Buffer 34 H Register */
#define CAN_1_W34            CAN_1.MB[34].DATA.W.R         /* Message Buffer 34 W Register */
#define CAN_1_CS35           CAN_1.MB[35].CS.R             /* Message Buffer 35 CS Register */
#define CAN_1_ID35           CAN_1.MB[35].ID.R             /* Message Buffer 35 ID Register */
#define CAN_1_B35            CAN_1.MB[35].DATA.B.R         /* Message Buffer 35 B Register */
#define CAN_1_H35            CAN_1.MB[35].DATA.H.R         /* Message Buffer 35 H Register */
#define CAN_1_W35            CAN_1.MB[35].DATA.W.R         /* Message Buffer 35 W Register */
#define CAN_1_CS36           CAN_1.MB[36].CS.R             /* Message Buffer 36 CS Register */
#define CAN_1_ID36           CAN_1.MB[36].ID.R             /* Message Buffer 36 ID Register */
#define CAN_1_B36            CAN_1.MB[36].DATA.B.R         /* Message Buffer 36 B Register */
#define CAN_1_H36            CAN_1.MB[36].DATA.H.R         /* Message Buffer 36 H Register */
#define CAN_1_W36            CAN_1.MB[36].DATA.W.R         /* Message Buffer 36 W Register */
#define CAN_1_CS37           CAN_1.MB[37].CS.R             /* Message Buffer 37 CS Register */
#define CAN_1_ID37           CAN_1.MB[37].ID.R             /* Message Buffer 37 ID Register */
#define CAN_1_B37            CAN_1.MB[37].DATA.B.R         /* Message Buffer 37 B Register */
#define CAN_1_H37            CAN_1.MB[37].DATA.H.R         /* Message Buffer 37 H Register */
#define CAN_1_W37            CAN_1.MB[37].DATA.W.R         /* Message Buffer 37 W Register */
#define CAN_1_CS38           CAN_1.MB[38].CS.R             /* Message Buffer 38 CS Register */
#define CAN_1_ID38           CAN_1.MB[38].ID.R             /* Message Buffer 38 ID Register */
#define CAN_1_B38            CAN_1.MB[38].DATA.B.R         /* Message Buffer 38 B Register */
#define CAN_1_H38            CAN_1.MB[38].DATA.H.R         /* Message Buffer 38 H Register */
#define CAN_1_W38            CAN_1.MB[38].DATA.W.R         /* Message Buffer 38 W Register */
#define CAN_1_CS39           CAN_1.MB[39].CS.R             /* Message Buffer 39 CS Register */
#define CAN_1_ID39           CAN_1.MB[39].ID.R             /* Message Buffer 39 ID Register */
#define CAN_1_B39            CAN_1.MB[39].DATA.B.R         /* Message Buffer 39 B Register */
#define CAN_1_H39            CAN_1.MB[39].DATA.H.R         /* Message Buffer 39 H Register */
#define CAN_1_W39            CAN_1.MB[39].DATA.W.R         /* Message Buffer 39 W Register */
#define CAN_1_CS40           CAN_1.MB[40].CS.R             /* Message Buffer 40 CS Register */
#define CAN_1_ID40           CAN_1.MB[40].ID.R             /* Message Buffer 40 ID Register */
#define CAN_1_B40            CAN_1.MB[40].DATA.B.R         /* Message Buffer 40 B Register */
#define CAN_1_H40            CAN_1.MB[40].DATA.H.R         /* Message Buffer 40 H Register */
#define CAN_1_W40            CAN_1.MB[40].DATA.W.R         /* Message Buffer 40 W Register */
#define CAN_1_CS41           CAN_1.MB[41].CS.R             /* Message Buffer 41 CS Register */
#define CAN_1_ID41           CAN_1.MB[41].ID.R             /* Message Buffer 41 ID Register */
#define CAN_1_B41            CAN_1.MB[41].DATA.B.R         /* Message Buffer 41 B Register */
#define CAN_1_H41            CAN_1.MB[41].DATA.H.R         /* Message Buffer 41 H Register */
#define CAN_1_W41            CAN_1.MB[41].DATA.W.R         /* Message Buffer 41 W Register */
#define CAN_1_CS42           CAN_1.MB[42].CS.R             /* Message Buffer 42 CS Register */
#define CAN_1_ID42           CAN_1.MB[42].ID.R             /* Message Buffer 42 ID Register */
#define CAN_1_B42            CAN_1.MB[42].DATA.B.R         /* Message Buffer 42 B Register */
#define CAN_1_H42            CAN_1.MB[42].DATA.H.R         /* Message Buffer 42 H Register */
#define CAN_1_W42            CAN_1.MB[42].DATA.W.R         /* Message Buffer 42 W Register */
#define CAN_1_CS43           CAN_1.MB[43].CS.R             /* Message Buffer 43 CS Register */
#define CAN_1_ID43           CAN_1.MB[43].ID.R             /* Message Buffer 43 ID Register */
#define CAN_1_B43            CAN_1.MB[43].DATA.B.R         /* Message Buffer 43 B Register */
#define CAN_1_H43            CAN_1.MB[43].DATA.H.R         /* Message Buffer 43 H Register */
#define CAN_1_W43            CAN_1.MB[43].DATA.W.R         /* Message Buffer 43 W Register */
#define CAN_1_CS44           CAN_1.MB[44].CS.R             /* Message Buffer 44 CS Register */
#define CAN_1_ID44           CAN_1.MB[44].ID.R             /* Message Buffer 44 ID Register */
#define CAN_1_B44            CAN_1.MB[44].DATA.B.R         /* Message Buffer 44 B Register */
#define CAN_1_H44            CAN_1.MB[44].DATA.H.R         /* Message Buffer 44 H Register */
#define CAN_1_W44            CAN_1.MB[44].DATA.W.R         /* Message Buffer 44 W Register */
#define CAN_1_CS45           CAN_1.MB[45].CS.R             /* Message Buffer 45 CS Register */
#define CAN_1_ID45           CAN_1.MB[45].ID.R             /* Message Buffer 45 ID Register */
#define CAN_1_B45            CAN_1.MB[45].DATA.B.R         /* Message Buffer 45 B Register */
#define CAN_1_H45            CAN_1.MB[45].DATA.H.R         /* Message Buffer 45 H Register */
#define CAN_1_W45            CAN_1.MB[45].DATA.W.R         /* Message Buffer 45 W Register */
#define CAN_1_CS46           CAN_1.MB[46].CS.R             /* Message Buffer 46 CS Register */
#define CAN_1_ID46           CAN_1.MB[46].ID.R             /* Message Buffer 46 ID Register */
#define CAN_1_B46            CAN_1.MB[46].DATA.B.R         /* Message Buffer 46 B Register */
#define CAN_1_H46            CAN_1.MB[46].DATA.H.R         /* Message Buffer 46 H Register */
#define CAN_1_W46            CAN_1.MB[46].DATA.W.R         /* Message Buffer 46 W Register */
#define CAN_1_CS47           CAN_1.MB[47].CS.R             /* Message Buffer 47 CS Register */
#define CAN_1_ID47           CAN_1.MB[47].ID.R             /* Message Buffer 47 ID Register */
#define CAN_1_B47            CAN_1.MB[47].DATA.B.R         /* Message Buffer 47 B Register */
#define CAN_1_H47            CAN_1.MB[47].DATA.H.R         /* Message Buffer 47 H Register */
#define CAN_1_W47            CAN_1.MB[47].DATA.W.R         /* Message Buffer 47 W Register */
#define CAN_1_CS48           CAN_1.MB[48].CS.R             /* Message Buffer 48 CS Register */
#define CAN_1_ID48           CAN_1.MB[48].ID.R             /* Message Buffer 48 ID Register */
#define CAN_1_B48            CAN_1.MB[48].DATA.B.R         /* Message Buffer 48 B Register */
#define CAN_1_H48            CAN_1.MB[48].DATA.H.R         /* Message Buffer 48 H Register */
#define CAN_1_W48            CAN_1.MB[48].DATA.W.R         /* Message Buffer 48 W Register */
#define CAN_1_CS49           CAN_1.MB[49].CS.R             /* Message Buffer 49 CS Register */
#define CAN_1_ID49           CAN_1.MB[49].ID.R             /* Message Buffer 49 ID Register */
#define CAN_1_B49            CAN_1.MB[49].DATA.B.R         /* Message Buffer 49 B Register */
#define CAN_1_H49            CAN_1.MB[49].DATA.H.R         /* Message Buffer 49 H Register */
#define CAN_1_W49            CAN_1.MB[49].DATA.W.R         /* Message Buffer 49 W Register */
#define CAN_1_CS50           CAN_1.MB[50].CS.R             /* Message Buffer 50 CS Register */
#define CAN_1_ID50           CAN_1.MB[50].ID.R             /* Message Buffer 50 ID Register */
#define CAN_1_B50            CAN_1.MB[50].DATA.B.R         /* Message Buffer 50 B Register */
#define CAN_1_H50            CAN_1.MB[50].DATA.H.R         /* Message Buffer 50 H Register */
#define CAN_1_W50            CAN_1.MB[50].DATA.W.R         /* Message Buffer 50 W Register */
#define CAN_1_CS51           CAN_1.MB[51].CS.R             /* Message Buffer 51 CS Register */
#define CAN_1_ID51           CAN_1.MB[51].ID.R             /* Message Buffer 51 ID Register */
#define CAN_1_B51            CAN_1.MB[51].DATA.B.R         /* Message Buffer 51 B Register */
#define CAN_1_H51            CAN_1.MB[51].DATA.H.R         /* Message Buffer 51 H Register */
#define CAN_1_W51            CAN_1.MB[51].DATA.W.R         /* Message Buffer 51 W Register */
#define CAN_1_CS52           CAN_1.MB[52].CS.R             /* Message Buffer 52 CS Register */
#define CAN_1_ID52           CAN_1.MB[52].ID.R             /* Message Buffer 52 ID Register */
#define CAN_1_B52            CAN_1.MB[52].DATA.B.R         /* Message Buffer 52 B Register */
#define CAN_1_H52            CAN_1.MB[52].DATA.H.R         /* Message Buffer 52 H Register */
#define CAN_1_W52            CAN_1.MB[52].DATA.W.R         /* Message Buffer 52 W Register */
#define CAN_1_CS53           CAN_1.MB[53].CS.R             /* Message Buffer 53 CS Register */
#define CAN_1_ID53           CAN_1.MB[53].ID.R             /* Message Buffer 53 ID Register */
#define CAN_1_B53            CAN_1.MB[53].DATA.B.R         /* Message Buffer 53 B Register */
#define CAN_1_H53            CAN_1.MB[53].DATA.H.R         /* Message Buffer 53 H Register */
#define CAN_1_W53            CAN_1.MB[53].DATA.W.R         /* Message Buffer 53 W Register */
#define CAN_1_CS54           CAN_1.MB[54].CS.R             /* Message Buffer 54 CS Register */
#define CAN_1_ID54           CAN_1.MB[54].ID.R             /* Message Buffer 54 ID Register */
#define CAN_1_B54            CAN_1.MB[54].DATA.B.R         /* Message Buffer 54 B Register */
#define CAN_1_H54            CAN_1.MB[54].DATA.H.R         /* Message Buffer 54 H Register */
#define CAN_1_W54            CAN_1.MB[54].DATA.W.R         /* Message Buffer 54 W Register */
#define CAN_1_CS55           CAN_1.MB[55].CS.R             /* Message Buffer 55 CS Register */
#define CAN_1_ID55           CAN_1.MB[55].ID.R             /* Message Buffer 55 ID Register */
#define CAN_1_B55            CAN_1.MB[55].DATA.B.R         /* Message Buffer 55 B Register */
#define CAN_1_H55            CAN_1.MB[55].DATA.H.R         /* Message Buffer 55 H Register */
#define CAN_1_W55            CAN_1.MB[55].DATA.W.R         /* Message Buffer 55 W Register */
#define CAN_1_CS56           CAN_1.MB[56].CS.R             /* Message Buffer 56 CS Register */
#define CAN_1_ID56           CAN_1.MB[56].ID.R             /* Message Buffer 56 ID Register */
#define CAN_1_B56            CAN_1.MB[56].DATA.B.R         /* Message Buffer 56 B Register */
#define CAN_1_H56            CAN_1.MB[56].DATA.H.R         /* Message Buffer 56 H Register */
#define CAN_1_W56            CAN_1.MB[56].DATA.W.R         /* Message Buffer 56 W Register */
#define CAN_1_CS57           CAN_1.MB[57].CS.R             /* Message Buffer 57 CS Register */
#define CAN_1_ID57           CAN_1.MB[57].ID.R             /* Message Buffer 57 ID Register */
#define CAN_1_B57            CAN_1.MB[57].DATA.B.R         /* Message Buffer 57 B Register */
#define CAN_1_H57            CAN_1.MB[57].DATA.H.R         /* Message Buffer 57 H Register */
#define CAN_1_W57            CAN_1.MB[57].DATA.W.R         /* Message Buffer 57 W Register */
#define CAN_1_CS58           CAN_1.MB[58].CS.R             /* Message Buffer 58 CS Register */
#define CAN_1_ID58           CAN_1.MB[58].ID.R             /* Message Buffer 58 ID Register */
#define CAN_1_B58            CAN_1.MB[58].DATA.B.R         /* Message Buffer 58 B Register */
#define CAN_1_H58            CAN_1.MB[58].DATA.H.R         /* Message Buffer 58 H Register */
#define CAN_1_W58            CAN_1.MB[58].DATA.W.R         /* Message Buffer 58 W Register */
#define CAN_1_CS59           CAN_1.MB[59].CS.R             /* Message Buffer 59 CS Register */
#define CAN_1_ID59           CAN_1.MB[59].ID.R             /* Message Buffer 59 ID Register */
#define CAN_1_B59            CAN_1.MB[59].DATA.B.R         /* Message Buffer 59 B Register */
#define CAN_1_H59            CAN_1.MB[59].DATA.H.R         /* Message Buffer 59 H Register */
#define CAN_1_W59            CAN_1.MB[59].DATA.W.R         /* Message Buffer 59 W Register */
#define CAN_1_CS60           CAN_1.MB[60].CS.R             /* Message Buffer 60 CS Register */
#define CAN_1_ID60           CAN_1.MB[60].ID.R             /* Message Buffer 60 ID Register */
#define CAN_1_B60            CAN_1.MB[60].DATA.B.R         /* Message Buffer 60 B Register */
#define CAN_1_H60            CAN_1.MB[60].DATA.H.R         /* Message Buffer 60 H Register */
#define CAN_1_W60            CAN_1.MB[60].DATA.W.R         /* Message Buffer 60 W Register */
#define CAN_1_CS61           CAN_1.MB[61].CS.R             /* Message Buffer 61 CS Register */
#define CAN_1_ID61           CAN_1.MB[61].ID.R             /* Message Buffer 61 ID Register */
#define CAN_1_B61            CAN_1.MB[61].DATA.B.R         /* Message Buffer 61 B Register */
#define CAN_1_H61            CAN_1.MB[61].DATA.H.R         /* Message Buffer 61 H Register */
#define CAN_1_W61            CAN_1.MB[61].DATA.W.R         /* Message Buffer 61 W Register */
#define CAN_1_CS62           CAN_1.MB[62].CS.R             /* Message Buffer 62 CS Register */
#define CAN_1_ID62           CAN_1.MB[62].ID.R             /* Message Buffer 62 ID Register */
#define CAN_1_B62            CAN_1.MB[62].DATA.B.R         /* Message Buffer 62 B Register */
#define CAN_1_H62            CAN_1.MB[62].DATA.H.R         /* Message Buffer 62 H Register */
#define CAN_1_W62            CAN_1.MB[62].DATA.W.R         /* Message Buffer 62 W Register */
#define CAN_1_CS63           CAN_1.MB[63].CS.R             /* Message Buffer 63 CS Register */
#define CAN_1_ID63           CAN_1.MB[63].ID.R             /* Message Buffer 63 ID Register */
#define CAN_1_B63            CAN_1.MB[63].DATA.B.R         /* Message Buffer 63 B Register */
#define CAN_1_H63            CAN_1.MB[63].DATA.H.R         /* Message Buffer 63 H Register */
#define CAN_1_W63            CAN_1.MB[63].DATA.W.R         /* Message Buffer 63 W Register */
#define CAN_1_RXIMR0         CAN_1.RXIMR[0].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR1         CAN_1.RXIMR[1].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR2         CAN_1.RXIMR[2].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR3         CAN_1.RXIMR[3].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR4         CAN_1.RXIMR[4].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR5         CAN_1.RXIMR[5].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR6         CAN_1.RXIMR[6].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR7         CAN_1.RXIMR[7].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR8         CAN_1.RXIMR[8].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR9         CAN_1.RXIMR[9].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR10        CAN_1.RXIMR[10].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR11        CAN_1.RXIMR[11].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR12        CAN_1.RXIMR[12].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR13        CAN_1.RXIMR[13].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR14        CAN_1.RXIMR[14].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR15        CAN_1.RXIMR[15].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR16        CAN_1.RXIMR[16].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR17        CAN_1.RXIMR[17].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR18        CAN_1.RXIMR[18].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR19        CAN_1.RXIMR[19].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR20        CAN_1.RXIMR[20].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR21        CAN_1.RXIMR[21].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR22        CAN_1.RXIMR[22].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR23        CAN_1.RXIMR[23].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR24        CAN_1.RXIMR[24].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR25        CAN_1.RXIMR[25].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR26        CAN_1.RXIMR[26].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR27        CAN_1.RXIMR[27].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR28        CAN_1.RXIMR[28].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR29        CAN_1.RXIMR[29].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR30        CAN_1.RXIMR[30].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR31        CAN_1.RXIMR[31].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR32        CAN_1.RXIMR[32].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR33        CAN_1.RXIMR[33].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR34        CAN_1.RXIMR[34].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR35        CAN_1.RXIMR[35].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR36        CAN_1.RXIMR[36].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR37        CAN_1.RXIMR[37].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR38        CAN_1.RXIMR[38].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR39        CAN_1.RXIMR[39].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR40        CAN_1.RXIMR[40].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR41        CAN_1.RXIMR[41].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR42        CAN_1.RXIMR[42].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR43        CAN_1.RXIMR[43].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR44        CAN_1.RXIMR[44].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR45        CAN_1.RXIMR[45].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR46        CAN_1.RXIMR[46].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR47        CAN_1.RXIMR[47].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR48        CAN_1.RXIMR[48].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR49        CAN_1.RXIMR[49].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR50        CAN_1.RXIMR[50].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR51        CAN_1.RXIMR[51].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR52        CAN_1.RXIMR[52].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR53        CAN_1.RXIMR[53].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR54        CAN_1.RXIMR[54].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR55        CAN_1.RXIMR[55].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR56        CAN_1.RXIMR[56].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR57        CAN_1.RXIMR[57].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR58        CAN_1.RXIMR[58].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR59        CAN_1.RXIMR[59].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR60        CAN_1.RXIMR[60].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR61        CAN_1.RXIMR[61].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR62        CAN_1.RXIMR[62].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR63        CAN_1.RXIMR[63].R             /* Rx Individual Mask Registers */
#define CAN_1_MECR           CAN_1.MECR.R                  /* Memory Error Control Register */
#define CAN_1_ERRIAR         CAN_1.ERRIAR.R                /* Error Injection Address Register */
#define CAN_1_ERRIDPR        CAN_1.ERRIDPR.R               /* Error Injection Data Pattern Register */
#define CAN_1_ERRIPPR        CAN_1.ERRIPPR.R               /* Error Injection Parity Pattern Register */
#define CAN_1_RERRAR         CAN_1.RERRAR.R                /* Error Report Address Register */
#define CAN_1_RERRDR         CAN_1.RERRDR.R                /* Error Report Data Register */
#define CAN_1_RERRSYNR       CAN_1.RERRSYNR.R              /* Error Report Syndrome Register */
#define CAN_1_ERRSR          CAN_1.ERRSR.R                 /* Error Status Register */

/* CAN */
#define CAN_2_MCR            CAN_2.MCR.R                   /* Module Configuration Register */
#define CAN_2_CTRL1          CAN_2.CTRL1.R                 /* Control 1 register */
#define CAN_2_TIMER          CAN_2.TIMER.R                 /* Free Running Timer */
#define CAN_2_RXMGMASK       CAN_2.RXMGMASK.R              /* Rx Mailboxes Global Mask Register */
#define CAN_2_RX14MASK       CAN_2.RX14MASK.R              /* Rx 14 Mask register */
#define CAN_2_RX15MASK       CAN_2.RX15MASK.R              /* Rx 15 Mask register */
#define CAN_2_ECR            CAN_2.ECR.R                   /* Error Counter */
#define CAN_2_ESR1           CAN_2.ESR1.R                  /* Error and Status 1 register */
#define CAN_2_IMASK2         CAN_2.IMASK2.R                /* Interrupt Masks 2 register */
#define CAN_2_IMASK1         CAN_2.IMASK1.R                /* Interrupt Masks 1 register */
#define CAN_2_IFLAG2         CAN_2.IFLAG2.R                /* Interrupt Flags 2 register */
#define CAN_2_IFLAG1         CAN_2.IFLAG1.R                /* Interrupt Flags 1 register */
#define CAN_2_CTRL2          CAN_2.CTRL2.R                 /* Control 2 register */
#define CAN_2_ESR2           CAN_2.ESR2.R                  /* Error and Status 2 register */
#define CAN_2_CRCR           CAN_2.CRCR.R                  /* CRC Register */
#define CAN_2_RXFGMASK       CAN_2.RXFGMASK.R              /* Rx FIFO Global Mask register */
#define CAN_2_RXFIR          CAN_2.RXFIR.R                 /* Rx FIFO Information Register */
#define CAN_2_CS0            CAN_2.MB[0].CS.R              /* Message Buffer 0 CS Register */
#define CAN_2_ID0            CAN_2.MB[0].ID.R              /* Message Buffer 0 ID Register */
#define CAN_2_B0             CAN_2.MB[0].DATA.B.R          /* Message Buffer 0 B Register */
#define CAN_2_H0             CAN_2.MB[0].DATA.H.R          /* Message Buffer 0 H Register */
#define CAN_2_W0             CAN_2.MB[0].DATA.W.R          /* Message Buffer 0 W Register */
#define CAN_2_CS1            CAN_2.MB[1].CS.R              /* Message Buffer 1 CS Register */
#define CAN_2_ID1            CAN_2.MB[1].ID.R              /* Message Buffer 1 ID Register */
#define CAN_2_B1             CAN_2.MB[1].DATA.B.R          /* Message Buffer 1 B Register */
#define CAN_2_H1             CAN_2.MB[1].DATA.H.R          /* Message Buffer 1 H Register */
#define CAN_2_W1             CAN_2.MB[1].DATA.W.R          /* Message Buffer 1 W Register */
#define CAN_2_CS2            CAN_2.MB[2].CS.R              /* Message Buffer 2 CS Register */
#define CAN_2_ID2            CAN_2.MB[2].ID.R              /* Message Buffer 2 ID Register */
#define CAN_2_B2             CAN_2.MB[2].DATA.B.R          /* Message Buffer 2 B Register */
#define CAN_2_H2             CAN_2.MB[2].DATA.H.R          /* Message Buffer 2 H Register */
#define CAN_2_W2             CAN_2.MB[2].DATA.W.R          /* Message Buffer 2 W Register */
#define CAN_2_CS3            CAN_2.MB[3].CS.R              /* Message Buffer 3 CS Register */
#define CAN_2_ID3            CAN_2.MB[3].ID.R              /* Message Buffer 3 ID Register */
#define CAN_2_B3             CAN_2.MB[3].DATA.B.R          /* Message Buffer 3 B Register */
#define CAN_2_H3             CAN_2.MB[3].DATA.H.R          /* Message Buffer 3 H Register */
#define CAN_2_W3             CAN_2.MB[3].DATA.W.R          /* Message Buffer 3 W Register */
#define CAN_2_CS4            CAN_2.MB[4].CS.R              /* Message Buffer 4 CS Register */
#define CAN_2_ID4            CAN_2.MB[4].ID.R              /* Message Buffer 4 ID Register */
#define CAN_2_B4             CAN_2.MB[4].DATA.B.R          /* Message Buffer 4 B Register */
#define CAN_2_H4             CAN_2.MB[4].DATA.H.R          /* Message Buffer 4 H Register */
#define CAN_2_W4             CAN_2.MB[4].DATA.W.R          /* Message Buffer 4 W Register */
#define CAN_2_CS5            CAN_2.MB[5].CS.R              /* Message Buffer 5 CS Register */
#define CAN_2_ID5            CAN_2.MB[5].ID.R              /* Message Buffer 5 ID Register */
#define CAN_2_B5             CAN_2.MB[5].DATA.B.R          /* Message Buffer 5 B Register */
#define CAN_2_H5             CAN_2.MB[5].DATA.H.R          /* Message Buffer 5 H Register */
#define CAN_2_W5             CAN_2.MB[5].DATA.W.R          /* Message Buffer 5 W Register */
#define CAN_2_CS6            CAN_2.MB[6].CS.R              /* Message Buffer 6 CS Register */
#define CAN_2_ID6            CAN_2.MB[6].ID.R              /* Message Buffer 6 ID Register */
#define CAN_2_B6             CAN_2.MB[6].DATA.B.R          /* Message Buffer 6 B Register */
#define CAN_2_H6             CAN_2.MB[6].DATA.H.R          /* Message Buffer 6 H Register */
#define CAN_2_W6             CAN_2.MB[6].DATA.W.R          /* Message Buffer 6 W Register */
#define CAN_2_CS7            CAN_2.MB[7].CS.R              /* Message Buffer 7 CS Register */
#define CAN_2_ID7            CAN_2.MB[7].ID.R              /* Message Buffer 7 ID Register */
#define CAN_2_B7             CAN_2.MB[7].DATA.B.R          /* Message Buffer 7 B Register */
#define CAN_2_H7             CAN_2.MB[7].DATA.H.R          /* Message Buffer 7 H Register */
#define CAN_2_W7             CAN_2.MB[7].DATA.W.R          /* Message Buffer 7 W Register */
#define CAN_2_CS8            CAN_2.MB[8].CS.R              /* Message Buffer 8 CS Register */
#define CAN_2_ID8            CAN_2.MB[8].ID.R              /* Message Buffer 8 ID Register */
#define CAN_2_B8             CAN_2.MB[8].DATA.B.R          /* Message Buffer 8 B Register */
#define CAN_2_H8             CAN_2.MB[8].DATA.H.R          /* Message Buffer 8 H Register */
#define CAN_2_W8             CAN_2.MB[8].DATA.W.R          /* Message Buffer 8 W Register */
#define CAN_2_CS9            CAN_2.MB[9].CS.R              /* Message Buffer 9 CS Register */
#define CAN_2_ID9            CAN_2.MB[9].ID.R              /* Message Buffer 9 ID Register */
#define CAN_2_B9             CAN_2.MB[9].DATA.B.R          /* Message Buffer 9 B Register */
#define CAN_2_H9             CAN_2.MB[9].DATA.H.R          /* Message Buffer 9 H Register */
#define CAN_2_W9             CAN_2.MB[9].DATA.W.R          /* Message Buffer 9 W Register */
#define CAN_2_CS10           CAN_2.MB[10].CS.R             /* Message Buffer 10 CS Register */
#define CAN_2_ID10           CAN_2.MB[10].ID.R             /* Message Buffer 10 ID Register */
#define CAN_2_B10            CAN_2.MB[10].DATA.B.R         /* Message Buffer 10 B Register */
#define CAN_2_H10            CAN_2.MB[10].DATA.H.R         /* Message Buffer 10 H Register */
#define CAN_2_W10            CAN_2.MB[10].DATA.W.R         /* Message Buffer 10 W Register */
#define CAN_2_CS11           CAN_2.MB[11].CS.R             /* Message Buffer 11 CS Register */
#define CAN_2_ID11           CAN_2.MB[11].ID.R             /* Message Buffer 11 ID Register */
#define CAN_2_B11            CAN_2.MB[11].DATA.B.R         /* Message Buffer 11 B Register */
#define CAN_2_H11            CAN_2.MB[11].DATA.H.R         /* Message Buffer 11 H Register */
#define CAN_2_W11            CAN_2.MB[11].DATA.W.R         /* Message Buffer 11 W Register */
#define CAN_2_CS12           CAN_2.MB[12].CS.R             /* Message Buffer 12 CS Register */
#define CAN_2_ID12           CAN_2.MB[12].ID.R             /* Message Buffer 12 ID Register */
#define CAN_2_B12            CAN_2.MB[12].DATA.B.R         /* Message Buffer 12 B Register */
#define CAN_2_H12            CAN_2.MB[12].DATA.H.R         /* Message Buffer 12 H Register */
#define CAN_2_W12            CAN_2.MB[12].DATA.W.R         /* Message Buffer 12 W Register */
#define CAN_2_CS13           CAN_2.MB[13].CS.R             /* Message Buffer 13 CS Register */
#define CAN_2_ID13           CAN_2.MB[13].ID.R             /* Message Buffer 13 ID Register */
#define CAN_2_B13            CAN_2.MB[13].DATA.B.R         /* Message Buffer 13 B Register */
#define CAN_2_H13            CAN_2.MB[13].DATA.H.R         /* Message Buffer 13 H Register */
#define CAN_2_W13            CAN_2.MB[13].DATA.W.R         /* Message Buffer 13 W Register */
#define CAN_2_CS14           CAN_2.MB[14].CS.R             /* Message Buffer 14 CS Register */
#define CAN_2_ID14           CAN_2.MB[14].ID.R             /* Message Buffer 14 ID Register */
#define CAN_2_B14            CAN_2.MB[14].DATA.B.R         /* Message Buffer 14 B Register */
#define CAN_2_H14            CAN_2.MB[14].DATA.H.R         /* Message Buffer 14 H Register */
#define CAN_2_W14            CAN_2.MB[14].DATA.W.R         /* Message Buffer 14 W Register */
#define CAN_2_CS15           CAN_2.MB[15].CS.R             /* Message Buffer 15 CS Register */
#define CAN_2_ID15           CAN_2.MB[15].ID.R             /* Message Buffer 15 ID Register */
#define CAN_2_B15            CAN_2.MB[15].DATA.B.R         /* Message Buffer 15 B Register */
#define CAN_2_H15            CAN_2.MB[15].DATA.H.R         /* Message Buffer 15 H Register */
#define CAN_2_W15            CAN_2.MB[15].DATA.W.R         /* Message Buffer 15 W Register */
#define CAN_2_CS16           CAN_2.MB[16].CS.R             /* Message Buffer 16 CS Register */
#define CAN_2_ID16           CAN_2.MB[16].ID.R             /* Message Buffer 16 ID Register */
#define CAN_2_B16            CAN_2.MB[16].DATA.B.R         /* Message Buffer 16 B Register */
#define CAN_2_H16            CAN_2.MB[16].DATA.H.R         /* Message Buffer 16 H Register */
#define CAN_2_W16            CAN_2.MB[16].DATA.W.R         /* Message Buffer 16 W Register */
#define CAN_2_CS17           CAN_2.MB[17].CS.R             /* Message Buffer 17 CS Register */
#define CAN_2_ID17           CAN_2.MB[17].ID.R             /* Message Buffer 17 ID Register */
#define CAN_2_B17            CAN_2.MB[17].DATA.B.R         /* Message Buffer 17 B Register */
#define CAN_2_H17            CAN_2.MB[17].DATA.H.R         /* Message Buffer 17 H Register */
#define CAN_2_W17            CAN_2.MB[17].DATA.W.R         /* Message Buffer 17 W Register */
#define CAN_2_CS18           CAN_2.MB[18].CS.R             /* Message Buffer 18 CS Register */
#define CAN_2_ID18           CAN_2.MB[18].ID.R             /* Message Buffer 18 ID Register */
#define CAN_2_B18            CAN_2.MB[18].DATA.B.R         /* Message Buffer 18 B Register */
#define CAN_2_H18            CAN_2.MB[18].DATA.H.R         /* Message Buffer 18 H Register */
#define CAN_2_W18            CAN_2.MB[18].DATA.W.R         /* Message Buffer 18 W Register */
#define CAN_2_CS19           CAN_2.MB[19].CS.R             /* Message Buffer 19 CS Register */
#define CAN_2_ID19           CAN_2.MB[19].ID.R             /* Message Buffer 19 ID Register */
#define CAN_2_B19            CAN_2.MB[19].DATA.B.R         /* Message Buffer 19 B Register */
#define CAN_2_H19            CAN_2.MB[19].DATA.H.R         /* Message Buffer 19 H Register */
#define CAN_2_W19            CAN_2.MB[19].DATA.W.R         /* Message Buffer 19 W Register */
#define CAN_2_CS20           CAN_2.MB[20].CS.R             /* Message Buffer 20 CS Register */
#define CAN_2_ID20           CAN_2.MB[20].ID.R             /* Message Buffer 20 ID Register */
#define CAN_2_B20            CAN_2.MB[20].DATA.B.R         /* Message Buffer 20 B Register */
#define CAN_2_H20            CAN_2.MB[20].DATA.H.R         /* Message Buffer 20 H Register */
#define CAN_2_W20            CAN_2.MB[20].DATA.W.R         /* Message Buffer 20 W Register */
#define CAN_2_CS21           CAN_2.MB[21].CS.R             /* Message Buffer 21 CS Register */
#define CAN_2_ID21           CAN_2.MB[21].ID.R             /* Message Buffer 21 ID Register */
#define CAN_2_B21            CAN_2.MB[21].DATA.B.R         /* Message Buffer 21 B Register */
#define CAN_2_H21            CAN_2.MB[21].DATA.H.R         /* Message Buffer 21 H Register */
#define CAN_2_W21            CAN_2.MB[21].DATA.W.R         /* Message Buffer 21 W Register */
#define CAN_2_CS22           CAN_2.MB[22].CS.R             /* Message Buffer 22 CS Register */
#define CAN_2_ID22           CAN_2.MB[22].ID.R             /* Message Buffer 22 ID Register */
#define CAN_2_B22            CAN_2.MB[22].DATA.B.R         /* Message Buffer 22 B Register */
#define CAN_2_H22            CAN_2.MB[22].DATA.H.R         /* Message Buffer 22 H Register */
#define CAN_2_W22            CAN_2.MB[22].DATA.W.R         /* Message Buffer 22 W Register */
#define CAN_2_CS23           CAN_2.MB[23].CS.R             /* Message Buffer 23 CS Register */
#define CAN_2_ID23           CAN_2.MB[23].ID.R             /* Message Buffer 23 ID Register */
#define CAN_2_B23            CAN_2.MB[23].DATA.B.R         /* Message Buffer 23 B Register */
#define CAN_2_H23            CAN_2.MB[23].DATA.H.R         /* Message Buffer 23 H Register */
#define CAN_2_W23            CAN_2.MB[23].DATA.W.R         /* Message Buffer 23 W Register */
#define CAN_2_CS24           CAN_2.MB[24].CS.R             /* Message Buffer 24 CS Register */
#define CAN_2_ID24           CAN_2.MB[24].ID.R             /* Message Buffer 24 ID Register */
#define CAN_2_B24            CAN_2.MB[24].DATA.B.R         /* Message Buffer 24 B Register */
#define CAN_2_H24            CAN_2.MB[24].DATA.H.R         /* Message Buffer 24 H Register */
#define CAN_2_W24            CAN_2.MB[24].DATA.W.R         /* Message Buffer 24 W Register */
#define CAN_2_CS25           CAN_2.MB[25].CS.R             /* Message Buffer 25 CS Register */
#define CAN_2_ID25           CAN_2.MB[25].ID.R             /* Message Buffer 25 ID Register */
#define CAN_2_B25            CAN_2.MB[25].DATA.B.R         /* Message Buffer 25 B Register */
#define CAN_2_H25            CAN_2.MB[25].DATA.H.R         /* Message Buffer 25 H Register */
#define CAN_2_W25            CAN_2.MB[25].DATA.W.R         /* Message Buffer 25 W Register */
#define CAN_2_CS26           CAN_2.MB[26].CS.R             /* Message Buffer 26 CS Register */
#define CAN_2_ID26           CAN_2.MB[26].ID.R             /* Message Buffer 26 ID Register */
#define CAN_2_B26            CAN_2.MB[26].DATA.B.R         /* Message Buffer 26 B Register */
#define CAN_2_H26            CAN_2.MB[26].DATA.H.R         /* Message Buffer 26 H Register */
#define CAN_2_W26            CAN_2.MB[26].DATA.W.R         /* Message Buffer 26 W Register */
#define CAN_2_CS27           CAN_2.MB[27].CS.R             /* Message Buffer 27 CS Register */
#define CAN_2_ID27           CAN_2.MB[27].ID.R             /* Message Buffer 27 ID Register */
#define CAN_2_B27            CAN_2.MB[27].DATA.B.R         /* Message Buffer 27 B Register */
#define CAN_2_H27            CAN_2.MB[27].DATA.H.R         /* Message Buffer 27 H Register */
#define CAN_2_W27            CAN_2.MB[27].DATA.W.R         /* Message Buffer 27 W Register */
#define CAN_2_CS28           CAN_2.MB[28].CS.R             /* Message Buffer 28 CS Register */
#define CAN_2_ID28           CAN_2.MB[28].ID.R             /* Message Buffer 28 ID Register */
#define CAN_2_B28            CAN_2.MB[28].DATA.B.R         /* Message Buffer 28 B Register */
#define CAN_2_H28            CAN_2.MB[28].DATA.H.R         /* Message Buffer 28 H Register */
#define CAN_2_W28            CAN_2.MB[28].DATA.W.R         /* Message Buffer 28 W Register */
#define CAN_2_CS29           CAN_2.MB[29].CS.R             /* Message Buffer 29 CS Register */
#define CAN_2_ID29           CAN_2.MB[29].ID.R             /* Message Buffer 29 ID Register */
#define CAN_2_B29            CAN_2.MB[29].DATA.B.R         /* Message Buffer 29 B Register */
#define CAN_2_H29            CAN_2.MB[29].DATA.H.R         /* Message Buffer 29 H Register */
#define CAN_2_W29            CAN_2.MB[29].DATA.W.R         /* Message Buffer 29 W Register */
#define CAN_2_CS30           CAN_2.MB[30].CS.R             /* Message Buffer 30 CS Register */
#define CAN_2_ID30           CAN_2.MB[30].ID.R             /* Message Buffer 30 ID Register */
#define CAN_2_B30            CAN_2.MB[30].DATA.B.R         /* Message Buffer 30 B Register */
#define CAN_2_H30            CAN_2.MB[30].DATA.H.R         /* Message Buffer 30 H Register */
#define CAN_2_W30            CAN_2.MB[30].DATA.W.R         /* Message Buffer 30 W Register */
#define CAN_2_CS31           CAN_2.MB[31].CS.R             /* Message Buffer 31 CS Register */
#define CAN_2_ID31           CAN_2.MB[31].ID.R             /* Message Buffer 31 ID Register */
#define CAN_2_B31            CAN_2.MB[31].DATA.B.R         /* Message Buffer 31 B Register */
#define CAN_2_H31            CAN_2.MB[31].DATA.H.R         /* Message Buffer 31 H Register */
#define CAN_2_W31            CAN_2.MB[31].DATA.W.R         /* Message Buffer 31 W Register */
#define CAN_2_CS32           CAN_2.MB[32].CS.R             /* Message Buffer 32 CS Register */
#define CAN_2_ID32           CAN_2.MB[32].ID.R             /* Message Buffer 32 ID Register */
#define CAN_2_B32            CAN_2.MB[32].DATA.B.R         /* Message Buffer 32 B Register */
#define CAN_2_H32            CAN_2.MB[32].DATA.H.R         /* Message Buffer 32 H Register */
#define CAN_2_W32            CAN_2.MB[32].DATA.W.R         /* Message Buffer 32 W Register */
#define CAN_2_CS33           CAN_2.MB[33].CS.R             /* Message Buffer 33 CS Register */
#define CAN_2_ID33           CAN_2.MB[33].ID.R             /* Message Buffer 33 ID Register */
#define CAN_2_B33            CAN_2.MB[33].DATA.B.R         /* Message Buffer 33 B Register */
#define CAN_2_H33            CAN_2.MB[33].DATA.H.R         /* Message Buffer 33 H Register */
#define CAN_2_W33            CAN_2.MB[33].DATA.W.R         /* Message Buffer 33 W Register */
#define CAN_2_CS34           CAN_2.MB[34].CS.R             /* Message Buffer 34 CS Register */
#define CAN_2_ID34           CAN_2.MB[34].ID.R             /* Message Buffer 34 ID Register */
#define CAN_2_B34            CAN_2.MB[34].DATA.B.R         /* Message Buffer 34 B Register */
#define CAN_2_H34            CAN_2.MB[34].DATA.H.R         /* Message Buffer 34 H Register */
#define CAN_2_W34            CAN_2.MB[34].DATA.W.R         /* Message Buffer 34 W Register */
#define CAN_2_CS35           CAN_2.MB[35].CS.R             /* Message Buffer 35 CS Register */
#define CAN_2_ID35           CAN_2.MB[35].ID.R             /* Message Buffer 35 ID Register */
#define CAN_2_B35            CAN_2.MB[35].DATA.B.R         /* Message Buffer 35 B Register */
#define CAN_2_H35            CAN_2.MB[35].DATA.H.R         /* Message Buffer 35 H Register */
#define CAN_2_W35            CAN_2.MB[35].DATA.W.R         /* Message Buffer 35 W Register */
#define CAN_2_CS36           CAN_2.MB[36].CS.R             /* Message Buffer 36 CS Register */
#define CAN_2_ID36           CAN_2.MB[36].ID.R             /* Message Buffer 36 ID Register */
#define CAN_2_B36            CAN_2.MB[36].DATA.B.R         /* Message Buffer 36 B Register */
#define CAN_2_H36            CAN_2.MB[36].DATA.H.R         /* Message Buffer 36 H Register */
#define CAN_2_W36            CAN_2.MB[36].DATA.W.R         /* Message Buffer 36 W Register */
#define CAN_2_CS37           CAN_2.MB[37].CS.R             /* Message Buffer 37 CS Register */
#define CAN_2_ID37           CAN_2.MB[37].ID.R             /* Message Buffer 37 ID Register */
#define CAN_2_B37            CAN_2.MB[37].DATA.B.R         /* Message Buffer 37 B Register */
#define CAN_2_H37            CAN_2.MB[37].DATA.H.R         /* Message Buffer 37 H Register */
#define CAN_2_W37            CAN_2.MB[37].DATA.W.R         /* Message Buffer 37 W Register */
#define CAN_2_CS38           CAN_2.MB[38].CS.R             /* Message Buffer 38 CS Register */
#define CAN_2_ID38           CAN_2.MB[38].ID.R             /* Message Buffer 38 ID Register */
#define CAN_2_B38            CAN_2.MB[38].DATA.B.R         /* Message Buffer 38 B Register */
#define CAN_2_H38            CAN_2.MB[38].DATA.H.R         /* Message Buffer 38 H Register */
#define CAN_2_W38            CAN_2.MB[38].DATA.W.R         /* Message Buffer 38 W Register */
#define CAN_2_CS39           CAN_2.MB[39].CS.R             /* Message Buffer 39 CS Register */
#define CAN_2_ID39           CAN_2.MB[39].ID.R             /* Message Buffer 39 ID Register */
#define CAN_2_B39            CAN_2.MB[39].DATA.B.R         /* Message Buffer 39 B Register */
#define CAN_2_H39            CAN_2.MB[39].DATA.H.R         /* Message Buffer 39 H Register */
#define CAN_2_W39            CAN_2.MB[39].DATA.W.R         /* Message Buffer 39 W Register */
#define CAN_2_CS40           CAN_2.MB[40].CS.R             /* Message Buffer 40 CS Register */
#define CAN_2_ID40           CAN_2.MB[40].ID.R             /* Message Buffer 40 ID Register */
#define CAN_2_B40            CAN_2.MB[40].DATA.B.R         /* Message Buffer 40 B Register */
#define CAN_2_H40            CAN_2.MB[40].DATA.H.R         /* Message Buffer 40 H Register */
#define CAN_2_W40            CAN_2.MB[40].DATA.W.R         /* Message Buffer 40 W Register */
#define CAN_2_CS41           CAN_2.MB[41].CS.R             /* Message Buffer 41 CS Register */
#define CAN_2_ID41           CAN_2.MB[41].ID.R             /* Message Buffer 41 ID Register */
#define CAN_2_B41            CAN_2.MB[41].DATA.B.R         /* Message Buffer 41 B Register */
#define CAN_2_H41            CAN_2.MB[41].DATA.H.R         /* Message Buffer 41 H Register */
#define CAN_2_W41            CAN_2.MB[41].DATA.W.R         /* Message Buffer 41 W Register */
#define CAN_2_CS42           CAN_2.MB[42].CS.R             /* Message Buffer 42 CS Register */
#define CAN_2_ID42           CAN_2.MB[42].ID.R             /* Message Buffer 42 ID Register */
#define CAN_2_B42            CAN_2.MB[42].DATA.B.R         /* Message Buffer 42 B Register */
#define CAN_2_H42            CAN_2.MB[42].DATA.H.R         /* Message Buffer 42 H Register */
#define CAN_2_W42            CAN_2.MB[42].DATA.W.R         /* Message Buffer 42 W Register */
#define CAN_2_CS43           CAN_2.MB[43].CS.R             /* Message Buffer 43 CS Register */
#define CAN_2_ID43           CAN_2.MB[43].ID.R             /* Message Buffer 43 ID Register */
#define CAN_2_B43            CAN_2.MB[43].DATA.B.R         /* Message Buffer 43 B Register */
#define CAN_2_H43            CAN_2.MB[43].DATA.H.R         /* Message Buffer 43 H Register */
#define CAN_2_W43            CAN_2.MB[43].DATA.W.R         /* Message Buffer 43 W Register */
#define CAN_2_CS44           CAN_2.MB[44].CS.R             /* Message Buffer 44 CS Register */
#define CAN_2_ID44           CAN_2.MB[44].ID.R             /* Message Buffer 44 ID Register */
#define CAN_2_B44            CAN_2.MB[44].DATA.B.R         /* Message Buffer 44 B Register */
#define CAN_2_H44            CAN_2.MB[44].DATA.H.R         /* Message Buffer 44 H Register */
#define CAN_2_W44            CAN_2.MB[44].DATA.W.R         /* Message Buffer 44 W Register */
#define CAN_2_CS45           CAN_2.MB[45].CS.R             /* Message Buffer 45 CS Register */
#define CAN_2_ID45           CAN_2.MB[45].ID.R             /* Message Buffer 45 ID Register */
#define CAN_2_B45            CAN_2.MB[45].DATA.B.R         /* Message Buffer 45 B Register */
#define CAN_2_H45            CAN_2.MB[45].DATA.H.R         /* Message Buffer 45 H Register */
#define CAN_2_W45            CAN_2.MB[45].DATA.W.R         /* Message Buffer 45 W Register */
#define CAN_2_CS46           CAN_2.MB[46].CS.R             /* Message Buffer 46 CS Register */
#define CAN_2_ID46           CAN_2.MB[46].ID.R             /* Message Buffer 46 ID Register */
#define CAN_2_B46            CAN_2.MB[46].DATA.B.R         /* Message Buffer 46 B Register */
#define CAN_2_H46            CAN_2.MB[46].DATA.H.R         /* Message Buffer 46 H Register */
#define CAN_2_W46            CAN_2.MB[46].DATA.W.R         /* Message Buffer 46 W Register */
#define CAN_2_CS47           CAN_2.MB[47].CS.R             /* Message Buffer 47 CS Register */
#define CAN_2_ID47           CAN_2.MB[47].ID.R             /* Message Buffer 47 ID Register */
#define CAN_2_B47            CAN_2.MB[47].DATA.B.R         /* Message Buffer 47 B Register */
#define CAN_2_H47            CAN_2.MB[47].DATA.H.R         /* Message Buffer 47 H Register */
#define CAN_2_W47            CAN_2.MB[47].DATA.W.R         /* Message Buffer 47 W Register */
#define CAN_2_CS48           CAN_2.MB[48].CS.R             /* Message Buffer 48 CS Register */
#define CAN_2_ID48           CAN_2.MB[48].ID.R             /* Message Buffer 48 ID Register */
#define CAN_2_B48            CAN_2.MB[48].DATA.B.R         /* Message Buffer 48 B Register */
#define CAN_2_H48            CAN_2.MB[48].DATA.H.R         /* Message Buffer 48 H Register */
#define CAN_2_W48            CAN_2.MB[48].DATA.W.R         /* Message Buffer 48 W Register */
#define CAN_2_CS49           CAN_2.MB[49].CS.R             /* Message Buffer 49 CS Register */
#define CAN_2_ID49           CAN_2.MB[49].ID.R             /* Message Buffer 49 ID Register */
#define CAN_2_B49            CAN_2.MB[49].DATA.B.R         /* Message Buffer 49 B Register */
#define CAN_2_H49            CAN_2.MB[49].DATA.H.R         /* Message Buffer 49 H Register */
#define CAN_2_W49            CAN_2.MB[49].DATA.W.R         /* Message Buffer 49 W Register */
#define CAN_2_CS50           CAN_2.MB[50].CS.R             /* Message Buffer 50 CS Register */
#define CAN_2_ID50           CAN_2.MB[50].ID.R             /* Message Buffer 50 ID Register */
#define CAN_2_B50            CAN_2.MB[50].DATA.B.R         /* Message Buffer 50 B Register */
#define CAN_2_H50            CAN_2.MB[50].DATA.H.R         /* Message Buffer 50 H Register */
#define CAN_2_W50            CAN_2.MB[50].DATA.W.R         /* Message Buffer 50 W Register */
#define CAN_2_CS51           CAN_2.MB[51].CS.R             /* Message Buffer 51 CS Register */
#define CAN_2_ID51           CAN_2.MB[51].ID.R             /* Message Buffer 51 ID Register */
#define CAN_2_B51            CAN_2.MB[51].DATA.B.R         /* Message Buffer 51 B Register */
#define CAN_2_H51            CAN_2.MB[51].DATA.H.R         /* Message Buffer 51 H Register */
#define CAN_2_W51            CAN_2.MB[51].DATA.W.R         /* Message Buffer 51 W Register */
#define CAN_2_CS52           CAN_2.MB[52].CS.R             /* Message Buffer 52 CS Register */
#define CAN_2_ID52           CAN_2.MB[52].ID.R             /* Message Buffer 52 ID Register */
#define CAN_2_B52            CAN_2.MB[52].DATA.B.R         /* Message Buffer 52 B Register */
#define CAN_2_H52            CAN_2.MB[52].DATA.H.R         /* Message Buffer 52 H Register */
#define CAN_2_W52            CAN_2.MB[52].DATA.W.R         /* Message Buffer 52 W Register */
#define CAN_2_CS53           CAN_2.MB[53].CS.R             /* Message Buffer 53 CS Register */
#define CAN_2_ID53           CAN_2.MB[53].ID.R             /* Message Buffer 53 ID Register */
#define CAN_2_B53            CAN_2.MB[53].DATA.B.R         /* Message Buffer 53 B Register */
#define CAN_2_H53            CAN_2.MB[53].DATA.H.R         /* Message Buffer 53 H Register */
#define CAN_2_W53            CAN_2.MB[53].DATA.W.R         /* Message Buffer 53 W Register */
#define CAN_2_CS54           CAN_2.MB[54].CS.R             /* Message Buffer 54 CS Register */
#define CAN_2_ID54           CAN_2.MB[54].ID.R             /* Message Buffer 54 ID Register */
#define CAN_2_B54            CAN_2.MB[54].DATA.B.R         /* Message Buffer 54 B Register */
#define CAN_2_H54            CAN_2.MB[54].DATA.H.R         /* Message Buffer 54 H Register */
#define CAN_2_W54            CAN_2.MB[54].DATA.W.R         /* Message Buffer 54 W Register */
#define CAN_2_CS55           CAN_2.MB[55].CS.R             /* Message Buffer 55 CS Register */
#define CAN_2_ID55           CAN_2.MB[55].ID.R             /* Message Buffer 55 ID Register */
#define CAN_2_B55            CAN_2.MB[55].DATA.B.R         /* Message Buffer 55 B Register */
#define CAN_2_H55            CAN_2.MB[55].DATA.H.R         /* Message Buffer 55 H Register */
#define CAN_2_W55            CAN_2.MB[55].DATA.W.R         /* Message Buffer 55 W Register */
#define CAN_2_CS56           CAN_2.MB[56].CS.R             /* Message Buffer 56 CS Register */
#define CAN_2_ID56           CAN_2.MB[56].ID.R             /* Message Buffer 56 ID Register */
#define CAN_2_B56            CAN_2.MB[56].DATA.B.R         /* Message Buffer 56 B Register */
#define CAN_2_H56            CAN_2.MB[56].DATA.H.R         /* Message Buffer 56 H Register */
#define CAN_2_W56            CAN_2.MB[56].DATA.W.R         /* Message Buffer 56 W Register */
#define CAN_2_CS57           CAN_2.MB[57].CS.R             /* Message Buffer 57 CS Register */
#define CAN_2_ID57           CAN_2.MB[57].ID.R             /* Message Buffer 57 ID Register */
#define CAN_2_B57            CAN_2.MB[57].DATA.B.R         /* Message Buffer 57 B Register */
#define CAN_2_H57            CAN_2.MB[57].DATA.H.R         /* Message Buffer 57 H Register */
#define CAN_2_W57            CAN_2.MB[57].DATA.W.R         /* Message Buffer 57 W Register */
#define CAN_2_CS58           CAN_2.MB[58].CS.R             /* Message Buffer 58 CS Register */
#define CAN_2_ID58           CAN_2.MB[58].ID.R             /* Message Buffer 58 ID Register */
#define CAN_2_B58            CAN_2.MB[58].DATA.B.R         /* Message Buffer 58 B Register */
#define CAN_2_H58            CAN_2.MB[58].DATA.H.R         /* Message Buffer 58 H Register */
#define CAN_2_W58            CAN_2.MB[58].DATA.W.R         /* Message Buffer 58 W Register */
#define CAN_2_CS59           CAN_2.MB[59].CS.R             /* Message Buffer 59 CS Register */
#define CAN_2_ID59           CAN_2.MB[59].ID.R             /* Message Buffer 59 ID Register */
#define CAN_2_B59            CAN_2.MB[59].DATA.B.R         /* Message Buffer 59 B Register */
#define CAN_2_H59            CAN_2.MB[59].DATA.H.R         /* Message Buffer 59 H Register */
#define CAN_2_W59            CAN_2.MB[59].DATA.W.R         /* Message Buffer 59 W Register */
#define CAN_2_CS60           CAN_2.MB[60].CS.R             /* Message Buffer 60 CS Register */
#define CAN_2_ID60           CAN_2.MB[60].ID.R             /* Message Buffer 60 ID Register */
#define CAN_2_B60            CAN_2.MB[60].DATA.B.R         /* Message Buffer 60 B Register */
#define CAN_2_H60            CAN_2.MB[60].DATA.H.R         /* Message Buffer 60 H Register */
#define CAN_2_W60            CAN_2.MB[60].DATA.W.R         /* Message Buffer 60 W Register */
#define CAN_2_CS61           CAN_2.MB[61].CS.R             /* Message Buffer 61 CS Register */
#define CAN_2_ID61           CAN_2.MB[61].ID.R             /* Message Buffer 61 ID Register */
#define CAN_2_B61            CAN_2.MB[61].DATA.B.R         /* Message Buffer 61 B Register */
#define CAN_2_H61            CAN_2.MB[61].DATA.H.R         /* Message Buffer 61 H Register */
#define CAN_2_W61            CAN_2.MB[61].DATA.W.R         /* Message Buffer 61 W Register */
#define CAN_2_CS62           CAN_2.MB[62].CS.R             /* Message Buffer 62 CS Register */
#define CAN_2_ID62           CAN_2.MB[62].ID.R             /* Message Buffer 62 ID Register */
#define CAN_2_B62            CAN_2.MB[62].DATA.B.R         /* Message Buffer 62 B Register */
#define CAN_2_H62            CAN_2.MB[62].DATA.H.R         /* Message Buffer 62 H Register */
#define CAN_2_W62            CAN_2.MB[62].DATA.W.R         /* Message Buffer 62 W Register */
#define CAN_2_CS63           CAN_2.MB[63].CS.R             /* Message Buffer 63 CS Register */
#define CAN_2_ID63           CAN_2.MB[63].ID.R             /* Message Buffer 63 ID Register */
#define CAN_2_B63            CAN_2.MB[63].DATA.B.R         /* Message Buffer 63 B Register */
#define CAN_2_H63            CAN_2.MB[63].DATA.H.R         /* Message Buffer 63 H Register */
#define CAN_2_W63            CAN_2.MB[63].DATA.W.R         /* Message Buffer 63 W Register */
#define CAN_2_RXIMR0         CAN_2.RXIMR[0].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR1         CAN_2.RXIMR[1].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR2         CAN_2.RXIMR[2].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR3         CAN_2.RXIMR[3].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR4         CAN_2.RXIMR[4].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR5         CAN_2.RXIMR[5].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR6         CAN_2.RXIMR[6].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR7         CAN_2.RXIMR[7].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR8         CAN_2.RXIMR[8].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR9         CAN_2.RXIMR[9].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR10        CAN_2.RXIMR[10].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR11        CAN_2.RXIMR[11].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR12        CAN_2.RXIMR[12].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR13        CAN_2.RXIMR[13].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR14        CAN_2.RXIMR[14].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR15        CAN_2.RXIMR[15].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR16        CAN_2.RXIMR[16].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR17        CAN_2.RXIMR[17].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR18        CAN_2.RXIMR[18].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR19        CAN_2.RXIMR[19].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR20        CAN_2.RXIMR[20].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR21        CAN_2.RXIMR[21].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR22        CAN_2.RXIMR[22].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR23        CAN_2.RXIMR[23].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR24        CAN_2.RXIMR[24].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR25        CAN_2.RXIMR[25].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR26        CAN_2.RXIMR[26].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR27        CAN_2.RXIMR[27].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR28        CAN_2.RXIMR[28].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR29        CAN_2.RXIMR[29].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR30        CAN_2.RXIMR[30].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR31        CAN_2.RXIMR[31].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR32        CAN_2.RXIMR[32].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR33        CAN_2.RXIMR[33].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR34        CAN_2.RXIMR[34].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR35        CAN_2.RXIMR[35].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR36        CAN_2.RXIMR[36].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR37        CAN_2.RXIMR[37].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR38        CAN_2.RXIMR[38].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR39        CAN_2.RXIMR[39].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR40        CAN_2.RXIMR[40].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR41        CAN_2.RXIMR[41].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR42        CAN_2.RXIMR[42].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR43        CAN_2.RXIMR[43].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR44        CAN_2.RXIMR[44].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR45        CAN_2.RXIMR[45].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR46        CAN_2.RXIMR[46].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR47        CAN_2.RXIMR[47].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR48        CAN_2.RXIMR[48].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR49        CAN_2.RXIMR[49].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR50        CAN_2.RXIMR[50].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR51        CAN_2.RXIMR[51].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR52        CAN_2.RXIMR[52].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR53        CAN_2.RXIMR[53].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR54        CAN_2.RXIMR[54].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR55        CAN_2.RXIMR[55].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR56        CAN_2.RXIMR[56].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR57        CAN_2.RXIMR[57].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR58        CAN_2.RXIMR[58].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR59        CAN_2.RXIMR[59].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR60        CAN_2.RXIMR[60].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR61        CAN_2.RXIMR[61].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR62        CAN_2.RXIMR[62].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR63        CAN_2.RXIMR[63].R             /* Rx Individual Mask Registers */
#define CAN_2_MECR           CAN_2.MECR.R                  /* Memory Error Control Register */
#define CAN_2_ERRIAR         CAN_2.ERRIAR.R                /* Error Injection Address Register */
#define CAN_2_ERRIDPR        CAN_2.ERRIDPR.R               /* Error Injection Data Pattern Register */
#define CAN_2_ERRIPPR        CAN_2.ERRIPPR.R               /* Error Injection Parity Pattern Register */
#define CAN_2_RERRAR         CAN_2.RERRAR.R                /* Error Report Address Register */
#define CAN_2_RERRDR         CAN_2.RERRDR.R                /* Error Report Data Register */
#define CAN_2_RERRSYNR       CAN_2.RERRSYNR.R              /* Error Report Syndrome Register */
#define CAN_2_ERRSR          CAN_2.ERRSR.R                 /* Error Status Register */

/* CAN */
#define CAN_3_MCR            CAN_3.MCR.R                   /* Module Configuration Register */
#define CAN_3_CTRL1          CAN_3.CTRL1.R                 /* Control 1 register */
#define CAN_3_TIMER          CAN_3.TIMER.R                 /* Free Running Timer */
#define CAN_3_RXMGMASK       CAN_3.RXMGMASK.R              /* Rx Mailboxes Global Mask Register */
#define CAN_3_RX14MASK       CAN_3.RX14MASK.R              /* Rx 14 Mask register */
#define CAN_3_RX15MASK       CAN_3.RX15MASK.R              /* Rx 15 Mask register */
#define CAN_3_ECR            CAN_3.ECR.R                   /* Error Counter */
#define CAN_3_ESR1           CAN_3.ESR1.R                  /* Error and Status 1 register */
#define CAN_3_IMASK2         CAN_3.IMASK2.R                /* Interrupt Masks 2 register */
#define CAN_3_IMASK1         CAN_3.IMASK1.R                /* Interrupt Masks 1 register */
#define CAN_3_IFLAG2         CAN_3.IFLAG2.R                /* Interrupt Flags 2 register */
#define CAN_3_IFLAG1         CAN_3.IFLAG1.R                /* Interrupt Flags 1 register */
#define CAN_3_CTRL2          CAN_3.CTRL2.R                 /* Control 2 register */
#define CAN_3_ESR2           CAN_3.ESR2.R                  /* Error and Status 2 register */
#define CAN_3_CRCR           CAN_3.CRCR.R                  /* CRC Register */
#define CAN_3_RXFGMASK       CAN_3.RXFGMASK.R              /* Rx FIFO Global Mask register */
#define CAN_3_RXFIR          CAN_3.RXFIR.R                 /* Rx FIFO Information Register */
#define CAN_3_CS0            CAN_3.MB[0].CS.R              /* Message Buffer 0 CS Register */
#define CAN_3_ID0            CAN_3.MB[0].ID.R              /* Message Buffer 0 ID Register */
#define CAN_3_B0             CAN_3.MB[0].DATA.B.R          /* Message Buffer 0 B Register */
#define CAN_3_H0             CAN_3.MB[0].DATA.H.R          /* Message Buffer 0 H Register */
#define CAN_3_W0             CAN_3.MB[0].DATA.W.R          /* Message Buffer 0 W Register */
#define CAN_3_CS1            CAN_3.MB[1].CS.R              /* Message Buffer 1 CS Register */
#define CAN_3_ID1            CAN_3.MB[1].ID.R              /* Message Buffer 1 ID Register */
#define CAN_3_B1             CAN_3.MB[1].DATA.B.R          /* Message Buffer 1 B Register */
#define CAN_3_H1             CAN_3.MB[1].DATA.H.R          /* Message Buffer 1 H Register */
#define CAN_3_W1             CAN_3.MB[1].DATA.W.R          /* Message Buffer 1 W Register */
#define CAN_3_CS2            CAN_3.MB[2].CS.R              /* Message Buffer 2 CS Register */
#define CAN_3_ID2            CAN_3.MB[2].ID.R              /* Message Buffer 2 ID Register */
#define CAN_3_B2             CAN_3.MB[2].DATA.B.R          /* Message Buffer 2 B Register */
#define CAN_3_H2             CAN_3.MB[2].DATA.H.R          /* Message Buffer 2 H Register */
#define CAN_3_W2             CAN_3.MB[2].DATA.W.R          /* Message Buffer 2 W Register */
#define CAN_3_CS3            CAN_3.MB[3].CS.R              /* Message Buffer 3 CS Register */
#define CAN_3_ID3            CAN_3.MB[3].ID.R              /* Message Buffer 3 ID Register */
#define CAN_3_B3             CAN_3.MB[3].DATA.B.R          /* Message Buffer 3 B Register */
#define CAN_3_H3             CAN_3.MB[3].DATA.H.R          /* Message Buffer 3 H Register */
#define CAN_3_W3             CAN_3.MB[3].DATA.W.R          /* Message Buffer 3 W Register */
#define CAN_3_CS4            CAN_3.MB[4].CS.R              /* Message Buffer 4 CS Register */
#define CAN_3_ID4            CAN_3.MB[4].ID.R              /* Message Buffer 4 ID Register */
#define CAN_3_B4             CAN_3.MB[4].DATA.B.R          /* Message Buffer 4 B Register */
#define CAN_3_H4             CAN_3.MB[4].DATA.H.R          /* Message Buffer 4 H Register */
#define CAN_3_W4             CAN_3.MB[4].DATA.W.R          /* Message Buffer 4 W Register */
#define CAN_3_CS5            CAN_3.MB[5].CS.R              /* Message Buffer 5 CS Register */
#define CAN_3_ID5            CAN_3.MB[5].ID.R              /* Message Buffer 5 ID Register */
#define CAN_3_B5             CAN_3.MB[5].DATA.B.R          /* Message Buffer 5 B Register */
#define CAN_3_H5             CAN_3.MB[5].DATA.H.R          /* Message Buffer 5 H Register */
#define CAN_3_W5             CAN_3.MB[5].DATA.W.R          /* Message Buffer 5 W Register */
#define CAN_3_CS6            CAN_3.MB[6].CS.R              /* Message Buffer 6 CS Register */
#define CAN_3_ID6            CAN_3.MB[6].ID.R              /* Message Buffer 6 ID Register */
#define CAN_3_B6             CAN_3.MB[6].DATA.B.R          /* Message Buffer 6 B Register */
#define CAN_3_H6             CAN_3.MB[6].DATA.H.R          /* Message Buffer 6 H Register */
#define CAN_3_W6             CAN_3.MB[6].DATA.W.R          /* Message Buffer 6 W Register */
#define CAN_3_CS7            CAN_3.MB[7].CS.R              /* Message Buffer 7 CS Register */
#define CAN_3_ID7            CAN_3.MB[7].ID.R              /* Message Buffer 7 ID Register */
#define CAN_3_B7             CAN_3.MB[7].DATA.B.R          /* Message Buffer 7 B Register */
#define CAN_3_H7             CAN_3.MB[7].DATA.H.R          /* Message Buffer 7 H Register */
#define CAN_3_W7             CAN_3.MB[7].DATA.W.R          /* Message Buffer 7 W Register */
#define CAN_3_CS8            CAN_3.MB[8].CS.R              /* Message Buffer 8 CS Register */
#define CAN_3_ID8            CAN_3.MB[8].ID.R              /* Message Buffer 8 ID Register */
#define CAN_3_B8             CAN_3.MB[8].DATA.B.R          /* Message Buffer 8 B Register */
#define CAN_3_H8             CAN_3.MB[8].DATA.H.R          /* Message Buffer 8 H Register */
#define CAN_3_W8             CAN_3.MB[8].DATA.W.R          /* Message Buffer 8 W Register */
#define CAN_3_CS9            CAN_3.MB[9].CS.R              /* Message Buffer 9 CS Register */
#define CAN_3_ID9            CAN_3.MB[9].ID.R              /* Message Buffer 9 ID Register */
#define CAN_3_B9             CAN_3.MB[9].DATA.B.R          /* Message Buffer 9 B Register */
#define CAN_3_H9             CAN_3.MB[9].DATA.H.R          /* Message Buffer 9 H Register */
#define CAN_3_W9             CAN_3.MB[9].DATA.W.R          /* Message Buffer 9 W Register */
#define CAN_3_CS10           CAN_3.MB[10].CS.R             /* Message Buffer 10 CS Register */
#define CAN_3_ID10           CAN_3.MB[10].ID.R             /* Message Buffer 10 ID Register */
#define CAN_3_B10            CAN_3.MB[10].DATA.B.R         /* Message Buffer 10 B Register */
#define CAN_3_H10            CAN_3.MB[10].DATA.H.R         /* Message Buffer 10 H Register */
#define CAN_3_W10            CAN_3.MB[10].DATA.W.R         /* Message Buffer 10 W Register */
#define CAN_3_CS11           CAN_3.MB[11].CS.R             /* Message Buffer 11 CS Register */
#define CAN_3_ID11           CAN_3.MB[11].ID.R             /* Message Buffer 11 ID Register */
#define CAN_3_B11            CAN_3.MB[11].DATA.B.R         /* Message Buffer 11 B Register */
#define CAN_3_H11            CAN_3.MB[11].DATA.H.R         /* Message Buffer 11 H Register */
#define CAN_3_W11            CAN_3.MB[11].DATA.W.R         /* Message Buffer 11 W Register */
#define CAN_3_CS12           CAN_3.MB[12].CS.R             /* Message Buffer 12 CS Register */
#define CAN_3_ID12           CAN_3.MB[12].ID.R             /* Message Buffer 12 ID Register */
#define CAN_3_B12            CAN_3.MB[12].DATA.B.R         /* Message Buffer 12 B Register */
#define CAN_3_H12            CAN_3.MB[12].DATA.H.R         /* Message Buffer 12 H Register */
#define CAN_3_W12            CAN_3.MB[12].DATA.W.R         /* Message Buffer 12 W Register */
#define CAN_3_CS13           CAN_3.MB[13].CS.R             /* Message Buffer 13 CS Register */
#define CAN_3_ID13           CAN_3.MB[13].ID.R             /* Message Buffer 13 ID Register */
#define CAN_3_B13            CAN_3.MB[13].DATA.B.R         /* Message Buffer 13 B Register */
#define CAN_3_H13            CAN_3.MB[13].DATA.H.R         /* Message Buffer 13 H Register */
#define CAN_3_W13            CAN_3.MB[13].DATA.W.R         /* Message Buffer 13 W Register */
#define CAN_3_CS14           CAN_3.MB[14].CS.R             /* Message Buffer 14 CS Register */
#define CAN_3_ID14           CAN_3.MB[14].ID.R             /* Message Buffer 14 ID Register */
#define CAN_3_B14            CAN_3.MB[14].DATA.B.R         /* Message Buffer 14 B Register */
#define CAN_3_H14            CAN_3.MB[14].DATA.H.R         /* Message Buffer 14 H Register */
#define CAN_3_W14            CAN_3.MB[14].DATA.W.R         /* Message Buffer 14 W Register */
#define CAN_3_CS15           CAN_3.MB[15].CS.R             /* Message Buffer 15 CS Register */
#define CAN_3_ID15           CAN_3.MB[15].ID.R             /* Message Buffer 15 ID Register */
#define CAN_3_B15            CAN_3.MB[15].DATA.B.R         /* Message Buffer 15 B Register */
#define CAN_3_H15            CAN_3.MB[15].DATA.H.R         /* Message Buffer 15 H Register */
#define CAN_3_W15            CAN_3.MB[15].DATA.W.R         /* Message Buffer 15 W Register */
#define CAN_3_CS16           CAN_3.MB[16].CS.R             /* Message Buffer 16 CS Register */
#define CAN_3_ID16           CAN_3.MB[16].ID.R             /* Message Buffer 16 ID Register */
#define CAN_3_B16            CAN_3.MB[16].DATA.B.R         /* Message Buffer 16 B Register */
#define CAN_3_H16            CAN_3.MB[16].DATA.H.R         /* Message Buffer 16 H Register */
#define CAN_3_W16            CAN_3.MB[16].DATA.W.R         /* Message Buffer 16 W Register */
#define CAN_3_CS17           CAN_3.MB[17].CS.R             /* Message Buffer 17 CS Register */
#define CAN_3_ID17           CAN_3.MB[17].ID.R             /* Message Buffer 17 ID Register */
#define CAN_3_B17            CAN_3.MB[17].DATA.B.R         /* Message Buffer 17 B Register */
#define CAN_3_H17            CAN_3.MB[17].DATA.H.R         /* Message Buffer 17 H Register */
#define CAN_3_W17            CAN_3.MB[17].DATA.W.R         /* Message Buffer 17 W Register */
#define CAN_3_CS18           CAN_3.MB[18].CS.R             /* Message Buffer 18 CS Register */
#define CAN_3_ID18           CAN_3.MB[18].ID.R             /* Message Buffer 18 ID Register */
#define CAN_3_B18            CAN_3.MB[18].DATA.B.R         /* Message Buffer 18 B Register */
#define CAN_3_H18            CAN_3.MB[18].DATA.H.R         /* Message Buffer 18 H Register */
#define CAN_3_W18            CAN_3.MB[18].DATA.W.R         /* Message Buffer 18 W Register */
#define CAN_3_CS19           CAN_3.MB[19].CS.R             /* Message Buffer 19 CS Register */
#define CAN_3_ID19           CAN_3.MB[19].ID.R             /* Message Buffer 19 ID Register */
#define CAN_3_B19            CAN_3.MB[19].DATA.B.R         /* Message Buffer 19 B Register */
#define CAN_3_H19            CAN_3.MB[19].DATA.H.R         /* Message Buffer 19 H Register */
#define CAN_3_W19            CAN_3.MB[19].DATA.W.R         /* Message Buffer 19 W Register */
#define CAN_3_CS20           CAN_3.MB[20].CS.R             /* Message Buffer 20 CS Register */
#define CAN_3_ID20           CAN_3.MB[20].ID.R             /* Message Buffer 20 ID Register */
#define CAN_3_B20            CAN_3.MB[20].DATA.B.R         /* Message Buffer 20 B Register */
#define CAN_3_H20            CAN_3.MB[20].DATA.H.R         /* Message Buffer 20 H Register */
#define CAN_3_W20            CAN_3.MB[20].DATA.W.R         /* Message Buffer 20 W Register */
#define CAN_3_CS21           CAN_3.MB[21].CS.R             /* Message Buffer 21 CS Register */
#define CAN_3_ID21           CAN_3.MB[21].ID.R             /* Message Buffer 21 ID Register */
#define CAN_3_B21            CAN_3.MB[21].DATA.B.R         /* Message Buffer 21 B Register */
#define CAN_3_H21            CAN_3.MB[21].DATA.H.R         /* Message Buffer 21 H Register */
#define CAN_3_W21            CAN_3.MB[21].DATA.W.R         /* Message Buffer 21 W Register */
#define CAN_3_CS22           CAN_3.MB[22].CS.R             /* Message Buffer 22 CS Register */
#define CAN_3_ID22           CAN_3.MB[22].ID.R             /* Message Buffer 22 ID Register */
#define CAN_3_B22            CAN_3.MB[22].DATA.B.R         /* Message Buffer 22 B Register */
#define CAN_3_H22            CAN_3.MB[22].DATA.H.R         /* Message Buffer 22 H Register */
#define CAN_3_W22            CAN_3.MB[22].DATA.W.R         /* Message Buffer 22 W Register */
#define CAN_3_CS23           CAN_3.MB[23].CS.R             /* Message Buffer 23 CS Register */
#define CAN_3_ID23           CAN_3.MB[23].ID.R             /* Message Buffer 23 ID Register */
#define CAN_3_B23            CAN_3.MB[23].DATA.B.R         /* Message Buffer 23 B Register */
#define CAN_3_H23            CAN_3.MB[23].DATA.H.R         /* Message Buffer 23 H Register */
#define CAN_3_W23            CAN_3.MB[23].DATA.W.R         /* Message Buffer 23 W Register */
#define CAN_3_CS24           CAN_3.MB[24].CS.R             /* Message Buffer 24 CS Register */
#define CAN_3_ID24           CAN_3.MB[24].ID.R             /* Message Buffer 24 ID Register */
#define CAN_3_B24            CAN_3.MB[24].DATA.B.R         /* Message Buffer 24 B Register */
#define CAN_3_H24            CAN_3.MB[24].DATA.H.R         /* Message Buffer 24 H Register */
#define CAN_3_W24            CAN_3.MB[24].DATA.W.R         /* Message Buffer 24 W Register */
#define CAN_3_CS25           CAN_3.MB[25].CS.R             /* Message Buffer 25 CS Register */
#define CAN_3_ID25           CAN_3.MB[25].ID.R             /* Message Buffer 25 ID Register */
#define CAN_3_B25            CAN_3.MB[25].DATA.B.R         /* Message Buffer 25 B Register */
#define CAN_3_H25            CAN_3.MB[25].DATA.H.R         /* Message Buffer 25 H Register */
#define CAN_3_W25            CAN_3.MB[25].DATA.W.R         /* Message Buffer 25 W Register */
#define CAN_3_CS26           CAN_3.MB[26].CS.R             /* Message Buffer 26 CS Register */
#define CAN_3_ID26           CAN_3.MB[26].ID.R             /* Message Buffer 26 ID Register */
#define CAN_3_B26            CAN_3.MB[26].DATA.B.R         /* Message Buffer 26 B Register */
#define CAN_3_H26            CAN_3.MB[26].DATA.H.R         /* Message Buffer 26 H Register */
#define CAN_3_W26            CAN_3.MB[26].DATA.W.R         /* Message Buffer 26 W Register */
#define CAN_3_CS27           CAN_3.MB[27].CS.R             /* Message Buffer 27 CS Register */
#define CAN_3_ID27           CAN_3.MB[27].ID.R             /* Message Buffer 27 ID Register */
#define CAN_3_B27            CAN_3.MB[27].DATA.B.R         /* Message Buffer 27 B Register */
#define CAN_3_H27            CAN_3.MB[27].DATA.H.R         /* Message Buffer 27 H Register */
#define CAN_3_W27            CAN_3.MB[27].DATA.W.R         /* Message Buffer 27 W Register */
#define CAN_3_CS28           CAN_3.MB[28].CS.R             /* Message Buffer 28 CS Register */
#define CAN_3_ID28           CAN_3.MB[28].ID.R             /* Message Buffer 28 ID Register */
#define CAN_3_B28            CAN_3.MB[28].DATA.B.R         /* Message Buffer 28 B Register */
#define CAN_3_H28            CAN_3.MB[28].DATA.H.R         /* Message Buffer 28 H Register */
#define CAN_3_W28            CAN_3.MB[28].DATA.W.R         /* Message Buffer 28 W Register */
#define CAN_3_CS29           CAN_3.MB[29].CS.R             /* Message Buffer 29 CS Register */
#define CAN_3_ID29           CAN_3.MB[29].ID.R             /* Message Buffer 29 ID Register */
#define CAN_3_B29            CAN_3.MB[29].DATA.B.R         /* Message Buffer 29 B Register */
#define CAN_3_H29            CAN_3.MB[29].DATA.H.R         /* Message Buffer 29 H Register */
#define CAN_3_W29            CAN_3.MB[29].DATA.W.R         /* Message Buffer 29 W Register */
#define CAN_3_CS30           CAN_3.MB[30].CS.R             /* Message Buffer 30 CS Register */
#define CAN_3_ID30           CAN_3.MB[30].ID.R             /* Message Buffer 30 ID Register */
#define CAN_3_B30            CAN_3.MB[30].DATA.B.R         /* Message Buffer 30 B Register */
#define CAN_3_H30            CAN_3.MB[30].DATA.H.R         /* Message Buffer 30 H Register */
#define CAN_3_W30            CAN_3.MB[30].DATA.W.R         /* Message Buffer 30 W Register */
#define CAN_3_CS31           CAN_3.MB[31].CS.R             /* Message Buffer 31 CS Register */
#define CAN_3_ID31           CAN_3.MB[31].ID.R             /* Message Buffer 31 ID Register */
#define CAN_3_B31            CAN_3.MB[31].DATA.B.R         /* Message Buffer 31 B Register */
#define CAN_3_H31            CAN_3.MB[31].DATA.H.R         /* Message Buffer 31 H Register */
#define CAN_3_W31            CAN_3.MB[31].DATA.W.R         /* Message Buffer 31 W Register */
#define CAN_3_CS32           CAN_3.MB[32].CS.R             /* Message Buffer 32 CS Register */
#define CAN_3_ID32           CAN_3.MB[32].ID.R             /* Message Buffer 32 ID Register */
#define CAN_3_B32            CAN_3.MB[32].DATA.B.R         /* Message Buffer 32 B Register */
#define CAN_3_H32            CAN_3.MB[32].DATA.H.R         /* Message Buffer 32 H Register */
#define CAN_3_W32            CAN_3.MB[32].DATA.W.R         /* Message Buffer 32 W Register */
#define CAN_3_CS33           CAN_3.MB[33].CS.R             /* Message Buffer 33 CS Register */
#define CAN_3_ID33           CAN_3.MB[33].ID.R             /* Message Buffer 33 ID Register */
#define CAN_3_B33            CAN_3.MB[33].DATA.B.R         /* Message Buffer 33 B Register */
#define CAN_3_H33            CAN_3.MB[33].DATA.H.R         /* Message Buffer 33 H Register */
#define CAN_3_W33            CAN_3.MB[33].DATA.W.R         /* Message Buffer 33 W Register */
#define CAN_3_CS34           CAN_3.MB[34].CS.R             /* Message Buffer 34 CS Register */
#define CAN_3_ID34           CAN_3.MB[34].ID.R             /* Message Buffer 34 ID Register */
#define CAN_3_B34            CAN_3.MB[34].DATA.B.R         /* Message Buffer 34 B Register */
#define CAN_3_H34            CAN_3.MB[34].DATA.H.R         /* Message Buffer 34 H Register */
#define CAN_3_W34            CAN_3.MB[34].DATA.W.R         /* Message Buffer 34 W Register */
#define CAN_3_CS35           CAN_3.MB[35].CS.R             /* Message Buffer 35 CS Register */
#define CAN_3_ID35           CAN_3.MB[35].ID.R             /* Message Buffer 35 ID Register */
#define CAN_3_B35            CAN_3.MB[35].DATA.B.R         /* Message Buffer 35 B Register */
#define CAN_3_H35            CAN_3.MB[35].DATA.H.R         /* Message Buffer 35 H Register */
#define CAN_3_W35            CAN_3.MB[35].DATA.W.R         /* Message Buffer 35 W Register */
#define CAN_3_CS36           CAN_3.MB[36].CS.R             /* Message Buffer 36 CS Register */
#define CAN_3_ID36           CAN_3.MB[36].ID.R             /* Message Buffer 36 ID Register */
#define CAN_3_B36            CAN_3.MB[36].DATA.B.R         /* Message Buffer 36 B Register */
#define CAN_3_H36            CAN_3.MB[36].DATA.H.R         /* Message Buffer 36 H Register */
#define CAN_3_W36            CAN_3.MB[36].DATA.W.R         /* Message Buffer 36 W Register */
#define CAN_3_CS37           CAN_3.MB[37].CS.R             /* Message Buffer 37 CS Register */
#define CAN_3_ID37           CAN_3.MB[37].ID.R             /* Message Buffer 37 ID Register */
#define CAN_3_B37            CAN_3.MB[37].DATA.B.R         /* Message Buffer 37 B Register */
#define CAN_3_H37            CAN_3.MB[37].DATA.H.R         /* Message Buffer 37 H Register */
#define CAN_3_W37            CAN_3.MB[37].DATA.W.R         /* Message Buffer 37 W Register */
#define CAN_3_CS38           CAN_3.MB[38].CS.R             /* Message Buffer 38 CS Register */
#define CAN_3_ID38           CAN_3.MB[38].ID.R             /* Message Buffer 38 ID Register */
#define CAN_3_B38            CAN_3.MB[38].DATA.B.R         /* Message Buffer 38 B Register */
#define CAN_3_H38            CAN_3.MB[38].DATA.H.R         /* Message Buffer 38 H Register */
#define CAN_3_W38            CAN_3.MB[38].DATA.W.R         /* Message Buffer 38 W Register */
#define CAN_3_CS39           CAN_3.MB[39].CS.R             /* Message Buffer 39 CS Register */
#define CAN_3_ID39           CAN_3.MB[39].ID.R             /* Message Buffer 39 ID Register */
#define CAN_3_B39            CAN_3.MB[39].DATA.B.R         /* Message Buffer 39 B Register */
#define CAN_3_H39            CAN_3.MB[39].DATA.H.R         /* Message Buffer 39 H Register */
#define CAN_3_W39            CAN_3.MB[39].DATA.W.R         /* Message Buffer 39 W Register */
#define CAN_3_CS40           CAN_3.MB[40].CS.R             /* Message Buffer 40 CS Register */
#define CAN_3_ID40           CAN_3.MB[40].ID.R             /* Message Buffer 40 ID Register */
#define CAN_3_B40            CAN_3.MB[40].DATA.B.R         /* Message Buffer 40 B Register */
#define CAN_3_H40            CAN_3.MB[40].DATA.H.R         /* Message Buffer 40 H Register */
#define CAN_3_W40            CAN_3.MB[40].DATA.W.R         /* Message Buffer 40 W Register */
#define CAN_3_CS41           CAN_3.MB[41].CS.R             /* Message Buffer 41 CS Register */
#define CAN_3_ID41           CAN_3.MB[41].ID.R             /* Message Buffer 41 ID Register */
#define CAN_3_B41            CAN_3.MB[41].DATA.B.R         /* Message Buffer 41 B Register */
#define CAN_3_H41            CAN_3.MB[41].DATA.H.R         /* Message Buffer 41 H Register */
#define CAN_3_W41            CAN_3.MB[41].DATA.W.R         /* Message Buffer 41 W Register */
#define CAN_3_CS42           CAN_3.MB[42].CS.R             /* Message Buffer 42 CS Register */
#define CAN_3_ID42           CAN_3.MB[42].ID.R             /* Message Buffer 42 ID Register */
#define CAN_3_B42            CAN_3.MB[42].DATA.B.R         /* Message Buffer 42 B Register */
#define CAN_3_H42            CAN_3.MB[42].DATA.H.R         /* Message Buffer 42 H Register */
#define CAN_3_W42            CAN_3.MB[42].DATA.W.R         /* Message Buffer 42 W Register */
#define CAN_3_CS43           CAN_3.MB[43].CS.R             /* Message Buffer 43 CS Register */
#define CAN_3_ID43           CAN_3.MB[43].ID.R             /* Message Buffer 43 ID Register */
#define CAN_3_B43            CAN_3.MB[43].DATA.B.R         /* Message Buffer 43 B Register */
#define CAN_3_H43            CAN_3.MB[43].DATA.H.R         /* Message Buffer 43 H Register */
#define CAN_3_W43            CAN_3.MB[43].DATA.W.R         /* Message Buffer 43 W Register */
#define CAN_3_CS44           CAN_3.MB[44].CS.R             /* Message Buffer 44 CS Register */
#define CAN_3_ID44           CAN_3.MB[44].ID.R             /* Message Buffer 44 ID Register */
#define CAN_3_B44            CAN_3.MB[44].DATA.B.R         /* Message Buffer 44 B Register */
#define CAN_3_H44            CAN_3.MB[44].DATA.H.R         /* Message Buffer 44 H Register */
#define CAN_3_W44            CAN_3.MB[44].DATA.W.R         /* Message Buffer 44 W Register */
#define CAN_3_CS45           CAN_3.MB[45].CS.R             /* Message Buffer 45 CS Register */
#define CAN_3_ID45           CAN_3.MB[45].ID.R             /* Message Buffer 45 ID Register */
#define CAN_3_B45            CAN_3.MB[45].DATA.B.R         /* Message Buffer 45 B Register */
#define CAN_3_H45            CAN_3.MB[45].DATA.H.R         /* Message Buffer 45 H Register */
#define CAN_3_W45            CAN_3.MB[45].DATA.W.R         /* Message Buffer 45 W Register */
#define CAN_3_CS46           CAN_3.MB[46].CS.R             /* Message Buffer 46 CS Register */
#define CAN_3_ID46           CAN_3.MB[46].ID.R             /* Message Buffer 46 ID Register */
#define CAN_3_B46            CAN_3.MB[46].DATA.B.R         /* Message Buffer 46 B Register */
#define CAN_3_H46            CAN_3.MB[46].DATA.H.R         /* Message Buffer 46 H Register */
#define CAN_3_W46            CAN_3.MB[46].DATA.W.R         /* Message Buffer 46 W Register */
#define CAN_3_CS47           CAN_3.MB[47].CS.R             /* Message Buffer 47 CS Register */
#define CAN_3_ID47           CAN_3.MB[47].ID.R             /* Message Buffer 47 ID Register */
#define CAN_3_B47            CAN_3.MB[47].DATA.B.R         /* Message Buffer 47 B Register */
#define CAN_3_H47            CAN_3.MB[47].DATA.H.R         /* Message Buffer 47 H Register */
#define CAN_3_W47            CAN_3.MB[47].DATA.W.R         /* Message Buffer 47 W Register */
#define CAN_3_CS48           CAN_3.MB[48].CS.R             /* Message Buffer 48 CS Register */
#define CAN_3_ID48           CAN_3.MB[48].ID.R             /* Message Buffer 48 ID Register */
#define CAN_3_B48            CAN_3.MB[48].DATA.B.R         /* Message Buffer 48 B Register */
#define CAN_3_H48            CAN_3.MB[48].DATA.H.R         /* Message Buffer 48 H Register */
#define CAN_3_W48            CAN_3.MB[48].DATA.W.R         /* Message Buffer 48 W Register */
#define CAN_3_CS49           CAN_3.MB[49].CS.R             /* Message Buffer 49 CS Register */
#define CAN_3_ID49           CAN_3.MB[49].ID.R             /* Message Buffer 49 ID Register */
#define CAN_3_B49            CAN_3.MB[49].DATA.B.R         /* Message Buffer 49 B Register */
#define CAN_3_H49            CAN_3.MB[49].DATA.H.R         /* Message Buffer 49 H Register */
#define CAN_3_W49            CAN_3.MB[49].DATA.W.R         /* Message Buffer 49 W Register */
#define CAN_3_CS50           CAN_3.MB[50].CS.R             /* Message Buffer 50 CS Register */
#define CAN_3_ID50           CAN_3.MB[50].ID.R             /* Message Buffer 50 ID Register */
#define CAN_3_B50            CAN_3.MB[50].DATA.B.R         /* Message Buffer 50 B Register */
#define CAN_3_H50            CAN_3.MB[50].DATA.H.R         /* Message Buffer 50 H Register */
#define CAN_3_W50            CAN_3.MB[50].DATA.W.R         /* Message Buffer 50 W Register */
#define CAN_3_CS51           CAN_3.MB[51].CS.R             /* Message Buffer 51 CS Register */
#define CAN_3_ID51           CAN_3.MB[51].ID.R             /* Message Buffer 51 ID Register */
#define CAN_3_B51            CAN_3.MB[51].DATA.B.R         /* Message Buffer 51 B Register */
#define CAN_3_H51            CAN_3.MB[51].DATA.H.R         /* Message Buffer 51 H Register */
#define CAN_3_W51            CAN_3.MB[51].DATA.W.R         /* Message Buffer 51 W Register */
#define CAN_3_CS52           CAN_3.MB[52].CS.R             /* Message Buffer 52 CS Register */
#define CAN_3_ID52           CAN_3.MB[52].ID.R             /* Message Buffer 52 ID Register */
#define CAN_3_B52            CAN_3.MB[52].DATA.B.R         /* Message Buffer 52 B Register */
#define CAN_3_H52            CAN_3.MB[52].DATA.H.R         /* Message Buffer 52 H Register */
#define CAN_3_W52            CAN_3.MB[52].DATA.W.R         /* Message Buffer 52 W Register */
#define CAN_3_CS53           CAN_3.MB[53].CS.R             /* Message Buffer 53 CS Register */
#define CAN_3_ID53           CAN_3.MB[53].ID.R             /* Message Buffer 53 ID Register */
#define CAN_3_B53            CAN_3.MB[53].DATA.B.R         /* Message Buffer 53 B Register */
#define CAN_3_H53            CAN_3.MB[53].DATA.H.R         /* Message Buffer 53 H Register */
#define CAN_3_W53            CAN_3.MB[53].DATA.W.R         /* Message Buffer 53 W Register */
#define CAN_3_CS54           CAN_3.MB[54].CS.R             /* Message Buffer 54 CS Register */
#define CAN_3_ID54           CAN_3.MB[54].ID.R             /* Message Buffer 54 ID Register */
#define CAN_3_B54            CAN_3.MB[54].DATA.B.R         /* Message Buffer 54 B Register */
#define CAN_3_H54            CAN_3.MB[54].DATA.H.R         /* Message Buffer 54 H Register */
#define CAN_3_W54            CAN_3.MB[54].DATA.W.R         /* Message Buffer 54 W Register */
#define CAN_3_CS55           CAN_3.MB[55].CS.R             /* Message Buffer 55 CS Register */
#define CAN_3_ID55           CAN_3.MB[55].ID.R             /* Message Buffer 55 ID Register */
#define CAN_3_B55            CAN_3.MB[55].DATA.B.R         /* Message Buffer 55 B Register */
#define CAN_3_H55            CAN_3.MB[55].DATA.H.R         /* Message Buffer 55 H Register */
#define CAN_3_W55            CAN_3.MB[55].DATA.W.R         /* Message Buffer 55 W Register */
#define CAN_3_CS56           CAN_3.MB[56].CS.R             /* Message Buffer 56 CS Register */
#define CAN_3_ID56           CAN_3.MB[56].ID.R             /* Message Buffer 56 ID Register */
#define CAN_3_B56            CAN_3.MB[56].DATA.B.R         /* Message Buffer 56 B Register */
#define CAN_3_H56            CAN_3.MB[56].DATA.H.R         /* Message Buffer 56 H Register */
#define CAN_3_W56            CAN_3.MB[56].DATA.W.R         /* Message Buffer 56 W Register */
#define CAN_3_CS57           CAN_3.MB[57].CS.R             /* Message Buffer 57 CS Register */
#define CAN_3_ID57           CAN_3.MB[57].ID.R             /* Message Buffer 57 ID Register */
#define CAN_3_B57            CAN_3.MB[57].DATA.B.R         /* Message Buffer 57 B Register */
#define CAN_3_H57            CAN_3.MB[57].DATA.H.R         /* Message Buffer 57 H Register */
#define CAN_3_W57            CAN_3.MB[57].DATA.W.R         /* Message Buffer 57 W Register */
#define CAN_3_CS58           CAN_3.MB[58].CS.R             /* Message Buffer 58 CS Register */
#define CAN_3_ID58           CAN_3.MB[58].ID.R             /* Message Buffer 58 ID Register */
#define CAN_3_B58            CAN_3.MB[58].DATA.B.R         /* Message Buffer 58 B Register */
#define CAN_3_H58            CAN_3.MB[58].DATA.H.R         /* Message Buffer 58 H Register */
#define CAN_3_W58            CAN_3.MB[58].DATA.W.R         /* Message Buffer 58 W Register */
#define CAN_3_CS59           CAN_3.MB[59].CS.R             /* Message Buffer 59 CS Register */
#define CAN_3_ID59           CAN_3.MB[59].ID.R             /* Message Buffer 59 ID Register */
#define CAN_3_B59            CAN_3.MB[59].DATA.B.R         /* Message Buffer 59 B Register */
#define CAN_3_H59            CAN_3.MB[59].DATA.H.R         /* Message Buffer 59 H Register */
#define CAN_3_W59            CAN_3.MB[59].DATA.W.R         /* Message Buffer 59 W Register */
#define CAN_3_CS60           CAN_3.MB[60].CS.R             /* Message Buffer 60 CS Register */
#define CAN_3_ID60           CAN_3.MB[60].ID.R             /* Message Buffer 60 ID Register */
#define CAN_3_B60            CAN_3.MB[60].DATA.B.R         /* Message Buffer 60 B Register */
#define CAN_3_H60            CAN_3.MB[60].DATA.H.R         /* Message Buffer 60 H Register */
#define CAN_3_W60            CAN_3.MB[60].DATA.W.R         /* Message Buffer 60 W Register */
#define CAN_3_CS61           CAN_3.MB[61].CS.R             /* Message Buffer 61 CS Register */
#define CAN_3_ID61           CAN_3.MB[61].ID.R             /* Message Buffer 61 ID Register */
#define CAN_3_B61            CAN_3.MB[61].DATA.B.R         /* Message Buffer 61 B Register */
#define CAN_3_H61            CAN_3.MB[61].DATA.H.R         /* Message Buffer 61 H Register */
#define CAN_3_W61            CAN_3.MB[61].DATA.W.R         /* Message Buffer 61 W Register */
#define CAN_3_CS62           CAN_3.MB[62].CS.R             /* Message Buffer 62 CS Register */
#define CAN_3_ID62           CAN_3.MB[62].ID.R             /* Message Buffer 62 ID Register */
#define CAN_3_B62            CAN_3.MB[62].DATA.B.R         /* Message Buffer 62 B Register */
#define CAN_3_H62            CAN_3.MB[62].DATA.H.R         /* Message Buffer 62 H Register */
#define CAN_3_W62            CAN_3.MB[62].DATA.W.R         /* Message Buffer 62 W Register */
#define CAN_3_CS63           CAN_3.MB[63].CS.R             /* Message Buffer 63 CS Register */
#define CAN_3_ID63           CAN_3.MB[63].ID.R             /* Message Buffer 63 ID Register */
#define CAN_3_B63            CAN_3.MB[63].DATA.B.R         /* Message Buffer 63 B Register */
#define CAN_3_H63            CAN_3.MB[63].DATA.H.R         /* Message Buffer 63 H Register */
#define CAN_3_W63            CAN_3.MB[63].DATA.W.R         /* Message Buffer 63 W Register */
#define CAN_3_RXIMR0         CAN_3.RXIMR[0].R              /* Rx Individual Mask Registers */
#define CAN_3_RXIMR1         CAN_3.RXIMR[1].R              /* Rx Individual Mask Registers */
#define CAN_3_RXIMR2         CAN_3.RXIMR[2].R              /* Rx Individual Mask Registers */
#define CAN_3_RXIMR3         CAN_3.RXIMR[3].R              /* Rx Individual Mask Registers */
#define CAN_3_RXIMR4         CAN_3.RXIMR[4].R              /* Rx Individual Mask Registers */
#define CAN_3_RXIMR5         CAN_3.RXIMR[5].R              /* Rx Individual Mask Registers */
#define CAN_3_RXIMR6         CAN_3.RXIMR[6].R              /* Rx Individual Mask Registers */
#define CAN_3_RXIMR7         CAN_3.RXIMR[7].R              /* Rx Individual Mask Registers */
#define CAN_3_RXIMR8         CAN_3.RXIMR[8].R              /* Rx Individual Mask Registers */
#define CAN_3_RXIMR9         CAN_3.RXIMR[9].R              /* Rx Individual Mask Registers */
#define CAN_3_RXIMR10        CAN_3.RXIMR[10].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR11        CAN_3.RXIMR[11].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR12        CAN_3.RXIMR[12].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR13        CAN_3.RXIMR[13].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR14        CAN_3.RXIMR[14].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR15        CAN_3.RXIMR[15].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR16        CAN_3.RXIMR[16].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR17        CAN_3.RXIMR[17].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR18        CAN_3.RXIMR[18].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR19        CAN_3.RXIMR[19].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR20        CAN_3.RXIMR[20].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR21        CAN_3.RXIMR[21].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR22        CAN_3.RXIMR[22].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR23        CAN_3.RXIMR[23].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR24        CAN_3.RXIMR[24].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR25        CAN_3.RXIMR[25].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR26        CAN_3.RXIMR[26].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR27        CAN_3.RXIMR[27].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR28        CAN_3.RXIMR[28].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR29        CAN_3.RXIMR[29].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR30        CAN_3.RXIMR[30].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR31        CAN_3.RXIMR[31].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR32        CAN_3.RXIMR[32].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR33        CAN_3.RXIMR[33].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR34        CAN_3.RXIMR[34].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR35        CAN_3.RXIMR[35].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR36        CAN_3.RXIMR[36].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR37        CAN_3.RXIMR[37].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR38        CAN_3.RXIMR[38].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR39        CAN_3.RXIMR[39].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR40        CAN_3.RXIMR[40].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR41        CAN_3.RXIMR[41].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR42        CAN_3.RXIMR[42].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR43        CAN_3.RXIMR[43].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR44        CAN_3.RXIMR[44].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR45        CAN_3.RXIMR[45].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR46        CAN_3.RXIMR[46].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR47        CAN_3.RXIMR[47].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR48        CAN_3.RXIMR[48].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR49        CAN_3.RXIMR[49].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR50        CAN_3.RXIMR[50].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR51        CAN_3.RXIMR[51].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR52        CAN_3.RXIMR[52].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR53        CAN_3.RXIMR[53].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR54        CAN_3.RXIMR[54].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR55        CAN_3.RXIMR[55].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR56        CAN_3.RXIMR[56].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR57        CAN_3.RXIMR[57].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR58        CAN_3.RXIMR[58].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR59        CAN_3.RXIMR[59].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR60        CAN_3.RXIMR[60].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR61        CAN_3.RXIMR[61].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR62        CAN_3.RXIMR[62].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR63        CAN_3.RXIMR[63].R             /* Rx Individual Mask Registers */
#define CAN_3_MECR           CAN_3.MECR.R                  /* Memory Error Control Register */
#define CAN_3_ERRIAR         CAN_3.ERRIAR.R                /* Error Injection Address Register */
#define CAN_3_ERRIDPR        CAN_3.ERRIDPR.R               /* Error Injection Data Pattern Register */
#define CAN_3_ERRIPPR        CAN_3.ERRIPPR.R               /* Error Injection Parity Pattern Register */
#define CAN_3_RERRAR         CAN_3.RERRAR.R                /* Error Report Address Register */
#define CAN_3_RERRDR         CAN_3.RERRDR.R                /* Error Report Data Register */
#define CAN_3_RERRSYNR       CAN_3.RERRSYNR.R              /* Error Report Syndrome Register */
#define CAN_3_ERRSR          CAN_3.ERRSR.R                 /* Error Status Register */

/* CMU */
#define CMU_ADCSD_CSR        CMU_ADCSD.CSR.R               /* CMU Control Status Register */
#define CMU_ADCSD_FDR        CMU_ADCSD.FDR.R               /* CMU Frequency Display Register */
#define CMU_ADCSD_HFREFR     CMU_ADCSD.HFREFR.R            /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_ADCSD_LFREFR     CMU_ADCSD.LFREFR.R            /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_ADCSD_ISR        CMU_ADCSD.ISR.R               /* CMU Interrupt Status Register */
#define CMU_ADCSD_MDR        CMU_ADCSD.MDR.R               /* CMU Measurement Duration Register */

/* CMU */
#define CMU_AIPS_CSR         CMU_AIPS.CSR.R                /* CMU Control Status Register */
#define CMU_AIPS_FDR         CMU_AIPS.FDR.R                /* CMU Frequency Display Register */
#define CMU_AIPS_HFREFR      CMU_AIPS.HFREFR.R             /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_AIPS_LFREFR      CMU_AIPS.LFREFR.R             /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_AIPS_ISR         CMU_AIPS.ISR.R                /* CMU Interrupt Status Register */
#define CMU_AIPS_MDR         CMU_AIPS.MDR.R                /* CMU Measurement Duration Register */

/* CMU */
#define CMU_CLKOUT_CSR       CMU_CLKOUT.CSR.R              /* CMU Control Status Register */
#define CMU_CLKOUT_FDR       CMU_CLKOUT.FDR.R              /* CMU Frequency Display Register */
#define CMU_CLKOUT_HFREFR    CMU_CLKOUT.HFREFR.R           /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_CLKOUT_LFREFR    CMU_CLKOUT.LFREFR.R           /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_CLKOUT_ISR       CMU_CLKOUT.ISR.R              /* CMU Interrupt Status Register */
#define CMU_CLKOUT_MDR       CMU_CLKOUT.MDR.R              /* CMU Measurement Duration Register */

/* CMU */
#define CMU_FXBAR_CSR        CMU_FXBAR.CSR.R               /* CMU Control Status Register */
#define CMU_FXBAR_FDR        CMU_FXBAR.FDR.R               /* CMU Frequency Display Register */
#define CMU_FXBAR_HFREFR     CMU_FXBAR.HFREFR.R            /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_FXBAR_LFREFR     CMU_FXBAR.LFREFR.R            /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_FXBAR_ISR        CMU_FXBAR.ISR.R               /* CMU Interrupt Status Register */
#define CMU_FXBAR_MDR        CMU_FXBAR.MDR.R               /* CMU Measurement Duration Register */

/* CMU */
#define CMU_PER_CSR          CMU_PER.CSR.R                 /* CMU Control Status Register */
#define CMU_PER_FDR          CMU_PER.FDR.R                 /* CMU Frequency Display Register */
#define CMU_PER_HFREFR       CMU_PER.HFREFR.R              /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_PER_LFREFR       CMU_PER.LFREFR.R              /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_PER_ISR          CMU_PER.ISR.R                 /* CMU Interrupt Status Register */
#define CMU_PER_MDR          CMU_PER.MDR.R                 /* CMU Measurement Duration Register */

/* CMU */
#define CMU_PLL_CSR          CMU_PLL.CSR.R                 /* CMU Control Status Register */
#define CMU_PLL_FDR          CMU_PLL.FDR.R                 /* CMU Frequency Display Register */
#define CMU_PLL_HFREFR       CMU_PLL.HFREFR.R              /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_PLL_LFREFR       CMU_PLL.LFREFR.R              /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_PLL_ISR          CMU_PLL.ISR.R                 /* CMU Interrupt Status Register */
#define CMU_PLL_MDR          CMU_PLL.MDR.R                 /* CMU Measurement Duration Register */

/* CMU */
#define CMU_SARADC_CSR       CMU_SARADC.CSR.R              /* CMU Control Status Register */
#define CMU_SARADC_FDR       CMU_SARADC.FDR.R              /* CMU Frequency Display Register */
#define CMU_SARADC_HFREFR    CMU_SARADC.HFREFR.R           /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_SARADC_LFREFR    CMU_SARADC.LFREFR.R           /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_SARADC_ISR       CMU_SARADC.ISR.R              /* CMU Interrupt Status Register */
#define CMU_SARADC_MDR       CMU_SARADC.MDR.R              /* CMU Measurement Duration Register */

/* CMU */
#define CMU_SENT_CSR         CMU_SENT.CSR.R                /* CMU Control Status Register */
#define CMU_SENT_FDR         CMU_SENT.FDR.R                /* CMU Frequency Display Register */
#define CMU_SENT_HFREFR      CMU_SENT.HFREFR.R             /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_SENT_LFREFR      CMU_SENT.LFREFR.R             /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_SENT_ISR         CMU_SENT.ISR.R                /* CMU Interrupt Status Register */
#define CMU_SENT_MDR         CMU_SENT.MDR.R                /* CMU Measurement Duration Register */

/* CMU */
#define CMU_SXBAR_CSR        CMU_SXBAR.CSR.R               /* CMU Control Status Register */
#define CMU_SXBAR_FDR        CMU_SXBAR.FDR.R               /* CMU Frequency Display Register */
#define CMU_SXBAR_HFREFR     CMU_SXBAR.HFREFR.R            /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_SXBAR_LFREFR     CMU_SXBAR.LFREFR.R            /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_SXBAR_ISR        CMU_SXBAR.ISR.R               /* CMU Interrupt Status Register */
#define CMU_SXBAR_MDR        CMU_SXBAR.MDR.R               /* CMU Measurement Duration Register */

/* CMU */
#define CMU_eMIOS_CSR        CMU_eMIOS.CSR.R               /* CMU Control Status Register */
#define CMU_eMIOS_FDR        CMU_eMIOS.FDR.R               /* CMU Frequency Display Register */
#define CMU_eMIOS_HFREFR     CMU_eMIOS.HFREFR.R            /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_eMIOS_LFREFR     CMU_eMIOS.LFREFR.R            /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_eMIOS_ISR        CMU_eMIOS.ISR.R               /* CMU Interrupt Status Register */
#define CMU_eMIOS_MDR        CMU_eMIOS.MDR.R               /* CMU Measurement Duration Register */

/* CMU */
#define CMU_eTPU2_CSR        CMU_eTPU2.CSR.R               /* CMU Control Status Register */
#define CMU_eTPU2_FDR        CMU_eTPU2.FDR.R               /* CMU Frequency Display Register */
#define CMU_eTPU2_HFREFR     CMU_eTPU2.HFREFR.R            /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_eTPU2_LFREFR     CMU_eTPU2.LFREFR.R            /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_eTPU2_ISR        CMU_eTPU2.ISR.R               /* CMU Interrupt Status Register */
#define CMU_eTPU2_MDR        CMU_eTPU2.MDR.R               /* CMU Measurement Duration Register */

/* CRC */
#define CRC_0_CFG            CRC_0.CFG.R                   /* Configuration Register */
#define CRC_0_INP            CRC_0.INP.R                   /* Input Register */
#define CRC_0_CSTAT          CRC_0.CSTAT.R                 /* Current Status Register */
#define CRC_0_OUTP           CRC_0.OUTP.R                  /* Output Register */

/* CRC */
#define CRC_1_CFG            CRC_1.CFG.R                   /* Configuration Register */
#define CRC_1_INP            CRC_1.INP.R                   /* Input Register */
#define CRC_1_CSTAT          CRC_1.CSTAT.R                 /* Current Status Register */
#define CRC_1_OUTP           CRC_1.OUTP.R                  /* Output Register */

/* DECFILTER */
#define DECFILTER_0_MCR      DECFILTER_0.MCR.R             /* Module Configuration Register */
#define DECFILTER_0_MSR      DECFILTER_0.MSR.R             /* Module Status Register */
#define DECFILTER_0_MXCR     DECFILTER_0.MXCR.R            /* Module Extended Config Register */
#define DECFILTER_0_MXSR     DECFILTER_0.MXSR.R            /* Module Extended Status Register */
#define DECFILTER_0_IB       DECFILTER_0.IB.R              /* Interface Input Buffer */
#define DECFILTER_0_OB       DECFILTER_0.OB.R              /* Interface Output Buffer */
#define DECFILTER_0_COEF0    DECFILTER_0.COEF[0].R         /* Filter Coefficient */
#define DECFILTER_0_COEF1    DECFILTER_0.COEF[1].R         /* Filter Coefficient */
#define DECFILTER_0_COEF2    DECFILTER_0.COEF[2].R         /* Filter Coefficient */
#define DECFILTER_0_COEF3    DECFILTER_0.COEF[3].R         /* Filter Coefficient */
#define DECFILTER_0_COEF4    DECFILTER_0.COEF[4].R         /* Filter Coefficient */
#define DECFILTER_0_COEF5    DECFILTER_0.COEF[5].R         /* Filter Coefficient */
#define DECFILTER_0_COEF6    DECFILTER_0.COEF[6].R         /* Filter Coefficient */
#define DECFILTER_0_COEF7    DECFILTER_0.COEF[7].R         /* Filter Coefficient */
#define DECFILTER_0_COEF8    DECFILTER_0.COEF[8].R         /* Filter Coefficient */
#define DECFILTER_0_TAP0     DECFILTER_0.TAP[0].R          /* Filter TAP */
#define DECFILTER_0_TAP1     DECFILTER_0.TAP[1].R          /* Filter TAP */
#define DECFILTER_0_TAP2     DECFILTER_0.TAP[2].R          /* Filter TAP */
#define DECFILTER_0_TAP3     DECFILTER_0.TAP[3].R          /* Filter TAP */
#define DECFILTER_0_TAP4     DECFILTER_0.TAP[4].R          /* Filter TAP */
#define DECFILTER_0_TAP5     DECFILTER_0.TAP[5].R          /* Filter TAP */
#define DECFILTER_0_TAP6     DECFILTER_0.TAP[6].R          /* Filter TAP */
#define DECFILTER_0_TAP7     DECFILTER_0.TAP[7].R          /* Filter TAP */
#define DECFILTER_0_FINTVAL  DECFILTER_0.FINTVAL.R         /* Final Integer Value Register */
#define DECFILTER_0_FINTCNT  DECFILTER_0.FINTCNT.R         /* Final Integer Count Register */
#define DECFILTER_0_CINTVAL  DECFILTER_0.CINTVAL.R         /* Current Integer Value Register */
#define DECFILTER_0_CINTCNT  DECFILTER_0.CINTCNT.R         /* Current Integer Count Register */

/* DECFILTER */
#define DECFILTER_1_MCR      DECFILTER_1.MCR.R             /* Module Configuration Register */
#define DECFILTER_1_MSR      DECFILTER_1.MSR.R             /* Module Status Register */
#define DECFILTER_1_MXCR     DECFILTER_1.MXCR.R            /* Module Extended Config Register */
#define DECFILTER_1_MXSR     DECFILTER_1.MXSR.R            /* Module Extended Status Register */
#define DECFILTER_1_IB       DECFILTER_1.IB.R              /* Interface Input Buffer */
#define DECFILTER_1_OB       DECFILTER_1.OB.R              /* Interface Output Buffer */
#define DECFILTER_1_COEF0    DECFILTER_1.COEF[0].R         /* Filter Coefficient */
#define DECFILTER_1_COEF1    DECFILTER_1.COEF[1].R         /* Filter Coefficient */
#define DECFILTER_1_COEF2    DECFILTER_1.COEF[2].R         /* Filter Coefficient */
#define DECFILTER_1_COEF3    DECFILTER_1.COEF[3].R         /* Filter Coefficient */
#define DECFILTER_1_COEF4    DECFILTER_1.COEF[4].R         /* Filter Coefficient */
#define DECFILTER_1_COEF5    DECFILTER_1.COEF[5].R         /* Filter Coefficient */
#define DECFILTER_1_COEF6    DECFILTER_1.COEF[6].R         /* Filter Coefficient */
#define DECFILTER_1_COEF7    DECFILTER_1.COEF[7].R         /* Filter Coefficient */
#define DECFILTER_1_COEF8    DECFILTER_1.COEF[8].R         /* Filter Coefficient */
#define DECFILTER_1_TAP0     DECFILTER_1.TAP[0].R          /* Filter TAP */
#define DECFILTER_1_TAP1     DECFILTER_1.TAP[1].R          /* Filter TAP */
#define DECFILTER_1_TAP2     DECFILTER_1.TAP[2].R          /* Filter TAP */
#define DECFILTER_1_TAP3     DECFILTER_1.TAP[3].R          /* Filter TAP */
#define DECFILTER_1_TAP4     DECFILTER_1.TAP[4].R          /* Filter TAP */
#define DECFILTER_1_TAP5     DECFILTER_1.TAP[5].R          /* Filter TAP */
#define DECFILTER_1_TAP6     DECFILTER_1.TAP[6].R          /* Filter TAP */
#define DECFILTER_1_TAP7     DECFILTER_1.TAP[7].R          /* Filter TAP */
#define DECFILTER_1_FINTVAL  DECFILTER_1.FINTVAL.R         /* Final Integer Value Register */
#define DECFILTER_1_FINTCNT  DECFILTER_1.FINTCNT.R         /* Final Integer Count Register */
#define DECFILTER_1_CINTVAL  DECFILTER_1.CINTVAL.R         /* Current Integer Value Register */
#define DECFILTER_1_CINTCNT  DECFILTER_1.CINTCNT.R         /* Current Integer Count Register */

/* DMAMUX */
#define DMAMUX_0_CHCFG0      DMAMUX_0.CHCFG[0].R           /* Channel Configuration register */
#define DMAMUX_0_CHCFG1      DMAMUX_0.CHCFG[1].R           /* Channel Configuration register */
#define DMAMUX_0_CHCFG2      DMAMUX_0.CHCFG[2].R           /* Channel Configuration register */
#define DMAMUX_0_CHCFG3      DMAMUX_0.CHCFG[3].R           /* Channel Configuration register */
#define DMAMUX_0_CHCFG4      DMAMUX_0.CHCFG[4].R           /* Channel Configuration register */
#define DMAMUX_0_CHCFG5      DMAMUX_0.CHCFG[5].R           /* Channel Configuration register */
#define DMAMUX_0_CHCFG6      DMAMUX_0.CHCFG[6].R           /* Channel Configuration register */
#define DMAMUX_0_CHCFG7      DMAMUX_0.CHCFG[7].R           /* Channel Configuration register */
#define DMAMUX_0_CHCFG8      DMAMUX_0.CHCFG[8].R           /* Channel Configuration register */
#define DMAMUX_0_CHCFG9      DMAMUX_0.CHCFG[9].R           /* Channel Configuration register */
#define DMAMUX_0_CHCFG10     DMAMUX_0.CHCFG[10].R          /* Channel Configuration register */
#define DMAMUX_0_CHCFG11     DMAMUX_0.CHCFG[11].R          /* Channel Configuration register */
#define DMAMUX_0_CHCFG12     DMAMUX_0.CHCFG[12].R          /* Channel Configuration register */
#define DMAMUX_0_CHCFG13     DMAMUX_0.CHCFG[13].R          /* Channel Configuration register */
#define DMAMUX_0_CHCFG14     DMAMUX_0.CHCFG[14].R          /* Channel Configuration register */
#define DMAMUX_0_CHCFG15     DMAMUX_0.CHCFG[15].R          /* Channel Configuration register */

/* DMAMUX */
#define DMAMUX_1_CHCFG0      DMAMUX_1.CHCFG[0].R           /* Channel Configuration register */
#define DMAMUX_1_CHCFG1      DMAMUX_1.CHCFG[1].R           /* Channel Configuration register */
#define DMAMUX_1_CHCFG2      DMAMUX_1.CHCFG[2].R           /* Channel Configuration register */
#define DMAMUX_1_CHCFG3      DMAMUX_1.CHCFG[3].R           /* Channel Configuration register */
#define DMAMUX_1_CHCFG4      DMAMUX_1.CHCFG[4].R           /* Channel Configuration register */
#define DMAMUX_1_CHCFG5      DMAMUX_1.CHCFG[5].R           /* Channel Configuration register */
#define DMAMUX_1_CHCFG6      DMAMUX_1.CHCFG[6].R           /* Channel Configuration register */
#define DMAMUX_1_CHCFG7      DMAMUX_1.CHCFG[7].R           /* Channel Configuration register */
#define DMAMUX_1_CHCFG8      DMAMUX_1.CHCFG[8].R           /* Channel Configuration register */
#define DMAMUX_1_CHCFG9      DMAMUX_1.CHCFG[9].R           /* Channel Configuration register */
#define DMAMUX_1_CHCFG10     DMAMUX_1.CHCFG[10].R          /* Channel Configuration register */
#define DMAMUX_1_CHCFG11     DMAMUX_1.CHCFG[11].R          /* Channel Configuration register */
#define DMAMUX_1_CHCFG12     DMAMUX_1.CHCFG[12].R          /* Channel Configuration register */
#define DMAMUX_1_CHCFG13     DMAMUX_1.CHCFG[13].R          /* Channel Configuration register */
#define DMAMUX_1_CHCFG14     DMAMUX_1.CHCFG[14].R          /* Channel Configuration register */
#define DMAMUX_1_CHCFG15     DMAMUX_1.CHCFG[15].R          /* Channel Configuration register */

/* DMAMUX */
#define DMAMUX_2_CHCFG0      DMAMUX_2.CHCFG[0].R           /* Channel Configuration register */
#define DMAMUX_2_CHCFG1      DMAMUX_2.CHCFG[1].R           /* Channel Configuration register */
#define DMAMUX_2_CHCFG2      DMAMUX_2.CHCFG[2].R           /* Channel Configuration register */
#define DMAMUX_2_CHCFG3      DMAMUX_2.CHCFG[3].R           /* Channel Configuration register */
#define DMAMUX_2_CHCFG4      DMAMUX_2.CHCFG[4].R           /* Channel Configuration register */
#define DMAMUX_2_CHCFG5      DMAMUX_2.CHCFG[5].R           /* Channel Configuration register */
#define DMAMUX_2_CHCFG6      DMAMUX_2.CHCFG[6].R           /* Channel Configuration register */
#define DMAMUX_2_CHCFG7      DMAMUX_2.CHCFG[7].R           /* Channel Configuration register */
#define DMAMUX_2_CHCFG8      DMAMUX_2.CHCFG[8].R           /* Channel Configuration register */
#define DMAMUX_2_CHCFG9      DMAMUX_2.CHCFG[9].R           /* Channel Configuration register */
#define DMAMUX_2_CHCFG10     DMAMUX_2.CHCFG[10].R          /* Channel Configuration register */
#define DMAMUX_2_CHCFG11     DMAMUX_2.CHCFG[11].R          /* Channel Configuration register */
#define DMAMUX_2_CHCFG12     DMAMUX_2.CHCFG[12].R          /* Channel Configuration register */
#define DMAMUX_2_CHCFG13     DMAMUX_2.CHCFG[13].R          /* Channel Configuration register */
#define DMAMUX_2_CHCFG14     DMAMUX_2.CHCFG[14].R          /* Channel Configuration register */
#define DMAMUX_2_CHCFG15     DMAMUX_2.CHCFG[15].R          /* Channel Configuration register */

/* DMAMUX */
#define DMAMUX_3_CHCFG0      DMAMUX_3.CHCFG[0].R           /* Channel Configuration register */
#define DMAMUX_3_CHCFG1      DMAMUX_3.CHCFG[1].R           /* Channel Configuration register */
#define DMAMUX_3_CHCFG2      DMAMUX_3.CHCFG[2].R           /* Channel Configuration register */
#define DMAMUX_3_CHCFG3      DMAMUX_3.CHCFG[3].R           /* Channel Configuration register */
#define DMAMUX_3_CHCFG4      DMAMUX_3.CHCFG[4].R           /* Channel Configuration register */
#define DMAMUX_3_CHCFG5      DMAMUX_3.CHCFG[5].R           /* Channel Configuration register */
#define DMAMUX_3_CHCFG6      DMAMUX_3.CHCFG[6].R           /* Channel Configuration register */
#define DMAMUX_3_CHCFG7      DMAMUX_3.CHCFG[7].R           /* Channel Configuration register */
#define DMAMUX_3_CHCFG8      DMAMUX_3.CHCFG[8].R           /* Channel Configuration register */
#define DMAMUX_3_CHCFG9      DMAMUX_3.CHCFG[9].R           /* Channel Configuration register */
#define DMAMUX_3_CHCFG10     DMAMUX_3.CHCFG[10].R          /* Channel Configuration register */
#define DMAMUX_3_CHCFG11     DMAMUX_3.CHCFG[11].R          /* Channel Configuration register */
#define DMAMUX_3_CHCFG12     DMAMUX_3.CHCFG[12].R          /* Channel Configuration register */
#define DMAMUX_3_CHCFG13     DMAMUX_3.CHCFG[13].R          /* Channel Configuration register */
#define DMAMUX_3_CHCFG14     DMAMUX_3.CHCFG[14].R          /* Channel Configuration register */
#define DMAMUX_3_CHCFG15     DMAMUX_3.CHCFG[15].R          /* Channel Configuration register */

/* DMA */
#define DMA_0_CR             DMA_0.CR.R                    /* Control Register */
#define DMA_0_ES             DMA_0.ES.R                    /* Error Status Register */
#define DMA_0_ERQH           DMA_0.ERQH.R                  /* Enable Request Register High */
#define DMA_0_ERQL           DMA_0.ERQL.R                  /* Enable Request Register Low */
#define DMA_0_EEIH           DMA_0.EEIH.R                  /* Enable Error Interrupt Register High */
#define DMA_0_EEIL           DMA_0.EEIL.R                  /* Enable Error Interrupt Register High */
#define DMA_0_SERQ           DMA_0.SERQ.R                  /* Set Enable Request Register */
#define DMA_0_CERQ           DMA_0.CERQ.R                  /* Clear Enable Request Register */
#define DMA_0_SEEI           DMA_0.SEEI.R                  /* Set Enable Error Interrupt Register */
#define DMA_0_CEEI           DMA_0.CEEI.R                  /* Clear Enable Error Interrupt Register */
#define DMA_0_CINT           DMA_0.CINT.R                  /* Clear Interrupt Request Register */
#define DMA_0_CERR           DMA_0.CERR.R                  /* Clear Error Register */
#define DMA_0_SSRT           DMA_0.SSRT.R                  /* Set START Bit Register */
#define DMA_0_CDNE           DMA_0.CDNE.R                  /* Clear DONE Status Bit Register */
#define DMA_0_INTH           DMA_0.INTH.R                  /* Interrupt Request Register High */
#define DMA_0_INTL           DMA_0.INTL.R                  /* Interrupt Request Register Low */
#define DMA_0_ERRH           DMA_0.ERRH.R                  /* Error Register High */
#define DMA_0_ERRL           DMA_0.ERRL.R                  /* Error Register Low */
#define DMA_0_HRSH           DMA_0.HRSH.R                  /* Hardware Request Status Register High */
#define DMA_0_HRSL           DMA_0.HRSL.R                  /* Hardware Request Status Register Low */
#define DMA_0_DCHPRI0        DMA_0.DCHPRI[0].R             /* Channel n Priority Register */
#define DMA_0_DCHPRI1        DMA_0.DCHPRI[1].R             /* Channel n Priority Register */
#define DMA_0_DCHPRI2        DMA_0.DCHPRI[2].R             /* Channel n Priority Register */
#define DMA_0_DCHPRI3        DMA_0.DCHPRI[3].R             /* Channel n Priority Register */
#define DMA_0_DCHPRI4        DMA_0.DCHPRI[4].R             /* Channel n Priority Register */
#define DMA_0_DCHPRI5        DMA_0.DCHPRI[5].R             /* Channel n Priority Register */
#define DMA_0_DCHPRI6        DMA_0.DCHPRI[6].R             /* Channel n Priority Register */
#define DMA_0_DCHPRI7        DMA_0.DCHPRI[7].R             /* Channel n Priority Register */
#define DMA_0_DCHPRI8        DMA_0.DCHPRI[8].R             /* Channel n Priority Register */
#define DMA_0_DCHPRI9        DMA_0.DCHPRI[9].R             /* Channel n Priority Register */
#define DMA_0_DCHPRI10       DMA_0.DCHPRI[10].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI11       DMA_0.DCHPRI[11].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI12       DMA_0.DCHPRI[12].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI13       DMA_0.DCHPRI[13].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI14       DMA_0.DCHPRI[14].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI15       DMA_0.DCHPRI[15].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI16       DMA_0.DCHPRI[16].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI17       DMA_0.DCHPRI[17].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI18       DMA_0.DCHPRI[18].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI19       DMA_0.DCHPRI[19].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI20       DMA_0.DCHPRI[20].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI21       DMA_0.DCHPRI[21].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI22       DMA_0.DCHPRI[22].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI23       DMA_0.DCHPRI[23].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI24       DMA_0.DCHPRI[24].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI25       DMA_0.DCHPRI[25].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI26       DMA_0.DCHPRI[26].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI27       DMA_0.DCHPRI[27].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI28       DMA_0.DCHPRI[28].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI29       DMA_0.DCHPRI[29].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI30       DMA_0.DCHPRI[30].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI31       DMA_0.DCHPRI[31].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI32       DMA_0.DCHPRI[32].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI33       DMA_0.DCHPRI[33].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI34       DMA_0.DCHPRI[34].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI35       DMA_0.DCHPRI[35].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI36       DMA_0.DCHPRI[36].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI37       DMA_0.DCHPRI[37].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI38       DMA_0.DCHPRI[38].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI39       DMA_0.DCHPRI[39].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI40       DMA_0.DCHPRI[40].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI41       DMA_0.DCHPRI[41].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI42       DMA_0.DCHPRI[42].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI43       DMA_0.DCHPRI[43].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI44       DMA_0.DCHPRI[44].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI45       DMA_0.DCHPRI[45].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI46       DMA_0.DCHPRI[46].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI47       DMA_0.DCHPRI[47].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI48       DMA_0.DCHPRI[48].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI49       DMA_0.DCHPRI[49].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI50       DMA_0.DCHPRI[50].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI51       DMA_0.DCHPRI[51].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI52       DMA_0.DCHPRI[52].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI53       DMA_0.DCHPRI[53].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI54       DMA_0.DCHPRI[54].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI55       DMA_0.DCHPRI[55].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI56       DMA_0.DCHPRI[56].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI57       DMA_0.DCHPRI[57].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI58       DMA_0.DCHPRI[58].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI59       DMA_0.DCHPRI[59].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI60       DMA_0.DCHPRI[60].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI61       DMA_0.DCHPRI[61].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI62       DMA_0.DCHPRI[62].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI63       DMA_0.DCHPRI[63].R            /* Channel n Priority Register */
#define DMA_0_DCHMID0        DMA_0.DCHMID[0].R             /* Channel n Master ID Register */
#define DMA_0_DCHMID1        DMA_0.DCHMID[1].R             /* Channel n Master ID Register */
#define DMA_0_DCHMID2        DMA_0.DCHMID[2].R             /* Channel n Master ID Register */
#define DMA_0_DCHMID3        DMA_0.DCHMID[3].R             /* Channel n Master ID Register */
#define DMA_0_DCHMID4        DMA_0.DCHMID[4].R             /* Channel n Master ID Register */
#define DMA_0_DCHMID5        DMA_0.DCHMID[5].R             /* Channel n Master ID Register */
#define DMA_0_DCHMID6        DMA_0.DCHMID[6].R             /* Channel n Master ID Register */
#define DMA_0_DCHMID7        DMA_0.DCHMID[7].R             /* Channel n Master ID Register */
#define DMA_0_DCHMID8        DMA_0.DCHMID[8].R             /* Channel n Master ID Register */
#define DMA_0_DCHMID9        DMA_0.DCHMID[9].R             /* Channel n Master ID Register */
#define DMA_0_DCHMID10       DMA_0.DCHMID[10].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID11       DMA_0.DCHMID[11].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID12       DMA_0.DCHMID[12].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID13       DMA_0.DCHMID[13].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID14       DMA_0.DCHMID[14].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID15       DMA_0.DCHMID[15].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID16       DMA_0.DCHMID[16].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID17       DMA_0.DCHMID[17].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID18       DMA_0.DCHMID[18].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID19       DMA_0.DCHMID[19].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID20       DMA_0.DCHMID[20].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID21       DMA_0.DCHMID[21].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID22       DMA_0.DCHMID[22].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID23       DMA_0.DCHMID[23].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID24       DMA_0.DCHMID[24].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID25       DMA_0.DCHMID[25].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID26       DMA_0.DCHMID[26].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID27       DMA_0.DCHMID[27].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID28       DMA_0.DCHMID[28].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID29       DMA_0.DCHMID[29].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID30       DMA_0.DCHMID[30].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID31       DMA_0.DCHMID[31].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID32       DMA_0.DCHMID[32].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID33       DMA_0.DCHMID[33].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID34       DMA_0.DCHMID[34].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID35       DMA_0.DCHMID[35].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID36       DMA_0.DCHMID[36].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID37       DMA_0.DCHMID[37].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID38       DMA_0.DCHMID[38].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID39       DMA_0.DCHMID[39].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID40       DMA_0.DCHMID[40].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID41       DMA_0.DCHMID[41].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID42       DMA_0.DCHMID[42].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID43       DMA_0.DCHMID[43].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID44       DMA_0.DCHMID[44].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID45       DMA_0.DCHMID[45].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID46       DMA_0.DCHMID[46].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID47       DMA_0.DCHMID[47].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID48       DMA_0.DCHMID[48].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID49       DMA_0.DCHMID[49].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID50       DMA_0.DCHMID[50].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID51       DMA_0.DCHMID[51].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID52       DMA_0.DCHMID[52].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID53       DMA_0.DCHMID[53].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID54       DMA_0.DCHMID[54].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID55       DMA_0.DCHMID[55].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID56       DMA_0.DCHMID[56].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID57       DMA_0.DCHMID[57].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID58       DMA_0.DCHMID[58].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID59       DMA_0.DCHMID[59].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID60       DMA_0.DCHMID[60].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID61       DMA_0.DCHMID[61].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID62       DMA_0.DCHMID[62].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID63       DMA_0.DCHMID[63].R            /* Channel n Master ID Register */
#define DMA_0_TCD0_WORD_0    DMA_0.TCD[0].WORD_0.R         /* TCD Source Address */
#define DMA_0_TCD0_WORD_1    DMA_0.TCD[0].WORD_1.R         /* TCD Transfer Attributes */
#define DMA_0_TCD0_WORD_2    DMA_0.TCD[0].WORD_2.R         /* TCD Number of bytes to be transferred */
#define DMA_0_TCD0_WORD_3    DMA_0.TCD[0].WORD_3.R         /* TCD Last Source Address Adjustment */
#define DMA_0_TCD0_WORD_4    DMA_0.TCD[0].WORD_4.R         /* TCD Destination Address */
#define DMA_0_TCD0_WORD_5    DMA_0.TCD[0].WORD_5.R         /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD0_WORD_6    DMA_0.TCD[0].WORD_6.R         /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD0_WORD_7    DMA_0.TCD[0].WORD_7.R         /* TCD Control and Status */
#define DMA_0_TCD1_WORD_0    DMA_0.TCD[1].WORD_0.R         /* TCD Source Address */
#define DMA_0_TCD1_WORD_1    DMA_0.TCD[1].WORD_1.R         /* TCD Transfer Attributes */
#define DMA_0_TCD1_WORD_2    DMA_0.TCD[1].WORD_2.R         /* TCD Number of bytes to be transferred */
#define DMA_0_TCD1_WORD_3    DMA_0.TCD[1].WORD_3.R         /* TCD Last Source Address Adjustment */
#define DMA_0_TCD1_WORD_4    DMA_0.TCD[1].WORD_4.R         /* TCD Destination Address */
#define DMA_0_TCD1_WORD_5    DMA_0.TCD[1].WORD_5.R         /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD1_WORD_6    DMA_0.TCD[1].WORD_6.R         /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD1_WORD_7    DMA_0.TCD[1].WORD_7.R         /* TCD Control and Status */
#define DMA_0_TCD2_WORD_0    DMA_0.TCD[2].WORD_0.R         /* TCD Source Address */
#define DMA_0_TCD2_WORD_1    DMA_0.TCD[2].WORD_1.R         /* TCD Transfer Attributes */
#define DMA_0_TCD2_WORD_2    DMA_0.TCD[2].WORD_2.R         /* TCD Number of bytes to be transferred */
#define DMA_0_TCD2_WORD_3    DMA_0.TCD[2].WORD_3.R         /* TCD Last Source Address Adjustment */
#define DMA_0_TCD2_WORD_4    DMA_0.TCD[2].WORD_4.R         /* TCD Destination Address */
#define DMA_0_TCD2_WORD_5    DMA_0.TCD[2].WORD_5.R         /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD2_WORD_6    DMA_0.TCD[2].WORD_6.R         /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD2_WORD_7    DMA_0.TCD[2].WORD_7.R         /* TCD Control and Status */
#define DMA_0_TCD3_WORD_0    DMA_0.TCD[3].WORD_0.R         /* TCD Source Address */
#define DMA_0_TCD3_WORD_1    DMA_0.TCD[3].WORD_1.R         /* TCD Transfer Attributes */
#define DMA_0_TCD3_WORD_2    DMA_0.TCD[3].WORD_2.R         /* TCD Number of bytes to be transferred */
#define DMA_0_TCD3_WORD_3    DMA_0.TCD[3].WORD_3.R         /* TCD Last Source Address Adjustment */
#define DMA_0_TCD3_WORD_4    DMA_0.TCD[3].WORD_4.R         /* TCD Destination Address */
#define DMA_0_TCD3_WORD_5    DMA_0.TCD[3].WORD_5.R         /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD3_WORD_6    DMA_0.TCD[3].WORD_6.R         /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD3_WORD_7    DMA_0.TCD[3].WORD_7.R         /* TCD Control and Status */
#define DMA_0_TCD4_WORD_0    DMA_0.TCD[4].WORD_0.R         /* TCD Source Address */
#define DMA_0_TCD4_WORD_1    DMA_0.TCD[4].WORD_1.R         /* TCD Transfer Attributes */
#define DMA_0_TCD4_WORD_2    DMA_0.TCD[4].WORD_2.R         /* TCD Number of bytes to be transferred */
#define DMA_0_TCD4_WORD_3    DMA_0.TCD[4].WORD_3.R         /* TCD Last Source Address Adjustment */
#define DMA_0_TCD4_WORD_4    DMA_0.TCD[4].WORD_4.R         /* TCD Destination Address */
#define DMA_0_TCD4_WORD_5    DMA_0.TCD[4].WORD_5.R         /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD4_WORD_6    DMA_0.TCD[4].WORD_6.R         /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD4_WORD_7    DMA_0.TCD[4].WORD_7.R         /* TCD Control and Status */
#define DMA_0_TCD5_WORD_0    DMA_0.TCD[5].WORD_0.R         /* TCD Source Address */
#define DMA_0_TCD5_WORD_1    DMA_0.TCD[5].WORD_1.R         /* TCD Transfer Attributes */
#define DMA_0_TCD5_WORD_2    DMA_0.TCD[5].WORD_2.R         /* TCD Number of bytes to be transferred */
#define DMA_0_TCD5_WORD_3    DMA_0.TCD[5].WORD_3.R         /* TCD Last Source Address Adjustment */
#define DMA_0_TCD5_WORD_4    DMA_0.TCD[5].WORD_4.R         /* TCD Destination Address */
#define DMA_0_TCD5_WORD_5    DMA_0.TCD[5].WORD_5.R         /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD5_WORD_6    DMA_0.TCD[5].WORD_6.R         /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD5_WORD_7    DMA_0.TCD[5].WORD_7.R         /* TCD Control and Status */
#define DMA_0_TCD6_WORD_0    DMA_0.TCD[6].WORD_0.R         /* TCD Source Address */
#define DMA_0_TCD6_WORD_1    DMA_0.TCD[6].WORD_1.R         /* TCD Transfer Attributes */
#define DMA_0_TCD6_WORD_2    DMA_0.TCD[6].WORD_2.R         /* TCD Number of bytes to be transferred */
#define DMA_0_TCD6_WORD_3    DMA_0.TCD[6].WORD_3.R         /* TCD Last Source Address Adjustment */
#define DMA_0_TCD6_WORD_4    DMA_0.TCD[6].WORD_4.R         /* TCD Destination Address */
#define DMA_0_TCD6_WORD_5    DMA_0.TCD[6].WORD_5.R         /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD6_WORD_6    DMA_0.TCD[6].WORD_6.R         /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD6_WORD_7    DMA_0.TCD[6].WORD_7.R         /* TCD Control and Status */
#define DMA_0_TCD7_WORD_0    DMA_0.TCD[7].WORD_0.R         /* TCD Source Address */
#define DMA_0_TCD7_WORD_1    DMA_0.TCD[7].WORD_1.R         /* TCD Transfer Attributes */
#define DMA_0_TCD7_WORD_2    DMA_0.TCD[7].WORD_2.R         /* TCD Number of bytes to be transferred */
#define DMA_0_TCD7_WORD_3    DMA_0.TCD[7].WORD_3.R         /* TCD Last Source Address Adjustment */
#define DMA_0_TCD7_WORD_4    DMA_0.TCD[7].WORD_4.R         /* TCD Destination Address */
#define DMA_0_TCD7_WORD_5    DMA_0.TCD[7].WORD_5.R         /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD7_WORD_6    DMA_0.TCD[7].WORD_6.R         /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD7_WORD_7    DMA_0.TCD[7].WORD_7.R         /* TCD Control and Status */
#define DMA_0_TCD8_WORD_0    DMA_0.TCD[8].WORD_0.R         /* TCD Source Address */
#define DMA_0_TCD8_WORD_1    DMA_0.TCD[8].WORD_1.R         /* TCD Transfer Attributes */
#define DMA_0_TCD8_WORD_2    DMA_0.TCD[8].WORD_2.R         /* TCD Number of bytes to be transferred */
#define DMA_0_TCD8_WORD_3    DMA_0.TCD[8].WORD_3.R         /* TCD Last Source Address Adjustment */
#define DMA_0_TCD8_WORD_4    DMA_0.TCD[8].WORD_4.R         /* TCD Destination Address */
#define DMA_0_TCD8_WORD_5    DMA_0.TCD[8].WORD_5.R         /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD8_WORD_6    DMA_0.TCD[8].WORD_6.R         /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD8_WORD_7    DMA_0.TCD[8].WORD_7.R         /* TCD Control and Status */
#define DMA_0_TCD9_WORD_0    DMA_0.TCD[9].WORD_0.R         /* TCD Source Address */
#define DMA_0_TCD9_WORD_1    DMA_0.TCD[9].WORD_1.R         /* TCD Transfer Attributes */
#define DMA_0_TCD9_WORD_2    DMA_0.TCD[9].WORD_2.R         /* TCD Number of bytes to be transferred */
#define DMA_0_TCD9_WORD_3    DMA_0.TCD[9].WORD_3.R         /* TCD Last Source Address Adjustment */
#define DMA_0_TCD9_WORD_4    DMA_0.TCD[9].WORD_4.R         /* TCD Destination Address */
#define DMA_0_TCD9_WORD_5    DMA_0.TCD[9].WORD_5.R         /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD9_WORD_6    DMA_0.TCD[9].WORD_6.R         /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD9_WORD_7    DMA_0.TCD[9].WORD_7.R         /* TCD Control and Status */
#define DMA_0_TCD10_WORD_0   DMA_0.TCD[10].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD10_WORD_1   DMA_0.TCD[10].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD10_WORD_2   DMA_0.TCD[10].WORD_2.R        /* TCD Number of bytes to be transferred */
#define DMA_0_TCD10_WORD_3   DMA_0.TCD[10].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD10_WORD_4   DMA_0.TCD[10].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD10_WORD_5   DMA_0.TCD[10].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD10_WORD_6   DMA_0.TCD[10].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD10_WORD_7   DMA_0.TCD[10].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD11_WORD_0   DMA_0.TCD[11].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD11_WORD_1   DMA_0.TCD[11].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD11_WORD_2   DMA_0.TCD[11].WORD_2.R        /* TCD Number of bytes to be transferred */
#define DMA_0_TCD11_WORD_3   DMA_0.TCD[11].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD11_WORD_4   DMA_0.TCD[11].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD11_WORD_5   DMA_0.TCD[11].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD11_WORD_6   DMA_0.TCD[11].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD11_WORD_7   DMA_0.TCD[11].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD12_WORD_0   DMA_0.TCD[12].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD12_WORD_1   DMA_0.TCD[12].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD12_WORD_2   DMA_0.TCD[12].WORD_2.R        /* TCD Number of bytes to be transferred */
#define DMA_0_TCD12_WORD_3   DMA_0.TCD[12].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD12_WORD_4   DMA_0.TCD[12].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD12_WORD_5   DMA_0.TCD[12].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD12_WORD_6   DMA_0.TCD[12].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD12_WORD_7   DMA_0.TCD[12].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD13_WORD_0   DMA_0.TCD[13].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD13_WORD_1   DMA_0.TCD[13].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD13_WORD_2   DMA_0.TCD[13].WORD_2.R        /* TCD Number of bytes to be transferred */
#define DMA_0_TCD13_WORD_3   DMA_0.TCD[13].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD13_WORD_4   DMA_0.TCD[13].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD13_WORD_5   DMA_0.TCD[13].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD13_WORD_6   DMA_0.TCD[13].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD13_WORD_7   DMA_0.TCD[13].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD14_WORD_0   DMA_0.TCD[14].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD14_WORD_1   DMA_0.TCD[14].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD14_WORD_2   DMA_0.TCD[14].WORD_2.R        /* TCD Number of bytes to be transferred */
#define DMA_0_TCD14_WORD_3   DMA_0.TCD[14].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD14_WORD_4   DMA_0.TCD[14].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD14_WORD_5   DMA_0.TCD[14].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD14_WORD_6   DMA_0.TCD[14].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD14_WORD_7   DMA_0.TCD[14].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD15_WORD_0   DMA_0.TCD[15].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD15_WORD_1   DMA_0.TCD[15].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD15_WORD_2   DMA_0.TCD[15].WORD_2.R        /* TCD Number of bytes to be transferred */
#define DMA_0_TCD15_WORD_3   DMA_0.TCD[15].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD15_WORD_4   DMA_0.TCD[15].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD15_WORD_5   DMA_0.TCD[15].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD15_WORD_6   DMA_0.TCD[15].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD15_WORD_7   DMA_0.TCD[15].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD16_WORD_0   DMA_0.TCD[16].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD16_WORD_1   DMA_0.TCD[16].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD16_WORD_2   DMA_0.TCD[16].WORD_2.R        /* TCD Number of bytes to be transferred */
#define DMA_0_TCD16_WORD_3   DMA_0.TCD[16].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD16_WORD_4   DMA_0.TCD[16].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD16_WORD_5   DMA_0.TCD[16].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD16_WORD_6   DMA_0.TCD[16].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD16_WORD_7   DMA_0.TCD[16].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD17_WORD_0   DMA_0.TCD[17].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD17_WORD_1   DMA_0.TCD[17].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD17_WORD_2   DMA_0.TCD[17].WORD_2.R        /* TCD Number of bytes to be transferred */
#define DMA_0_TCD17_WORD_3   DMA_0.TCD[17].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD17_WORD_4   DMA_0.TCD[17].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD17_WORD_5   DMA_0.TCD[17].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD17_WORD_6   DMA_0.TCD[17].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD17_WORD_7   DMA_0.TCD[17].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD18_WORD_0   DMA_0.TCD[18].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD18_WORD_1   DMA_0.TCD[18].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD18_WORD_2   DMA_0.TCD[18].WORD_2.R        /* TCD Number of bytes to be transferred */
#define DMA_0_TCD18_WORD_3   DMA_0.TCD[18].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD18_WORD_4   DMA_0.TCD[18].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD18_WORD_5   DMA_0.TCD[18].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD18_WORD_6   DMA_0.TCD[18].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD18_WORD_7   DMA_0.TCD[18].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD19_WORD_0   DMA_0.TCD[19].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD19_WORD_1   DMA_0.TCD[19].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD19_WORD_2   DMA_0.TCD[19].WORD_2.R        /* TCD Number of bytes to be transferred */
#define DMA_0_TCD19_WORD_3   DMA_0.TCD[19].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD19_WORD_4   DMA_0.TCD[19].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD19_WORD_5   DMA_0.TCD[19].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD19_WORD_6   DMA_0.TCD[19].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD19_WORD_7   DMA_0.TCD[19].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD20_WORD_0   DMA_0.TCD[20].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD20_WORD_1   DMA_0.TCD[20].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD20_WORD_2   DMA_0.TCD[20].WORD_2.R        /* TCD Number of bytes to be transferred */
#define DMA_0_TCD20_WORD_3   DMA_0.TCD[20].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD20_WORD_4   DMA_0.TCD[20].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD20_WORD_5   DMA_0.TCD[20].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD20_WORD_6   DMA_0.TCD[20].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD20_WORD_7   DMA_0.TCD[20].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD21_WORD_0   DMA_0.TCD[21].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD21_WORD_1   DMA_0.TCD[21].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD21_WORD_2   DMA_0.TCD[21].WORD_2.R        /* TCD Number of bytes to be transferred */
#define DMA_0_TCD21_WORD_3   DMA_0.TCD[21].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD21_WORD_4   DMA_0.TCD[21].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD21_WORD_5   DMA_0.TCD[21].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD21_WORD_6   DMA_0.TCD[21].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD21_WORD_7   DMA_0.TCD[21].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD22_WORD_0   DMA_0.TCD[22].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD22_WORD_1   DMA_0.TCD[22].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD22_WORD_2   DMA_0.TCD[22].WORD_2.R        /* TCD Number of bytes to be transferred */
#define DMA_0_TCD22_WORD_3   DMA_0.TCD[22].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD22_WORD_4   DMA_0.TCD[22].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD22_WORD_5   DMA_0.TCD[22].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD22_WORD_6   DMA_0.TCD[22].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD22_WORD_7   DMA_0.TCD[22].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD23_WORD_0   DMA_0.TCD[23].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD23_WORD_1   DMA_0.TCD[23].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD23_WORD_2   DMA_0.TCD[23].WORD_2.R        /* TCD Number of bytes to be transferred */
#define DMA_0_TCD23_WORD_3   DMA_0.TCD[23].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD23_WORD_4   DMA_0.TCD[23].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD23_WORD_5   DMA_0.TCD[23].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD23_WORD_6   DMA_0.TCD[23].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD23_WORD_7   DMA_0.TCD[23].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD24_WORD_0   DMA_0.TCD[24].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD24_WORD_1   DMA_0.TCD[24].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD24_WORD_2   DMA_0.TCD[24].WORD_2.R        /* TCD Number of bytes to be transferred */
#define DMA_0_TCD24_WORD_3   DMA_0.TCD[24].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD24_WORD_4   DMA_0.TCD[24].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD24_WORD_5   DMA_0.TCD[24].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD24_WORD_6   DMA_0.TCD[24].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD24_WORD_7   DMA_0.TCD[24].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD25_WORD_0   DMA_0.TCD[25].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD25_WORD_1   DMA_0.TCD[25].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD25_WORD_2   DMA_0.TCD[25].WORD_2.R        /* TCD Number of bytes to be transferred */
#define DMA_0_TCD25_WORD_3   DMA_0.TCD[25].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD25_WORD_4   DMA_0.TCD[25].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD25_WORD_5   DMA_0.TCD[25].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD25_WORD_6   DMA_0.TCD[25].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD25_WORD_7   DMA_0.TCD[25].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD26_WORD_0   DMA_0.TCD[26].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD26_WORD_1   DMA_0.TCD[26].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD26_WORD_2   DMA_0.TCD[26].WORD_2.R        /* TCD Number of bytes to be transferred */
#define DMA_0_TCD26_WORD_3   DMA_0.TCD[26].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD26_WORD_4   DMA_0.TCD[26].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD26_WORD_5   DMA_0.TCD[26].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD26_WORD_6   DMA_0.TCD[26].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD26_WORD_7   DMA_0.TCD[26].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD27_WORD_0   DMA_0.TCD[27].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD27_WORD_1   DMA_0.TCD[27].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD27_WORD_2   DMA_0.TCD[27].WORD_2.R        /* TCD Number of bytes to be transferred */
#define DMA_0_TCD27_WORD_3   DMA_0.TCD[27].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD27_WORD_4   DMA_0.TCD[27].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD27_WORD_5   DMA_0.TCD[27].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD27_WORD_6   DMA_0.TCD[27].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD27_WORD_7   DMA_0.TCD[27].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD28_WORD_0   DMA_0.TCD[28].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD28_WORD_1   DMA_0.TCD[28].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD28_WORD_2   DMA_0.TCD[28].WORD_2.R        /* TCD Number of bytes to be transferred */
#define DMA_0_TCD28_WORD_3   DMA_0.TCD[28].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD28_WORD_4   DMA_0.TCD[28].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD28_WORD_5   DMA_0.TCD[28].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD28_WORD_6   DMA_0.TCD[28].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD28_WORD_7   DMA_0.TCD[28].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD29_WORD_0   DMA_0.TCD[29].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD29_WORD_1   DMA_0.TCD[29].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD29_WORD_2   DMA_0.TCD[29].WORD_2.R        /* TCD Number of bytes to be transferred */
#define DMA_0_TCD29_WORD_3   DMA_0.TCD[29].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD29_WORD_4   DMA_0.TCD[29].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD29_WORD_5   DMA_0.TCD[29].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD29_WORD_6   DMA_0.TCD[29].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD29_WORD_7   DMA_0.TCD[29].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD30_WORD_0   DMA_0.TCD[30].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD30_WORD_1   DMA_0.TCD[30].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD30_WORD_2   DMA_0.TCD[30].WORD_2.R        /* TCD Number of bytes to be transferred */
#define DMA_0_TCD30_WORD_3   DMA_0.TCD[30].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD30_WORD_4   DMA_0.TCD[30].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD30_WORD_5   DMA_0.TCD[30].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD30_WORD_6   DMA_0.TCD[30].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD30_WORD_7   DMA_0.TCD[30].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD31_WORD_0   DMA_0.TCD[31].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD31_WORD_1   DMA_0.TCD[31].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD31_WORD_2   DMA_0.TCD[31].WORD_2.R        /* TCD Number of bytes to be transferred */
#define DMA_0_TCD31_WORD_3   DMA_0.TCD[31].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD31_WORD_4   DMA_0.TCD[31].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD31_WORD_5   DMA_0.TCD[31].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD31_WORD_6   DMA_0.TCD[31].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD31_WORD_7   DMA_0.TCD[31].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD32_WORD_0   DMA_0.TCD[32].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD32_WORD_1   DMA_0.TCD[32].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD32_WORD_2   DMA_0.TCD[32].WORD_2.R        /* TCD Number of bytes to be transferred */
#define DMA_0_TCD32_WORD_3   DMA_0.TCD[32].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD32_WORD_4   DMA_0.TCD[32].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD32_WORD_5   DMA_0.TCD[32].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD32_WORD_6   DMA_0.TCD[32].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD32_WORD_7   DMA_0.TCD[32].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD33_WORD_0   DMA_0.TCD[33].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD33_WORD_1   DMA_0.TCD[33].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD33_WORD_2   DMA_0.TCD[33].WORD_2.R        /* TCD Number of bytes to be transferred */
#define DMA_0_TCD33_WORD_3   DMA_0.TCD[33].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD33_WORD_4   DMA_0.TCD[33].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD33_WORD_5   DMA_0.TCD[33].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD33_WORD_6   DMA_0.TCD[33].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD33_WORD_7   DMA_0.TCD[33].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD34_WORD_0   DMA_0.TCD[34].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD34_WORD_1   DMA_0.TCD[34].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD34_WORD_2   DMA_0.TCD[34].WORD_2.R        /* TCD Number of bytes to be transferred */
#define DMA_0_TCD34_WORD_3   DMA_0.TCD[34].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD34_WORD_4   DMA_0.TCD[34].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD34_WORD_5   DMA_0.TCD[34].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD34_WORD_6   DMA_0.TCD[34].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD34_WORD_7   DMA_0.TCD[34].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD35_WORD_0   DMA_0.TCD[35].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD35_WORD_1   DMA_0.TCD[35].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD35_WORD_2   DMA_0.TCD[35].WORD_2.R        /* TCD Number of bytes to be transferred */
#define DMA_0_TCD35_WORD_3   DMA_0.TCD[35].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD35_WORD_4   DMA_0.TCD[35].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD35_WORD_5   DMA_0.TCD[35].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD35_WORD_6   DMA_0.TCD[35].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD35_WORD_7   DMA_0.TCD[35].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD36_WORD_0   DMA_0.TCD[36].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD36_WORD_1   DMA_0.TCD[36].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD36_WORD_2   DMA_0.TCD[36].WORD_2.R        /* TCD Number of bytes to be transferred */
#define DMA_0_TCD36_WORD_3   DMA_0.TCD[36].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD36_WORD_4   DMA_0.TCD[36].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD36_WORD_5   DMA_0.TCD[36].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD36_WORD_6   DMA_0.TCD[36].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD36_WORD_7   DMA_0.TCD[36].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD37_WORD_0   DMA_0.TCD[37].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD37_WORD_1   DMA_0.TCD[37].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD37_WORD_2   DMA_0.TCD[37].WORD_2.R        /* TCD Number of bytes to be transferred */
#define DMA_0_TCD37_WORD_3   DMA_0.TCD[37].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD37_WORD_4   DMA_0.TCD[37].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD37_WORD_5   DMA_0.TCD[37].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD37_WORD_6   DMA_0.TCD[37].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD37_WORD_7   DMA_0.TCD[37].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD38_WORD_0   DMA_0.TCD[38].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD38_WORD_1   DMA_0.TCD[38].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD38_WORD_2   DMA_0.TCD[38].WORD_2.R        /* TCD Number of bytes to be transferred */
#define DMA_0_TCD38_WORD_3   DMA_0.TCD[38].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD38_WORD_4   DMA_0.TCD[38].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD38_WORD_5   DMA_0.TCD[38].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD38_WORD_6   DMA_0.TCD[38].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD38_WORD_7   DMA_0.TCD[38].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD39_WORD_0   DMA_0.TCD[39].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD39_WORD_1   DMA_0.TCD[39].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD39_WORD_2   DMA_0.TCD[39].WORD_2.R        /* TCD Number of bytes to be transferred */
#define DMA_0_TCD39_WORD_3   DMA_0.TCD[39].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD39_WORD_4   DMA_0.TCD[39].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD39_WORD_5   DMA_0.TCD[39].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD39_WORD_6   DMA_0.TCD[39].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD39_WORD_7   DMA_0.TCD[39].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD40_WORD_0   DMA_0.TCD[40].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD40_WORD_1   DMA_0.TCD[40].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD40_WORD_2   DMA_0.TCD[40].WORD_2.R        /* TCD Number of bytes to be transferred */
#define DMA_0_TCD40_WORD_3   DMA_0.TCD[40].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD40_WORD_4   DMA_0.TCD[40].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD40_WORD_5   DMA_0.TCD[40].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD40_WORD_6   DMA_0.TCD[40].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD40_WORD_7   DMA_0.TCD[40].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD41_WORD_0   DMA_0.TCD[41].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD41_WORD_1   DMA_0.TCD[41].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD41_WORD_2   DMA_0.TCD[41].WORD_2.R        /* TCD Number of bytes to be transferred */
#define DMA_0_TCD41_WORD_3   DMA_0.TCD[41].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD41_WORD_4   DMA_0.TCD[41].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD41_WORD_5   DMA_0.TCD[41].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD41_WORD_6   DMA_0.TCD[41].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD41_WORD_7   DMA_0.TCD[41].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD42_WORD_0   DMA_0.TCD[42].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD42_WORD_1   DMA_0.TCD[42].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD42_WORD_2   DMA_0.TCD[42].WORD_2.R        /* TCD Number of bytes to be transferred */
#define DMA_0_TCD42_WORD_3   DMA_0.TCD[42].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD42_WORD_4   DMA_0.TCD[42].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD42_WORD_5   DMA_0.TCD[42].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD42_WORD_6   DMA_0.TCD[42].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD42_WORD_7   DMA_0.TCD[42].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD43_WORD_0   DMA_0.TCD[43].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD43_WORD_1   DMA_0.TCD[43].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD43_WORD_2   DMA_0.TCD[43].WORD_2.R        /* TCD Number of bytes to be transferred */
#define DMA_0_TCD43_WORD_3   DMA_0.TCD[43].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD43_WORD_4   DMA_0.TCD[43].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD43_WORD_5   DMA_0.TCD[43].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD43_WORD_6   DMA_0.TCD[43].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD43_WORD_7   DMA_0.TCD[43].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD44_WORD_0   DMA_0.TCD[44].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD44_WORD_1   DMA_0.TCD[44].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD44_WORD_2   DMA_0.TCD[44].WORD_2.R        /* TCD Number of bytes to be transferred */
#define DMA_0_TCD44_WORD_3   DMA_0.TCD[44].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD44_WORD_4   DMA_0.TCD[44].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD44_WORD_5   DMA_0.TCD[44].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD44_WORD_6   DMA_0.TCD[44].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD44_WORD_7   DMA_0.TCD[44].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD45_WORD_0   DMA_0.TCD[45].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD45_WORD_1   DMA_0.TCD[45].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD45_WORD_2   DMA_0.TCD[45].WORD_2.R        /* TCD Number of bytes to be transferred */
#define DMA_0_TCD45_WORD_3   DMA_0.TCD[45].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD45_WORD_4   DMA_0.TCD[45].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD45_WORD_5   DMA_0.TCD[45].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD45_WORD_6   DMA_0.TCD[45].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD45_WORD_7   DMA_0.TCD[45].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD46_WORD_0   DMA_0.TCD[46].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD46_WORD_1   DMA_0.TCD[46].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD46_WORD_2   DMA_0.TCD[46].WORD_2.R        /* TCD Number of bytes to be transferred */
#define DMA_0_TCD46_WORD_3   DMA_0.TCD[46].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD46_WORD_4   DMA_0.TCD[46].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD46_WORD_5   DMA_0.TCD[46].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD46_WORD_6   DMA_0.TCD[46].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD46_WORD_7   DMA_0.TCD[46].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD47_WORD_0   DMA_0.TCD[47].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD47_WORD_1   DMA_0.TCD[47].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD47_WORD_2   DMA_0.TCD[47].WORD_2.R        /* TCD Number of bytes to be transferred */
#define DMA_0_TCD47_WORD_3   DMA_0.TCD[47].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD47_WORD_4   DMA_0.TCD[47].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD47_WORD_5   DMA_0.TCD[47].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD47_WORD_6   DMA_0.TCD[47].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD47_WORD_7   DMA_0.TCD[47].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD48_WORD_0   DMA_0.TCD[48].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD48_WORD_1   DMA_0.TCD[48].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD48_WORD_2   DMA_0.TCD[48].WORD_2.R        /* TCD Number of bytes to be transferred */
#define DMA_0_TCD48_WORD_3   DMA_0.TCD[48].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD48_WORD_4   DMA_0.TCD[48].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD48_WORD_5   DMA_0.TCD[48].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD48_WORD_6   DMA_0.TCD[48].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD48_WORD_7   DMA_0.TCD[48].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD49_WORD_0   DMA_0.TCD[49].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD49_WORD_1   DMA_0.TCD[49].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD49_WORD_2   DMA_0.TCD[49].WORD_2.R        /* TCD Number of bytes to be transferred */
#define DMA_0_TCD49_WORD_3   DMA_0.TCD[49].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD49_WORD_4   DMA_0.TCD[49].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD49_WORD_5   DMA_0.TCD[49].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD49_WORD_6   DMA_0.TCD[49].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD49_WORD_7   DMA_0.TCD[49].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD50_WORD_0   DMA_0.TCD[50].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD50_WORD_1   DMA_0.TCD[50].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD50_WORD_2   DMA_0.TCD[50].WORD_2.R        /* TCD Number of bytes to be transferred */
#define DMA_0_TCD50_WORD_3   DMA_0.TCD[50].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD50_WORD_4   DMA_0.TCD[50].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD50_WORD_5   DMA_0.TCD[50].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD50_WORD_6   DMA_0.TCD[50].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD50_WORD_7   DMA_0.TCD[50].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD51_WORD_0   DMA_0.TCD[51].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD51_WORD_1   DMA_0.TCD[51].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD51_WORD_2   DMA_0.TCD[51].WORD_2.R        /* TCD Number of bytes to be transferred */
#define DMA_0_TCD51_WORD_3   DMA_0.TCD[51].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD51_WORD_4   DMA_0.TCD[51].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD51_WORD_5   DMA_0.TCD[51].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD51_WORD_6   DMA_0.TCD[51].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD51_WORD_7   DMA_0.TCD[51].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD52_WORD_0   DMA_0.TCD[52].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD52_WORD_1   DMA_0.TCD[52].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD52_WORD_2   DMA_0.TCD[52].WORD_2.R        /* TCD Number of bytes to be transferred */
#define DMA_0_TCD52_WORD_3   DMA_0.TCD[52].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD52_WORD_4   DMA_0.TCD[52].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD52_WORD_5   DMA_0.TCD[52].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD52_WORD_6   DMA_0.TCD[52].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD52_WORD_7   DMA_0.TCD[52].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD53_WORD_0   DMA_0.TCD[53].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD53_WORD_1   DMA_0.TCD[53].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD53_WORD_2   DMA_0.TCD[53].WORD_2.R        /* TCD Number of bytes to be transferred */
#define DMA_0_TCD53_WORD_3   DMA_0.TCD[53].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD53_WORD_4   DMA_0.TCD[53].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD53_WORD_5   DMA_0.TCD[53].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD53_WORD_6   DMA_0.TCD[53].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD53_WORD_7   DMA_0.TCD[53].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD54_WORD_0   DMA_0.TCD[54].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD54_WORD_1   DMA_0.TCD[54].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD54_WORD_2   DMA_0.TCD[54].WORD_2.R        /* TCD Number of bytes to be transferred */
#define DMA_0_TCD54_WORD_3   DMA_0.TCD[54].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD54_WORD_4   DMA_0.TCD[54].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD54_WORD_5   DMA_0.TCD[54].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD54_WORD_6   DMA_0.TCD[54].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD54_WORD_7   DMA_0.TCD[54].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD55_WORD_0   DMA_0.TCD[55].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD55_WORD_1   DMA_0.TCD[55].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD55_WORD_2   DMA_0.TCD[55].WORD_2.R        /* TCD Number of bytes to be transferred */
#define DMA_0_TCD55_WORD_3   DMA_0.TCD[55].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD55_WORD_4   DMA_0.TCD[55].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD55_WORD_5   DMA_0.TCD[55].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD55_WORD_6   DMA_0.TCD[55].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD55_WORD_7   DMA_0.TCD[55].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD56_WORD_0   DMA_0.TCD[56].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD56_WORD_1   DMA_0.TCD[56].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD56_WORD_2   DMA_0.TCD[56].WORD_2.R        /* TCD Number of bytes to be transferred */
#define DMA_0_TCD56_WORD_3   DMA_0.TCD[56].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD56_WORD_4   DMA_0.TCD[56].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD56_WORD_5   DMA_0.TCD[56].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD56_WORD_6   DMA_0.TCD[56].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD56_WORD_7   DMA_0.TCD[56].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD57_WORD_0   DMA_0.TCD[57].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD57_WORD_1   DMA_0.TCD[57].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD57_WORD_2   DMA_0.TCD[57].WORD_2.R        /* TCD Number of bytes to be transferred */
#define DMA_0_TCD57_WORD_3   DMA_0.TCD[57].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD57_WORD_4   DMA_0.TCD[57].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD57_WORD_5   DMA_0.TCD[57].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD57_WORD_6   DMA_0.TCD[57].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD57_WORD_7   DMA_0.TCD[57].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD58_WORD_0   DMA_0.TCD[58].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD58_WORD_1   DMA_0.TCD[58].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD58_WORD_2   DMA_0.TCD[58].WORD_2.R        /* TCD Number of bytes to be transferred */
#define DMA_0_TCD58_WORD_3   DMA_0.TCD[58].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD58_WORD_4   DMA_0.TCD[58].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD58_WORD_5   DMA_0.TCD[58].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD58_WORD_6   DMA_0.TCD[58].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD58_WORD_7   DMA_0.TCD[58].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD59_WORD_0   DMA_0.TCD[59].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD59_WORD_1   DMA_0.TCD[59].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD59_WORD_2   DMA_0.TCD[59].WORD_2.R        /* TCD Number of bytes to be transferred */
#define DMA_0_TCD59_WORD_3   DMA_0.TCD[59].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD59_WORD_4   DMA_0.TCD[59].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD59_WORD_5   DMA_0.TCD[59].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD59_WORD_6   DMA_0.TCD[59].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD59_WORD_7   DMA_0.TCD[59].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD60_WORD_0   DMA_0.TCD[60].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD60_WORD_1   DMA_0.TCD[60].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD60_WORD_2   DMA_0.TCD[60].WORD_2.R        /* TCD Number of bytes to be transferred */
#define DMA_0_TCD60_WORD_3   DMA_0.TCD[60].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD60_WORD_4   DMA_0.TCD[60].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD60_WORD_5   DMA_0.TCD[60].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD60_WORD_6   DMA_0.TCD[60].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD60_WORD_7   DMA_0.TCD[60].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD61_WORD_0   DMA_0.TCD[61].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD61_WORD_1   DMA_0.TCD[61].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD61_WORD_2   DMA_0.TCD[61].WORD_2.R        /* TCD Number of bytes to be transferred */
#define DMA_0_TCD61_WORD_3   DMA_0.TCD[61].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD61_WORD_4   DMA_0.TCD[61].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD61_WORD_5   DMA_0.TCD[61].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD61_WORD_6   DMA_0.TCD[61].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD61_WORD_7   DMA_0.TCD[61].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD62_WORD_0   DMA_0.TCD[62].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD62_WORD_1   DMA_0.TCD[62].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD62_WORD_2   DMA_0.TCD[62].WORD_2.R        /* TCD Number of bytes to be transferred */
#define DMA_0_TCD62_WORD_3   DMA_0.TCD[62].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD62_WORD_4   DMA_0.TCD[62].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD62_WORD_5   DMA_0.TCD[62].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD62_WORD_6   DMA_0.TCD[62].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD62_WORD_7   DMA_0.TCD[62].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD63_WORD_0   DMA_0.TCD[63].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD63_WORD_1   DMA_0.TCD[63].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD63_WORD_2   DMA_0.TCD[63].WORD_2.R        /* TCD Number of bytes to be transferred */
#define DMA_0_TCD63_WORD_3   DMA_0.TCD[63].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD63_WORD_4   DMA_0.TCD[63].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD63_WORD_5   DMA_0.TCD[63].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD63_WORD_6   DMA_0.TCD[63].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD63_WORD_7   DMA_0.TCD[63].WORD_7.R        /* TCD Control and Status */

/* DSPI */
#define DSPI_0_MCR           DSPI_0.MCR.R                  /* Module Configuration Register */
#define DSPI_0_TCR           DSPI_0.TCR.R                  /* Transfer Count Register */
#define DSPI_0_CTAR0         DSPI_0.MODE.CTAR[0].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_0_CTAR1         DSPI_0.MODE.CTAR[1].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_0_CTAR2         DSPI_0.MODE.CTAR[2].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_0_CTAR3         DSPI_0.MODE.CTAR[3].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_0_CTAR4         DSPI_0.MODE.CTAR[4].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_0_CTAR5         DSPI_0.MODE.CTAR[5].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_0_CTAR0_SLAVE   DSPI_0.MODE.CTAR_SLAVE[0].R   /* Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_0_CTAR1_SLAVE   DSPI_0.MODE.CTAR_SLAVE[1].R   /* Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_0_CTAR6         DSPI_0.CTAR[0].R              /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_0_CTAR7         DSPI_0.CTAR[1].R              /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_0_SR            DSPI_0.SR.R                   /* Status Register */
#define DSPI_0_RSER          DSPI_0.RSER.R                 /* DMA/Interrupt Request Select and Enable Register */
#define DSPI_0_PUSHR         DSPI_0.PUSHR.PUSHR.R          /* PUSH TX FIFO Register In Master Mode */
#define DSPI_0_PUSHR_SLAVE   DSPI_0.PUSHR.PUSHR_SLAVE.R    /* PUSH TX FIFO Register In Slave Mode */
#define DSPI_0_POPR          DSPI_0.POPR.R                 /* POP RX FIFO Register */
#define DSPI_0_TXFR0         DSPI_0.TXFR[0].R              /* Transmit FIFO Registers */
#define DSPI_0_TXFR1         DSPI_0.TXFR[1].R              /* Transmit FIFO Registers */
#define DSPI_0_TXFR2         DSPI_0.TXFR[2].R              /* Transmit FIFO Registers */
#define DSPI_0_TXFR3         DSPI_0.TXFR[3].R              /* Transmit FIFO Registers */
#define DSPI_0_RXFR0         DSPI_0.RXFR[0].R              /* Receive FIFO Registers */
#define DSPI_0_RXFR1         DSPI_0.RXFR[1].R              /* Receive FIFO Registers */
#define DSPI_0_RXFR2         DSPI_0.RXFR[2].R              /* Receive FIFO Registers */
#define DSPI_0_RXFR3         DSPI_0.RXFR[3].R              /* Receive FIFO Registers */
#define DSPI_0_DSICR0        DSPI_0.DSICR0.R               /* DSI Configuration Register 0 */
#define DSPI_0_SDR0          DSPI_0.SDR0.R                 /* DSI Serialization Data Register 0 */
#define DSPI_0_ASDR0         DSPI_0.ASDR0.R                /* DSI Alternate Serialization Data Register 0 */
#define DSPI_0_COMPR0        DSPI_0.COMPR0.R               /* DSI Transmit Comparison Register 0 */
#define DSPI_0_DSICR1        DSPI_0.DSICR1.R               /* DSI Configuration Register 1 */
#define DSPI_0_SSR0          DSPI_0.SSR0.R                 /* DSI Serialization Source Select Register 0 */
#define DSPI_0_SDR1          DSPI_0.SDR1.R                 /* DSI Serialization Data Register 1 */
#define DSPI_0_ASDR1         DSPI_0.ASDR1.R                /* DSI Alternate Serialization Data Register 1 */
#define DSPI_0_COMPR1        DSPI_0.COMPR1.R               /* DSI Transmit Comparison Register 1 */
#define DSPI_0_DDR1          DSPI_0.DDR1.R                 /* DSI Deserialization Data Register 1 */
#define DSPI_0_SSR1          DSPI_0.SSR1.R                 /* DSI Serialization Source Select Register 1 */
#define DSPI_0_DIMR1         DSPI_0.DIMR1.R                /* DSI Deserialized Data Interrupt Mask Register 1 */
#define DSPI_0_DPIR1         DSPI_0.DPIR1.R                /* DSI Deserialized Data Polarity Interrupt Register 1 */
#define DSPI_0_CTARE0        DSPI_0.CTARE[0].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_0_CTARE1        DSPI_0.CTARE[1].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_0_CTARE2        DSPI_0.CTARE[2].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_0_CTARE3        DSPI_0.CTARE[3].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_0_CTARE4        DSPI_0.CTARE[4].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_0_CTARE5        DSPI_0.CTARE[5].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_0_CTARE6        DSPI_0.CTARE[6].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_0_CTARE7        DSPI_0.CTARE[7].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_0_SREX          DSPI_0.SREX.R                 /* Status Register Extended */
#define DSPI_0_TRIG          DSPI_0.TRIG.R                 /* Trigger Register */
#define DSPI_0_TSL           DSPI_0.TSL.R                  /* Time Slot Length Register */
#define DSPI_0_TS_CONF       DSPI_0.TS_CONF.R              /* Time Slot Configuration Register */

/* DSPI */
#define DSPI_1_MCR           DSPI_1.MCR.R                  /* Module Configuration Register */
#define DSPI_1_TCR           DSPI_1.TCR.R                  /* Transfer Count Register */
#define DSPI_1_CTAR0         DSPI_1.MODE.CTAR[0].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_1_CTAR1         DSPI_1.MODE.CTAR[1].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_1_CTAR2         DSPI_1.MODE.CTAR[2].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_1_CTAR3         DSPI_1.MODE.CTAR[3].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_1_CTAR4         DSPI_1.MODE.CTAR[4].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_1_CTAR5         DSPI_1.MODE.CTAR[5].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_1_CTAR0_SLAVE   DSPI_1.MODE.CTAR_SLAVE[0].R   /* Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_1_CTAR1_SLAVE   DSPI_1.MODE.CTAR_SLAVE[1].R   /* Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_1_CTAR6         DSPI_1.CTAR[0].R              /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_1_CTAR7         DSPI_1.CTAR[1].R              /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_1_SR            DSPI_1.SR.R                   /* Status Register */
#define DSPI_1_RSER          DSPI_1.RSER.R                 /* DMA/Interrupt Request Select and Enable Register */
#define DSPI_1_PUSHR         DSPI_1.PUSHR.PUSHR.R          /* PUSH TX FIFO Register In Master Mode */
#define DSPI_1_PUSHR_SLAVE   DSPI_1.PUSHR.PUSHR_SLAVE.R    /* PUSH TX FIFO Register In Slave Mode */
#define DSPI_1_POPR          DSPI_1.POPR.R                 /* POP RX FIFO Register */
#define DSPI_1_TXFR0         DSPI_1.TXFR[0].R              /* Transmit FIFO Registers */
#define DSPI_1_TXFR1         DSPI_1.TXFR[1].R              /* Transmit FIFO Registers */
#define DSPI_1_TXFR2         DSPI_1.TXFR[2].R              /* Transmit FIFO Registers */
#define DSPI_1_TXFR3         DSPI_1.TXFR[3].R              /* Transmit FIFO Registers */
#define DSPI_1_RXFR0         DSPI_1.RXFR[0].R              /* Receive FIFO Registers */
#define DSPI_1_RXFR1         DSPI_1.RXFR[1].R              /* Receive FIFO Registers */
#define DSPI_1_RXFR2         DSPI_1.RXFR[2].R              /* Receive FIFO Registers */
#define DSPI_1_RXFR3         DSPI_1.RXFR[3].R              /* Receive FIFO Registers */
#define DSPI_1_DSICR0        DSPI_1.DSICR0.R               /* DSI Configuration Register 0 */
#define DSPI_1_SDR0          DSPI_1.SDR0.R                 /* DSI Serialization Data Register 0 */
#define DSPI_1_ASDR0         DSPI_1.ASDR0.R                /* DSI Alternate Serialization Data Register 0 */
#define DSPI_1_COMPR0        DSPI_1.COMPR0.R               /* DSI Transmit Comparison Register 0 */
#define DSPI_1_DSICR1        DSPI_1.DSICR1.R               /* DSI Configuration Register 1 */
#define DSPI_1_SSR0          DSPI_1.SSR0.R                 /* DSI Serialization Source Select Register 0 */
#define DSPI_1_SDR1          DSPI_1.SDR1.R                 /* DSI Serialization Data Register 1 */
#define DSPI_1_ASDR1         DSPI_1.ASDR1.R                /* DSI Alternate Serialization Data Register 1 */
#define DSPI_1_COMPR1        DSPI_1.COMPR1.R               /* DSI Transmit Comparison Register 1 */
#define DSPI_1_DDR1          DSPI_1.DDR1.R                 /* DSI Deserialization Data Register 1 */
#define DSPI_1_SSR1          DSPI_1.SSR1.R                 /* DSI Serialization Source Select Register 1 */
#define DSPI_1_DIMR1         DSPI_1.DIMR1.R                /* DSI Deserialized Data Interrupt Mask Register 1 */
#define DSPI_1_DPIR1         DSPI_1.DPIR1.R                /* DSI Deserialized Data Polarity Interrupt Register 1 */
#define DSPI_1_CTARE0        DSPI_1.CTARE[0].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_1_CTARE1        DSPI_1.CTARE[1].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_1_CTARE2        DSPI_1.CTARE[2].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_1_CTARE3        DSPI_1.CTARE[3].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_1_CTARE4        DSPI_1.CTARE[4].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_1_CTARE5        DSPI_1.CTARE[5].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_1_CTARE6        DSPI_1.CTARE[6].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_1_CTARE7        DSPI_1.CTARE[7].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_1_SREX          DSPI_1.SREX.R                 /* Status Register Extended */
#define DSPI_1_TRIG          DSPI_1.TRIG.R                 /* Trigger Register */
#define DSPI_1_TSL           DSPI_1.TSL.R                  /* Time Slot Length Register */
#define DSPI_1_TS_CONF       DSPI_1.TS_CONF.R              /* Time Slot Configuration Register */

/* DSPI */
#define DSPI_2_MCR           DSPI_2.MCR.R                  /* Module Configuration Register */
#define DSPI_2_TCR           DSPI_2.TCR.R                  /* Transfer Count Register */
#define DSPI_2_CTAR0         DSPI_2.MODE.CTAR[0].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_2_CTAR1         DSPI_2.MODE.CTAR[1].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_2_CTAR2         DSPI_2.MODE.CTAR[2].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_2_CTAR3         DSPI_2.MODE.CTAR[3].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_2_CTAR4         DSPI_2.MODE.CTAR[4].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_2_CTAR5         DSPI_2.MODE.CTAR[5].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_2_CTAR0_SLAVE   DSPI_2.MODE.CTAR_SLAVE[0].R   /* Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_2_CTAR1_SLAVE   DSPI_2.MODE.CTAR_SLAVE[1].R   /* Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_2_CTAR6         DSPI_2.CTAR[0].R              /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_2_CTAR7         DSPI_2.CTAR[1].R              /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_2_SR            DSPI_2.SR.R                   /* Status Register */
#define DSPI_2_RSER          DSPI_2.RSER.R                 /* DMA/Interrupt Request Select and Enable Register */
#define DSPI_2_PUSHR         DSPI_2.PUSHR.PUSHR.R          /* PUSH TX FIFO Register In Master Mode */
#define DSPI_2_PUSHR_SLAVE   DSPI_2.PUSHR.PUSHR_SLAVE.R    /* PUSH TX FIFO Register In Slave Mode */
#define DSPI_2_POPR          DSPI_2.POPR.R                 /* POP RX FIFO Register */
#define DSPI_2_TXFR0         DSPI_2.TXFR[0].R              /* Transmit FIFO Registers */
#define DSPI_2_TXFR1         DSPI_2.TXFR[1].R              /* Transmit FIFO Registers */
#define DSPI_2_TXFR2         DSPI_2.TXFR[2].R              /* Transmit FIFO Registers */
#define DSPI_2_TXFR3         DSPI_2.TXFR[3].R              /* Transmit FIFO Registers */
#define DSPI_2_RXFR0         DSPI_2.RXFR[0].R              /* Receive FIFO Registers */
#define DSPI_2_RXFR1         DSPI_2.RXFR[1].R              /* Receive FIFO Registers */
#define DSPI_2_RXFR2         DSPI_2.RXFR[2].R              /* Receive FIFO Registers */
#define DSPI_2_RXFR3         DSPI_2.RXFR[3].R              /* Receive FIFO Registers */
#define DSPI_2_DSICR0        DSPI_2.DSICR0.R               /* DSI Configuration Register 0 */
#define DSPI_2_SDR0          DSPI_2.SDR0.R                 /* DSI Serialization Data Register 0 */
#define DSPI_2_ASDR0         DSPI_2.ASDR0.R                /* DSI Alternate Serialization Data Register 0 */
#define DSPI_2_COMPR0        DSPI_2.COMPR0.R               /* DSI Transmit Comparison Register 0 */
#define DSPI_2_DSICR1        DSPI_2.DSICR1.R               /* DSI Configuration Register 1 */
#define DSPI_2_SSR0          DSPI_2.SSR0.R                 /* DSI Serialization Source Select Register 0 */
#define DSPI_2_SDR1          DSPI_2.SDR1.R                 /* DSI Serialization Data Register 1 */
#define DSPI_2_ASDR1         DSPI_2.ASDR1.R                /* DSI Alternate Serialization Data Register 1 */
#define DSPI_2_COMPR1        DSPI_2.COMPR1.R               /* DSI Transmit Comparison Register 1 */
#define DSPI_2_DDR1          DSPI_2.DDR1.R                 /* DSI Deserialization Data Register 1 */
#define DSPI_2_SSR1          DSPI_2.SSR1.R                 /* DSI Serialization Source Select Register 1 */
#define DSPI_2_DIMR1         DSPI_2.DIMR1.R                /* DSI Deserialized Data Interrupt Mask Register 1 */
#define DSPI_2_DPIR1         DSPI_2.DPIR1.R                /* DSI Deserialized Data Polarity Interrupt Register 1 */
#define DSPI_2_CTARE0        DSPI_2.CTARE[0].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_2_CTARE1        DSPI_2.CTARE[1].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_2_CTARE2        DSPI_2.CTARE[2].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_2_CTARE3        DSPI_2.CTARE[3].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_2_CTARE4        DSPI_2.CTARE[4].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_2_CTARE5        DSPI_2.CTARE[5].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_2_CTARE6        DSPI_2.CTARE[6].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_2_CTARE7        DSPI_2.CTARE[7].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_2_SREX          DSPI_2.SREX.R                 /* Status Register Extended */
#define DSPI_2_TRIG          DSPI_2.TRIG.R                 /* Trigger Register */
#define DSPI_2_TSL           DSPI_2.TSL.R                  /* Time Slot Length Register */
#define DSPI_2_TS_CONF       DSPI_2.TS_CONF.R              /* Time Slot Configuration Register */

/* DSPI */
#define DSPI_3_MCR           DSPI_3.MCR.R                  /* Module Configuration Register */
#define DSPI_3_TCR           DSPI_3.TCR.R                  /* Transfer Count Register */
#define DSPI_3_CTAR0         DSPI_3.MODE.CTAR[0].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_3_CTAR1         DSPI_3.MODE.CTAR[1].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_3_CTAR2         DSPI_3.MODE.CTAR[2].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_3_CTAR3         DSPI_3.MODE.CTAR[3].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_3_CTAR4         DSPI_3.MODE.CTAR[4].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_3_CTAR5         DSPI_3.MODE.CTAR[5].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_3_CTAR0_SLAVE   DSPI_3.MODE.CTAR_SLAVE[0].R   /* Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_3_CTAR1_SLAVE   DSPI_3.MODE.CTAR_SLAVE[1].R   /* Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_3_CTAR6         DSPI_3.CTAR[0].R              /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_3_CTAR7         DSPI_3.CTAR[1].R              /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_3_SR            DSPI_3.SR.R                   /* Status Register */
#define DSPI_3_RSER          DSPI_3.RSER.R                 /* DMA/Interrupt Request Select and Enable Register */
#define DSPI_3_PUSHR         DSPI_3.PUSHR.PUSHR.R          /* PUSH TX FIFO Register In Master Mode */
#define DSPI_3_PUSHR_SLAVE   DSPI_3.PUSHR.PUSHR_SLAVE.R    /* PUSH TX FIFO Register In Slave Mode */
#define DSPI_3_POPR          DSPI_3.POPR.R                 /* POP RX FIFO Register */
#define DSPI_3_TXFR0         DSPI_3.TXFR[0].R              /* Transmit FIFO Registers */
#define DSPI_3_TXFR1         DSPI_3.TXFR[1].R              /* Transmit FIFO Registers */
#define DSPI_3_TXFR2         DSPI_3.TXFR[2].R              /* Transmit FIFO Registers */
#define DSPI_3_TXFR3         DSPI_3.TXFR[3].R              /* Transmit FIFO Registers */
#define DSPI_3_RXFR0         DSPI_3.RXFR[0].R              /* Receive FIFO Registers */
#define DSPI_3_RXFR1         DSPI_3.RXFR[1].R              /* Receive FIFO Registers */
#define DSPI_3_RXFR2         DSPI_3.RXFR[2].R              /* Receive FIFO Registers */
#define DSPI_3_RXFR3         DSPI_3.RXFR[3].R              /* Receive FIFO Registers */
#define DSPI_3_DSICR0        DSPI_3.DSICR0.R               /* DSI Configuration Register 0 */
#define DSPI_3_SDR0          DSPI_3.SDR0.R                 /* DSI Serialization Data Register 0 */
#define DSPI_3_ASDR0         DSPI_3.ASDR0.R                /* DSI Alternate Serialization Data Register 0 */
#define DSPI_3_COMPR0        DSPI_3.COMPR0.R               /* DSI Transmit Comparison Register 0 */
#define DSPI_3_DSICR1        DSPI_3.DSICR1.R               /* DSI Configuration Register 1 */
#define DSPI_3_SSR0          DSPI_3.SSR0.R                 /* DSI Serialization Source Select Register 0 */
#define DSPI_3_SDR1          DSPI_3.SDR1.R                 /* DSI Serialization Data Register 1 */
#define DSPI_3_ASDR1         DSPI_3.ASDR1.R                /* DSI Alternate Serialization Data Register 1 */
#define DSPI_3_COMPR1        DSPI_3.COMPR1.R               /* DSI Transmit Comparison Register 1 */
#define DSPI_3_DDR1          DSPI_3.DDR1.R                 /* DSI Deserialization Data Register 1 */
#define DSPI_3_SSR1          DSPI_3.SSR1.R                 /* DSI Serialization Source Select Register 1 */
#define DSPI_3_DIMR1         DSPI_3.DIMR1.R                /* DSI Deserialized Data Interrupt Mask Register 1 */
#define DSPI_3_DPIR1         DSPI_3.DPIR1.R                /* DSI Deserialized Data Polarity Interrupt Register 1 */
#define DSPI_3_CTARE0        DSPI_3.CTARE[0].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_3_CTARE1        DSPI_3.CTARE[1].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_3_CTARE2        DSPI_3.CTARE[2].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_3_CTARE3        DSPI_3.CTARE[3].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_3_CTARE4        DSPI_3.CTARE[4].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_3_CTARE5        DSPI_3.CTARE[5].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_3_CTARE6        DSPI_3.CTARE[6].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_3_CTARE7        DSPI_3.CTARE[7].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_3_SREX          DSPI_3.SREX.R                 /* Status Register Extended */
#define DSPI_3_TRIG          DSPI_3.TRIG.R                 /* Trigger Register */
#define DSPI_3_TSL           DSPI_3.TSL.R                  /* Time Slot Length Register */
#define DSPI_3_TS_CONF       DSPI_3.TS_CONF.R              /* Time Slot Configuration Register */

/* DSPI */
#define DSPI_4_MCR           DSPI_4.MCR.R                  /* Module Configuration Register */
#define DSPI_4_TCR           DSPI_4.TCR.R                  /* Transfer Count Register */
#define DSPI_4_CTAR0         DSPI_4.MODE.CTAR[0].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_4_CTAR1         DSPI_4.MODE.CTAR[1].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_4_CTAR2         DSPI_4.MODE.CTAR[2].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_4_CTAR3         DSPI_4.MODE.CTAR[3].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_4_CTAR4         DSPI_4.MODE.CTAR[4].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_4_CTAR5         DSPI_4.MODE.CTAR[5].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_4_CTAR0_SLAVE   DSPI_4.MODE.CTAR_SLAVE[0].R   /* Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_4_CTAR1_SLAVE   DSPI_4.MODE.CTAR_SLAVE[1].R   /* Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_4_CTAR6         DSPI_4.CTAR[0].R              /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_4_CTAR7         DSPI_4.CTAR[1].R              /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_4_SR            DSPI_4.SR.R                   /* Status Register */
#define DSPI_4_RSER          DSPI_4.RSER.R                 /* DMA/Interrupt Request Select and Enable Register */
#define DSPI_4_PUSHR         DSPI_4.PUSHR.PUSHR.R          /* PUSH TX FIFO Register In Master Mode */
#define DSPI_4_PUSHR_SLAVE   DSPI_4.PUSHR.PUSHR_SLAVE.R    /* PUSH TX FIFO Register In Slave Mode */
#define DSPI_4_POPR          DSPI_4.POPR.R                 /* POP RX FIFO Register */
#define DSPI_4_TXFR0         DSPI_4.TXFR[0].R              /* Transmit FIFO Registers */
#define DSPI_4_TXFR1         DSPI_4.TXFR[1].R              /* Transmit FIFO Registers */
#define DSPI_4_TXFR2         DSPI_4.TXFR[2].R              /* Transmit FIFO Registers */
#define DSPI_4_TXFR3         DSPI_4.TXFR[3].R              /* Transmit FIFO Registers */
#define DSPI_4_RXFR0         DSPI_4.RXFR[0].R              /* Receive FIFO Registers */
#define DSPI_4_RXFR1         DSPI_4.RXFR[1].R              /* Receive FIFO Registers */
#define DSPI_4_RXFR2         DSPI_4.RXFR[2].R              /* Receive FIFO Registers */
#define DSPI_4_RXFR3         DSPI_4.RXFR[3].R              /* Receive FIFO Registers */
#define DSPI_4_DSICR0        DSPI_4.DSICR0.R               /* DSI Configuration Register 0 */
#define DSPI_4_SDR0          DSPI_4.SDR0.R                 /* DSI Serialization Data Register 0 */
#define DSPI_4_ASDR0         DSPI_4.ASDR0.R                /* DSI Alternate Serialization Data Register 0 */
#define DSPI_4_COMPR0        DSPI_4.COMPR0.R               /* DSI Transmit Comparison Register 0 */
#define DSPI_4_DSICR1        DSPI_4.DSICR1.R               /* DSI Configuration Register 1 */
#define DSPI_4_SSR0          DSPI_4.SSR0.R                 /* DSI Serialization Source Select Register 0 */
#define DSPI_4_SDR1          DSPI_4.SDR1.R                 /* DSI Serialization Data Register 1 */
#define DSPI_4_ASDR1         DSPI_4.ASDR1.R                /* DSI Alternate Serialization Data Register 1 */
#define DSPI_4_COMPR1        DSPI_4.COMPR1.R               /* DSI Transmit Comparison Register 1 */
#define DSPI_4_DDR1          DSPI_4.DDR1.R                 /* DSI Deserialization Data Register 1 */
#define DSPI_4_SSR1          DSPI_4.SSR1.R                 /* DSI Serialization Source Select Register 1 */
#define DSPI_4_DIMR1         DSPI_4.DIMR1.R                /* DSI Deserialized Data Interrupt Mask Register 1 */
#define DSPI_4_DPIR1         DSPI_4.DPIR1.R                /* DSI Deserialized Data Polarity Interrupt Register 1 */
#define DSPI_4_CTARE0        DSPI_4.CTARE[0].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_4_CTARE1        DSPI_4.CTARE[1].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_4_CTARE2        DSPI_4.CTARE[2].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_4_CTARE3        DSPI_4.CTARE[3].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_4_CTARE4        DSPI_4.CTARE[4].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_4_CTARE5        DSPI_4.CTARE[5].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_4_CTARE6        DSPI_4.CTARE[6].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_4_CTARE7        DSPI_4.CTARE[7].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_4_SREX          DSPI_4.SREX.R                 /* Status Register Extended */
#define DSPI_4_TRIG          DSPI_4.TRIG.R                 /* Trigger Register */
#define DSPI_4_TSL           DSPI_4.TSL.R                  /* Time Slot Length Register */
#define DSPI_4_TS_CONF       DSPI_4.TS_CONF.R              /* Time Slot Configuration Register */

/* DSPI */
#define DSPI_M0_MCR          DSPI_M0.MCR.R                 /* Module Configuration Register */
#define DSPI_M0_TCR          DSPI_M0.TCR.R                 /* Transfer Count Register */
#define DSPI_M0_CTAR0        DSPI_M0.MODE.CTAR[0].R        /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_M0_CTAR1        DSPI_M0.MODE.CTAR[1].R        /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_M0_CTAR2        DSPI_M0.MODE.CTAR[2].R        /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_M0_CTAR3        DSPI_M0.MODE.CTAR[3].R        /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_M0_CTAR4        DSPI_M0.MODE.CTAR[4].R        /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_M0_CTAR5        DSPI_M0.MODE.CTAR[5].R        /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_M0_CTAR0_SLAVE  DSPI_M0.MODE.CTAR_SLAVE[0].R  /* Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_M0_CTAR1_SLAVE  DSPI_M0.MODE.CTAR_SLAVE[1].R  /* Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_M0_CTAR6        DSPI_M0.CTAR[0].R             /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_M0_CTAR7        DSPI_M0.CTAR[1].R             /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_M0_SR           DSPI_M0.SR.R                  /* Status Register */
#define DSPI_M0_RSER         DSPI_M0.RSER.R                /* DMA/Interrupt Request Select and Enable Register */
#define DSPI_M0_PUSHR        DSPI_M0.PUSHR.PUSHR.R         /* PUSH TX FIFO Register In Master Mode */
#define DSPI_M0_PUSHR_SLAVE  DSPI_M0.PUSHR.PUSHR_SLAVE.R   /* PUSH TX FIFO Register In Slave Mode */
#define DSPI_M0_POPR         DSPI_M0.POPR.R                /* POP RX FIFO Register */
#define DSPI_M0_TXFR0        DSPI_M0.TXFR[0].R             /* Transmit FIFO Registers */
#define DSPI_M0_TXFR1        DSPI_M0.TXFR[1].R             /* Transmit FIFO Registers */
#define DSPI_M0_TXFR2        DSPI_M0.TXFR[2].R             /* Transmit FIFO Registers */
#define DSPI_M0_TXFR3        DSPI_M0.TXFR[3].R             /* Transmit FIFO Registers */
#define DSPI_M0_RXFR0        DSPI_M0.RXFR[0].R             /* Receive FIFO Registers */
#define DSPI_M0_RXFR1        DSPI_M0.RXFR[1].R             /* Receive FIFO Registers */
#define DSPI_M0_RXFR2        DSPI_M0.RXFR[2].R             /* Receive FIFO Registers */
#define DSPI_M0_RXFR3        DSPI_M0.RXFR[3].R             /* Receive FIFO Registers */
#define DSPI_M0_DSICR0       DSPI_M0.DSICR0.R              /* DSI Configuration Register 0 */
#define DSPI_M0_SDR0         DSPI_M0.SDR0.R                /* DSI Serialization Data Register 0 */
#define DSPI_M0_ASDR0        DSPI_M0.ASDR0.R               /* DSI Alternate Serialization Data Register 0 */
#define DSPI_M0_COMPR0       DSPI_M0.COMPR0.R              /* DSI Transmit Comparison Register 0 */
#define DSPI_M0_DSICR1       DSPI_M0.DSICR1.R              /* DSI Configuration Register 1 */
#define DSPI_M0_SSR0         DSPI_M0.SSR0.R                /* DSI Serialization Source Select Register 0 */
#define DSPI_M0_SDR1         DSPI_M0.SDR1.R                /* DSI Serialization Data Register 1 */
#define DSPI_M0_ASDR1        DSPI_M0.ASDR1.R               /* DSI Alternate Serialization Data Register 1 */
#define DSPI_M0_COMPR1       DSPI_M0.COMPR1.R              /* DSI Transmit Comparison Register 1 */
#define DSPI_M0_DDR1         DSPI_M0.DDR1.R                /* DSI Deserialization Data Register 1 */
#define DSPI_M0_SSR1         DSPI_M0.SSR1.R                /* DSI Serialization Source Select Register 1 */
#define DSPI_M0_DIMR1        DSPI_M0.DIMR1.R               /* DSI Deserialized Data Interrupt Mask Register 1 */
#define DSPI_M0_DPIR1        DSPI_M0.DPIR1.R               /* DSI Deserialized Data Polarity Interrupt Register 1 */
#define DSPI_M0_CTARE0       DSPI_M0.CTARE[0].R            /* Clock and Transfer Attributes Register Extended */
#define DSPI_M0_CTARE1       DSPI_M0.CTARE[1].R            /* Clock and Transfer Attributes Register Extended */
#define DSPI_M0_CTARE2       DSPI_M0.CTARE[2].R            /* Clock and Transfer Attributes Register Extended */
#define DSPI_M0_CTARE3       DSPI_M0.CTARE[3].R            /* Clock and Transfer Attributes Register Extended */
#define DSPI_M0_CTARE4       DSPI_M0.CTARE[4].R            /* Clock and Transfer Attributes Register Extended */
#define DSPI_M0_CTARE5       DSPI_M0.CTARE[5].R            /* Clock and Transfer Attributes Register Extended */
#define DSPI_M0_CTARE6       DSPI_M0.CTARE[6].R            /* Clock and Transfer Attributes Register Extended */
#define DSPI_M0_CTARE7       DSPI_M0.CTARE[7].R            /* Clock and Transfer Attributes Register Extended */
#define DSPI_M0_SREX         DSPI_M0.SREX.R                /* Status Register Extended */
#define DSPI_M0_TRIG         DSPI_M0.TRIG.R                /* Trigger Register */
#define DSPI_M0_TSL          DSPI_M0.TSL.R                 /* Time Slot Length Register */
#define DSPI_M0_TS_CONF      DSPI_M0.TS_CONF.R             /* Time Slot Configuration Register */

/* DSPI */
#define DSPI_M1_MCR          DSPI_M1.MCR.R                 /* Module Configuration Register */
#define DSPI_M1_TCR          DSPI_M1.TCR.R                 /* Transfer Count Register */
#define DSPI_M1_CTAR0        DSPI_M1.MODE.CTAR[0].R        /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_M1_CTAR1        DSPI_M1.MODE.CTAR[1].R        /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_M1_CTAR2        DSPI_M1.MODE.CTAR[2].R        /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_M1_CTAR3        DSPI_M1.MODE.CTAR[3].R        /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_M1_CTAR4        DSPI_M1.MODE.CTAR[4].R        /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_M1_CTAR5        DSPI_M1.MODE.CTAR[5].R        /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_M1_CTAR0_SLAVE  DSPI_M1.MODE.CTAR_SLAVE[0].R  /* Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_M1_CTAR1_SLAVE  DSPI_M1.MODE.CTAR_SLAVE[1].R  /* Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_M1_CTAR6        DSPI_M1.CTAR[0].R             /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_M1_CTAR7        DSPI_M1.CTAR[1].R             /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_M1_SR           DSPI_M1.SR.R                  /* Status Register */
#define DSPI_M1_RSER         DSPI_M1.RSER.R                /* DMA/Interrupt Request Select and Enable Register */
#define DSPI_M1_PUSHR        DSPI_M1.PUSHR.PUSHR.R         /* PUSH TX FIFO Register In Master Mode */
#define DSPI_M1_PUSHR_SLAVE  DSPI_M1.PUSHR.PUSHR_SLAVE.R   /* PUSH TX FIFO Register In Slave Mode */
#define DSPI_M1_POPR         DSPI_M1.POPR.R                /* POP RX FIFO Register */
#define DSPI_M1_TXFR0        DSPI_M1.TXFR[0].R             /* Transmit FIFO Registers */
#define DSPI_M1_TXFR1        DSPI_M1.TXFR[1].R             /* Transmit FIFO Registers */
#define DSPI_M1_TXFR2        DSPI_M1.TXFR[2].R             /* Transmit FIFO Registers */
#define DSPI_M1_TXFR3        DSPI_M1.TXFR[3].R             /* Transmit FIFO Registers */
#define DSPI_M1_RXFR0        DSPI_M1.RXFR[0].R             /* Receive FIFO Registers */
#define DSPI_M1_RXFR1        DSPI_M1.RXFR[1].R             /* Receive FIFO Registers */
#define DSPI_M1_RXFR2        DSPI_M1.RXFR[2].R             /* Receive FIFO Registers */
#define DSPI_M1_RXFR3        DSPI_M1.RXFR[3].R             /* Receive FIFO Registers */
#define DSPI_M1_DSICR0       DSPI_M1.DSICR0.R              /* DSI Configuration Register 0 */
#define DSPI_M1_SDR0         DSPI_M1.SDR0.R                /* DSI Serialization Data Register 0 */
#define DSPI_M1_ASDR0        DSPI_M1.ASDR0.R               /* DSI Alternate Serialization Data Register 0 */
#define DSPI_M1_COMPR0       DSPI_M1.COMPR0.R              /* DSI Transmit Comparison Register 0 */
#define DSPI_M1_DSICR1       DSPI_M1.DSICR1.R              /* DSI Configuration Register 1 */
#define DSPI_M1_SSR0         DSPI_M1.SSR0.R                /* DSI Serialization Source Select Register 0 */
#define DSPI_M1_SDR1         DSPI_M1.SDR1.R                /* DSI Serialization Data Register 1 */
#define DSPI_M1_ASDR1        DSPI_M1.ASDR1.R               /* DSI Alternate Serialization Data Register 1 */
#define DSPI_M1_COMPR1       DSPI_M1.COMPR1.R              /* DSI Transmit Comparison Register 1 */
#define DSPI_M1_DDR1         DSPI_M1.DDR1.R                /* DSI Deserialization Data Register 1 */
#define DSPI_M1_SSR1         DSPI_M1.SSR1.R                /* DSI Serialization Source Select Register 1 */
#define DSPI_M1_DIMR1        DSPI_M1.DIMR1.R               /* DSI Deserialized Data Interrupt Mask Register 1 */
#define DSPI_M1_DPIR1        DSPI_M1.DPIR1.R               /* DSI Deserialized Data Polarity Interrupt Register 1 */
#define DSPI_M1_CTARE0       DSPI_M1.CTARE[0].R            /* Clock and Transfer Attributes Register Extended */
#define DSPI_M1_CTARE1       DSPI_M1.CTARE[1].R            /* Clock and Transfer Attributes Register Extended */
#define DSPI_M1_CTARE2       DSPI_M1.CTARE[2].R            /* Clock and Transfer Attributes Register Extended */
#define DSPI_M1_CTARE3       DSPI_M1.CTARE[3].R            /* Clock and Transfer Attributes Register Extended */
#define DSPI_M1_CTARE4       DSPI_M1.CTARE[4].R            /* Clock and Transfer Attributes Register Extended */
#define DSPI_M1_CTARE5       DSPI_M1.CTARE[5].R            /* Clock and Transfer Attributes Register Extended */
#define DSPI_M1_CTARE6       DSPI_M1.CTARE[6].R            /* Clock and Transfer Attributes Register Extended */
#define DSPI_M1_CTARE7       DSPI_M1.CTARE[7].R            /* Clock and Transfer Attributes Register Extended */
#define DSPI_M1_SREX         DSPI_M1.SREX.R                /* Status Register Extended */
#define DSPI_M1_TRIG         DSPI_M1.TRIG.R                /* Trigger Register */
#define DSPI_M1_TSL          DSPI_M1.TSL.R                 /* Time Slot Length Register */
#define DSPI_M1_TS_CONF      DSPI_M1.TS_CONF.R             /* Time Slot Configuration Register */

/* DTS */
#define DTS_ENABLE           DTS.ENABLE.R                  /* Output Enable Register */
#define DTS_STARTUP          DTS.STARTUP.R                 /* Startup Register */
#define DTS_SEMAPHORE        DTS.SEMAPHORE.R               /* Semaphore Register */
#define DTS_SEMAPHORE_B      DTS.SEMAPHORE_B.R             /* Semaphore Extension */

/* FCCU */
#define FCCU_CTRL            FCCU.CTRL.R                   /* Control Register */
#define FCCU_CTRLK           FCCU.CTRLK.R                  /* CTRL Key Register */
#define FCCU_CFG             FCCU.CFG.R                    /* Configuration Register */
#define FCCU_NCF_CFG0        FCCU.NCF_CFG[0].R             /* NCF Configuration Register */
#define FCCU_NCF_CFG1        FCCU.NCF_CFG[1].R             /* NCF Configuration Register */
#define FCCU_NCF_CFG2        FCCU.NCF_CFG[2].R             /* NCF Configuration Register */
#define FCCU_NCFS_CFG0       FCCU.NCFS_CFG[0].R            /* NCFS Configuration Register */
#define FCCU_NCFS_CFG1       FCCU.NCFS_CFG[1].R            /* NCFS Configuration Register */
#define FCCU_NCFS_CFG2       FCCU.NCFS_CFG[2].R            /* NCFS Configuration Register */
#define FCCU_NCFS_CFG3       FCCU.NCFS_CFG[3].R            /* NCFS Configuration Register */
#define FCCU_NCFS_CFG4       FCCU.NCFS_CFG[4].R            /* NCFS Configuration Register */
#define FCCU_NCFS_CFG5       FCCU.NCFS_CFG[5].R            /* NCFS Configuration Register */
#define FCCU_NCF_S0          FCCU.NCF_S[0].R               /* NCF Status Register */
#define FCCU_NCF_S1          FCCU.NCF_S[1].R               /* NCF Status Register */
#define FCCU_NCF_S2          FCCU.NCF_S[2].R               /* NCF Status Register */
#define FCCU_NCFK            FCCU.NCFK.R                   /* NCF Key Register */
#define FCCU_NCF_E0          FCCU.NCF_E[0].R               /* NCF Enable Register */
#define FCCU_NCF_E1          FCCU.NCF_E[1].R               /* NCF Enable Register */
#define FCCU_NCF_E2          FCCU.NCF_E[2].R               /* NCF Enable Register */
#define FCCU_NCF_TOE0        FCCU.NCF_TOE[0].R             /* NCF Time-out Enable Register */
#define FCCU_NCF_TOE1        FCCU.NCF_TOE[1].R             /* NCF Time-out Enable Register */
#define FCCU_NCF_TOE2        FCCU.NCF_TOE[2].R             /* NCF Time-out Enable Register */
#define FCCU_NCF_TO          FCCU.NCF_TO.R                 /* NCF Time-out Register */
#define FCCU_CFG_TO          FCCU.CFG_TO.R                 /* CFG Timeout Register */
#define FCCU_EINOUT          FCCU.EINOUT.R                 /* IO Control Register */
#define FCCU_STAT            FCCU.STAT.R                   /* Status Register */
#define FCCU_N2AF_STATUS     FCCU.N2AF_STATUS.R            /* NA Freeze Status Register */
#define FCCU_A2FF_STATUS     FCCU.A2FF_STATUS.R            /* AF Freeze Status Register */
#define FCCU_N2FF_STATUS     FCCU.N2FF_STATUS.R            /* NF Freeze Status Register */
#define FCCU_F2A_STATUS      FCCU.F2A_STATUS.R             /* FA Freeze Status Register */
#define FCCU_NCFF            FCCU.NCFF.R                   /* NCF Fake Register */
#define FCCU_IRQ_STAT        FCCU.IRQ_STAT.R               /* IRQ Status Register */
#define FCCU_IRQ_EN          FCCU.IRQ_EN.R                 /* IRQ Enable Register */
#define FCCU_XTMR            FCCU.XTMR.R                   /* XTMR Register */
#define FCCU_MCS             FCCU.MCS.R                    /* MCS Register */
#define FCCU_TRANS_LOCK      FCCU.TRANS_LOCK.R             /* Transient Lock Register */
#define FCCU_PERMNT_LOCK     FCCU.PERMNT_LOCK.R            /* Permanent Lock Register */
#define FCCU_DELTA_T         FCCU.DELTA_T.R                /* Delta T Register */
#define FCCU_IRQ_ALARM_EN0   FCCU.IRQ_ALARM_EN[0].R        /* IRQ Alarm Enable Register */
#define FCCU_IRQ_ALARM_EN1   FCCU.IRQ_ALARM_EN[1].R        /* IRQ Alarm Enable Register */
#define FCCU_IRQ_ALARM_EN2   FCCU.IRQ_ALARM_EN[2].R        /* IRQ Alarm Enable Register */
#define FCCU_NMI_EN0         FCCU.NMI_EN[0].R              /* NMI Enable Register */
#define FCCU_NMI_EN1         FCCU.NMI_EN[1].R              /* NMI Enable Register */
#define FCCU_NMI_EN2         FCCU.NMI_EN[2].R              /* NMI Enable Register */
#define FCCU_EOUT_SIG_EN0    FCCU.EOUT_SIG_EN[0].R         /* EOUT Signaling Enable Register */
#define FCCU_EOUT_SIG_EN1    FCCU.EOUT_SIG_EN[1].R         /* EOUT Signaling Enable Register */
#define FCCU_EOUT_SIG_EN2    FCCU.EOUT_SIG_EN[2].R         /* EOUT Signaling Enable Register */

/* FEC */
#define FEC_EIR              FEC.EIR.R                     /* Interrupt Event Register */
#define FEC_EIMR             FEC.EIMR.R                    /* Interrupt Mask Register */
#define FEC_RDAR             FEC.RDAR.R                    /* Receive Descriptor Active Register */
#define FEC_TDAR             FEC.TDAR.R                    /* Transmit Descriptor Active Register */
#define FEC_ECR              FEC.ECR.R                     /* Ethernet Control Register */
#define FEC_MMFR             FEC.MMFR.R                    /* MII Management Frame Register */
#define FEC_MSCR             FEC.MSCR.R                    /* MII Speed Control Register */
#define FEC_MIBC             FEC.MIBC.R                    /* MIB Control Register */
#define FEC_RCR              FEC.RCR.R                     /* Receive Control Register */
#define FEC_TCR              FEC.TCR.R                     /* Transmit Control Register */
#define FEC_PALR             FEC.PALR.R                    /* Physical Address Low Register */
#define FEC_PAUR             FEC.PAUR.R                    /* Physical Address High Register and Type Field */
#define FEC_OPD              FEC.OPD.R                     /* Opcode/Pause Duration */
#define FEC_IAUR             FEC.IAUR.R                    /* Descriptor Individual Upper Address Register */
#define FEC_IALR             FEC.IALR.R                    /* Descriptor Individual Lower Address Register */
#define FEC_GAUR             FEC.GAUR.R                    /* Descriptor Group Upper Address Register */
#define FEC_GALR             FEC.GALR.R                    /* Descriptor Group Lower Address Register */
#define FEC_TFWR             FEC.TFWR.R                    /* Transmit FIFO Watermark */
#define FEC_FRBR             FEC.FRBR.R                    /* FIFO Receive Bound Register */
#define FEC_FRSR             FEC.FRSR.R                    /* FIFO Receive Start Register */
#define FEC_ERDSR            FEC.ERDSR.R                   /* Receive Descriptor Ring Start Register */
#define FEC_ETDSR            FEC.ETDSR.R                   /* Transmit Buffer Descriptor Ring Start Register */
#define FEC_EMRBR            FEC.EMRBR.R                   /* Receive Buffer Size Register */
#define FEC_RMON_T_DROP      FEC.RMON_T_DROP.R             /* Count of frames not counted correctly */
#define FEC_RMON_T_PACKETS   FEC.RMON_T_PACKETS.R          /* RMON Tx packet count */
#define FEC_RMON_T_BC_PKT    FEC.RMON_T_BC_PKT.R           /* RMON Tx broadcast packets */
#define FEC_RMON_T_MC_PKT    FEC.RMON_T_MC_PKT.R           /* RMON Tx multicast packets */
#define FEC_RMON_T_CRC_ALIGN FEC.RMON_T_CRC_ALIGN.R        /* RMON Tx packets with CRC/align error */
#define FEC_RMON_T_UNDERSIZE FEC.RMON_T_UNDERSIZE.R        /* RMON Tx packets < 64 bytes, good CRC */
#define FEC_RMON_T_OVERSIZE  FEC.RMON_T_OVERSIZE.R         /* RMON Tx packets > MAX_FL bytes, good CRC */
#define FEC_RMON_T_FRAG      FEC.RMON_T_FRAG.R             /* RMON Tx packets < 64 bytes, bad CRC */
#define FEC_RMON_T_JAB       FEC.RMON_T_JAB.R              /* RMON Tx packets > MAX_FL bytes, bad CRC */
#define FEC_RMON_T_COL       FEC.RMON_T_COL.R              /* RMON Tx collision count */
#define FEC_RMON_T_P64       FEC.RMON_T_P64.R              /* RMON Tx 64 byte packets */
#define FEC_RMON_T_P65TO127  FEC.RMON_T_P65TO127.R         /* RMON Tx 65 to 127 byte packets */
#define FEC_RMON_T_P128TO255 FEC.RMON_T_P128TO255.R        /* RMON Tx 128 to 255 byte packets */
#define FEC_RMON_T_P256TO511 FEC.RMON_T_P256TO511.R        /* RMON Tx 256 to 511 byte packets */
#define FEC_RMON_T_P512TO1023 FEC.RMON_T_P512TO1023.R      /* RMON Tx 512 to 1023 byte packets */
#define FEC_RMON_T_P1024TO2047 FEC.RMON_T_P1024TO2047.R    /* RMON Tx 1024 to 2047 byte packets */
#define FEC_RMON_T_P_GTE2048 FEC.RMON_T_P_GTE2048.R        /* RMON Tx packets with > 2048 bytes */
#define FEC_RMON_T_OCTETS    FEC.RMON_T_OCTETS.R           /* RMON Tx Octets */
#define FEC_IEEE_T_DROP      FEC.IEEE_T_DROP.R             /* Count of transmitted frames not counted correctly */
#define FEC_IEEE_T_FRAME_OK  FEC.IEEE_T_FRAME_OK.R         /* Frames transmitted OK */
#define FEC_IEEE_T_1COL      FEC.IEEE_T_1COL.R             /* Frames transmitted with single collision */
#define FEC_IEEE_T_MCOL      FEC.IEEE_T_MCOL.R             /* Frames transmitted with multiple collisions */
#define FEC_IEEE_T_DEF       FEC.IEEE_T_DEF.R              /* Frames transmitted after deferral delay */
#define FEC_IEEE_T_LCOL      FEC.IEEE_T_LCOL.R             /* Frames transmitted with late collision */
#define FEC_IEEE_T_EXCOL     FEC.IEEE_T_EXCOL.R            /* Frames transmitted with excessive collisions */
#define FEC_IEEE_T_MACERR    FEC.IEEE_T_MACERR.R           /* Frames transmitted with Tx FIFO underrun */
#define FEC_IEEE_T_CSERR     FEC.IEEE_T_CSERR.R            /* Frames transmitted with carrier sense error */
#define FEC_IEEE_T_SQE       FEC.IEEE_T_SQE.R              /* Frames transmitted with SQE error */
#define FEC_IEEE_T_FDXFC     FEC.IEEE_T_FDXFC.R            /* Flow control pause frames transmitted */
#define FEC_IEEE_T_OCTETS_OK FEC.IEEE_T_OCTETS_OK.R        /* Octet count for frames transmitted without error */
#define FEC_RMON_R_DROP      FEC.RMON_R_DROP.R             /* Count of received frames not counted correctly */
#define FEC_RMON_R_PACKETS   FEC.RMON_R_PACKETS.R          /* RMON Rx packet count */
#define FEC_RMON_R_BC_PKT    FEC.RMON_R_BC_PKT.R           /* RMON Rx broadcast packets */
#define FEC_RMON_R_MC_PKT    FEC.RMON_R_MC_PKT.R           /* RMON Rx multicast packets */
#define FEC_RMON_R_CRC_ALIGN FEC.RMON_R_CRC_ALIGN.R        /* RMON Rx packets with CRC/Align error */
#define FEC_RMON_R_UNDERSIZE FEC.RMON_R_UNDERSIZE.R        /* RMON Rx packets < 64 bytes, good CRC */
#define FEC_RMON_R_OVERSIZE  FEC.RMON_R_OVERSIZE.R         /* RMON Rx packets > MAX_FL bytes, good CRC */
#define FEC_RMON_R_FRAG      FEC.RMON_R_FRAG.R             /* RMON Rx packets < 64 bytes, bad CRC */
#define FEC_RMON_R_JAB       FEC.RMON_R_JAB.R              /* RMON Rx packets > MAX_FL bytes, bad CRC */
#define FEC_RMON_R_RESVD_0   FEC.RMON_R_RESVD_0.R          /* Reserved */
#define FEC_RMON_R_P64       FEC.RMON_R_P64.R              /* RMON Rx 64 byte packets */
#define FEC_RMON_R_P65TO127  FEC.RMON_R_P65TO127.R         /* RMON Rx 65 to 127 byte packets */
#define FEC_RMON_R_P128TO255 FEC.RMON_R_P128TO255.R        /* RMON Rx 128 to 255 byte packets */
#define FEC_RMON_R_P256TO511 FEC.RMON_R_P256TO511.R        /* RMON Rx 256 to 511 byte packets */
#define FEC_RMON_R_P512TO1023 FEC.RMON_R_P512TO1023.R      /* RMON Rx 512 to 1023 byte packets */
#define FEC_RMON_R_P1024TO2047 FEC.RMON_R_P1024TO2047.R    /* RMON Rx 1024 to 2047 byte packets */
#define FEC_RMON_R_P_GTE2048 FEC.RMON_R_P_GTE2048.R        /* RMON Rx packets with > 2048 bytes */
#define FEC_RMON_R_OCTETS    FEC.RMON_R_OCTETS.R           /* RMON Rx octets */
#define FEC_IEEE_R_DROP      FEC.IEEE_R_DROP.R             /* Count of received frames not counted correctly */
#define FEC_IEEE_R_FRAME_OK  FEC.IEEE_R_FRAME_OK.R         /* Frames received OK */
#define FEC_IEEE_R_CRC       FEC.IEEE_R_CRC.R              /* Frames received with CRC error */
#define FEC_IEEE_R_ALIGN     FEC.IEEE_R_ALIGN.R            /* Frames received with alignment error */
#define FEC_IEEE_R_MACERR    FEC.IEEE_R_MACERR.R           /* Receive FIFO overflow count */
#define FEC_IEEE_R_FDXFC     FEC.IEEE_R_FDXFC.R            /* Flow control pause frames received */
#define FEC_IEEE_R_OCTETS_OK FEC.IEEE_R_OCTETS_OK.R        /* Octet count for frames received without error */

/* IGF */
#define IGF_MCR0             IGF.MCR.R                     /* Module Configuration Register */
#define IGF_MSR0             IGF.MSR0.R                    /* Module Status Register */
#define IGF_PRESR0           IGF.PRESR0.R                  /* Prescaler Register */
#define IGF_RTHR0            IGF.RTHR0.R                   /* Rising edge Threshold Register */
#define IGF_FTHR0            IGF.FTHR0.R                   /* Falling edge Threshold Register */
#define IGF_MCR1             IGF.MCR1.R                    /* Module Configuration Register */
#define IGF_MSR1             IGF.MSR1.R                    /* Module Status Register */
#define IGF_RTHR1            IGF.RTHR1.R                   /* Rising edge Threshold Register */
#define IGF_FTHR1            IGF.FTHR1.R                   /* Falling edge Threshold Register */
#define IGF_MCR2             IGF.MCR2.R                    /* Module Configuration Register */
#define IGF_MSR2             IGF.MSR2.R                    /* Module Status Register */
#define IGF_RTHR2            IGF.RTHR2.R                   /* Rising edge Threshold Register */
#define IGF_FTHR2            IGF.FTHR2.R                   /* Falling edge Threshold Register */
#define IGF_MCR3             IGF.MCR3.R                    /* Module Configuration Register */
#define IGF_MSR3             IGF.MSR3.R                    /* Module Status Register */
#define IGF_RTHR3            IGF.RTHR3.R                   /* Rising edge Threshold Register */
#define IGF_FTHR3            IGF.FTHR3.R                   /* Falling edge Threshold Register */
#define IGF_MCR4             IGF.MCR4.R                    /* Module Configuration Register */
#define IGF_MSR4             IGF.MSR4.R                    /* Module Status Register */
#define IGF_RTHR4            IGF.RTHR4.R                   /* Rising edge Threshold Register */
#define IGF_FTHR4            IGF.FTHR4.R                   /* Falling edge Threshold Register */
#define IGF_MCR5             IGF.MCR5.R                    /* Module Configuration Register */
#define IGF_MSR5             IGF.MSR5.R                    /* Module Status Register */
#define IGF_RTHR5            IGF.RTHR5.R                   /* Rising edge Threshold Register */
#define IGF_FTHR5            IGF.FTHR5.R                   /* Falling edge Threshold Register */
#define IGF_MCR6             IGF.MCR6.R                    /* Module Configuration Register */
#define IGF_MSR6             IGF.MSR6.R                    /* Module Status Register */
#define IGF_RTHR6            IGF.RTHR6.R                   /* Rising edge Threshold Register */
#define IGF_FTHR6            IGF.FTHR6.R                   /* Falling edge Threshold Register */
#define IGF_MCR7             IGF.MCR7.R                    /* Module Configuration Register */
#define IGF_MSR7             IGF.MSR7.R                    /* Module Status Register */
#define IGF_RTHR7            IGF.RTHR7.R                   /* Rising edge Threshold Register */
#define IGF_FTHR7            IGF.FTHR7.R                   /* Falling edge Threshold Register */
#define IGF_MCR8             IGF.MCR8.R                    /* Module Configuration Register */
#define IGF_MSR8             IGF.MSR8.R                    /* Module Status Register */
#define IGF_RTHR8            IGF.RTHR8.R                   /* Rising edge Threshold Register */
#define IGF_FTHR8            IGF.FTHR8.R                   /* Falling edge Threshold Register */
#define IGF_MCR9             IGF.MCR9.R                    /* Module Configuration Register */
#define IGF_MSR9             IGF.MSR9.R                    /* Module Status Register */
#define IGF_RTHR9            IGF.RTHR9.R                   /* Rising edge Threshold Register */
#define IGF_FTHR9            IGF.FTHR9.R                   /* Falling edge Threshold Register */
#define IGF_MCR10            IGF.MCR10.R                   /* Module Configuration Register */
#define IGF_MSR10            IGF.MSR10.R                   /* Module Status Register */
#define IGF_RTHR10           IGF.RTHR10.R                  /* Rising edge Threshold Register */
#define IGF_FTHR10           IGF.FTHR10.R                  /* Falling edge Threshold Register */
#define IGF_MCR11            IGF.MCR11.R                   /* Module Configuration Register */
#define IGF_MSR11            IGF.MSR11.R                   /* Module Status Register */
#define IGF_RTHR11           IGF.RTHR11.R                  /* Rising edge Threshold Register */
#define IGF_FTHR11           IGF.FTHR11.R                  /* Falling edge Threshold Register */
#define IGF_MCR12            IGF.MCR12.R                   /* Module Configuration Register */
#define IGF_MSR12            IGF.MSR12.R                   /* Module Status Register */
#define IGF_RTHR12           IGF.RTHR12.R                  /* Rising edge Threshold Register */
#define IGF_FTHR12           IGF.FTHR12.R                  /* Falling edge Threshold Register */
#define IGF_MCR13            IGF.MCR13.R                   /* Module Configuration Register */
#define IGF_MSR13            IGF.MSR13.R                   /* Module Status Register */
#define IGF_RTHR13           IGF.RTHR13.R                  /* Rising edge Threshold Register */
#define IGF_FTHR13           IGF.FTHR13.R                  /* Falling edge Threshold Register */
#define IGF_MCR14            IGF.MCR14.R                   /* Module Configuration Register */
#define IGF_MSR14            IGF.MSR14.R                   /* Module Status Register */
#define IGF_RTHR14           IGF.RTHR14.R                  /* Rising edge Threshold Register */
#define IGF_FTHR14           IGF.FTHR14.R                  /* Falling edge Threshold Register */
#define IGF_MCR15            IGF.MCR15.R                   /* Module Configuration Register */
#define IGF_MSR15            IGF.MSR15.R                   /* Module Status Register */
#define IGF_RTHR15           IGF.RTHR15.R                  /* Rising edge Threshold Register */
#define IGF_FTHR15           IGF.FTHR15.R                  /* Falling edge Threshold Register */
#define IGF_MCR16            IGF.MCR16.R                   /* Module Configuration Register */
#define IGF_MSR16            IGF.MSR16.R                   /* Module Status Register */
#define IGF_RTHR16           IGF.RTHR16.R                  /* Rising edge Threshold Register */
#define IGF_FTHR16           IGF.FTHR16.R                  /* Falling edge Threshold Register */
#define IGF_MCR17            IGF.MCR17.R                   /* Module Configuration Register */
#define IGF_MSR17            IGF.MSR17.R                   /* Module Status Register */
#define IGF_RTHR17           IGF.RTHR17.R                  /* Rising edge Threshold Register */
#define IGF_FTHR17           IGF.FTHR17.R                  /* Falling edge Threshold Register */
#define IGF_MCR18            IGF.MCR18.R                   /* Module Configuration Register */
#define IGF_MSR18            IGF.MSR18.R                   /* Module Status Register */
#define IGF_RTHR18           IGF.RTHR18.R                  /* Rising edge Threshold Register */
#define IGF_FTHR18           IGF.FTHR18.R                  /* Falling edge Threshold Register */
#define IGF_MCR19            IGF.MCR19.R                   /* Module Configuration Register */
#define IGF_MSR19            IGF.MSR19.R                   /* Module Status Register */
#define IGF_RTHR19           IGF.RTHR19.R                  /* Rising edge Threshold Register */
#define IGF_FTHR19           IGF.FTHR19.R                  /* Falling edge Threshold Register */
#define IGF_MCR20            IGF.MCR20.R                   /* Module Configuration Register */
#define IGF_MSR20            IGF.MSR20.R                   /* Module Status Register */
#define IGF_RTHR20           IGF.RTHR20.R                  /* Rising edge Threshold Register */
#define IGF_FTHR20           IGF.FTHR20.R                  /* Falling edge Threshold Register */
#define IGF_MCR21            IGF.MCR21.R                   /* Module Configuration Register */
#define IGF_MSR21            IGF.MSR21.R                   /* Module Status Register */
#define IGF_RTHR21           IGF.RTHR21.R                  /* Rising edge Threshold Register */
#define IGF_FTHR21           IGF.FTHR21.R                  /* Falling edge Threshold Register */
#define IGF_MCR22            IGF.MCR22.R                   /* Module Configuration Register */
#define IGF_MSR22            IGF.MSR22.R                   /* Module Status Register */
#define IGF_RTHR22           IGF.RTHR22.R                  /* Rising edge Threshold Register */
#define IGF_FTHR22           IGF.FTHR22.R                  /* Falling edge Threshold Register */
#define IGF_MCR23            IGF.MCR23.R                   /* Module Configuration Register */
#define IGF_MSR23            IGF.MSR23.R                   /* Module Status Register */
#define IGF_RTHR23           IGF.RTHR23.R                  /* Rising edge Threshold Register */
#define IGF_FTHR23           IGF.FTHR23.R                  /* Falling edge Threshold Register */
#define IGF_MCR24            IGF.MCR24.R                   /* Module Configuration Register */
#define IGF_MSR24            IGF.MSR24.R                   /* Module Status Register */
#define IGF_RTHR24           IGF.RTHR24.R                  /* Rising edge Threshold Register */
#define IGF_FTHR24           IGF.FTHR24.R                  /* Falling edge Threshold Register */
#define IGF_MCR25            IGF.MCR25.R                   /* Module Configuration Register */
#define IGF_MSR25            IGF.MSR25.R                   /* Module Status Register */
#define IGF_RTHR25           IGF.RTHR25.R                  /* Rising edge Threshold Register */
#define IGF_FTHR25           IGF.FTHR25.R                  /* Falling edge Threshold Register */
#define IGF_MCR26            IGF.MCR26.R                   /* Module Configuration Register */
#define IGF_MSR26            IGF.MSR26.R                   /* Module Status Register */
#define IGF_RTHR26           IGF.RTHR26.R                  /* Rising edge Threshold Register */
#define IGF_FTHR26           IGF.FTHR26.R                  /* Falling edge Threshold Register */
#define IGF_MCR27            IGF.MCR27.R                   /* Module Configuration Register */
#define IGF_MSR27            IGF.MSR27.R                   /* Module Status Register */
#define IGF_RTHR27           IGF.RTHR27.R                  /* Rising edge Threshold Register */
#define IGF_FTHR27           IGF.FTHR27.R                  /* Falling edge Threshold Register */
#define IGF_MCR28            IGF.MCR28.R                   /* Module Configuration Register */
#define IGF_MSR28            IGF.MSR28.R                   /* Module Status Register */
#define IGF_RTHR28           IGF.RTHR28.R                  /* Rising edge Threshold Register */
#define IGF_FTHR28           IGF.FTHR28.R                  /* Falling edge Threshold Register */
#define IGF_MCR29            IGF.MCR29.R                   /* Module Configuration Register */
#define IGF_MSR29            IGF.MSR29.R                   /* Module Status Register */
#define IGF_RTHR29           IGF.RTHR29.R                  /* Rising edge Threshold Register */
#define IGF_FTHR29           IGF.FTHR29.R                  /* Falling edge Threshold Register */
#define IGF_MCR30            IGF.MCR30.R                   /* Module Configuration Register */
#define IGF_MSR30            IGF.MSR30.R                   /* Module Status Register */
#define IGF_RTHR30           IGF.RTHR30.R                  /* Rising edge Threshold Register */
#define IGF_FTHR30           IGF.FTHR30.R                  /* Falling edge Threshold Register */
#define IGF_MCR31            IGF.MCR31.R                   /* Module Configuration Register */
#define IGF_MSR31            IGF.MSR31.R                   /* Module Status Register */
#define IGF_RTHR31           IGF.RTHR31.R                  /* Rising edge Threshold Register */
#define IGF_FTHR31           IGF.FTHR31.R                  /* Falling edge Threshold Register */

/* INTC */
#define INTC_0_BCR           INTC_0.BCR.R                  /* INTC Block Configuration Register */
#define INTC_0_CPR0          INTC_0.CPR[0].R               /* INTC Current Priority Register for Processor n */
#define INTC_0_CPR1          INTC_0.CPR[1].R               /* INTC Current Priority Register for Processor n */
#define INTC_0_IACKR0        INTC_0.IACKR[0].R             /* INTC Interrupt Acknowledge Register for Processor n */
#define INTC_0_IACKR1        INTC_0.IACKR[1].R             /* INTC Interrupt Acknowledge Register for Processor n */
#define INTC_0_EOIR0         INTC_0.EOIR[0].R              /* INTC End Of Interrupt Register for Processor n */
#define INTC_0_EOIR1         INTC_0.EOIR[1].R              /* INTC End Of Interrupt Register for Processor n */
#define INTC_0_SSCIR0        INTC_0.SSCIR[0].R             /* INTC Software Set/Clear Interrupt Register */
#define INTC_0_SSCIR1        INTC_0.SSCIR[1].R             /* INTC Software Set/Clear Interrupt Register */
#define INTC_0_SSCIR2        INTC_0.SSCIR[2].R             /* INTC Software Set/Clear Interrupt Register */
#define INTC_0_SSCIR3        INTC_0.SSCIR[3].R             /* INTC Software Set/Clear Interrupt Register */
#define INTC_0_SSCIR4        INTC_0.SSCIR[4].R             /* INTC Software Set/Clear Interrupt Register */
#define INTC_0_SSCIR5        INTC_0.SSCIR[5].R             /* INTC Software Set/Clear Interrupt Register */
#define INTC_0_SSCIR6        INTC_0.SSCIR[6].R             /* INTC Software Set/Clear Interrupt Register */
#define INTC_0_SSCIR7        INTC_0.SSCIR[7].R             /* INTC Software Set/Clear Interrupt Register */
#define INTC_0_SSCIR8        INTC_0.SSCIR[8].R             /* INTC Software Set/Clear Interrupt Register */
#define INTC_0_SSCIR9        INTC_0.SSCIR[9].R             /* INTC Software Set/Clear Interrupt Register */
#define INTC_0_SSCIR10       INTC_0.SSCIR[10].R            /* INTC Software Set/Clear Interrupt Register */
#define INTC_0_SSCIR11       INTC_0.SSCIR[11].R            /* INTC Software Set/Clear Interrupt Register */
#define INTC_0_SSCIR12       INTC_0.SSCIR[12].R            /* INTC Software Set/Clear Interrupt Register */
#define INTC_0_SSCIR13       INTC_0.SSCIR[13].R            /* INTC Software Set/Clear Interrupt Register */
#define INTC_0_SSCIR14       INTC_0.SSCIR[14].R            /* INTC Software Set/Clear Interrupt Register */
#define INTC_0_SSCIR15       INTC_0.SSCIR[15].R            /* INTC Software Set/Clear Interrupt Register */
#define INTC_0_SSCIR16       INTC_0.SSCIR[16].R            /* INTC Software Set/Clear Interrupt Register */
#define INTC_0_SSCIR17       INTC_0.SSCIR[17].R            /* INTC Software Set/Clear Interrupt Register */
#define INTC_0_SSCIR18       INTC_0.SSCIR[18].R            /* INTC Software Set/Clear Interrupt Register */
#define INTC_0_SSCIR19       INTC_0.SSCIR[19].R            /* INTC Software Set/Clear Interrupt Register */
#define INTC_0_SSCIR20       INTC_0.SSCIR[20].R            /* INTC Software Set/Clear Interrupt Register */
#define INTC_0_SSCIR21       INTC_0.SSCIR[21].R            /* INTC Software Set/Clear Interrupt Register */
#define INTC_0_SSCIR22       INTC_0.SSCIR[22].R            /* INTC Software Set/Clear Interrupt Register */
#define INTC_0_SSCIR23       INTC_0.SSCIR[23].R            /* INTC Software Set/Clear Interrupt Register */
#define INTC_0_SSCIR24       INTC_0.SSCIR[24].R            /* INTC Software Set/Clear Interrupt Register */
#define INTC_0_SSCIR25       INTC_0.SSCIR[25].R            /* INTC Software Set/Clear Interrupt Register */
#define INTC_0_SSCIR26       INTC_0.SSCIR[26].R            /* INTC Software Set/Clear Interrupt Register */
#define INTC_0_SSCIR27       INTC_0.SSCIR[27].R            /* INTC Software Set/Clear Interrupt Register */
#define INTC_0_SSCIR28       INTC_0.SSCIR[28].R            /* INTC Software Set/Clear Interrupt Register */
#define INTC_0_SSCIR29       INTC_0.SSCIR[29].R            /* INTC Software Set/Clear Interrupt Register */
#define INTC_0_SSCIR30       INTC_0.SSCIR[30].R            /* INTC Software Set/Clear Interrupt Register */
#define INTC_0_SSCIR31       INTC_0.SSCIR[31].R            /* INTC Software Set/Clear Interrupt Register */
#define INTC_0_PSR0          INTC_0.PSR[0].R               /* INTC Priority Select Register */
#define INTC_0_PSR1          INTC_0.PSR[1].R               /* INTC Priority Select Register */
#define INTC_0_PSR2          INTC_0.PSR[2].R               /* INTC Priority Select Register */
#define INTC_0_PSR3          INTC_0.PSR[3].R               /* INTC Priority Select Register */
#define INTC_0_PSR4          INTC_0.PSR[4].R               /* INTC Priority Select Register */
#define INTC_0_PSR5          INTC_0.PSR[5].R               /* INTC Priority Select Register */
#define INTC_0_PSR6          INTC_0.PSR[6].R               /* INTC Priority Select Register */
#define INTC_0_PSR7          INTC_0.PSR[7].R               /* INTC Priority Select Register */
#define INTC_0_PSR8          INTC_0.PSR[8].R               /* INTC Priority Select Register */
#define INTC_0_PSR9          INTC_0.PSR[9].R               /* INTC Priority Select Register */
#define INTC_0_PSR10         INTC_0.PSR[10].R              /* INTC Priority Select Register */
#define INTC_0_PSR11         INTC_0.PSR[11].R              /* INTC Priority Select Register */
#define INTC_0_PSR12         INTC_0.PSR[12].R              /* INTC Priority Select Register */
#define INTC_0_PSR13         INTC_0.PSR[13].R              /* INTC Priority Select Register */
#define INTC_0_PSR14         INTC_0.PSR[14].R              /* INTC Priority Select Register */
#define INTC_0_PSR15         INTC_0.PSR[15].R              /* INTC Priority Select Register */
#define INTC_0_PSR16         INTC_0.PSR[16].R              /* INTC Priority Select Register */
#define INTC_0_PSR17         INTC_0.PSR[17].R              /* INTC Priority Select Register */
#define INTC_0_PSR18         INTC_0.PSR[18].R              /* INTC Priority Select Register */
#define INTC_0_PSR19         INTC_0.PSR[19].R              /* INTC Priority Select Register */
#define INTC_0_PSR20         INTC_0.PSR[20].R              /* INTC Priority Select Register */
#define INTC_0_PSR21         INTC_0.PSR[21].R              /* INTC Priority Select Register */
#define INTC_0_PSR22         INTC_0.PSR[22].R              /* INTC Priority Select Register */
#define INTC_0_PSR23         INTC_0.PSR[23].R              /* INTC Priority Select Register */
#define INTC_0_PSR24         INTC_0.PSR[24].R              /* INTC Priority Select Register */
#define INTC_0_PSR25         INTC_0.PSR[25].R              /* INTC Priority Select Register */
#define INTC_0_PSR26         INTC_0.PSR[26].R              /* INTC Priority Select Register */
#define INTC_0_PSR27         INTC_0.PSR[27].R              /* INTC Priority Select Register */
#define INTC_0_PSR28         INTC_0.PSR[28].R              /* INTC Priority Select Register */
#define INTC_0_PSR29         INTC_0.PSR[29].R              /* INTC Priority Select Register */
#define INTC_0_PSR30         INTC_0.PSR[30].R              /* INTC Priority Select Register */
#define INTC_0_PSR31         INTC_0.PSR[31].R              /* INTC Priority Select Register */
#define INTC_0_PSR32         INTC_0.PSR[32].R              /* INTC Priority Select Register */
#define INTC_0_PSR33         INTC_0.PSR[33].R              /* INTC Priority Select Register */
#define INTC_0_PSR34         INTC_0.PSR[34].R              /* INTC Priority Select Register */
#define INTC_0_PSR35         INTC_0.PSR[35].R              /* INTC Priority Select Register */
#define INTC_0_PSR36         INTC_0.PSR[36].R              /* INTC Priority Select Register */
#define INTC_0_PSR37         INTC_0.PSR[37].R              /* INTC Priority Select Register */
#define INTC_0_PSR38         INTC_0.PSR[38].R              /* INTC Priority Select Register */
#define INTC_0_PSR39         INTC_0.PSR[39].R              /* INTC Priority Select Register */
#define INTC_0_PSR40         INTC_0.PSR[40].R              /* INTC Priority Select Register */
#define INTC_0_PSR41         INTC_0.PSR[41].R              /* INTC Priority Select Register */
#define INTC_0_PSR42         INTC_0.PSR[42].R              /* INTC Priority Select Register */
#define INTC_0_PSR43         INTC_0.PSR[43].R              /* INTC Priority Select Register */
#define INTC_0_PSR44         INTC_0.PSR[44].R              /* INTC Priority Select Register */
#define INTC_0_PSR45         INTC_0.PSR[45].R              /* INTC Priority Select Register */
#define INTC_0_PSR46         INTC_0.PSR[46].R              /* INTC Priority Select Register */
#define INTC_0_PSR47         INTC_0.PSR[47].R              /* INTC Priority Select Register */
#define INTC_0_PSR48         INTC_0.PSR[48].R              /* INTC Priority Select Register */
#define INTC_0_PSR49         INTC_0.PSR[49].R              /* INTC Priority Select Register */
#define INTC_0_PSR50         INTC_0.PSR[50].R              /* INTC Priority Select Register */
#define INTC_0_PSR51         INTC_0.PSR[51].R              /* INTC Priority Select Register */
#define INTC_0_PSR52         INTC_0.PSR[52].R              /* INTC Priority Select Register */
#define INTC_0_PSR53         INTC_0.PSR[53].R              /* INTC Priority Select Register */
#define INTC_0_PSR54         INTC_0.PSR[54].R              /* INTC Priority Select Register */
#define INTC_0_PSR55         INTC_0.PSR[55].R              /* INTC Priority Select Register */
#define INTC_0_PSR56         INTC_0.PSR[56].R              /* INTC Priority Select Register */
#define INTC_0_PSR57         INTC_0.PSR[57].R              /* INTC Priority Select Register */
#define INTC_0_PSR58         INTC_0.PSR[58].R              /* INTC Priority Select Register */
#define INTC_0_PSR59         INTC_0.PSR[59].R              /* INTC Priority Select Register */
#define INTC_0_PSR60         INTC_0.PSR[60].R              /* INTC Priority Select Register */
#define INTC_0_PSR61         INTC_0.PSR[61].R              /* INTC Priority Select Register */
#define INTC_0_PSR62         INTC_0.PSR[62].R              /* INTC Priority Select Register */
#define INTC_0_PSR63         INTC_0.PSR[63].R              /* INTC Priority Select Register */
#define INTC_0_PSR64         INTC_0.PSR[64].R              /* INTC Priority Select Register */
#define INTC_0_PSR65         INTC_0.PSR[65].R              /* INTC Priority Select Register */
#define INTC_0_PSR66         INTC_0.PSR[66].R              /* INTC Priority Select Register */
#define INTC_0_PSR67         INTC_0.PSR[67].R              /* INTC Priority Select Register */
#define INTC_0_PSR68         INTC_0.PSR[68].R              /* INTC Priority Select Register */
#define INTC_0_PSR69         INTC_0.PSR[69].R              /* INTC Priority Select Register */
#define INTC_0_PSR70         INTC_0.PSR[70].R              /* INTC Priority Select Register */
#define INTC_0_PSR71         INTC_0.PSR[71].R              /* INTC Priority Select Register */
#define INTC_0_PSR72         INTC_0.PSR[72].R              /* INTC Priority Select Register */
#define INTC_0_PSR73         INTC_0.PSR[73].R              /* INTC Priority Select Register */
#define INTC_0_PSR74         INTC_0.PSR[74].R              /* INTC Priority Select Register */
#define INTC_0_PSR75         INTC_0.PSR[75].R              /* INTC Priority Select Register */
#define INTC_0_PSR76         INTC_0.PSR[76].R              /* INTC Priority Select Register */
#define INTC_0_PSR77         INTC_0.PSR[77].R              /* INTC Priority Select Register */
#define INTC_0_PSR78         INTC_0.PSR[78].R              /* INTC Priority Select Register */
#define INTC_0_PSR79         INTC_0.PSR[79].R              /* INTC Priority Select Register */
#define INTC_0_PSR80         INTC_0.PSR[80].R              /* INTC Priority Select Register */
#define INTC_0_PSR81         INTC_0.PSR[81].R              /* INTC Priority Select Register */
#define INTC_0_PSR82         INTC_0.PSR[82].R              /* INTC Priority Select Register */
#define INTC_0_PSR83         INTC_0.PSR[83].R              /* INTC Priority Select Register */
#define INTC_0_PSR84         INTC_0.PSR[84].R              /* INTC Priority Select Register */
#define INTC_0_PSR85         INTC_0.PSR[85].R              /* INTC Priority Select Register */
#define INTC_0_PSR86         INTC_0.PSR[86].R              /* INTC Priority Select Register */
#define INTC_0_PSR87         INTC_0.PSR[87].R              /* INTC Priority Select Register */
#define INTC_0_PSR88         INTC_0.PSR[88].R              /* INTC Priority Select Register */
#define INTC_0_PSR89         INTC_0.PSR[89].R              /* INTC Priority Select Register */
#define INTC_0_PSR90         INTC_0.PSR[90].R              /* INTC Priority Select Register */
#define INTC_0_PSR91         INTC_0.PSR[91].R              /* INTC Priority Select Register */
#define INTC_0_PSR92         INTC_0.PSR[92].R              /* INTC Priority Select Register */
#define INTC_0_PSR93         INTC_0.PSR[93].R              /* INTC Priority Select Register */
#define INTC_0_PSR94         INTC_0.PSR[94].R              /* INTC Priority Select Register */
#define INTC_0_PSR95         INTC_0.PSR[95].R              /* INTC Priority Select Register */
#define INTC_0_PSR96         INTC_0.PSR[96].R              /* INTC Priority Select Register */
#define INTC_0_PSR97         INTC_0.PSR[97].R              /* INTC Priority Select Register */
#define INTC_0_PSR98         INTC_0.PSR[98].R              /* INTC Priority Select Register */
#define INTC_0_PSR99         INTC_0.PSR[99].R              /* INTC Priority Select Register */
#define INTC_0_PSR100        INTC_0.PSR[100].R             /* INTC Priority Select Register */
#define INTC_0_PSR101        INTC_0.PSR[101].R             /* INTC Priority Select Register */
#define INTC_0_PSR102        INTC_0.PSR[102].R             /* INTC Priority Select Register */
#define INTC_0_PSR103        INTC_0.PSR[103].R             /* INTC Priority Select Register */
#define INTC_0_PSR104        INTC_0.PSR[104].R             /* INTC Priority Select Register */
#define INTC_0_PSR105        INTC_0.PSR[105].R             /* INTC Priority Select Register */
#define INTC_0_PSR106        INTC_0.PSR[106].R             /* INTC Priority Select Register */
#define INTC_0_PSR107        INTC_0.PSR[107].R             /* INTC Priority Select Register */
#define INTC_0_PSR108        INTC_0.PSR[108].R             /* INTC Priority Select Register */
#define INTC_0_PSR109        INTC_0.PSR[109].R             /* INTC Priority Select Register */
#define INTC_0_PSR110        INTC_0.PSR[110].R             /* INTC Priority Select Register */
#define INTC_0_PSR111        INTC_0.PSR[111].R             /* INTC Priority Select Register */
#define INTC_0_PSR112        INTC_0.PSR[112].R             /* INTC Priority Select Register */
#define INTC_0_PSR113        INTC_0.PSR[113].R             /* INTC Priority Select Register */
#define INTC_0_PSR114        INTC_0.PSR[114].R             /* INTC Priority Select Register */
#define INTC_0_PSR115        INTC_0.PSR[115].R             /* INTC Priority Select Register */
#define INTC_0_PSR116        INTC_0.PSR[116].R             /* INTC Priority Select Register */
#define INTC_0_PSR117        INTC_0.PSR[117].R             /* INTC Priority Select Register */
#define INTC_0_PSR118        INTC_0.PSR[118].R             /* INTC Priority Select Register */
#define INTC_0_PSR119        INTC_0.PSR[119].R             /* INTC Priority Select Register */
#define INTC_0_PSR120        INTC_0.PSR[120].R             /* INTC Priority Select Register */
#define INTC_0_PSR121        INTC_0.PSR[121].R             /* INTC Priority Select Register */
#define INTC_0_PSR122        INTC_0.PSR[122].R             /* INTC Priority Select Register */
#define INTC_0_PSR123        INTC_0.PSR[123].R             /* INTC Priority Select Register */
#define INTC_0_PSR124        INTC_0.PSR[124].R             /* INTC Priority Select Register */
#define INTC_0_PSR125        INTC_0.PSR[125].R             /* INTC Priority Select Register */
#define INTC_0_PSR126        INTC_0.PSR[126].R             /* INTC Priority Select Register */
#define INTC_0_PSR127        INTC_0.PSR[127].R             /* INTC Priority Select Register */
#define INTC_0_PSR128        INTC_0.PSR[128].R             /* INTC Priority Select Register */
#define INTC_0_PSR129        INTC_0.PSR[129].R             /* INTC Priority Select Register */
#define INTC_0_PSR130        INTC_0.PSR[130].R             /* INTC Priority Select Register */
#define INTC_0_PSR131        INTC_0.PSR[131].R             /* INTC Priority Select Register */
#define INTC_0_PSR132        INTC_0.PSR[132].R             /* INTC Priority Select Register */
#define INTC_0_PSR133        INTC_0.PSR[133].R             /* INTC Priority Select Register */
#define INTC_0_PSR134        INTC_0.PSR[134].R             /* INTC Priority Select Register */
#define INTC_0_PSR135        INTC_0.PSR[135].R             /* INTC Priority Select Register */
#define INTC_0_PSR136        INTC_0.PSR[136].R             /* INTC Priority Select Register */
#define INTC_0_PSR137        INTC_0.PSR[137].R             /* INTC Priority Select Register */
#define INTC_0_PSR138        INTC_0.PSR[138].R             /* INTC Priority Select Register */
#define INTC_0_PSR139        INTC_0.PSR[139].R             /* INTC Priority Select Register */
#define INTC_0_PSR140        INTC_0.PSR[140].R             /* INTC Priority Select Register */
#define INTC_0_PSR141        INTC_0.PSR[141].R             /* INTC Priority Select Register */
#define INTC_0_PSR142        INTC_0.PSR[142].R             /* INTC Priority Select Register */
#define INTC_0_PSR143        INTC_0.PSR[143].R             /* INTC Priority Select Register */
#define INTC_0_PSR144        INTC_0.PSR[144].R             /* INTC Priority Select Register */
#define INTC_0_PSR145        INTC_0.PSR[145].R             /* INTC Priority Select Register */
#define INTC_0_PSR146        INTC_0.PSR[146].R             /* INTC Priority Select Register */
#define INTC_0_PSR147        INTC_0.PSR[147].R             /* INTC Priority Select Register */
#define INTC_0_PSR148        INTC_0.PSR[148].R             /* INTC Priority Select Register */
#define INTC_0_PSR149        INTC_0.PSR[149].R             /* INTC Priority Select Register */
#define INTC_0_PSR150        INTC_0.PSR[150].R             /* INTC Priority Select Register */
#define INTC_0_PSR151        INTC_0.PSR[151].R             /* INTC Priority Select Register */
#define INTC_0_PSR152        INTC_0.PSR[152].R             /* INTC Priority Select Register */
#define INTC_0_PSR153        INTC_0.PSR[153].R             /* INTC Priority Select Register */
#define INTC_0_PSR154        INTC_0.PSR[154].R             /* INTC Priority Select Register */
#define INTC_0_PSR155        INTC_0.PSR[155].R             /* INTC Priority Select Register */
#define INTC_0_PSR156        INTC_0.PSR[156].R             /* INTC Priority Select Register */
#define INTC_0_PSR157        INTC_0.PSR[157].R             /* INTC Priority Select Register */
#define INTC_0_PSR158        INTC_0.PSR[158].R             /* INTC Priority Select Register */
#define INTC_0_PSR159        INTC_0.PSR[159].R             /* INTC Priority Select Register */
#define INTC_0_PSR160        INTC_0.PSR[160].R             /* INTC Priority Select Register */
#define INTC_0_PSR161        INTC_0.PSR[161].R             /* INTC Priority Select Register */
#define INTC_0_PSR162        INTC_0.PSR[162].R             /* INTC Priority Select Register */
#define INTC_0_PSR163        INTC_0.PSR[163].R             /* INTC Priority Select Register */
#define INTC_0_PSR164        INTC_0.PSR[164].R             /* INTC Priority Select Register */
#define INTC_0_PSR165        INTC_0.PSR[165].R             /* INTC Priority Select Register */
#define INTC_0_PSR166        INTC_0.PSR[166].R             /* INTC Priority Select Register */
#define INTC_0_PSR167        INTC_0.PSR[167].R             /* INTC Priority Select Register */
#define INTC_0_PSR168        INTC_0.PSR[168].R             /* INTC Priority Select Register */
#define INTC_0_PSR169        INTC_0.PSR[169].R             /* INTC Priority Select Register */
#define INTC_0_PSR170        INTC_0.PSR[170].R             /* INTC Priority Select Register */
#define INTC_0_PSR171        INTC_0.PSR[171].R             /* INTC Priority Select Register */
#define INTC_0_PSR172        INTC_0.PSR[172].R             /* INTC Priority Select Register */
#define INTC_0_PSR173        INTC_0.PSR[173].R             /* INTC Priority Select Register */
#define INTC_0_PSR174        INTC_0.PSR[174].R             /* INTC Priority Select Register */
#define INTC_0_PSR175        INTC_0.PSR[175].R             /* INTC Priority Select Register */
#define INTC_0_PSR176        INTC_0.PSR[176].R             /* INTC Priority Select Register */
#define INTC_0_PSR177        INTC_0.PSR[177].R             /* INTC Priority Select Register */
#define INTC_0_PSR178        INTC_0.PSR[178].R             /* INTC Priority Select Register */
#define INTC_0_PSR179        INTC_0.PSR[179].R             /* INTC Priority Select Register */
#define INTC_0_PSR180        INTC_0.PSR[180].R             /* INTC Priority Select Register */
#define INTC_0_PSR181        INTC_0.PSR[181].R             /* INTC Priority Select Register */
#define INTC_0_PSR182        INTC_0.PSR[182].R             /* INTC Priority Select Register */
#define INTC_0_PSR183        INTC_0.PSR[183].R             /* INTC Priority Select Register */
#define INTC_0_PSR184        INTC_0.PSR[184].R             /* INTC Priority Select Register */
#define INTC_0_PSR185        INTC_0.PSR[185].R             /* INTC Priority Select Register */
#define INTC_0_PSR186        INTC_0.PSR[186].R             /* INTC Priority Select Register */
#define INTC_0_PSR187        INTC_0.PSR[187].R             /* INTC Priority Select Register */
#define INTC_0_PSR188        INTC_0.PSR[188].R             /* INTC Priority Select Register */
#define INTC_0_PSR189        INTC_0.PSR[189].R             /* INTC Priority Select Register */
#define INTC_0_PSR190        INTC_0.PSR[190].R             /* INTC Priority Select Register */
#define INTC_0_PSR191        INTC_0.PSR[191].R             /* INTC Priority Select Register */
#define INTC_0_PSR192        INTC_0.PSR[192].R             /* INTC Priority Select Register */
#define INTC_0_PSR193        INTC_0.PSR[193].R             /* INTC Priority Select Register */
#define INTC_0_PSR194        INTC_0.PSR[194].R             /* INTC Priority Select Register */
#define INTC_0_PSR195        INTC_0.PSR[195].R             /* INTC Priority Select Register */
#define INTC_0_PSR196        INTC_0.PSR[196].R             /* INTC Priority Select Register */
#define INTC_0_PSR197        INTC_0.PSR[197].R             /* INTC Priority Select Register */
#define INTC_0_PSR198        INTC_0.PSR[198].R             /* INTC Priority Select Register */
#define INTC_0_PSR199        INTC_0.PSR[199].R             /* INTC Priority Select Register */
#define INTC_0_PSR200        INTC_0.PSR[200].R             /* INTC Priority Select Register */
#define INTC_0_PSR201        INTC_0.PSR[201].R             /* INTC Priority Select Register */
#define INTC_0_PSR202        INTC_0.PSR[202].R             /* INTC Priority Select Register */
#define INTC_0_PSR203        INTC_0.PSR[203].R             /* INTC Priority Select Register */
#define INTC_0_PSR204        INTC_0.PSR[204].R             /* INTC Priority Select Register */
#define INTC_0_PSR205        INTC_0.PSR[205].R             /* INTC Priority Select Register */
#define INTC_0_PSR206        INTC_0.PSR[206].R             /* INTC Priority Select Register */
#define INTC_0_PSR207        INTC_0.PSR[207].R             /* INTC Priority Select Register */
#define INTC_0_PSR208        INTC_0.PSR[208].R             /* INTC Priority Select Register */
#define INTC_0_PSR209        INTC_0.PSR[209].R             /* INTC Priority Select Register */
#define INTC_0_PSR210        INTC_0.PSR[210].R             /* INTC Priority Select Register */
#define INTC_0_PSR211        INTC_0.PSR[211].R             /* INTC Priority Select Register */
#define INTC_0_PSR212        INTC_0.PSR[212].R             /* INTC Priority Select Register */
#define INTC_0_PSR213        INTC_0.PSR[213].R             /* INTC Priority Select Register */
#define INTC_0_PSR214        INTC_0.PSR[214].R             /* INTC Priority Select Register */
#define INTC_0_PSR215        INTC_0.PSR[215].R             /* INTC Priority Select Register */
#define INTC_0_PSR216        INTC_0.PSR[216].R             /* INTC Priority Select Register */
#define INTC_0_PSR217        INTC_0.PSR[217].R             /* INTC Priority Select Register */
#define INTC_0_PSR218        INTC_0.PSR[218].R             /* INTC Priority Select Register */
#define INTC_0_PSR219        INTC_0.PSR[219].R             /* INTC Priority Select Register */
#define INTC_0_PSR220        INTC_0.PSR[220].R             /* INTC Priority Select Register */
#define INTC_0_PSR221        INTC_0.PSR[221].R             /* INTC Priority Select Register */
#define INTC_0_PSR222        INTC_0.PSR[222].R             /* INTC Priority Select Register */
#define INTC_0_PSR223        INTC_0.PSR[223].R             /* INTC Priority Select Register */
#define INTC_0_PSR224        INTC_0.PSR[224].R             /* INTC Priority Select Register */
#define INTC_0_PSR225        INTC_0.PSR[225].R             /* INTC Priority Select Register */
#define INTC_0_PSR226        INTC_0.PSR[226].R             /* INTC Priority Select Register */
#define INTC_0_PSR227        INTC_0.PSR[227].R             /* INTC Priority Select Register */
#define INTC_0_PSR228        INTC_0.PSR[228].R             /* INTC Priority Select Register */
#define INTC_0_PSR229        INTC_0.PSR[229].R             /* INTC Priority Select Register */
#define INTC_0_PSR230        INTC_0.PSR[230].R             /* INTC Priority Select Register */
#define INTC_0_PSR231        INTC_0.PSR[231].R             /* INTC Priority Select Register */
#define INTC_0_PSR232        INTC_0.PSR[232].R             /* INTC Priority Select Register */
#define INTC_0_PSR233        INTC_0.PSR[233].R             /* INTC Priority Select Register */
#define INTC_0_PSR234        INTC_0.PSR[234].R             /* INTC Priority Select Register */
#define INTC_0_PSR235        INTC_0.PSR[235].R             /* INTC Priority Select Register */
#define INTC_0_PSR236        INTC_0.PSR[236].R             /* INTC Priority Select Register */
#define INTC_0_PSR237        INTC_0.PSR[237].R             /* INTC Priority Select Register */
#define INTC_0_PSR238        INTC_0.PSR[238].R             /* INTC Priority Select Register */
#define INTC_0_PSR239        INTC_0.PSR[239].R             /* INTC Priority Select Register */
#define INTC_0_PSR240        INTC_0.PSR[240].R             /* INTC Priority Select Register */
#define INTC_0_PSR241        INTC_0.PSR[241].R             /* INTC Priority Select Register */
#define INTC_0_PSR242        INTC_0.PSR[242].R             /* INTC Priority Select Register */
#define INTC_0_PSR243        INTC_0.PSR[243].R             /* INTC Priority Select Register */
#define INTC_0_PSR244        INTC_0.PSR[244].R             /* INTC Priority Select Register */
#define INTC_0_PSR245        INTC_0.PSR[245].R             /* INTC Priority Select Register */
#define INTC_0_PSR246        INTC_0.PSR[246].R             /* INTC Priority Select Register */
#define INTC_0_PSR247        INTC_0.PSR[247].R             /* INTC Priority Select Register */
#define INTC_0_PSR248        INTC_0.PSR[248].R             /* INTC Priority Select Register */
#define INTC_0_PSR249        INTC_0.PSR[249].R             /* INTC Priority Select Register */
#define INTC_0_PSR250        INTC_0.PSR[250].R             /* INTC Priority Select Register */
#define INTC_0_PSR251        INTC_0.PSR[251].R             /* INTC Priority Select Register */
#define INTC_0_PSR252        INTC_0.PSR[252].R             /* INTC Priority Select Register */
#define INTC_0_PSR253        INTC_0.PSR[253].R             /* INTC Priority Select Register */
#define INTC_0_PSR254        INTC_0.PSR[254].R             /* INTC Priority Select Register */
#define INTC_0_PSR255        INTC_0.PSR[255].R             /* INTC Priority Select Register */
#define INTC_0_PSR256        INTC_0.PSR[256].R             /* INTC Priority Select Register */
#define INTC_0_PSR257        INTC_0.PSR[257].R             /* INTC Priority Select Register */
#define INTC_0_PSR258        INTC_0.PSR[258].R             /* INTC Priority Select Register */
#define INTC_0_PSR259        INTC_0.PSR[259].R             /* INTC Priority Select Register */
#define INTC_0_PSR260        INTC_0.PSR[260].R             /* INTC Priority Select Register */
#define INTC_0_PSR261        INTC_0.PSR[261].R             /* INTC Priority Select Register */
#define INTC_0_PSR262        INTC_0.PSR[262].R             /* INTC Priority Select Register */
#define INTC_0_PSR263        INTC_0.PSR[263].R             /* INTC Priority Select Register */
#define INTC_0_PSR264        INTC_0.PSR[264].R             /* INTC Priority Select Register */
#define INTC_0_PSR265        INTC_0.PSR[265].R             /* INTC Priority Select Register */
#define INTC_0_PSR266        INTC_0.PSR[266].R             /* INTC Priority Select Register */
#define INTC_0_PSR267        INTC_0.PSR[267].R             /* INTC Priority Select Register */
#define INTC_0_PSR268        INTC_0.PSR[268].R             /* INTC Priority Select Register */
#define INTC_0_PSR269        INTC_0.PSR[269].R             /* INTC Priority Select Register */
#define INTC_0_PSR270        INTC_0.PSR[270].R             /* INTC Priority Select Register */
#define INTC_0_PSR271        INTC_0.PSR[271].R             /* INTC Priority Select Register */
#define INTC_0_PSR272        INTC_0.PSR[272].R             /* INTC Priority Select Register */
#define INTC_0_PSR273        INTC_0.PSR[273].R             /* INTC Priority Select Register */
#define INTC_0_PSR274        INTC_0.PSR[274].R             /* INTC Priority Select Register */
#define INTC_0_PSR275        INTC_0.PSR[275].R             /* INTC Priority Select Register */
#define INTC_0_PSR276        INTC_0.PSR[276].R             /* INTC Priority Select Register */
#define INTC_0_PSR277        INTC_0.PSR[277].R             /* INTC Priority Select Register */
#define INTC_0_PSR278        INTC_0.PSR[278].R             /* INTC Priority Select Register */
#define INTC_0_PSR279        INTC_0.PSR[279].R             /* INTC Priority Select Register */
#define INTC_0_PSR280        INTC_0.PSR[280].R             /* INTC Priority Select Register */
#define INTC_0_PSR281        INTC_0.PSR[281].R             /* INTC Priority Select Register */
#define INTC_0_PSR282        INTC_0.PSR[282].R             /* INTC Priority Select Register */
#define INTC_0_PSR283        INTC_0.PSR[283].R             /* INTC Priority Select Register */
#define INTC_0_PSR284        INTC_0.PSR[284].R             /* INTC Priority Select Register */
#define INTC_0_PSR285        INTC_0.PSR[285].R             /* INTC Priority Select Register */
#define INTC_0_PSR286        INTC_0.PSR[286].R             /* INTC Priority Select Register */
#define INTC_0_PSR287        INTC_0.PSR[287].R             /* INTC Priority Select Register */
#define INTC_0_PSR288        INTC_0.PSR[288].R             /* INTC Priority Select Register */
#define INTC_0_PSR289        INTC_0.PSR[289].R             /* INTC Priority Select Register */
#define INTC_0_PSR290        INTC_0.PSR[290].R             /* INTC Priority Select Register */
#define INTC_0_PSR291        INTC_0.PSR[291].R             /* INTC Priority Select Register */
#define INTC_0_PSR292        INTC_0.PSR[292].R             /* INTC Priority Select Register */
#define INTC_0_PSR293        INTC_0.PSR[293].R             /* INTC Priority Select Register */
#define INTC_0_PSR294        INTC_0.PSR[294].R             /* INTC Priority Select Register */
#define INTC_0_PSR295        INTC_0.PSR[295].R             /* INTC Priority Select Register */
#define INTC_0_PSR296        INTC_0.PSR[296].R             /* INTC Priority Select Register */
#define INTC_0_PSR297        INTC_0.PSR[297].R             /* INTC Priority Select Register */
#define INTC_0_PSR298        INTC_0.PSR[298].R             /* INTC Priority Select Register */
#define INTC_0_PSR299        INTC_0.PSR[299].R             /* INTC Priority Select Register */
#define INTC_0_PSR300        INTC_0.PSR[300].R             /* INTC Priority Select Register */
#define INTC_0_PSR301        INTC_0.PSR[301].R             /* INTC Priority Select Register */
#define INTC_0_PSR302        INTC_0.PSR[302].R             /* INTC Priority Select Register */
#define INTC_0_PSR303        INTC_0.PSR[303].R             /* INTC Priority Select Register */
#define INTC_0_PSR304        INTC_0.PSR[304].R             /* INTC Priority Select Register */
#define INTC_0_PSR305        INTC_0.PSR[305].R             /* INTC Priority Select Register */
#define INTC_0_PSR306        INTC_0.PSR[306].R             /* INTC Priority Select Register */
#define INTC_0_PSR307        INTC_0.PSR[307].R             /* INTC Priority Select Register */
#define INTC_0_PSR308        INTC_0.PSR[308].R             /* INTC Priority Select Register */
#define INTC_0_PSR309        INTC_0.PSR[309].R             /* INTC Priority Select Register */
#define INTC_0_PSR310        INTC_0.PSR[310].R             /* INTC Priority Select Register */
#define INTC_0_PSR311        INTC_0.PSR[311].R             /* INTC Priority Select Register */
#define INTC_0_PSR312        INTC_0.PSR[312].R             /* INTC Priority Select Register */
#define INTC_0_PSR313        INTC_0.PSR[313].R             /* INTC Priority Select Register */
#define INTC_0_PSR314        INTC_0.PSR[314].R             /* INTC Priority Select Register */
#define INTC_0_PSR315        INTC_0.PSR[315].R             /* INTC Priority Select Register */
#define INTC_0_PSR316        INTC_0.PSR[316].R             /* INTC Priority Select Register */
#define INTC_0_PSR317        INTC_0.PSR[317].R             /* INTC Priority Select Register */
#define INTC_0_PSR318        INTC_0.PSR[318].R             /* INTC Priority Select Register */
#define INTC_0_PSR319        INTC_0.PSR[319].R             /* INTC Priority Select Register */
#define INTC_0_PSR320        INTC_0.PSR[320].R             /* INTC Priority Select Register */
#define INTC_0_PSR321        INTC_0.PSR[321].R             /* INTC Priority Select Register */
#define INTC_0_PSR322        INTC_0.PSR[322].R             /* INTC Priority Select Register */
#define INTC_0_PSR323        INTC_0.PSR[323].R             /* INTC Priority Select Register */
#define INTC_0_PSR324        INTC_0.PSR[324].R             /* INTC Priority Select Register */
#define INTC_0_PSR325        INTC_0.PSR[325].R             /* INTC Priority Select Register */
#define INTC_0_PSR326        INTC_0.PSR[326].R             /* INTC Priority Select Register */
#define INTC_0_PSR327        INTC_0.PSR[327].R             /* INTC Priority Select Register */
#define INTC_0_PSR328        INTC_0.PSR[328].R             /* INTC Priority Select Register */
#define INTC_0_PSR329        INTC_0.PSR[329].R             /* INTC Priority Select Register */
#define INTC_0_PSR330        INTC_0.PSR[330].R             /* INTC Priority Select Register */
#define INTC_0_PSR331        INTC_0.PSR[331].R             /* INTC Priority Select Register */
#define INTC_0_PSR332        INTC_0.PSR[332].R             /* INTC Priority Select Register */
#define INTC_0_PSR333        INTC_0.PSR[333].R             /* INTC Priority Select Register */
#define INTC_0_PSR334        INTC_0.PSR[334].R             /* INTC Priority Select Register */
#define INTC_0_PSR335        INTC_0.PSR[335].R             /* INTC Priority Select Register */
#define INTC_0_PSR336        INTC_0.PSR[336].R             /* INTC Priority Select Register */
#define INTC_0_PSR337        INTC_0.PSR[337].R             /* INTC Priority Select Register */
#define INTC_0_PSR338        INTC_0.PSR[338].R             /* INTC Priority Select Register */
#define INTC_0_PSR339        INTC_0.PSR[339].R             /* INTC Priority Select Register */
#define INTC_0_PSR340        INTC_0.PSR[340].R             /* INTC Priority Select Register */
#define INTC_0_PSR341        INTC_0.PSR[341].R             /* INTC Priority Select Register */
#define INTC_0_PSR342        INTC_0.PSR[342].R             /* INTC Priority Select Register */
#define INTC_0_PSR343        INTC_0.PSR[343].R             /* INTC Priority Select Register */
#define INTC_0_PSR344        INTC_0.PSR[344].R             /* INTC Priority Select Register */
#define INTC_0_PSR345        INTC_0.PSR[345].R             /* INTC Priority Select Register */
#define INTC_0_PSR346        INTC_0.PSR[346].R             /* INTC Priority Select Register */
#define INTC_0_PSR347        INTC_0.PSR[347].R             /* INTC Priority Select Register */
#define INTC_0_PSR348        INTC_0.PSR[348].R             /* INTC Priority Select Register */
#define INTC_0_PSR349        INTC_0.PSR[349].R             /* INTC Priority Select Register */
#define INTC_0_PSR350        INTC_0.PSR[350].R             /* INTC Priority Select Register */
#define INTC_0_PSR351        INTC_0.PSR[351].R             /* INTC Priority Select Register */
#define INTC_0_PSR352        INTC_0.PSR[352].R             /* INTC Priority Select Register */
#define INTC_0_PSR353        INTC_0.PSR[353].R             /* INTC Priority Select Register */
#define INTC_0_PSR354        INTC_0.PSR[354].R             /* INTC Priority Select Register */
#define INTC_0_PSR355        INTC_0.PSR[355].R             /* INTC Priority Select Register */
#define INTC_0_PSR356        INTC_0.PSR[356].R             /* INTC Priority Select Register */
#define INTC_0_PSR357        INTC_0.PSR[357].R             /* INTC Priority Select Register */
#define INTC_0_PSR358        INTC_0.PSR[358].R             /* INTC Priority Select Register */
#define INTC_0_PSR359        INTC_0.PSR[359].R             /* INTC Priority Select Register */
#define INTC_0_PSR360        INTC_0.PSR[360].R             /* INTC Priority Select Register */
#define INTC_0_PSR361        INTC_0.PSR[361].R             /* INTC Priority Select Register */
#define INTC_0_PSR362        INTC_0.PSR[362].R             /* INTC Priority Select Register */
#define INTC_0_PSR363        INTC_0.PSR[363].R             /* INTC Priority Select Register */
#define INTC_0_PSR364        INTC_0.PSR[364].R             /* INTC Priority Select Register */
#define INTC_0_PSR365        INTC_0.PSR[365].R             /* INTC Priority Select Register */
#define INTC_0_PSR366        INTC_0.PSR[366].R             /* INTC Priority Select Register */
#define INTC_0_PSR367        INTC_0.PSR[367].R             /* INTC Priority Select Register */
#define INTC_0_PSR368        INTC_0.PSR[368].R             /* INTC Priority Select Register */
#define INTC_0_PSR369        INTC_0.PSR[369].R             /* INTC Priority Select Register */
#define INTC_0_PSR370        INTC_0.PSR[370].R             /* INTC Priority Select Register */
#define INTC_0_PSR371        INTC_0.PSR[371].R             /* INTC Priority Select Register */
#define INTC_0_PSR372        INTC_0.PSR[372].R             /* INTC Priority Select Register */
#define INTC_0_PSR373        INTC_0.PSR[373].R             /* INTC Priority Select Register */
#define INTC_0_PSR374        INTC_0.PSR[374].R             /* INTC Priority Select Register */
#define INTC_0_PSR375        INTC_0.PSR[375].R             /* INTC Priority Select Register */
#define INTC_0_PSR376        INTC_0.PSR[376].R             /* INTC Priority Select Register */
#define INTC_0_PSR377        INTC_0.PSR[377].R             /* INTC Priority Select Register */
#define INTC_0_PSR378        INTC_0.PSR[378].R             /* INTC Priority Select Register */
#define INTC_0_PSR379        INTC_0.PSR[379].R             /* INTC Priority Select Register */
#define INTC_0_PSR380        INTC_0.PSR[380].R             /* INTC Priority Select Register */
#define INTC_0_PSR381        INTC_0.PSR[381].R             /* INTC Priority Select Register */
#define INTC_0_PSR382        INTC_0.PSR[382].R             /* INTC Priority Select Register */
#define INTC_0_PSR383        INTC_0.PSR[383].R             /* INTC Priority Select Register */
#define INTC_0_PSR384        INTC_0.PSR[384].R             /* INTC Priority Select Register */
#define INTC_0_PSR385        INTC_0.PSR[385].R             /* INTC Priority Select Register */
#define INTC_0_PSR386        INTC_0.PSR[386].R             /* INTC Priority Select Register */
#define INTC_0_PSR387        INTC_0.PSR[387].R             /* INTC Priority Select Register */
#define INTC_0_PSR388        INTC_0.PSR[388].R             /* INTC Priority Select Register */
#define INTC_0_PSR389        INTC_0.PSR[389].R             /* INTC Priority Select Register */
#define INTC_0_PSR390        INTC_0.PSR[390].R             /* INTC Priority Select Register */
#define INTC_0_PSR391        INTC_0.PSR[391].R             /* INTC Priority Select Register */
#define INTC_0_PSR392        INTC_0.PSR[392].R             /* INTC Priority Select Register */
#define INTC_0_PSR393        INTC_0.PSR[393].R             /* INTC Priority Select Register */
#define INTC_0_PSR394        INTC_0.PSR[394].R             /* INTC Priority Select Register */
#define INTC_0_PSR395        INTC_0.PSR[395].R             /* INTC Priority Select Register */
#define INTC_0_PSR396        INTC_0.PSR[396].R             /* INTC Priority Select Register */
#define INTC_0_PSR397        INTC_0.PSR[397].R             /* INTC Priority Select Register */
#define INTC_0_PSR398        INTC_0.PSR[398].R             /* INTC Priority Select Register */
#define INTC_0_PSR399        INTC_0.PSR[399].R             /* INTC Priority Select Register */
#define INTC_0_PSR400        INTC_0.PSR[400].R             /* INTC Priority Select Register */
#define INTC_0_PSR401        INTC_0.PSR[401].R             /* INTC Priority Select Register */
#define INTC_0_PSR402        INTC_0.PSR[402].R             /* INTC Priority Select Register */
#define INTC_0_PSR403        INTC_0.PSR[403].R             /* INTC Priority Select Register */
#define INTC_0_PSR404        INTC_0.PSR[404].R             /* INTC Priority Select Register */
#define INTC_0_PSR405        INTC_0.PSR[405].R             /* INTC Priority Select Register */
#define INTC_0_PSR406        INTC_0.PSR[406].R             /* INTC Priority Select Register */
#define INTC_0_PSR407        INTC_0.PSR[407].R             /* INTC Priority Select Register */
#define INTC_0_PSR408        INTC_0.PSR[408].R             /* INTC Priority Select Register */
#define INTC_0_PSR409        INTC_0.PSR[409].R             /* INTC Priority Select Register */
#define INTC_0_PSR410        INTC_0.PSR[410].R             /* INTC Priority Select Register */
#define INTC_0_PSR411        INTC_0.PSR[411].R             /* INTC Priority Select Register */
#define INTC_0_PSR412        INTC_0.PSR[412].R             /* INTC Priority Select Register */
#define INTC_0_PSR413        INTC_0.PSR[413].R             /* INTC Priority Select Register */
#define INTC_0_PSR414        INTC_0.PSR[414].R             /* INTC Priority Select Register */
#define INTC_0_PSR415        INTC_0.PSR[415].R             /* INTC Priority Select Register */
#define INTC_0_PSR416        INTC_0.PSR[416].R             /* INTC Priority Select Register */
#define INTC_0_PSR417        INTC_0.PSR[417].R             /* INTC Priority Select Register */
#define INTC_0_PSR418        INTC_0.PSR[418].R             /* INTC Priority Select Register */
#define INTC_0_PSR419        INTC_0.PSR[419].R             /* INTC Priority Select Register */
#define INTC_0_PSR420        INTC_0.PSR[420].R             /* INTC Priority Select Register */
#define INTC_0_PSR421        INTC_0.PSR[421].R             /* INTC Priority Select Register */
#define INTC_0_PSR422        INTC_0.PSR[422].R             /* INTC Priority Select Register */
#define INTC_0_PSR423        INTC_0.PSR[423].R             /* INTC Priority Select Register */
#define INTC_0_PSR424        INTC_0.PSR[424].R             /* INTC Priority Select Register */
#define INTC_0_PSR425        INTC_0.PSR[425].R             /* INTC Priority Select Register */
#define INTC_0_PSR426        INTC_0.PSR[426].R             /* INTC Priority Select Register */
#define INTC_0_PSR427        INTC_0.PSR[427].R             /* INTC Priority Select Register */
#define INTC_0_PSR428        INTC_0.PSR[428].R             /* INTC Priority Select Register */
#define INTC_0_PSR429        INTC_0.PSR[429].R             /* INTC Priority Select Register */
#define INTC_0_PSR430        INTC_0.PSR[430].R             /* INTC Priority Select Register */
#define INTC_0_PSR431        INTC_0.PSR[431].R             /* INTC Priority Select Register */
#define INTC_0_PSR432        INTC_0.PSR[432].R             /* INTC Priority Select Register */
#define INTC_0_PSR433        INTC_0.PSR[433].R             /* INTC Priority Select Register */
#define INTC_0_PSR434        INTC_0.PSR[434].R             /* INTC Priority Select Register */
#define INTC_0_PSR435        INTC_0.PSR[435].R             /* INTC Priority Select Register */
#define INTC_0_PSR436        INTC_0.PSR[436].R             /* INTC Priority Select Register */
#define INTC_0_PSR437        INTC_0.PSR[437].R             /* INTC Priority Select Register */
#define INTC_0_PSR438        INTC_0.PSR[438].R             /* INTC Priority Select Register */
#define INTC_0_PSR439        INTC_0.PSR[439].R             /* INTC Priority Select Register */
#define INTC_0_PSR440        INTC_0.PSR[440].R             /* INTC Priority Select Register */
#define INTC_0_PSR441        INTC_0.PSR[441].R             /* INTC Priority Select Register */
#define INTC_0_PSR442        INTC_0.PSR[442].R             /* INTC Priority Select Register */
#define INTC_0_PSR443        INTC_0.PSR[443].R             /* INTC Priority Select Register */
#define INTC_0_PSR444        INTC_0.PSR[444].R             /* INTC Priority Select Register */
#define INTC_0_PSR445        INTC_0.PSR[445].R             /* INTC Priority Select Register */
#define INTC_0_PSR446        INTC_0.PSR[446].R             /* INTC Priority Select Register */
#define INTC_0_PSR447        INTC_0.PSR[447].R             /* INTC Priority Select Register */
#define INTC_0_PSR448        INTC_0.PSR[448].R             /* INTC Priority Select Register */
#define INTC_0_PSR449        INTC_0.PSR[449].R             /* INTC Priority Select Register */
#define INTC_0_PSR450        INTC_0.PSR[450].R             /* INTC Priority Select Register */
#define INTC_0_PSR451        INTC_0.PSR[451].R             /* INTC Priority Select Register */
#define INTC_0_PSR452        INTC_0.PSR[452].R             /* INTC Priority Select Register */
#define INTC_0_PSR453        INTC_0.PSR[453].R             /* INTC Priority Select Register */
#define INTC_0_PSR454        INTC_0.PSR[454].R             /* INTC Priority Select Register */
#define INTC_0_PSR455        INTC_0.PSR[455].R             /* INTC Priority Select Register */
#define INTC_0_PSR456        INTC_0.PSR[456].R             /* INTC Priority Select Register */
#define INTC_0_PSR457        INTC_0.PSR[457].R             /* INTC Priority Select Register */
#define INTC_0_PSR458        INTC_0.PSR[458].R             /* INTC Priority Select Register */
#define INTC_0_PSR459        INTC_0.PSR[459].R             /* INTC Priority Select Register */
#define INTC_0_PSR460        INTC_0.PSR[460].R             /* INTC Priority Select Register */
#define INTC_0_PSR461        INTC_0.PSR[461].R             /* INTC Priority Select Register */
#define INTC_0_PSR462        INTC_0.PSR[462].R             /* INTC Priority Select Register */
#define INTC_0_PSR463        INTC_0.PSR[463].R             /* INTC Priority Select Register */
#define INTC_0_PSR464        INTC_0.PSR[464].R             /* INTC Priority Select Register */
#define INTC_0_PSR465        INTC_0.PSR[465].R             /* INTC Priority Select Register */
#define INTC_0_PSR466        INTC_0.PSR[466].R             /* INTC Priority Select Register */
#define INTC_0_PSR467        INTC_0.PSR[467].R             /* INTC Priority Select Register */
#define INTC_0_PSR468        INTC_0.PSR[468].R             /* INTC Priority Select Register */
#define INTC_0_PSR469        INTC_0.PSR[469].R             /* INTC Priority Select Register */
#define INTC_0_PSR470        INTC_0.PSR[470].R             /* INTC Priority Select Register */
#define INTC_0_PSR471        INTC_0.PSR[471].R             /* INTC Priority Select Register */
#define INTC_0_PSR472        INTC_0.PSR[472].R             /* INTC Priority Select Register */
#define INTC_0_PSR473        INTC_0.PSR[473].R             /* INTC Priority Select Register */
#define INTC_0_PSR474        INTC_0.PSR[474].R             /* INTC Priority Select Register */
#define INTC_0_PSR475        INTC_0.PSR[475].R             /* INTC Priority Select Register */
#define INTC_0_PSR476        INTC_0.PSR[476].R             /* INTC Priority Select Register */
#define INTC_0_PSR477        INTC_0.PSR[477].R             /* INTC Priority Select Register */
#define INTC_0_PSR478        INTC_0.PSR[478].R             /* INTC Priority Select Register */
#define INTC_0_PSR479        INTC_0.PSR[479].R             /* INTC Priority Select Register */
#define INTC_0_PSR480        INTC_0.PSR[480].R             /* INTC Priority Select Register */
#define INTC_0_PSR481        INTC_0.PSR[481].R             /* INTC Priority Select Register */
#define INTC_0_PSR482        INTC_0.PSR[482].R             /* INTC Priority Select Register */
#define INTC_0_PSR483        INTC_0.PSR[483].R             /* INTC Priority Select Register */
#define INTC_0_PSR484        INTC_0.PSR[484].R             /* INTC Priority Select Register */
#define INTC_0_PSR485        INTC_0.PSR[485].R             /* INTC Priority Select Register */
#define INTC_0_PSR486        INTC_0.PSR[486].R             /* INTC Priority Select Register */
#define INTC_0_PSR487        INTC_0.PSR[487].R             /* INTC Priority Select Register */
#define INTC_0_PSR488        INTC_0.PSR[488].R             /* INTC Priority Select Register */
#define INTC_0_PSR489        INTC_0.PSR[489].R             /* INTC Priority Select Register */
#define INTC_0_PSR490        INTC_0.PSR[490].R             /* INTC Priority Select Register */
#define INTC_0_PSR491        INTC_0.PSR[491].R             /* INTC Priority Select Register */
#define INTC_0_PSR492        INTC_0.PSR[492].R             /* INTC Priority Select Register */
#define INTC_0_PSR493        INTC_0.PSR[493].R             /* INTC Priority Select Register */
#define INTC_0_PSR494        INTC_0.PSR[494].R             /* INTC Priority Select Register */
#define INTC_0_PSR495        INTC_0.PSR[495].R             /* INTC Priority Select Register */
#define INTC_0_PSR496        INTC_0.PSR[496].R             /* INTC Priority Select Register */
#define INTC_0_PSR497        INTC_0.PSR[497].R             /* INTC Priority Select Register */
#define INTC_0_PSR498        INTC_0.PSR[498].R             /* INTC Priority Select Register */
#define INTC_0_PSR499        INTC_0.PSR[499].R             /* INTC Priority Select Register */
#define INTC_0_PSR500        INTC_0.PSR[500].R             /* INTC Priority Select Register */
#define INTC_0_PSR501        INTC_0.PSR[501].R             /* INTC Priority Select Register */
#define INTC_0_PSR502        INTC_0.PSR[502].R             /* INTC Priority Select Register */
#define INTC_0_PSR503        INTC_0.PSR[503].R             /* INTC Priority Select Register */
#define INTC_0_PSR504        INTC_0.PSR[504].R             /* INTC Priority Select Register */
#define INTC_0_PSR505        INTC_0.PSR[505].R             /* INTC Priority Select Register */
#define INTC_0_PSR506        INTC_0.PSR[506].R             /* INTC Priority Select Register */
#define INTC_0_PSR507        INTC_0.PSR[507].R             /* INTC Priority Select Register */
#define INTC_0_PSR508        INTC_0.PSR[508].R             /* INTC Priority Select Register */
#define INTC_0_PSR509        INTC_0.PSR[509].R             /* INTC Priority Select Register */
#define INTC_0_PSR510        INTC_0.PSR[510].R             /* INTC Priority Select Register */
#define INTC_0_PSR511        INTC_0.PSR[511].R             /* INTC Priority Select Register */
#define INTC_0_PSR512        INTC_0.PSR[512].R             /* INTC Priority Select Register */
#define INTC_0_PSR513        INTC_0.PSR[513].R             /* INTC Priority Select Register */
#define INTC_0_PSR514        INTC_0.PSR[514].R             /* INTC Priority Select Register */
#define INTC_0_PSR515        INTC_0.PSR[515].R             /* INTC Priority Select Register */
#define INTC_0_PSR516        INTC_0.PSR[516].R             /* INTC Priority Select Register */
#define INTC_0_PSR517        INTC_0.PSR[517].R             /* INTC Priority Select Register */
#define INTC_0_PSR518        INTC_0.PSR[518].R             /* INTC Priority Select Register */
#define INTC_0_PSR519        INTC_0.PSR[519].R             /* INTC Priority Select Register */
#define INTC_0_PSR520        INTC_0.PSR[520].R             /* INTC Priority Select Register */
#define INTC_0_PSR521        INTC_0.PSR[521].R             /* INTC Priority Select Register */
#define INTC_0_PSR522        INTC_0.PSR[522].R             /* INTC Priority Select Register */
#define INTC_0_PSR523        INTC_0.PSR[523].R             /* INTC Priority Select Register */
#define INTC_0_PSR524        INTC_0.PSR[524].R             /* INTC Priority Select Register */
#define INTC_0_PSR525        INTC_0.PSR[525].R             /* INTC Priority Select Register */
#define INTC_0_PSR526        INTC_0.PSR[526].R             /* INTC Priority Select Register */
#define INTC_0_PSR527        INTC_0.PSR[527].R             /* INTC Priority Select Register */
#define INTC_0_PSR528        INTC_0.PSR[528].R             /* INTC Priority Select Register */
#define INTC_0_PSR529        INTC_0.PSR[529].R             /* INTC Priority Select Register */
#define INTC_0_PSR530        INTC_0.PSR[530].R             /* INTC Priority Select Register */
#define INTC_0_PSR531        INTC_0.PSR[531].R             /* INTC Priority Select Register */
#define INTC_0_PSR532        INTC_0.PSR[532].R             /* INTC Priority Select Register */
#define INTC_0_PSR533        INTC_0.PSR[533].R             /* INTC Priority Select Register */
#define INTC_0_PSR534        INTC_0.PSR[534].R             /* INTC Priority Select Register */
#define INTC_0_PSR535        INTC_0.PSR[535].R             /* INTC Priority Select Register */
#define INTC_0_PSR536        INTC_0.PSR[536].R             /* INTC Priority Select Register */
#define INTC_0_PSR537        INTC_0.PSR[537].R             /* INTC Priority Select Register */
#define INTC_0_PSR538        INTC_0.PSR[538].R             /* INTC Priority Select Register */
#define INTC_0_PSR539        INTC_0.PSR[539].R             /* INTC Priority Select Register */
#define INTC_0_PSR540        INTC_0.PSR[540].R             /* INTC Priority Select Register */
#define INTC_0_PSR541        INTC_0.PSR[541].R             /* INTC Priority Select Register */
#define INTC_0_PSR542        INTC_0.PSR[542].R             /* INTC Priority Select Register */
#define INTC_0_PSR543        INTC_0.PSR[543].R             /* INTC Priority Select Register */
#define INTC_0_PSR544        INTC_0.PSR[544].R             /* INTC Priority Select Register */
#define INTC_0_PSR545        INTC_0.PSR[545].R             /* INTC Priority Select Register */
#define INTC_0_PSR546        INTC_0.PSR[546].R             /* INTC Priority Select Register */
#define INTC_0_PSR547        INTC_0.PSR[547].R             /* INTC Priority Select Register */
#define INTC_0_PSR548        INTC_0.PSR[548].R             /* INTC Priority Select Register */
#define INTC_0_PSR549        INTC_0.PSR[549].R             /* INTC Priority Select Register */
#define INTC_0_PSR550        INTC_0.PSR[550].R             /* INTC Priority Select Register */
#define INTC_0_PSR551        INTC_0.PSR[551].R             /* INTC Priority Select Register */
#define INTC_0_PSR552        INTC_0.PSR[552].R             /* INTC Priority Select Register */
#define INTC_0_PSR553        INTC_0.PSR[553].R             /* INTC Priority Select Register */
#define INTC_0_PSR554        INTC_0.PSR[554].R             /* INTC Priority Select Register */
#define INTC_0_PSR555        INTC_0.PSR[555].R             /* INTC Priority Select Register */
#define INTC_0_PSR556        INTC_0.PSR[556].R             /* INTC Priority Select Register */
#define INTC_0_PSR557        INTC_0.PSR[557].R             /* INTC Priority Select Register */
#define INTC_0_PSR558        INTC_0.PSR[558].R             /* INTC Priority Select Register */
#define INTC_0_PSR559        INTC_0.PSR[559].R             /* INTC Priority Select Register */
#define INTC_0_PSR560        INTC_0.PSR[560].R             /* INTC Priority Select Register */
#define INTC_0_PSR561        INTC_0.PSR[561].R             /* INTC Priority Select Register */
#define INTC_0_PSR562        INTC_0.PSR[562].R             /* INTC Priority Select Register */
#define INTC_0_PSR563        INTC_0.PSR[563].R             /* INTC Priority Select Register */
#define INTC_0_PSR564        INTC_0.PSR[564].R             /* INTC Priority Select Register */
#define INTC_0_PSR565        INTC_0.PSR[565].R             /* INTC Priority Select Register */
#define INTC_0_PSR566        INTC_0.PSR[566].R             /* INTC Priority Select Register */
#define INTC_0_PSR567        INTC_0.PSR[567].R             /* INTC Priority Select Register */
#define INTC_0_PSR568        INTC_0.PSR[568].R             /* INTC Priority Select Register */
#define INTC_0_PSR569        INTC_0.PSR[569].R             /* INTC Priority Select Register */
#define INTC_0_PSR570        INTC_0.PSR[570].R             /* INTC Priority Select Register */
#define INTC_0_PSR571        INTC_0.PSR[571].R             /* INTC Priority Select Register */
#define INTC_0_PSR572        INTC_0.PSR[572].R             /* INTC Priority Select Register */
#define INTC_0_PSR573        INTC_0.PSR[573].R             /* INTC Priority Select Register */
#define INTC_0_PSR574        INTC_0.PSR[574].R             /* INTC Priority Select Register */
#define INTC_0_PSR575        INTC_0.PSR[575].R             /* INTC Priority Select Register */
#define INTC_0_PSR576        INTC_0.PSR[576].R             /* INTC Priority Select Register */
#define INTC_0_PSR577        INTC_0.PSR[577].R             /* INTC Priority Select Register */
#define INTC_0_PSR578        INTC_0.PSR[578].R             /* INTC Priority Select Register */
#define INTC_0_PSR579        INTC_0.PSR[579].R             /* INTC Priority Select Register */
#define INTC_0_PSR580        INTC_0.PSR[580].R             /* INTC Priority Select Register */
#define INTC_0_PSR581        INTC_0.PSR[581].R             /* INTC Priority Select Register */
#define INTC_0_PSR582        INTC_0.PSR[582].R             /* INTC Priority Select Register */
#define INTC_0_PSR583        INTC_0.PSR[583].R             /* INTC Priority Select Register */
#define INTC_0_PSR584        INTC_0.PSR[584].R             /* INTC Priority Select Register */
#define INTC_0_PSR585        INTC_0.PSR[585].R             /* INTC Priority Select Register */
#define INTC_0_PSR586        INTC_0.PSR[586].R             /* INTC Priority Select Register */
#define INTC_0_PSR587        INTC_0.PSR[587].R             /* INTC Priority Select Register */
#define INTC_0_PSR588        INTC_0.PSR[588].R             /* INTC Priority Select Register */
#define INTC_0_PSR589        INTC_0.PSR[589].R             /* INTC Priority Select Register */
#define INTC_0_PSR590        INTC_0.PSR[590].R             /* INTC Priority Select Register */
#define INTC_0_PSR591        INTC_0.PSR[591].R             /* INTC Priority Select Register */
#define INTC_0_PSR592        INTC_0.PSR[592].R             /* INTC Priority Select Register */
#define INTC_0_PSR593        INTC_0.PSR[593].R             /* INTC Priority Select Register */
#define INTC_0_PSR594        INTC_0.PSR[594].R             /* INTC Priority Select Register */
#define INTC_0_PSR595        INTC_0.PSR[595].R             /* INTC Priority Select Register */
#define INTC_0_PSR596        INTC_0.PSR[596].R             /* INTC Priority Select Register */
#define INTC_0_PSR597        INTC_0.PSR[597].R             /* INTC Priority Select Register */
#define INTC_0_PSR598        INTC_0.PSR[598].R             /* INTC Priority Select Register */
#define INTC_0_PSR599        INTC_0.PSR[599].R             /* INTC Priority Select Register */
#define INTC_0_PSR600        INTC_0.PSR[600].R             /* INTC Priority Select Register */
#define INTC_0_PSR601        INTC_0.PSR[601].R             /* INTC Priority Select Register */
#define INTC_0_PSR602        INTC_0.PSR[602].R             /* INTC Priority Select Register */
#define INTC_0_PSR603        INTC_0.PSR[603].R             /* INTC Priority Select Register */
#define INTC_0_PSR604        INTC_0.PSR[604].R             /* INTC Priority Select Register */
#define INTC_0_PSR605        INTC_0.PSR[605].R             /* INTC Priority Select Register */
#define INTC_0_PSR606        INTC_0.PSR[606].R             /* INTC Priority Select Register */
#define INTC_0_PSR607        INTC_0.PSR[607].R             /* INTC Priority Select Register */
#define INTC_0_PSR608        INTC_0.PSR[608].R             /* INTC Priority Select Register */
#define INTC_0_PSR609        INTC_0.PSR[609].R             /* INTC Priority Select Register */
#define INTC_0_PSR610        INTC_0.PSR[610].R             /* INTC Priority Select Register */
#define INTC_0_PSR611        INTC_0.PSR[611].R             /* INTC Priority Select Register */
#define INTC_0_PSR612        INTC_0.PSR[612].R             /* INTC Priority Select Register */
#define INTC_0_PSR613        INTC_0.PSR[613].R             /* INTC Priority Select Register */
#define INTC_0_PSR614        INTC_0.PSR[614].R             /* INTC Priority Select Register */
#define INTC_0_PSR615        INTC_0.PSR[615].R             /* INTC Priority Select Register */
#define INTC_0_PSR616        INTC_0.PSR[616].R             /* INTC Priority Select Register */
#define INTC_0_PSR617        INTC_0.PSR[617].R             /* INTC Priority Select Register */
#define INTC_0_PSR618        INTC_0.PSR[618].R             /* INTC Priority Select Register */
#define INTC_0_PSR619        INTC_0.PSR[619].R             /* INTC Priority Select Register */
#define INTC_0_PSR620        INTC_0.PSR[620].R             /* INTC Priority Select Register */
#define INTC_0_PSR621        INTC_0.PSR[621].R             /* INTC Priority Select Register */
#define INTC_0_PSR622        INTC_0.PSR[622].R             /* INTC Priority Select Register */
#define INTC_0_PSR623        INTC_0.PSR[623].R             /* INTC Priority Select Register */
#define INTC_0_PSR624        INTC_0.PSR[624].R             /* INTC Priority Select Register */
#define INTC_0_PSR625        INTC_0.PSR[625].R             /* INTC Priority Select Register */
#define INTC_0_PSR626        INTC_0.PSR[626].R             /* INTC Priority Select Register */
#define INTC_0_PSR627        INTC_0.PSR[627].R             /* INTC Priority Select Register */
#define INTC_0_PSR628        INTC_0.PSR[628].R             /* INTC Priority Select Register */
#define INTC_0_PSR629        INTC_0.PSR[629].R             /* INTC Priority Select Register */
#define INTC_0_PSR630        INTC_0.PSR[630].R             /* INTC Priority Select Register */
#define INTC_0_PSR631        INTC_0.PSR[631].R             /* INTC Priority Select Register */
#define INTC_0_PSR632        INTC_0.PSR[632].R             /* INTC Priority Select Register */
#define INTC_0_PSR633        INTC_0.PSR[633].R             /* INTC Priority Select Register */
#define INTC_0_PSR634        INTC_0.PSR[634].R             /* INTC Priority Select Register */
#define INTC_0_PSR635        INTC_0.PSR[635].R             /* INTC Priority Select Register */
#define INTC_0_PSR636        INTC_0.PSR[636].R             /* INTC Priority Select Register */
#define INTC_0_PSR637        INTC_0.PSR[637].R             /* INTC Priority Select Register */
#define INTC_0_PSR638        INTC_0.PSR[638].R             /* INTC Priority Select Register */
#define INTC_0_PSR639        INTC_0.PSR[639].R             /* INTC Priority Select Register */
#define INTC_0_PSR640        INTC_0.PSR[640].R             /* INTC Priority Select Register */
#define INTC_0_PSR641        INTC_0.PSR[641].R             /* INTC Priority Select Register */
#define INTC_0_PSR642        INTC_0.PSR[642].R             /* INTC Priority Select Register */
#define INTC_0_PSR643        INTC_0.PSR[643].R             /* INTC Priority Select Register */
#define INTC_0_PSR644        INTC_0.PSR[644].R             /* INTC Priority Select Register */
#define INTC_0_PSR645        INTC_0.PSR[645].R             /* INTC Priority Select Register */
#define INTC_0_PSR646        INTC_0.PSR[646].R             /* INTC Priority Select Register */
#define INTC_0_PSR647        INTC_0.PSR[647].R             /* INTC Priority Select Register */
#define INTC_0_PSR648        INTC_0.PSR[648].R             /* INTC Priority Select Register */
#define INTC_0_PSR649        INTC_0.PSR[649].R             /* INTC Priority Select Register */
#define INTC_0_PSR650        INTC_0.PSR[650].R             /* INTC Priority Select Register */
#define INTC_0_PSR651        INTC_0.PSR[651].R             /* INTC Priority Select Register */
#define INTC_0_PSR652        INTC_0.PSR[652].R             /* INTC Priority Select Register */
#define INTC_0_PSR653        INTC_0.PSR[653].R             /* INTC Priority Select Register */
#define INTC_0_PSR654        INTC_0.PSR[654].R             /* INTC Priority Select Register */
#define INTC_0_PSR655        INTC_0.PSR[655].R             /* INTC Priority Select Register */
#define INTC_0_PSR656        INTC_0.PSR[656].R             /* INTC Priority Select Register */
#define INTC_0_PSR657        INTC_0.PSR[657].R             /* INTC Priority Select Register */
#define INTC_0_PSR658        INTC_0.PSR[658].R             /* INTC Priority Select Register */
#define INTC_0_PSR659        INTC_0.PSR[659].R             /* INTC Priority Select Register */
#define INTC_0_PSR660        INTC_0.PSR[660].R             /* INTC Priority Select Register */
#define INTC_0_PSR661        INTC_0.PSR[661].R             /* INTC Priority Select Register */
#define INTC_0_PSR662        INTC_0.PSR[662].R             /* INTC Priority Select Register */
#define INTC_0_PSR663        INTC_0.PSR[663].R             /* INTC Priority Select Register */
#define INTC_0_PSR664        INTC_0.PSR[664].R             /* INTC Priority Select Register */
#define INTC_0_PSR665        INTC_0.PSR[665].R             /* INTC Priority Select Register */
#define INTC_0_PSR666        INTC_0.PSR[666].R             /* INTC Priority Select Register */
#define INTC_0_PSR667        INTC_0.PSR[667].R             /* INTC Priority Select Register */
#define INTC_0_PSR668        INTC_0.PSR[668].R             /* INTC Priority Select Register */
#define INTC_0_PSR669        INTC_0.PSR[669].R             /* INTC Priority Select Register */
#define INTC_0_PSR670        INTC_0.PSR[670].R             /* INTC Priority Select Register */
#define INTC_0_PSR671        INTC_0.PSR[671].R             /* INTC Priority Select Register */
#define INTC_0_PSR672        INTC_0.PSR[672].R             /* INTC Priority Select Register */
#define INTC_0_PSR673        INTC_0.PSR[673].R             /* INTC Priority Select Register */
#define INTC_0_PSR674        INTC_0.PSR[674].R             /* INTC Priority Select Register */
#define INTC_0_PSR675        INTC_0.PSR[675].R             /* INTC Priority Select Register */
#define INTC_0_PSR676        INTC_0.PSR[676].R             /* INTC Priority Select Register */
#define INTC_0_PSR677        INTC_0.PSR[677].R             /* INTC Priority Select Register */
#define INTC_0_PSR678        INTC_0.PSR[678].R             /* INTC Priority Select Register */
#define INTC_0_PSR679        INTC_0.PSR[679].R             /* INTC Priority Select Register */
#define INTC_0_PSR680        INTC_0.PSR[680].R             /* INTC Priority Select Register */
#define INTC_0_PSR681        INTC_0.PSR[681].R             /* INTC Priority Select Register */
#define INTC_0_PSR682        INTC_0.PSR[682].R             /* INTC Priority Select Register */
#define INTC_0_PSR683        INTC_0.PSR[683].R             /* INTC Priority Select Register */
#define INTC_0_PSR684        INTC_0.PSR[684].R             /* INTC Priority Select Register */
#define INTC_0_PSR685        INTC_0.PSR[685].R             /* INTC Priority Select Register */
#define INTC_0_PSR686        INTC_0.PSR[686].R             /* INTC Priority Select Register */
#define INTC_0_PSR687        INTC_0.PSR[687].R             /* INTC Priority Select Register */
#define INTC_0_PSR688        INTC_0.PSR[688].R             /* INTC Priority Select Register */
#define INTC_0_PSR689        INTC_0.PSR[689].R             /* INTC Priority Select Register */
#define INTC_0_PSR690        INTC_0.PSR[690].R             /* INTC Priority Select Register */
#define INTC_0_PSR691        INTC_0.PSR[691].R             /* INTC Priority Select Register */
#define INTC_0_PSR692        INTC_0.PSR[692].R             /* INTC Priority Select Register */
#define INTC_0_PSR693        INTC_0.PSR[693].R             /* INTC Priority Select Register */
#define INTC_0_PSR694        INTC_0.PSR[694].R             /* INTC Priority Select Register */
#define INTC_0_PSR695        INTC_0.PSR[695].R             /* INTC Priority Select Register */
#define INTC_0_PSR696        INTC_0.PSR[696].R             /* INTC Priority Select Register */
#define INTC_0_PSR697        INTC_0.PSR[697].R             /* INTC Priority Select Register */
#define INTC_0_PSR698        INTC_0.PSR[698].R             /* INTC Priority Select Register */
#define INTC_0_PSR699        INTC_0.PSR[699].R             /* INTC Priority Select Register */
#define INTC_0_PSR700        INTC_0.PSR[700].R             /* INTC Priority Select Register */
#define INTC_0_PSR701        INTC_0.PSR[701].R             /* INTC Priority Select Register */
#define INTC_0_PSR702        INTC_0.PSR[702].R             /* INTC Priority Select Register */
#define INTC_0_PSR703        INTC_0.PSR[703].R             /* INTC Priority Select Register */
#define INTC_0_PSR704        INTC_0.PSR[704].R             /* INTC Priority Select Register */
#define INTC_0_PSR705        INTC_0.PSR[705].R             /* INTC Priority Select Register */
#define INTC_0_PSR706        INTC_0.PSR[706].R             /* INTC Priority Select Register */
#define INTC_0_PSR707        INTC_0.PSR[707].R             /* INTC Priority Select Register */
#define INTC_0_PSR708        INTC_0.PSR[708].R             /* INTC Priority Select Register */
#define INTC_0_PSR709        INTC_0.PSR[709].R             /* INTC Priority Select Register */
#define INTC_0_PSR710        INTC_0.PSR[710].R             /* INTC Priority Select Register */
#define INTC_0_PSR711        INTC_0.PSR[711].R             /* INTC Priority Select Register */
#define INTC_0_PSR712        INTC_0.PSR[712].R             /* INTC Priority Select Register */
#define INTC_0_PSR713        INTC_0.PSR[713].R             /* INTC Priority Select Register */
#define INTC_0_PSR714        INTC_0.PSR[714].R             /* INTC Priority Select Register */
#define INTC_0_PSR715        INTC_0.PSR[715].R             /* INTC Priority Select Register */
#define INTC_0_PSR716        INTC_0.PSR[716].R             /* INTC Priority Select Register */
#define INTC_0_PSR717        INTC_0.PSR[717].R             /* INTC Priority Select Register */
#define INTC_0_PSR718        INTC_0.PSR[718].R             /* INTC Priority Select Register */
#define INTC_0_PSR719        INTC_0.PSR[719].R             /* INTC Priority Select Register */
#define INTC_0_PSR720        INTC_0.PSR[720].R             /* INTC Priority Select Register */
#define INTC_0_PSR721        INTC_0.PSR[721].R             /* INTC Priority Select Register */
#define INTC_0_PSR722        INTC_0.PSR[722].R             /* INTC Priority Select Register */
#define INTC_0_PSR723        INTC_0.PSR[723].R             /* INTC Priority Select Register */
#define INTC_0_PSR724        INTC_0.PSR[724].R             /* INTC Priority Select Register */
#define INTC_0_PSR725        INTC_0.PSR[725].R             /* INTC Priority Select Register */
#define INTC_0_PSR726        INTC_0.PSR[726].R             /* INTC Priority Select Register */
#define INTC_0_PSR727        INTC_0.PSR[727].R             /* INTC Priority Select Register */
#define INTC_0_PSR728        INTC_0.PSR[728].R             /* INTC Priority Select Register */
#define INTC_0_PSR729        INTC_0.PSR[729].R             /* INTC Priority Select Register */
#define INTC_0_PSR730        INTC_0.PSR[730].R             /* INTC Priority Select Register */
#define INTC_0_PSR731        INTC_0.PSR[731].R             /* INTC Priority Select Register */
#define INTC_0_PSR732        INTC_0.PSR[732].R             /* INTC Priority Select Register */
#define INTC_0_PSR733        INTC_0.PSR[733].R             /* INTC Priority Select Register */
#define INTC_0_PSR734        INTC_0.PSR[734].R             /* INTC Priority Select Register */
#define INTC_0_PSR735        INTC_0.PSR[735].R             /* INTC Priority Select Register */
#define INTC_0_PSR736        INTC_0.PSR[736].R             /* INTC Priority Select Register */
#define INTC_0_PSR737        INTC_0.PSR[737].R             /* INTC Priority Select Register */
#define INTC_0_PSR738        INTC_0.PSR[738].R             /* INTC Priority Select Register */
#define INTC_0_PSR739        INTC_0.PSR[739].R             /* INTC Priority Select Register */
#define INTC_0_PSR740        INTC_0.PSR[740].R             /* INTC Priority Select Register */
#define INTC_0_PSR741        INTC_0.PSR[741].R             /* INTC Priority Select Register */
#define INTC_0_PSR742        INTC_0.PSR[742].R             /* INTC Priority Select Register */
#define INTC_0_PSR743        INTC_0.PSR[743].R             /* INTC Priority Select Register */
#define INTC_0_PSR744        INTC_0.PSR[744].R             /* INTC Priority Select Register */
#define INTC_0_PSR745        INTC_0.PSR[745].R             /* INTC Priority Select Register */
#define INTC_0_PSR746        INTC_0.PSR[746].R             /* INTC Priority Select Register */
#define INTC_0_PSR747        INTC_0.PSR[747].R             /* INTC Priority Select Register */
#define INTC_0_PSR748        INTC_0.PSR[748].R             /* INTC Priority Select Register */
#define INTC_0_PSR749        INTC_0.PSR[749].R             /* INTC Priority Select Register */
#define INTC_0_PSR750        INTC_0.PSR[750].R             /* INTC Priority Select Register */
#define INTC_0_PSR751        INTC_0.PSR[751].R             /* INTC Priority Select Register */
#define INTC_0_PSR752        INTC_0.PSR[752].R             /* INTC Priority Select Register */
#define INTC_0_PSR753        INTC_0.PSR[753].R             /* INTC Priority Select Register */
#define INTC_0_PSR754        INTC_0.PSR[754].R             /* INTC Priority Select Register */
#define INTC_0_PSR755        INTC_0.PSR[755].R             /* INTC Priority Select Register */
#define INTC_0_PSR756        INTC_0.PSR[756].R             /* INTC Priority Select Register */
#define INTC_0_PSR757        INTC_0.PSR[757].R             /* INTC Priority Select Register */
#define INTC_0_PSR758        INTC_0.PSR[758].R             /* INTC Priority Select Register */
#define INTC_0_PSR759        INTC_0.PSR[759].R             /* INTC Priority Select Register */
#define INTC_0_PSR760        INTC_0.PSR[760].R             /* INTC Priority Select Register */
#define INTC_0_PSR761        INTC_0.PSR[761].R             /* INTC Priority Select Register */
#define INTC_0_PSR762        INTC_0.PSR[762].R             /* INTC Priority Select Register */
#define INTC_0_PSR763        INTC_0.PSR[763].R             /* INTC Priority Select Register */
#define INTC_0_PSR764        INTC_0.PSR[764].R             /* INTC Priority Select Register */
#define INTC_0_PSR765        INTC_0.PSR[765].R             /* INTC Priority Select Register */
#define INTC_0_PSR766        INTC_0.PSR[766].R             /* INTC Priority Select Register */
#define INTC_0_PSR767        INTC_0.PSR[767].R             /* INTC Priority Select Register */
#define INTC_0_PSR768        INTC_0.PSR[768].R             /* INTC Priority Select Register */
#define INTC_0_PSR769        INTC_0.PSR[769].R             /* INTC Priority Select Register */
#define INTC_0_PSR770        INTC_0.PSR[770].R             /* INTC Priority Select Register */
#define INTC_0_PSR771        INTC_0.PSR[771].R             /* INTC Priority Select Register */
#define INTC_0_PSR772        INTC_0.PSR[772].R             /* INTC Priority Select Register */
#define INTC_0_PSR773        INTC_0.PSR[773].R             /* INTC Priority Select Register */
#define INTC_0_PSR774        INTC_0.PSR[774].R             /* INTC Priority Select Register */
#define INTC_0_PSR775        INTC_0.PSR[775].R             /* INTC Priority Select Register */
#define INTC_0_PSR776        INTC_0.PSR[776].R             /* INTC Priority Select Register */
#define INTC_0_PSR777        INTC_0.PSR[777].R             /* INTC Priority Select Register */
#define INTC_0_PSR778        INTC_0.PSR[778].R             /* INTC Priority Select Register */
#define INTC_0_PSR779        INTC_0.PSR[779].R             /* INTC Priority Select Register */
#define INTC_0_PSR780        INTC_0.PSR[780].R             /* INTC Priority Select Register */
#define INTC_0_PSR781        INTC_0.PSR[781].R             /* INTC Priority Select Register */
#define INTC_0_PSR782        INTC_0.PSR[782].R             /* INTC Priority Select Register */
#define INTC_0_PSR783        INTC_0.PSR[783].R             /* INTC Priority Select Register */
#define INTC_0_PSR784        INTC_0.PSR[784].R             /* INTC Priority Select Register */
#define INTC_0_PSR785        INTC_0.PSR[785].R             /* INTC Priority Select Register */
#define INTC_0_PSR786        INTC_0.PSR[786].R             /* INTC Priority Select Register */
#define INTC_0_PSR787        INTC_0.PSR[787].R             /* INTC Priority Select Register */
#define INTC_0_PSR788        INTC_0.PSR[788].R             /* INTC Priority Select Register */
#define INTC_0_PSR789        INTC_0.PSR[789].R             /* INTC Priority Select Register */
#define INTC_0_PSR790        INTC_0.PSR[790].R             /* INTC Priority Select Register */
#define INTC_0_PSR791        INTC_0.PSR[791].R             /* INTC Priority Select Register */
#define INTC_0_PSR792        INTC_0.PSR[792].R             /* INTC Priority Select Register */
#define INTC_0_PSR793        INTC_0.PSR[793].R             /* INTC Priority Select Register */
#define INTC_0_PSR794        INTC_0.PSR[794].R             /* INTC Priority Select Register */
#define INTC_0_PSR795        INTC_0.PSR[795].R             /* INTC Priority Select Register */
#define INTC_0_PSR796        INTC_0.PSR[796].R             /* INTC Priority Select Register */
#define INTC_0_PSR797        INTC_0.PSR[797].R             /* INTC Priority Select Register */
#define INTC_0_PSR798        INTC_0.PSR[798].R             /* INTC Priority Select Register */
#define INTC_0_PSR799        INTC_0.PSR[799].R             /* INTC Priority Select Register */
#define INTC_0_PSR800        INTC_0.PSR[800].R             /* INTC Priority Select Register */
#define INTC_0_PSR801        INTC_0.PSR[801].R             /* INTC Priority Select Register */
#define INTC_0_PSR802        INTC_0.PSR[802].R             /* INTC Priority Select Register */
#define INTC_0_PSR803        INTC_0.PSR[803].R             /* INTC Priority Select Register */
#define INTC_0_PSR804        INTC_0.PSR[804].R             /* INTC Priority Select Register */
#define INTC_0_PSR805        INTC_0.PSR[805].R             /* INTC Priority Select Register */
#define INTC_0_PSR806        INTC_0.PSR[806].R             /* INTC Priority Select Register */
#define INTC_0_PSR807        INTC_0.PSR[807].R             /* INTC Priority Select Register */
#define INTC_0_PSR808        INTC_0.PSR[808].R             /* INTC Priority Select Register */
#define INTC_0_PSR809        INTC_0.PSR[809].R             /* INTC Priority Select Register */
#define INTC_0_PSR810        INTC_0.PSR[810].R             /* INTC Priority Select Register */
#define INTC_0_PSR811        INTC_0.PSR[811].R             /* INTC Priority Select Register */
#define INTC_0_PSR812        INTC_0.PSR[812].R             /* INTC Priority Select Register */
#define INTC_0_PSR813        INTC_0.PSR[813].R             /* INTC Priority Select Register */
#define INTC_0_PSR814        INTC_0.PSR[814].R             /* INTC Priority Select Register */
#define INTC_0_PSR815        INTC_0.PSR[815].R             /* INTC Priority Select Register */
#define INTC_0_PSR816        INTC_0.PSR[816].R             /* INTC Priority Select Register */
#define INTC_0_PSR817        INTC_0.PSR[817].R             /* INTC Priority Select Register */
#define INTC_0_PSR818        INTC_0.PSR[818].R             /* INTC Priority Select Register */
#define INTC_0_PSR819        INTC_0.PSR[819].R             /* INTC Priority Select Register */
#define INTC_0_PSR820        INTC_0.PSR[820].R             /* INTC Priority Select Register */
#define INTC_0_PSR821        INTC_0.PSR[821].R             /* INTC Priority Select Register */
#define INTC_0_PSR822        INTC_0.PSR[822].R             /* INTC Priority Select Register */
#define INTC_0_PSR823        INTC_0.PSR[823].R             /* INTC Priority Select Register */
#define INTC_0_PSR824        INTC_0.PSR[824].R             /* INTC Priority Select Register */
#define INTC_0_PSR825        INTC_0.PSR[825].R             /* INTC Priority Select Register */
#define INTC_0_PSR826        INTC_0.PSR[826].R             /* INTC Priority Select Register */
#define INTC_0_PSR827        INTC_0.PSR[827].R             /* INTC Priority Select Register */
#define INTC_0_PSR828        INTC_0.PSR[828].R             /* INTC Priority Select Register */
#define INTC_0_PSR829        INTC_0.PSR[829].R             /* INTC Priority Select Register */
#define INTC_0_PSR830        INTC_0.PSR[830].R             /* INTC Priority Select Register */
#define INTC_0_PSR831        INTC_0.PSR[831].R             /* INTC Priority Select Register */
#define INTC_0_PSR832        INTC_0.PSR[832].R             /* INTC Priority Select Register */
#define INTC_0_PSR833        INTC_0.PSR[833].R             /* INTC Priority Select Register */
#define INTC_0_PSR834        INTC_0.PSR[834].R             /* INTC Priority Select Register */
#define INTC_0_PSR835        INTC_0.PSR[835].R             /* INTC Priority Select Register */
#define INTC_0_PSR836        INTC_0.PSR[836].R             /* INTC Priority Select Register */
#define INTC_0_PSR837        INTC_0.PSR[837].R             /* INTC Priority Select Register */
#define INTC_0_PSR838        INTC_0.PSR[838].R             /* INTC Priority Select Register */
#define INTC_0_PSR839        INTC_0.PSR[839].R             /* INTC Priority Select Register */
#define INTC_0_PSR840        INTC_0.PSR[840].R             /* INTC Priority Select Register */
#define INTC_0_PSR841        INTC_0.PSR[841].R             /* INTC Priority Select Register */
#define INTC_0_PSR842        INTC_0.PSR[842].R             /* INTC Priority Select Register */
#define INTC_0_PSR843        INTC_0.PSR[843].R             /* INTC Priority Select Register */
#define INTC_0_PSR844        INTC_0.PSR[844].R             /* INTC Priority Select Register */
#define INTC_0_PSR845        INTC_0.PSR[845].R             /* INTC Priority Select Register */
#define INTC_0_PSR846        INTC_0.PSR[846].R             /* INTC Priority Select Register */
#define INTC_0_PSR847        INTC_0.PSR[847].R             /* INTC Priority Select Register */
#define INTC_0_PSR848        INTC_0.PSR[848].R             /* INTC Priority Select Register */
#define INTC_0_PSR849        INTC_0.PSR[849].R             /* INTC Priority Select Register */
#define INTC_0_PSR850        INTC_0.PSR[850].R             /* INTC Priority Select Register */
#define INTC_0_PSR851        INTC_0.PSR[851].R             /* INTC Priority Select Register */
#define INTC_0_PSR852        INTC_0.PSR[852].R             /* INTC Priority Select Register */
#define INTC_0_PSR853        INTC_0.PSR[853].R             /* INTC Priority Select Register */
#define INTC_0_PSR854        INTC_0.PSR[854].R             /* INTC Priority Select Register */
#define INTC_0_PSR855        INTC_0.PSR[855].R             /* INTC Priority Select Register */
#define INTC_0_PSR856        INTC_0.PSR[856].R             /* INTC Priority Select Register */
#define INTC_0_PSR857        INTC_0.PSR[857].R             /* INTC Priority Select Register */
#define INTC_0_PSR858        INTC_0.PSR[858].R             /* INTC Priority Select Register */
#define INTC_0_PSR859        INTC_0.PSR[859].R             /* INTC Priority Select Register */
#define INTC_0_PSR860        INTC_0.PSR[860].R             /* INTC Priority Select Register */
#define INTC_0_PSR861        INTC_0.PSR[861].R             /* INTC Priority Select Register */
#define INTC_0_PSR862        INTC_0.PSR[862].R             /* INTC Priority Select Register */
#define INTC_0_PSR863        INTC_0.PSR[863].R             /* INTC Priority Select Register */
#define INTC_0_PSR864        INTC_0.PSR[864].R             /* INTC Priority Select Register */
#define INTC_0_PSR865        INTC_0.PSR[865].R             /* INTC Priority Select Register */
#define INTC_0_PSR866        INTC_0.PSR[866].R             /* INTC Priority Select Register */
#define INTC_0_PSR867        INTC_0.PSR[867].R             /* INTC Priority Select Register */
#define INTC_0_PSR868        INTC_0.PSR[868].R             /* INTC Priority Select Register */
#define INTC_0_PSR869        INTC_0.PSR[869].R             /* INTC Priority Select Register */
#define INTC_0_PSR870        INTC_0.PSR[870].R             /* INTC Priority Select Register */
#define INTC_0_PSR871        INTC_0.PSR[871].R             /* INTC Priority Select Register */
#define INTC_0_PSR872        INTC_0.PSR[872].R             /* INTC Priority Select Register */
#define INTC_0_PSR873        INTC_0.PSR[873].R             /* INTC Priority Select Register */
#define INTC_0_PSR874        INTC_0.PSR[874].R             /* INTC Priority Select Register */
#define INTC_0_PSR875        INTC_0.PSR[875].R             /* INTC Priority Select Register */
#define INTC_0_PSR876        INTC_0.PSR[876].R             /* INTC Priority Select Register */
#define INTC_0_PSR877        INTC_0.PSR[877].R             /* INTC Priority Select Register */
#define INTC_0_PSR878        INTC_0.PSR[878].R             /* INTC Priority Select Register */
#define INTC_0_PSR879        INTC_0.PSR[879].R             /* INTC Priority Select Register */
#define INTC_0_PSR880        INTC_0.PSR[880].R             /* INTC Priority Select Register */
#define INTC_0_PSR881        INTC_0.PSR[881].R             /* INTC Priority Select Register */
#define INTC_0_PSR882        INTC_0.PSR[882].R             /* INTC Priority Select Register */
#define INTC_0_PSR883        INTC_0.PSR[883].R             /* INTC Priority Select Register */
#define INTC_0_PSR884        INTC_0.PSR[884].R             /* INTC Priority Select Register */
#define INTC_0_PSR885        INTC_0.PSR[885].R             /* INTC Priority Select Register */
#define INTC_0_PSR886        INTC_0.PSR[886].R             /* INTC Priority Select Register */
#define INTC_0_PSR887        INTC_0.PSR[887].R             /* INTC Priority Select Register */
#define INTC_0_PSR888        INTC_0.PSR[888].R             /* INTC Priority Select Register */
#define INTC_0_PSR889        INTC_0.PSR[889].R             /* INTC Priority Select Register */
#define INTC_0_PSR890        INTC_0.PSR[890].R             /* INTC Priority Select Register */
#define INTC_0_PSR891        INTC_0.PSR[891].R             /* INTC Priority Select Register */
#define INTC_0_PSR892        INTC_0.PSR[892].R             /* INTC Priority Select Register */
#define INTC_0_PSR893        INTC_0.PSR[893].R             /* INTC Priority Select Register */
#define INTC_0_PSR894        INTC_0.PSR[894].R             /* INTC Priority Select Register */
#define INTC_0_PSR895        INTC_0.PSR[895].R             /* INTC Priority Select Register */
#define INTC_0_PSR896        INTC_0.PSR[896].R             /* INTC Priority Select Register */
#define INTC_0_PSR897        INTC_0.PSR[897].R             /* INTC Priority Select Register */
#define INTC_0_PSR898        INTC_0.PSR[898].R             /* INTC Priority Select Register */
#define INTC_0_PSR899        INTC_0.PSR[899].R             /* INTC Priority Select Register */
#define INTC_0_PSR900        INTC_0.PSR[900].R             /* INTC Priority Select Register */
#define INTC_0_PSR901        INTC_0.PSR[901].R             /* INTC Priority Select Register */
#define INTC_0_PSR902        INTC_0.PSR[902].R             /* INTC Priority Select Register */
#define INTC_0_PSR903        INTC_0.PSR[903].R             /* INTC Priority Select Register */
#define INTC_0_PSR904        INTC_0.PSR[904].R             /* INTC Priority Select Register */
#define INTC_0_PSR905        INTC_0.PSR[905].R             /* INTC Priority Select Register */
#define INTC_0_PSR906        INTC_0.PSR[906].R             /* INTC Priority Select Register */
#define INTC_0_PSR907        INTC_0.PSR[907].R             /* INTC Priority Select Register */
#define INTC_0_PSR908        INTC_0.PSR[908].R             /* INTC Priority Select Register */
#define INTC_0_PSR909        INTC_0.PSR[909].R             /* INTC Priority Select Register */
#define INTC_0_PSR910        INTC_0.PSR[910].R             /* INTC Priority Select Register */
#define INTC_0_PSR911        INTC_0.PSR[911].R             /* INTC Priority Select Register */
#define INTC_0_PSR912        INTC_0.PSR[912].R             /* INTC Priority Select Register */
#define INTC_0_PSR913        INTC_0.PSR[913].R             /* INTC Priority Select Register */
#define INTC_0_PSR914        INTC_0.PSR[914].R             /* INTC Priority Select Register */
#define INTC_0_PSR915        INTC_0.PSR[915].R             /* INTC Priority Select Register */
#define INTC_0_PSR916        INTC_0.PSR[916].R             /* INTC Priority Select Register */
#define INTC_0_PSR917        INTC_0.PSR[917].R             /* INTC Priority Select Register */
#define INTC_0_PSR918        INTC_0.PSR[918].R             /* INTC Priority Select Register */
#define INTC_0_PSR919        INTC_0.PSR[919].R             /* INTC Priority Select Register */
#define INTC_0_PSR920        INTC_0.PSR[920].R             /* INTC Priority Select Register */
#define INTC_0_PSR921        INTC_0.PSR[921].R             /* INTC Priority Select Register */
#define INTC_0_PSR922        INTC_0.PSR[922].R             /* INTC Priority Select Register */
#define INTC_0_PSR923        INTC_0.PSR[923].R             /* INTC Priority Select Register */
#define INTC_0_PSR924        INTC_0.PSR[924].R             /* INTC Priority Select Register */
#define INTC_0_PSR925        INTC_0.PSR[925].R             /* INTC Priority Select Register */
#define INTC_0_PSR926        INTC_0.PSR[926].R             /* INTC Priority Select Register */
#define INTC_0_PSR927        INTC_0.PSR[927].R             /* INTC Priority Select Register */
#define INTC_0_PSR928        INTC_0.PSR[928].R             /* INTC Priority Select Register */
#define INTC_0_PSR929        INTC_0.PSR[929].R             /* INTC Priority Select Register */
#define INTC_0_PSR930        INTC_0.PSR[930].R             /* INTC Priority Select Register */
#define INTC_0_PSR931        INTC_0.PSR[931].R             /* INTC Priority Select Register */
#define INTC_0_PSR932        INTC_0.PSR[932].R             /* INTC Priority Select Register */
#define INTC_0_PSR933        INTC_0.PSR[933].R             /* INTC Priority Select Register */
#define INTC_0_PSR934        INTC_0.PSR[934].R             /* INTC Priority Select Register */
#define INTC_0_PSR935        INTC_0.PSR[935].R             /* INTC Priority Select Register */
#define INTC_0_PSR936        INTC_0.PSR[936].R             /* INTC Priority Select Register */
#define INTC_0_PSR937        INTC_0.PSR[937].R             /* INTC Priority Select Register */
#define INTC_0_PSR938        INTC_0.PSR[938].R             /* INTC Priority Select Register */
#define INTC_0_PSR939        INTC_0.PSR[939].R             /* INTC Priority Select Register */
#define INTC_0_PSR940        INTC_0.PSR[940].R             /* INTC Priority Select Register */
#define INTC_0_PSR941        INTC_0.PSR[941].R             /* INTC Priority Select Register */
#define INTC_0_PSR942        INTC_0.PSR[942].R             /* INTC Priority Select Register */
#define INTC_0_PSR943        INTC_0.PSR[943].R             /* INTC Priority Select Register */
#define INTC_0_PSR944        INTC_0.PSR[944].R             /* INTC Priority Select Register */
#define INTC_0_PSR945        INTC_0.PSR[945].R             /* INTC Priority Select Register */
#define INTC_0_PSR946        INTC_0.PSR[946].R             /* INTC Priority Select Register */
#define INTC_0_PSR947        INTC_0.PSR[947].R             /* INTC Priority Select Register */
#define INTC_0_PSR948        INTC_0.PSR[948].R             /* INTC Priority Select Register */
#define INTC_0_PSR949        INTC_0.PSR[949].R             /* INTC Priority Select Register */
#define INTC_0_PSR950        INTC_0.PSR[950].R             /* INTC Priority Select Register */
#define INTC_0_PSR951        INTC_0.PSR[951].R             /* INTC Priority Select Register */
#define INTC_0_PSR952        INTC_0.PSR[952].R             /* INTC Priority Select Register */
#define INTC_0_PSR953        INTC_0.PSR[953].R             /* INTC Priority Select Register */
#define INTC_0_PSR954        INTC_0.PSR[954].R             /* INTC Priority Select Register */
#define INTC_0_PSR955        INTC_0.PSR[955].R             /* INTC Priority Select Register */
#define INTC_0_PSR956        INTC_0.PSR[956].R             /* INTC Priority Select Register */
#define INTC_0_PSR957        INTC_0.PSR[957].R             /* INTC Priority Select Register */
#define INTC_0_PSR958        INTC_0.PSR[958].R             /* INTC Priority Select Register */
#define INTC_0_PSR959        INTC_0.PSR[959].R             /* INTC Priority Select Register */
#define INTC_0_PSR960        INTC_0.PSR[960].R             /* INTC Priority Select Register */
#define INTC_0_PSR961        INTC_0.PSR[961].R             /* INTC Priority Select Register */
#define INTC_0_PSR962        INTC_0.PSR[962].R             /* INTC Priority Select Register */
#define INTC_0_PSR963        INTC_0.PSR[963].R             /* INTC Priority Select Register */
#define INTC_0_PSR964        INTC_0.PSR[964].R             /* INTC Priority Select Register */
#define INTC_0_PSR965        INTC_0.PSR[965].R             /* INTC Priority Select Register */
#define INTC_0_PSR966        INTC_0.PSR[966].R             /* INTC Priority Select Register */
#define INTC_0_PSR967        INTC_0.PSR[967].R             /* INTC Priority Select Register */
#define INTC_0_PSR968        INTC_0.PSR[968].R             /* INTC Priority Select Register */
#define INTC_0_PSR969        INTC_0.PSR[969].R             /* INTC Priority Select Register */
#define INTC_0_PSR970        INTC_0.PSR[970].R             /* INTC Priority Select Register */
#define INTC_0_PSR971        INTC_0.PSR[971].R             /* INTC Priority Select Register */
#define INTC_0_PSR972        INTC_0.PSR[972].R             /* INTC Priority Select Register */
#define INTC_0_PSR973        INTC_0.PSR[973].R             /* INTC Priority Select Register */
#define INTC_0_PSR974        INTC_0.PSR[974].R             /* INTC Priority Select Register */
#define INTC_0_PSR975        INTC_0.PSR[975].R             /* INTC Priority Select Register */
#define INTC_0_PSR976        INTC_0.PSR[976].R             /* INTC Priority Select Register */
#define INTC_0_PSR977        INTC_0.PSR[977].R             /* INTC Priority Select Register */
#define INTC_0_PSR978        INTC_0.PSR[978].R             /* INTC Priority Select Register */
#define INTC_0_PSR979        INTC_0.PSR[979].R             /* INTC Priority Select Register */
#define INTC_0_PSR980        INTC_0.PSR[980].R             /* INTC Priority Select Register */
#define INTC_0_PSR981        INTC_0.PSR[981].R             /* INTC Priority Select Register */
#define INTC_0_PSR982        INTC_0.PSR[982].R             /* INTC Priority Select Register */
#define INTC_0_PSR983        INTC_0.PSR[983].R             /* INTC Priority Select Register */
#define INTC_0_PSR984        INTC_0.PSR[984].R             /* INTC Priority Select Register */
#define INTC_0_PSR985        INTC_0.PSR[985].R             /* INTC Priority Select Register */
#define INTC_0_PSR986        INTC_0.PSR[986].R             /* INTC Priority Select Register */
#define INTC_0_PSR987        INTC_0.PSR[987].R             /* INTC Priority Select Register */
#define INTC_0_PSR988        INTC_0.PSR[988].R             /* INTC Priority Select Register */
#define INTC_0_PSR989        INTC_0.PSR[989].R             /* INTC Priority Select Register */
#define INTC_0_PSR990        INTC_0.PSR[990].R             /* INTC Priority Select Register */
#define INTC_0_PSR991        INTC_0.PSR[991].R             /* INTC Priority Select Register */
#define INTC_0_PSR992        INTC_0.PSR[992].R             /* INTC Priority Select Register */
#define INTC_0_PSR993        INTC_0.PSR[993].R             /* INTC Priority Select Register */
#define INTC_0_PSR994        INTC_0.PSR[994].R             /* INTC Priority Select Register */
#define INTC_0_PSR995        INTC_0.PSR[995].R             /* INTC Priority Select Register */
#define INTC_0_PSR996        INTC_0.PSR[996].R             /* INTC Priority Select Register */
#define INTC_0_PSR997        INTC_0.PSR[997].R             /* INTC Priority Select Register */
#define INTC_0_PSR998        INTC_0.PSR[998].R             /* INTC Priority Select Register */
#define INTC_0_PSR999        INTC_0.PSR[999].R             /* INTC Priority Select Register */
#define INTC_0_PSR1000       INTC_0.PSR[1000].R            /* INTC Priority Select Register */
#define INTC_0_PSR1001       INTC_0.PSR[1001].R            /* INTC Priority Select Register */
#define INTC_0_PSR1002       INTC_0.PSR[1002].R            /* INTC Priority Select Register */
#define INTC_0_PSR1003       INTC_0.PSR[1003].R            /* INTC Priority Select Register */
#define INTC_0_PSR1004       INTC_0.PSR[1004].R            /* INTC Priority Select Register */
#define INTC_0_PSR1005       INTC_0.PSR[1005].R            /* INTC Priority Select Register */
#define INTC_0_PSR1006       INTC_0.PSR[1006].R            /* INTC Priority Select Register */
#define INTC_0_PSR1007       INTC_0.PSR[1007].R            /* INTC Priority Select Register */
#define INTC_0_PSR1008       INTC_0.PSR[1008].R            /* INTC Priority Select Register */
#define INTC_0_PSR1009       INTC_0.PSR[1009].R            /* INTC Priority Select Register */
#define INTC_0_PSR1010       INTC_0.PSR[1010].R            /* INTC Priority Select Register */
#define INTC_0_PSR1011       INTC_0.PSR[1011].R            /* INTC Priority Select Register */
#define INTC_0_PSR1012       INTC_0.PSR[1012].R            /* INTC Priority Select Register */
#define INTC_0_PSR1013       INTC_0.PSR[1013].R            /* INTC Priority Select Register */
#define INTC_0_PSR1014       INTC_0.PSR[1014].R            /* INTC Priority Select Register */
#define INTC_0_PSR1015       INTC_0.PSR[1015].R            /* INTC Priority Select Register */
#define INTC_0_PSR1016       INTC_0.PSR[1016].R            /* INTC Priority Select Register */
#define INTC_0_PSR1017       INTC_0.PSR[1017].R            /* INTC Priority Select Register */
#define INTC_0_PSR1018       INTC_0.PSR[1018].R            /* INTC Priority Select Register */
#define INTC_0_PSR1019       INTC_0.PSR[1019].R            /* INTC Priority Select Register */
#define INTC_0_PSR1020       INTC_0.PSR[1020].R            /* INTC Priority Select Register */
#define INTC_0_PSR1021       INTC_0.PSR[1021].R            /* INTC Priority Select Register */
#define INTC_0_PSR1022       INTC_0.PSR[1022].R            /* INTC Priority Select Register */
#define INTC_0_PSR1023       INTC_0.PSR[1023].R            /* INTC Priority Select Register */
#define INTC_0_MMRC0         INTC_0.CHANNEL[0].MMRC.R      /* INTC Monitor Mode Register */
#define INTC_0_HIPRI0C0      INTC_0.CHANNEL[0].HIPRIC[0].R /* INTC HIPRI Register */
#define INTC_0_HIPRI1C0      INTC_0.CHANNEL[0].HIPRIC[1].R /* INTC HIPRI Register */
#define INTC_0_HIPRI2C0      INTC_0.CHANNEL[0].HIPRIC[2].R /* INTC HIPRI Register */
#define INTC_0_HIPRI3C0      INTC_0.CHANNEL[0].HIPRIC[3].R /* INTC HIPRI Register */
#define INTC_0_LAT0C0        INTC_0.CHANNEL[0].LATC[0].R   /* INTC LAT Register */
#define INTC_0_LAT1C0        INTC_0.CHANNEL[0].LATC[1].R   /* INTC LAT Register */
#define INTC_0_LAT2C0        INTC_0.CHANNEL[0].LATC[2].R   /* INTC LAT Register */
#define INTC_0_LAT3C0        INTC_0.CHANNEL[0].LATC[3].R   /* INTC LAT Register */
#define INTC_0_TIMER0C0      INTC_0.CHANNEL[0].TIMERC[0].R /* INTC Timer Register */
#define INTC_0_TIMER1C0      INTC_0.CHANNEL[0].TIMERC[1].R /* INTC Timer Register */
#define INTC_0_TIMER2C0      INTC_0.CHANNEL[0].TIMERC[2].R /* INTC Timer Register */
#define INTC_0_TIMER3C0      INTC_0.CHANNEL[0].TIMERC[3].R /* INTC Timer Register */
#define INTC_0_MMRC1         INTC_0.CHANNEL[1].MMRC.R      /* INTC Monitor Mode Register */
#define INTC_0_HIPRI0C1      INTC_0.CHANNEL[1].HIPRIC[0].R /* INTC HIPRI Register */
#define INTC_0_HIPRI1C1      INTC_0.CHANNEL[1].HIPRIC[1].R /* INTC HIPRI Register */
#define INTC_0_HIPRI2C1      INTC_0.CHANNEL[1].HIPRIC[2].R /* INTC HIPRI Register */
#define INTC_0_HIPRI3C1      INTC_0.CHANNEL[1].HIPRIC[3].R /* INTC HIPRI Register */
#define INTC_0_LAT0C1        INTC_0.CHANNEL[1].LATC[0].R   /* INTC LAT Register */
#define INTC_0_LAT1C1        INTC_0.CHANNEL[1].LATC[1].R   /* INTC LAT Register */
#define INTC_0_LAT2C1        INTC_0.CHANNEL[1].LATC[2].R   /* INTC LAT Register */
#define INTC_0_LAT3C1        INTC_0.CHANNEL[1].LATC[3].R   /* INTC LAT Register */
#define INTC_0_TIMER0C1      INTC_0.CHANNEL[1].TIMERC[0].R /* INTC Timer Register */
#define INTC_0_TIMER1C1      INTC_0.CHANNEL[1].TIMERC[1].R /* INTC Timer Register */
#define INTC_0_TIMER2C1      INTC_0.CHANNEL[1].TIMERC[2].R /* INTC Timer Register */
#define INTC_0_TIMER3C1      INTC_0.CHANNEL[1].TIMERC[3].R /* INTC Timer Register */

/* IRCOSC */
#define IRCOSC_CTL           IRCOSC.CTL.R                  /* IRCOSC Control Register */

/* JDC */
#define JDC_MCR              JDC.MCR.R                     /* Module Configuration Register */
#define JDC_MSR              JDC.MSR.R                     /* Module Status Register */
#define JDC_JOUT_IPS         JDC.JOUT_IPS.R                /* JTAG Output Data Register */
#define JDC_JIN_IPS          JDC.JIN_IPS.R                 /* JTAG Input Data Register */

/* JTAGM */
#define JTAGM_MCR            JTAGM.MCR.R                   /* Module Configuration Register */
#define JTAGM_SR             JTAGM.SR.R                    /* Status Register */
#define JTAGM_DOR0           JTAGM.DOR0.R                  /* Data Out Register 0 */
#define JTAGM_DOR1           JTAGM.DOR1.R                  /* Data Out Register 1 */
#define JTAGM_DOR2           JTAGM.DOR2.R                  /* Data Out Register 2 */
#define JTAGM_DOR3           JTAGM.DOR3.R                  /* Data Out Register 3 */
#define JTAGM_DIR0           JTAGM.DIR0.R                  /* Data Input Register 0 */
#define JTAGM_DIR1           JTAGM.DIR1.R                  /* Data Input Register 1 */

/* LFAST */
#define LFAST_MCR            LFAST.MCR.R                   /* LFAST Mode Configuration Register */
#define LFAST_SCR            LFAST.SCR.R                   /* LFAST Speed Control Register */
#define LFAST_COCR           LFAST.COCR.R                  /* LFAST Correlator Control Register */
#define LFAST_TMCR           LFAST.TMCR.R                  /* LFAST Test Mode Control Register */
#define LFAST_ALCR           LFAST.ALCR.R                  /* LFAST Auto Loopback Control Register */
#define LFAST_RCDCR          LFAST.RCDCR.R                 /* LFAST Rate Change Delay Control Register */
#define LFAST_SLCR           LFAST.SLCR.R                  /* LFAST Wakeup Delay Control Register */
#define LFAST_ICR            LFAST.ICR.R                   /* LFAST ICLC Control Register */
#define LFAST_PICR           LFAST.PICR.R                  /* LFAST Ping Control Register */
#define LFAST_RFCR           LFAST.RFCR.R                  /* LFAST Rx FIFO CTS Control Register */
#define LFAST_TIER           LFAST.TIER.R                  /* LFAST Tx Interrupt Enable Register */
#define LFAST_RIER           LFAST.RIER.R                  /* LFAST Rx Interrupt Enable Register */
#define LFAST_RIIER          LFAST.RIIER.R                 /* LFAST Rx ICLC Interrupt Enable Register */
#define LFAST_PLLCR          LFAST.PLLCR.R                 /* LFAST PLL Control Register */
#define LFAST_LCR            LFAST.LCR.R                   /* LFAST LVDS Control Register */
#define LFAST_UNSTCR         LFAST.UNSTCR.R                /* LFAST Unsolicited Tx Control Register */
#define LFAST_UNSTDR0        LFAST.UNSTDR[0].R             /* LFAST Unsolicited Tx Data Registers */
#define LFAST_UNSTDR1        LFAST.UNSTDR[1].R             /* LFAST Unsolicited Tx Data Registers */
#define LFAST_UNSTDR2        LFAST.UNSTDR[2].R             /* LFAST Unsolicited Tx Data Registers */
#define LFAST_UNSTDR3        LFAST.UNSTDR[3].R             /* LFAST Unsolicited Tx Data Registers */
#define LFAST_UNSTDR4        LFAST.UNSTDR[4].R             /* LFAST Unsolicited Tx Data Registers */
#define LFAST_UNSTDR5        LFAST.UNSTDR[5].R             /* LFAST Unsolicited Tx Data Registers */
#define LFAST_UNSTDR6        LFAST.UNSTDR[6].R             /* LFAST Unsolicited Tx Data Registers */
#define LFAST_UNSTDR7        LFAST.UNSTDR[7].R             /* LFAST Unsolicited Tx Data Registers */
#define LFAST_UNSTDR8        LFAST.UNSTDR[8].R             /* LFAST Unsolicited Tx Data Registers */
#define LFAST_GSR            LFAST.GSR.R                   /* LFAST Global Status Register */
#define LFAST_PISR           LFAST.PISR.R                  /* LFAST Ping Status Register */
#define LFAST_DFSR           LFAST.DFSR.R                  /* LFAST Data Frame Status Register */
#define LFAST_TISR           LFAST.TISR.R                  /* LFAST Tx Interrupt Status Register */
#define LFAST_RISR           LFAST.RISR.R                  /* LFAST Rx Interrupt Status Register */
#define LFAST_RIISR          LFAST.RIISR.R                 /* LFAST Rx ICLC Interrupt Status Register */
#define LFAST_PLLLSR         LFAST.PLLLSR.R                /* LFAST PLL and LVDS Status Register */
#define LFAST_UNSRSR         LFAST.UNSRSR.R                /* LFAST Unsolicited Rx Status Register */
#define LFAST_UNSRDR0        LFAST.UNSRDR[0].R             /* LFAST Unsolicited Rx Data Register */
#define LFAST_UNSRDR1        LFAST.UNSRDR[1].R             /* LFAST Unsolicited Rx Data Register */
#define LFAST_UNSRDR2        LFAST.UNSRDR[2].R             /* LFAST Unsolicited Rx Data Register */
#define LFAST_UNSRDR3        LFAST.UNSRDR[3].R             /* LFAST Unsolicited Rx Data Register */
#define LFAST_UNSRDR4        LFAST.UNSRDR[4].R             /* LFAST Unsolicited Rx Data Register */
#define LFAST_UNSRDR5        LFAST.UNSRDR[5].R             /* LFAST Unsolicited Rx Data Register */
#define LFAST_UNSRDR6        LFAST.UNSRDR[6].R             /* LFAST Unsolicited Rx Data Register */
#define LFAST_UNSRDR7        LFAST.UNSRDR[7].R             /* LFAST Unsolicited Rx Data Register */
#define LFAST_UNSRDR8        LFAST.UNSRDR[8].R             /* LFAST Unsolicited Rx Data Register */

/* LINFlexD */
#define LINFlexD_0_LINCR1    LINFlexD_0.LINCR1.R           /* LIN Control Register 1 */
#define LINFlexD_0_LINIER    LINFlexD_0.LINIER.R           /* LIN Interrupt enable register */
#define LINFlexD_0_LINSR     LINFlexD_0.LINSR.R            /* LIN Status Register */
#define LINFlexD_0_LINESR    LINFlexD_0.LINESR.R           /* LIN Error Status Register */
#define LINFlexD_0_UARTCR    LINFlexD_0.UARTCR.R           /* UART Mode Control Register */
#define LINFlexD_0_UARTSR    LINFlexD_0.UARTSR.R           /* UART Mode Status Register */
#define LINFlexD_0_LINTCSR   LINFlexD_0.LINTCSR.R          /* LIN Time-Out Control Status Register */
#define LINFlexD_0_LINOCR    LINFlexD_0.LINOCR.R           /* LIN Output Compare Register */
#define LINFlexD_0_LINTOCR   LINFlexD_0.LINTOCR.R          /* LIN Time-Out Control Register */
#define LINFlexD_0_LINFBRR   LINFlexD_0.LINFBRR.R          /* LIN Fractional Baud Rate Register */
#define LINFlexD_0_LINIBRR   LINFlexD_0.LINIBRR.R          /* LIN Integer Baud Rate Register */
#define LINFlexD_0_LINCFR    LINFlexD_0.LINCFR.R           /* LIN Checksum Field Register */
#define LINFlexD_0_LINCR2    LINFlexD_0.LINCR2.R           /* LIN Control Register 2 */
#define LINFlexD_0_BIDR      LINFlexD_0.BIDR.R             /* Buffer Identifier Register */
#define LINFlexD_0_BDRL      LINFlexD_0.BDRL.R             /* Buffer Data Register Least Significant */
#define LINFlexD_0_BDRM      LINFlexD_0.BDRM.R             /* Buffer Data Register Most Significant */
#define LINFlexD_0_IFER      LINFlexD_0.IFER.R             /* Identifier Filter Enable Register */
#define LINFlexD_0_IFMI      LINFlexD_0.IFMI.R             /* Identifier Filter Match Index */
#define LINFlexD_0_IFMR      LINFlexD_0.IFMR.R             /* Identifier Filter Mode Register */
#define LINFlexD_0_IFCR0     LINFlexD_0.IFCR[0].R          /* Identifier Filter Control Register */
#define LINFlexD_0_IFCR1     LINFlexD_0.IFCR[1].R          /* Identifier Filter Control Register */
#define LINFlexD_0_IFCR2     LINFlexD_0.IFCR[2].R          /* Identifier Filter Control Register */
#define LINFlexD_0_IFCR3     LINFlexD_0.IFCR[3].R          /* Identifier Filter Control Register */
#define LINFlexD_0_IFCR4     LINFlexD_0.IFCR[4].R          /* Identifier Filter Control Register */
#define LINFlexD_0_IFCR5     LINFlexD_0.IFCR[5].R          /* Identifier Filter Control Register */
#define LINFlexD_0_IFCR6     LINFlexD_0.IFCR[6].R          /* Identifier Filter Control Register */
#define LINFlexD_0_IFCR7     LINFlexD_0.IFCR[7].R          /* Identifier Filter Control Register */
#define LINFlexD_0_IFCR8     LINFlexD_0.IFCR[8].R          /* Identifier Filter Control Register */
#define LINFlexD_0_IFCR9     LINFlexD_0.IFCR[9].R          /* Identifier Filter Control Register */
#define LINFlexD_0_IFCR10    LINFlexD_0.IFCR[10].R         /* Identifier Filter Control Register */
#define LINFlexD_0_IFCR11    LINFlexD_0.IFCR[11].R         /* Identifier Filter Control Register */
#define LINFlexD_0_IFCR12    LINFlexD_0.IFCR[12].R         /* Identifier Filter Control Register */
#define LINFlexD_0_IFCR13    LINFlexD_0.IFCR[13].R         /* Identifier Filter Control Register */
#define LINFlexD_0_IFCR14    LINFlexD_0.IFCR[14].R         /* Identifier Filter Control Register */
#define LINFlexD_0_IFCR15    LINFlexD_0.IFCR[15].R         /* Identifier Filter Control Register */
#define LINFlexD_0_GCR       LINFlexD_0.GCR.R              /* Global Control Register */
#define LINFlexD_0_UARTPTO   LINFlexD_0.UARTPTO.R          /* UART Preset Timeout Register */
#define LINFlexD_0_UARTCTO   LINFlexD_0.UARTCTO.R          /* UART Current Timeout Register */
#define LINFlexD_0_DMATXE    LINFlexD_0.DMATXE.R           /* DMA Tx Enable Register */
#define LINFlexD_0_DMARXE    LINFlexD_0.DMARXE.R           /* DMA Rx Enable Register */

/* LINFlexD */
#define LINFlexD_1_LINCR1    LINFlexD_1.LINCR1.R           /* LIN Control Register 1 */
#define LINFlexD_1_LINIER    LINFlexD_1.LINIER.R           /* LIN Interrupt enable register */
#define LINFlexD_1_LINSR     LINFlexD_1.LINSR.R            /* LIN Status Register */
#define LINFlexD_1_LINESR    LINFlexD_1.LINESR.R           /* LIN Error Status Register */
#define LINFlexD_1_UARTCR    LINFlexD_1.UARTCR.R           /* UART Mode Control Register */
#define LINFlexD_1_UARTSR    LINFlexD_1.UARTSR.R           /* UART Mode Status Register */
#define LINFlexD_1_LINTCSR   LINFlexD_1.LINTCSR.R          /* LIN Time-Out Control Status Register */
#define LINFlexD_1_LINOCR    LINFlexD_1.LINOCR.R           /* LIN Output Compare Register */
#define LINFlexD_1_LINTOCR   LINFlexD_1.LINTOCR.R          /* LIN Time-Out Control Register */
#define LINFlexD_1_LINFBRR   LINFlexD_1.LINFBRR.R          /* LIN Fractional Baud Rate Register */
#define LINFlexD_1_LINIBRR   LINFlexD_1.LINIBRR.R          /* LIN Integer Baud Rate Register */
#define LINFlexD_1_LINCFR    LINFlexD_1.LINCFR.R           /* LIN Checksum Field Register */
#define LINFlexD_1_LINCR2    LINFlexD_1.LINCR2.R           /* LIN Control Register 2 */
#define LINFlexD_1_BIDR      LINFlexD_1.BIDR.R             /* Buffer Identifier Register */
#define LINFlexD_1_BDRL      LINFlexD_1.BDRL.R             /* Buffer Data Register Least Significant */
#define LINFlexD_1_BDRM      LINFlexD_1.BDRM.R             /* Buffer Data Register Most Significant */
#define LINFlexD_1_IFER      LINFlexD_1.IFER.R             /* Identifier Filter Enable Register */
#define LINFlexD_1_IFMI      LINFlexD_1.IFMI.R             /* Identifier Filter Match Index */
#define LINFlexD_1_IFMR      LINFlexD_1.IFMR.R             /* Identifier Filter Mode Register */
#define LINFlexD_1_IFCR0     LINFlexD_1.IFCR[0].R          /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR1     LINFlexD_1.IFCR[1].R          /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR2     LINFlexD_1.IFCR[2].R          /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR3     LINFlexD_1.IFCR[3].R          /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR4     LINFlexD_1.IFCR[4].R          /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR5     LINFlexD_1.IFCR[5].R          /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR6     LINFlexD_1.IFCR[6].R          /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR7     LINFlexD_1.IFCR[7].R          /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR8     LINFlexD_1.IFCR[8].R          /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR9     LINFlexD_1.IFCR[9].R          /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR10    LINFlexD_1.IFCR[10].R         /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR11    LINFlexD_1.IFCR[11].R         /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR12    LINFlexD_1.IFCR[12].R         /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR13    LINFlexD_1.IFCR[13].R         /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR14    LINFlexD_1.IFCR[14].R         /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR15    LINFlexD_1.IFCR[15].R         /* Identifier Filter Control Register */
#define LINFlexD_1_GCR       LINFlexD_1.GCR.R              /* Global Control Register */
#define LINFlexD_1_UARTPTO   LINFlexD_1.UARTPTO.R          /* UART Preset Timeout Register */
#define LINFlexD_1_UARTCTO   LINFlexD_1.UARTCTO.R          /* UART Current Timeout Register */
#define LINFlexD_1_DMATXE    LINFlexD_1.DMATXE.R           /* DMA Tx Enable Register */
#define LINFlexD_1_DMARXE    LINFlexD_1.DMARXE.R           /* DMA Rx Enable Register */

/* LINFlexD */
#define LINFlexD_2_LINCR1    LINFlexD_2.LINCR1.R           /* LIN Control Register 1 */
#define LINFlexD_2_LINIER    LINFlexD_2.LINIER.R           /* LIN Interrupt enable register */
#define LINFlexD_2_LINSR     LINFlexD_2.LINSR.R            /* LIN Status Register */
#define LINFlexD_2_LINESR    LINFlexD_2.LINESR.R           /* LIN Error Status Register */
#define LINFlexD_2_UARTCR    LINFlexD_2.UARTCR.R           /* UART Mode Control Register */
#define LINFlexD_2_UARTSR    LINFlexD_2.UARTSR.R           /* UART Mode Status Register */
#define LINFlexD_2_LINTCSR   LINFlexD_2.LINTCSR.R          /* LIN Time-Out Control Status Register */
#define LINFlexD_2_LINOCR    LINFlexD_2.LINOCR.R           /* LIN Output Compare Register */
#define LINFlexD_2_LINTOCR   LINFlexD_2.LINTOCR.R          /* LIN Time-Out Control Register */
#define LINFlexD_2_LINFBRR   LINFlexD_2.LINFBRR.R          /* LIN Fractional Baud Rate Register */
#define LINFlexD_2_LINIBRR   LINFlexD_2.LINIBRR.R          /* LIN Integer Baud Rate Register */
#define LINFlexD_2_LINCFR    LINFlexD_2.LINCFR.R           /* LIN Checksum Field Register */
#define LINFlexD_2_LINCR2    LINFlexD_2.LINCR2.R           /* LIN Control Register 2 */
#define LINFlexD_2_BIDR      LINFlexD_2.BIDR.R             /* Buffer Identifier Register */
#define LINFlexD_2_BDRL      LINFlexD_2.BDRL.R             /* Buffer Data Register Least Significant */
#define LINFlexD_2_BDRM      LINFlexD_2.BDRM.R             /* Buffer Data Register Most Significant */
#define LINFlexD_2_IFER      LINFlexD_2.IFER.R             /* Identifier Filter Enable Register */
#define LINFlexD_2_IFMI      LINFlexD_2.IFMI.R             /* Identifier Filter Match Index */
#define LINFlexD_2_IFMR      LINFlexD_2.IFMR.R             /* Identifier Filter Mode Register */
#define LINFlexD_2_IFCR0     LINFlexD_2.IFCR[0].R          /* Identifier Filter Control Register */
#define LINFlexD_2_IFCR1     LINFlexD_2.IFCR[1].R          /* Identifier Filter Control Register */
#define LINFlexD_2_IFCR2     LINFlexD_2.IFCR[2].R          /* Identifier Filter Control Register */
#define LINFlexD_2_IFCR3     LINFlexD_2.IFCR[3].R          /* Identifier Filter Control Register */
#define LINFlexD_2_IFCR4     LINFlexD_2.IFCR[4].R          /* Identifier Filter Control Register */
#define LINFlexD_2_IFCR5     LINFlexD_2.IFCR[5].R          /* Identifier Filter Control Register */
#define LINFlexD_2_IFCR6     LINFlexD_2.IFCR[6].R          /* Identifier Filter Control Register */
#define LINFlexD_2_IFCR7     LINFlexD_2.IFCR[7].R          /* Identifier Filter Control Register */
#define LINFlexD_2_IFCR8     LINFlexD_2.IFCR[8].R          /* Identifier Filter Control Register */
#define LINFlexD_2_IFCR9     LINFlexD_2.IFCR[9].R          /* Identifier Filter Control Register */
#define LINFlexD_2_IFCR10    LINFlexD_2.IFCR[10].R         /* Identifier Filter Control Register */
#define LINFlexD_2_IFCR11    LINFlexD_2.IFCR[11].R         /* Identifier Filter Control Register */
#define LINFlexD_2_IFCR12    LINFlexD_2.IFCR[12].R         /* Identifier Filter Control Register */
#define LINFlexD_2_IFCR13    LINFlexD_2.IFCR[13].R         /* Identifier Filter Control Register */
#define LINFlexD_2_IFCR14    LINFlexD_2.IFCR[14].R         /* Identifier Filter Control Register */
#define LINFlexD_2_IFCR15    LINFlexD_2.IFCR[15].R         /* Identifier Filter Control Register */
#define LINFlexD_2_GCR       LINFlexD_2.GCR.R              /* Global Control Register */
#define LINFlexD_2_UARTPTO   LINFlexD_2.UARTPTO.R          /* UART Preset Timeout Register */
#define LINFlexD_2_UARTCTO   LINFlexD_2.UARTCTO.R          /* UART Current Timeout Register */
#define LINFlexD_2_DMATXE    LINFlexD_2.DMATXE.R           /* DMA Tx Enable Register */
#define LINFlexD_2_DMARXE    LINFlexD_2.DMARXE.R           /* DMA Rx Enable Register */

/* LINFlexD */
#define LINFlexD_3_LINCR1    LINFlexD_3.LINCR1.R           /* LIN Control Register 1 */
#define LINFlexD_3_LINIER    LINFlexD_3.LINIER.R           /* LIN Interrupt enable register */
#define LINFlexD_3_LINSR     LINFlexD_3.LINSR.R            /* LIN Status Register */
#define LINFlexD_3_LINESR    LINFlexD_3.LINESR.R           /* LIN Error Status Register */
#define LINFlexD_3_UARTCR    LINFlexD_3.UARTCR.R           /* UART Mode Control Register */
#define LINFlexD_3_UARTSR    LINFlexD_3.UARTSR.R           /* UART Mode Status Register */
#define LINFlexD_3_LINTCSR   LINFlexD_3.LINTCSR.R          /* LIN Time-Out Control Status Register */
#define LINFlexD_3_LINOCR    LINFlexD_3.LINOCR.R           /* LIN Output Compare Register */
#define LINFlexD_3_LINTOCR   LINFlexD_3.LINTOCR.R          /* LIN Time-Out Control Register */
#define LINFlexD_3_LINFBRR   LINFlexD_3.LINFBRR.R          /* LIN Fractional Baud Rate Register */
#define LINFlexD_3_LINIBRR   LINFlexD_3.LINIBRR.R          /* LIN Integer Baud Rate Register */
#define LINFlexD_3_LINCFR    LINFlexD_3.LINCFR.R           /* LIN Checksum Field Register */
#define LINFlexD_3_LINCR2    LINFlexD_3.LINCR2.R           /* LIN Control Register 2 */
#define LINFlexD_3_BIDR      LINFlexD_3.BIDR.R             /* Buffer Identifier Register */
#define LINFlexD_3_BDRL      LINFlexD_3.BDRL.R             /* Buffer Data Register Least Significant */
#define LINFlexD_3_BDRM      LINFlexD_3.BDRM.R             /* Buffer Data Register Most Significant */
#define LINFlexD_3_IFER      LINFlexD_3.IFER.R             /* Identifier Filter Enable Register */
#define LINFlexD_3_IFMI      LINFlexD_3.IFMI.R             /* Identifier Filter Match Index */
#define LINFlexD_3_IFMR      LINFlexD_3.IFMR.R             /* Identifier Filter Mode Register */
#define LINFlexD_3_IFCR0     LINFlexD_3.IFCR[0].R          /* Identifier Filter Control Register */
#define LINFlexD_3_IFCR1     LINFlexD_3.IFCR[1].R          /* Identifier Filter Control Register */
#define LINFlexD_3_IFCR2     LINFlexD_3.IFCR[2].R          /* Identifier Filter Control Register */
#define LINFlexD_3_IFCR3     LINFlexD_3.IFCR[3].R          /* Identifier Filter Control Register */
#define LINFlexD_3_IFCR4     LINFlexD_3.IFCR[4].R          /* Identifier Filter Control Register */
#define LINFlexD_3_IFCR5     LINFlexD_3.IFCR[5].R          /* Identifier Filter Control Register */
#define LINFlexD_3_IFCR6     LINFlexD_3.IFCR[6].R          /* Identifier Filter Control Register */
#define LINFlexD_3_IFCR7     LINFlexD_3.IFCR[7].R          /* Identifier Filter Control Register */
#define LINFlexD_3_IFCR8     LINFlexD_3.IFCR[8].R          /* Identifier Filter Control Register */
#define LINFlexD_3_IFCR9     LINFlexD_3.IFCR[9].R          /* Identifier Filter Control Register */
#define LINFlexD_3_IFCR10    LINFlexD_3.IFCR[10].R         /* Identifier Filter Control Register */
#define LINFlexD_3_IFCR11    LINFlexD_3.IFCR[11].R         /* Identifier Filter Control Register */
#define LINFlexD_3_IFCR12    LINFlexD_3.IFCR[12].R         /* Identifier Filter Control Register */
#define LINFlexD_3_IFCR13    LINFlexD_3.IFCR[13].R         /* Identifier Filter Control Register */
#define LINFlexD_3_IFCR14    LINFlexD_3.IFCR[14].R         /* Identifier Filter Control Register */
#define LINFlexD_3_IFCR15    LINFlexD_3.IFCR[15].R         /* Identifier Filter Control Register */
#define LINFlexD_3_GCR       LINFlexD_3.GCR.R              /* Global Control Register */
#define LINFlexD_3_UARTPTO   LINFlexD_3.UARTPTO.R          /* UART Preset Timeout Register */
#define LINFlexD_3_UARTCTO   LINFlexD_3.UARTCTO.R          /* UART Current Timeout Register */
#define LINFlexD_3_DMATXE    LINFlexD_3.DMATXE.R           /* DMA Tx Enable Register */
#define LINFlexD_3_DMARXE    LINFlexD_3.DMARXE.R           /* DMA Rx Enable Register */

/* LINFlexD */
#define LINFlexD_M0_LINCR1   LINFlexD_M0.LINCR1.R          /* LIN Control Register 1 */
#define LINFlexD_M0_LINIER   LINFlexD_M0.LINIER.R          /* LIN Interrupt enable register */
#define LINFlexD_M0_LINSR    LINFlexD_M0.LINSR.R           /* LIN Status Register */
#define LINFlexD_M0_LINESR   LINFlexD_M0.LINESR.R          /* LIN Error Status Register */
#define LINFlexD_M0_UARTCR   LINFlexD_M0.UARTCR.R          /* UART Mode Control Register */
#define LINFlexD_M0_UARTSR   LINFlexD_M0.UARTSR.R          /* UART Mode Status Register */
#define LINFlexD_M0_LINTCSR  LINFlexD_M0.LINTCSR.R         /* LIN Time-Out Control Status Register */
#define LINFlexD_M0_LINOCR   LINFlexD_M0.LINOCR.R          /* LIN Output Compare Register */
#define LINFlexD_M0_LINTOCR  LINFlexD_M0.LINTOCR.R         /* LIN Time-Out Control Register */
#define LINFlexD_M0_LINFBRR  LINFlexD_M0.LINFBRR.R         /* LIN Fractional Baud Rate Register */
#define LINFlexD_M0_LINIBRR  LINFlexD_M0.LINIBRR.R         /* LIN Integer Baud Rate Register */
#define LINFlexD_M0_LINCFR   LINFlexD_M0.LINCFR.R          /* LIN Checksum Field Register */
#define LINFlexD_M0_LINCR2   LINFlexD_M0.LINCR2.R          /* LIN Control Register 2 */
#define LINFlexD_M0_BIDR     LINFlexD_M0.BIDR.R            /* Buffer Identifier Register */
#define LINFlexD_M0_BDRL     LINFlexD_M0.BDRL.R            /* Buffer Data Register Least Significant */
#define LINFlexD_M0_BDRM     LINFlexD_M0.BDRM.R            /* Buffer Data Register Most Significant */
#define LINFlexD_M0_IFER     LINFlexD_M0.IFER.R            /* Identifier Filter Enable Register */
#define LINFlexD_M0_IFMI     LINFlexD_M0.IFMI.R            /* Identifier Filter Match Index */
#define LINFlexD_M0_IFMR     LINFlexD_M0.IFMR.R            /* Identifier Filter Mode Register */
#define LINFlexD_M0_IFCR0    LINFlexD_M0.IFCR[0].R         /* Identifier Filter Control Register */
#define LINFlexD_M0_IFCR1    LINFlexD_M0.IFCR[1].R         /* Identifier Filter Control Register */
#define LINFlexD_M0_IFCR2    LINFlexD_M0.IFCR[2].R         /* Identifier Filter Control Register */
#define LINFlexD_M0_IFCR3    LINFlexD_M0.IFCR[3].R         /* Identifier Filter Control Register */
#define LINFlexD_M0_IFCR4    LINFlexD_M0.IFCR[4].R         /* Identifier Filter Control Register */
#define LINFlexD_M0_IFCR5    LINFlexD_M0.IFCR[5].R         /* Identifier Filter Control Register */
#define LINFlexD_M0_IFCR6    LINFlexD_M0.IFCR[6].R         /* Identifier Filter Control Register */
#define LINFlexD_M0_IFCR7    LINFlexD_M0.IFCR[7].R         /* Identifier Filter Control Register */
#define LINFlexD_M0_IFCR8    LINFlexD_M0.IFCR[8].R         /* Identifier Filter Control Register */
#define LINFlexD_M0_IFCR9    LINFlexD_M0.IFCR[9].R         /* Identifier Filter Control Register */
#define LINFlexD_M0_IFCR10   LINFlexD_M0.IFCR[10].R        /* Identifier Filter Control Register */
#define LINFlexD_M0_IFCR11   LINFlexD_M0.IFCR[11].R        /* Identifier Filter Control Register */
#define LINFlexD_M0_IFCR12   LINFlexD_M0.IFCR[12].R        /* Identifier Filter Control Register */
#define LINFlexD_M0_IFCR13   LINFlexD_M0.IFCR[13].R        /* Identifier Filter Control Register */
#define LINFlexD_M0_IFCR14   LINFlexD_M0.IFCR[14].R        /* Identifier Filter Control Register */
#define LINFlexD_M0_IFCR15   LINFlexD_M0.IFCR[15].R        /* Identifier Filter Control Register */
#define LINFlexD_M0_GCR      LINFlexD_M0.GCR.R             /* Global Control Register */
#define LINFlexD_M0_UARTPTO  LINFlexD_M0.UARTPTO.R         /* UART Preset Timeout Register */
#define LINFlexD_M0_UARTCTO  LINFlexD_M0.UARTCTO.R         /* UART Current Timeout Register */
#define LINFlexD_M0_DMATXE   LINFlexD_M0.DMATXE.R          /* DMA Tx Enable Register */
#define LINFlexD_M0_DMARXE   LINFlexD_M0.DMARXE.R          /* DMA Rx Enable Register */

/* LINFlexD */
#define LINFlexD_M1_LINCR1   LINFlexD_M1.LINCR1.R          /* LIN Control Register 1 */
#define LINFlexD_M1_LINIER   LINFlexD_M1.LINIER.R          /* LIN Interrupt enable register */
#define LINFlexD_M1_LINSR    LINFlexD_M1.LINSR.R           /* LIN Status Register */
#define LINFlexD_M1_LINESR   LINFlexD_M1.LINESR.R          /* LIN Error Status Register */
#define LINFlexD_M1_UARTCR   LINFlexD_M1.UARTCR.R          /* UART Mode Control Register */
#define LINFlexD_M1_UARTSR   LINFlexD_M1.UARTSR.R          /* UART Mode Status Register */
#define LINFlexD_M1_LINTCSR  LINFlexD_M1.LINTCSR.R         /* LIN Time-Out Control Status Register */
#define LINFlexD_M1_LINOCR   LINFlexD_M1.LINOCR.R          /* LIN Output Compare Register */
#define LINFlexD_M1_LINTOCR  LINFlexD_M1.LINTOCR.R         /* LIN Time-Out Control Register */
#define LINFlexD_M1_LINFBRR  LINFlexD_M1.LINFBRR.R         /* LIN Fractional Baud Rate Register */
#define LINFlexD_M1_LINIBRR  LINFlexD_M1.LINIBRR.R         /* LIN Integer Baud Rate Register */
#define LINFlexD_M1_LINCFR   LINFlexD_M1.LINCFR.R          /* LIN Checksum Field Register */
#define LINFlexD_M1_LINCR2   LINFlexD_M1.LINCR2.R          /* LIN Control Register 2 */
#define LINFlexD_M1_BIDR     LINFlexD_M1.BIDR.R            /* Buffer Identifier Register */
#define LINFlexD_M1_BDRL     LINFlexD_M1.BDRL.R            /* Buffer Data Register Least Significant */
#define LINFlexD_M1_BDRM     LINFlexD_M1.BDRM.R            /* Buffer Data Register Most Significant */
#define LINFlexD_M1_IFER     LINFlexD_M1.IFER.R            /* Identifier Filter Enable Register */
#define LINFlexD_M1_IFMI     LINFlexD_M1.IFMI.R            /* Identifier Filter Match Index */
#define LINFlexD_M1_IFMR     LINFlexD_M1.IFMR.R            /* Identifier Filter Mode Register */
#define LINFlexD_M1_IFCR0    LINFlexD_M1.IFCR[0].R         /* Identifier Filter Control Register */
#define LINFlexD_M1_IFCR1    LINFlexD_M1.IFCR[1].R         /* Identifier Filter Control Register */
#define LINFlexD_M1_IFCR2    LINFlexD_M1.IFCR[2].R         /* Identifier Filter Control Register */
#define LINFlexD_M1_IFCR3    LINFlexD_M1.IFCR[3].R         /* Identifier Filter Control Register */
#define LINFlexD_M1_IFCR4    LINFlexD_M1.IFCR[4].R         /* Identifier Filter Control Register */
#define LINFlexD_M1_IFCR5    LINFlexD_M1.IFCR[5].R         /* Identifier Filter Control Register */
#define LINFlexD_M1_IFCR6    LINFlexD_M1.IFCR[6].R         /* Identifier Filter Control Register */
#define LINFlexD_M1_IFCR7    LINFlexD_M1.IFCR[7].R         /* Identifier Filter Control Register */
#define LINFlexD_M1_IFCR8    LINFlexD_M1.IFCR[8].R         /* Identifier Filter Control Register */
#define LINFlexD_M1_IFCR9    LINFlexD_M1.IFCR[9].R         /* Identifier Filter Control Register */
#define LINFlexD_M1_IFCR10   LINFlexD_M1.IFCR[10].R        /* Identifier Filter Control Register */
#define LINFlexD_M1_IFCR11   LINFlexD_M1.IFCR[11].R        /* Identifier Filter Control Register */
#define LINFlexD_M1_IFCR12   LINFlexD_M1.IFCR[12].R        /* Identifier Filter Control Register */
#define LINFlexD_M1_IFCR13   LINFlexD_M1.IFCR[13].R        /* Identifier Filter Control Register */
#define LINFlexD_M1_IFCR14   LINFlexD_M1.IFCR[14].R        /* Identifier Filter Control Register */
#define LINFlexD_M1_IFCR15   LINFlexD_M1.IFCR[15].R        /* Identifier Filter Control Register */
#define LINFlexD_M1_GCR      LINFlexD_M1.GCR.R             /* Global Control Register */
#define LINFlexD_M1_UARTPTO  LINFlexD_M1.UARTPTO.R         /* UART Preset Timeout Register */
#define LINFlexD_M1_UARTCTO  LINFlexD_M1.UARTCTO.R         /* UART Current Timeout Register */
#define LINFlexD_M1_DMATXE   LINFlexD_M1.DMATXE.R          /* DMA Tx Enable Register */
#define LINFlexD_M1_DMARXE   LINFlexD_M1.DMARXE.R          /* DMA Rx Enable Register */

/* MC_CGM */
#define MC_CGM_PCS_SDUR      MC_CGM.PCS_SDUR.R             /* PCS Switch Duration */
#define MC_CGM_PCS_DIVC1     MC_CGM.PCS_DIVC1.R            /* PCS Divider Change for external crystal oscillator */
#define MC_CGM_PCS_DIVE1     MC_CGM.PCS_DIVE1.R            /* PCS Divider End for external crystal oscillator */
#define MC_CGM_PCS_DIVS1     MC_CGM.PCS_DIVS1.R            /* PCS Divider Start for external crystal oscillator */
#define MC_CGM_PCS_DIVC2     MC_CGM.PCS_DIVC2.R            /* PCS Divider Change for PLL0 PHI */
#define MC_CGM_PCS_DIVE2     MC_CGM.PCS_DIVE2.R            /* PCS Divider End for PLL0 PHI */
#define MC_CGM_PCS_DIVS2     MC_CGM.PCS_DIVS2.R            /* PCS Divider Start for PLL0 PHI */
#define MC_CGM_PCS_DIVC4     MC_CGM.PCS_DIVC4.R            /* PCS Divider Change for PLL1 PHI */
#define MC_CGM_PCS_DIVE4     MC_CGM.PCS_DIVE4.R            /* PCS Divider End for PLL1 PHI */
#define MC_CGM_PCS_DIVS4     MC_CGM.PCS_DIVS4.R            /* PCS Divider Start for PLL1 PHI */
#define MC_CGM_SC_DIV_RC     MC_CGM.SC_DIV_RC.R            /* System Clock Divider Ratio Change Register */
#define MC_CGM_DIV_UPD_TYPE  MC_CGM.DIV_UPD_TYPE.R         /* Divider Update Type */
#define MC_CGM_DIV_UPD_TRIG  MC_CGM.DIV_UPD_TRIG.R         /* Divider Update Trigger */
#define MC_CGM_DIV_UPD_STAT  MC_CGM.DIV_UPD_STAT.R         /* Divider Update Status */
#define MC_CGM_SC_SS         MC_CGM.SC_SS.R                /* System Clock Select Status */
#define MC_CGM_SC_DC0        MC_CGM.SC_DC[0].R             /* System Clock Divider Configuration 0 */
#define MC_CGM_SC_DC1        MC_CGM.SC_DC[1].R             /* System Clock Divider Configuration 1 */
#define MC_CGM_SC_DC2        MC_CGM.SC_DC[2].R             /* System Clock Divider Configuration 2 */
#define MC_CGM_AC0_SC        MC_CGM.AC0_SC.R               /* Aux Clock 0 Select Control */
#define MC_CGM_AC0_SS        MC_CGM.AC0_SS.R               /* Aux Clock 0 Select Status */
#define MC_CGM_AC0_DC0       MC_CGM.AC0_DC0.R              /* Aux Clock 0 Divider Configuration 0 */
#define MC_CGM_AC0_DC1       MC_CGM.AC0_DC1.R              /* Aux Clock 0 Divider Configuration 1 */
#define MC_CGM_AC0_DC2       MC_CGM.AC0_DC2.R              /* Aux Clock 0 Divider Configuration 2 */
#define MC_CGM_AC0_DC3       MC_CGM.AC0_DC3.R              /* Aux Clock 0 Divider Configuration 3 */
#define MC_CGM_AC0_DC4       MC_CGM.AC0_DC4.R              /* Aux Clock 0 Divider Configuration 4 */
#define MC_CGM_AC1_SC        MC_CGM.AC1_SC.R               /* Aux Clock 1 Select Control */
#define MC_CGM_AC1_SS        MC_CGM.AC1_SS.R               /* Aux Clock 1 Select Status */
#define MC_CGM_AC1_DC0       MC_CGM.AC1_DC0.R              /* Aux Clock 1 Divider Configuration 0 */
#define MC_CGM_AC2_SC        MC_CGM.AC2_SC.R               /* Aux Clock 2 Select Control */
#define MC_CGM_AC2_SS        MC_CGM.AC2_SS.R               /* Aux Clock 2 Select Status */
#define MC_CGM_AC2_DC0       MC_CGM.AC2_DC0.R              /* Aux Clock 2 Divider Configuration 0 */
#define MC_CGM_AC3_SC        MC_CGM.AC3_SC.R               /* Aux Clock 3 Select Control */
#define MC_CGM_AC3_SS        MC_CGM.AC3_SS.R               /* Aux Clock 3 Select Status */
#define MC_CGM_AC4_SC        MC_CGM.AC4_SC.R               /* Aux Clock 4 Select Control */
#define MC_CGM_AC4_SS        MC_CGM.AC4_SS.R               /* Aux Clock 4 Select Status */
#define MC_CGM_AC5_SC        MC_CGM.AC5_SC.R               /* Aux Clock 5 Select Control */
#define MC_CGM_AC5_SS        MC_CGM.AC5_SS.R               /* Aux Clock 5 Select Status */
#define MC_CGM_AC5_DC0       MC_CGM.AC5_DC0.R              /* Aux Clock 5 Divider Configuration 0 */
#define MC_CGM_AC5_DC1       MC_CGM.AC5_DC1.R              /* Aux Clock 5 Divider Configuration 1 */
#define MC_CGM_AC6_SC        MC_CGM.AC6_SC.R               /* Aux Clock 6 Select Control */
#define MC_CGM_AC6_SS        MC_CGM.AC6_SS.R               /* Aux Clock 6 Select Status */
#define MC_CGM_AC6_DC0       MC_CGM.AC6_DC0.R              /* Aux Clock 6 Divider Configuration 0 */
#define MC_CGM_AC8_SC        MC_CGM.AC8_SC.R               /* Aux Clock 8 Select Control */
#define MC_CGM_AC8_SS        MC_CGM.AC8_SS.R               /* Aux Clock 8 Select Status */
#define MC_CGM_AC8_DC0       MC_CGM.AC8_DC0.R              /* Aux Clock 8 Divider Configuration 0 */
#define MC_CGM_AC9_SC        MC_CGM.AC9_SC.R               /* Aux Clock 9 Select Control */
#define MC_CGM_AC9_SS        MC_CGM.AC9_SS.R               /* Aux Clock 9 Select Status */
#define MC_CGM_AC9_DC0       MC_CGM.AC9_DC0.R              /* Aux Clock 9 Divider Configuration 0 */
#define MC_CGM_AC10_SC       MC_CGM.AC10_SC.R              /* Aux Clock 10 Select Control */
#define MC_CGM_AC10_SS       MC_CGM.AC10_SS.R              /* Aux Clock 10 Select Status */
#define MC_CGM_AC10_DC0      MC_CGM.AC10_DC0.R             /* Aux Clock 10 Divider Configuration 0 */

/* MC_ME */
#define MC_ME_GS             MC_ME.GS.R                    /* Global Status */
#define MC_ME_MCTL           MC_ME.MCTL.R                  /* Mode Control */
#define MC_ME_ME             MC_ME.ME.R                    /* Mode Enable */
#define MC_ME_IS             MC_ME.IS.R                    /* Interrupt Status */
#define MC_ME_IM             MC_ME.IM.R                    /* Interrupt Mask */
#define MC_ME_IMTS           MC_ME.IMTS.R                  /* Invalid Mode Transition Status */
#define MC_ME_DMTS           MC_ME.DMTS.R                  /* Debug Mode Transition Status */
#define MC_ME_RESET_MC       MC_ME.RESET_MC.R              /* RESET Mode Configuration */
#define MC_ME_TEST_MC        MC_ME.TEST_MC.R               /* TEST Mode Configuration */
#define MC_ME_SAFE_MC        MC_ME.SAFE_MC.R               /* SAFE Mode Configuration */
#define MC_ME_DRUN_MC        MC_ME.DRUN_MC.R               /* DRUN Mode Configuration */
#define MC_ME_RUN0_MC        MC_ME.RUN_MC[0].R             /* RUN0 Mode Configuration */
#define MC_ME_RUN1_MC        MC_ME.RUN_MC[1].R             /* RUN1 Mode Configuration */
#define MC_ME_RUN2_MC        MC_ME.RUN_MC[2].R             /* RUN2 Mode Configuration */
#define MC_ME_RUN3_MC        MC_ME.RUN_MC[3].R             /* RUN3 Mode Configuration */
#define MC_ME_HALT0_MC       MC_ME.HALT0_MC.R              /* HALT0 Mode Configuration */
#define MC_ME_STOP0_MC       MC_ME.STOP0_MC.R              /* STOP0 Mode Configuration */
#define MC_ME_PS0            MC_ME.PS0.R                   /* Peripheral Status 0 */
#define MC_ME_PS1            MC_ME.PS1.R                   /* Peripheral Status 1 */
#define MC_ME_PS2            MC_ME.PS2.R                   /* Peripheral Status 2 */
#define MC_ME_PS3            MC_ME.PS3.R                   /* Peripheral Status 3 */
#define MC_ME_PS4            MC_ME.PS4.R                   /* Peripheral Status 4 */
#define MC_ME_PS5            MC_ME.PS5.R                   /* Peripheral Status 5 */
#define MC_ME_PS6            MC_ME.PS6.R                   /* Peripheral Status 6 */
#define MC_ME_PS7            MC_ME.PS7.R                   /* Peripheral Status 7 */
#define MC_ME_RUN_PC0        MC_ME.RUN_PC[0].R             /* Run Peripheral Configuration 0 */
#define MC_ME_RUN_PC1        MC_ME.RUN_PC[1].R             /* Run Peripheral Configuration 0 */
#define MC_ME_RUN_PC2        MC_ME.RUN_PC[2].R             /* Run Peripheral Configuration 0 */
#define MC_ME_RUN_PC3        MC_ME.RUN_PC[3].R             /* Run Peripheral Configuration 0 */
#define MC_ME_RUN_PC4        MC_ME.RUN_PC[4].R             /* Run Peripheral Configuration 0 */
#define MC_ME_RUN_PC5        MC_ME.RUN_PC[5].R             /* Run Peripheral Configuration 0 */
#define MC_ME_RUN_PC6        MC_ME.RUN_PC[6].R             /* Run Peripheral Configuration 0 */
#define MC_ME_RUN_PC7        MC_ME.RUN_PC[7].R             /* Run Peripheral Configuration 0 */
#define MC_ME_LP_PC0         MC_ME.LP_PC[0].R              /* Low-Power Peripheral Configuration 0 */
#define MC_ME_LP_PC1         MC_ME.LP_PC[1].R              /* Low-Power Peripheral Configuration 0 */
#define MC_ME_LP_PC2         MC_ME.LP_PC[2].R              /* Low-Power Peripheral Configuration 0 */
#define MC_ME_LP_PC3         MC_ME.LP_PC[3].R              /* Low-Power Peripheral Configuration 0 */
#define MC_ME_LP_PC4         MC_ME.LP_PC[4].R              /* Low-Power Peripheral Configuration 0 */
#define MC_ME_LP_PC5         MC_ME.LP_PC[5].R              /* Low-Power Peripheral Configuration 0 */
#define MC_ME_LP_PC6         MC_ME.LP_PC[6].R              /* Low-Power Peripheral Configuration 0 */
#define MC_ME_LP_PC7         MC_ME.LP_PC[7].R              /* Low-Power Peripheral Configuration 0 */
#define MC_ME_PCTL0          MC_ME.PCTL[0].R               /*  */
#define MC_ME_PCTL1          MC_ME.PCTL[1].R               /*  */
#define MC_ME_PCTL2          MC_ME.PCTL[2].R               /*  */
#define MC_ME_PCTL3          MC_ME.PCTL[3].R               /*  */
#define MC_ME_PCTL4          MC_ME.PCTL[4].R               /*  */
#define MC_ME_PCTL5          MC_ME.PCTL[5].R               /*  */
#define MC_ME_PCTL6          MC_ME.PCTL[6].R               /*  */
#define MC_ME_PCTL7          MC_ME.PCTL[7].R               /*  */
#define MC_ME_PCTL8          MC_ME.PCTL[8].R               /*  */
#define MC_ME_PCTL9          MC_ME.PCTL[9].R               /* LFAST_0 Control */
#define MC_ME_PCTL10         MC_ME.PCTL[10].R              /*  */
#define MC_ME_PCTL11         MC_ME.PCTL[11].R              /* SIPI_0 Control */
#define MC_ME_PCTL12         MC_ME.PCTL[12].R              /*  */
#define MC_ME_PCTL13         MC_ME.PCTL[13].R              /*  */
#define MC_ME_PCTL14         MC_ME.PCTL[14].R              /*  */
#define MC_ME_PCTL15         MC_ME.PCTL[15].R              /* SIUL2 Control */
#define MC_ME_PCTL16         MC_ME.PCTL[16].R              /*  */
#define MC_ME_PCTL17         MC_ME.PCTL[17].R              /*  */
#define MC_ME_PCTL18         MC_ME.PCTL[18].R              /*  */
#define MC_ME_PCTL19         MC_ME.PCTL[19].R              /*  */
#define MC_ME_PCTL20         MC_ME.PCTL[20].R              /*  */
#define MC_ME_PCTL21         MC_ME.PCTL[21].R              /*  */
#define MC_ME_PCTL22         MC_ME.PCTL[22].R              /*  */
#define MC_ME_PCTL23         MC_ME.PCTL[23].R              /*  */
#define MC_ME_PCTL24         MC_ME.PCTL[24].R              /*  */
#define MC_ME_PCTL25         MC_ME.PCTL[25].R              /*  */
#define MC_ME_PCTL26         MC_ME.PCTL[26].R              /*  */
#define MC_ME_PCTL27         MC_ME.PCTL[27].R              /*  */
#define MC_ME_PCTL28         MC_ME.PCTL[28].R              /* DECFILT_1 Control */
#define MC_ME_PCTL29         MC_ME.PCTL[29].R              /* DECFILT_0 Control */
#define MC_ME_PCTL30         MC_ME.PCTL[30].R              /* PIT_RTI_0 Control */
#define MC_ME_PCTL31         MC_ME.PCTL[31].R              /* PIT_RTI_1 Control */
#define MC_ME_PCTL32         MC_ME.PCTL[32].R              /*  */
#define MC_ME_PCTL33         MC_ME.PCTL[33].R              /*  */
#define MC_ME_PCTL34         MC_ME.PCTL[34].R              /*  */
#define MC_ME_PCTL35         MC_ME.PCTL[35].R              /*  */
#define MC_ME_PCTL36         MC_ME.PCTL[36].R              /* DMA_CH_MUX_0-2 Control */
#define MC_ME_PCTL37         MC_ME.PCTL[37].R              /*  */
#define MC_ME_PCTL38         MC_ME.PCTL[38].R              /* CRC_0 Control */
#define MC_ME_PCTL39         MC_ME.PCTL[39].R              /*  */
#define MC_ME_PCTL40         MC_ME.PCTL[40].R              /*  */
#define MC_ME_PCTL41         MC_ME.PCTL[41].R              /*  */
#define MC_ME_PCTL42         MC_ME.PCTL[42].R              /*  */
#define MC_ME_PCTL43         MC_ME.PCTL[43].R              /*  */
#define MC_ME_PCTL44         MC_ME.PCTL[44].R              /*  */
#define MC_ME_PCTL45         MC_ME.PCTL[45].R              /* JTAGM Control */
#define MC_ME_PCTL46         MC_ME.PCTL[46].R              /*  */
#define MC_ME_PCTL47         MC_ME.PCTL[47].R              /*  */
#define MC_ME_PCTL48         MC_ME.PCTL[48].R              /*  */
#define MC_ME_PCTL49         MC_ME.PCTL[49].R              /*  */
#define MC_ME_PCTL50         MC_ME.PCTL[50].R              /*  */
#define MC_ME_PCTL51         MC_ME.PCTL[51].R           