/*****************************************************************************/
/*                                                                           */
/* FILE NAME     :  main_core0.c                                             */
/* DESCRIPTION   :  Main function to toggle LED periodically                 */
/* DATE          :  July 31, 2013                                            */
/*                                                                           */
/*****************************************************************************/

#include "../headers/project.h"

extern void Irq_Init_Core0(void);
extern void copy_handler_to_imem_c0(void);

/*****************************************************************************/
/*         Function: main                                                    */
/*         Content:  main function for core 0                                */
/*                   Toggle I/O pin periodically to toggle connected LED     */
/*         Argument: void                                                    */
/*         Return value: void                                                */
/*****************************************************************************/

int main_core0(void)
{
    volatile uint32_t i;

    /* Please connect PA3 to USER LEDS pin 2 */
    /* Setup port PA[3] as output which is connected to PA[3] of EVB pin */
    SIUL2.MSCR0_255[3].R = 0x12380000;

    /* Please connect PC15 to USER LEDS pin 4 */
    /* Setup port PC[6] as output which is connected to PC[15] of EVB pin*/
    /* This pin will be toggled by PIT Interrupt on core 0 */
    SIUL2.MSCR0_255[38].R = 0x12380000;
    SIUL2.GPDO[38].B.PDO = 0;	/* LED is on */
    
    /* copy IVOR vectors and IVOR4 handler to IMEM */
    //copy_handler_to_imem_c0();

    /* set up interrupts for core 0 */
    Irq_Init_Core0();

    /* PIT 0 Timer 2 Config - Used for Periodic Interrupt example  */
    PIT_0.MCR.B.MDIS = 0;                                      /* Enable PIT */
    PIT_0.CH[2].LDVAL.R = 0x04C4B400;               /* 2S at 40MHz Per clock */
    PIT_0.CH[2].TCTRL.R = 0x00000003;            /* enable timer CH2 and int */
        
    /* Main While Loop */
    while(1)
    {
	i = 0;
	while (i < 10000000)
	{
	    i++;
	}
	/* Toggle LED 2 */
	SIUL2.GPDO[3].B.PDO = ~SIUL2.GPDO[3].B.PDO;
    }

}

