/*****************************************************************************/
/*                                                                           */
/*   FILE NAME     :  irq_init_core1.c                                       */
/*   DESCRIPTION   :  Example source for initializing the core 1 interrupts  */
/*   DATE          :  July 31, 2013                                          */
/*                                                                           */
/*****************************************************************************/

#include "../headers/project.h"
extern const uint32_t IntcIsrVectorTable[];

/*****************************************************************************/
/*            Function: Irq_Init_Core1                                       */
/*            This function intializes the INTC for core 1                   */
/*****************************************************************************/
void Irq_Init_Core1(void) {
    volatile int temp;

    /* Choose software (HVEN=0) or hardware (HVEN=1) vector mode */
    INTC_0.BCR.R &= 0xFFFFFFEF;

    /* Read IACKR before enabling interrupts */
    temp = INTC_0.IACKR1.R;
    
    /* Set INTC ISR vector table base addr. */
    INTC_0.IACKR1.R = (uint32_t) &IntcIsrVectorTable[0]; 

    /* only core 1 can write PSR registers */
    INTC_0.PSR[229].R = 0x4002; // IRQ229(PIT0 CH3)irq goes to core 1, priority 2
    INTC_0.PSR[228].R = 0x8001; // IRQ228(PIT0 CH2)irq goes to core 0, priority 1

    
    /* Ensure INTC's current priority is 0 */
    INTC_0.CPR1.B.PRI = 0;
    
    /* Enable external interrupts */
    asm(" wrteei 1");
}

