/*****************************************************************************/
/*                                                                           */
/* FILE NAME     :  main_core1.c                                             */
/* DESCRIPTION   :  Main function to toggle LED periodically                 */
/* DATE          :  July 31, 2013                                            */
/*                                                                           */
/*****************************************************************************/

#include "../headers/project.h"

extern void Clock_and_Mode_Init(void);
extern void Irq_Init_Core1(void);
extern void copy_handler_to_imem_c1(void);

/*****************************************************************************/
/*         Function: main                                                    */
/*         Content:  main function for core 1                                */
/*                   Toggle I/O pin periodically to toggle connected LED     */
/*         Argument: void                                                    */
/*         Return value: void                                                */
/*****************************************************************************/

int main(void)
{
    volatile uint32_t i;

    /* Please connect PA0 to USER LEDS pin 1 */
    /* Setup port PA[0] as output which is connected to PA[0] of EVB pin */
    SIUL2.MSCR0_255[0].R = 0x12380000;

    /* Please connect PA15 to USER LEDS pin 3 */
    /* Setup port PC[0] as output which is connected to PA[15] of EVB pin*/
    /* This pin will be toggled by PIT Interrupt on core 1 */
    SIUL2.MSCR0_255[32].R = 0x12380000;
    SIUL2.GPDO[32].B.PDO = 0;	/* LED is on */
    SIUL2.MSCR512_955[1].R = 0x0;
    
    /* copy IVOR table and IVOR4 Handler to IMEM */
    //copy_handler_to_imem_c1();
    
    /* Initialize and start core1 interrupt */
    Irq_Init_Core1();

    
    
    
    /* PIT 0 Timer 2 Config - Used for Periodic Interrupt example  */
    PIT_0.MCR.B.MDIS = 0;                                      /* Enable PIT */
    PIT_0.CH[3].LDVAL.R = 0x02625A00;               /* 1S at 40MHz Per clock */
    PIT_0.CH[3].TCTRL.R = 0x00000003;            /* enable timer CH3 and int */

    /* Main While Loop */
    while(1)
    {
	i = 0;
	while (i < 1000000)
	{
	    i++;
	}
	/* Toggle LED 1 */
	SIUL2.GPDO[0].B.PDO = ~SIUL2.GPDO[0].B.PDO;
    }
}
