/*---------- MODIFY THIS SECTION FOR YOUR DEVICE -----------*/
DEFAULTS {
// Define Core 0 Flash Allocation
   FLASH_SIZE = 256K
// Define Core 0 Flash Base Address 
   FLASH_BASE_ADDR =  0x01040000

// Define Core 0 SRAM Allocation  
   C0_SRAM_SIZE =  112K    
// Define Processor 2 SRAM Base Address
   C0_SRAM_BASE_ADDR = 0x40008000  

// Define Core 0 IMEM  
   C0_IMEM_SIZE =  16K    
// Define Processor 1 IMEM Base Address
   C0_IMEM_BASE_ADDR = 0x50000000   

// Define Core 0 DMEM  
   C0_DMEM_SIZE =  32K    
// Define Processor 1 DMEM Base Address
   C0_DMEM_BASE_ADDR = 0x50800000   
	
// Stack located at end of DMEM     
// Define Stack Size
   STACK_SIZE = 4K       
       
}

/*---------- DO NOT MODIFY ANYTHING BELOW THIS POINT -------*/
MEMORY {
    int_flash : org = FLASH_BASE_ADDR,     len = FLASH_SIZE
    int_sram  : org = C0_SRAM_BASE_ADDR,   len = C0_SRAM_SIZE
    int_imem  : org = C0_IMEM_BASE_ADDR,   len = C0_IMEM_SIZE
    int_dmem  : org = C0_DMEM_BASE_ADDR,   len = C0_DMEM_SIZE-STACK_SIZE
    stack_ram : org = (C0_DMEM_BASE_ADDR+C0_DMEM_SIZE-STACK_SIZE)  len = STACK_SIZE    
}

SECTIONS
{   
    .init             : {} > int_flash			
    .text             : {} > .              /* BookE Code   */
    .vletext          : {} > .              /* VLE Code */                                            
    .fixaddr          : {} > .              /* Required for         */
    .fixtype          : {} > .              /* compatibility with   */
    .secinfo          : {} > .              /* GHS provided startup */
    .syscall          : {} > .              /* code                 */
	
    .rodata  : {*(.rdata) *(.rodata)} > .   /* Read Only Data */
     
    .ROM.data   ROM(.data)       : {} > .   /* Store Initialised RAM Variables */
    .ROM.sdata  ROM(.sdata)      : {} > .   /* temporarily in Flash            */
    .xptn_vectors ALIGN(0x100)   : {} > .  /* Exception Vector Table (IVPR) - align 256 byte boundary */
    .isrvectbl    ALIGN(0x1000)   : {} > .   /* ISR Vector Table - must be 4K aligned */

//    .IVOR4_HWvectors ALIGN(0x1000): {} > .   /* IVOR4 HW Vector Table (IVPR) - align 4K boundary */

    .data             : {} > int_sram       /* Initialised Data                */
    .bss              : {} > .              /* Uninitialised Data              */
    .sdabase ALIGN (2): {} > .              /* Base location for SDA Area      */
    .sdata            : {} > .              /* Small Initialised Data (Area1)  */
    .sbss             : {} > .              /* Small Uninitialised Data (Area1)*/
    .sdata2           : {} > .              /* Small Initialised Constant Data */
    .sbss2            : {} > .              /* Small Uninitialised Data (Area2)*/
    
    .heap   ALIGN(16) PAD(1K)         : {} > int_sram   /* Heap Area  */
    .stack  ALIGN(4)  PAD(STACK_SIZE) : {} > stack_ram  /* Stack Area */

/*------------------------------------------------------------*/
/*  Example of allocating section at absolute address         */
/*                                                            */
/*  .my_section 0x40001000 :{} > int_flash                    */
/*                                                            */
/*  Linker uses "0x40001000" address, rather than "int_flash" */
/*------------------------------------------------------------*/

/*-------- LABELS USED IN CODE -------------------------------*/
/* Interrupt Handler Parameters */
__IVPR = ADDR(.xptn_vectors);

/* Label for IMEM and DMEM Init */
    __IMEM_START_CPU0 = C0_IMEM_BASE_ADDR;
    __IMEM_END_CPU0   = C0_IMEM_BASE_ADDR + C0_IMEM_SIZE;

    __DMEM_START_CPU0 = C0_DMEM_BASE_ADDR;
    __DMEM_END_CPU0   = C0_DMEM_BASE_ADDR + C0_DMEM_SIZE-STACK_SIZE;

/* Labels for Copying Initialised Data from Flash to RAM */
    __DATA_SRAM_ADDR_CPU0  = ADDR(.data);
    __SDATA_SRAM_ADDR_CPU0 = ADDR(.sdata);

    __DATA_SIZE_CPU0   = SIZEOF(.data);
    __SDATA_SIZE_CPU0  = SIZEOF(.sdata);

    __DATA_ROM_ADDR_CPU0  = ADDR(.ROM.data);
    __SDATA_ROM_ADDR_CPU0 = ADDR(.ROM.sdata);

/* Labels for stack */
    __STACK_SIZE = STACK_SIZE;
    __STACK_START_CPU0 = C0_DMEM_BASE_ADDR+C0_DMEM_SIZE-STACK_SIZE;
    __STACK_END_CPU0   = C0_DMEM_BASE_ADDR+C0_DMEM_SIZE;


/* These special symbols mark the bounds of RAM and ROM memory. */
/* They are used by the MULTI debugger.                         */

    __ghs_ramstart  = MEMADDR(int_sram);
    __ghs_ramend    = MEMENDADDR(int_sram);
    __ghs_romstart  = MEMADDR(int_flash);
    __ghs_romend    = MEMENDADDR(int_flash);

    __ghs_rambootcodestart = 0;           /* zero for ROM image */
    __ghs_rambootcodeend = 0;             /* zero for ROM image */
    __ghs_rombootcodestart = MEMADDR(int_flash);
    __ghs_rombootcodeend = MEMENDADDR(int_flash);

}
