/** ###################################################################
**     THIS COMPONENT MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename  : ADC.c
**     Project   : ProcessorExpert
**     Processor : MC9S08PT60CLH
**     Component : Init_ADC
**     Version   : Component 01.244, Driver 01.20, CPU db: 3.00.000
**     Compiler  : CodeWarrior HCS08 C Compiler
**     Date/Time : 2012-05-23, 10:10, # CodeGen: 218
**     Abstract  :
**          This file implements the ADC (ADC) module initialization 
**          according to the Peripheral Initialization Component settings, and defines
**          interrupt service routines prototypes. 

**     Settings  :
**          Component name                                 : ADC
**          Device                                         : ADC
**          Prescaler                                      : 2
**          Sample time                                    : 3.19 us
**          Conversion mode                                : Single conversion
**          Result data formats                            : 12-bit right
**          ADC Channels                                   : 5
**          Pins                                           : PTF4_ADP12
**                                                           PTF5_ADP13
**                                                           PTF6_ADP14
**                                                           PTB3_KBI0P7_MOSI0_ADP7_TSI5
**                                                           PTA0_KBI0P0_FTM0CH0_ACMP0_ADP0
**          Interrupt                                      : Vadc
**          Conversion complete interrupt                  : Enabled
**          ISR name                                       : AdcBackEMFdetection
**          Initial channel select                         : Channel 12 - AD12
**          Call Init method                               : yes
**          Enable module                                  : Disabled

**     Contents  :
**         Init - void ADC_Init(void);
**
**     Copyright : 1997 - 2011 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################*/

/* MODULE ADC. */

#include "ADC.h"

/*
** ###################################################################
**
**  The interrupt service routine(s) must be implemented
**  by user in one of the following user modules.
**
**  If the "Generate ISR" option is enabled, Processor Expert generates
**  ISR templates in the CPU event module.
**
**  User modules:
**      ProcessorExpert.c
**      Events.c
**
** ###################################################################
ISR( AdcBackEMFdetection)
{
  // NOTE: The routine should include the following actions to obtain
  //       correct functionality of the hardware.
  //
  // The interrupt will remain pending as long as the COCO flag is set.
  // The COCO bit is cleared whenever the ADC status and control (ADCxSC1) register is written.
  // The COCO bit is also cleared whenever the ADC result registers (ADCxRH or ADCxRL) are read.
  // Example: word result;
  //          result = ADC_R;


}
*/

/*
** ===================================================================
**     Method      :  ADC_Init (component Init_ADC)
**
**     Description :
**         This method initializes registers of the ADC module
**         according to this Peripheral Initialization Component settings.
**         Call this method in user code to initialize the module.
**         By default, the method is called by PE automatically; see
**         "Call Init method" property of the component for more details.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
void ADC_Init(void)
{
  /* SYS_SOPT2: ADHWTS=2 */
  clrSetReg8Bits(SYS_SOPT2, 0x01U, 0x02U); /* Selects the FTM2initDelay as the source of internal HW trigger */ 
  /* SYS_SOPT4: DELAY=0x0F */
  setReg8(SYS_SOPT4, 0x0FU);           /* Selects delay for the source of internal HW trigger if it could be delayed */ 
  /* ADC_APCTL1: ADPC7=1,ADPC6=0,ADPC5=0,ADPC4=0,ADPC3=0,ADPC2=0,ADPC1=0,ADPC0=1 */
  setReg8(ADC_APCTL1, 0x81U);           
  /* ADC_APCTL2: ADPC15=0,ADPC14=1,ADPC13=1,ADPC12=1,ADPC11=0,ADPC10=0,ADPC9=0,ADPC8=0 */
  setReg8(ADC_APCTL2, 0x70U);           
  /* ADC_SC4: ??=0,ASCANE=0,ACFSEL=0,??=0,??=0,AFDEP=0 */
  setReg8(ADC_SC4, 0x00U);              
  /* ADC_SC3: ADLPC=0,ADIV=1,ADLSMP=0,MODE=2,ADICLK=0 */
  setReg8(ADC_SC3, 0x28U);              
  /* ADC_CV: ??=0,??=0,??=0,??=0,CV=0 */
  setReg16(ADC_CV, 0x00U);              
  /* ADC_SC2: ADACT=0,ADTRG=1,ACFE=0,ACFGT=0,FEMPTY=1,FFULL=0,??=0,??=0 */
  setReg8(ADC_SC2, 0x48U);              
  /* ADC_SC1: COCO=0,AIEN=1,ADCO=0,ADCH=0x0C */
  setReg8(ADC_SC1, 0x4CU);              
}
/* END ADC. */

/*
** ###################################################################
**
**     This file was created by Processor Expert 5.1 [04.49]
**     for the Freescale HCS08 series of microcontrollers.
**
** ###################################################################
*/
