/******************************************************************************
* 
* Copyright (c) 2009 Freescale Semiconductor;
* All Rights Reserved                       
*
*******************************************************************************
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
***************************************************************************//*!
*
* $File Name:	3pps_bldc_drv.h$
*
* $Author:		r30322$
* 
* $Version:		1.0.34.0$
* 
* $Date:		Nov-13-2009$
* 
* $Brief: 		3-phase power stage drivers header for six-step BLDC PWM
*               using Flextimer FTM2 for the PWM and FTM1 for commutation timing
*
* Target:		MC9S08MP16 device
*
*******************************************************************************/
/* DEFINITION_START */

#ifndef _3PP_BLDC_DRV_H
#define _3PP_BLDC_DRV_H


#include "derivative.h"
#include "PE_Types.h"
#include "types.h"
#include "main.h"
#include "IO_Map.h"

typedef union {
  byte Byte;
  struct 
  {
    byte Dir024             :1;         /* motor rotation direction */
    byte TimeAlignmentRq    :1;         /* time aAlignment request */
    byte StartVectorSet     :1;         /* Start Vector set flag */
    byte Bit3               :1;
    byte ShftVector         :1;         /* Shift Vector */
    byte ForcedPLLModeRq    :1;         /* Forced PLL, Voltage (PWM) feedback Mode request */
    byte Bit6           	:1;         /* Not Used */
    byte SyncPLLModeRq      :1;         /* PLL feedback Mode request */
  } Bits;
} BLDC_MAIN_FLAGS;


#define PWM_SECTOR_MAX 5    /* pwm sector max for six step */

extern  char pwmVector_Compl_OutMask[];

extern  signed char pwmVector_UniCompl_C0ValDir024[];
extern  signed char pwmVector_UniCompl_C2ValDir024[];
extern  signed char pwmVector_UniCompl_C4ValDir024[];

extern  signed char pwmVector_UniCompl_C0ValDir420[];
extern  signed char pwmVector_UniCompl_C2ValDir420[];
extern  signed char pwmVector_UniCompl_C4ValDir420[];

extern char pwmVector_BipCompl_ElsCh0Dir024[];
extern  char pwmVector_BipCompl_ElsCh2Dir024[];
extern  char pwmVector_BipCompl_ElsCh4Dir024[];

extern  char pwmVector_BipCompl_ElsCh0Dir420[];
extern  char pwmVector_BipCompl_ElsCh2Dir420[];
extern  char pwmVector_BipCompl_ElsCh4Dir420[];


#define MTIM_TimB_EnableInterrupt() \
    {   \
		MTIM1_SC_TOF = 0; \
        MTIM1_SC_TOIE = 1; \
    }


#define FTM0ch0_TimerCmt_CmtEnableInterrupt() \
{ \
	FTM0_SC_TOF = 0;\
	FTM0_SC_TOIE = 1;\
}

/*FTM0ch0 interrupt disable*/
#define FTM0ch0_TimerCmt_CmtDisableInterrupt() \
{\
	FTM0_SC_TOIE = 0;\
}

/*PWM off for 3 phase bridge*/
#define FTM2_pwm3pps_PWMOff()\
{ \
    FTM2_OUTMASK = FTM2_OUTMASK_CH0OM_MASK|FTM2_OUTMASK_CH1OM_MASK|FTM2_OUTMASK_CH2OM_MASK|\
                  FTM2_OUTMASK_CH3OM_MASK|FTM2_OUTMASK_CH4OM_MASK|FTM2_OUTMASK_CH5OM_MASK; \
                  \
    FTM2_MODE_PWMSYNC = 0; \
    FTM2_SYNC_SWSYNC = 1; \
    FTM2_MODE_PWMSYNC = 1; \
}

/*FTM2 fault write protection*/
#define FTM2_pwm3pps_FaultFlagReadClear() \
{ \
   FTM2_FMS &= FTM2_FMS_WPEN_MASK; \
}

/*according to the sector and rotor direction to select one of six step*/
#define FTM2_pwm3pps_UnipVectorSet(pwmSectorLoc, BLDCMainFlagsLoc) \
    {if (BLDCMainFlagsLoc.Bits.Dir024) \
        { \
            FTM2_pwm3pps_UnipComplBLDCSetVectorDir024(pwmSectorLoc); \
        } \
        else \
        { \
            FTM2_pwm3pps_UnipComplBLDCSetVectorDir420(pwmSectorLoc); \
        } \
    }
/*witch phase to mask in clock wise direction */
#define FTM2_pwm3pps_UnipComplBLDCSetVectorDir024(pwmSectorLoc)  \
{   \
    FTM2_SYNC_SYNCHOM = 0; \
    FTM2_OUTMASK = pwmVector_Compl_OutMask[pwmSectorLoc]; \
    FTM2_SYNC_SYNCHOM = 1;\
  	FTM2_pwm3pps_UnipCompl_CxValDir024(pwmSectorLoc); \
	FTM2_SYNC_SWSYNC = 1;\
}

/*determine which mosfet PWM and which normally open according to clock direction*/
#define FTM2_pwm3pps_UnipCompl_CxValDir024(pwmSectorLoc2) \
{ \
  	FTM2_C0VH = (unsigned char)pwmVector_UniCompl_C0ValDir024[pwmSectorLoc2]; \
  	FTM2_C0VL = 0; \
  	FTM2_C2VH = (unsigned char)pwmVector_UniCompl_C2ValDir024[pwmSectorLoc2]; \
  	FTM2_C2VL = 0; \
  	FTM2_C4VH = (unsigned char)pwmVector_UniCompl_C4ValDir024[pwmSectorLoc2]; \
  	FTM2_C4VL = 0; \
}

#define FTM2_pwm3pps_UnipComplBLDCSetVectorDir420(pwmSectorLoc)  \
{    \
    FTM2_SYNC_SYNCHOM = 0; \
    FTM2_OUTMASK = pwmVector_Compl_OutMask[pwmSectorLoc]; \
	FTM2_SYNC_SYNCHOM = 1;\
  	FTM2_pwm3pps_UnipCompl_CxValDir420(pwmSectorLoc); \
	FTM2_SYNC_SWSYNC = 1;\
}

#define FTM2_pwm3pps_UnipCompl_CxValDir420(pwmSectorLoc) \
{ \
  	FTM2_C0VH = (unsigned char)pwmVector_UniCompl_C0ValDir420[pwmSectorLoc]; \
  	FTM2_C0VL = 0; \
  	FTM2_C2VH = (unsigned char)pwmVector_UniCompl_C2ValDir420[pwmSectorLoc]; \
  	FTM2_C2VL = 0; \
  	FTM2_C4VH = (unsigned char)pwmVector_UniCompl_C4ValDir420[pwmSectorLoc]; \
  	FTM2_C4VL = 0; \
}

#define FTM2_pwm3pps_ComplDutyCycleUpdate(dutyCycleLoc) \
{   \
	/* Phase A */ \
    FTM2_C1V = dutyCycleLoc; \
    /* Phase B */ \
    FTM2_C3V = dutyCycleLoc; \
    /* Phase C */ \
    FTM2_C5V = dutyCycleLoc; \
    \
    FTM2_SYNC |= FTM2_SYNC_SWSYNC_MASK | FTM2_SYNC_SYNCHOM_MASK | FTM2_SYNC_REINIT_MASK | FTM2_SYNC_CNTMAX_MASK; \
    \
}

/*mask one bridge*/
#define FTM2_pwm3pps_Compl_OutMaskVector(pwmSectorLoc)  \
{  \
    FTM2_OUTMASK = pwmVector_Compl_OutMask[pwmSectorLoc]; \
}


/*commutation process determine the which two transistors open and unipolar  fashion*/
#define FTM2_pwm3pps_UnipVectorCommutatePreset(pwmSectorLoc, BLDCMainFlagsLoc) \
{\
	if (BLDCMainFlagsLoc.Bits.Dir024 ) \
    { \
        FTM2_pwm3pps_UnipCompl_CxValDir024(pwmSectorLoc); \
        if (++pwmSectorLoc>PWM_SECTOR_MAX) \
        { \
            pwmSectorLoc = 0; \
        } \
    } \
    else \
    { \
        FTM2_pwm3pps_UnipCompl_CxValDir420(pwmSectorLoc); \
        if (pwmSectorLoc-- == 0) \
        { \
            pwmSectorLoc = PWM_SECTOR_MAX; \
        } \
    } \
    FTM2_pwm3pps_Compl_OutMaskVector(pwmSectorLoc); \
    FTM2_SYNC_SWSYNC = 1;\
}

    
#define FTM2_pwm3pps_UnipVectorCommutateSet(pwmSectorLoc, BLDCMainFlagsLoc) \
 {\
	if (BLDCMainFlagsLoc.Bits.Dir024 ) \
    { \
        if (++pwmSectorLoc>PWM_SECTOR_MAX) \
        {\
            pwmSectorLoc = 0;\
        }\
        FTM2_pwm3pps_UnipComplBLDCSetVectorDir024(pwmSectorLoc);\
    }\
    else \
    { \
        if (pwmSectorLoc-- == 0)\
        {\
            pwmSectorLoc = PWM_SECTOR_MAX;\
        }\
        FTM2_pwm3pps_UnipComplBLDCSetVectorDir420(pwmSectorLoc);\
    }\
}

#define FTM2_pwm3pps_BipolVectorSet(pwmSectorLoc, BLDCMainFlagsLoc) \
    {\
		if (BLDCMainFlagsLoc.Bits.Dir024) \
        { \
            FTM2_pwm3pps_BipComplBLDCSetVectorDir024(pwmSectorLoc); \
        } \
        else \
        { \
            FTM2_pwm3pps_BipComplBLDCSetVectorDir420(pwmSectorLoc); \
        } \
    }
#define FTM2_pwm3pps_BipComplBLDCSetVectorDir024(pwmSectorLoc)  \
{ \
    FTM2_SYNC_SYNCHOM = 0; \
    FTM2_pwm3pps_Compl_OutMaskVector(pwmSectorLoc); \
    FTM2_SYNC_SYNCHOM = 1; \
    FTM2_pwm3pps_BipCompl_ElsVectorDir024(pwmSectorLoc); \
}


#define FTM2_pwm3pps_BipCompl_ElsVectorDir024(pwmSectorLoc) \
{   \
  	FTM2_C0SC = pwmVector_BipCompl_ElsCh0Dir024[pwmSectorLoc]; \
  	FTM2_C2SC = pwmVector_BipCompl_ElsCh2Dir024[pwmSectorLoc]; \
  	FTM2_C4SC = pwmVector_BipCompl_ElsCh4Dir024[pwmSectorLoc]; \
}

#define FTM2_pwm3pps_BipComplBLDCSetVectorDir420(pwmSectorLoc)  \
{    \
    FTM2_SYNC_SYNCHOM = 0; \
    FTM2_pwm3pps_Compl_OutMaskVector(pwmSectorLoc);\
    FTM2_SYNC_SYNCHOM = 1; \
    FTM2_pwm3pps_BipCompl_ElsVectorDir420(pwmSectorLoc); \
}

#define FTM2_pwm3pps_BipCompl_ElsVectorDir420(pwmSectorLoc) \
{   \
  	FTM2_C0SC = pwmVector_BipCompl_ElsCh0Dir420[pwmSectorLoc]; \
  	FTM2_C2SC = pwmVector_BipCompl_ElsCh2Dir420[pwmSectorLoc]; \
  	FTM2_C4SC = pwmVector_BipCompl_ElsCh4Dir420[pwmSectorLoc]; \
}


#define FTM2_pwm3pps_BipolVectorCommutateSet(pwmSectorLoc, BLDCMainFlagsLoc) \
    {\
		if (BLDCMainFlagsLoc.Bits.Dir024) \
        { \
            if (++pwmSectorLoc>PWM_SECTOR_MAX) \
            { \
                pwmSectorLoc = 0; \
            } \
            FTM2_pwm3pps_BipComplBLDCSetVectorDir024(pwmSectorLoc); \
        } \
        else \
        { \
            if (pwmSectorLoc-- == 0) \
            { \
                pwmSectorLoc = PWM_SECTOR_MAX; \
            } \
            FTM2_pwm3pps_BipComplBLDCSetVectorDir420(pwmSectorLoc); \
        } \
    }



#define FTM2_pwm3pps_BipolVectorCommutatePreset(pwmSectorLoc, BLDCMainFlagsLoc) \
    {\
		if (BLDCMainFlagsLoc.Bits.Dir024) \
        { \
            FTM2_pwm3pps_BipCompl_ElsVectorDir024(pwmSectorLoc); \
            if (++pwmSectorLoc>PWM_SECTOR_MAX) \
            { \
                pwmSectorLoc = 0; \
            } \
        } \
        else \
        { \
            FTM2_pwm3pps_BipCompl_ElsVectorDir420(pwmSectorLoc); \
            if (pwmSectorLoc-- == 0) \
            { \
                pwmSectorLoc = PWM_SECTOR_MAX; \
            } \
        } \
        \
        FTM2_pwm3pps_Compl_OutMaskVector(pwmSectorLoc);\
        \
		FTM2_SYNC_SWSYNC = 1;\
    }



void FTM0ch0_TimerCmt_OCISetNext(unsigned int timeOCNext);

void FTM0ch0_TimerCmt_OCISetNextTrigWait(unsigned int timeOCNext);

void FTM1ch0_TimerCmt_OCISetNextTrig(unsigned int timeOCNext);

unsigned int FTM0ch0_TimerCmt_OCICorrectLow(unsigned int timeOCNext);
//extern void FTM2_pwm3pps_BipolVectorCommutateSet(signed char*pwmSectorLoc, BLDC_MAIN_FLAGS*BLDCMainFlagsLoc);
//extern void FTM2_pwm3pps_BipolVectorCommutatePreset(signed char*pwmSectorLoc, BLDC_MAIN_FLAGS*BLDCMainFlagsLoc);

#endif  /* _3PP_BLDC_DRV_H */
