/******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2004-2006 Freescale Semiconductor, Inc.
* (c) Copyright 2001-2004 Motorola, Inc.
* ALL RIGHTS RESERVED.
*
****************************************************************************//*!
*
* @file   freemaster_HC08.h
*
* @brief  FreeMASTER Driver hardware dependent stuff
*
* @version 1.0.1.0
* 
* @date Jul-7-2009
* 
*******************************************************************************/

#ifndef __FREEMASTER_HC08_H
#define __FREEMASTER_HC08_H

/******************************************************************************
* turn off some warning messages which appears in the FreeMASTER driver code
******************************************************************************/

#ifndef FMSTR_HC08_ALL_MESSAGES
#pragma MESSAGE DISABLE C1420  /* Result of function call is ignored */
#pragma MESSAGE DISABLE C3604  /* static not referenced */
#pragma MESSAGE DISABLE C4000  /* Condition always true */
#pragma MESSAGE DISABLE C4001  /* Condition always false */
#pragma MESSAGE DISABLE C4002  /* Result not used */
#pragma MESSAGE DISABLE C4301  /* Inline expansion done for call */
#pragma MESSAGE DISABLE C4443  /* Undefined macro taken as 0 */
#pragma MESSAGE DISABLE C5904  /* Division by one */
#pragma MESSAGE DISABLE C5905  /* Multiplication with one */
#pragma MESSAGE DISABLE C5909  /* Assignment in condition */
#pragma MESSAGE DISABLE C5917  /* Removed dead assignment */
#endif

/******************************************************************************
* platform-specific default configuration
******************************************************************************/

/* using 16bit addressing commands */
#ifndef FMSTR_USE_NOEX_CMDS
#define FMSTR_USE_NOEX_CMDS 1
#endif

/* using 32bit addressing commands */
#ifndef FMSTR_USE_EX_CMDS
#define FMSTR_USE_EX_CMDS   0
#endif

/*****************************************************************************
* Board configuration information 
******************************************************************************/

#define FMSTR_PROT_VER           3      /* protocol version 3 */
#define FMSTR_CFG_FLAGS  FMSTR_CFGFLAG_BIGENDIAN /* board info flags */
#define FMSTR_CFG_BUS_WIDTH      1      /* data bus width */
#define FMSTR_GLOB_VERSION_MAJOR 2      /* driver version */
#define FMSTR_GLOB_VERSION_MINOR 0
#define FMSTR_IDT_STRING "HC08 FreeMASTER Driver"
#define FMSTR_TSA_FLAGS          0

/******************************************************************************
* platform-specific types
******************************************************************************/

typedef unsigned char  FMSTR_U8;     /* smallest memory entity */
typedef unsigned short FMSTR_U16;    /* 16bit value */
typedef unsigned long  FMSTR_U32;    /* 32bit value */

typedef signed char    FMSTR_S8;     /* signed 8bit value */
typedef signed short   FMSTR_S16;    /* signed 16bit value */
typedef signed long    FMSTR_S32;    /* signed 32bit value */

typedef unsigned char  FMSTR_FLAGS;  /* type to be union-ed with flags (at least 8 bits) */
typedef unsigned char  FMSTR_SIZE8;  /* one-byte size value */
typedef signed short   FMSTR_INDEX;  /* general for-loop index (must be signed) */

typedef unsigned char  FMSTR_BCHR;   /* type of a single character in comm.buffer */
typedef unsigned char* FMSTR_BPTR;   /* pointer within a communication buffer */

typedef unsigned char  FMSTR_SCISR;  /* data type to store SCI status register */

/******************************************************************************
* communication buffer access functions (non-#pragma INLINE)
******************************************************************************/

void FMSTR_CopyMemory(FMSTR_ADDR nDestAddr, FMSTR_ADDR nSrcAddr, FMSTR_SIZE8 nSize);
FMSTR_BPTR FMSTR_CopyToBuffer(FMSTR_BPTR pDestBuff, FMSTR_ADDR nSrcAddr, FMSTR_SIZE8 nSize);
FMSTR_BPTR FMSTR_CopyFromBuffer(FMSTR_ADDR nDestAddr, FMSTR_BPTR pSrcBuff, FMSTR_SIZE8 nSize);
void FMSTR_CopyFromBufferWithMask(FMSTR_ADDR nDestAddr, FMSTR_BPTR pSrcBuff, FMSTR_SIZE8 nSize);

/* no support for EX commands  */
#if FMSTR_USE_EX_CMDS || !FMSTR_USE_NOEX_CMDS
#error Can not use EX commands in this implementation
#undef  FMSTR_USE_EX_CMDS
#define FMSTR_USE_EX_CMDS   1
#undef  FMSTR_USE_NOEX_CMDS
#define FMSTR_USE_NOEX_CMDS 0
#endif

/* we always know 16bit addresses are used, (ignore FMSTR_SetExAddr) */
#define FMSTR_SetExAddr(bNextAddrIsEx) 

/*********************************************************************************
* communication buffer access functions. Most of them are trivial simple on HC08
*********************************************************************************/

#define FMSTR_ValueFromBuffer8(pDest, pSrc) \
    ( (*((FMSTR_U8*)(pDest)) = *(FMSTR_U8*)(pSrc)), (((FMSTR_BPTR)(pSrc))+1) )

#define FMSTR_ValueFromBuffer16(pDest, pSrc) \
    ( (*((FMSTR_U16*)(pDest)) = *(FMSTR_U16*)(pSrc)), (((FMSTR_BPTR)(pSrc))+2) )

#define FMSTR_ValueFromBuffer32(pDest, pSrc) \
    ( (*((FMSTR_U32*)(pDest)) = *(FMSTR_U32*)(pSrc)), (((FMSTR_BPTR)(pSrc))+4) )


#define FMSTR_ValueToBuffer8(pDest, src) \
    ( (*((FMSTR_U8*)(pDest)) = (FMSTR_U8)(src)), (((FMSTR_BPTR)(pDest))+1) )

#define FMSTR_ValueToBuffer16(pDest, src) \
    ( (*((FMSTR_U16*)(pDest)) = (FMSTR_U16)(src)), (((FMSTR_BPTR)(pDest))+2) )

#define FMSTR_ValueToBuffer32(pDest, src) \
    ( (*((FMSTR_U32*)(pDest)) = (FMSTR_U32)(src)), (((FMSTR_BPTR)(pDest))+4) )


#define FMSTR_SkipInBuffer(pDest, nSize) \
    ( ((FMSTR_BPTR)(pDest)) + (nSize) )


#define FMSTR_ConstToBuffer8  FMSTR_ValueToBuffer8
#define FMSTR_ConstToBuffer16 FMSTR_ValueToBuffer16

#define FMSTR_AddressFromBuffer(pDest, pSrc) \
    ( (*((FMSTR_ADDR*)(pDest)) = *(FMSTR_ADDR*)(pSrc)), (((FMSTR_BPTR)(pSrc))+2) )

#define FMSTR_AddressToBuffer(pDest, nAddr) \
    ( (*((FMSTR_ADDR*)(pDest)) = (FMSTR_ADDR)(nAddr)), (((FMSTR_BPTR)(pDest))+2) )

#define FMSTR_GetS8(addr)  ( *(FMSTR_S8*)(addr) )
#define FMSTR_GetU8(addr)  ( *(FMSTR_U8*)(addr) )
#define FMSTR_GetS16(addr) ( *(FMSTR_S16*)(addr) )
#define FMSTR_GetU16(addr) ( *(FMSTR_U16*)(addr) )
#define FMSTR_GetS32(addr) ( *(FMSTR_S32*)(addr) )
#define FMSTR_GetU32(addr) ( *(FMSTR_U32*)(addr) )

/****************************************************************************************
* Other helper macros
*****************************************************************************************/

/* This macro assigns C pointer to FMSTR_ADDR-typed variable */
#define FMSTR_PTR2ADDR(tmpAddr,ptr) ( tmpAddr = (FMSTR_ADDR) (FMSTR_U8*) ptr )
#define FMSTR_ARR2ADDR FMSTR_PTR2ADDR

/****************************************************************************************
* Platform-specific configuration check
*****************************************************************************************/

#ifndef FMSTR_USE_SCI
#define FMSTR_USE_SCI 1
#endif

#if FMSTR_USE_SCI
    /* user must select what SCI to use */
    #ifndef FMSTR_SCI_BASE
    #error You have to define FMSTR_SCI_BASE as a base address of SCI register space
    #endif
#endif

/****************************************************************************************
* General peripheral space access macros
*****************************************************************************************/

#define FMSTR_SETBIT(base, offset, bit)     (*(((volatile FMSTR_U8*)(base))+(offset)) |= bit)
#define FMSTR_CLRBIT(base, offset, bit)     (*(((volatile FMSTR_U8*)(base))+(offset)) &= ~(bit))
#define FMSTR_SETREG(base, offset, value)   (*(((volatile FMSTR_U8*)(base))+(offset)) = value)
#define FMSTR_GETREG(base, offset)          (*(((volatile FMSTR_U8*)(base))+(offset)))

#ifdef __HCS08__

/****************************************************************************************
* HCS08 SCI module constants
*****************************************************************************************/

/* SCI module registers */
#define FMSTR_SCIBDH_OFFSET 0
#define FMSTR_SCIBDL_OFFSET 1
#define FMSTR_SCICR1_OFFSET 2
#define FMSTR_SCICR2_OFFSET 3
#define FMSTR_SCISR1_OFFSET 4
#define FMSTR_SCISR2_OFFSET 5
#define FMSTR_SCICR3_OFFSET 6
#define FMSTR_SCIDR_OFFSET  7

/* SCI Control Register bits */
#define FMSTR_SCICR1_LOOPS     0x80
#define FMSTR_SCICR1_SWAI      0x40
#define FMSTR_SCICR1_RSRC      0x20
#define FMSTR_SCICR1_M         0x10
#define FMSTR_SCICR1_WAKE      0x08
#define FMSTR_SCICR1_ILT       0x04
#define FMSTR_SCICR1_PE        0x02
#define FMSTR_SCICR1_PT        0x01
#define FMSTR_SCICR2_TIE       0x80
#define FMSTR_SCICR2_TCIE      0x40
#define FMSTR_SCICR2_RIE       0x20
#define FMSTR_SCICR2_ILIE      0x10
#define FMSTR_SCICR2_TE        0x08
#define FMSTR_SCICR2_RE        0x04
#define FMSTR_SCICR2_RWU       0x02
#define FMSTR_SCICR2_SBK       0x01
#define FMSTR_SCICR3_R8        0x80
#define FMSTR_SCICR3_T8        0x40
#define FMSTR_SCICR3_TXDIR     0x20
#define FMSTR_SCICR3_ORIE      0x08
#define FMSTR_SCICR3_NEIE      0x04
#define FMSTR_SCICR3_FEIE      0x02
#define FMSTR_SCICR3_PEIE      0x01

/* SCI Status registers bits */
#define FMSTR_SCISR_TDRE       0x80
#define FMSTR_SCISR_TC         0x40
#define FMSTR_SCISR_RDRF       0x20
#define FMSTR_SCISR_IDLE       0x10
#define FMSTR_SCISR_OR         0x08
#define FMSTR_SCISR_NF         0x04
#define FMSTR_SCISR_FE         0x02
#define FMSTR_SCISR_PF         0x01
#define FMSTR_SCISR2_RAF       0x01

/*******************************************************************************************
* HCS08 SCI access macros
*****************************************************************************************/

/* transmitter enable/disable (also support single wire mode) */
#define FMSTR_SCI_TE() ( FMSTR_SETBIT(FMSTR_SCI_BASE, FMSTR_SCICR2_OFFSET, FMSTR_SCICR2_TE) )

#define FMSTR_SCI_TD() ( FMSTR_CLRBIT(FMSTR_SCI_BASE, FMSTR_SCICR2_OFFSET, FMSTR_SCICR2_TE), \
                         FMSTR_CLRBIT(FMSTR_SCI_BASE, FMSTR_SCICR3_OFFSET, FMSTR_SCICR3_TXDIR) )

/* receiver enable/disable */
#define FMSTR_SCI_RE() FMSTR_SETBIT(FMSTR_SCI_BASE, FMSTR_SCICR2_OFFSET, FMSTR_SCICR2_RE)
#define FMSTR_SCI_RD() FMSTR_CLRBIT(FMSTR_SCI_BASE, FMSTR_SCICR2_OFFSET, FMSTR_SCICR2_RE)

/* Transmitter-empty interrupt enable/disable */
#define FMSTR_SCI_ETXI() FMSTR_SETBIT(FMSTR_SCI_BASE, FMSTR_SCICR2_OFFSET, FMSTR_SCICR2_TIE)
#define FMSTR_SCI_DTXI() FMSTR_CLRBIT(FMSTR_SCI_BASE, FMSTR_SCICR2_OFFSET, FMSTR_SCICR2_TIE)

/* Receiver-full interrupt enable/disable */
#define FMSTR_SCI_ERXI() FMSTR_SETBIT(FMSTR_SCI_BASE, FMSTR_SCICR2_OFFSET, FMSTR_SCICR2_RIE)
#define FMSTR_SCI_DRXI() FMSTR_CLRBIT(FMSTR_SCI_BASE, FMSTR_SCICR2_OFFSET, FMSTR_SCICR2_RIE)

/* Tranmsit character */
#define FMSTR_SCI_PUTCHAR(ch) FMSTR_SETREG(FMSTR_SCI_BASE, FMSTR_SCIDR_OFFSET, ch)

/* Get received character */
#define FMSTR_SCI_GETCHAR() FMSTR_GETREG(FMSTR_SCI_BASE, FMSTR_SCIDR_OFFSET)

/* read status register */
#define FMSTR_SCI_GETSR()   FMSTR_GETREG(FMSTR_SCI_BASE, FMSTR_SCISR1_OFFSET)

/* read & clear status register  */
#define FMSTR_SCI_RDCLRSR() FMSTR_GETREG(FMSTR_SCI_BASE, FMSTR_SCISR1_OFFSET)

#else /* #ifdef __HCS08__ */

/****************************************************************************************
* HC08 SCI module constants
*****************************************************************************************/

/* SCI module registers */
#define FMSTR_SCICR1_OFFSET 0
#define FMSTR_SCICR2_OFFSET 1
#define FMSTR_SCICR3_OFFSET 2
#define FMSTR_SCISR1_OFFSET 3
#define FMSTR_SCISR2_OFFSET 4
#define FMSTR_SCIDR_OFFSET  5
#define FMSTR_SCIBD_OFFSET  6

/* SCI Control Register bits */
#define FMSTR_SCICR1_LOOPS     0x80
#define FMSTR_SCICR1_ENSCI     0x40
#define FMSTR_SCICR1_TXINV     0x20
#define FMSTR_SCICR1_M         0x10
#define FMSTR_SCICR1_WAKE      0x08
#define FMSTR_SCICR1_ILTY      0x04
#define FMSTR_SCICR1_PEN       0x02
#define FMSTR_SCICR1_PTY       0x01
#define FMSTR_SCICR2_SCTIE     0x80
#define FMSTR_SCICR2_TCIE      0x40
#define FMSTR_SCICR2_SCRIE     0x20
#define FMSTR_SCICR2_ILIE      0x10
#define FMSTR_SCICR2_TE        0x08
#define FMSTR_SCICR2_RE        0x04
#define FMSTR_SCICR2_RWU       0x02
#define FMSTR_SCICR2_SBK       0x01
#define FMSTR_SCICR3_R8        0x80
#define FMSTR_SCICR3_T8        0x40
#define FMSTR_SCICR3_TXDIR     0x20
#define FMSTR_SCICR3_ORIE      0x08
#define FMSTR_SCICR3_NEIE      0x04
#define FMSTR_SCICR3_FEIE      0x02
#define FMSTR_SCICR3_PEIE      0x01

/* SCI Status registers bits */
#define FMSTR_SCISR_TDRE       0x80
#define FMSTR_SCISR_TC         0x40
#define FMSTR_SCISR_RDRF       0x20
#define FMSTR_SCISR_IDLE       0x10
#define FMSTR_SCISR_OR         0x08
#define FMSTR_SCISR_NF         0x04
#define FMSTR_SCISR_FE         0x02
#define FMSTR_SCISR_PF         0x01
#define FMSTR_SCISR2_BKF       0x02
#define FMSTR_SCISR2_RPF       0x01

/*******************************************************************************************
* HC08 SCI access macros
*****************************************************************************************/

/* transmitter enable/disable (also support single wire mode) */
#define FMSTR_SCI_TE() ( FMSTR_SETBIT(FMSTR_SCI_BASE, FMSTR_SCICR1_OFFSET, FMSTR_SCICR1_ENSCI), \
                         FMSTR_SETBIT(FMSTR_SCI_BASE, FMSTR_SCICR2_OFFSET, FMSTR_SCICR2_TE) )    

#define FMSTR_SCI_TD() ( FMSTR_CLRBIT(FMSTR_SCI_BASE, FMSTR_SCICR2_OFFSET, FMSTR_SCICR2_TE), \
                         FMSTR_CLRBIT(FMSTR_SCI_BASE, FMSTR_SCICR3_OFFSET, FMSTR_SCICR3_TXDIR) )

/* receiver enable/disable */
#define FMSTR_SCI_RE() ( FMSTR_SETBIT(FMSTR_SCI_BASE, FMSTR_SCICR1_OFFSET, FMSTR_SCICR1_ENSCI), \
                         FMSTR_SETBIT(FMSTR_SCI_BASE, FMSTR_SCICR2_OFFSET, FMSTR_SCICR2_RE) )
#define FMSTR_SCI_RD() FMSTR_CLRBIT(FMSTR_SCI_BASE, FMSTR_SCICR2_OFFSET, FMSTR_SCICR2_RE)

/* Transmitter-empty interrupt enable/disable */
#define FMSTR_SCI_ETXI() FMSTR_SETBIT(FMSTR_SCI_BASE, FMSTR_SCICR2_OFFSET, FMSTR_SCICR2_SCTIE)
#define FMSTR_SCI_DTXI() FMSTR_CLRBIT(FMSTR_SCI_BASE, FMSTR_SCICR2_OFFSET, FMSTR_SCICR2_SCTIE)

/* Receiver-full interrupt enable/disable */
#define FMSTR_SCI_ERXI() FMSTR_SETBIT(FMSTR_SCI_BASE, FMSTR_SCICR2_OFFSET, FMSTR_SCICR2_SCRIE)
#define FMSTR_SCI_DRXI() FMSTR_CLRBIT(FMSTR_SCI_BASE, FMSTR_SCICR2_OFFSET, FMSTR_SCICR2_SCRIE)

/* Tranmsit character */
#define FMSTR_SCI_PUTCHAR(ch) FMSTR_SETREG(FMSTR_SCI_BASE, FMSTR_SCIDR_OFFSET, ch)

/* Get received character */
#define FMSTR_SCI_GETCHAR() FMSTR_GETREG(FMSTR_SCI_BASE, FMSTR_SCIDR_OFFSET)

/* read status register */
#define FMSTR_SCI_GETSR()   FMSTR_GETREG(FMSTR_SCI_BASE, FMSTR_SCISR1_OFFSET)

/* read & clear status register  */
#define FMSTR_SCI_RDCLRSR() FMSTR_GETREG(FMSTR_SCI_BASE, FMSTR_SCISR1_OFFSET)

#endif /* #ifdef __HCS08__ */

#endif /* __FREEMASTER_HC08_H */
