/******************************************************************************
* 
* Copyright (c) 2009 Freescale Semiconductor;
* All Rights Reserved                       
*
*******************************************************************************
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
***************************************************************************//*!
*
* $File Name:	adc_drv.c$
*
* $Author:		r30322$
* 
* $Version:		1.0.19.0$
* 
* $Date:		Jan-21-2010$
* 
* $Brief: 		analog variables for motor control conversion driver using ADC module
*
* Target:		MC9S08MP16 device
*
*******************************************************************************/
//#include "derivative.h"     /* include peripheral declarations */
#include "adc_drv.h"        /* include adc driver header file */
#include "hw_config.h"      /* include hardware configurations */
#include "main.h"           /* include main definitions */
#include "intrinsic_math.h" /* include arithmetics header file */
#include "PE_Types.h"
#include "IO_Map.h"

#pragma DATA_SEG SHORT MY_ZEROPAGE
unsigned char adcSensing_SecondSampState;
unsigned char adcSensingPwm3ppsSector;

unsigned char adcSensing_CalibrationCounter;

unsigned int uDcb;
unsigned int uDcbOffset;
unsigned char  adcSensing_AverageIDCBCounter;
unsigned long uDcbSum32;

unsigned long uDcbSum32offset;

signed int uDcb_ZC;
unsigned int uZCPhase;
unsigned char  adcSensing_AverageUDCBCounter;

unsigned char adcSensing_OffsetCounter;

signed int iDcb;
unsigned int iDcboffset;
unsigned long iDcbSum32;

unsigned long uBEMFAsum32;
unsigned long uBEMFBsum32;
unsigned long uBEMFCsum32;

unsigned char adcSensing_AverageTemperatureCounter;

unsigned int index1;
unsigned int index2;
unsigned int ADCSample_zcDetectEnable;



ADC_FLAGS adcFlags;
ADC_STATE_ENUM adcSensingStateIndex;
#pragma DATA_SEG DEFAULT
unsigned int uDcbFilt;
unsigned int uDcbFilt_half;

unsigned int ADCoffset;
unsigned int iDcbFilt;
FILTER_MA_T_F16  Udcb_filt;
signed int u_dc_bus_filt;
 


void ADCSensing_I_UT_Init (void)
{
    adcSensing_SecondSampState = 0;

    adcFlags.Byte = 0;
    iDcboffset = 0;
    iDcbFilt = 0;
    iDcbSum32 = 0;
    adcSensing_AverageUDCBCounter = 0;
    uDcbOffset = 0;
    uDcbFilt = 0;
    uDcbSum32 = 0;
    index1 = 0;
    index2 = 0;
    ADCSample_zcDetectEnable = 0;
    adcSensing_CalibrationCounter = 0;
    adcSensingStateIndex = ADC_INIT;
#if 0
	ADValue_BEMFA = 0;
	ADValue_BEMFA1 = 0;
	ADValue_BEMFA_Average = 0;
	
	ADValue_BEMFB = 0;
	ADValue_BEMFB1 = 0;
	ADValue_BEMFB_Average = 0;
	
	ADValue_BEMFC = 0;
	ADValue_BEMFC1 = 0;
	ADValue_BEMFC_Average = 0;
#endif
    /* ADTRG = 1 enable HW trigger */ 
#ifdef EnableAdcFifoMode
{
	ADCFIFOSetting();
}
#else
{
;
}
#endif
	ADC_EnableInterrupt()

	//ADC_SC1 = ADC_INPUT_SELECT_BEMF_A ;
    ADC_SC2_ADTRG = 1;
}

/* ADCSensing_FilterAverageU  needs to has lower interrupt priority then ADCSensing_FilterSample */
unsigned int ADCSensing_FilterAverageU (unsigned long *sumU32, unsigned char *counterU8, unsigned int outPrevU8)
{   
    unsigned int outTemp;
    unsigned char counterU8Loc;
    counterU8Loc = *counterU8;
    if(counterU8Loc >0)
    {
        outTemp = udiv32i8to16(*sumU32, counterU8Loc);
        if(counterU8Loc != *counterU8)/* solves hazard when counterU8 changed (in interrupt) during outTemp calculation */
        {
            outTemp = udiv32i8to16(*sumU32, *counterU8);
        };
        *sumU32 = 0;
        *counterU8 = 0;
        if (*counterU8 != 0)/* solves hazard when counterU8 changed (in interrupt) after counterU8 = 0 */
        {
            *sumU32 = 0;
            *counterU8 = 0;
        }
        return(outTemp);
    } else
    {
        return(outPrevU8);
    }
}

void ADCSensingCheckInit(void)
{
    if(adcFlags.Byte == ADC_FLAGS_ALLINIT_MASK)
    {
        adcSensingStateIndex = ADC_RUN;
    } else
    {
        adcSensingStateIndex = ADC_INIT;
    }
}

unsigned char adcI_UTSecondSample_InputSelectTab[2] =
                        { ADC_INPUT_SELECT_DCB_Vhalf,
                          ADC_INPUT_SELECT_DCB_I};
unsigned char adcI_UTSecondSample_InputSelectTab1[2] =
{
		ADC_INPUT_SELECT_DCB_I,	ADC_INPUT_SELECT_DCB_Vhalf
};
unsigned char adc_BEMF_InputSelectTab[6]=
{
		ADC_INPUT_SELECT_BEMF_B,ADC_INPUT_SELECT_BEMF_A,ADC_INPUT_SELECT_BEMF_C,ADC_INPUT_SELECT_BEMF_B,ADC_INPUT_SELECT_BEMF_A,ADC_INPUT_SELECT_BEMF_C	
};
void ADCValue_Average(unsigned int *ptr1,unsigned int *ptr2)
{
	unsigned int buffer[2];
	unsigned int sum32;
	int mean;
	if (index1 < 2)
	{
		buffer[index1] = *ptr1;
		index1 ++;
	}
	else 
	{
		buffer[index2] = *ptr1;
		index2 ++;
		if (index2 > 1)
		{
			index2 = 0;
		}
	}
	if (index1 >= 1)
	{
		for (mean=0;mean<2;mean++)
		{
			sum32 += buffer[mean];
		}
		sum32 >>= 1;
		*ptr2 = sum32;
		ADCSample_zcDetectEnable = 1;
	}
}

void ADCFIFOSetting(void)
{
	  ADC_SC1 = ADC_INPUT_SELECT_DCB_I;
	  ADC_SC1 = ADC_INPUT_SELECT_DCB_Vhalf;
	  ADC_SC1 = ADC_INPUT_SELECT_BEMF_A;
	  ADC_SC1 = ADC_INPUT_SELECT_BEMF_B;
	  ADC_SC1 = (ADC_INPUT_SELECT_BEMF_C | ADC_SC1_AIEN_MASK);
}
