#ifndef TYPES_H
#define TYPES_H
/*******************************************************************************
 *
 * Motorola Inc. 2003 All rights reserved
 *
 *******************************************************************************
 *
 * $File Name: types.h$
 * Description:     general types definitions
 *
 * $Version: 0.1.10.0$
 * $Date: Jan-21-2010$
 *
 * Author:          Libor Prokop (r30322)
 * Tested on Compiler:
 *                  METROWERKS ANSI-C/cC++ Compiler for HC08 V-5.0.16
 *
 * Notes:           
 *                                                                     
 * ===========================================================================
 * Copyright (c):      MOTOROLA Inc.,2003, All rights reserved.        
 *                                                                     
 * ===========================================================================
 * THIS SOFTWARE IS PROVIDED BY MOTOROLA RSAL "AS IS" AND ANY EXPRESSED OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR  PURPOSE ARE DISCLAIMED.  
 * IN NO EVENT SHALL MOTOROLA RSAL OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL,     SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND 
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF 
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * ===========================================================================
 *
 ******************************************************************************/
#define NIL  ((void *) NULL)


#define MAX_U8                  0xFF        /* maximum for unsigned 8bit value */
#define MAX_U16                 0xFFFF      /* maximum for unsigned 16bit value */

#define MAX_S8                  0x7F        /* maximum for signed 8bit value */
#define MAX_S16                 0x7FFF      /* maximum for signed 16bit value */
#define OPENLOOPCOMMUTATE        MAX_S16/2
#define MIN_S16                 0x8000      /* minimum for signed 16bit value */
#define MAX_S32                 0x7FFFFFFF  /* maximum for signed 32bit value */
/******************************************************************************
    Basic Types
******************************************************************************/
typedef void (*FCN_POINTER)(void); /* pointer to function */

typedef signed   char  SByte;
typedef unsigned char  UByte;

/* Generic word types */
typedef signed   short SWord16;
typedef unsigned short UWord16;

typedef signed   long  SWord32;
typedef unsigned long  UWord32;


typedef union
{
    struct
    {
        SWord16 H;                      /* SHLWord16 High Byte */
        UWord16 L;                      /* SHLWord16 Low Byte*/
    } HL_W16;
    SWord32 S32;                        /* SWord32 */
}SWord32HL16;

typedef union
{
    struct
    {
        SByte H;                        /* SHLWord16 High Byte */
        UByte M;                        /* SHLWord16 Middle Byte */
        UByte L;                        /* SHLWord16 Low Byte*/
    } HML_SByte;
    struct
    {
        SWord16 H16;                    /* Word of Higher 2 Bytes */
        UByte   L8;                     /* Lowest byte */
    } H16L8;                            /* Structure Word of Higher 2 Bytes and Lowest byte */
}SWord24H16L8;

typedef union
{
    struct
    {
        UByte H;                        /* SHLWord16 High Byte */
        UByte M;                        /* SHLWord16 Middle Byte */
        UByte L;                        /* SHLWord16 Low Byte*/
    } HML_SByte;
    struct
    {
        UWord16 H16;                    /* Word of Higher 2 Bytes */
        UByte   L8;                     /* Lowest byte */
    } H16L8;                            /* Structure Word of Higher 2 Bytes and Lowest byte */
}UWord24H16L8;


#endif  //TYPES_H
