/******************************************************************************
* 
* Copyright (c) 2009 Freescale Semiconductor;
* All Rights Reserved                       
*
*******************************************************************************
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
***************************************************************************//*!
*
* $File Name:	zc_detection_drv.c$
*
* $Author:		r30322$
* 
* $Version:		1.0.34.0$
* 
* $Date:		Jan-13-2012$
* 
* $Brief: 		back-EMF zero-crossing detection drivers 
*               for 3-Phase Sensorless BLDC Motor Control using AD sample 
*               for zero-crossing and FTM1 for zero-crossing capture
*
* Target:		MC9S08PT60 device
*
*******************************************************************************/
//#include <hidef.h>          /* for EnableInterrupts macro */
#include "derivative.h"     /* include peripheral declarations */
#include "hw_config.h"      /* include hardware configurations */
#include "main.h"           /* include main definitions */
#include "zc_detection_drv.h"   /* include zero crossing detection header file */
#include "IO_Map.h"

#pragma DATA_SEG SHORT MY_ZEROPAGE
ZCDETECT_STATE_ENUM  zcDetectStateIndex;
signed char zcCompSectorInit;
signed char zcCompSector;
signed char zcErrorCounter;
signed char zcSeqCorrectCounter;
unsigned int CommutationFlag;

#pragma DATA_SEG DEFAULT


char zcCompZCOpposite[] = {
   3,
   4,
   5,
   0,
   1,
   2
};

void ZCDetect_Error(void)
{
    zcErrorCounter++;
    zcSeqCorrectCounter=0;
    //timeBLDCZc = FTM0_CNT;
    ZCDetect_SetZCOff();
    zcDetectStateIndex = ZCDETECT_STG3ZCDETECTED;
}
/*zero-crossing idle*/
void ZCDetect_SetIdle(void)
{
    ZCDetect_SetZCOff();
    zcDetectStateIndex = ZCDETECT_IDLE;
}

void ZCDetect_SetZCOff(void)
{
	  //CommutationFlag = 1;
}

/*clockwise rotation*/
void ZCDetect_BeginABC(signed char zcCompSectorSet)
{
    /* set pdb */
    ZCDetect_SetStg0ABC(zcCompSectorSet);
    ZCDetect_SetStg1CurrRecirculation();
	BEMF_ADC_Channel_distinguish();
};

/*according to the sector to select the corresponding non-conduct phase*/
void ZCDetect_SetStg0ABC(signed char zcCompSectorSet)
{
    ZCDetect_SetZCOff();
  	zcCompSector = zcCompZCOpposite[zcCompSectorSet];//determine which sector to be measured
    zcDetectStateIndex = ZCDETECT_STG0;//zero crossing detect state initialization
}

/*count clockwise rotation */
void ZCDetect_BeginCBA(signed char zcCompSectorSet)
{
    /* set pdb */
    ZCDetect_SetStg0CBA(zcCompSectorSet);
    ZCDetect_SetStg1CurrRecirculation();
	BEMF_ADC_Channel_distinguish();
};

void ZCDetect_SetStg0CBA(signed char zcCompSectorSet)
{
    ZCDetect_SetZCOff();
    zcCompSector = zcCompSectorSet;
    zcDetectStateIndex = ZCDETECT_STG0;
}

void ZCDetect_SetStg1CurrRecirculation(void)
{
    zcDetectStateIndex = ZCDETECT_STG1CURR_RECIRCULATION;
}

void ZCDetect_SetStg2ZCDetectionProc(void)
{
    zcDetectStateIndex = ZCDETECT_STG2ZCDETECTION_PROC;
    CommutationFlag = 0;
}

void ZCDetect_Stg3ZCDetected(void)
{
    ZCDetect_SetZCOff();
    if(zcDetectStateIndex != ZCDETECT_STG3ZCDETECTED)
    {
        
    	/******************need to optimize *********************/
        
    	
        zcDetectStateIndex = ZCDETECT_STG3ZCDETECTED;
        zcErrorCounter = 0;
        zcSeqCorrectCounter++;
    }
}
void BEMF_ADC_Channel_distinguish(void)
{
	
    switch (zcCompSector)
    {
		case 0:
			 ADC_SC1 = ADC_INPUT_SELECT_BEMF_B | ADC_SC1_AIEN_MASK;
			 break;
		case 1:
			 ADC_SC1 = ADC_INPUT_SELECT_BEMF_A | ADC_SC1_AIEN_MASK;
			 break;
		case 2:
			ADC_SC1 = ADC_INPUT_SELECT_BEMF_C | ADC_SC1_AIEN_MASK;
			break;
		case 3:
			ADC_SC1 = ADC_INPUT_SELECT_BEMF_B | ADC_SC1_AIEN_MASK;
			break;
		case 4:
			ADC_SC1 = ADC_INPUT_SELECT_BEMF_A | ADC_SC1_AIEN_MASK;
			break;
		case 5:
			ADC_SC1 = ADC_INPUT_SELECT_BEMF_C | ADC_SC1_AIEN_MASK;
			break;
		default:
			{
				;
			}
			break;	
    }
}

