/*
 * Comms.c
 *
 *  Created on: Mar 13, 2013
 *      Author: B34981
 *      
 *  SCI Communications Driver for MagniV Bootloader 
 *  IP Versoin: SCIV5
 *  Channel: 1 (SCI1)
 *  BaudRate: 19200
 *  
 */


/**********************************************************************************************
* Includes
**********************************************************************************************/
#include "Comms.h"

/**********************************************************************************************
* External objects
**********************************************************************************************/

/**********************************************************************************************
* Local function prototypes
*********************************************************************************************/
void SCI_T_Byte(UINT8 u8char);


/**********************************************************************************************
* Global variables
**********************************************************************************************/
UINT8 u8LIN_Byte_Counter = 0;
extern BootPhraseStruct BP;
extern UINT8 u8BootPhraseRcvd;

/**********************************************************************************************
* Constants and macros
**********************************************************************************************/


/**********************************************************************************************
* Local types
**********************************************************************************************/


/**********************************************************************************************
* Local variables
**********************************************************************************************/


/**********************************************************************************************
* Local functions
**********************************************************************************************/


/**********************************************************************************************
* Global functions
**********************************************************************************************/

/***********************************************************************************************
*
* @brief    Comms_Init - Initialize the serial communications driver. Designed for SCIV5
* @param    none
* @return   none
*
************************************************************************************************/  	
void Comms_Init()
{	
	SCI1BDH = 0x00;		/* Divide frequency over 104 (0x68). 32 MHz/(16*104) = ~19200 Hz */
	SCI1BDL = 0x68;

	SCI1CR1 = 0x00;		/* 8 data bits, no parity, Idle char bit count after STOP bit */	
	SCI1CR2 = 0x0C;		/* Interrups disabled, transmitter and receiver enabled */
	
	MODRR0_SCI1RR = 1;	/* Route SCI to On-Board SCItoUSB bridge */
}


/***********************************************************************************************
*
* @brief    Comms_Tx_Ack - Reply to received Boot Phrases depending on checksum results
* @param    ACK_OPTS ack: OK or CRC_ERROR
* @return   none
*
************************************************************************************************/  	
void Comms_Tx_Ack(enum ACK_OPTS ack)
{
	SCI_T_Byte(ack);					/* Transmit acknowledge reply */				
}


/***********************************************************************************************
*
* @brief    Comms_Reset_Reg - Reset the modified registers to its defaut values
* @param    none
* @return   none
*
************************************************************************************************/  	
void Comms_Reset_Reg()
{
	SCI1BDH = 0x00;
	SCI1BDL = 0x00;
	SCI1CR1 = 0x00;
	SCI1CR2 = 0x00;
}


/***********************************************************************************************
*
* @brief    SCI_T_Byte - Transmit a byte through the SCI interface
* @param    UINT8 u8char - Character to transmit
* @return   none
*
************************************************************************************************/
void SCI_T_Byte(UINT8 u8char)
{
	while(!SCI1SR1_TDRE)		/*Dummy while. Waits until Transmit Data Register is empty*/
	{	
	}
	SCI1DRL = u8char;			/*The character to be sent is stored into the SCI data register*/
	
	while(!SCI1SR1_TC)			/*Dummy while. Waits until Transmission is completed*/
	{
	}
}


/***********************************************************************************************
*
* @brief    Comms_Rx_Data - Poll or Interrupt that receives serial data.
* @param    none
* @return   none (Data must fill the BP structure, when BP is fill, update u8BootPhraseRcvd)
*
************************************************************************************************/ 
void Comms_Rx_Data()
{		
   if(SCI1SR1_RDRF)							/* If data was received */
   {
		(void)SCI1SR1;						/* Clear Rx Flag */				
		BP.Byte[u8LIN_Byte_Counter] = SCI1DRL;	/* Store received byte on the last array position */			
		
		if(u8LIN_Byte_Counter == 0)			/* If first array byte */				
		{
			u8LIN_Byte_Counter++;			/* Advance boot data the array pointer by one */	
		}
		else
		{
			if(u8LIN_Byte_Counter >= BP.F.PhraseSize)	/* When the expected bytes have been received (first byte of each phrase) */
			{
				u8BootPhraseRcvd = 1;				/* Indicate main application that a Boot Phrase was received */
				u8LIN_Byte_Counter = 0;				/* Reset byte counter */
			}
			else
			{
				u8LIN_Byte_Counter++;			/* Advance boot data the array pointer by one */
			}
		}		   	  
   }	
}
