/*
 * Buffer.h
 *
 *  Created on: Mar 11, 2013
 *      Author: B36524
 */

#ifndef BUFFER_H_
#define BUFFER_H_

#define RX_DATA_SIZE        2048//1024 //550

// Function prototypes
extern asm void mem_init(register char *mem, register char init, register UInt16 sz);
extern void cirBufferInit(void);
extern UInt16 char_to_int(char c);
extern char int_to_char(UInt16 i);
extern char *int_to_string (UInt16 i);
extern void sci_tx(char *msg);
extern void sci_tx_char(char msg);
extern asm UInt16 get_byte(register char **ptr);
extern asm char get_char(register char **ptr);
extern asm void mem_copy(long p_start,long x_start,unsigned int cnt);

// variables
extern char *data_in;      // pointer to a cell in the circular buffer where data is about to written in
extern char *data_out;		// pointer to a cell in the circular buffer where data is about to read  
extern char rx_data[RX_DATA_SIZE];	// a circular buffer to receive the code
extern UWord16 bytesum;	// checksum of a s-record
extern char hex_string[5]; // dedicated to a 4-character ASCII string
extern UWord16 status;		// status of the boot-loading process

/////////////////////////////////////////////////////////////////////////////
// I N L I N E D   F U N C T I O N S
/////////////////////////////////////////////////////////////////////////////

inline unsigned int pmem_read(register UWord16 *addr)
{
   register unsigned int data;

   asm(move.w  p:(addr)+,data);
   return data;
}

#endif /* BUFFER_H_ */
