#include "../headers/typedefs.h"
#include "../headers/mpc5746m.h"

vuint32_t data_array0[] = {
		0xCAFEBEEF, 0xFEEDFACE, 0xBAADBEEF, 0xFACEBEEF,
		0xBAADFACE, 0xFEEDBEEF, 0xBEEFCAFE, 0xFACECAFE,
		0xCAFEBEEF, 0xFEEDFACE, 0xBAADBEEF, 0xFACEBEEF,
		0xBAADFACE, 0xFEEDBEEF,
		},

		data_array1[] = {
		0xBEEFCAFE, 0xFACECAFE,
		},
		
		TCD_SG[] = {
			(int)&data_array1[0],0x02020004,
			0x00000008,0xfffffff8,
			0x4001ff00,0x00010004,
			0xfffffff8,0x00010001,
		};

/****************** Configure the DMA - Loop of transfers ********************/
void DMA_Init(void)
{
	/* Configure CH0 */
	DMA_0.TCD[0].SADDR = (int)&data_array0[0];
	DMA_0.TCD[0].SMOD = 0;    
	DMA_0.TCD[0].SSIZE = 0x2;	/* 32-bit */
	DMA_0.TCD[0].DMOD = 0;
	DMA_0.TCD[0].DSIZE = 0x2;	/* 32-bit */
	DMA_0.TCD[0].SOFF = 0x4;
	DMA_0.TCD[0].NBYTES = 56;	/* 14x32-bits */
	DMA_0.TCD[0].SLAST = -56;
	DMA_0.TCD[0].DADDR = 0x4001F000;
	DMA_0.TCD[0].CITER_ELINK = 0;     
	//DMA_0.TCD[0].CITER_LINKCH = 0;
	DMA_0.TCD[0].CITER = 1;
	DMA_0.TCD[0].DOFF = 0x4;
	DMA_0.TCD[0].DLAST_SGA = (int)&TCD_SG[0];
	DMA_0.TCD[0].BITER = 1;
	DMA_0.TCD[0].BITER_ELINK = 0;
	//DMA_0.TCD[0].BITER_LINKCH = 0;
	DMA_0.TCD[0].BWC = 0;    
	//DMA_0.TCD[0].MAJORLINKCH = 1;	/* Link to channel 1 */
	DMA_0.TCD[0].MAJORELINK = 0;	/* Disable channel linking */
	DMA_0.TCD[0].ESG = 1;			/* Enable Sgatter/gather */
	DMA_0.TCD[0].DREQ = 0;
	DMA_0.TCD[0].INTHALF = 0;
	DMA_0.TCD[0].INTMAJ = 0;
 
} /* DMA_Init */