/**************************************************************************/
/* FILE NAME: SD_ADC.c        Copyright (c) 2013, Freescale Semiconductor */ 
/* VERSION:  3.0                                  All Rights Reserved     */
/*                                                                        */
/* DESCRIPTION:                                                           */
/* SD ADC Run IDD Code for MPC5746M                                       */						 
/*                                                                        */
/*========================================================================*/
/* UPDATE HISTORY                                                         */
/* REV      AUTHOR      DATE       DESCRIPTION OF CHANGE                  */
/* ---   -----------  ---------    ---------------------                  */					    
/* 1.0     A.Turner    16/01/12    Initial version for MPC5764M RIDD      */
/* 2.0     A.Turner    18/04/12    Modified for EMC                       */
/* 3.0     M.Vaupel    29/04/13    Modified for eDMA app note             */
/**************************************************************************/
#include "../headers/mpc5746m.h"

void start_SDADC(void)
{
	SDADC_0.FCR.R = 0x00000F07;		/* Configure FIFO: threshold = 16, size = 16 datawords */
	SDADC_0.OSDR.R = 0x0;			/* Configure OSDR: All SD ADC modules initially min time */
	SDADC_0.MCR.R = 0x15300000;		/* Configure MCR: PDR = 256, Gain =8, HFN off, diff mode */
	SDADC_0.MCR.B.FRZ = 1;			/* Power up SDADC 0 */
	SDADC_0.RSER.R = 0x00010003;	/* Configure for DMA, allow FIFO full and overflow IRQs */
	SDADC_0.CSR.R = 0x0;			/* Configure CSR 0 */
	SDADC_0.MCR.B.EN = 1;			/* Power up SDADC_0 */
	SDADC_0.RKR.R = 0x5AF0;			/* Configure RKR0: Send RST key to begin conversions with new config */
}
