#include "MPC5645S.h"

//Defines port pins vs the relevant SIU port number
#define PF5 75
#define PF6 76
#define PF10 80
#define PF11 81
#define PF12 82
#define PF13 83
#define PF14 84
#define PF15 85

#define PJ13 118
#define PJ14 119
#define PJ15 120

#define PK1  122

#define MCU_MAXFREQ	    248
#define MCU_MAXFREQ2	80

#define qspi_wait_for_ICR_complete() 	while(QUADSPI_0.SFMSR.B.BUSY)

void DisableWatchdog(void)
{
  SWT.SR.R = 0x0000c520; /* key */
  SWT.SR.R = 0x0000d928; /* key */
  SWT.CR.R = 0x8000010A; /* disable WEN */
}

void ConfigureModes(void)
/* --- Setup modes and behaviour in modes --- */
{   
    ME.MER.R = 0x000025FF;        /* Enable all modes                       */		
    ME.RUNPC[0].R = 0x000000FE;   /* Enable all peripherals in all run modes*/
		
    ME.STANDBY.R = 0x0000000f;      /* FIRC disabled                       */   
    
    /* Configure Low Power Peripheral Config Register1 to allow peripheral  */
    /*  to run in STANDBY mode (Used for API below)                         */		
    ME.LPPC[0].R  = 0x00002000;     

    /* Re-enter DRUN mode to update the clock configuration                 */
    ME.MCTL.R = 0x30005AF0;           /* DRUN Mode & Key                    */
    ME.MCTL.R = 0x3000A50F;           /* DRUN Mode & Key                    */
    while (ME.IS.B.I_MTC != 1) {}     /* Wait Until transition completed    */
    ME.IS.B.I_MTC = 1;                /* Clear flag                         */    
}

void ConfigureClocks(void)
{
	CGM.SC_DC[0].R = 0x83;
	CGM.SC_DC[1].R = 0x81;
	CGM.SC_DC[2].R = 0x81;
}

static uint16_t MCU_SetupPLLs(uint16_t freq0, uint16_t freq1);

int main(void) {
  volatile int i = 0;
  
  DisableWatchdog();
  ConfigureModes();
  
  RGM.DERD.B.D_SWT = 1;
  
  ConfigureClocks();
  MCU_SetupPLLs(MCU_MAXFREQ,MCU_MAXFREQ2);
  
	
  /* QSPI A
  */
  SIU.PCR[PF13].R = 0x70c;
  SIU.PCR[PF14].R = 0x70c;
  SIU.PCR[PF11].R = 0x70c;
  SIU.PCR[PF12].R = 0x70c;
  SIU.PCR[PF10].R = 0x70f;
  SIU.PCR[PF15].R = 0x600;
  /* QSPI B
   */
  SIU.PCR[PF6].R = 0x70c;
  SIU.PCR[PF5].R = 0x70c;
  SIU.PCR[PK1].R = 0x70c;
  SIU.PCR[PJ15].R = 0x70c;
  SIU.PCR[PJ13].R = 0x70f;
  SIU.PCR[PJ14].R = 0x600;
  
  CGM.AC3_SC.B.SELCTL = 2;
  CGM.AC3_DC.B.DIV0 = 0; 
  
  QUADSPI_0.MCR.R = 0x000f0010;
  
  *((uint32_t *)(0xFFFA0000 + 4)) = 0x4;
  QUADSPI_0.ACR.R = 0x00007feb;

  /* Loop forever */
  for (;;) {
    i++;
  }
}

static uint16_t MCU_SetupPLLs(uint16_t freq0, uint16_t freq1)
{
    if (freq0 > MCU_MAXFREQ) freq0 = MCU_MAXFREQ;
    if (freq0 < 16) freq0 = 16;
    if (freq1 > MCU_MAXFREQ) freq1 = MCU_MAXFREQ;
    if (freq1 < 16) freq1 = 16;

    ME.DRUN.B.FXOSCON=1;				/* Switch on external osc */
    ME.DRUN.B.SYSCLK=2;			       	/* Select external osc */
    
	/* RE enter the drun mode, to update the configuration */
    ME.MCTL.R = 0x30005AF0;        		/* Mode & Key */
    ME.MCTL.R = 0x3000A50F;        		/* Mode & Key inverted */
    while(ME.GS.B.S_FXOSC==0){;}		/* Wait for external osc to stabilize */
    while(ME.GS.B.S_MTRANS==1){;}      	/* Wait for mode entry to complete */
    while(ME.GS.B.S_CURRENTMODE!=3){;} 	/* Check DRUN mode has been entered */

	/* Max bus 64Mhz, VCO 256-512Mhz */
	/* Fpll = XTAL * NDIV / IDF / ODF = 64MHz */
	/* Fvco = XTAL * NDIV / IDF = 512MHz */

    if (freq0 >= 128)
    {
		freq0 = freq0/4;
		CGM.FMPLL[0].CR.B.IDF=0x0000; 	/* Divide by 1 */
		CGM.FMPLL[0].CR.B.ODF=0x0;		/* Divide by 2 */
		CGM.FMPLL[0].CR.B.NDIV=freq0; 	/* Loop divide by freq */
		freq0 = freq0*4;
    }
    else if (freq0 >= 64)
    {
		freq0 = freq0/2;
		CGM.FMPLL[0].CR.B.IDF=0x0000; 	/* Divide by 1 */
		CGM.FMPLL[0].CR.B.ODF=0x1;		/* Divide by 4 */
		CGM.FMPLL[0].CR.B.NDIV=freq0; 	/* Loop divide by freq */
		freq0 = freq0*2;
    }
    else

    if (freq0 >= 32)
    {
		CGM.FMPLL[0].CR.B.IDF=0x0000; 	/* Divide by 1 */
		CGM.FMPLL[0].CR.B.ODF=0x2;		/* Divide by 8 */
		CGM.FMPLL[0].CR.B.NDIV=freq0;	/* Loop divide by freq */
    }
    else if (freq0 >= 16)
    {
		CGM.FMPLL[0].CR.B.IDF=0x0000;	/* Divide by 1 */
		CGM.FMPLL[0].CR.B.ODF=0x3;		/* Divide by 16 */
		CGM.FMPLL[0].CR.B.NDIV=freq0*2;	/* Loop divide by freq*2 */
    }
    
	/* Max bus 64Mhz, VCO 256-512Mhz */
	/* Fpll = XTAL * NDIV / IDF / ODF = 64MHz */
	/* Fvco = XTAL * NDIV / IDF = 512MHz */

    if (freq1 >= 128)
    {
		freq1 = freq1/4;
		CGM.FMPLL[1].CR.B.IDF=0x0000; 	/* Divide by 1 */
		CGM.FMPLL[1].CR.B.ODF=0x0;		/* Divide by 2 */
		CGM.FMPLL[1].CR.B.NDIV=freq1; 	/* Loop divide by freq */
		freq1 = freq1*4;
    }
    else if (freq1 >= 64)
    {
		freq1 = freq1/2;
		CGM.FMPLL[1].CR.B.IDF=0x0000; 	/* Divide by 1 */
		CGM.FMPLL[1].CR.B.ODF=0x1;		/* Divide by 4 */
		CGM.FMPLL[1].CR.B.NDIV=freq1; 	/* Loop divide by freq */
		freq1 = freq1*2;
    }
    else if (freq1 >= 32)
    {
		CGM.FMPLL[1].CR.B.IDF=0x0000; 	/* Divide by 1 */
		CGM.FMPLL[1].CR.B.ODF=0x2;		/* Divide by 8 */
		CGM.FMPLL[1].CR.B.NDIV=freq1;	/* Loop divide by freq */
    }
    else if (freq1 >= 16)
    {
		CGM.FMPLL[1].CR.B.IDF=0x0000;	/* Divide by 1 */
		CGM.FMPLL[1].CR.B.ODF=0x3;		/* Divide by 16 */
		CGM.FMPLL[1].CR.B.NDIV=freq1*2;	/* Loop divide by freq*2 */
    }    	


    ME.DRUN.B.FMPLL0ON=1;     /* enable pll */
    ME.DRUN.B.FMPLL1ON=1;     /* enable pll */

	/* RE enter the drun mode, to update the configuration */
    ME.MCTL.R = 0x30005AF0;     	  		/* Mode & Key */
    ME.MCTL.R = 0x3000A50F;         		/* Mode & Key inverted */
    while(ME.GS.B.S_MTRANS==1){;}			/* Wait for mode entry to complete */
    while(ME.GS.B.S_CURRENTMODE!=0x3){;}	/* Check DRUN mode has been entered */

    while(CGM.FMPLL[0].CR.B.S_LOCK==0){;}

    ME.DRUN.B.SYSCLK=0x4;  					/* system clock is PLL */
    ME.MCTL.R = 0x30005AF0;     	  		/* Mode & Key */
    ME.MCTL.R = 0x3000A50F;         		/* Mode & Key inverted */
    while(ME.GS.B.S_MTRANS==1){;}		    /* Wait for mode entry to complete */
    while(ME.GS.B.S_CURRENTMODE!=0x3){;}	/* Check DRUN mode has been entered */

	/*	
		ME_GS Poll Global status register to get current system clock
   		fail if system clock is not pll
   		0000 16MHz internal RC oscillator
   		0001 divided 16MHz internal RC oscillator
   		0010 4MHz crystal oscillator
   		0011 divided 4MHz crystal oscillator
   		0100 system PLL
   		1111 system clock is disabled 
   	*/

    while(ME.GS.B.S_SYSCLK != 4){;} 		/* fail is stuck here	 */
    return freq0;
}