
MEMORY {

//  Internal SRAM 

    sram    	 : ORIGIN = 0x40000000, LENGTH = 0x51000
    stack_ram_z4 : org = 0x40051000, len = 0x4000
        
    cache_code: org = 0x4005D000,    LENGTH = 0x0FFF
    sw_reset_vector : org = (0x40000000+0x5F000-0x80),    LENGTH = 0x80
//  Internal Flash 

    flash_rcw	: ORIGIN = 0x00000000, LENGTH = 0x20
    int_flash	: ORIGIN = ., LENGTH = 0x27FFFF - 0x20
}

DEFAULTS {
    SRAM_SIZE = 2K
    heap_reserve = 4K
    stack_reserve = 16K
    }

//
// Program layout for running out of RAM.
//


SECTIONS
{
     /* align the IVPR on a 64K boundary */
     .xcptn    ALIGN(0x10000)            : {} > sram
     .isrvectbl ALIGN(0x1000): {} > sram
    
    .PPC.EMB.sdata0   ABS                          : > sram
    .PPC.EMB.sbss0    CLEAR ABS                    : > .

    .init       			           : { *(.init) } > sram
    .text  			                   : > .
    .vletext 				           : > .
    .syscall 				           : > .
    .secinfo 				           : > .
    .rodata 				           : > .
    .sdata2 				           : > .
    .fixaddr			 	           : > .
    .fixtype				           : > .
    .sdabase 	      ALIGN(16)                    : > .	
    .sdata 				           : > .
    .sbss 				           : > .
    .data 				           : > .
    .bd		      ALIGN(16)                    : {*(.bd)} > .
    .buf	                  	           : {*(.buf)} > .
    .bss 		  		           : > .    
    .heap             ALIGN(16) PAD(heap_reserve)  : > .	
    
    __SP_INIT      = ADDR(stack_ram_z4) + SIZEOF(stack_ram_z4);
    
    __IV_ADDR      = ADDR(.xcptn);
.sw_reset_vector_var : {} > sw_reset_vector	/* Variable to hold reset status*/

	.cache_code_array : {} > cache_code		/* Location of cache test code */

__SP_INIT      = ADDR(stack_ram_z4) + SIZEOF(stack_ram_z4)-4;
__SP_START_MEM        = ADDR(stack_ram_z4);
//__STACK_SIZE     = SIZEOF(stack_ram); 

/* Interrupt Handler Parameters */
//__IVPR = ADDR(.xptn_vectors);
__IV_ADDR = ADDR(.xcptn);


__CACHE_CODE = ADDR(.cache_code_array);
__CACHE_CODE_SIZE = SIZEOF(.cache_code_array);

__SW_Reset_Vector = ADDR(.sw_reset_vector_var);
/* Labels Used for Initialising SRAM ECC */
  _SRAM_SIZE=SRAM_SIZE;
  
      __ghs_ramstart  = MEMADDR(sram);
    __ghs_ramend    = MEMENDADDR(sram);
    __ghs_romstart  = MEMADDR(int_flash);
    __ghs_romend    = MEMENDADDR(int_flash);

}
