#**************************************************************************/
#* FILE NAME: GHS_MPC56xx_55xx_FLASH.ld    COPYRIGHT (c) Freescale 2008   */
#*                                                All Rights Reserved     */
#* DESCRIPTION:                                                           */
#* Generic single core FLASH linker file to be used for MPC5XXX devices   */
#=========================================================================*/
#*                                                                        */
#*========================================================================*/
#* REV      AUTHOR        DATE        DESCRIPTION OF CHANGE               */
#* ---   -----------    ----------    ---------------------               */
#* 0.1    R. Moran       10/12/2008    Initial Version                    */
#* 0.2    A.Robertson    08/10/2009    Leopard Version                    */
#**************************************************************************/
/*  **********************************************************************/
/*  *  THIS FILE IS ONLY INTENDED AS AN EXAMPLE CODE FOR THE 		 */
/*  *  JDP DEVICES AND HAS ONLY BEEN GIVEN A MIMIMUM LEVEL OF TEST.      */
/*  *  IT IS PROVIDED 'AS SEEN' WITH NO GUARANTEES AND NO PROMISE        */
/*  *  OF SUPPORT.  USE AT YOUR OWN RISK !!                              */
/*  **********************************************************************/

/*---------- MODIFY THIS SECTION FOR YOUR DEVICE -----------*/
DEFAULTS
{
    /* Define Flash Size */

     FLASH_SIZE = 0x280000
    /* Define Flash Boot Address */
//    FLASH_BASE_ADDR = 0x00FC0000
//    FLASH_BASE_ADDR = 0x00FC4000
//    FLASH_BASE_ADDR = 0x00FC8000
//    FLASH_BASE_ADDR = 0x00FCC000
//    FLASH_BASE_ADDR = 0x01000000
//    FLASH_BASE_ADDR = 0x01040000
//    FLASH_BASE_ADDR = 0x01080000
   FLASH_BASE_ADDR = 0x013C0000

    /* Define SRAM Size */
    SRAM_SIZE =  384K     // 384KB SRAM
    
    /* Define SRAM Base Address */
    CORE2_SRAM_ADDR = 0x40000000
    
    /* Stack located at end of SRAM       */

    /* Define Stack Size */
    STACK_SIZE = 4K       // 4KB Stack
}

/*---------- DO NOT MODIFY ANYTHING BELOW THIS POINT -------*/


MEMORY
{
    flash_rcw : org = FLASH_BASE_ADDR,   len = 0x20
    int_flash : org = FLASH_BASE_ADDR + 0x20, len = FLASH_SIZE-0x20
    int_sram  : org = CORE2_SRAM_ADDR,    len = 0x50000
     stack_ram : org = 0x40050000, len = 0xD000
    
    cache_code: org = 0x4005D000,    LENGTH = 0x0FFF
    sw_reset_vector : org = (0x40000000+0x5F000-0x80),    LENGTH = 0x80
}

SECTIONS
{
    .rcw              : {*(.rcw)}> flash_rcw
    .init	        :{*(.init)}> int_flash

    .text             : {} > .      /* BookE Code   */
    .vletext          : {} > .              /* VLE Code */

    .fixaddr          : {} > .              /* Required for         */
    .fixtype          : {} > .              /* compatibility with   */
    .secinfo          : {} > .              /* GHS provided startup */
    .syscall          : {} > .              /* code                 */
    .flash_data 	: {}>. 		
    .rodata  : {*(.rdata) *(.rodata)} > .   /* Read Only Data */
    .text_cached          : {} > .      

    .ROM.data   ROM(.data)       : {} > .   /* Store Initialised RAM Variables */
    .ROM.sdata  ROM(.sdata)      : {} > .   /* temporarily in Flash            */
 //   .ROM.isrvectbl  ROM(.isrvectbl)      : {} > .   /* ISR vector table            */
    
    .xcptn ALIGN(0x10000) : {} > .   /* Exception Vector Table (IVPR) - align 64K boundary */

    .data             : {} > int_sram       /* Initialised Data                */
    .sdata            : {} > .              /* Small Initialised Data (Area1)  */
 //   .bd		        ALIGN(16): {*(.bd)} > .
 //   .buf	        ALIGN(16): {*(.buf)} > .
 //   .array		ALIGN(16): {*(.array)} > .
    .bss              : {} > .              /* Uninitialised Data              */
    .sbss             : {} > .              /* Small Uninitialised Data (Area1)*/
    .sdata2           : {} > .              /* Small Initialised Constant Data */
    .sbss2            : {} > .              /* Small Uninitialised Data (Area2)*/

   // .isrvectbl    ALIGN(0x800)   : {} > .   /* ISR Vector Table - must be 2K aligned */

    .stack  ALIGN(4)  PAD(STACK_SIZE) : {} > stack_ram  /* Stack Area */
   
 .sw_reset_vector_var : {} > sw_reset_vector	/* Variable to hold reset status*/

	.cache_code_array : {} > cache_code		/* Location of cache test code */
/*------------------------------------------------------------*/
/*  Example of allocating section at absolute address         */
/*                                                            */
/*  .my_section 0x40001000 :{} > int_flash                    */
/*                                                            */
/*  Linker uses "0x40001000" address, rather than "int_flash" */
/*------------------------------------------------------------*/

/*-------- LABELS USED IN CODE -------------------------------*/

/* Stack Address Parameters */
__SP_INIT      = ADDR(stack_ram) + SIZEOF(stack_ram)-4;
__SP_START_MEM        = ADDR(stack_ram);
//__STACK_SIZE     = SIZEOF(stack_ram); 

/* Interrupt Handler Parameters */
//__IVPR = ADDR(.xptn_vectors);
__IV_ADDR = ADDR(.xcptn);


__CACHE_CODE = ADDR(.cache_code_array);
__CACHE_CODE_SIZE = SIZEOF(.cache_code_array);

__SW_Reset_Vector = ADDR(.sw_reset_vector_var);

/* Labels for Copying Initialised Data from Flash to RAM */
__DATA_SRAM_ADDR  = ADDR(.data);
__SDATA_SRAM_ADDR = ADDR(.sdata);
//__ISRVECTTBL_SRAM_ADDR  = ADDR(.isrvectbl);

__DATA_SIZE   = ((SIZEOF(.data) + SIZEOF(.sdata)));
__SDATA_SIZE  = SIZEOF(.sdata);
//__ISRVECTTBL_SIZE  = SIZEOF(.isrvectbl);

__DATA_ROM_ADDR  = ADDR(.ROM.data);
__SDATA_ROM_ADDR = ADDR(.ROM.sdata);
//__ISRVECTTBL_ROM_ADDR = ADDR(.ROM.isrvectbl);

/* Labels Used for Initialising SRAM ECC */
_SRAM_SIZE=SRAM_SIZE;
_CORE2_SRAM_ADDR = CORE2_SRAM_ADDR;


/* These special symbols mark the bounds of RAM and ROM memory. */
/* They are used by the MULTI debugger.                         */

    __ghs_ramstart  = MEMADDR(int_sram);
    __ghs_ramend    = MEMENDADDR(int_sram);
    __ghs_romstart  = MEMADDR(int_flash);
    __ghs_romend    = MEMENDADDR(int_flash);

    __ghs_rambootcodestart = 0;           /* zero for ROM image */
    __ghs_rambootcodeend = 0;             /* zero for ROM image */
    __ghs_rombootcodestart = MEMADDR(int_flash);
    __ghs_rombootcodeend = MEMENDADDR(int_flash);

}
