// --------------------------------------------------------------------------
// COPYRIGHT (c) Freescale 2009
// Freescale Confidential Proprietary
// All Rights Reserved
// --------------------------------------------------------------------------
//!\file    mpc5606s_main_flash.c
//!\brief   The main function which gives the control to thirdeye or the user defined test case.
//!\brief   It also handles the checks for reset and passes the control to previous running
//!\brief   test case if a reset inbetween a test case.
//
// TYPE: C Source File
// DEPARTMENT: MSG-IDC
// CREATED BY: Ankur Sharma  (B17102)
// --------------------------------------------------------------------------
// PURPOSE:  Main file sued for passing control to test cases
// --------------------------------------------------------------------------
// $Log: mpc57xx_main_flash.c.rca $
// 
//  Revision: 1.2 Wed May  9 07:42:44 2012 B17104
//  *** empty comment string ***
// 
//  Revision: 1.1 Mon May  7 07:26:21 2012 B17104
//  *** empty comment string ***
// 
//  Revision: 1.6 Wed Mar  7 03:26:33 2012 MadhusudanAggarwalFSL
//  *** empty comment string ***
// 
//  Revision: 1.5 Thu Mar  1 00:40:25 2012 AijazFatimaFSL
//  *** empty comment string ***
// 
//  Revision: 1.4 Thu Mar  1 00:34:32 2012 AijazFatimaFSL
//  *** empty comment string ***
// 
//  Revision: 1.3 Thu Mar  1 00:33:28 2012 AijazFatimaFSL
//  *** empty comment string ***
// 
//  Revision: 1.2 Wed Apr 27 02:06:40 2011 PankajKushwahaFSL
//  Added #ifdef THIRDEYE support
// 
//  Revision: 1.1 Tue Apr 19 04:09:54 2011 AijazFatimaFSL
//  Initial version

#include "common.h"
#include "serial.h"
#include "thirdeye.h"
void resume_previous_test();
uint32_t reset_status;
uint32_t swt_inst;




void main(void)
{
#ifdef THIRDEYE
	SET_PUT_API(sci_a_putchar);
	SET_GET_API(sci_a_getchar);
		thirdeye_main("Panther");
		start_running_tests();
#else
	test();
#endif
}


/**
 *\brief Function for resuming a previous test case 
 *
 *This function is used to pass the control back to a previous
 *running test case in case a reset is received inbetween the test case
 */
void resume_previous_test()
{
    uint32_t run_test;
    printf("resuming the previous test case after reset");
    run_test = get_int_value("test_case_num");
    printf("The test case number being executed after reset = %d",run_test);
    
    UIF_TEST_CASES[run_test].func();
    #if RESET_BETWEEN_TEST
	 software_reset_between_test();
    #else
	printf("TEST_FINISHED");
	start_running_tests();
    #endif	
}
