// --------------------------------------------------------------------------
// COPYRIGHT (c) Freescale 2009
// Freescale Confidential Proprietary
// All Rights Reserved
// --------------------------------------------------------------------------
//!\file    mpc57xx_main_sram.c
//!\brief   The main function which gives the control to thirdeye or the user defined test case.
//!\brief   It also handles the checks for reset and passes the control to previous running
//!\brief   test case if a reset inbetween a test case.
//
// TYPE: C Source File
// DEPARTMENT: MSG-IDC
// CREATED BY: Ankur Sharma  (B17102)
// --------------------------------------------------------------------------
// PURPOSE:  Main file sued for passing control to test cases
// --------------------------------------------------------------------------
// $Log: mpc57xx_main_sram.c.rca $
// 
//  Revision: 1.2 Wed May  9 07:43:14 2012 B17104
//  *** empty comment string ***
// 
//  Revision: 1.1 Mon May  7 07:26:09 2012 B17104
//  *** empty comment string ***
// 
//  Revision: 1.4 Thu Mar  1 00:40:21 2012 AijazFatimaFSL
//  *** empty comment string ***
// 
//  Revision: 1.3 Thu Mar  1 00:34:27 2012 AijazFatimaFSL
//  *** empty comment string ***
// 
//  Revision: 1.2 Wed Apr 27 02:06:50 2011 PankajKushwahaFSL
//  Added #ifdef THIRDEYE support
// 
//  Revision: 1.1 Tue Apr 19 04:09:49 2011 AijazFatimaFSL
//  Initial version

#include "common.h"
#include "serial.h"
#include "..\..\validation\eTimer\driver\inc\etimer_api.h"

void main(void)
{
  uint32_t frequency = 0, duty = 0;
  
  init_peripheral_eTimer();
	
  Change_mode(ME_DRUN,SYS_PL0, 160);
  MC_CGM.AC0_SC.R		= 0x02000000;
  MC_CGM.AC0_DC0.R 		= 0x80000000;

  //set clkout
  MC_CGM.AC6_SC.R		= 0x01000000;
  MC_CGM.AC6_DC0.R 		= 0x800A0000;
  SIUL2.MSCR[22].B.OBE	= 0x1;
  SIUL2.MSCR[22].B.SSS	= 0x1;	//B6 - on motherboard b9

  /*eTimer_CONFIG_PINS(0,0,DIRECTION_OUT,SLEWRATE_2);//A0
  eTimer_CONFIG_PINS(0,1,DIRECTION_OUT,SLEWRATE_3);//A1
  eTimer_CONFIG_PINS(0,2,DIRECTION_OUT,SLEWRATE_3);//A2
  eTimer_CONFIG_PINS(0,3,DIRECTION_OUT,SLEWRATE_3);//A3
  eTimer_CONFIG_PINS(0,4,DIRECTION_OUT,SLEWRATE_3);//A4
  eTimer_CONFIG_PINS(0,5,DIRECTION_OUT,SLEWRATE_3);//C12*/

  //Generate_Signal(0/*timer*/, 0 /*channel*/, 200/*Hz*/, 100/*%*10*/, 160000 /*kHz*/); //duty in [%]
  //Generate_Signal2( 0/*timer*/, 2, 1, 0, 1000/*ms*/, 1000/*ns*/, 160000/*kHz*/);
  //Generate_OneShot_signal_set(0/*timer*/,0/*channel*/,200/*delay [us]*/,20/*width [us]*/,160000/*motor clock [kHz]*/, LOW);
  //start_Generate_OneShot_signal(0/*timer*/,0/*channel*/);

  eTimer_CONFIG_PINS(0,0,DIRECTION_IN,SLEWRATE_2);//A0
  Measure_signal_parameters_set ( 0/*timer*/,0 /*channel*/);
  while(1)
  {
	asm("nop");
	asm("nop");
	asm("nop");
	start_Measure_signal_parameters ( 0/*timer*/,0 /*channel*/,  160000 /*motor_freq*/, &frequency /*frequency of signal [kHz]*/, &duty /*duty of signal [desetiny %]*/); 
  }
  
  while(1);
}
