// --------------------------------------------------------------------------
// COPYRIGHT (c) Freescale 2009
// Freescale Confidential Proprietary
// All Rights Reserved
// --------------------------------------------------------------------------
//!\file    io.c 
//!\brief   This file is used for called the getchar and putchar functions
//
// TYPE: C Source file
// DEPARTMENT: MSG-IDC
// CREATED BY: Ankur Sharma  (B17102)
// --------------------------------------------------------------------------
// PURPOSE:  Calling of getchar and putchar functions
// --------------------------------------------------------------------------
// $Log: io.c.rca $
// 
//  Revision: 1.1 Thu Mar  5 17:57:04 2009 AnkurSharmaFSL
//  Initial Check In 
// -------------------------------------------------------------------------

#include "common.h"

/**
 *\brief calling of getchar function
 *
 *Calls the getchar function to get the character received on serial port
 *\return The character received from the serial port
 */

unsigned char in_char (void)
{
	return sci_a_getchar();
}

/**
 *\brief calling of putchar function
 *
 *Calls the putchar function and passes the ch value for print
 *\param ch The character to be send through serial interface for print
 */
void out_char (char ch)
{
	sci_a_putchar(ch);
}

