#include "jdp_extended.h"
#include "jdp.h"
#include "test_config.h"

int8_t LINFLEX_0_WakeupReceived=0;
int16_t LINFLEX_0_ErrorReceived=0;

int16_t LINFLEX_0_Nb_of_ReceivedWakeup=0;

//int32_t TxResponseL = 0;
//int32_t TxResponseM = 0;

uint8_t ReceivedResponse1[64];
uint8_t *ReceivedResponse1_ptr = ReceivedResponse1;

void LINFLEX_LIN_Master_Init(vuint8_t LINFlex_Index, vuint16_t Baudrate)
{
	LINFlex_ConfigurePads(LINFlex_Index);

	LINFLEX(LINFlex_Index).LINCR1.B.SLEEP = 0; /* exit sleep mode */
	LINFLEX(LINFlex_Index).LINCR1.B.INIT = 1;  /* enter initialization mode */

	LINFLEX(LINFlex_Index).LINCR1.B.MME = 1;   /* Select Master mode */
	LINFLEX(LINFlex_Index).LINCR1.B.MBL = 3;   /* 13-bit break */
	LINFLEX(LINFlex_Index).LINCR1.B.LASE = 0;
	LINFLEX(LINFlex_Index).LINCR2.B.IOBE = 0;

	LINFLEX(LINFlex_Index).LINIER.B.HRIE = 1;  /* Header received interrupt enable */
	LINFLEX(LINFlex_Index).LINIER.B.DTIE = 1;  /* Data transmission interrupt enable */
	LINFLEX(LINFlex_Index).LINIER.B.DRIE = 1;  /* Data reception complete interrupt enable */
	LINFLEX(LINFlex_Index).LINIER.B.WUIE = 1;  /* Wake up interrupt enable */
	LINFLEX(LINFlex_Index).LINIER.B.FEIE = 1;  /* Framing error interrupt enable */
	LINFLEX(LINFlex_Index).LINIER.B.HEIE = 1;  /* Header error interrupt enable */
	LINFLEX(LINFlex_Index).LINIER.B.CEIE = 1;  /* Checksum error interrupt enable */
	LINFLEX(LINFlex_Index).LINIER.B.BEIE = 1;  /* Bit error interrupt enable */
	LINFLEX(LINFlex_Index).LINIER.B.OCIE = 1;  /* Output compare interrupt enable */
	LINFLEX(LINFlex_Index).LINIER.B.DBFIE = 1;  /* Data Buffer Full interrupt enable */
	LINFLEX(LINFlex_Index).LINIER.B.DBEIE = 1;  /* Data Buffer Empty interrupt enable */

	LINFLEX(LINFlex_Index).LINTCSR.B.MODE = 0; /* Select LIN timeout mode for 8-bit counter */
	LINFLEX(LINFlex_Index).LINTCSR.B.IOT = 0;

	LINFlex_ChangeBaudrate(LINFlex_Index, FREQ, Baudrate);

	LINFLEX(LINFlex_Index).LINCR1.B.INIT = 0;  /* enter normal mode */

	LINFLEX(LINFlex_Index).LINSR.R = 0xF23F;   /* Clear all flags */
}

void LINFLEX_LIN_Disable_WakeUp_Interrupt(vuint8_t LINFlex_Index)
{
	LINFLEX(LINFlex_Index).LINIER.B.WUIE = 0;  /* Wake up interrupt disable */
}

void LINFLEX_LIN_Enable_WakeUp_Interrupt(vuint8_t LINFlex_Index)
{
	LINFLEX(LINFlex_Index).LINSR.B.WUF = 1;    /* Clear wake up flag */
	LINFLEX(LINFlex_Index).LINIER.B.WUIE = 1;  /* to enable it again after discard response */
}

void LINFLEX_LIN_Master_Send_Frame (vuint8_t LINFlex_Index, int8_t DataFieldLength, int8_t ChecksumType, int8_t ProtectedIdentifier, uint8_t* Response)
{
	int32_t ResponseL = 0;
	int32_t ResponseM = 0;
	int8_t index, BufferLength;

	LINFLEX(LINFlex_Index).BIDR.B.ID = ProtectedIdentifier; /* Configure Protected Identifier */
	LINFLEX(LINFlex_Index).BIDR.B.DFL = DataFieldLength-1; /* Configure DFL in BIDR */
	LINFLEX(LINFlex_Index).BIDR.B.CCS = ChecksumType; /* Configure checksum type in BIDR */
	LINFLEX(LINFlex_Index).BIDR.B.DIR = 1; /* Set direction bit in BIDR */

	BufferLength = DataFieldLength;
	if (BufferLength>8) BufferLength=8;

	for (index=0;index<BufferLength;index++)
	{
		if (index<4) ResponseL += (*(Response+index))<<(8*index);
		else ResponseM += (*(Response+index))<<(8*(index-4));
	}

	/* Fill Buffer */
	LINFLEX(LINFlex_Index).BDRL.R = ResponseL;
	LINFLEX(LINFlex_Index).BDRM.R = ResponseM;

	LINFLEX(LINFlex_Index).LINCR2.B.HTRQ = 1; /* Trigger Frame transmission*/
}

void LINFLEX_LIN_Master_Receive_Frame (vuint8_t LINFlex_Index, int8_t DataFieldLength, int8_t ChecksumType, int8_t ProtectedIdentifier)
{
	LINFLEX(LINFlex_Index).BIDR.B.DFL = DataFieldLength-1;  /* Configure DFL in BIDR */

	LINFLEX(LINFlex_Index).BIDR.B.CCS = ChecksumType;       /* Configure checksum type in BIDR */
	LINFLEX(LINFlex_Index).BIDR.B.DIR = 0;                  /* Reset direction bit in BIDR */

	LINFLEX(LINFlex_Index).BIDR.B.ID = ProtectedIdentifier; /* Configure Protected Identifier */

	LINFLEX(LINFlex_Index).LINCR2.B.DDRQ = 0;               /* Receive Data */

	LINFLEX(LINFlex_Index).LINCR2.B.HTRQ = 1;               /* Trigger Frame transmission*/
}


void LINFLEX_LIN_Master_Send_Header (vuint8_t LINFlex_Index, int8_t ProtectedIdentifier)
{
	LINFLEX(LINFlex_Index).BIDR.B.ID = ProtectedIdentifier; /* Configure Protected Identifier */

	LINFLEX(LINFlex_Index).LINCR2.B.HTRQ = 1; /* Trigger Header transmission */
}


void LINFLEX_LIN_Master_Send_Response (vuint8_t LINFlex_Index, int8_t DataFieldLength, int8_t ChecksumType, uint8_t* Response)
{
	int32_t ResponseL = 0;
	int32_t ResponseM = 0;
	int8_t index;

	for (index=0;index<DataFieldLength;index++)
	{
		if (index<4) ResponseL += ( (int32_t) (*(Response+index)) ) << (8*index);
		else ResponseM += ( (int32_t) (*(Response+index)) ) << (8*(index-4));
	}

	/* Fill Buffer */
	LINFLEX(LINFlex_Index).BDRL.R = ResponseL;
	LINFLEX(LINFlex_Index).BDRM.R = ResponseM;

	LINFLEX(LINFlex_Index).BIDR.B.DFL = DataFieldLength-1; /* Configure DFL in BIDR */

	LINFLEX(LINFlex_Index).BIDR.B.CCS = ChecksumType; /* Configure checksum type in BIDR */
	LINFLEX(LINFlex_Index).BIDR.B.DIR = 1; /* Set direction bit in BIDR */

	LINFLEX(LINFlex_Index).LINCR2.B.DTRQ = 1; /* Trigger Response (data) transmission */
}

void LINFLEX_LIN_Master_Receive_Response (vuint8_t LINFlex_Index, int8_t DataFieldLength, int8_t ChecksumType)
{
	LINFLEX(LINFlex_Index).BIDR.B.DFL = DataFieldLength-1; /* Configure DFL in BIDR */
	LINFLEX(LINFlex_Index).BIDR.B.CCS = ChecksumType; /* Configure checksum type in BIDR */
	LINFLEX(LINFlex_Index).BIDR.B.DIR = 0; /* Reset direction bit in BIDR */
}

void LINFLEX_LIN_Master_Discard_Response(vuint8_t LINFlex_Index)
{
	LINFLEX_LIN_Disable_WakeUp_Interrupt(LINFlex_Index);
	LINFLEX(LINFlex_Index).BIDR.B.DIR = 0; /* Reset direction bit in BIDR */
	LINFLEX(LINFlex_Index).LINCR2.B.DDRQ = 1; /* Discard Response (data)*/
}

void LINFLEX_LIN_Master_Get_Response (vuint8_t LINFlex_Index, int8_t DataFieldLength, uint8_t* Response)
{
	int32_t ResponseL = 0;
	int32_t ResponseM = 0;
	int8_t index;

	ResponseL = LINFLEX(LINFlex_Index).BDRL.R;
	ResponseM = LINFLEX(LINFlex_Index).BDRM.R;

	for (index=0;index<DataFieldLength;index++)
	{
		if (index<4) *(Response+index) = (int8_t) ( ResponseL  >> (8*index) );
		else *(Response+index) = (int8_t) ( ResponseM >> (8*(index-4)) );
	}
}

void LINFLEX_LIN_Master_AbortFrame(vuint8_t LINFlex_Index)
{
	LINFLEX(LINFlex_Index).LINCR2.B.ABRQ = 1; /* Abort Frame */
}

void LINFLEX_LIN_Master_Refill_Buffer (vuint8_t LINFlex_Index, int8_t DataFieldLength, uint8_t* Response)
{
	int32_t ResponseL = 0;
	int32_t ResponseM = 0;
	int8_t index;

	for (index=0;index<DataFieldLength;index++)
	{
		if (index<4) ResponseL += ( (int32_t) (*(Response+index)) ) << (8*index);
		else ResponseM += ( (int32_t) (*(Response+index)) ) << (8*(index-4));
	}

	/* Fill Buffer */
	LINFLEX(LINFlex_Index).BDRL.R = ResponseL;
	LINFLEX(LINFlex_Index).BDRM.R = ResponseM;
}


/* LINFLEX RX interrupt service routine*/
void LINFLEX_LIN_Master_RX_ISR(vuint8_t LINFlex_Index)
{
	SIU.GPDO[0].R = 1;

	/* wake-up flag */
	if (LINFLEX(LINFlex_Index).LINSR.B.WUF)
	{
		LINFLEX_0_WakeupReceived = 1;
		LINFLEX_0_Nb_of_ReceivedWakeup++;
	}

	/* Data */
	if (LINFLEX(LINFlex_Index).LINSR.B.DRF)
	{
		LINFLEX_LIN_Master_Get_Response (LINFlex_Index, 8, ReceivedResponse1_ptr);
	}

	/* Extended Frame Data Received */
	if (LINFLEX(LINFlex_Index).LINSR.B.DBFF)
	{
		LINFLEX_LIN_Master_Get_Response (LINFlex_Index, 8, ReceivedResponse1_ptr);
		ReceivedResponse1_ptr = ReceivedResponse1_ptr + 8;
	}

	/* Clear all flags */
	LINFLEX(LINFlex_Index).LINSR.R = 0xF23F;

	SIU.GPDO[0].R = 0;
}

/* LINFLEX ERR interrupt service routine*/
void LINFLEX_LIN_Master_ERR_ISR(vuint8_t LINFlex_Index)
{
  SIU.GPDO[3].R = 1;

	/* LIN error*/
	if (LINFLEX(LINFlex_Index).LINESR.R)
	{
		LINFLEX_0_ErrorReceived |= LINFLEX(LINFlex_Index).LINESR.R;
	}

	/* Clear all flags */
	LINFLEX(LINFlex_Index).LINESR.R = 0xFF81;

	SIU.GPDO[3].R = 0;
}

/* LINFLEX TX interrupt service routine*/
void LINFLEX_LIN_Master_TX_ISR(vuint8_t LINFlex_Index)
{
	SIU.GPDO[1].R = 1;

 	if (LINFLEX(LINFlex_Index).LINSR.B.DTF)
	{
		/* Do Nothing */
	}

	if (LINFLEX(LINFlex_Index).LINSR.B.DBEF)
	{
		uint8_t MasterResponseToBeSent[8];
		static uint8_t i = 1;

		MasterResponseToBeSent[0] = 'a' + i;
		MasterResponseToBeSent[1] = 'b' + i;
		MasterResponseToBeSent[2] = 'c' + i;
		MasterResponseToBeSent[3] = 'd' + i;
		MasterResponseToBeSent[4] = 'e' + i;
		MasterResponseToBeSent[5] = 'f' + i;
		MasterResponseToBeSent[6] = 'g' + i;
		MasterResponseToBeSent[7] = 'h' + i;

		i++;

		LINFLEX_LIN_Master_Refill_Buffer (LINFlex_Index, 8, MasterResponseToBeSent);
	}

	/* Clear all flags */
	LINFLEX(LINFlex_Index).LINSR.R = 0xF23F;

	SIU.GPDO[1].R = 0;
}
